/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GLRptSubLedgerCondition
extends GLRptAsstactBaseCondition {
    private static final long serialVersionUID = -2943986714111269687L;
    public static final int TYPE_ASST = 0;
    public static final int TYPE_USERPROP = 1;
    public static final int TYPE_ASST_USERPROP = 2;
    private boolean showAccountAttribute = false;
    private boolean showDailyTotal = false;
    private boolean showOppAccount = false;
    private boolean showOppAsstact = false;
    private boolean showDisplayAsstDetail = false;
    private boolean noDisplayZeroTotal = false;
    private boolean sumByAsstact = false;
    private boolean groupVoucher = false;
    private boolean groupVoucherByAccount = false;
    private int groupVoucherAccLevel;
    private boolean groupVoucherZeroNotShow = false;
    private AccountViewCollection accounts;
    private boolean acctAndAsst = false;
    private Map<String, String> bizAccountVirtualAccountMap = null;
    private boolean isNoAmountShow = false;

    public GLRptSubLedgerCondition() {
    }

    public GLRptSubLedgerCondition(ReportConditionBase base) {
        super(base);
        if (base instanceof GLRptSubLedgerCondition) {
            GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)base;
            this.setShowOppAccount(cond.isShowOppAccount());
            this.setShowOppAsstact(cond.isShowOppAsstact());
            this.setShowDailyTotal(cond.isShowDailyTotal());
            this.setShowAccountAttribute(cond.isShowAccountAttribute());
            this.setShowDisplayAsstDetail(cond.isShowDisplayAsstDetail());
            this.setNoDisplayZeroTotal(cond.isNoDisplayZeroTotal());
            this.setGroupVoucher(cond.isGroupVoucher());
            this.setGroupVoucherByAccount(cond.isGroupVoucherByAccount());
            this.setGroupVoucherAccLevel(cond.getGroupVoucherAccLevel());
            this.setGroupVoucherZeroNotShow(cond.isGroupVoucherZeroNotShow());
            this.setSumByAsstact(cond.isSumByAsstact());
            this.setNoAmountShow(cond.isNoAmountShow());
        }
    }

    public GLRptSubLedgerCondition(Map map) throws CloneNotSupportedException {
        super(map);
        if (map.get("optionNotIncludePLVoucher") != null) {
            this.setNotIncluePLVoucher((Boolean)map.get("optionNotIncludePLVoucher"));
        }
        this.setShowOppAccount(this.getBoolean((Boolean)map.get("OptionOppAccount")));
        this.setShowOppAsstact(this.getBoolean((Boolean)map.get("OptionOppAsstact")));
        this.setShowDailyTotal(this.getBoolean((Boolean)map.get("OptionDailyTotal")));
        this.setShowAccountAttribute(this.getBoolean((Boolean)map.get("optionShowAccountCusAttribute")));
        this.setShowDisplayAsstDetail(this.getBoolean((Boolean)map.get("OptionOnlyAsst")));
        this.setNoDisplayZeroTotal(this.getBoolean((Boolean)map.get("noDisplayZeroTotal")));
        this.setGroupVoucher(this.getBoolean((Boolean)map.get("groupVoucher")));
        this.setGroupVoucherByAccount(this.getBoolean((Boolean)map.get("groupVoucherByAccount")));
        this.setGroupVoucherAccLevel(this.getInt((Integer)map.get("groupVoucherAccLevel")));
        this.setGroupVoucherZeroNotShow(this.getBoolean((Boolean)map.get("groupVoucherZeroNotShow")));
        this.setSumByAsstact(this.getBoolean((Boolean)map.get("sumByAsstact")));
        this.setNoAmountShow(this.getBoolean((Boolean)map.get("isNoAmountShow")));
    }

    @Override
    public Map toMap() {
        Map map = super.toMap();
        map.put("OptionOppAccount", this.isShowOppAccount());
        map.put("OptionOppAsstact", this.isShowOppAsstact());
        map.put("OptionDailyTotal", this.isShowDailyTotal());
        map.put("optionShowAccountCusAttribute", this.isShowAccountAttribute());
        map.put("OptionOnlyAsst", this.isShowDisplayAsstDetail());
        map.put("noDisplayZeroTotal", this.isNoDisplayZeroTotal());
        map.put("groupVoucher", this.isGroupVoucher());
        map.put("groupVoucherByAccount", this.isGroupVoucherByAccount());
        map.put("groupVoucherAccLevel", this.getGroupVoucherAccLevel());
        map.put("groupVoucherZeroNotShow", this.isGroupVoucherZeroNotShow());
        map.put("sumByAsstact", this.isSumByAsstact());
        map.put("isNoAmountShow", this.isNoAmountShow());
        return map;
    }

    public boolean isQty() throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        boolean isQtyAsst = this.getRptParams().isQtyAsst();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", this.getAccountIdSet(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isQty", (Object)new Integer(1)));
        if (isQtyAsst) {
            filter.getFilterItems().add(new FilterItemInfo("CAA.id", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CAA.isQty", (Object)new Integer(1)));
            filter.setMaskString("#0 AND #1 AND (#2 OR (#3 AND #4))");
        } else {
            filter.setMaskString("#0 AND #1");
        }
        view.setFilter(filter);
        if (this.ctx == null) {
            return !AccountViewFactory.getRemoteInstance().getAccountViewCollection(view).isEmpty();
        }
        return !AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewCollection(view).isEmpty();
    }

    @Override
    public String getCompanyIdsStr() throws BOSException {
        if (this.companyIdsStr == null) {
            Set idSet = null;
            try {
                idSet = !this.getCompany().isIsBizUnit() && this.getRptParams().isUseGL053 ? this.getCompanyIdsWithGL053() : this.getCompanyIds();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            if (idSet == null) {
                idSet = new HashSet();
            }
            this.companyIdsStr = this.genCompanyIdsStr(idSet);
        }
        return this.companyIdsStr;
    }

    public boolean isShowAccountAttribute() {
        return this.showAccountAttribute;
    }

    public void setShowAccountAttribute(boolean showAccountAttribute) {
        this.showAccountAttribute = showAccountAttribute;
    }

    public boolean isShowDailyTotal() {
        return this.showDailyTotal;
    }

    public void setShowDailyTotal(boolean showDailyTotal) {
        this.showDailyTotal = showDailyTotal;
    }

    public boolean isShowOppAccount() {
        return this.showOppAccount;
    }

    public void setShowOppAccount(boolean showOtherAccount) {
        this.showOppAccount = showOtherAccount;
    }

    public boolean isShowOppAsstact() {
        return this.isShowOppAccount() && this.showOppAsstact;
    }

    public void setShowOppAsstact(boolean showOppAsstact) {
        this.showOppAsstact = showOppAsstact;
    }

    public boolean isShowDisplayAsstDetail() {
        return this.showDisplayAsstDetail;
    }

    public void setShowDisplayAsstDetail(boolean showDisplayAsstDetail) {
        this.showDisplayAsstDetail = showDisplayAsstDetail;
    }

    public boolean queryVoucherAssistRecordField() {
        return this.isShowDisplayAsstDetail() || this.isShowAccountAttribute();
    }

    public boolean isNoDisplayZeroTotal() {
        return this.noDisplayZeroTotal;
    }

    public void setNoDisplayZeroTotal(boolean noDisplayZeroTotal) {
        this.noDisplayZeroTotal = noDisplayZeroTotal;
    }

    public boolean isGroupVoucher() {
        return this.groupVoucher && !this.isShowOppAccount();
    }

    public void setGroupVoucher(boolean groupVoucher) {
        this.groupVoucher = groupVoucher;
    }

    public boolean isGroupVoucherByAccount() {
        return this.groupVoucherByAccount;
    }

    public void setGroupVoucherByAccount(boolean groupVoucherByAccount) {
        this.groupVoucherByAccount = groupVoucherByAccount;
    }

    public int getGroupVoucherAccLevel() {
        return this.groupVoucherAccLevel;
    }

    public void setGroupVoucherAccLevel(int groupVoucherAccLevel) {
        this.groupVoucherAccLevel = groupVoucherAccLevel;
    }

    public boolean isGroupVoucherZeroNotShow() {
        return this.groupVoucherZeroNotShow;
    }

    public void setGroupVoucherZeroNotShow(boolean groupVoucherZeroNotShow) {
        this.groupVoucherZeroNotShow = groupVoucherZeroNotShow;
    }

    public boolean isNoAmountShow() {
        return this.isNoAmountShow;
    }

    public void setNoAmountShow(boolean noAmountShow) {
        this.isNoAmountShow = noAmountShow;
    }

    public Set<String> getAccountIds(int type, boolean reverse) {
        HashSet<String> accountIds = new HashSet<String>();
        if (this.accounts != null) {
            block5: for (int i = 0; i < this.accounts.size(); ++i) {
                AccountViewInfo account = this.accounts.get(i);
                switch (type) {
                    case 0: {
                        if (reverse) {
                            if (account.getCAA() != null) continue block5;
                            accountIds.add(account.getId().toString());
                            continue block5;
                        }
                        if (account.getCAA() == null) continue block5;
                        accountIds.add(account.getId().toString());
                        continue block5;
                    }
                    case 1: {
                        if (reverse) {
                            if (account.isHasUserProperty()) continue block5;
                            accountIds.add(account.getId().toString());
                            continue block5;
                        }
                        if (!account.isHasUserProperty()) continue block5;
                        accountIds.add(account.getId().toString());
                        continue block5;
                    }
                    case 2: {
                        if (reverse) {
                            if (account.getCAA() != null || account.isHasUserProperty()) continue block5;
                            accountIds.add(account.getId().toString());
                            continue block5;
                        }
                        if (account.getCAA() == null && !account.isHasUserProperty()) continue block5;
                        accountIds.add(account.getId().toString());
                    }
                }
            }
        }
        return accountIds;
    }

    public AccountViewCollection getAccounts() {
        return this.accounts;
    }

    public void setAccounts(AccountViewCollection accounts) {
        this.accounts = accounts;
    }

    public void setSumByAsstact(boolean sumByAsstact) {
        this.sumByAsstact = sumByAsstact;
    }

    public boolean isSumByAsstact() {
        return this.sumByAsstact;
    }

    public void setAcctAndAsst(boolean acctAndAsst) {
        this.acctAndAsst = acctAndAsst;
    }

    public boolean isAcctAndAsst() {
        return this.acctAndAsst;
    }

    public Map<String, String> getBizAccountVirtualAccountMap() {
        return this.bizAccountVirtualAccountMap;
    }

    public void setBizAccountVirtualAccountMap(Map<String, String> bizAccountVirtualAccountMap) {
        this.bizAccountVirtualAccountMap = bizAccountVirtualAccountMap;
    }

    @Override
    protected String genAccountIdsStr() throws BOSException {
        if (this.getAccountIdSet().size() > 500) {
            String accountTempTable = GLRptDaoUtil.createIdTempTable((Context)this.ctx, this.getAccountIdSet());
            return "SELECT fid from " + accountTempTable;
        }
        StringBuffer accountIds = new StringBuffer();
        Set<String> accountIdSet = this.getAccountIdSet();
        if (accountIdSet.isEmpty()) {
            return "''";
        }
        if (this.getCompanys() != null && this.getCompanys().length > 1 || this.getProfitCenters() != null && this.getProfitCenters().length > 1) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", accountIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            AccountViewCollection accts = AccountViewFactory.getLocalInstance((Context)this.getCtx()).getAccountViewCollection(view);
            HashSet<String> acctNumSet = new HashSet<String>();
            for (int i = 0; i < accts.size(); ++i) {
                acctNumSet.add(accts.get(i).getNumber());
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", acctNumSet, CompareType.INCLUDE));
            String companyId = this.getCompanyId();
            if (null == companyId) {
                companyId = this.getCompany().getId().toString();
            }
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyId));
            view.setFilter(filter);
            accts = AccountViewFactory.getLocalInstance((Context)this.getCtx()).getAccountViewCollection(view);
            accountIdSet = new HashSet<String>();
            for (int i = 0; i < accts.size(); ++i) {
                accountIdSet.add((String)accts.get(i).getId());
            }
        }
        if (accountIdSet.isEmpty()) {
            return "''";
        }
        Iterator<String> it = accountIdSet.iterator();
        accountIds.append("'").append((Object)it.next()).append("'");
        while (it.hasNext()) {
            accountIds.append(",'").append((Object)it.next()).append("'");
        }
        return accountIds.toString();
    }
}

