/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.client.GLRptExcelExporter;
import java.util.ArrayList;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;

public class AcctCussentCheckExporter
extends GLRptExcelExporter {
    private Map<String, Object> acctCussentCondition;

    public AcctCussentCheckExporter(Map<String, Object> acctCussentCondition, Map<String, Object> params) {
        super(null, params);
        this.acctCussentCondition = acctCussentCondition;
    }

    @Override
    protected boolean isTotal(GLRptRowSet data) throws BOSException {
        boolean isTotal = false;
        isTotal = data.getInt("FLineType") == 9;
        return isTotal;
    }

    @Override
    protected int createRptHead(HSSFWorkbook wb, HSSFSheet sheet) {
        int rowIndex = 0;
        HSSFRow row = sheet.createRow(rowIndex++);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue((RichTextString)new HSSFRichTextString((String)this.params.get("accountInfo")));
        CellRangeAddress rang = new CellRangeAddress(0, 0, 0, 1);
        sheet.addMergedRegion(rang);
        cell = row.createCell(2);
        cell.setCellValue((RichTextString)new HSSFRichTextString((String)this.params.get("currencyInfo")));
        rang = new CellRangeAddress(0, 0, 2, 3);
        sheet.addMergedRegion(rang);
        cell = row.createCell(4);
        cell.setCellValue((RichTextString)new HSSFRichTextString((String)this.params.get("bookDateInfo")));
        boolean showBizNum = Boolean.valueOf(this.acctCussentCondition.get("showBizNum").toString());
        ArrayList itemTypes = (ArrayList)this.acctCussentCondition.get("itemtypes");
        rang = showBizNum ? new CellRangeAddress(0, 0, 4, 6) : new CellRangeAddress(0, 0, 4, 5);
        sheet.addMergedRegion(rang);
        CompanyDisplayModeEnum companyDisplayModeEnum = (CompanyDisplayModeEnum)((Object)this.acctCussentCondition.get("companyDisplayModeEnum"));
        if (companyDisplayModeEnum == CompanyDisplayModeEnum.enumerate) {
            if (showBizNum) {
                cell = row.createCell(7);
                rang = new CellRangeAddress(0, 0, 7, 8 + itemTypes.size());
            } else {
                cell = row.createCell(6);
                rang = new CellRangeAddress(0, 0, 6, 6 + itemTypes.size());
            }
            cell.setCellValue((RichTextString)new HSSFRichTextString(this.acctCussentCondition.get("company").toString()));
            sheet.addMergedRegion(rang);
        }
        return rowIndex;
    }

    @Override
    protected void setCellValueAndStyle(GLRptTableHeadInfo.GLRptTableColumnInfo col, HSSFCell cell, GLRptRowSet data, boolean isTotal) throws BOSException {
        String colName = col.getColName();
        Object value = data.getObject(colName);
        HSSFCellStyle style = null;
        if (colName.equals("FLocalExchangeRate")) {
            int localExRatePre = col.getScale();
            if (Boolean.valueOf(this.acctCussentCondition.get("isAllCurrency").toString()).booleanValue()) {
                localExRatePre = data.getInt("FRptExRatePre");
            }
            style = this.getNumericStyle(isTotal, localExRatePre);
            this.setCellDoubleValue(cell, value);
        } else if (colName.equals("FReportingExchangeRate")) {
            int rptExRatePre = col.getScale();
            if (Boolean.valueOf(this.acctCussentCondition.get("isAllCurrency").toString()).booleanValue()) {
                rptExRatePre = data.getInt("FRptExRatePre");
            }
            style = this.getNumericStyle(isTotal, rptExRatePre);
            this.setCellDoubleValue(cell, value);
        } else if (col.isNumeral()) {
            cell.setCellType(CellType.NUMERIC);
            int precision = col.getScale();
            if (Boolean.valueOf(this.acctCussentCondition.get("isAllCurrency").toString()).booleanValue() && colName.endsWith("For")) {
                precision = data.getInt("currencyPre");
            }
            style = this.getNumericStyle(isTotal, precision);
            this.setCellDoubleValue(cell, value);
        } else {
            style = this.getCommStyle(isTotal);
            if (value != null) {
                cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
            } else {
                cell.setCellValue((RichTextString)new HSSFRichTextString(""));
            }
            style.setDataFormat(this.dataFormat.getFormat("@"));
        }
        cell.setCellStyle(style);
    }

    @Override
    protected String getFileName() {
        return "acctCussentCheckTmp.xls";
    }
}

