/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.ImportCompayFieldsEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.client.AbstractFilterForAssistF7UI;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class FilterForAssistF7UI
extends AbstractFilterForAssistF7UI {
    private static final Logger logger = CoreUIObject.getLogger(FilterForAssistF7UI.class);
    private boolean isCancel = true;
    private ArrayList<AssistViewFilterInfo> allAssistList = null;
    private Set selectedAssists;
    private List<String> selectedAssistIds;
    private int defaultHeight = 0;
    private String queryPK;
    private Integer isBasic;
    private EntityViewInfo hashView;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblAllAssist.checkParsed();
        this.tblSelectedAssist.checkParsed();
        this.tblAllAssist.getStyleAttributes().setLocked(true);
        this.tblSelectedAssist.getStyleAttributes().setLocked(true);
        this.tblAllAssist.getSelectManager().setSelectMode(10);
        this.tblSelectedAssist.getSelectManager().setSelectMode(10);
        this.getParamFromUIContext();
        this.loadAllAssist();
        this.loadSelectedAssist();
        this.kDComboBox1.addItem((Object)ImportCompayFieldsEnum.NUMBER);
        this.kDComboBox1.addItem((Object)ImportCompayFieldsEnum.NAME);
    }

    public void initListener() {
        this.tblAllAssist.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 1) {
                    FilterForAssistF7UI.this.tblAllAssist.showCellDetailInfo();
                } else if (e.getClickCount() >= 2) {
                    FilterForAssistF7UI.this.moveToRight();
                }
            }
        });
        this.tblSelectedAssist.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 1) {
                    FilterForAssistF7UI.this.tblSelectedAssist.showCellDetailInfo();
                } else if (e.getClickCount() >= 2) {
                    FilterForAssistF7UI.this.moveToLeft();
                }
            }
        });
        this.queryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FilterForAssistF7UI.this.doQuerying();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void moveToRight() {
        ArrayList<AssistViewFilterInfo> selectedList = this.getSelectedList(this.tblAllAssist);
        this.addSelectedAssist(this.tblSelectedAssist, selectedList);
        this.tblAllAssist.getSelectManager().removeAll();
    }

    private void moveToLeft() {
        ArrayList<AssistViewFilterInfo> selectedList = this.getSelectedList(this.tblSelectedAssist);
        this.addSelectedAssist(this.tblAllAssist, selectedList);
        this.tblSelectedAssist.getSelectManager().removeAll();
    }

    private ArrayList<AssistViewFilterInfo> getSelectedList(KDTable srcTable) {
        ArrayList<AssistViewFilterInfo> selectedList = new ArrayList<AssistViewFilterInfo>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)srcTable);
        if (srcTable.getSelectManager().getActiveRowIndex() < 0) {
            return selectedList;
        }
        boolean isAllTab = "tblAllAssist".equals(srcTable.getName());
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = srcTable.getRow(selectRows[i] - (isAllTab ? 0 : i));
            if (row.getStyleAttributes().isHided()) continue;
            selectedList.add((AssistViewFilterInfo)row.getCell("idSet").getUserObject());
            if (isAllTab) {
                srcTable.getRow(selectRows[i]).getStyleAttributes().setHided(true);
                continue;
            }
            srcTable.removeRow(selectRows[i] - i);
        }
        return selectedList;
    }

    private void addSelectedAssist(KDTable destTable, ArrayList<AssistViewFilterInfo> selectedList) {
        for (int i = 0; i < selectedList.size(); ++i) {
            AssistViewFilterInfo acctFilterInfo = selectedList.get(i);
            String id = (String)acctFilterInfo.getIdSet().iterator().next();
            if ("tblSelectedAssist".equals(destTable.getName())) {
                if (!this.selectedAssistIds.contains(id)) {
                    this.selectedAssistIds.add(id);
                }
                this.loadRowData(acctFilterInfo);
                continue;
            }
            int rowCount = this.tblAllAssist.getRowCount();
            for (int j = 0; j < rowCount; ++j) {
                IRow row = this.tblAllAssist.getRow(j);
                AssistViewFilterInfo assFilterInfo = (AssistViewFilterInfo)row.getCell("idSet").getUserObject();
                if (!acctFilterInfo.getNumber().equals(assFilterInfo.getNumber())) continue;
                row.getStyleAttributes().setHided(false);
            }
            if (!this.selectedAssistIds.contains(id)) continue;
            this.selectedAssistIds.remove(this.selectedAssistIds.indexOf(id));
        }
    }

    private void loadAllAssistToTbl(KDTable destTable) throws EASBizException, BOSException, SQLException {
        boolean isMoveAllToLeft = destTable.getName().equals("tblAllAssist");
        if (isMoveAllToLeft) {
            this.tblSelectedAssist.removeRows();
            this.selectedAssistIds.clear();
        }
        ArrayList<String> suitableAssistNumList = new ArrayList<String>();
        if (isMoveAllToLeft) {
            if (this.kDComboBox1.getSelectedItem() != null) {
                String value = this.kDTextField1.getText();
                boolean isBlurred = this.fuzzyQuery.isSelected();
                String fieldStr = null;
                int field = ((ImportCompayFieldsEnum)this.kDComboBox1.getSelectedItem()).getValue();
                switch (field) {
                    case 1: {
                        fieldStr = "number";
                        break;
                    }
                    case 2: {
                        fieldStr = "name";
                    }
                }
                if (!StringUtils.isEmpty((String)value)) {
                    String[] values = value.split(";");
                    for (int i = 0; i < this.allAssistList.size(); ++i) {
                        String tableValue;
                        AssistViewFilterInfo item = this.allAssistList.get(i);
                        String string = tableValue = "number".equals(fieldStr) ? item.getNumber() : item.getName();
                        if (!this.isContains(tableValue, values, isBlurred)) continue;
                        suitableAssistNumList.add(tableValue);
                    }
                }
            }
            this.setRowHideForAllTbl(suitableAssistNumList);
        } else {
            HashSet<String> existSelected = new HashSet<String>();
            int count = this.tblSelectedAssist.getRowCount();
            for (int i = 0; i < count; ++i) {
                existSelected.add(this.tblSelectedAssist.getRow(i).getCell("number").getValue().toString());
            }
            int rowCount = this.tblAllAssist.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblAllAssist.getRow(i);
                AssistViewFilterInfo assFilterInfo = (AssistViewFilterInfo)row.getCell("idSet").getUserObject();
                boolean isExist = existSelected.contains(assFilterInfo.getNumber());
                if (!isExist && !row.getStyleAttributes().isHided()) {
                    String id = (String)assFilterInfo.getIdSet().iterator().next();
                    if (!this.selectedAssistIds.contains(id)) {
                        this.selectedAssistIds.add(id);
                    }
                    IRow newRow = destTable.addRow();
                    newRow.getCell("idSet").setValue((Object)assFilterInfo.getIdSet());
                    newRow.getCell("number").setValue((Object)assFilterInfo.getNumber());
                    newRow.getCell("name").setValue((Object)assFilterInfo.getName());
                    newRow.getCell("idSet").setUserObject((Object)assFilterInfo);
                }
                row.getStyleAttributes().setHided(true);
            }
        }
    }

    private void loadRowData(AssistViewFilterInfo acctFilterInfo) {
        int rowIndex = this.tblSelectedAssist.getRowCount();
        for (int i = 0; i < this.tblSelectedAssist.getRowCount(); ++i) {
            String number = (String)this.tblSelectedAssist.getRow(i).getCell("number").getValue();
            if (number.compareTo(acctFilterInfo.getNumber()) <= 0) continue;
            rowIndex = i;
            break;
        }
        IRow row = this.tblSelectedAssist.addRow(rowIndex);
        row.getCell("idSet").setValue((Object)acctFilterInfo.getIdSet());
        row.getCell("number").setValue((Object)acctFilterInfo.getNumber());
        row.getCell("name").setValue((Object)acctFilterInfo.getName());
        row.getCell("idSet").setUserObject((Object)acctFilterInfo);
    }

    private void setRowHideForAllTbl(List<String> assistNumList) {
        int rowCount = this.allAssistList.size();
        if (assistNumList.isEmpty()) {
            for (int i = 0; i < rowCount; ++i) {
                this.tblAllAssist.getRow(i).getStyleAttributes().setHided(false);
            }
        } else {
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblAllAssist.getRow(i);
                AssistViewFilterInfo assFilterInfo = (AssistViewFilterInfo)row.getCell("idSet").getUserObject();
                row.getStyleAttributes().setHided(!assistNumList.contains(assFilterInfo.getNumber()));
            }
        }
    }

    private void doQuerying() throws Exception {
        String value = this.kDTextField1.getText();
        boolean isBlurred = this.fuzzyQuery.isSelected();
        String fieldStr = null;
        int field = ((ImportCompayFieldsEnum)this.kDComboBox1.getSelectedItem()).getValue();
        switch (field) {
            case 1: {
                fieldStr = "number";
                break;
            }
            case 2: {
                fieldStr = "name";
            }
        }
        int rowCount = this.tblAllAssist.getRowCount();
        if (StringUtils.isEmpty((String)value)) {
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblAllAssist.getRow(i);
                String id = (String)((AssistViewFilterInfo)row.getCell("idSet").getUserObject()).getIdSet().iterator().next();
                row.getStyleAttributes().setHided(this.selectedAssistIds.contains(id));
            }
        } else {
            String[] values = value.split(";");
            if (this.defaultHeight == 0 && rowCount > 0) {
                this.defaultHeight = this.tblAllAssist.getRow(0).getHeight();
            }
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblAllAssist.getRow(i);
                String tableValue = row.getCell(fieldStr).getValue().toString();
                String id = (String)((AssistViewFilterInfo)row.getCell("idSet").getUserObject()).getIdSet().iterator().next();
                if (this.isContains(tableValue, values, isBlurred) && !this.selectedAssistIds.contains(id)) {
                    row.setHeight(this.defaultHeight);
                    row.getStyleAttributes().setHided(false);
                    continue;
                }
                row.getStyleAttributes().setHided(true);
            }
        }
    }

    private boolean isContains(String tableValue, String[] values, boolean isBlurred) {
        boolean isContains = false;
        for (String value : values) {
            if (isBlurred) {
                if (!tableValue.contains(value.trim())) continue;
                isContains = true;
                break;
            }
            if (!tableValue.equals(value.trim())) continue;
            isContains = true;
            break;
        }
        return isContains;
    }

    private void getParamFromUIContext() {
        this.selectedAssists = (Set)this.getUIContext().get("selectedAssists");
        this.queryPK = (String)this.getUIContext().get("queryPK");
        this.hashView = (EntityViewInfo)this.getUIContext().get("hashView");
        this.isBasic = (Integer)this.getUIContext().get("isBasic");
    }

    private void loadAllAssist() throws SQLException, BOSException {
        this.allAssistList = this.getAllAssistList();
        for (int i = 0; i < this.allAssistList.size(); ++i) {
            AssistViewFilterInfo asstFilterInfo = this.allAssistList.get(i);
            IRow row = this.tblAllAssist.addRow(i);
            row.getCell("idSet").setValue((Object)asstFilterInfo.getIdSet());
            row.getCell("number").setValue((Object)asstFilterInfo.getNumber());
            row.getCell("name").setValue((Object)asstFilterInfo.getName());
            row.getCell("idSet").setUserObject((Object)asstFilterInfo);
        }
    }

    private void loadSelectedAssist() {
        this.selectedAssistIds = new ArrayList<String>(this.selectedAssists.size());
        if (this.selectedAssists.isEmpty()) {
            return;
        }
        int rowCount = this.tblAllAssist.getRowCount();
        block0: for (AssistViewFilterInfo acct : this.selectedAssists) {
            Set idSet = acct.getIdSet();
            for (String assistId : idSet) {
                this.selectedAssistIds.add(assistId);
                for (int i = 0; i < rowCount; ++i) {
                    IRow row = this.tblAllAssist.getRow(i);
                    AssistViewFilterInfo acctFilterInfo = (AssistViewFilterInfo)row.getCell("idSet").getUserObject();
                    if (!acctFilterInfo.getIdSet().contains(assistId)) continue;
                    this.tblAllAssist.getRow(i).getStyleAttributes().setHided(true);
                    this.loadRowData(acctFilterInfo);
                    continue block0;
                }
            }
        }
    }

    private ArrayList<AssistViewFilterInfo> getAllAssistList() throws BOSException, SQLException {
        if (this.allAssistList == null) {
            this.allAssistList = new ArrayList();
            this.queryPK = this.queryPK.replaceAll("\\\\", ".");
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(this.queryPK));
            exec.setObjectView(this.hashView);
            String sql = exec.getSQL();
            sql = this.checkIsBasic(sql);
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
            AssistViewFilterInfo v = null;
            HashSet<String> idSet = null;
            HashSet<String> existIds = new HashSet<String>();
            while (rs.next()) {
                String id = rs.getString("id");
                if (existIds.contains(id)) continue;
                idSet = new HashSet<String>();
                idSet.add(id);
                v = new AssistViewFilterInfo(idSet, rs.getString("number"), rs.getString("name"));
                this.allAssistList.add(v);
                existIds.add(id);
            }
        }
        return this.allAssistList;
    }

    private String checkIsBasic(String sql) {
        if (8 == this.isBasic) {
            return sql;
        }
        String basicString = null;
        String newBasicString = null;
        if (this.isBasic == 0) {
            basicString = "\"CUSTOMERGROUPSTANDARD\".FIsBasic = 1";
            newBasicString = "\"CUSTOMERGROUPSTANDARD\".FIsBasic = 0";
            if (sql.contains(basicString)) {
                sql = sql.replace(basicString, newBasicString);
            }
        } else if (this.isBasic == 5) {
            basicString = "\"SUPPLIERGROUPSTANDARD\".FIsBasic = 1";
            newBasicString = "\"SUPPLIERGROUPSTANDARD\".FIsBasic = 0";
            if (sql.contains(basicString)) {
                sql = sql.replace(basicString, newBasicString);
            }
        } else {
            if (this.isBasic == 2) {
                return sql;
            }
            if (this.isBasic == 3) {
                return sql;
            }
            if (this.isBasic == 4) {
                return sql;
            }
        }
        return sql;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.loadAllAssistToTbl(this.tblSelectedAssist);
    }

    @Override
    protected void btnSelect_actionPerformed(ActionEvent e) throws Exception {
        this.moveToRight();
    }

    @Override
    protected void btnUnSelect_actionPerformed(ActionEvent e) throws Exception {
        this.moveToLeft();
    }

    @Override
    protected void btnUnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.loadAllAssistToTbl(this.tblAllAssist);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.selectedAssists = new HashSet();
        if (this.tblSelectedAssist.getRowCount() > 0) {
            for (int i = 0; i < this.tblSelectedAssist.getRowCount(); ++i) {
                IRow row = this.tblSelectedAssist.getRow(i);
                this.selectedAssists.add(row.getCell("idSet").getUserObject());
            }
        } else {
            this.selectedAssists = new HashSet();
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void kDComboBox2_actionPerformed(ActionEvent e) throws Exception {
        super.kDComboBox2_actionPerformed(e);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public Set getData() {
        return this.selectedAssists != null && this.selectedAssists.isEmpty() ? null : this.selectedAssists;
    }
}

