/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.WSVoucherFactory;
import com.kingdee.eas.fi.gl.ZipUtils;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptBaseExporter;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptExportBaseUI;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class GLNRptAccountBalanceExporter
extends GLNRptBaseExporter {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptAccountBalanceExporter.class);
    protected int MAX_SIZE = 1000000;
    protected boolean showByDispatchDc = false;
    protected boolean showByAccountDc = false;
    protected boolean showCompanyNameByLevel = false;
    protected boolean showAccountNameByLevel = false;
    protected boolean showAsstActNameByLevel = false;
    protected boolean sheetByOrg = false;
    protected String placeholder = "";
    protected int companyTopLevel = 1;
    protected int levelAatIdx = 0;
    protected String levelAatColName = null;
    protected Map<String, Integer> colIndexs = new HashMap<String, Integer>();
    protected Map<String, XSSFCellStyle> numeralFormats = new HashMap<String, XSSFCellStyle>();
    protected XSSFCellStyle sumCommonStyle = null;
    protected XSSFCellStyle textStyle = null;
    protected XSSFCellStyle sumTextStyle = null;
    protected List<String> colNames = null;
    protected List<String> colAliass = null;
    protected List<String> allCols = null;
    protected List<String> commonCols;
    protected List<String> asstActCols;
    protected List<String> yearBeginCols;
    protected List<String> beginCols;
    protected List<String> cols;
    protected List<String> pnlCols;
    protected List<String> yearCols;
    protected List<String> yearPnlCols;
    protected List<String> endCols;
    protected SXSSFWorkbook wb = null;
    protected XSSFCellStyle style = null;
    protected Sheet sheet = null;
    protected int sheetIndex = 1;
    protected String lastOrgNumber;

    public GLNRptAccountBalanceExporter(GLNRptExportBaseUI nRptUI, Map<String, String> config) {
        super(nRptUI, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.info("***************************************************************************");
        String path = (String)this.config.get("file");
        if (path == null || path.trim().length() == 0) {
            this.error(this.getResource("chooseFileLocation"));
            return;
        }
        File file = new File(path);
        if (file.isDirectory()) {
            path = file.getAbsolutePath() + File.separator + (String)this.config.get("rptType") + ".xlsx";
        } else if (!file.exists()) {
            File parent = file.getParentFile();
            if (parent == null || !parent.isDirectory()) {
                this.error(this.getResource("fileNotFound"));
                return;
            }
            path = file.getAbsolutePath();
            if (!path.toLowerCase(Locale.ENGLISH).endsWith(".xlsx")) {
                path = path + ".xlsx";
            }
        }
        try {
            List rows;
            List errs;
            Map result;
            List sqls;
            this.info(this.getResource("beginQuery"));
            if (!this.beforeExecute()) {
                return;
            }
            long start = System.currentTimeMillis();
            Map<String, Object> params = this.buildParams();
            String jsonParams = JSON.toJSONString(params);
            if ("true".equals(this.config.get("showRequest"))) {
                this.info("params\uff1a" + jsonParams);
            }
            String jsonResult = WSVoucherFactory.getRemoteInstance().nGetBalance(jsonParams, false);
            this.info(this.getResource("endQueryAndCost") + (System.currentTimeMillis() - start) + "ms");
            if ("true".equals(this.config.get("isCompress"))) {
                jsonResult = ZipUtils.gunzip(jsonResult);
            }
            if ("true".equals(this.config.get("showRequest"))) {
                this.info("result\uff1a" + (jsonResult.length() > 100000 ? jsonResult.substring(0, 100000) : jsonResult));
            }
            if ((sqls = (List)(result = (Map)JSON.parseObject((String)jsonResult, Map.class)).get("sqls")) != null) {
                for (Object sql : sqls) {
                    this.info(sql.toString());
                }
            }
            if ((errs = (List)result.get("errs")) != null) {
                for (Object msg : errs) {
                    this.error(msg.toString());
                }
            }
            if ((rows = (List)result.get("rows")) != null && rows.size() > 0) {
                long bStart = System.currentTimeMillis();
                this.info(this.getResource("generateFile"));
                this.buildExcel(result, rows, path);
                this.info(this.getResource("endGenerateFileAndCost") + (System.currentTimeMillis() - bStart) + "ms");
            }
            this.info(this.getResource("endOperateAndCost") + (System.currentTimeMillis() - start) + "ms\n");
            if (rows != null && rows.size() > 0) {
                GLNRptAccountBalanceExporter.open(new File(path));
            }
        }
        catch (Exception e) {
            this.error(e);
        }
        finally {
            this.afterExecute();
        }
    }

    protected Map<String, Object> buildParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rptType", "AccountBalance");
        params.put("dataMode", "byBatch");
        params.put("companyNumber", this.config.get("companyNumber"));
        params.put("companyDisplayMode", this.config.get("companyDisplayMode"));
        params.put("companyLevel", this.config.get("companyLevel"));
        params.put("orgTreeId", this.config.get("orgTreeId"));
        params.put("unionNumber", this.config.get("unionNumber"));
        params.put("sumByUnion", this.config.get("sumByUnion"));
        params.put("periodTypeNumber", this.config.get("periodTypeNumber"));
        params.put("fromPeriodNumber", this.config.get("fromPeriodNumber"));
        params.put("toPeriodNumber", this.config.get("toPeriodNumber"));
        params.put("currencyNumber", this.config.get("currencyNumber"));
        params.put("balType", "true".equals(this.config.get("balType")) ? "1" : "5");
        params.put("notIncludePLVoucher", this.config.get("notIncludePLVoucher"));
        params.put("balanceDc", this.config.get("balanceDc"));
        params.put("accountTableNumber", this.config.get("accountTableNumber"));
        params.put("fromAccountLevel", this.config.get("fromAccountLevel"));
        params.put("toAccountLevel", this.config.get("toAccountLevel"));
        params.put("showOnlyLeafAccount", this.config.get("showOnlyLeafAccount"));
        params.put("fromAccountNumber", this.config.get("fromAccountNumber"));
        params.put("toAccountNumber", this.config.get("toAccountNumber"));
        params.put("accountNumber", this.config.get("accountNumber"));
        List asstActTypes = new ArrayList();
        String strAsstActTypes = (String)this.config.get("asstActTypes");
        if (strAsstActTypes != null) {
            asstActTypes = (List)JSON.parseObject((String)strAsstActTypes, List.class);
        }
        params.put("asstActTypes", asstActTypes);
        params.put("showAsstDetail", this.config.get("showAsstDetail"));
        params.put("notShowZero", this.config.get("notShowZero"));
        params.put("notShowNoCurrent", this.config.get("notShowNoCurrent"));
        params.put("notShowZeroAndNoCurrent", this.config.get("notShowZeroAndNoCurrent"));
        params.put("notShowNoYear", this.config.get("notShowNoYear"));
        params.put("notShowZeroAndNoYear", this.config.get("notShowZeroAndNoYear"));
        params.put("showFor", this.config.get("showFor"));
        params.put("showLocal", this.config.get("showLocal"));
        params.put("showRpt", this.config.get("showRpt"));
        params.put("showYear", this.config.get("showYear"));
        params.put("showSumRow", this.config.get("showSumRow"));
        params.put("showQty", this.config.get("showQty"));
        params.put("showByStandardMU", this.config.get("showByStandardMU"));
        params.put("showByDispatchDc", this.config.get("showByDispatchDc"));
        params.put("sumByDispatchDc", this.config.get("sumByDispatchDc"));
        params.put("showByAccountDc", this.config.get("showByAccountDc"));
        params.put("showCompanyLongNumber", this.config.get("showCompanyLongNumber"));
        params.put("showCompanyLevel", this.config.get("showCompanyLevel"));
        Object param = this.config.get("showCompanyNameByLevel");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            params.put("showCompanyLevel", "true");
        }
        params.put("showCompanyName", this.config.get("showCompanyName"));
        params.put("showCompanyBizUnit", this.config.get("showCompanyBizUnit"));
        params.put("showAccountName", this.config.get("showAccountName"));
        params.put("showAccountLongName", this.config.get("showAccountLongName"));
        params.put("showAccountLevel", this.config.get("showAccountLevel"));
        param = this.config.get("showAccountNameByLevel");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            params.put("showAccountLevel", "true");
        }
        params.put("showAccountDc", this.config.get("showAccountDc"));
        param = this.config.get("showByAccountDc");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            params.put("showAccountDc", "true");
        }
        params.put("showCurrencyNumber", this.config.get("showCurrencyNumber"));
        params.put("showCurrencyName", this.config.get("showCurrencyName"));
        params.put("showAsstActName", this.config.get("showAsstActName"));
        params.put("showAsstActLongName", this.config.get("showAsstActLongName"));
        params.put("showAsstActNumber", this.config.get("showAsstActNumber"));
        params.put("isCompress", this.config.get("isCompress"));
        params.put("updateBalance", this.config.get("updateBalance"));
        params.put("threadCount", this.config.get("threadCount"));
        if (this.config.get("extendKeys") != null) {
            Set extendKeys = (Set)JSON.parseObject((String)((String)this.config.get("extendKeys")), Set.class);
            for (String key : extendKeys) {
                if (!this.config.containsKey(key)) continue;
                params.put(key, this.config.get(key));
            }
        }
        return params;
    }

    @Override
    protected String getSheetName() {
        return this.getResource("accountBalance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildExcel(Map result, List values, String fileName) {
        this.init(result, values);
        OutputStream os = null;
        try {
            this.buildWorkbook(result, values);
            os = new FileOutputStream(fileName);
            this.wb.write(os);
            os.flush();
        }
        catch (Throwable e) {
            this.error(e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void init(Map result, List<List<String>> values) {
        Object param = this.config.get("showByDispatchDc");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showByDispatchDc = true;
        }
        if ((param = this.config.get("showByAccountDc")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showByAccountDc = true;
        }
        if ((param = this.config.get("showCompanyNameByLevel")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCompanyNameByLevel = true;
        }
        if ((param = this.config.get("showAccountNameByLevel")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAccountNameByLevel = true;
        }
        if ((param = this.config.get("showAsstActNameByLevel")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActNameByLevel = true;
        }
        this.sheetByOrg = (param = this.config.get("sheetByOrg")) != null && param.toString().trim().equals("true");
        param = this.config.get("MAX_SIZE");
        if (param != null && param.toString().trim().length() > 0) {
            this.MAX_SIZE = Integer.parseInt(param.toString().trim());
        }
        if ((param = this.config.get("placeholder")) != null && param.toString().trim().length() > 0) {
            this.placeholder = param.toString().trim();
            if (this.placeholder.startsWith("$")) {
                this.placeholder = this.placeholder.substring(1);
            }
            if (this.placeholder.endsWith("$")) {
                this.placeholder = this.placeholder.substring(0, this.placeholder.length() - 1);
            }
        }
        if (result.containsKey("companyTopLevel") && (param = result.get("companyTopLevel")) != null) {
            if (param instanceof Integer) {
                this.companyTopLevel = (Integer)param;
            } else if (param.toString().length() > 0) {
                try {
                    this.companyTopLevel = Integer.parseInt(param.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (result.containsKey("levelAatIdx") && (param = result.get("levelAatIdx")) != null) {
            if (param instanceof Integer) {
                this.levelAatIdx = (Integer)param;
            } else if (param.toString().length() > 0) {
                try {
                    this.levelAatIdx = Integer.parseInt(param.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.levelAatIdx > 0) {
                this.levelAatColName = "asstActName" + this.levelAatIdx;
            }
        }
        this.colNames = values.get(0);
        this.colAliass = values.get(1);
        this.commonCols = new ArrayList<String>();
        this.asstActCols = new ArrayList<String>();
        for (int i = 0; i < this.colNames.size(); ++i) {
            String colName = this.colNames.get(i);
            this.colIndexs.put(colName, i);
            if (colName.endsWith("For") || colName.endsWith("Local") || colName.endsWith("Rpt") || colName.endsWith("Qty")) continue;
            if ("companyLevel".equals(colName)) {
                if (!"true".equals(this.config.get("showCompanyLevel"))) {
                    continue;
                }
            } else if ("accountLevel".equals(colName)) {
                if (!"true".equals(this.config.get("showAccountLevel"))) {
                    continue;
                }
            } else if (!"accountDc".equals(colName) ? colName.startsWith("asstActLevel") && !"true".equals(this.config.get("showAsstActLevel")) : !"true".equals(this.config.get("showAccountDc"))) continue;
            if (colName.startsWith("asstActName") && this.getClass() == GLNRptAccountBalanceExporter.class) {
                this.asstActCols.add(colName);
                continue;
            }
            if (colName.equals("assistGrpId") || colName.endsWith("Precision") || colName.endsWith("isTotal")) continue;
            this.commonCols.add(colName);
        }
        this.yearBeginCols = new ArrayList<String>();
        if (this.showByDispatchDc) {
            if (this.colIndexs.containsKey("yearBeginDebitQty")) {
                this.yearBeginCols.add("yearBeginDebitQty");
            }
            if (this.colIndexs.containsKey("yearBeginBalanceDebitFor")) {
                this.yearBeginCols.add("yearBeginBalanceDebitFor");
            }
            if (this.colIndexs.containsKey("yearBeginBalanceDebitLocal")) {
                this.yearBeginCols.add("yearBeginBalanceDebitLocal");
            }
            if (this.colIndexs.containsKey("yearBeginBalanceDebitRpt")) {
                this.yearBeginCols.add("yearBeginBalanceDebitRpt");
            }
            if (this.colIndexs.containsKey("yearBeginCreditQty")) {
                this.yearBeginCols.add("yearBeginCreditQty");
            }
            if (this.colIndexs.containsKey("yearBeginBalanceCreditFor")) {
                this.yearBeginCols.add("yearBeginBalanceCreditFor");
            }
            if (this.colIndexs.containsKey("yearBeginBalanceCreditLocal")) {
                this.yearBeginCols.add("yearBeginBalanceCreditLocal");
            }
            if (this.colIndexs.containsKey("yearBeginBalanceCreditRpt")) {
                this.yearBeginCols.add("yearBeginBalanceCreditRpt");
            }
        } else {
            if (this.colIndexs.containsKey("yearBeginQty")) {
                this.yearBeginCols.add("yearBeginQty");
            }
            if (this.colIndexs.containsKey("yearBeginBalanceFor")) {
                this.yearBeginCols.add("yearBeginBalanceFor");
            }
            if (this.colIndexs.containsKey("yearBeginBalanceLocal")) {
                this.yearBeginCols.add("yearBeginBalanceLocal");
            }
            if (this.colIndexs.containsKey("yearBeginBalanceRpt")) {
                this.yearBeginCols.add("yearBeginBalanceRpt");
            }
        }
        this.beginCols = new ArrayList<String>();
        if (this.showByDispatchDc) {
            if (this.colIndexs.containsKey("beginDebitQty")) {
                this.beginCols.add("beginDebitQty");
            }
            if (this.colIndexs.containsKey("beginBalanceDebitFor")) {
                this.beginCols.add("beginBalanceDebitFor");
            }
            if (this.colIndexs.containsKey("beginBalanceDebitLocal")) {
                this.beginCols.add("beginBalanceDebitLocal");
            }
            if (this.colIndexs.containsKey("beginBalanceDebitRpt")) {
                this.beginCols.add("beginBalanceDebitRpt");
            }
            if (this.colIndexs.containsKey("beginCreditQty")) {
                this.beginCols.add("beginCreditQty");
            }
            if (this.colIndexs.containsKey("beginBalanceCreditFor")) {
                this.beginCols.add("beginBalanceCreditFor");
            }
            if (this.colIndexs.containsKey("beginBalanceCreditLocal")) {
                this.beginCols.add("beginBalanceCreditLocal");
            }
            if (this.colIndexs.containsKey("beginBalanceCreditRpt")) {
                this.beginCols.add("beginBalanceCreditRpt");
            }
        } else {
            if (this.colIndexs.containsKey("beginQty")) {
                this.beginCols.add("beginQty");
            }
            if (this.colIndexs.containsKey("beginBalanceFor")) {
                this.beginCols.add("beginBalanceFor");
            }
            if (this.colIndexs.containsKey("beginBalanceLocal")) {
                this.beginCols.add("beginBalanceLocal");
            }
            if (this.colIndexs.containsKey("beginBalanceRpt")) {
                this.beginCols.add("beginBalanceRpt");
            }
        }
        this.cols = new ArrayList<String>();
        if (this.colIndexs.containsKey("debitQty")) {
            this.cols.add("debitQty");
        }
        if (this.colIndexs.containsKey("debitFor")) {
            this.cols.add("debitFor");
        }
        if (this.colIndexs.containsKey("debitLocal")) {
            this.cols.add("debitLocal");
        }
        if (this.colIndexs.containsKey("debitRpt")) {
            this.cols.add("debitRpt");
        }
        if (this.colIndexs.containsKey("creditQty")) {
            this.cols.add("creditQty");
        }
        if (this.colIndexs.containsKey("creditFor")) {
            this.cols.add("creditFor");
        }
        if (this.colIndexs.containsKey("creditLocal")) {
            this.cols.add("creditLocal");
        }
        if (this.colIndexs.containsKey("creditRpt")) {
            this.cols.add("creditRpt");
        }
        this.pnlCols = new ArrayList<String>();
        if (this.showByDispatchDc) {
            if (this.colIndexs.containsKey("monthPnlDebitQty")) {
                this.pnlCols.add("monthPnlDebitQty");
            }
            if (this.colIndexs.containsKey("monthPnlDebitFor")) {
                this.pnlCols.add("monthPnlDebitFor");
            }
            if (this.colIndexs.containsKey("monthPnlDebitLocal")) {
                this.pnlCols.add("monthPnlDebitLocal");
            }
            if (this.colIndexs.containsKey("monthPnlDebitRpt")) {
                this.pnlCols.add("monthPnlDebitRpt");
            }
            if (this.colIndexs.containsKey("monthPnlCreditQty")) {
                this.pnlCols.add("monthPnlCreditQty");
            }
            if (this.colIndexs.containsKey("monthPnlCreditFor")) {
                this.pnlCols.add("monthPnlCreditFor");
            }
            if (this.colIndexs.containsKey("monthPnlCreditLocal")) {
                this.pnlCols.add("monthPnlCreditLocal");
            }
            if (this.colIndexs.containsKey("monthPnlCreditRpt")) {
                this.pnlCols.add("monthPnlCreditRpt");
            }
        } else {
            if (this.colIndexs.containsKey("monthPnlQty")) {
                this.pnlCols.add("monthPnlQty");
            }
            if (this.colIndexs.containsKey("monthPnlFor")) {
                this.pnlCols.add("monthPnlFor");
            }
            if (this.colIndexs.containsKey("monthPnlLocal")) {
                this.pnlCols.add("monthPnlLocal");
            }
            if (this.colIndexs.containsKey("monthPnlRpt")) {
                this.pnlCols.add("monthPnlRpt");
            }
        }
        this.yearCols = new ArrayList<String>();
        if (this.colIndexs.containsKey("yearDebitQty")) {
            this.yearCols.add("yearDebitQty");
        }
        if (this.colIndexs.containsKey("yearDebitFor")) {
            this.yearCols.add("yearDebitFor");
        }
        if (this.colIndexs.containsKey("yearDebitLocal")) {
            this.yearCols.add("yearDebitLocal");
        }
        if (this.colIndexs.containsKey("yearDebitRpt")) {
            this.yearCols.add("yearDebitRpt");
        }
        if (this.colIndexs.containsKey("yearCreditQty")) {
            this.yearCols.add("yearCreditQty");
        }
        if (this.colIndexs.containsKey("yearCreditFor")) {
            this.yearCols.add("yearCreditFor");
        }
        if (this.colIndexs.containsKey("yearCreditLocal")) {
            this.yearCols.add("yearCreditLocal");
        }
        if (this.colIndexs.containsKey("yearCreditRpt")) {
            this.yearCols.add("yearCreditRpt");
        }
        this.yearPnlCols = new ArrayList<String>();
        if (this.showByDispatchDc) {
            if (this.colIndexs.containsKey("yearPnlDebitQty")) {
                this.yearPnlCols.add("yearPnlDebitQty");
            }
            if (this.colIndexs.containsKey("yearPnlDebitFor")) {
                this.yearPnlCols.add("yearPnlDebitFor");
            }
            if (this.colIndexs.containsKey("yearPnlDebitLocal")) {
                this.yearPnlCols.add("yearPnlDebitLocal");
            }
            if (this.colIndexs.containsKey("yearPnlDebitRpt")) {
                this.yearPnlCols.add("yearPnlDebitRpt");
            }
            if (this.colIndexs.containsKey("yearPnlCreditQty")) {
                this.yearPnlCols.add("yearPnlCreditQty");
            }
            if (this.colIndexs.containsKey("yearPnlCreditFor")) {
                this.yearPnlCols.add("yearPnlCreditFor");
            }
            if (this.colIndexs.containsKey("yearPnlCreditLocal")) {
                this.yearPnlCols.add("yearPnlCreditLocal");
            }
            if (this.colIndexs.containsKey("yearPnlCreditRpt")) {
                this.yearPnlCols.add("yearPnlCreditRpt");
            }
        } else {
            if (this.colIndexs.containsKey("yearPnlQty")) {
                this.yearPnlCols.add("yearPnlQty");
            }
            if (this.colIndexs.containsKey("yearPnlFor")) {
                this.yearPnlCols.add("yearPnlFor");
            }
            if (this.colIndexs.containsKey("yearPnlLocal")) {
                this.yearPnlCols.add("yearPnlLocal");
            }
            if (this.colIndexs.containsKey("yearPnlRpt")) {
                this.yearPnlCols.add("yearPnlRpt");
            }
        }
        this.endCols = new ArrayList<String>();
        if (this.showByDispatchDc) {
            if (this.colIndexs.containsKey("endDebitQty")) {
                this.endCols.add("endDebitQty");
            }
            if (this.colIndexs.containsKey("endBalanceDebitFor")) {
                this.endCols.add("endBalanceDebitFor");
            }
            if (this.colIndexs.containsKey("endBalanceDebitLocal")) {
                this.endCols.add("endBalanceDebitLocal");
            }
            if (this.colIndexs.containsKey("endBalanceDebitRpt")) {
                this.endCols.add("endBalanceDebitRpt");
            }
            if (this.colIndexs.containsKey("endCreditQty")) {
                this.endCols.add("endCreditQty");
            }
            if (this.colIndexs.containsKey("endBalanceCreditFor")) {
                this.endCols.add("endBalanceCreditFor");
            }
            if (this.colIndexs.containsKey("endBalanceCreditLocal")) {
                this.endCols.add("endBalanceCreditLocal");
            }
            if (this.colIndexs.containsKey("endBalanceCreditRpt")) {
                this.endCols.add("endBalanceCreditRpt");
            }
        } else {
            if (this.colIndexs.containsKey("endQty")) {
                this.endCols.add("endQty");
            }
            if (this.colIndexs.containsKey("endBalanceFor")) {
                this.endCols.add("endBalanceFor");
            }
            if (this.colIndexs.containsKey("endBalanceLocal")) {
                this.endCols.add("endBalanceLocal");
            }
            if (this.colIndexs.containsKey("endBalanceRpt")) {
                this.endCols.add("endBalanceRpt");
            }
        }
        this.allCols = new ArrayList<String>();
        this.allCols.addAll(this.commonCols);
        this.allCols.addAll(this.asstActCols);
        this.allCols.addAll(this.yearBeginCols);
        this.allCols.addAll(this.beginCols);
        this.allCols.addAll(this.cols);
        this.allCols.addAll(this.pnlCols);
        this.allCols.addAll(this.yearCols);
        this.allCols.addAll(this.yearPnlCols);
        this.allCols.addAll(this.endCols);
    }

    protected XSSFCellStyle getCellStyle(SXSSFWorkbook wb, Color bgcolor, Color borderColor) {
        XSSFCellStyle cellStyle = (XSSFCellStyle)wb.createCellStyle();
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        if (borderColor != null) {
            XSSFColor xssfColor = new XSSFColor(borderColor);
            cellStyle.setBottomBorderColor(xssfColor);
            cellStyle.setTopBorderColor(xssfColor);
            cellStyle.setLeftBorderColor(xssfColor);
            cellStyle.setRightBorderColor(xssfColor);
        }
        cellStyle.setFillForegroundColor(new XSSFColor(bgcolor));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setHidden(false);
        return cellStyle;
    }

    public void buildWorkbook(Map result, List<List<String>> values) {
        this.wb = new SXSSFWorkbook();
        this.style = this.getCellStyle(this.wb, new Color(201, 222, 240), null);
        Font font = this.wb.createFont();
        font.setBold(true);
        this.style.setAlignment(HorizontalAlignment.CENTER);
        this.style.setVerticalAlignment(VerticalAlignment.CENTER);
        this.style.setFont(font);
        Color borderColor = new Color(218, 220, 221);
        this.sumCommonStyle = this.getCellStyle(this.wb, new Color(252, 251, 223), borderColor);
        DataFormat format = this.wb.createDataFormat();
        short fmt = format.getFormat("@");
        this.textStyle = this.getCellStyle(this.wb, Color.WHITE, borderColor);
        this.textStyle.setDataFormat(fmt);
        this.sumTextStyle = this.getCellStyle(this.wb, new Color(252, 251, 223), borderColor);
        this.sumTextStyle.setDataFormat(fmt);
        this.lastOrgNumber = null;
        String companyNumber = null;
        if (this.sheetByOrg) {
            List<String> item = values.get(2);
            this.lastOrgNumber = companyNumber = item.get(this.colIndexs.get("companyNumber"));
        }
        this.sheet = this.wb.createSheet(companyNumber == null ? this.getSheetName() : companyNumber);
        this.buildHead();
        int beginIndex = this.buildBatch(values, true, 2);
        List batchNames = (List)result.get("batchNames");
        if (batchNames != null && batchNames.size() > 0) {
            for (String batchName : batchNames) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("rptType", "getBatch");
                params.put("batchName", batchName);
                params.put("isCompress", "true");
                String jsonParams = JSON.toJSONString(params);
                try {
                    List rows;
                    this.info(this.getResource("batchQuery") + batchName);
                    String jsonResult = WSVoucherFactory.getRemoteInstance().nGetBalance(jsonParams, false);
                    Map r = (Map)JSON.parseObject((String)(jsonResult = ZipUtils.gunzip(jsonResult)), Map.class);
                    if (r == null || (rows = (List)r.get("rows")) == null || rows.size() <= 0) continue;
                    beginIndex = this.buildBatch(rows, false, beginIndex);
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }
    }

    protected void buildHead() {
        Integer width;
        Cell cell1;
        Cell cell0;
        String colAlias;
        Map<String, Integer> widths = this.getWidths();
        Row row0 = this.sheet.createRow(0);
        Row row1 = this.sheet.createRow(1);
        for (int i = 0; i < this.commonCols.size(); ++i) {
            String colName = this.commonCols.get(i);
            int index = this.colIndexs.get(colName);
            String colAlias2 = this.colAliass.get(index);
            Cell cell02 = row0.createCell(i);
            cell02.setCellValue(colAlias2);
            cell02.setCellStyle((CellStyle)this.style);
            Cell cell12 = row1.createCell(i);
            cell12.setCellValue(colAlias2);
            cell12.setCellStyle((CellStyle)this.style);
            Integer width2 = widths.get(colName);
            if (width2 != null) {
                this.sheet.setColumnWidth(i, width2.intValue());
            }
            this.sheet.addMergedRegion(new CellRangeAddress(0, 1, i, i));
        }
        int start = this.commonCols.size();
        if (this.asstActCols.size() > 0) {
            for (int i = 0; i < this.asstActCols.size(); ++i) {
                String colName = this.asstActCols.get(i);
                int index = this.colIndexs.get(colName);
                colAlias = this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(this.getResource("asstAct"));
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width == null) continue;
                this.sheet.setColumnWidth(i + start, width.intValue());
            }
            if (this.asstActCols.size() > 0) {
                this.sheet.addMergedRegion(new CellRangeAddress(0, 1, start, start + this.asstActCols.size() - 1));
            }
        }
        start += this.asstActCols.size();
        if (this.yearBeginCols.size() > 0) {
            for (int i = 0; i < this.yearBeginCols.size(); ++i) {
                String colName = this.yearBeginCols.get(i);
                int index = this.colIndexs.get(colName);
                colAlias = this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(this.getResource("yearBeginBalance_exp"));
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                if (colName.equals("yearBeginQty")) {
                    colAlias = this.getResource("qty_exp");
                } else if (colName.equals("yearBeginDebitQty")) {
                    colAlias = this.getResource("debitQty_exp");
                } else if (colName.equals("yearBeginCreditQty")) {
                    colAlias = this.getResource("creditQty_exp");
                } else if (colName.equals("yearBeginBalanceFor")) {
                    colAlias = this.getResource("for_exp");
                } else if (colName.equals("yearBeginBalanceDebitFor")) {
                    colAlias = this.getResource("debitFor_exp");
                } else if (colName.equals("yearBeginBalanceCreditFor")) {
                    colAlias = this.getResource("creditFor_exp");
                } else if (colName.equals("yearBeginBalanceLocal")) {
                    colAlias = this.getResource("local_exp");
                } else if (colName.equals("yearBeginBalanceDebitLocal")) {
                    colAlias = this.getResource("debitLocal_exp");
                } else if (colName.equals("yearBeginBalanceCreditLocal")) {
                    colAlias = this.getResource("creditLocal_exp");
                } else if (colName.equals("yearBeginBalanceRpt")) {
                    colAlias = this.getResource("rpt_exp");
                } else if (colName.equals("yearBeginBalanceDebitRpt")) {
                    colAlias = this.getResource("debitRpt_exp");
                } else if (colName.equals("yearBeginBalanceCreditRpt")) {
                    colAlias = this.getResource("creditRpt_exp");
                }
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width == null) continue;
                this.sheet.setColumnWidth(i + start, width.intValue());
            }
            if (this.yearBeginCols.size() > 1) {
                this.sheet.addMergedRegion(new CellRangeAddress(0, 0, start, start + this.yearBeginCols.size() - 1));
            }
        }
        start += this.yearBeginCols.size();
        if (this.beginCols.size() > 0) {
            for (int i = 0; i < this.beginCols.size(); ++i) {
                String colName = this.beginCols.get(i);
                int index = this.colIndexs.get(colName);
                colAlias = this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(this.getResource("beginBalance_exp"));
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                if (colName.equals("beginQty")) {
                    colAlias = this.getResource("qty_exp");
                }
                if (colName.equals("beginDebitQty")) {
                    colAlias = this.getResource("debitQty_exp");
                }
                if (colName.equals("beginCreditQty")) {
                    colAlias = this.getResource("creditQty_exp");
                } else if (colName.equals("beginBalanceFor")) {
                    colAlias = this.getResource("for_exp");
                } else if (colName.equals("beginBalanceDebitFor")) {
                    colAlias = this.getResource("debitFor_exp");
                } else if (colName.equals("beginBalanceCreditFor")) {
                    colAlias = this.getResource("creditFor_exp");
                } else if (colName.equals("beginBalanceLocal")) {
                    colAlias = this.getResource("local_exp");
                } else if (colName.equals("beginBalanceDebitLocal")) {
                    colAlias = this.getResource("debitLocal_exp");
                } else if (colName.equals("beginBalanceCreditLocal")) {
                    colAlias = this.getResource("creditLocal_exp");
                } else if (colName.equals("beginBalanceRpt")) {
                    colAlias = this.getResource("rpt_exp");
                } else if (colName.equals("beginBalanceDebitRpt")) {
                    colAlias = this.getResource("debitRpt_exp");
                } else if (colName.equals("beginBalanceCreditRpt")) {
                    colAlias = this.getResource("creditRpt_exp");
                }
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width == null) continue;
                this.sheet.setColumnWidth(i + start, width.intValue());
            }
            if (this.beginCols.size() > 1) {
                this.sheet.addMergedRegion(new CellRangeAddress(0, 0, start, start + this.beginCols.size() - 1));
            }
        }
        start += this.beginCols.size();
        if (this.cols.size() > 0) {
            for (int i = 0; i < this.cols.size(); ++i) {
                String colName = this.cols.get(i);
                int index = this.colIndexs.get(colName);
                colAlias = this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(this.getResource("periodHappened"));
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                if (colName.equals("debitQty")) {
                    colAlias = this.getResource("debitQty_exp");
                } else if (colName.equals("debitFor")) {
                    colAlias = this.getResource("debitFor_exp");
                } else if (colName.equals("debitLocal")) {
                    colAlias = this.getResource("debitLocal_exp");
                } else if (colName.equals("debitRpt")) {
                    colAlias = this.getResource("debitRpt_exp");
                } else if (colName.equals("creditQty")) {
                    colAlias = this.getResource("creditQty_exp");
                } else if (colName.equals("creditFor")) {
                    colAlias = this.getResource("creditFor_exp");
                } else if (colName.equals("creditLocal")) {
                    colAlias = this.getResource("creditLocal_exp");
                } else if (colName.equals("creditRpt")) {
                    colAlias = this.getResource("creditRpt_exp");
                }
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width == null) continue;
                this.sheet.setColumnWidth(i + start, width.intValue());
            }
            if (this.cols.size() > 1) {
                this.sheet.addMergedRegion(new CellRangeAddress(0, 0, start, start + this.cols.size() - 1));
            }
        }
        start += this.cols.size();
        if (this.pnlCols.size() > 0) {
            for (int i = 0; i < this.pnlCols.size(); ++i) {
                String colName = this.pnlCols.get(i);
                int index = this.colIndexs.get(colName);
                colAlias = this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(this.getResource("periodSunyi"));
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                if (colName.equals("monthPnlQty")) {
                    colAlias = this.getResource("qty_exp");
                }
                if (colName.equals("monthPnlDebitQty")) {
                    colAlias = this.getResource("debitQty_exp");
                }
                if (colName.equals("monthPnlCreditQty")) {
                    colAlias = this.getResource("creditQty_exp");
                } else if (colName.equals("monthPnlFor")) {
                    colAlias = this.getResource("for_exp");
                } else if (colName.equals("monthPnlDebitFor")) {
                    colAlias = this.getResource("debitFor_exp");
                } else if (colName.equals("monthPnlCreditFor")) {
                    colAlias = this.getResource("creditFor_exp");
                } else if (colName.equals("monthPnlLocal")) {
                    colAlias = this.getResource("local_exp");
                } else if (colName.equals("monthPnlDebitLocal")) {
                    colAlias = this.getResource("debitLocal_exp");
                } else if (colName.equals("monthPnlCreditLocal")) {
                    colAlias = this.getResource("creditLocal_exp");
                } else if (colName.equals("monthPnlRpt")) {
                    colAlias = this.getResource("rpt_exp");
                } else if (colName.equals("monthPnlDebitRpt")) {
                    colAlias = this.getResource("debitRpt_exp");
                } else if (colName.equals("monthPnlCreditRpt")) {
                    colAlias = this.getResource("creditRpt_exp");
                }
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width == null) continue;
                this.sheet.setColumnWidth(i + start, width.intValue());
            }
            if (this.pnlCols.size() > 1) {
                this.sheet.addMergedRegion(new CellRangeAddress(0, 0, start, start + this.pnlCols.size() - 1));
            }
        }
        start += this.pnlCols.size();
        if (this.yearCols.size() > 0) {
            for (int i = 0; i < this.yearCols.size(); ++i) {
                String colName = this.yearCols.get(i);
                int index = this.colIndexs.get(colName);
                colAlias = this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(this.getResource("yearLeiji"));
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                if (colName.equals("yearDebitQty")) {
                    colAlias = this.getResource("debitQty_exp");
                } else if (colName.equals("yearDebitFor")) {
                    colAlias = this.getResource("debitFor_exp");
                } else if (colName.equals("yearDebitLocal")) {
                    colAlias = this.getResource("debitLocal_exp");
                } else if (colName.equals("yearDebitRpt")) {
                    colAlias = this.getResource("debitRpt_exp");
                } else if (colName.equals("yearCreditQty")) {
                    colAlias = this.getResource("creditQty_exp");
                } else if (colName.equals("yearCreditFor")) {
                    colAlias = this.getResource("creditFor_exp");
                } else if (colName.equals("yearCreditLocal")) {
                    colAlias = this.getResource("creditLocal_exp");
                } else if (colName.equals("yearCreditRpt")) {
                    colAlias = this.getResource("creditRpt_exp");
                }
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width == null) continue;
                this.sheet.setColumnWidth(i + start, width.intValue());
            }
            if (this.yearCols.size() > 1) {
                this.sheet.addMergedRegion(new CellRangeAddress(0, 0, start, start + this.yearCols.size() - 1));
            }
        }
        start += this.yearCols.size();
        if (this.yearPnlCols.size() > 0) {
            for (int i = 0; i < this.yearPnlCols.size(); ++i) {
                String colName = this.yearPnlCols.get(i);
                int index = this.colIndexs.get(colName);
                colAlias = this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(this.getResource("yearSunyi"));
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                if (colName.equals("yearPnlQty")) {
                    colAlias = this.getResource("qty_exp");
                } else if (colName.equals("yearPnlDebitQty")) {
                    colAlias = this.getResource("debitQty_exp");
                } else if (colName.equals("yearPnlCreditQty")) {
                    colAlias = this.getResource("creditQty_exp");
                } else if (colName.equals("yearPnlFor")) {
                    colAlias = this.getResource("for_exp");
                } else if (colName.equals("yearPnlDebitFor")) {
                    colAlias = this.getResource("debitFor_exp");
                } else if (colName.equals("yearPnlCreditFor")) {
                    colAlias = this.getResource("creditFor_exp");
                } else if (colName.equals("yearPnlLocal")) {
                    colAlias = this.getResource("local_exp");
                } else if (colName.equals("yearPnlDebitLocal")) {
                    colAlias = this.getResource("debitLocal_exp");
                } else if (colName.equals("yearPnlCreditLocal")) {
                    colAlias = this.getResource("creditLocal_exp");
                } else if (colName.equals("yearPnlRpt")) {
                    colAlias = this.getResource("rpt_exp");
                } else if (colName.equals("yearPnlDebitRpt")) {
                    colAlias = this.getResource("debitRpt_exp");
                } else if (colName.equals("yearPnlCreditRpt")) {
                    colAlias = this.getResource("creditRpt_exp");
                }
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width == null) continue;
                this.sheet.setColumnWidth(i + start, width.intValue());
            }
            if (this.yearPnlCols.size() > 1) {
                this.sheet.addMergedRegion(new CellRangeAddress(0, 0, start, start + this.yearPnlCols.size() - 1));
            }
        }
        start += this.yearPnlCols.size();
        if (this.endCols.size() > 0) {
            for (int i = 0; i < this.endCols.size(); ++i) {
                String colName = this.endCols.get(i);
                int index = this.colIndexs.get(colName);
                colAlias = this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(this.getResource("endBalance_exp"));
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                if (colName.equals("endQty")) {
                    colAlias = this.getResource("qty_exp");
                }
                if (colName.equals("endDebitQty")) {
                    colAlias = this.getResource("debitQty_exp");
                }
                if (colName.equals("endCreditQty")) {
                    colAlias = this.getResource("creditQty_exp");
                } else if (colName.equals("endBalanceFor")) {
                    colAlias = this.getResource("for_exp");
                } else if (colName.equals("endBalanceDebitFor")) {
                    colAlias = this.getResource("debitFor_exp");
                } else if (colName.equals("endBalanceCreditFor")) {
                    colAlias = this.getResource("creditFor_exp");
                } else if (colName.equals("endBalanceLocal")) {
                    colAlias = this.getResource("local_exp");
                } else if (colName.equals("endBalanceDebitLocal")) {
                    colAlias = this.getResource("debitLocal_exp");
                } else if (colName.equals("endBalanceCreditLocal")) {
                    colAlias = this.getResource("creditLocal_exp");
                } else if (colName.equals("endBalanceRpt")) {
                    colAlias = this.getResource("rpt_exp");
                } else if (colName.equals("endBalanceDebitRpt")) {
                    colAlias = this.getResource("debitRpt_exp");
                } else if (colName.equals("endBalanceCreditRpt")) {
                    colAlias = this.getResource("creditRpt_exp");
                }
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width == null) continue;
                this.sheet.setColumnWidth(i + start, width.intValue());
            }
            if (this.endCols.size() > 1) {
                this.sheet.addMergedRegion(new CellRangeAddress(0, 0, start, start + this.endCols.size() - 1));
            }
        }
    }

    protected int buildBatch(List<List<String>> values, boolean firstBatch, int beginIndex) {
        int i;
        int forPrecisionIndex = this.colIndexs.containsKey("forPrecision") ? this.colIndexs.get("forPrecision") : -1;
        int localPrecisionIndex = this.colIndexs.containsKey("localPrecision") ? this.colIndexs.get("localPrecision") : -1;
        int rptPrecisionIndex = this.colIndexs.containsKey("rptPrecision") ? this.colIndexs.get("rptPrecision") : -1;
        int qtyPrecisionIndex = this.colIndexs.containsKey("qtyPrecision") ? this.colIndexs.get("qtyPrecision") : -1;
        int companyNumberIndex = this.colIndexs.get("companyNumber");
        String orgNumber = null;
        int n = i = firstBatch ? 2 : 0;
        while (i < values.size()) {
            List<String> items = values.get(i);
            boolean isTotal = false;
            if (this.colIndexs.containsKey("isTotal")) {
                isTotal = "1".equals(items.get(this.colIndexs.get("isTotal")));
            }
            if (this.sheetByOrg) {
                orgNumber = items.get(companyNumberIndex);
            }
            if (this.sheetByOrg && !isTotal && !orgNumber.equals(this.lastOrgNumber)) {
                this.sheet = this.wb.createSheet(orgNumber);
                this.buildHead();
                beginIndex = 2;
                this.sheetIndex = 1;
            } else if (beginIndex >= this.MAX_SIZE) {
                this.sheet = this.sheetByOrg && isTotal ? this.wb.createSheet(this.lastOrgNumber + "_" + ++this.sheetIndex) : this.wb.createSheet((orgNumber != null ? orgNumber : this.getSheetName()) + "_" + ++this.sheetIndex);
                this.buildHead();
                beginIndex = 2;
            }
            this.lastOrgNumber = orgNumber;
            Row row = this.sheet.createRow(beginIndex++);
            for (int j = 0; j < this.allCols.size(); ++j) {
                String lv;
                Integer ix;
                String colName = this.allCols.get(j);
                int index = this.colIndexs.get(colName);
                String value = items.get(index);
                Cell cell = row.createCell(j);
                if (!StringUtil.isExcelNumber((String)value) && !colName.toLowerCase().contains("date")) {
                    cell.setCellStyle((CellStyle)(isTotal ? this.sumTextStyle : this.textStyle));
                } else if (isTotal) {
                    cell.setCellStyle((CellStyle)this.sumCommonStyle);
                }
                if (isTotal && j == 0) {
                    cell.setCellValue(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"total"));
                    continue;
                }
                int forPrecision = -1;
                int localPrecision = -1;
                int rptPrecision = -1;
                int qtyPrecision = -1;
                try {
                    if (forPrecisionIndex >= 0) {
                        forPrecision = Integer.parseInt(items.get(forPrecisionIndex));
                    }
                    if (localPrecisionIndex >= 0) {
                        localPrecision = Integer.parseInt(items.get(localPrecisionIndex));
                    }
                    if (rptPrecisionIndex >= 0) {
                        rptPrecision = Integer.parseInt(items.get(rptPrecisionIndex));
                    }
                    if (qtyPrecisionIndex >= 0) {
                        qtyPrecision = Integer.parseInt(items.get(qtyPrecisionIndex));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (colName.endsWith("For") || colName.endsWith("Local") || colName.endsWith("Rpt") || colName.endsWith("Qty")) {
                    Double d;
                    if (StringUtils.isEmpty((String)value) || value.equals("null") || value.replaceAll("0", "").replace(".", "").length() < 1) {
                        value = "0";
                    }
                    if ((d = Double.valueOf(Double.parseDouble(value))) == 0.0) continue;
                    cell.setCellValue(d.doubleValue());
                    int scale = colName.endsWith("For") ? forPrecision : (colName.endsWith("Local") ? localPrecision : (colName.endsWith("Rpt") ? rptPrecision : qtyPrecision));
                    String key = String.valueOf(scale) + isTotal;
                    XSSFCellStyle numeralStyle = this.numeralFormats.get(key);
                    if (numeralStyle == null) {
                        numeralStyle = (XSSFCellStyle)this.wb.createCellStyle();
                        if (isTotal) {
                            numeralStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                            numeralStyle.setFillForegroundColor(new XSSFColor(new Color(252, 251, 223)));
                        }
                        DataFormat format = this.wb.createDataFormat();
                        if (scale >= 0) {
                            numeralStyle.setDataFormat(format.getFormat(GlUtils.getDecimalFormat(scale)));
                        }
                        if (isTotal) {
                            XSSFColor borderColor = new XSSFColor(new Color(218, 220, 221));
                            numeralStyle.setBorderBottom(BorderStyle.THIN);
                            numeralStyle.setBorderTop(BorderStyle.THIN);
                            numeralStyle.setBorderLeft(BorderStyle.THIN);
                            numeralStyle.setBorderRight(BorderStyle.THIN);
                            numeralStyle.setBottomBorderColor(borderColor);
                            numeralStyle.setTopBorderColor(borderColor);
                            numeralStyle.setLeftBorderColor(borderColor);
                            numeralStyle.setRightBorderColor(borderColor);
                        }
                        this.numeralFormats.put(key, numeralStyle);
                    }
                    cell.setCellStyle((CellStyle)numeralStyle);
                    continue;
                }
                if (colName.endsWith("Level") || colName.equals("isBizUnit")) {
                    if (StringUtils.isEmpty((String)value)) continue;
                    cell.setCellValue(Double.parseDouble(value));
                    continue;
                }
                if (colName.equals("accountDc")) {
                    if ("1".equals(value)) {
                        cell.setCellValue(this.getResource("debit"));
                        continue;
                    }
                    cell.setCellValue(this.getResource("credit"));
                    continue;
                }
                if (colName.equals("companyName")) {
                    if (this.showCompanyNameByLevel && (ix = this.colIndexs.get("companyLevel")) != null && !StringUtils.isEmpty((String)(lv = items.get(ix)))) {
                        try {
                            int l = Integer.parseInt(lv);
                            if (l > 1) {
                                value = this.getPrefix(this.placeholder, l - this.companyTopLevel) + value;
                            }
                        }
                        catch (Exception l) {
                            // empty catch block
                        }
                    }
                    cell.setCellValue(value);
                    continue;
                }
                if (colName.equals("accountName")) {
                    if (this.showAccountNameByLevel && (ix = this.colIndexs.get("accountLevel")) != null && !StringUtils.isEmpty((String)(lv = items.get(ix)))) {
                        try {
                            int l = Integer.parseInt(lv);
                            if (l > 1) {
                                value = this.getPrefix(this.placeholder, l - 1) + value;
                            }
                        }
                        catch (Exception l) {
                            // empty catch block
                        }
                    }
                    cell.setCellValue(value);
                    continue;
                }
                if (colName.equals(this.levelAatColName)) {
                    if (this.showAsstActNameByLevel && (ix = this.colIndexs.get("asstActLevel" + this.levelAatIdx)) != null && !StringUtils.isEmpty((String)(lv = items.get(ix)))) {
                        try {
                            int l = Integer.parseInt(lv);
                            if (l > 1) {
                                value = this.getPrefix(this.placeholder, l - 1) + value;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    cell.setCellValue(value);
                    continue;
                }
                cell.setCellValue(value);
            }
            ++i;
        }
        return beginIndex;
    }

    protected String getPrefix(String placeholder, int count) {
        String prefix = "";
        for (int i = 0; i < count; ++i) {
            prefix = prefix + placeholder;
        }
        return prefix;
    }

    protected Map<String, Integer> getWidths() {
        HashMap<String, Integer> widths = new HashMap<String, Integer>();
        widths.put("companyNumber", 4000);
        widths.put("companyLongNumber", 5000);
        widths.put("companyName", 4000);
        widths.put("companyLevel", 2000);
        widths.put("isBizUnit", 2000);
        widths.put("accountNumber", 4000);
        widths.put("accountName", 4000);
        widths.put("accountLongName", 6000);
        widths.put("accountLevel", 2000);
        widths.put("accountDc", 2000);
        widths.put("currencyNumber", 2500);
        widths.put("currencyName", 2500);
        for (int i = 1; i <= 8; ++i) {
            widths.put("asstActNumber" + i, 4500);
            widths.put("asstActLongNumber" + i, 5000);
            widths.put("asstActName" + i, 4500);
            widths.put("asstActLongName" + i, 6000);
        }
        widths.put("yearBeginBalanceFor", 3500);
        widths.put("yearBeginBalanceDebitFor", 3500);
        widths.put("yearBeginBalanceCreditFor", 3500);
        widths.put("beginBalanceFor", 3500);
        widths.put("beginBalanceDebitFor", 3500);
        widths.put("beginBalanceCreditFor", 3500);
        widths.put("debitFor", 3500);
        widths.put("creditFor", 3500);
        widths.put("yearDebitFor", 3500);
        widths.put("yearCreditFor", 3500);
        widths.put("monthPnlFor", 3500);
        widths.put("monthPnlDebitFor", 3500);
        widths.put("monthPnlCreditFor", 3500);
        widths.put("yearPnlFor", 3500);
        widths.put("yearPnlDebitFor", 3500);
        widths.put("yearPnlCreditFor", 3500);
        widths.put("endBalanceFor", 3500);
        widths.put("endBalanceDebitFor", 3500);
        widths.put("endBalanceCreditFor", 3500);
        widths.put("yearBeginBalanceLocal", 3500);
        widths.put("yearBeginBalanceDebitLocal", 3500);
        widths.put("yearBeginBalanceCreditLocal", 3500);
        widths.put("beginBalanceLocal", 3500);
        widths.put("beginBalanceDebitLocal", 3500);
        widths.put("beginBalanceCreditLocal", 3500);
        widths.put("debitLocal", 3500);
        widths.put("creditLocal", 3500);
        widths.put("yearDebitLocal", 3500);
        widths.put("yearCreditLocal", 3500);
        widths.put("monthPnlLocal", 3500);
        widths.put("monthPnlDebitLocal", 3500);
        widths.put("monthPnlCreditLocal", 3500);
        widths.put("yearPnlLocal", 3500);
        widths.put("yearPnlDebitLocal", 3500);
        widths.put("yearPnlCreditLocal", 3500);
        widths.put("endBalanceLocal", 3500);
        widths.put("endBalanceDebitLocal", 3500);
        widths.put("endBalanceCreditLocal", 3500);
        widths.put("yearBeginBalanceRpt", 3500);
        widths.put("yearBeginBalanceDebitRpt", 3500);
        widths.put("yearBeginBalanceCreditRpt", 3500);
        widths.put("beginBalanceRpt", 3500);
        widths.put("beginBalanceDebitRpt", 3500);
        widths.put("beginBalanceCreditRpt", 3500);
        widths.put("debitRpt", 3500);
        widths.put("creditRpt", 3500);
        widths.put("yearDebitRpt", 3500);
        widths.put("yearCreditRpt", 3500);
        widths.put("monthPnlRpt", 3500);
        widths.put("monthPnlDebitRpt", 3500);
        widths.put("monthPnlCreditRpt", 3500);
        widths.put("yearPnlRpt", 3500);
        widths.put("yearPnlDebitRpt", 3500);
        widths.put("yearPnlCreditRpt", 3500);
        widths.put("endBalanceRpt", 3500);
        widths.put("endBalanceDebitRpt", 3500);
        widths.put("endBalanceCreditRpt", 3500);
        widths.put("measureUnitName", 3000);
        widths.put("yearBeginQty", 3000);
        widths.put("yearBeginDebitQty", 3000);
        widths.put("yearBeginCreditQty", 3000);
        widths.put("beginQty", 3000);
        widths.put("beginDebitQty", 3000);
        widths.put("beginCreditQty", 3000);
        widths.put("debitQty", 3000);
        widths.put("creditQty", 3000);
        widths.put("yearDebitQty", 3000);
        widths.put("yearCreditQty", 3000);
        widths.put("monthPnlQty", 3000);
        widths.put("monthPnlDebitQty", 3000);
        widths.put("monthPnlCreditQty", 3000);
        widths.put("yearPnlQty", 3000);
        widths.put("yearPnlDebitQty", 3000);
        widths.put("yearPnlCreditQty", 3000);
        widths.put("endQty", 3000);
        widths.put("endDebitQty", 3000);
        widths.put("endCreditQty", 3000);
        return widths;
    }

    public boolean isStop() {
        return this.nRptUI.isStop();
    }

    public void info(String msg) {
        this.nRptUI.info(msg);
    }

    public void warn(String msg) {
        this.nRptUI.warn(msg);
    }

    public void error(String msg) {
        this.nRptUI.error(msg);
    }

    public void error(Throwable t) {
        this.nRptUI.error(t);
    }
}

