/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.ReportConditionBalanceListAssist;
import com.kingdee.eas.fi.gl.client.ReportBalanceListAssistUI;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLNRptAccountBalanceUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAccountBalanceExportUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAccountBalanceQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptSubLedgerUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTable;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTableHelper;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.config.IObjectMultiPKBuilder;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;

public class GLNRptAccountBalanceUI
extends AbstractGLNRptAccountBalanceUI {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptAccountBalanceUI.class);

    public GLNRptAccountBalanceUI() throws Exception {
        this.init();
    }

    private void init() {
        this.txtConsole.setContentType("text/html");
        this.txtConsole.setEditable(false);
        StringBuffer htmlText = new StringBuffer();
        htmlText.append("<html>");
        htmlText.append("<body>");
        htmlText.append(this.getResource("detailsUsageInfo"));
        htmlText.append("<br>");
        htmlText.append("<a href=\"https://vip.kingdee.com/article/348055433821180928\">https://vip.kingdee.com/article/348055433821180928</a>");
        htmlText.append("<br>");
        htmlText.append("</body>");
        htmlText.append("</html>");
        this.txtConsole.setText(htmlText.toString());
        this.txtConsole.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(evt.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initPopMenu(GLNRptAccountBalanceExportUI.class.getName());
    }

    protected void initListener() {
        super.initListener();
        this.getTable().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    if (GLNRptAccountBalanceUI.this.innerSumTable != null) {
                        GLNRptAccountBalanceUI.this.innerSumTable.setVisible(false);
                    }
                    if (GLNRptAccountBalanceUI.this.innerSumTable != null && (GLNRptAccountBalanceUI.this.getTable().getSelectManager().size() > 1 || e.getSelectBlock().getEndRow() - e.getSelectBlock().getBeginRow() > 0)) {
                        GLNRptAccountBalanceUI.this.innerSumTable.selectRowSum(GLNRptAccountBalanceUI.this.getTable().getSelectManager().getBlocks(), false);
                    } else {
                        int rowIndex = e.getSelectBlock().getTop();
                        GLNRptAccountBalanceUI.this.tblMain_doSelectChanged(rowIndex);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    GLNRptAccountBalanceUI.this.handleError(ex);
                }
            }
        });
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        GLNRptAccountBalanceUI.this.tblMain_doDoubleClicked();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    GLNRptAccountBalanceUI.this.handleError(ex);
                }
            }
        });
    }

    @Override
    protected GLNRptBaseQueryUI getCustQueryPanel() throws Exception {
        return new GLNRptAccountBalanceQueryUI();
    }

    @Override
    protected void setQueryDialogSize(CommonQueryDialog dialog) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        int width = screen.width - insets.left - insets.right;
        if ((width -= 300) > 1080) {
            width = 1080;
        }
        int height = screen.height - insets.top - insets.bottom;
        if ((height -= 90) > 640) {
            height = 640;
        }
        dialog.setWidth(width);
        dialog.setHeight(height);
    }

    @Override
    public int getColumnWidthByColumnName(String colName) {
        return super.getColumnWidthByColumnName(colName);
    }

    @Override
    public void setRptType(Map<String, Object> queryConfig) {
        super.setRptType(queryConfig);
        queryConfig.put("rptType", "AccountBalance");
    }

    public void tblMain_doSelectChanged(int rowIndex) {
        this.actionSubsidiaryLedger.setEnabled(false);
        this.actionAssistAccount.setEnabled(false);
        Map<String, Object> queryConfig = this.getTable().queryConfig;
        String orgTreeId = (String)queryConfig.get("orgTreeId");
        String sumByUnion = (String)queryConfig.get("sumByUnion");
        if (orgTreeId != null && orgTreeId.length() > 0 && sumByUnion != null && "true".equals(sumByUnion)) {
            return;
        }
        IRow row = this.getTable().getRow(rowIndex);
        if (row != null) {
            String accountNumber = (String)row.getCell("accountNumber").getValue();
            if (StringUtils.isEmpty((String)accountNumber)) {
                return;
            }
            this.actionSubsidiaryLedger.setEnabled(true);
            String strAssisthgId = null;
            if (row.getCell("assistGrpId") != null) {
                strAssisthgId = (String)row.getCell("assistGrpId").getValue();
            }
            if (strAssisthgId != null && strAssisthgId.length() > 0) {
                this.actionAssistAccount.setEnabled(true);
                return;
            }
            try {
                String companyNumber = (String)row.getCell("companyNumber").getValue();
                CompanyOrgUnitInfo company = this.getCompany(companyNumber);
                if (!company.isIsBizUnit()) {
                    return;
                }
                AccountTableInfo accountTable = null;
                String accountTableNumber = (String)queryConfig.get("accountTableNumber");
                if (accountTableNumber != null) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountTableNumber));
                    view.setFilter(filter);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("id");
                    selector.add("name");
                    view.setSelector(selector);
                    AccountTableCollection coll = AccountTableFactory.getRemoteInstance().getAccountTableCollection(view);
                    if (coll.size() > 0) {
                        accountTable = coll.get(0);
                    }
                }
                if (accountTable == null) {
                    accountTable = company.getAccountTable();
                }
                if (accountTable == null) {
                    return;
                }
                AccountViewInfo account = null;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
                if (company != null) {
                    filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
                }
                if (accountTable != null) {
                    filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
                }
                filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                view.setSelector(selector);
                AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
                if (coll.size() > 0) {
                    account = coll.get(0);
                }
                if (account == null) {
                    return;
                }
                String fromPeriodNumber = (String)queryConfig.get("fromPeriodNumber");
                String toPeriodNumber = (String)queryConfig.get("toPeriodNumber");
                int startPeriod = Integer.parseInt(fromPeriodNumber);
                int endPeriod = Integer.parseInt(toPeriodNumber);
                Set caas = AccountFacadeFactory.getRemoteInstance().getCAAIdsByPeriodRange(account.getId().toString(), startPeriod, endPeriod);
                if (caas.size() > 0) {
                    this.actionAssistAccount.setEnabled(true);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"", (Throwable)e);
            }
        }
    }

    public void tblMain_doDoubleClicked() {
        if (this.actionSubsidiaryLedger.isEnabled()) {
            try {
                this.setCursorOfWair();
                this.findSubsidiaryLedger();
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handleError(e);
            }
            finally {
                this.setCursorOfDefault();
            }
        }
    }

    @Override
    public void actionSubsidiaryLedger_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        try {
            this.setCursorOfWair();
            this.findSubsidiaryLedger();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    private void findSubsidiaryLedger() throws BOSException, EASBizException {
        int rowIndex = KDTableUtil.getSelectedTop((KDTable)this.getTable());
        IRow row = this.getTable().getRow(rowIndex);
        if (row != null) {
            Object value;
            String assistGrpId;
            ICell cell = row.getCell("assistGrpId");
            if (cell == null || (assistGrpId = (String)cell.getValue()) == null || assistGrpId.trim().length() > 0) {
                // empty if block
            }
            HashMap<String, Object> queryConfig = new HashMap<String, Object>();
            queryConfig.putAll(this.queryConfig);
            String companyNumber = (String)row.getCell("companyNumber").getValue();
            if (!StringUtils.isEmpty((String)companyNumber)) {
                queryConfig.put("companyNumber", this.getLinkedCompanyNumber(companyNumber));
            }
            CurrencyInfo currency = null;
            String currencyNumber = (String)queryConfig.get("currencyNumber");
            if ((currencyNumber == null || currencyNumber.length() == 0) && (cell = row.getCell("currencyNumber")) != null) {
                currencyNumber = (String)cell.getValue();
            }
            if (currencyNumber != null && currencyNumber.length() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber));
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                view.setSelector(selector);
                CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
                if (coll.size() > 0) {
                    currency = coll.get(0);
                }
            }
            if (currency != null) {
                queryConfig.put("currencyNumber", currency.getNumber());
            } else {
                String currencyName;
                cell = row.getCell("currencyName");
                if (cell != null && (currencyName = (String)cell.getValue()) != null && currencyName.length() > 0) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)currencyName));
                    view.setFilter(filter);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("id");
                    selector.add("number");
                    selector.add("name");
                    view.setSelector(selector);
                    CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
                    if (coll.size() > 0) {
                        currency = coll.get(0);
                    }
                }
                if (currency != null) {
                    queryConfig.put("currencyNumber", currency.getNumber());
                }
            }
            String accountNumber = (String)row.getCell("accountNumber").getValue();
            String accountLevel = null;
            cell = row.getCell("accountLevel");
            if (cell != null && (value = cell.getValue()) != null && value.toString().trim().length() > 0) {
                try {
                    int i = Integer.parseInt(value.toString().trim());
                    if (i > 0) {
                        accountLevel = String.valueOf(i);
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((String)accountNumber)) {
                String assistGrpId2;
                String str = (String)queryConfig.get("accountNumber");
                if (str != null && str.trim().length() > 0) {
                    String[] ss;
                    StringBuffer numbers = new StringBuffer();
                    for (String s : ss = str.split(";")) {
                        if (!(s = s.trim()).startsWith(accountNumber) || s.length() <= accountNumber.length()) continue;
                        numbers.append(s).append(";");
                    }
                    if (numbers.length() > 0) {
                        queryConfig.put("accountNumber", numbers.toString());
                    } else {
                        queryConfig.put("accountNumber", accountNumber);
                    }
                } else {
                    queryConfig.put("accountNumber", accountNumber);
                }
                queryConfig.put("showPeriodSum", "true");
                queryConfig.put("showYearSum", "true");
                if (accountLevel == null) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
                    if (!StringUtils.isEmpty((String)companyNumber)) {
                        filter.getFilterItems().add(new FilterItemInfo("companyID.number", (Object)companyNumber));
                    }
                    if (queryConfig.get("accountTableNumber") != null) {
                        filter.getFilterItems().add(new FilterItemInfo("accountTableID.number", queryConfig.get("accountTableNumber")));
                    }
                    view.setFilter(filter);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("level");
                    view.setSelector(selector);
                    AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
                    if (coll.size() > 0) {
                        accountLevel = String.valueOf(coll.get(0).getLevel());
                    }
                }
                if (accountLevel == null) {
                    accountLevel = "1";
                }
                queryConfig.put("toAccountLevel", accountLevel);
                cell = row.getCell("assistGrpId");
                if (cell != null && (assistGrpId2 = (String)cell.getValue()) != null && assistGrpId2.trim().length() > 0) {
                    assistGrpId2 = assistGrpId2.trim();
                    List ats = GLRptUtils.getAsstactTypeEntityListWithSelectItem(assistGrpId2);
                    ArrayList asstActTypes = new ArrayList();
                    queryConfig.put("asstActTypes", asstActTypes);
                    for (AsstactTypeEntity at : ats) {
                        HashMap<String, String> asstActType = new HashMap<String, String>();
                        asstActTypes.add(asstActType);
                        asstActType.put("type", at.getNumber());
                        DataBaseInfo db = (DataBaseInfo)at.getFrom();
                        String number = null;
                        if (db != null) {
                            number = at.isGeneralActType() || at.isUseLongNumber() ? db.getString("longNumber") : db.getNumber();
                        }
                        asstActType.put("from", number != null ? number : "");
                        db = (DataBaseInfo)at.getTo();
                        number = null;
                        if (db != null) {
                            number = at.isGeneralActType() || at.isUseLongNumber() ? db.getString("longNumber") : db.getNumber();
                        }
                        asstActType.put("to", number != null ? number : "");
                    }
                }
                this.joinQuery(queryConfig, GLNRptSubLedgerUI.class.getName());
            }
        }
    }

    @Override
    protected void setQueryingActionStatus(boolean enable) {
        super.setQueryingActionStatus(enable);
        this.actionSubsidiaryLedger.setEnabled(false);
        this.actionAssistAccount.setEnabled(false);
    }

    private void findSubLedger(IRow row, String assistGrpId) throws BOSException, EASBizException {
        Object value;
        CurrencyCollection coll;
        SelectorItemCollection selector;
        FilterInfo filter;
        EntityViewInfo view;
        ICell cell;
        String toPeriodNumber;
        Map<String, Object> queryConfig = this.getTable().queryConfig;
        GLRptSubLedgerCondition cond = new GLRptSubLedgerCondition();
        String companyNumber = (String)row.getCell("companyNumber").getValue();
        CompanyOrgUnitInfo company = this.getCompany(companyNumber);
        if (!company.isIsBizUnit()) {
            return;
        }
        cond.setCompanyDisplayMode(CompanyDisplayModeEnum.enumerate);
        cond.switchCompany(company);
        cond.setSelectedCompanys(new CompanyOrgUnitInfo[]{company});
        cond.setOptionPosting("1".equals(queryConfig.get("balType")));
        cond.setNotIncluePLVoucher("true".equals(queryConfig.get("notIncludePLVoucher")));
        cond.setOptionAmountZero("true".equals(queryConfig.get("notShowNoCurrent")));
        cond.setOptionAmountAndBalZero("true".equals(queryConfig.get("notShowZeroAndNoCurrent")));
        PeriodTypeInfo periodType = null;
        String periodTypeNumber = (String)queryConfig.get("periodTypeNumber");
        if (periodTypeNumber != null) {
            EntityViewInfo view2 = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("number", (Object)periodTypeNumber));
            view2.setFilter(filter2);
            SelectorItemCollection selector2 = new SelectorItemCollection();
            selector2.add("id");
            view2.setSelector(selector2);
            PeriodTypeCollection coll2 = PeriodTypeFactory.getRemoteInstance().getPeriodTypeCollection(view2);
            if (coll2.size() > 0) {
                periodType = coll2.get(0);
            }
        }
        if (periodType != null) {
            cond.setPeriodTypeId(periodType.getId().toString());
        } else if (company.getAccountPeriodType() != null) {
            cond.setPeriodTypeId(company.getAccountPeriodType().getId().toString());
        } else {
            return;
        }
        String fromPeriodNumber = (String)queryConfig.get("fromPeriodNumber");
        if (fromPeriodNumber != null) {
            int i = Integer.parseInt(fromPeriodNumber);
            cond.setPeriodYearStart(i / 100);
            cond.setPeriodNumberStart(i % 100);
        }
        if ((toPeriodNumber = (String)queryConfig.get("toPeriodNumber")) != null) {
            int i = Integer.parseInt(toPeriodNumber);
            cond.setPeriodYearEnd(i / 100);
            cond.setPeriodNumberEnd(i % 100);
        }
        CurrencyInfo currency = null;
        String currencyNumber = (String)queryConfig.get("currencyNumber");
        if ((currencyNumber == null || currencyNumber.length() == 0) && (cell = row.getCell("currencyNumber")) != null) {
            currencyNumber = (String)cell.getValue();
        }
        if (currencyNumber != null && currencyNumber.length() > 0) {
            EntityViewInfo view3 = new EntityViewInfo();
            FilterInfo filter3 = new FilterInfo();
            filter3.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber));
            view3.setFilter(filter3);
            SelectorItemCollection selector3 = new SelectorItemCollection();
            selector3.add("id");
            selector3.add("name");
            view3.setSelector(selector3);
            CurrencyCollection coll3 = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view3);
            if (coll3.size() > 0) {
                currency = coll3.get(0);
            }
        }
        if (currency != null) {
            cond.setCurrencyID(currency.getId().toString());
            cond.setCurrencyName(currency.getName());
        } else {
            String currencyName;
            cell = row.getCell("currencyName");
            if (cell != null && (currencyName = (String)cell.getValue()) != null && currencyName.length() > 0) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)currencyName));
                view.setFilter(filter);
                selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("name");
                view.setSelector(selector);
                coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
                if (coll.size() > 0) {
                    currency = coll.get(0);
                }
            }
            if (currency != null) {
                cond.setCurrencyID(currency.getId().toString());
                cond.setCurrencyName(currency.getName());
            } else {
                cond.setCurrencyID("AllCurrency");
                cond.setCurrencyName(GLResUtil.getRes("all_currency"));
            }
        }
        AccountTableInfo accountTable = null;
        String accountTableNumber = (String)queryConfig.get("accountTableNumber");
        if (accountTableNumber != null) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountTableNumber));
            view.setFilter(filter);
            selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("name");
            view.setSelector(selector);
            coll = AccountTableFactory.getRemoteInstance().getAccountTableCollection(view);
            if (coll.size() > 0) {
                accountTable = coll.get(0);
            }
        }
        if (accountTable != null) {
            cond.setAccountTableId(accountTable.getId().toString());
        } else if (company.getAccountTable() != null) {
            cond.setAccountTableId(company.getAccountTable().getId().toString());
        } else {
            return;
        }
        String accountNumber = (String)row.getCell("accountNumber").getValue();
        String accountLevel = null;
        ICell cell2 = row.getCell("accountLevel");
        if (cell2 != null && (value = cell2.getValue()) != null && value.toString().trim().length() > 0) {
            try {
                int i = Integer.parseInt(value.toString().trim());
                if (i > 0) {
                    accountLevel = String.valueOf(i);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)accountNumber)) {
            cond.setAccountCodeStart(accountNumber);
            cond.setAccountCodeEnd(accountNumber);
            if (accountLevel == null) {
                EntityViewInfo view4 = new EntityViewInfo();
                FilterInfo filter4 = new FilterInfo();
                filter4.getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
                if (!StringUtils.isEmpty((String)companyNumber)) {
                    filter4.getFilterItems().add(new FilterItemInfo("companyID.number", (Object)companyNumber));
                }
                if (queryConfig.get("accountTableNumber") != null) {
                    filter4.getFilterItems().add(new FilterItemInfo("accountTableID.number", queryConfig.get("accountTableNumber")));
                }
                view4.setFilter(filter4);
                SelectorItemCollection selector4 = new SelectorItemCollection();
                selector4.add("level");
                view4.setSelector(selector4);
                AccountViewCollection coll4 = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view4);
                if (coll4.size() > 0) {
                    accountLevel = String.valueOf(coll4.get(0).getLevel());
                }
            }
        }
        if (accountLevel == null) {
            accountLevel = "1";
        }
        cond.setAccountLevelStart(Integer.parseInt(accountLevel));
        cond.setAccountLevelEnd(Integer.parseInt(accountLevel));
        cond.setShowDisplayAsstDetail(true);
        cond.setSumByAsstact(true);
        List ats = GLRptUtils.getAsstactTypeEntityListWithSelectItem(assistGrpId);
        cond.setAsstActList(ats);
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(GLRptSubLedgerUI.class.getName(), (Map)this.getLinkedContext(cond), null);
        ui.show();
    }

    protected UIContext getLinkedContext(GLRptBaseCondition cond) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
        uiContext.put((Object)"UIClassParam", (Object)cond.toMap().toString());
        uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)cond);
        return uiContext;
    }

    @Override
    public void actionAssistAccount_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.findAssistAccountBalance();
    }

    private void findAssistAccountBalance() throws Exception {
        SelectorItemCollection selector;
        ICell cell;
        String toPeriodNumber;
        KDTSelectBlock sb = this.getTable().getSelectManager().get();
        if (sb == null) {
            return;
        }
        int top = sb.getTop();
        IRow row = this.getTable().getRow(top);
        Map<String, Object> queryConfig = this.getTable().queryConfig;
        ReportConditionBalanceListAssist cond = new ReportConditionBalanceListAssist();
        String companyNumber = (String)row.getCell("companyNumber").getValue();
        CompanyOrgUnitInfo company = this.getCompany(companyNumber);
        if (!company.isIsBizUnit()) {
            return;
        }
        cond.setOptionShowQty("true".equals(queryConfig.get("showQty")));
        cond.setExpandCompanyLevel(1);
        cond.setOptionPosting("1".equals(queryConfig.get("balType")));
        String fromPeriodNumber = (String)queryConfig.get("fromPeriodNumber");
        if (fromPeriodNumber != null) {
            int i = Integer.parseInt(fromPeriodNumber);
            cond.setPeriodYearStart(i / 100);
            cond.setPeriodNumberStart(i % 100);
        }
        if ((toPeriodNumber = (String)queryConfig.get("toPeriodNumber")) != null) {
            int i = Integer.parseInt(toPeriodNumber);
            cond.setPeriodYearEnd(i / 100);
            cond.setPeriodNumberEnd(i % 100);
        }
        AccountTableInfo accountTable = null;
        String accountTableNumber = (String)queryConfig.get("accountTableNumber");
        if (accountTableNumber != null && accountTableNumber.length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountTableNumber));
            view.setFilter(filter);
            SelectorItemCollection selector2 = new SelectorItemCollection();
            selector2.add("id");
            selector2.add("name");
            view.setSelector(selector2);
            AccountTableCollection coll = AccountTableFactory.getRemoteInstance().getAccountTableCollection(view);
            if (coll.size() > 0) {
                accountTable = coll.get(0);
            }
        }
        if (accountTable == null) {
            accountTable = company.getAccountTable();
        }
        if (accountTable == null) {
            return;
        }
        AccountViewInfo account = null;
        String accountNumber = (String)row.getCell("accountNumber").getValue();
        if (accountNumber != null && accountNumber.length() > 0) {
            cond.setAccountCodeStart(accountNumber);
            cond.setAccountCodeEnd(accountNumber);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
            if (company != null) {
                filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
            }
            if (accountTable != null) {
                filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
            }
            view.setFilter(filter);
            SelectorItemCollection selector3 = new SelectorItemCollection();
            selector3.add("id");
            selector3.add("number");
            selector3.add("level");
            selector3.add("PLType");
            view.setSelector(selector3);
            AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
            if (coll.size() > 0) {
                account = coll.get(0);
            }
        }
        if (account == null) {
            return;
        }
        cond.setAccountId(account.getId().toString());
        cond.setAccountLevelStart(account.getLevel());
        cond.setAccountLevelEnd(account.getLevel());
        CurrencyInfo currency = null;
        String currencyNumber = (String)queryConfig.get("currencyNumber");
        if ((currencyNumber == null || currencyNumber.length() == 0) && (cell = row.getCell("currencyNumber")) != null) {
            currencyNumber = (String)cell.getValue();
        }
        if (currencyNumber != null && currencyNumber.length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber));
            view.setFilter(filter);
            selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("name");
            view.setSelector(selector);
            CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
            if (coll.size() > 0) {
                currency = coll.get(0);
            }
        }
        if (currency != null) {
            cond.setCurrencyID(currency.getId().toString());
            cond.setCurrencyName(currency.getName());
        } else {
            String currencyName;
            cell = row.getCell("currencyName");
            if (cell != null && (currencyName = (String)cell.getValue()) != null && currencyName.length() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)currencyName));
                view.setFilter(filter);
                SelectorItemCollection selector4 = new SelectorItemCollection();
                selector4.add("id");
                selector4.add("name");
                view.setSelector(selector4);
                CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
                if (coll.size() > 0) {
                    currency = coll.get(0);
                }
            }
            if (currency != null) {
                cond.setCurrencyID(currency.getId().toString());
                cond.setCurrencyName(currency.getName());
            } else {
                cond.setCurrencyID("AllCurrency");
                cond.setCurrencyName(GLResUtil.getRes("all_currency"));
            }
        }
        if ("true".equals(queryConfig.get("notIncludePLVoucher")) && (account == null || account != null && account.getPLType() != AccountPLType.NONE) && !MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"98_ReportBalanceListUI")))) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        if (currency != null) {
            cond.setCurrencyID(currency.getId().toString());
            cond.setCurrencyName(currency.getName());
        }
        evi.put("GLFixCondition", (Object)cond);
        String strAssisthgId = null;
        if (row.getCell("assistGrpId") != null) {
            strAssisthgId = (String)row.getCell("assistGrpId").getValue();
        }
        if (strAssisthgId != null && strAssisthgId.trim().length() > 0) {
            evi.put("asstHGId", (Object)strAssisthgId);
            cond.setAssistItemId(strAssisthgId);
            selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("asstAccount.id");
            AssistantHGInfo hg = AssistantHGFactory.getRemoteInstance().getAssistantHGInfo((IObjectPK)new ObjectUuidPK(strAssisthgId), selector);
            if (hg.getAsstAccount() != null) {
                cond.setAsstAccountId(hg.getAsstAccount().getId().toString());
            }
        }
        ReportBalanceListAssistUI.queryByCondition(evi, this, company);
    }

    @Override
    protected Map<String, Object> getSearchParams(int type) {
        Map<String, Object> params = super.getSearchParams(type);
        params.put("showRemoteSearch", "true");
        return params;
    }

    @Override
    protected List<Map<String, String>> getSearchTargets(int type) {
        ArrayList<Map<String, String>> targets = new ArrayList<Map<String, String>>();
        GLNRptTable table = this.getTable();
        if (table == null) {
            return targets;
        }
        HashSet<String> names = new HashSet<String>();
        names.add("companyNumber");
        names.add("companyLongNumber");
        names.add("companyName");
        names.add("accountNumber");
        names.add("accountName");
        names.add("accountLongName");
        names.add("currencyNumber");
        names.add("currencyName");
        names.add("asstActName1");
        names.add("asstActName2");
        names.add("asstActName3");
        names.add("asstActName4");
        names.add("asstActName5");
        names.add("asstActName6");
        names.add("asstActName7");
        names.add("asstActName8");
        names.add("beginBalanceFor");
        names.add("beginBalanceDebitFor");
        names.add("beginBalanceCreditFor");
        names.add("debitFor");
        names.add("creditFor");
        names.add("endBalanceFor");
        names.add("endBalanceDebitFor");
        names.add("endBalanceCreditFor");
        names.add("beginBalanceLocal");
        names.add("beginBalanceDebitLocal");
        names.add("beginBalanceCreditLocal");
        names.add("debitLocal");
        names.add("creditLocal");
        names.add("endBalanceLocal");
        names.add("endBalanceDebitLocal");
        names.add("endBalanceCreditLocal");
        names.add("beginBalanceRpt");
        names.add("beginBalanceDebitRpt");
        names.add("beginBalanceCreditRpt");
        names.add("debitRpt");
        names.add("creditRpt");
        names.add("endBalanceRpt");
        names.add("endBalanceDebitRpt");
        names.add("endBalanceCreditRpt");
        HashSet<Integer> selectedIndexs = new HashSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            KDTSelectBlock block = table.getSelectManager().get(i);
            if (block.getMode() != 1 && block.getMode() != 15 && block.getMode() != 4 && block.getMode() != 12) continue;
            for (int j = block.getLeft(); j <= block.getRight(); ++j) {
                selectedIndexs.add(j);
            }
        }
        for (int columIndex = 0; columIndex < table.getColumnCount(); ++columIndex) {
            String key;
            IColumn col = table.getColumn(columIndex);
            if (col == null || col.getStyleAttributes().isHided() || (key = col.getKey()) == null || !names.contains(key)) continue;
            HashMap<String, String> target = new HashMap<String, String>();
            target.put("name", key);
            if (key.startsWith("asstActName")) {
                target.put("title", this.getResource("asstAct") + key.substring(11));
            } else {
                target.put("title", this.getResource(key));
            }
            if (type == 1) {
                if (selectedIndexs.contains(columIndex)) {
                    target.put("selected", "true");
                } else {
                    target.put("selected", "false");
                }
            } else if (type == 2 && selectedIndexs.contains(columIndex)) {
                target.put("selected", "true");
            }
            targets.add(target);
        }
        return targets;
    }

    @Override
    public Object getTablePreferenceSchemaKey() {
        Object key = super.getTablePreferenceSchemaKey();
        Object showYear = this.queryConfig.get("showYear");
        return key + "||" + showYear;
    }

    protected void initHelper() {
        this.tHelperPrint = this.tHelper = new GLNRptTableHelper(this, new IObjectMultiPKBuilder(){

            public IObjectPK buildPK() {
                return GLNRptAccountBalanceUI.this.buildPK();
            }
        });
    }

    @Override
    protected String getExportPermissionItem() {
        return "gln_balanceList_export";
    }
}

