/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.SorterSignEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLNRptAsstActBalanceSortUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class GLNRptAsstActBalanceSortUI
extends AbstractGLNRptAsstActBalanceSortUI {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptAsstActBalanceSortUI.class);

    public GLNRptAsstActBalanceSortUI() throws Exception {
        this.init();
    }

    private void init() {
        this.tblSort.checkParsed();
        this.btnSortUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnSortUp.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonSorterPanel", (String)"moveUp"));
        this.btnSortDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnSortDown.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonSorterPanel", (String)"moveDown"));
        this.btnSortUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLNRptAsstActBalanceSortUI.this.moveRow(-1);
            }
        });
        this.btnSortDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLNRptAsstActBalanceSortUI.this.moveRow(1);
            }
        });
    }

    @Override
    protected void initDefaultSetting() throws EASBizException, BOSException {
        this.fillSortItems(this.getDefaultSortItems());
    }

    @Override
    protected void showAdvanceActionPerformed(ActionEvent e) {
        System.out.println();
    }

    private void moveRow(int offset) {
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblSort);
        if (indexs.length == 0) {
            return;
        }
        int index = indexs[0];
        int newIndex = index + offset;
        if (newIndex < 0 || newIndex >= this.tblSort.getRowCount()) {
            return;
        }
        IRow row = this.tblSort.removeRow(index);
        row = this.tblSort.addRow(newIndex, row);
        KDTSelectBlock sb = new KDTSelectBlock(newIndex, 0, newIndex, 0, 2);
        this.tblSort.getSelectManager().select(sb);
        this.tblSort.getLayoutManager().scrollToShow(newIndex, 0);
    }

    private List<Map<String, String>> getDefaultSortItems() {
        ArrayList<Map<String, String>> sortItems = new ArrayList<Map<String, String>>();
        HashMap<String, String> sortItem = new HashMap<String, String>();
        sortItem.put("fieldName", "asstActLongNumber");
        sortItem.put("fieldAlias", this.getResource("asstActLongNumber"));
        sortItem.put("selected", "true");
        sortItem.put("sortType", "");
        sortItems.add(sortItem);
        sortItem = new HashMap();
        sortItem.put("fieldName", "asstActLongName");
        sortItem.put("fieldAlias", this.getResource("asstActLongName"));
        sortItem.put("selected", "false");
        sortItem.put("sortType", "");
        sortItems.add(sortItem);
        sortItem = new HashMap();
        sortItem.put("fieldName", "accountNumber");
        sortItem.put("fieldAlias", this.getResource("accountNumber"));
        sortItem.put("selected", "true");
        sortItem.put("sortType", "");
        sortItems.add(sortItem);
        sortItem = new HashMap();
        sortItem.put("fieldName", "companyLongNumber");
        sortItem.put("fieldAlias", this.getResource("orgLongNumber"));
        sortItem.put("selected", "true");
        sortItem.put("sortType", "");
        sortItems.add(sortItem);
        sortItem = new HashMap();
        sortItem.put("fieldName", "companyLongName");
        sortItem.put("fieldAlias", this.getResource("companyLongName"));
        sortItem.put("selected", "false");
        sortItem.put("sortType", "");
        sortItems.add(sortItem);
        return sortItems;
    }

    @Override
    protected Object getParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.getSortOptions(param);
        return param;
    }

    protected void getSortOptions(Map<String, Object> params) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        List<Map<String, String>> defs = this.getDefaultSortItems();
        for (Map<String, String> sortItem : defs) {
            map.put(sortItem.get("fieldName"), sortItem);
        }
        ArrayList<Map> sortItems = new ArrayList<Map>();
        for (int i = 0; i < this.tblSort.getRowCount(); ++i) {
            Map def;
            String fieldName;
            IRow row = this.tblSort.getRow(i);
            Map sortItem = (Map)row.getUserObject();
            if (sortItem == null || (fieldName = (String)sortItem.get("fieldName")) == null || (def = (Map)map.get(fieldName)) == null) continue;
            def.remove("fieldAlias");
            Object val = row.getCell("selected").getValue();
            if (val instanceof Boolean) {
                def.put("selected", String.valueOf(val));
            } else {
                def.put("selected", "false");
            }
            val = row.getCell("sortType").getValue();
            if (val instanceof SorterSignEnum) {
                def.put("sortType", ((SorterSignEnum)val).getValue());
            } else {
                def.put("sortType", "");
            }
            sortItems.add(def);
        }
        params.put("sortItems", sortItems);
    }

    @Override
    protected void setParam(Object param) {
        if (param != null) {
            Map params = (Map)param;
            this.setSortOptions(params);
        }
    }

    protected void setSortOptions(Map<String, Object> params) {
        List sortItems = null;
        Object json = params.get("sortItems");
        if (json instanceof List) {
            sortItems = (List)json;
        } else if (json instanceof String) {
            sortItems = (List)JSON.parseObject((String)((String)json), List.class);
        }
        if (sortItems == null) {
            sortItems = this.getDefaultSortItems();
        }
        this.fillSortItems(sortItems);
    }

    private void fillSortItems(List<Map<String, String>> sortItems) {
        String fieldName;
        this.tblSort.removeRows();
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        List<Map<String, String>> defs = this.getDefaultSortItems();
        for (Map<String, String> sortItem : defs) {
            map.put(sortItem.get("fieldName"), sortItem);
        }
        ArrayList<Map<String, String>> prepares = new ArrayList<Map<String, String>>();
        HashSet<String> keys = new HashSet<String>();
        for (Map<String, String> sortItem : sortItems) {
            fieldName = sortItem.get("fieldName");
            Map def = (Map)map.get(fieldName);
            if (def == null) continue;
            keys.add(fieldName);
            def.put("selected", String.valueOf("true".equals(sortItem.get("selected"))));
            def.put("sortType", sortItem.get("sortType"));
            prepares.add(def);
        }
        for (Map<String, String> sortItem : defs) {
            fieldName = sortItem.get("fieldName");
            if (keys.contains(fieldName)) continue;
            prepares.add(sortItem);
        }
        for (Map<String, String> sortItem : prepares) {
            fieldName = sortItem.get("fieldName");
            String fieldAlias = sortItem.get("fieldAlias");
            IRow row = this.tblSort.addRow();
            row.setUserObject(sortItem);
            row.getCell("fieldName").setValue((Object)fieldAlias);
            row.getCell("fieldName").getStyleAttributes().setLocked(true);
            row.getCell("selected").setValue((Object)"true".equals(sortItem.get("selected")));
            this.fillSortType(row.getCell("sortType"), sortItem.get("sortType"));
        }
    }

    private void fillSortType(ICell cell, String value) {
        List list = GLNRptAsstActBalanceSortUI.getEnumList(SorterSignEnum.class.getName());
        Object[] array = list.toArray();
        Object[] temp = GLNRptAsstActBalanceSortUI.addObjectToArray(array, "");
        KDComboBox kdComboBox = new KDComboBox(temp);
        kdComboBox.setMaximumRowCount(10);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
        cell.setEditor((ICellEditor)kdtDefaultCellEditor);
        int index = 0;
        if (value != null) {
            value = value.trim();
            for (int i = 0; i < temp.length; ++i) {
                String val = temp[i] instanceof SorterSignEnum ? ((SorterSignEnum)temp[i]).getValue() : temp[i].toString();
                if (!value.equals(val)) continue;
                index = i;
                break;
            }
        }
        cell.setValue(temp[index]);
        kdComboBox.setSelectedIndex(index);
    }

    protected static List getEnumList(String enumpk) {
        MetaDataPK entityPK = MetaDataPK.create((String)enumpk);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        BizEnumInfo bizEnum = loader.getEnum((IMetaDataPK)entityPK);
        if (bizEnum.isDynamic()) {
            return DynamicEnum.getEnumList((String)enumpk);
        }
        return EnumUtils.getEnumList((String)enumpk);
    }

    protected static Object[] addObjectToArray(Object[] objects, Object insertObject) {
        Object[] DEFAULT_OBJECTs = new Object[]{insertObject};
        if (objects == null) {
            return DEFAULT_OBJECTs;
        }
        int length = objects.length;
        if (length == 0) {
            return DEFAULT_OBJECTs;
        }
        Object[] results = new Object[length + 1];
        results[0] = DEFAULT_OBJECTs[0];
        for (int i = 1; i <= length; ++i) {
            results[i] = objects[i - 1];
        }
        return results;
    }
}

