/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLNRptAsstActBalanceUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAsstActBalanceExportUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAsstActBalanceQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAsstActBalanceSortUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAsstactGDUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTable;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTableHelper;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.config.IObjectMultiPKBuilder;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.util.StringUtils;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;

public class GLNRptAsstActBalanceUI
extends AbstractGLNRptAsstActBalanceUI {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptAsstActBalanceUI.class);

    public GLNRptAsstActBalanceUI() throws Exception {
        this.init();
    }

    private void init() {
        this.txtConsole.setContentType("text/html");
        this.txtConsole.setEditable(false);
        StringBuffer htmlText = new StringBuffer();
        htmlText.append("<html>");
        htmlText.append("<body>");
        htmlText.append(this.getResource("detailsUsageInfo"));
        htmlText.append("<br>");
        htmlText.append("<a href=\"https://vip.kingdee.com/article/348055935727824128\">https://vip.kingdee.com/article/348055935727824128</a>");
        htmlText.append("<br>");
        htmlText.append("</body>");
        htmlText.append("</html>");
        this.txtConsole.setText(htmlText.toString());
        this.txtConsole.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(evt.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initPopMenu(GLNRptAsstActBalanceExportUI.class.getName());
    }

    protected void initListener() {
        super.initListener();
        this.getTable().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                if (GLNRptAsstActBalanceUI.this.innerSumTable != null) {
                    GLNRptAsstActBalanceUI.this.innerSumTable.setVisible(false);
                }
                if (GLNRptAsstActBalanceUI.this.innerSumTable != null && (GLNRptAsstActBalanceUI.this.getTable().getSelectManager().size() > 1 || e.getSelectBlock().getEndRow() - e.getSelectBlock().getBeginRow() > 0)) {
                    GLNRptAsstActBalanceUI.this.innerSumTable.selectRowSum(GLNRptAsstActBalanceUI.this.getTable().getSelectManager().getBlocks(), false);
                } else {
                    int rowIndex = e.getSelectBlock().getTop();
                    GLNRptAsstActBalanceUI.this.tblMain_doSelectChanged(rowIndex);
                }
            }
        });
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        GLNRptAsstActBalanceUI.this.tblMain_doDoubleClicked();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    GLNRptAsstActBalanceUI.this.handleError(ex);
                }
            }
        });
    }

    @Override
    protected GLNRptBaseQueryUI getCustQueryPanel() throws Exception {
        return new GLNRptAsstActBalanceQueryUI();
    }

    @Override
    protected GLNRptBaseQueryUI getCustSortPanel() throws Exception {
        GLNRptAsstActBalanceSortUI ui = new GLNRptAsstActBalanceSortUI();
        ui.setPanelName(this.getResource("Sort"));
        return ui;
    }

    @Override
    protected void setQueryDialogSize(CommonQueryDialog dialog) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        int width = screen.width - insets.left - insets.right;
        if ((width -= 300) > 1080) {
            width = 1080;
        }
        int height = screen.height - insets.top - insets.bottom;
        if ((height -= 90) > 670) {
            height = 670;
        }
        dialog.setWidth(width);
        dialog.setHeight(height);
    }

    @Override
    public int getColumnWidthByColumnName(String colName) {
        return super.getColumnWidthByColumnName(colName);
    }

    @Override
    public void setRptType(Map<String, Object> queryConfig) {
        super.setRptType(queryConfig);
        List sortItems = null;
        Object obj = queryConfig.get("sortItems");
        if (obj instanceof List) {
            sortItems = (List)obj;
        } else if (obj instanceof String) {
            sortItems = (List)JSON.parseObject((String)((String)obj), List.class);
        }
        ArrayList newItems = new ArrayList();
        if (sortItems != null && sortItems.size() > 0) {
            for (Map sortItem : sortItems) {
                if (sortItem.containsKey("selected") && !"true".equalsIgnoreCase((String)sortItem.get("selected"))) continue;
                HashMap newItem = new HashMap();
                newItem.putAll(sortItem);
                newItem.remove("selected");
                newItems.add(newItem);
            }
        }
        queryConfig.put("sortItems", newItems);
        queryConfig.put("showAsstActId", "true");
        queryConfig.put("rptType", "AsstActBalance");
    }

    @Override
    protected String getTotalColumn() {
        return "asstActNumber1";
    }

    @Override
    public void actionAsstactGD_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        try {
            this.setCursorOfWair();
            this.findAsstactGD();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    @Override
    protected void setQueryingActionStatus(boolean enable) {
        super.setQueryingActionStatus(enable);
        this.actionAsstactGD.setEnabled(false);
    }

    public void tblMain_doSelectChanged(int rowIndex) {
        this.actionAsstactGD.setEnabled(false);
        if (Boolean.parseBoolean((String)this.queryConfig.get("showBizCode"))) {
            return;
        }
        String orgTreeId = (String)this.queryConfig.get("orgTreeId");
        String sumByUnion = (String)this.queryConfig.get("sumByUnion");
        if (orgTreeId != null && orgTreeId.length() > 0 && sumByUnion != null && "true".equals(sumByUnion)) {
            return;
        }
        IRow row = this.getTable().getRow(rowIndex);
        if (row != null) {
            String asstActId1 = (String)row.getCell("asstActId1").getValue();
            this.actionAsstactGD.setEnabled(asstActId1 != null && asstActId1.trim().length() > 0);
        }
    }

    public void tblMain_doDoubleClicked() {
        if (this.btnAsstactGD.isEnabled()) {
            try {
                this.setCursorOfWair();
                this.findAsstactGD();
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handleError(e);
            }
        }
    }

    private void findAsstactGD() throws BOSException, EASBizException {
        Object value;
        ICell cell;
        int rowIndex = KDTableUtil.getSelectedTop((KDTable)this.getTable());
        IRow row = this.getTable().getRow(rowIndex);
        HashMap<String, Object> queryConfig = new HashMap<String, Object>();
        queryConfig.putAll(this.queryConfig);
        String companyNumber = (String)row.getCell("companyNumber").getValue();
        if (!StringUtils.isEmpty((String)companyNumber)) {
            queryConfig.put("companyNumber", this.getLinkedCompanyNumber(companyNumber));
        }
        CurrencyInfo currency = null;
        String currencyNumber = (String)this.getTable().queryConfig.get("currencyNumber");
        if ((currencyNumber == null || currencyNumber.length() == 0) && (cell = row.getCell("currencyNumber")) != null) {
            currencyNumber = (String)cell.getValue();
        }
        if (currencyNumber != null && currencyNumber.length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
            if (coll.size() > 0) {
                currency = coll.get(0);
            }
        }
        if (currency != null) {
            queryConfig.put("currencyNumber", currency.getNumber());
        } else {
            String currencyName;
            cell = row.getCell("currencyName");
            if (cell != null && (currencyName = (String)cell.getValue()) != null && currencyName.length() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)currencyName));
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                view.setSelector(selector);
                CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
                if (coll.size() > 0) {
                    currency = coll.get(0);
                }
            }
            if (currency != null) {
                queryConfig.put("currencyNumber", currency.getNumber());
            }
        }
        String accountNumber = (String)row.getCell("accountNumber").getValue();
        String accountLevel = null;
        ICell cell2 = row.getCell("accountLevel");
        if (cell2 != null && (value = cell2.getValue()) != null && value.toString().trim().length() > 0) {
            try {
                int i = Integer.parseInt(value.toString().trim());
                if (i > 0) {
                    accountLevel = String.valueOf(i);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)accountNumber)) {
            String str = (String)queryConfig.get("accountNumber");
            if (str != null && str.trim().length() > 0) {
                String[] ss;
                StringBuffer numbers = new StringBuffer();
                for (String s : ss = str.split(";")) {
                    if (!(s = s.trim()).startsWith(accountNumber) || s.length() <= accountNumber.length()) continue;
                    numbers.append(s).append(";");
                }
                if (numbers.length() > 0) {
                    queryConfig.put("accountNumber", numbers.toString());
                } else {
                    queryConfig.put("accountNumber", accountNumber);
                }
            } else {
                queryConfig.put("accountNumber", accountNumber);
            }
            queryConfig.put("showPeriodSum", "true");
            queryConfig.put("showYearSum", "true");
            if (accountLevel == null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
                if (!StringUtils.isEmpty((String)companyNumber)) {
                    filter.getFilterItems().add(new FilterItemInfo("companyID.number", (Object)companyNumber));
                }
                if (queryConfig.get("accountTableNumber") != null) {
                    filter.getFilterItems().add(new FilterItemInfo("accountTableID.number", queryConfig.get("accountTableNumber")));
                }
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("level");
                view.setSelector(selector);
                AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
                if (coll.size() > 0) {
                    accountLevel = String.valueOf(coll.get(0).getLevel());
                }
            }
            if (accountLevel == null) {
                accountLevel = "1";
            }
            queryConfig.put("toAccountLevel", accountLevel);
            ArrayList asstActTypes = new ArrayList();
            List curAsstActTypes = (List)this.getTable().queryConfig.get("asstActTypes");
            queryConfig.put("asstActTypes", asstActTypes);
            for (int i = 0; i < curAsstActTypes.size(); ++i) {
                Map curAsstActType = (Map)curAsstActTypes.get(i);
                String type = ((String)curAsstActType.get("type")).toString();
                String displayMode = ((String)curAsstActType.get("displayMode")).toString();
                if (type == null || (cell2 = row.getCell("asstActId" + (i + 1))) == null) continue;
                String asstActId = null;
                Object v = cell2.getValue();
                if (v != null && v.toString().trim().length() > 0) {
                    asstActId = v.toString().trim();
                }
                String asstActNumber = null;
                cell2 = row.getCell("asstActNumber" + (i + 1));
                if (cell2 != null && (v = cell2.getValue()) != null && v.toString().trim().length() > 0) {
                    asstActNumber = v.toString().trim();
                }
                String asstActLongNumber = null;
                cell2 = row.getCell("asstActLongNumber" + (i + 1));
                if (cell2 != null && (v = cell2.getValue()) != null && v.toString().trim().length() > 0) {
                    asstActLongNumber = v.toString().trim();
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)type));
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("asstHGAttribute");
                selector.add("isMultilevel");
                selector.add("groupTableName");
                selector.add("glAsstActTypeGrp.id");
                view.setSelector(selector);
                AsstActTypeCollection coll = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection(view);
                if (coll.size() <= 0) continue;
                AsstActTypeInfo aat = coll.get(0);
                HashMap<String, String> asstActType = new HashMap<String, String>(curAsstActType);
                asstActTypes.add(asstActType);
                if (CollectEnum.LEVEL.getAlias().equals(displayMode) || CollectEnum.LEVEL.getName().equals(displayMode) || "customer".equals(aat.getAsstHGAttribute()) || "provider".equals(aat.getAsstHGAttribute()) || "material".equals(aat.getAsstHGAttribute())) {
                    CSSPGroupStandardInfo st;
                    CSSPGroupCollection col;
                    String standard = null;
                    if ("customer".equals(aat.getAsstHGAttribute()) || "provider".equals(aat.getAsstHGAttribute())) {
                        view = new EntityViewInfo();
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)asstActId));
                        view.setFilter(filter);
                        selector = new SelectorItemCollection();
                        selector.add("id");
                        selector.add("groupStandard.number");
                        view.setSelector(selector);
                        col = CSSPGroupFactory.getRemoteInstance().getCSSPGroupCollection(view);
                        if (col.size() > 0 && (st = col.get(0).getGroupStandard()) != null) {
                            standard = st.getNumber();
                        }
                    } else if ("material".equals(aat.getAsstHGAttribute())) {
                        view = new EntityViewInfo();
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)asstActId));
                        view.setFilter(filter);
                        selector = new SelectorItemCollection();
                        selector.add("id");
                        selector.add("groupStandard.number");
                        view.setSelector(selector);
                        col = MaterialGroupFactory.getRemoteInstance().getMaterialGroupCollection(view);
                        if (col.size() > 0 && (st = col.get(0).getGroupStandard()) != null) {
                            standard = st.getNumber();
                        }
                    }
                    if (standard != null) {
                        asstActType.put("standard", standard);
                        asstActType.put("group", asstActNumber);
                        continue;
                    }
                }
                if (aat.getGlAsstActTypeGrp() != null) {
                    if (asstActLongNumber != null && asstActLongNumber.length() > 0) {
                        asstActNumber = asstActLongNumber.replaceAll("!", ".");
                    } else if (asstActId != null && asstActId.length() > 0) {
                        view = new EntityViewInfo();
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)asstActId));
                        view.setFilter(filter);
                        selector = new SelectorItemCollection();
                        selector.add("id");
                        selector.add("longNumber");
                        view.setSelector(selector);
                        GeneralAsstActTypeCollection col = GeneralAsstActTypeFactory.getRemoteInstance().getGeneralAsstActTypeCollection(view);
                        if (col.size() > 0) {
                            asstActNumber = col.get(0).getLongNumber().replace("!", ".");
                        }
                    }
                }
                if (asstActNumber == null || asstActNumber.length() <= 0) {
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("asstActType", aat);
                    aat.put("ignoreFilter", (Object)true);
                    HashSet<String> ids = new HashSet<String>();
                    ids.add(asstActId);
                    m.put("asstActIds", ids);
                    Map r = GLGeneralFacadeFactory.getRemoteInstance().findAsstActs(m);
                    Object o = r.get(asstActId);
                    if (o instanceof DataBaseInfo) {
                        asstActNumber = ((DataBaseInfo)o).getNumber();
                    }
                }
                if (asstActNumber == null || asstActNumber.length() <= 0) continue;
                HashSet<String> numbers = new HashSet<String>();
                String strNumbers = (String)asstActType.get("number");
                if (strNumbers != null && strNumbers.length() > 0) {
                    String[] ss = strNumbers.split(";");
                    for (String s : ss) {
                        if (s.trim().length() <= 0) continue;
                        numbers.add(s.trim().replace("!", "."));
                    }
                }
                if (numbers.size() == 0) {
                    asstActType.put("number", asstActNumber);
                    continue;
                }
                if ((CollectEnum.LEVEL.getAlias().equals(displayMode) || CollectEnum.LEVEL.getName().equals(displayMode)) && aat.isIsMultilevel()) {
                    if ("customer".equals(aat.getAsstHGAttribute()) || "provider".equals(aat.getAsstHGAttribute()) || "material".equals(aat.getAsstHGAttribute())) {
                        asstActType.put("number", asstActNumber);
                        continue;
                    }
                    if (aat.getGlAsstActTypeGrp() != null) {
                        HashSet<String> sons = new HashSet<String>();
                        for (String number : numbers) {
                            if (!number.startsWith(asstActNumber + ".")) continue;
                            sons.add(number);
                        }
                        if (sons.size() > 0) {
                            asstActNumber = "";
                            for (String number : sons) {
                                asstActNumber = asstActNumber + number + ";";
                            }
                        }
                        asstActType.put("number", asstActNumber);
                        continue;
                    }
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("asstActType", aat);
                    aat.put("ignoreFilter", (Object)true);
                    HashSet<String> asstActNumbers = new HashSet<String>();
                    asstActNumbers.addAll(numbers);
                    asstActNumbers.add(asstActNumber);
                    m.put("asstActNumbers", asstActNumbers);
                    Map r = GLGeneralFacadeFactory.getRemoteInstance().findAsstActs(m);
                    asstActLongNumber = null;
                    Object o = r.get(asstActNumber);
                    if (o instanceof DataBaseInfo) {
                        asstActLongNumber = (String)((DataBaseInfo)o).get("longNumber");
                    }
                    if (asstActLongNumber != null && asstActLongNumber.length() > 0) {
                        HashMap<String, String> longNumbers = new HashMap<String, String>();
                        for (String number : numbers) {
                            String longNumber;
                            o = r.get(number);
                            if (!(o instanceof DataBaseInfo) || (longNumber = (String)((DataBaseInfo)o).get("longNumber")) == null) continue;
                            longNumbers.put(number, longNumber);
                        }
                        if (longNumbers.size() > 0) {
                            HashSet<String> sons = new HashSet<String>();
                            for (String number : longNumbers.keySet()) {
                                if (!((String)longNumbers.get(number)).startsWith(asstActLongNumber + "!")) continue;
                                sons.add(number);
                            }
                            if (sons.size() > 0) {
                                asstActNumber = "";
                                for (String number : sons) {
                                    asstActNumber = asstActNumber + number + ";";
                                }
                            }
                            asstActType.put("number", asstActNumber);
                            continue;
                        }
                        asstActType.put("number", asstActNumber);
                        continue;
                    }
                    asstActType.put("number", asstActNumber);
                    continue;
                }
                asstActType.put("number", asstActNumber);
            }
            this.joinQuery(queryConfig, GLNRptAsstactGDUI.class.getName());
        }
    }

    @Override
    protected Map<String, Object> getSearchParams(int type) {
        Map<String, Object> params = super.getSearchParams(type);
        params.put("showRemoteSearch", "true");
        return params;
    }

    @Override
    protected List<Map<String, String>> getSearchTargets(int type) {
        ArrayList<Map<String, String>> targets = new ArrayList<Map<String, String>>();
        GLNRptTable table = this.getTable();
        if (table == null) {
            return targets;
        }
        HashSet<String> names = new HashSet<String>();
        names.add("asstActNumber1");
        names.add("asstActLongNumber1");
        names.add("asstActName1");
        names.add("asstActLongName1");
        names.add("asstActNumber2");
        names.add("asstActLongNumber2");
        names.add("asstActName2");
        names.add("asstActLongName2");
        names.add("asstActNumber3");
        names.add("asstActLongNumber3");
        names.add("asstActName3");
        names.add("asstActLongName3");
        names.add("asstActNumber4");
        names.add("asstActLongNumber4");
        names.add("asstActName4");
        names.add("asstActLongName4");
        names.add("asstActNumber5");
        names.add("asstActLongNumber5");
        names.add("asstActName5");
        names.add("asstActLongName5");
        names.add("asstActNumber6");
        names.add("asstActLongNumber6");
        names.add("asstActName6");
        names.add("asstActLongName6");
        names.add("asstActNumber7");
        names.add("asstActLongNumber7");
        names.add("asstActName7");
        names.add("asstActLongName7");
        names.add("asstActNumber8");
        names.add("asstActLongNumber8");
        names.add("asstActName8");
        names.add("asstActLongName8");
        names.add("companyNumber");
        names.add("companyLongNumber");
        names.add("companyName");
        names.add("accountNumber");
        names.add("accountName");
        names.add("accountLongName");
        names.add("currencyNumber");
        names.add("currencyName");
        names.add("beginBalanceFor");
        names.add("beginBalanceDebitFor");
        names.add("beginBalanceCreditFor");
        names.add("debitFor");
        names.add("creditFor");
        names.add("endBalanceFor");
        names.add("endBalanceDebitFor");
        names.add("endBalanceCreditFor");
        names.add("beginBalanceLocal");
        names.add("beginBalanceDebitLocal");
        names.add("beginBalanceCreditLocal");
        names.add("debitLocal");
        names.add("creditLocal");
        names.add("endBalanceLocal");
        names.add("endBalanceDebitLocal");
        names.add("endBalanceCreditLocal");
        names.add("beginBalanceRpt");
        names.add("beginBalanceDebitRpt");
        names.add("beginBalanceCreditRpt");
        names.add("debitRpt");
        names.add("creditRpt");
        names.add("endBalanceRpt");
        names.add("endBalanceDebitRpt");
        names.add("endBalanceCreditRpt");
        HashSet<Integer> selectedIndexs = new HashSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            KDTSelectBlock block = table.getSelectManager().get(i);
            if (block.getMode() != 1 && block.getMode() != 15 && block.getMode() != 4 && block.getMode() != 12) continue;
            for (int j = block.getLeft(); j <= block.getRight(); ++j) {
                selectedIndexs.add(j);
            }
        }
        IRow headRow = null;
        if (table.getHeadRowCount() > 0) {
            headRow = table.getHeadRow(table.getHeadRowCount() - 1);
        }
        for (int columIndex = 0; columIndex < table.getColumnCount(); ++columIndex) {
            Object title;
            ICell cell;
            String key;
            IColumn col = table.getColumn(columIndex);
            if (col == null || col.getStyleAttributes().isHided() || (key = col.getKey()) == null || !names.contains(key)) continue;
            HashMap<String, String> target = new HashMap<String, String>();
            target.put("name", key);
            if (key.startsWith("asstActNumber")) {
                target.put("title", "asstActNumber" + key.substring(13));
                if (headRow != null && (cell = headRow.getCell(columIndex)) != null && (title = cell.getValue()) != null) {
                    target.put("title", title.toString());
                }
            } else if (key.startsWith("asstActLongNumber")) {
                target.put("title", "asstActLongNumber" + key.substring(13));
                if (headRow != null && (cell = headRow.getCell(columIndex)) != null && (title = cell.getValue()) != null) {
                    target.put("title", title.toString());
                }
            } else if (key.startsWith("asstActName")) {
                target.put("title", this.getResource("asstAct") + key.substring(11));
                if (headRow != null && (cell = headRow.getCell(columIndex)) != null && (title = cell.getValue()) != null) {
                    target.put("title", title.toString());
                }
            } else if (key.startsWith("asstActLongName")) {
                target.put("title", this.getResource("asstAct") + key.substring(11));
                if (headRow != null && (cell = headRow.getCell(columIndex)) != null && (title = cell.getValue()) != null) {
                    target.put("title", title.toString());
                }
            } else {
                target.put("title", this.getResource(key));
            }
            if (type == 1) {
                if (selectedIndexs.contains(columIndex)) {
                    target.put("selected", "true");
                } else {
                    target.put("selected", "false");
                }
            } else if (type == 2 && selectedIndexs.contains(columIndex)) {
                target.put("selected", "true");
            }
            targets.add(target);
        }
        return targets;
    }

    @Override
    public Object getTablePreferenceSchemaKey() {
        Object key = super.getTablePreferenceSchemaKey();
        Object showYear = this.queryConfig.get("showYear");
        Object showAsstActName = this.queryConfig.get("showAsstActName");
        Object showAsstActNumber = this.queryConfig.get("showAsstActNumber");
        Object showAsstActLongNumber = this.queryConfig.get("showAsstActLongNumber");
        Object showAsstActLongName = this.queryConfig.get("showAsstActLongName");
        return key + "||" + showYear + "||" + showAsstActName + "||" + showAsstActNumber + "||" + showAsstActLongNumber + "||" + showAsstActLongName;
    }

    protected void initHelper() {
        this.tHelperPrint = this.tHelper = new GLNRptTableHelper(this, new IObjectMultiPKBuilder(){

            public IObjectPK buildPK() {
                return GLNRptAsstActBalanceUI.this.buildPK();
            }
        });
    }

    @Override
    protected String getExportPermissionItem() {
        return "gln_rptasstact_xbalance_entity_export";
    }
}

