/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLNRptAsstactGDQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class GLNRptAsstactGDQueryUI
extends AbstractGLNRptAsstactGDQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptAsstactGDQueryUI.class);
    private boolean changeAsstAccount = true;
    private DataChangeListener fromAccountListener = null;
    private DataChangeListener toAccountListener = null;
    DataChangeListener companyListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                GLNRptAsstactGDQueryUI.this.companyDataChange();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                GLNRptAsstactGDQueryUI.this.handUIException(ex);
            }
            Object object = GLNRptAsstactGDQueryUI.this.promptCompany.getValue();
            if (object != null) {
                GLNRptAsstactGDQueryUI.this.promptOrgTree.setValue(null);
                GLNRptAsstactGDQueryUI.this.promptUnion.setValue(null);
            }
        }
    };
    DataChangeListener periodTypeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                GLNRptAsstactGDQueryUI.this.periodTypeDataChange();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                GLNRptAsstactGDQueryUI.this.handUIException(ex);
            }
        }
    };
    DataChangeListener tableListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                GLNRptAsstactGDQueryUI.this.tableDataChange();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                GLNRptAsstactGDQueryUI.this.handUIException(ex);
            }
        }
    };
    DataChangeListener orgTreeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                GLNRptAsstactGDQueryUI.this.orgTreeChange();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                GLNRptAsstactGDQueryUI.this.handUIException(ex);
            }
        }
    };
    DataChangeListener unionListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                GLNRptAsstactGDQueryUI.this.unionChange();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                GLNRptAsstactGDQueryUI.this.handUIException(ex);
            }
        }
    };
    DataChangeListener asstAccountListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            GLNRptAsstactGDQueryUI.this.asstAccountChanged();
        }
    };

    protected void orgTreeChange() throws EASBizException, BOSException {
        OrgTreeInfo tree = null;
        Object object = this.promptOrgTree.getValue();
        if (object instanceof OrgTreeInfo) {
            tree = (OrgTreeInfo)object;
        }
        this.promptUnion.setValue(null);
        this.initUnion(tree);
        if (tree != null) {
            this.promptCompany.removeDataChangeListener(this.companyListener);
            try {
                this.promptCompany.setValue((Object)this.getCompanysByOrgTree(tree.getId().toString()));
                this.companyDataChange();
            }
            finally {
                this.promptCompany.addDataChangeListener(this.companyListener);
            }
        }
    }

    protected void unionChange() throws EASBizException, BOSException {
        this.periodTypeDataChange();
    }

    protected void asstAccountChanged() {
        if (!this.changeAsstAccount) {
            return;
        }
        this.fillTableAsstType();
    }

    protected void initUnion(OrgTreeInfo tree) {
        if (tree != null) {
            EntityViewInfo unionView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("ot.id", (Object)tree.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("os.isLeaf", (Object)0));
            unionView.setFilter(filter);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo si = new SorterItemInfo("longNumber");
            si.setSortType(SortType.ASCEND);
            sorter.add(si);
            unionView.setSorter(sorter);
            this.promptUnion.setEntityViewInfo(unionView);
        } else {
            EntityViewInfo unionView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("ot.id", (Object)"no"));
            filter.getFilterItems().add(new FilterItemInfo("os.isLeaf", (Object)0));
            unionView.setFilter(filter);
            this.promptUnion.setEntityViewInfo(unionView);
        }
    }

    public GLNRptAsstactGDQueryUI() throws Exception {
        this.init();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.remove((Component)this.kDPanel1);
        this.setLayout(new BorderLayout());
        this.kDPanel1.setPreferredSize(new Dimension(1000, 684));
        KDScrollPane sp = new KDScrollPane((Component)this.kDPanel1);
        sp.getVerticalScrollBar().setUnitIncrement(10);
        sp.getHorizontalScrollBar().setUnitIncrement(10);
        this.add((Component)sp, "Center");
    }

    private void init() {
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected;
                boolean bl = selected = e.getStateChange() == 1;
                if (selected) {
                    if (GLNRptAsstactGDQueryUI.this.rbNotShowZero != e.getSource()) {
                        GLNRptAsstactGDQueryUI.this.rbNotShowZero.setSelected(false);
                    }
                    if (GLNRptAsstactGDQueryUI.this.rbNotShowNoCurrent != e.getSource()) {
                        GLNRptAsstactGDQueryUI.this.rbNotShowNoCurrent.setSelected(false);
                    }
                    if (GLNRptAsstactGDQueryUI.this.rbNotShowZeroAndNoCurrent != e.getSource()) {
                        GLNRptAsstactGDQueryUI.this.rbNotShowZeroAndNoCurrent.setSelected(false);
                    }
                    if (GLNRptAsstactGDQueryUI.this.rbNotShowNoYear != e.getSource()) {
                        GLNRptAsstactGDQueryUI.this.rbNotShowNoYear.setSelected(false);
                    }
                    if (GLNRptAsstactGDQueryUI.this.rbNotShowZeroAndNoYear != e.getSource()) {
                        GLNRptAsstactGDQueryUI.this.rbNotShowZeroAndNoYear.setSelected(false);
                    }
                }
            }
        };
        this.rbNotShowZero.addItemListener(il);
        this.rbNotShowNoCurrent.addItemListener(il);
        this.rbNotShowZeroAndNoCurrent.addItemListener(il);
        this.rbNotShowNoYear.addItemListener(il);
        this.rbNotShowZeroAndNoYear.addItemListener(il);
        this.promptPeriodType.setEditable(true);
        this.promptPeriodType.setEditFormat("$number$");
        this.promptPeriodType.setCommitFormat("$number$;$name$");
        this.promptPeriodType.setDisplayFormat("$name$");
        this.promptCurrency.setEditable(true);
        this.promptCurrency.setEditFormat("$number$");
        this.promptCurrency.setCommitFormat("$number$;$name$");
        this.promptCurrency.setDisplayFormat("$name$");
        this.promptAccountTable.setEditable(true);
        this.promptAccountTable.setEditFormat("$number$");
        this.promptAccountTable.setCommitFormat("$number$;$name$");
        this.promptAccountTable.setDisplayFormat("$name$");
        this.promptAccountTable.addCommonF7KDTableListener(this.accountTableF7ColumnListener);
        this.prmptAccount.setEditFormat("$number$");
        this.prmptAccount.setCommitFormat("$helpCode$;$name$;$number$");
        this.prmptAccount.setDisplayFormat("$number$ - $name$");
        this.prmptAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prmptAccount.setCommitParser((IParser)new AccountViewParser(this.prmptAccount));
        this.prmptAccount.setEnabledMultiSelection(true);
        this.prmptFromAccount.setEditFormat("$number$");
        this.prmptFromAccount.setCommitFormat("$helpCode$;$name$;$number$");
        this.prmptFromAccount.setDisplayFormat("$number$ - $name$");
        this.prmptFromAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prmptFromAccount.setCommitParser((IParser)new AccountViewParser(this.prmptFromAccount));
        this.fromAccountListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                AccountViewInfo fromAccount = (AccountViewInfo)GLNRptAsstactGDQueryUI.this.prmptFromAccount.getValue();
                AccountViewInfo toAccount = (AccountViewInfo)GLNRptAsstactGDQueryUI.this.prmptToAccount.getValue();
                if (fromAccount != null && toAccount == null) {
                    toAccount = fromAccount;
                    GLNRptAsstactGDQueryUI.this.prmptToAccount.removeDataChangeListener(GLNRptAsstactGDQueryUI.this.toAccountListener);
                    GLNRptAsstactGDQueryUI.this.prmptToAccount.setValue((Object)toAccount);
                    GLNRptAsstactGDQueryUI.this.prmptToAccount.addDataChangeListener(GLNRptAsstactGDQueryUI.this.toAccountListener);
                }
                if (fromAccount != null) {
                    GLNRptAsstactGDQueryUI.this.prmptAccount.setValue(null);
                }
                GLNRptAsstactGDQueryUI.this.initAccount(fromAccount, toAccount);
            }
        };
        this.prmptFromAccount.addDataChangeListener(this.fromAccountListener);
        this.prmptToAccount.setEditFormat("$number$");
        this.prmptToAccount.setCommitFormat("$helpCode$;$name$;$number$");
        this.prmptToAccount.setDisplayFormat("$number$ - $name$");
        this.prmptToAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prmptToAccount.setCommitParser((IParser)new AccountViewParser(this.prmptToAccount));
        this.toAccountListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                AccountViewInfo fromAccount = (AccountViewInfo)GLNRptAsstactGDQueryUI.this.prmptFromAccount.getValue();
                AccountViewInfo toAccount = (AccountViewInfo)GLNRptAsstactGDQueryUI.this.prmptToAccount.getValue();
                if (toAccount != null) {
                    GLNRptAsstactGDQueryUI.this.prmptAccount.setValue(null);
                }
                GLNRptAsstactGDQueryUI.this.initAccount(fromAccount, toAccount);
            }
        };
        this.prmptToAccount.addDataChangeListener(this.toAccountListener);
        this.promptVoucherType.setEditable(true);
        this.promptVoucherType.setEditFormat("$number$");
        this.promptVoucherType.setCommitFormat("$number$;$name$");
        this.promptVoucherType.setDisplayFormat("$name$");
        this.spThreadCount.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 64, 1));
        this.promptCompany.setEditFormat("$number$");
        this.promptCompany.setCommitFormat("$name$;$number$");
        this.promptCompany.setDisplayFormat("$name$");
        this.promptCompany.setQueryInfo("com.kingdee.eas.fi.gl.app.F7CompanyOrgUnitQuery");
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.promptCompany.setEntityViewInfo(companyView);
        this.promptCompany.setSelector(this.getCompanySelector());
        this.promptCompany.setEditable(true);
        CompanyDisplayModeEnum[] items = new CompanyDisplayModeEnum[]{CompanyDisplayModeEnum.details, CompanyDisplayModeEnum.enumerate};
        this.cbCompanyDisplayMode.addItems((Object[])items);
        this.promptOrgTree.setEditFormat("$number$");
        this.promptOrgTree.setCommitFormat("$name$;$number$");
        this.promptOrgTree.setDisplayFormat("$name$ $startDate$");
        this.promptOrgTree.setQueryInfo("com.kingdee.eas.basedata.org.app.OrgTreeQuery");
        EntityViewInfo orgTreeView = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)8));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)-1, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("layerType", (Object)1));
        orgTreeView.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo si = new SorterItemInfo("number");
        si.setSortType(SortType.ASCEND);
        sorter.add(si);
        si = new SorterItemInfo("startDate");
        si.setSortType(SortType.DESCEND);
        sorter.add(si);
        orgTreeView.setSorter(sorter);
        this.promptOrgTree.setEntityViewInfo(orgTreeView);
        this.promptOrgTree.setEditable(true);
        this.promptOrgTree.setHasCUDefaultFilter(false);
        this.promptUnion.setEditFormat("$number$");
        this.promptUnion.setCommitFormat("$name$;$number$");
        this.promptUnion.setDisplayFormat("$name$");
        this.promptUnion.setQueryInfo("com.kingdee.eas.fi.gl.app.UnionStructureQuery");
        this.promptUnion.setEnabledMultiSelection(true);
        this.promptUnion.setEditable(true);
        this.promptUnion.setHasCUDefaultFilter(false);
        this.cbUsePreparedSpliter.setSelected(false);
        this.cbUsePreparedSpliter.setVisible(false);
        this.rbNotShowZeroAndNoCurrent.setSelected(true);
        this.rbNotShowNoYear.setVisible(false);
        this.rbNotShowZeroAndNoYear.setVisible(false);
        this.initAdvanceOptions();
        this.kDLabelContainer12.setVisible(false);
        this.cbCompress.setVisible(false);
        this.cbShowRequest.setVisible(false);
        this.lbExtends.setVisible(false);
        this.promptCompany.addDataChangeListener(this.companyListener);
        this.promptAccountTable.addDataChangeListener(this.tableListener);
        this.promptPeriodType.addDataChangeListener(this.periodTypeListener);
        this.promptOrgTree.addDataChangeListener(this.orgTreeListener);
        this.promptUnion.addDataChangeListener(this.unionListener);
        this.initAsstAccount(this.promptAsstAccount);
        this.promptAsstAccount.addDataChangeListener(this.asstAccountListener);
        Vector<String> v = new Vector<String>();
        v.add("");
        v.add((String)EntryDC.DEBIT);
        v.add((String)EntryDC.CREDIT);
        this.cbEntryDC.setModel(new DefaultComboBoxModel(v));
        this.tfRecordMinAmount.setDataType(1);
        this.tfRecordMinAmount.setHorizontalAlignment(4);
        this.tfRecordMinAmount.setDataVerifierType(-1);
        this.tfRecordMinAmount.setSupportedEmpty(true);
        this.tfRecordMinAmount.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        this.tfRecordMinAmount.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.tfRecordMaxAmount.setDataType(1);
        this.tfRecordMaxAmount.setHorizontalAlignment(4);
        this.tfRecordMaxAmount.setDataVerifierType(-1);
        this.tfRecordMaxAmount.setSupportedEmpty(true);
        this.tfRecordMaxAmount.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        this.tfRecordMaxAmount.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.cbShowCompanyLevel.setVisible(false);
        this.cbShowCompanyBizUnit.setVisible(false);
        this.cbShowAccountDc.setVisible(false);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected void initDefaultSetting() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.promptCompany.removeDataChangeListener(this.companyListener);
        this.changeAsstAccount = false;
        this.promptCompany.setValue((Object)new CompanyOrgUnitInfo[]{company});
        this.promptOrgTree.setValue(null);
        this.promptUnion.setValue(null);
        this.prmptFromAccount.setValue(null);
        this.prmptToAccount.setValue(null);
        this.prmptAccount.setValue(null);
        this.companyDataChange();
        this.promptCompany.addDataChangeListener(this.companyListener);
        this.initUnion(null);
        this.cbCompanyDisplayMode.setSelectedIndex(0);
        this.promptAsstAccount.setValue(null);
        this.asstactAndAccount.setSelected(true);
        this.onlyAsstact.setSelected(false);
        this.changeAsstAccount = true;
        this.asstAccountChanged();
        this.cbBalType.setSelected(true);
        this.cbNotIncludePLVoucher.setSelected(false);
        this.cbShowAsstActNumber.setSelected(true);
        this.cbShowAsstActLongNumber.setSelected(false);
        this.cbShowAsstActLongName.setSelected(false);
        this.promptVoucherType.setValue(null);
        this.tfVoucherNumber.setText("");
        this.tfFromVoucherNumber.setText("");
        this.tfToVoucherNumber.setText("");
        this.tfFromBookedDate.setValue(null);
        this.tfToBookedDate.setValue(null);
        this.tfFromBizDate.setValue(null);
        this.tfToBizDate.setValue(null);
        this.tfSourceSys.setText("");
        this.tfSourceType.setText("");
        this.tfCreator.setText("");
        this.tfAuditor.setText("");
        this.tfPoster.setText("");
        this.tfCashier.setText("");
        this.tfDescription.setText("");
        this.tfRecordDescription.setText("");
        this.cbEntryDC.setSelectedIndex(0);
        this.tfRecordMinAmount.setValue(null);
        this.tfRecordMaxAmount.setValue(null);
        this.cbUsePreparedSpliter.setSelected(false);
        this.rbNotShowZero.setSelected(false);
        this.rbNotShowNoCurrent.setSelected(false);
        this.rbNotShowZeroAndNoCurrent.setSelected(false);
        this.rbNotShowNoYear.setSelected(false);
        this.rbNotShowZeroAndNoYear.setSelected(false);
        this.cbShowFor.setSelected(true);
        this.cbShowLocal.setSelected(false);
        this.cbShowRpt.setSelected(false);
        this.cbShowPeriodSum.setSelected(true);
        this.cbShowYearSum.setSelected(true);
        this.cbShowQty.setSelected(false);
        this.cbShowByMU.setSelected(false);
        this.cbShowByAccountDc.setSelected(false);
        this.cbShowCompanyLongNumber.setSelected(false);
        this.cbShowCompanyLevel.setSelected(false);
        this.cbShowCompanyName.setSelected(true);
        this.cbShowCompanyBizUnit.setSelected(false);
        this.cbShowCurrencyNumber.setSelected(false);
        this.cbShowCurrencyName.setSelected(true);
        this.cbShowAccountName.setSelected(true);
        this.cbShowAccountDc.setSelected(false);
        this.cbUpdateBalance.setSelected(false);
        this.spThreadCount.setValue((Object)1);
        this.cbCompress.setSelected(true);
        this.cbShowRequest.setSelected(false);
        this.txtExtends.setText("");
    }

    @Override
    protected void kdUp_actionPerformed(ActionEvent e) throws Exception {
        this.tblAsstMoveRow(this.tblAsst, -1);
    }

    @Override
    protected void kdDown_actionPerformed(ActionEvent e) throws Exception {
        this.tblAsstMoveRow(this.tblAsst, 1);
    }

    @Override
    protected void showAdvanceActionPerformed(ActionEvent e) {
        this.kDLabelContainer12.setVisible(!this.kDLabelContainer12.isVisible());
        this.cbCompress.setVisible(!this.cbCompress.isVisible());
        this.cbShowRequest.setVisible(!this.cbShowRequest.isVisible());
        this.lbExtends.setVisible(!this.lbExtends.isVisible());
    }

    protected void companyDataChange() throws EASBizException, BOSException {
        PeriodInfo current;
        Object[] cs;
        Object object = this.promptCompany.getValue();
        CompanyOrgUnitInfo company = null;
        CompanyOrgUnitInfo bizCompany = null;
        if (object instanceof CompanyOrgUnitInfo[]) {
            cs = (CompanyOrgUnitInfo[])object;
            company = this.getTopCompany((CompanyOrgUnitInfo[])cs);
            bizCompany = this.getBizCompany((CompanyOrgUnitInfo[])cs);
        } else if (object instanceof Object[]) {
            cs = (Object[])object;
            company = this.getTopCompany(cs);
            bizCompany = this.getBizCompany(cs);
        } else if (object instanceof CompanyOrgUnitInfo) {
            company = (CompanyOrgUnitInfo)object;
        } else if (object instanceof String) {
            cs = this.getCompanys((String)object);
            company = this.getTopCompany((CompanyOrgUnitInfo[])cs);
            bizCompany = this.getBizCompany((CompanyOrgUnitInfo[])cs);
        }
        if (company == null) {
            return;
        }
        PeriodTypeInfo periodType = null;
        AccountTableInfo accountTable = null;
        CurrencyInfo currency = null;
        if (company.getAccountPeriodType() != null) {
            periodType = company.getAccountPeriodType().getNumber() != null ? company.getAccountPeriodType() : PeriodTypeFactory.getRemoteInstance().getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(company.getAccountPeriodType().getId()));
        }
        if (company.getBaseCurrency() != null) {
            currency = company.getBaseCurrency().getNumber() != null ? company.getBaseCurrency() : CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
        }
        if (company.getAccountTable() != null) {
            accountTable = company.getAccountTable().getNumber() != null ? company.getAccountTable() : AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(company.getAccountTable().getId()));
        }
        this.promptPeriodType.removeDataChangeListener(this.periodTypeListener);
        this.promptPeriodType.setValue((Object)periodType);
        this.periodTypeDataChange();
        this.promptPeriodType.addDataChangeListener(this.periodTypeListener);
        if (bizCompany != null && (current = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(bizCompany.getId().toString()))) != null && current != null) {
            this.spnPeriodYearBegin.setValue((Object)current.getPeriodYear());
            this.spnPeriodNumberBegin.setValue((Object)current.getPeriodNumber());
            this.spnPeriodYearEnd.setValue((Object)current.getPeriodYear());
            this.spnPeriodNumberEnd.setValue((Object)current.getPeriodNumber());
        }
        this.promptCurrency.setValue((Object)currency);
        this.promptAccountTable.removeDataChangeListener(this.tableListener);
        this.promptAccountTable.setValue((Object)accountTable);
        this.promptAccountTable.addDataChangeListener(this.tableListener);
        this.tableDataChange();
        this.initAsstTable(this.tblAsst, this.kdUp, this.kdDown, this.getCompanys());
        this.promptAsstAccount.removeDataChangeListener(this.asstAccountListener);
        this.promptAsstAccount.setValue(null);
        this.asstAccountChanged();
        this.promptAsstAccount.addDataChangeListener(this.asstAccountListener);
    }

    private void initAccount(AccountViewInfo fromAccount, AccountViewInfo toAccount) {
        Object[] cs;
        Object object = this.promptCompany.getValue();
        CompanyOrgUnitInfo company = null;
        if (object instanceof CompanyOrgUnitInfo[]) {
            cs = (CompanyOrgUnitInfo[])object;
            company = this.getTopCompany((CompanyOrgUnitInfo[])cs);
        } else if (object instanceof Object[]) {
            cs = (Object[])object;
            company = this.getTopCompany(cs);
        } else if (object instanceof CompanyOrgUnitInfo) {
            company = (CompanyOrgUnitInfo)object;
        } else if (object instanceof String) {
            cs = this.getCompanys((String)object);
            company = this.getTopCompany((CompanyOrgUnitInfo[])cs);
        }
        if (company == null) {
            return;
        }
        AccountTableInfo accountTable = (AccountTableInfo)this.promptAccountTable.getValue();
        if (accountTable == null && company.getAccountTable() != null) {
            if (company.getAccountTable().getNumber() != null) {
                accountTable = company.getAccountTable();
            } else {
                try {
                    accountTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(company.getAccountTable().getId()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        if (accountTable != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        } else {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)"emptyid"));
        }
        if (fromAccount != null) {
            fic.add(new FilterItemInfo("number", (Object)fromAccount.getNumber(), CompareType.GREATER_EQUALS));
        }
        if (toAccount != null) {
            fic.add(new FilterItemInfo("number", (Object)(toAccount.getNumber() + "zz"), CompareType.LESS_EQUALS));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmptAccount.getQueryAgent().resetRuntimeEntityView();
        this.prmptAccount.setEntityViewInfo(view);
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, company, accountTable, filter, false, false);
        this.prmptAccount.setSelector((KDPromptSelector)apb);
    }

    protected void periodTypeDataChange() {
        PeriodTypeInfo periodType = null;
        Object object = this.promptPeriodType.getValue();
        if (object instanceof PeriodTypeInfo) {
            periodType = (PeriodTypeInfo)object;
        }
        if (periodType == null) {
            return;
        }
        try {
            boolean isPeriodEnable;
            Set<String> companyIdSet = this.getPeriodCompanyIds(this.promptCompany.getValue(), (OrgTreeInfo)this.promptOrgTree.getValue(), this.promptUnion.getValue(), periodType);
            boolean bl = isPeriodEnable = !companyIdSet.isEmpty();
            if (isPeriodEnable) {
                PeriodEntity pe;
                Map pdRang = this.getIGLRptBaseFacade().getPeriodRange(companyIdSet, periodType.getId().toString());
                this.pe = pe = new PeriodEntity(pdRang);
                SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)false, (boolean)false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private IGLRptBaseFacade getIGLRptBaseFacade() throws BOSException {
        return GLRptSubLedgerFacadeFactory.getRemoteInstance();
    }

    protected Set getCompanyIdSet() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        HashSet<String> idSet = new HashSet<String>();
        if (companys == null) {
            return idSet;
        }
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    protected CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.promptCompany.getValue();
        if (company instanceof CompanyOrgUnitInfo) {
            return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
        }
        if (this.promptCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            return (CompanyOrgUnitInfo[])this.promptCompany.getValue();
        }
        if (this.promptCompany.getValue() instanceof Object[]) {
            Object[] companyObjs = (Object[])this.promptCompany.getValue();
            return this.toObjectArray2CompanyArray(companyObjs);
        }
        return null;
    }

    protected void tableDataChange() throws EASBizException, BOSException {
        Object[] cs;
        AccountTableInfo accountTable = null;
        Object object = this.promptAccountTable.getValue();
        if (object instanceof AccountTableInfo) {
            accountTable = (AccountTableInfo)object;
        }
        if (accountTable == null) {
            return;
        }
        object = this.promptCompany.getValue();
        CompanyOrgUnitInfo company = null;
        if (object instanceof CompanyOrgUnitInfo[]) {
            cs = (CompanyOrgUnitInfo[])object;
            company = this.getTopCompany((CompanyOrgUnitInfo[])cs);
        } else if (object instanceof Object[]) {
            cs = (Object[])object;
            company = this.getTopCompany(cs);
        } else if (object instanceof CompanyOrgUnitInfo) {
            company = (CompanyOrgUnitInfo)object;
        } else if (object instanceof String) {
            cs = this.getCompanys((String)object);
            company = this.getTopCompany((CompanyOrgUnitInfo[])cs);
        }
        if (company == null) {
            return;
        }
        HashSet<String> allAccountNumbers = new HashSet<String>();
        String fromAccountNumber = null;
        object = this.prmptFromAccount.getValue();
        if (object instanceof String) {
            fromAccountNumber = (String)object;
        } else if (object instanceof AccountViewInfo) {
            fromAccountNumber = ((AccountViewInfo)object).getNumber();
        }
        if (fromAccountNumber != null) {
            allAccountNumbers.add(fromAccountNumber);
        }
        String toAccountNumber = null;
        object = this.prmptToAccount.getValue();
        if (object instanceof String) {
            toAccountNumber = (String)object;
        } else if (object instanceof AccountViewInfo) {
            toAccountNumber = ((AccountViewInfo)object).getNumber();
        }
        if (toAccountNumber != null) {
            allAccountNumbers.add(toAccountNumber);
        }
        ArrayList<String> accountNumbers = new ArrayList<String>();
        object = this.prmptAccount.getValue();
        if (object instanceof String) {
            accountNumbers.add((String)object);
        } else if (object instanceof AccountViewInfo) {
            accountNumbers.add(((AccountViewInfo)object).getNumber());
        } else if (object instanceof AccountViewInfo[]) {
            for (AccountViewInfo accountViewInfo : (AccountViewInfo[])object) {
                accountNumbers.add(accountViewInfo.getNumber());
            }
        } else if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                if (object2 == null) continue;
                accountNumbers.add(((AccountViewInfo)object2).getNumber());
            }
        }
        allAccountNumbers.addAll(accountNumbers);
        this.initAccount(company, accountTable, this.prmptFromAccount);
        this.initAccount(company, accountTable, this.prmptToAccount);
        this.initAccount(company, accountTable, this.prmptAccount);
        Map<String, AccountViewInfo> map = this.getAccounts(company, accountTable, allAccountNumbers);
        AccountViewInfo fromAccount = null;
        if (fromAccountNumber != null && fromAccountNumber.length() > 0) {
            fromAccount = map.get(fromAccountNumber);
        }
        this.prmptFromAccount.setValue(fromAccount);
        AccountViewInfo toAccount = null;
        if (toAccountNumber != null && toAccountNumber.length() > 0) {
            toAccount = map.get(toAccountNumber);
        }
        this.prmptToAccount.setValue(toAccount);
        ArrayList<AccountViewInfo> arrayList = new ArrayList<AccountViewInfo>();
        for (String accountNumber : accountNumbers) {
            AccountViewInfo account = map.get(accountNumber);
            if (account == null) continue;
            arrayList.add(account);
        }
        this.prmptAccount.setValue((Object)arrayList.toArray(new AccountViewInfo[arrayList.size()]));
    }

    @Override
    protected String getPermissionItem() {
        return "gln_rptasstact_gd_view";
    }

    @Override
    protected void setParam(Object param) {
        if (param != null) {
            Map params = (Map)param;
            this.setGeneralOptions(params);
            this.setAsstActOptions(params);
            this.setVoucherRange(params);
            this.setShowOptions(params);
            this.setOtherOptions(params);
        }
    }

    protected void setOtherOptions(Map<String, Object> params) {
        this.cbUpdateBalance.setSelected(Boolean.valueOf((String)params.get("updateBalance")).booleanValue());
        String threadCount = (String)params.get("threadCount");
        if (threadCount != null) {
            try {
                int i = Integer.parseInt(threadCount);
                if (i >= 1 && i <= 64) {
                    this.spThreadCount.setValue((Object)i);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cbCompress.setSelected(Boolean.parseBoolean((String)params.get("isCompress")));
        this.cbShowRequest.setSelected(Boolean.parseBoolean((String)params.get("showRequest")));
        this.txtExtends.setText(params.get("extends") != null ? (String)params.get("extends") : "");
    }

    protected void setShowOptions(Map<String, Object> params) {
        boolean found = false;
        boolean notShowZero = false;
        boolean notShowNoCurrent = false;
        boolean notShowZeroAndNoCurrent = false;
        boolean notShowNoYear = false;
        boolean notShowZeroAndNoYear = false;
        if (Boolean.parseBoolean((String)params.get("notShowZero"))) {
            notShowZero = true;
            found = true;
        }
        if (!found && Boolean.parseBoolean((String)params.get("notShowNoCurrent"))) {
            notShowNoCurrent = true;
            found = true;
        }
        if (!found && Boolean.parseBoolean((String)params.get("notShowZeroAndNoCurrent"))) {
            notShowZeroAndNoCurrent = true;
            found = true;
        }
        if (!found && Boolean.parseBoolean((String)params.get("notShowNoYear"))) {
            notShowNoYear = true;
            found = true;
        }
        if (!found && Boolean.parseBoolean((String)params.get("notShowZeroAndNoYear"))) {
            notShowZeroAndNoYear = true;
        }
        this.rbNotShowZero.setSelected(notShowZero);
        this.rbNotShowNoCurrent.setSelected(notShowNoCurrent);
        this.rbNotShowZeroAndNoCurrent.setSelected(notShowZeroAndNoCurrent);
        this.rbNotShowNoYear.setSelected(notShowNoYear);
        this.rbNotShowZeroAndNoYear.setSelected(notShowZeroAndNoYear);
        this.cbShowFor.setSelected(Boolean.parseBoolean((String)params.get("showFor")));
        this.cbShowLocal.setSelected(Boolean.parseBoolean((String)params.get("showLocal")));
        this.cbShowRpt.setSelected(Boolean.parseBoolean((String)params.get("showRpt")));
        this.cbShowQty.setSelected(Boolean.parseBoolean((String)params.get("showQty")));
        this.cbShowByMU.setSelected(Boolean.parseBoolean((String)params.get("showByMU")));
        this.cbShowPeriodSum.setSelected(Boolean.parseBoolean((String)params.get("showPeriodSum")));
        this.cbShowYearSum.setSelected(Boolean.parseBoolean((String)params.get("showYearSum")));
        this.cbShowByAccountDc.setSelected(Boolean.parseBoolean((String)params.get("showByAccountDc")));
        this.cbShowCompanyLongNumber.setSelected(Boolean.parseBoolean((String)params.get("showCompanyLongNumber")));
        this.cbShowCompanyLevel.setSelected(Boolean.parseBoolean((String)params.get("showCompanyLevel")));
        this.cbShowCompanyName.setSelected(Boolean.parseBoolean((String)params.get("showCompanyName")));
        this.cbShowCompanyBizUnit.setSelected(Boolean.parseBoolean((String)params.get("showCompanyBizUnit")));
        this.cbShowAccountName.setSelected(Boolean.parseBoolean((String)params.get("showAccountName")));
        this.cbShowAccountLongName.setSelected(Boolean.parseBoolean((String)params.get("showAccountLongName")));
        this.cbShowAccountDc.setSelected(Boolean.parseBoolean((String)params.get("showAccountDc")));
        this.cbShowCurrencyNumber.setSelected(Boolean.parseBoolean((String)params.get("showCurrencyNumber")));
        this.cbShowCurrencyName.setSelected(Boolean.parseBoolean((String)params.get("showCurrencyName")));
        this.cbShowAsstActNumber.setSelected(Boolean.parseBoolean((String)params.get("showAsstActNumber")));
        this.cbShowAsstActLongNumber.setSelected(Boolean.parseBoolean((String)params.get("showAsstActLongNumber")));
        this.cbShowAsstActLongName.setSelected(Boolean.parseBoolean((String)params.get("showAsstActLongName")));
    }

    protected void setVoucherRange(Map<String, Object> params) {
        VoucherTypeInfo[] vts = null;
        String voucherType = (String)params.get("voucherType");
        if (voucherType != null && voucherType.trim().length() > 0) {
            HashSet<String> numbers = new HashSet<String>();
            for (String str : voucherType.split(";")) {
                if (str.trim().length() <= 0) continue;
                numbers.add(str.trim());
            }
            if (numbers.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                view.setFilter(filter);
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo item = new SorterItemInfo("number");
                item.setSortType(SortType.ASCEND);
                sorter.add(item);
                view.setSorter(sorter);
                try {
                    VoucherTypeCollection coll = VoucherTypeFactory.getRemoteInstance().getVoucherTypeCollection(view);
                    if (coll.size() > 0) {
                        vts = new VoucherTypeInfo[coll.size()];
                        for (int i = 0; i < coll.size(); ++i) {
                            vts[i] = coll.get(i);
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        this.promptVoucherType.setValue(vts);
        String voucherNumber = (String)params.get("voucherNumber");
        if (voucherNumber == null) {
            voucherNumber = "";
        }
        this.tfVoucherNumber.setText(voucherNumber);
        String fromVoucherNumber = (String)params.get("fromVoucherNumber");
        if (fromVoucherNumber == null) {
            fromVoucherNumber = "";
        }
        this.tfFromVoucherNumber.setText(fromVoucherNumber);
        String toVoucherNumber = (String)params.get("toVoucherNumber");
        if (toVoucherNumber == null) {
            toVoucherNumber = "";
        }
        this.tfToVoucherNumber.setText(toVoucherNumber);
        String fromBookedDate = (String)params.get("fromBookedDate");
        if (fromBookedDate != null && fromBookedDate.trim().length() > 0) {
            try {
                this.tfFromBookedDate.setValue((Object)DF_IMP.parse(fromBookedDate.trim()));
            }
            catch (ParseException e) {
                this.tfFromBookedDate.setValue(null);
            }
        } else {
            this.tfFromBookedDate.setValue(null);
        }
        String toBookedDate = (String)params.get("toBookedDate");
        if (toBookedDate != null && toBookedDate.trim().length() > 0) {
            try {
                this.tfToBookedDate.setValue((Object)DF_IMP.parse(toBookedDate.trim()));
            }
            catch (ParseException e) {
                this.tfToBookedDate.setValue(null);
            }
        } else {
            this.tfToBookedDate.setValue(null);
        }
        String fromBizDate = (String)params.get("fromBizDate");
        if (fromBizDate != null && fromBizDate.trim().length() > 0) {
            try {
                this.tfFromBizDate.setValue((Object)DF_IMP.parse(fromBizDate.trim()));
            }
            catch (ParseException e) {
                this.tfFromBizDate.setValue(null);
            }
        } else {
            this.tfFromBizDate.setValue(null);
        }
        String toBizDate = (String)params.get("toBizDate");
        if (toBizDate != null && toBizDate.trim().length() > 0) {
            try {
                this.tfToBizDate.setValue((Object)DF_IMP.parse(toBizDate.trim()));
            }
            catch (ParseException e) {
                this.tfToBizDate.setValue(null);
            }
        } else {
            this.tfToBizDate.setValue(null);
        }
        String sourceSys = (String)params.get("sourceSys");
        if (sourceSys == null) {
            sourceSys = "";
        }
        this.tfSourceSys.setText(sourceSys);
        String sourceType = (String)params.get("sourceType");
        if (sourceType == null) {
            sourceType = "";
        }
        this.tfSourceType.setText(sourceType);
        String creator = (String)params.get("creator");
        if (creator == null) {
            creator = "";
        }
        this.tfCreator.setText(creator);
        String auditor = (String)params.get("auditor");
        if (auditor == null) {
            auditor = "";
        }
        this.tfAuditor.setText(auditor);
        String poster = (String)params.get("poster");
        if (poster == null) {
            poster = "";
        }
        this.tfPoster.setText(poster);
        String cashier = (String)params.get("cashier");
        if (cashier == null) {
            cashier = "";
        }
        this.tfCashier.setText(cashier);
        String description = (String)params.get("description");
        if (description == null) {
            description = "";
        }
        this.tfDescription.setText(description);
        String recordDescription = (String)params.get("recordDescription");
        if (recordDescription == null) {
            recordDescription = "";
        }
        this.tfRecordDescription.setText(recordDescription);
        String entryDC = (String)params.get("entryDC");
        if (String.valueOf(EntryDC.DEBIT.getValue()).equals(entryDC)) {
            this.cbEntryDC.setSelectedIndex(1);
        } else if (String.valueOf(EntryDC.CREDIT.getValue()).equals(entryDC)) {
            this.cbEntryDC.setSelectedIndex(2);
        } else {
            this.cbEntryDC.setSelectedIndex(0);
        }
        BigDecimal recordMinAmount = null;
        String object = (String)params.get("recordMinAmount");
        if (object instanceof BigDecimal) {
            recordMinAmount = (BigDecimal)((Object)object);
        } else if (object != null && object.toString().trim().length() > 0) {
            try {
                recordMinAmount = new BigDecimal(object.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tfRecordMinAmount.setValue((Object)recordMinAmount);
        BigDecimal recordMaxAmount = null;
        object = (String)params.get("recordMaxAmount");
        if (object instanceof BigDecimal) {
            recordMaxAmount = (BigDecimal)((Object)object);
        } else if (object != null && object.toString().trim().length() > 0) {
            try {
                recordMaxAmount = new BigDecimal(object.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tfRecordMaxAmount.setValue((Object)recordMaxAmount);
        this.cbBalType.setSelected(false);
        if (params.get("balType") != null) {
            String balType = (String)params.get("balType");
            if ("1".equals(balType) || Boolean.parseBoolean(balType)) {
                this.cbBalType.setSelected(true);
            } else {
                this.cbBalType.setSelected(false);
            }
        }
        this.cbNotIncludePLVoucher.setSelected(Boolean.parseBoolean((String)params.get("notIncludePLVoucher")));
    }

    protected void setGeneralOptions(Map<String, Object> params) {
        String toAccountNumber;
        CompanyOrgUnitInfo company;
        String companyNumber = (String)params.get("companyNumber");
        CompanyOrgUnitInfo[] cs = this.getCompanys(companyNumber);
        this.changeAsstAccount = false;
        this.promptCompany.setValue((Object)cs);
        this.changeAsstAccount = true;
        String companyDisplayMode = (String)params.get("companyDisplayMode");
        if ("details".equals(companyDisplayMode)) {
            this.cbCompanyDisplayMode.setSelectedIndex(0);
        } else if ("enumerate".equals(companyDisplayMode)) {
            this.cbCompanyDisplayMode.setSelectedIndex(1);
        }
        String orgTreeId = (String)params.get("orgTreeId");
        OrgTreeInfo orgTree = this.getOrgTree(orgTreeId);
        this.promptOrgTree.setValue((Object)orgTree);
        this.initUnion(orgTree);
        OrgUnitInfo[] unions = null;
        if (orgTree != null) {
            String unionNumber = (String)params.get("unionNumber");
            unions = this.getUnions(orgTree.getId().toString(), unionNumber);
        }
        this.promptUnion.setValue(unions);
        AccountTableInfo accountTable = this.getAccountTable((String)params.get("accountTableNumber"));
        this.promptAccountTable.setValue((Object)accountTable);
        this.promptPeriodType.setValue((Object)this.getPeriodType((String)params.get("periodTypeNumber")));
        String fromPeriod = (String)params.get("fromPeriodNumber");
        String toPeriod = (String)params.get("toPeriodNumber");
        if (fromPeriod != null && fromPeriod.trim().length() > 0 && toPeriod != null && toPeriod.trim().length() > 0) {
            this.setPeriod(this.spnPeriodYearBegin, this.spnPeriodNumberBegin, this.spnPeriodYearEnd, this.spnPeriodNumberEnd, new Integer(fromPeriod.trim()), new Integer(toPeriod.trim()));
        }
        if ((company = this.getTopCompany(cs)) == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (accountTable == null) {
            accountTable = company.getAccountTable();
        }
        this.initAccount(company, accountTable, this.prmptFromAccount);
        this.initAccount(company, accountTable, this.prmptToAccount);
        this.initAccount(company, accountTable, this.prmptAccount);
        HashSet<String> allAccountNumbers = new HashSet<String>();
        String fromAccountNumber = (String)params.get("fromAccountNumber");
        if (fromAccountNumber != null && fromAccountNumber.length() > 0) {
            allAccountNumbers.add(fromAccountNumber);
        }
        if ((toAccountNumber = (String)params.get("toAccountNumber")) != null && toAccountNumber.length() > 0) {
            allAccountNumbers.add(toAccountNumber);
        }
        List<String> accountNumbers = this.split((String)params.get("accountNumber"), ";");
        allAccountNumbers.addAll(accountNumbers);
        Map<Object, Object> allAccounts = new HashMap();
        allAccounts = this.getAccounts(company, accountTable, allAccountNumbers);
        AccountViewInfo fromAccount = null;
        if (fromAccountNumber != null && fromAccountNumber.length() > 0) {
            fromAccount = (AccountViewInfo)allAccounts.get(fromAccountNumber);
        }
        this.prmptFromAccount.setValue(fromAccount);
        AccountViewInfo toAccount = null;
        if (toAccountNumber != null && toAccountNumber.length() > 0) {
            toAccount = (AccountViewInfo)allAccounts.get(toAccountNumber);
        }
        this.prmptToAccount.setValue(toAccount);
        ArrayList<AccountViewInfo> accounts = new ArrayList<AccountViewInfo>();
        for (String accountNumber : accountNumbers) {
            AccountViewInfo account = (AccountViewInfo)allAccounts.get(accountNumber);
            if (account == null) continue;
            accounts.add(account);
        }
        this.prmptAccount.setValue((Object)accounts.toArray(new AccountViewInfo[accounts.size()]));
        CurrencyInfo[] cys = null;
        String currency = (String)params.get("currencyNumber");
        if (currency != null && currency.trim().length() > 0) {
            HashSet<String> numbers = new HashSet<String>();
            for (String str : currency.split(";")) {
                if (str.trim().length() <= 0) continue;
                numbers.add(str.trim());
            }
            if (numbers.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                view.setFilter(filter);
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo item = new SorterItemInfo("number");
                item.setSortType(SortType.ASCEND);
                sorter.add(item);
                view.setSorter(sorter);
                try {
                    CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
                    if (coll.size() > 0) {
                        cys = new CurrencyInfo[coll.size()];
                        for (int i = 0; i < coll.size(); ++i) {
                            cys[i] = coll.get(i);
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        this.promptCurrency.setValue(cys != null ? cys[0] : null);
    }

    protected void setAsstActOptions(Map<String, Object> params) {
        this.cbUsePreparedSpliter.setSelected(Boolean.parseBoolean((String)params.get("usePreparedSpliter")));
        this.onlyAsstact.setSelected(Boolean.parseBoolean((String)params.get("onlyAsstact")));
        this.changeAsstAccount = false;
        String asstAccountNumber = (String)params.get("asstAccountNumber");
        AsstAccountInfo asstAccount = this.getAsstAccount(asstAccountNumber);
        this.promptAsstAccount.setValue((Object)asstAccount);
        this.changeAsstAccount = true;
        this.asstAccountChanged();
        this.setAsstactTypeList(this.tblAsst, (List)params.get("asstActTypes"), this.getCompanys());
    }

    @Override
    protected Object getParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.getGeneralOptions(param);
        this.getAsstActOptions(param);
        this.getVoucherRange(param);
        this.getShowOptions(param);
        this.getOtherOptions(param);
        return param;
    }

    public boolean verify() {
        boolean result = super.verify();
        if (!result) {
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.getAsstActOptions(param);
        List asstActTypes = (List)param.get("asstActTypes");
        if (asstActTypes == null || asstActTypes.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_act_item_please2"));
            return false;
        }
        return true;
    }

    private void getOtherOptions(Map<String, Object> param) {
        param.put("updateBalance", String.valueOf(this.cbUpdateBalance.isSelected()));
        param.put("threadCount", this.spThreadCount.getValue().toString());
        param.put("isCompress", String.valueOf(this.cbCompress.isSelected()));
        param.put("showRequest", String.valueOf(this.cbShowRequest.isVisible() && this.cbShowRequest.isSelected()));
        param.put("extends", this.txtExtends.getText());
    }

    protected void getShowOptions(Map<String, Object> param) {
        param.put("notShowZero", String.valueOf(this.rbNotShowZero.isSelected()));
        param.put("notShowNoCurrent", String.valueOf(this.rbNotShowNoCurrent.isSelected()));
        param.put("notShowZeroAndNoCurrent", String.valueOf(this.rbNotShowZeroAndNoCurrent.isSelected()));
        param.put("notShowNoYear", String.valueOf(this.rbNotShowNoYear.isSelected()));
        param.put("notShowZeroAndNoYear", String.valueOf(this.rbNotShowZeroAndNoYear.isSelected()));
        param.put("showFor", String.valueOf(this.cbShowFor.isSelected()));
        param.put("showLocal", String.valueOf(this.cbShowLocal.isSelected()));
        param.put("showRpt", String.valueOf(this.cbShowRpt.isSelected()));
        if (!(this.cbShowFor.isSelected() || this.cbShowLocal.isSelected() || this.cbShowRpt.isSelected())) {
            param.put("showFor", "true");
        }
        param.put("showQty", String.valueOf(this.cbShowQty.isSelected()));
        param.put("showByMU", String.valueOf(this.cbShowByMU.isSelected()));
        param.put("showPeriodSum", String.valueOf(this.cbShowPeriodSum.isSelected()));
        param.put("showYearSum", String.valueOf(this.cbShowYearSum.isSelected()));
        param.put("showByAccountDc", String.valueOf(this.cbShowByAccountDc.isSelected()));
        param.put("showCompanyLongNumber", String.valueOf(this.cbShowCompanyLongNumber.isSelected()));
        if (this.cbShowCompanyLevel.isVisible()) {
            param.put("showCompanyLevel", String.valueOf(this.cbShowCompanyLevel.isSelected()));
        }
        param.put("showCompanyName", String.valueOf(this.cbShowCompanyName.isSelected()));
        if (this.cbShowCompanyBizUnit.isVisible()) {
            param.put("showCompanyBizUnit", String.valueOf(this.cbShowCompanyBizUnit.isSelected()));
        }
        param.put("showAccountName", String.valueOf(this.cbShowAccountName.isSelected()));
        param.put("showAccountLongName", String.valueOf(this.cbShowAccountLongName.isSelected()));
        if (this.cbShowAccountDc.isVisible()) {
            param.put("showAccountDc", String.valueOf(this.cbShowAccountDc.isSelected()));
        }
        param.put("showCurrencyNumber", String.valueOf(this.cbShowCurrencyNumber.isSelected()));
        param.put("showCurrencyName", String.valueOf(this.cbShowCurrencyName.isSelected()));
        param.put("showAsstActNumber", String.valueOf(this.cbShowAsstActNumber.isSelected()));
        param.put("showAsstActLongNumber", String.valueOf(this.cbShowAsstActLongNumber.isSelected()));
        param.put("showAsstActLongName", String.valueOf(this.cbShowAsstActLongName.isSelected()));
    }

    protected void getVoucherRange(Map<String, Object> param) {
        Object recordMaxAmount;
        Object[] vts;
        StringBuffer str = new StringBuffer();
        str.setLength(0);
        Object object = this.promptVoucherType.getValue();
        if (object instanceof VoucherTypeInfo[]) {
            for (VoucherTypeInfo vt : vts = (VoucherTypeInfo[])object) {
                str.append(vt.getNumber()).append(";");
            }
        } else if (object instanceof Object[]) {
            for (VoucherTypeInfo vt : vts = (Object[])object) {
                str.append(vt.getNumber()).append(";");
            }
        } else if (object instanceof VoucherTypeInfo) {
            VoucherTypeInfo vt = (VoucherTypeInfo)object;
            str.append(vt.getNumber()).append(";");
        } else if (object != null) {
            str.append(object.toString());
        }
        param.put("voucherType", str.toString());
        param.put("voucherNumber", this.tfVoucherNumber.getText());
        param.put("fromVoucherNumber", this.tfFromVoucherNumber.getText());
        param.put("toVoucherNumber", this.tfToVoucherNumber.getText());
        param.put("fromBookedDate", this.tfFromBookedDate.getText());
        param.put("toBookedDate", this.tfToBookedDate.getText());
        param.put("fromBizDate", this.tfFromBizDate.getText());
        param.put("toBizDate", this.tfToBizDate.getText());
        param.put("sourceSys", this.tfSourceSys.getText());
        param.put("sourceType", this.tfSourceType.getText());
        param.put("creator", this.tfCreator.getText());
        param.put("auditor", this.tfAuditor.getText());
        param.put("poster", this.tfPoster.getText());
        param.put("cashier", this.tfCashier.getText());
        param.put("description", this.tfDescription.getText());
        param.put("recordDescription", this.tfRecordDescription.getText());
        Object entryDC = this.cbEntryDC.getSelectedItem();
        if (entryDC instanceof EntryDC) {
            param.put("entryDC", String.valueOf(((EntryDC)entryDC).getValue()));
        } else {
            param.put("entryDC", "");
        }
        Object recordMinAmount = this.tfRecordMinAmount.getValue();
        if (recordMinAmount instanceof BigDecimal) {
            param.put("recordMinAmount", recordMinAmount.toString());
        }
        if ((recordMaxAmount = this.tfRecordMaxAmount.getValue()) instanceof BigDecimal) {
            param.put("recordMaxAmount", recordMaxAmount.toString());
        }
        param.put("balType", this.cbBalType.isSelected() ? "1" : "5");
        param.put("notIncludePLVoucher", String.valueOf(this.cbNotIncludePLVoucher.isSelected()));
    }

    protected void getAsstActOptions(Map<String, Object> param) {
        param.put("usePreparedSpliter", String.valueOf(this.cbUsePreparedSpliter.isSelected()));
        param.put("onlyAsstact", String.valueOf(this.onlyAsstact.isSelected()));
        AsstAccountInfo asstAccount = (AsstAccountInfo)this.promptAsstAccount.getValue();
        param.put("asstAccountNumber", asstAccount != null ? asstAccount.getNumber() : "");
        ArrayList asstActTypes = new ArrayList();
        param.put("asstActTypes", asstActTypes);
        int count = 0;
        for (int i = 0; i < this.tblAsst.getRowCount(); ++i) {
            Object standard;
            Object dist;
            Object to;
            Object from;
            IRow row = this.tblAsst.getRow(i);
            Boolean selected = (Boolean)row.getCell("selected").getValue();
            if (!selected.booleanValue()) continue;
            HashMap<String, String> asstType = new HashMap<String, String>();
            AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
            asstType.put("type", at.getNumber());
            String key = "number";
            if (at.isGeneralActType()) {
                key = "longnumber";
            }
            if ((from = row.getCell("from").getValue()) instanceof IObjectValue) {
                asstType.put("from", ((IObjectValue)from).get(key).toString());
            }
            if ((to = row.getCell("to").getValue()) instanceof IObjectValue) {
                asstType.put("to", ((IObjectValue)to).get(key).toString());
            }
            if ((dist = row.getCell("dist").getUserObject()) instanceof Set) {
                StringBuilder asstNumbers = new StringBuilder();
                for (Object obj : (Set)dist) {
                    if (!(obj instanceof AssistViewFilterInfo)) continue;
                    String number = ((AssistViewFilterInfo)obj).getNumber();
                    if (asstNumbers.length() > 0) {
                        asstNumbers.append(";");
                    }
                    asstNumbers.append(number);
                }
                asstType.put("number", asstNumbers.toString());
            }
            if ((standard = row.getCell("groupStandard").getValue()) instanceof DataBaseInfo) {
                asstType.put("standard", ((DataBaseInfo)standard).getNumber());
            }
            Object groupObj = row.getCell("group").getValue();
            StringBuffer groupNumbers = new StringBuffer();
            if (groupObj instanceof Object[]) {
                Object[] groups;
                for (Object group : groups = (Object[])groupObj) {
                    if (!(group instanceof DataBaseInfo)) continue;
                    groupNumbers.append(((DataBaseInfo)group).getNumber()).append(";");
                }
                groupNumbers.deleteCharAt(groupNumbers.length() - 1);
                asstType.put("group", groupNumbers.toString());
            }
            asstActTypes.add(asstType);
            if (++count >= 8) break;
        }
    }

    protected void getGeneralOptions(Map<String, Object> param) {
        Object[] cs;
        StringBuffer str = new StringBuffer();
        Object object = this.promptCompany.getValue();
        if (object instanceof CompanyOrgUnitInfo[]) {
            for (CompanyOrgUnitInfo c : cs = (CompanyOrgUnitInfo[])object) {
                str.append(c.getNumber()).append(";");
            }
        } else if (object instanceof Object[]) {
            for (CompanyOrgUnitInfo c : cs = (Object[])object) {
                str.append(c.getNumber()).append(";");
            }
        } else if (object instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo c = (CompanyOrgUnitInfo)object;
            str.append(c.getNumber()).append(";");
        } else if (object != null) {
            str.append(object.toString());
        }
        param.put("companyNumber", str.toString());
        CompanyDisplayModeEnum mode = (CompanyDisplayModeEnum)((Object)this.cbCompanyDisplayMode.getSelectedItem());
        param.put("companyDisplayMode", mode.getName());
        OrgTreeInfo orgTree = (OrgTreeInfo)this.promptOrgTree.getValue();
        if (orgTree != null) {
            param.put("orgTreeId", orgTree.getId().toString());
            Object[] os = (Object[])this.promptUnion.getValue();
            if (os != null && os.length > 0) {
                str.setLength(0);
                for (Object o : os) {
                    str.append(((OrgUnitInfo)o).getNumber()).append(";");
                }
                param.put("unionNumber", str.toString());
            }
        }
        param.put("accountTableNumber", (object = this.promptAccountTable.getValue()) instanceof AccountTableInfo ? ((AccountTableInfo)object).getNumber() : "");
        object = this.promptPeriodType.getValue();
        param.put("periodTypeNumber", object instanceof PeriodTypeInfo ? ((PeriodTypeInfo)object).getNumber() : "");
        Integer fromPeriodYear = this.spnPeriodYearBegin.getIntegerVlaue();
        Integer fromPeriodNumber = this.spnPeriodNumberBegin.getIntegerVlaue();
        Integer toPeriodYear = this.spnPeriodYearEnd.getIntegerVlaue();
        Integer toPeriodNumber = this.spnPeriodNumberEnd.getIntegerVlaue();
        param.put("fromPeriodNumber", this.getPeriodStr(fromPeriodYear, fromPeriodNumber, str));
        param.put("toPeriodNumber", this.getPeriodStr(toPeriodYear, toPeriodNumber, str));
        String fromAccountNumber = "";
        object = this.prmptFromAccount.getValue();
        if (object instanceof String) {
            fromAccountNumber = (String)object;
        } else if (object instanceof AccountViewInfo) {
            fromAccountNumber = ((AccountViewInfo)object).getNumber();
        }
        param.put("fromAccountNumber", fromAccountNumber);
        String toAccountNumber = "";
        object = this.prmptToAccount.getValue();
        if (object instanceof String) {
            toAccountNumber = (String)object;
        } else if (object instanceof AccountViewInfo) {
            toAccountNumber = ((AccountViewInfo)object).getNumber();
        }
        param.put("toAccountNumber", toAccountNumber);
        String accountNumber = "";
        object = this.prmptAccount.getValue();
        if (object instanceof String) {
            accountNumber = (String)object;
        } else if (object instanceof AccountViewInfo) {
            accountNumber = ((AccountViewInfo)object).getNumber();
        } else if (object instanceof AccountViewInfo[]) {
            for (AccountViewInfo account : (AccountViewInfo[])object) {
                accountNumber = accountNumber + account.getNumber() + ";";
            }
        } else if (object instanceof Object[]) {
            for (Object account : (Object[])object) {
                accountNumber = accountNumber + ((AccountViewInfo)account).getNumber() + ";";
            }
        }
        param.put("accountNumber", accountNumber);
        object = this.promptCurrency.getValue();
        param.put("currencyNumber", object instanceof CurrencyInfo ? ((CurrencyInfo)object).getNumber() : "");
    }

    protected void fillTableAsstType() {
        String asstAccountId = null;
        AsstAccountInfo asstAccount = (AsstAccountInfo)this.promptAsstAccount.getValue();
        if (asstAccount != null) {
            asstAccountId = asstAccount.getId().toString();
        }
        List actList = null;
        try {
            if (asstAccountId == null) {
                HashSet<String> idSet = new HashSet<String>();
                CompanyOrgUnitInfo[] companys = this.getCompanys();
                if (companys != null) {
                    for (CompanyOrgUnitInfo company : companys) {
                        if (!company.isIsBizUnit()) {
                            idSet.clear();
                            break;
                        }
                        idSet.add(company.getId().toString());
                    }
                }
                actList = GLRptAsstActTypeBalanceFacadeFactory.getRemoteInstance().queryAsstAct(idSet);
            } else {
                actList = GLRptUtils.getAsstactTypeEntityList(asstAccountId);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.tblAsst.removeRows();
        if (actList == null || actList.isEmpty()) {
            return;
        }
        Iterator it = actList.iterator();
        while (it.hasNext()) {
            IRow row = this.tblAsst.addRow();
            if (row.getCell("selected") == null) {
                this.tblAsst.removeRows();
                return;
            }
            AsstactTypeEntity at = (AsstactTypeEntity)it.next();
            LabelValueBean lvb = new LabelValueBean(at.getId(), at.getName());
            lvb.setProperty("attrs", (Object)at);
            row.setUserObject((Object)at);
            if (asstAccountId != null) {
                row.getCell("selected").setValue((Object)Boolean.TRUE);
            } else {
                row.getCell("selected").setValue((Object)Boolean.FALSE);
            }
            row.getCell("asstact").setValue((Object)lvb);
            StyleAttributes sa = row.getCell("groupStandard").getStyleAttributes();
            if ("customer".equalsIgnoreCase(at.getHgAttribute()) || "provider".equalsIgnoreCase(at.getHgAttribute()) || "Material".equalsIgnoreCase(at.getHgAttribute())) {
                this.loadAsstGroupStandardF7(row);
                sa.setBackground(Color.WHITE);
            } else {
                sa.setBackground(LOCKCOLOR);
            }
            sa.setPattern(Pattern.Solid);
            sa.setLocked(true);
            row.getCell("group").getStyleAttributes().setBackground(LOCKCOLOR);
        }
    }
}

