/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLNRptAsstactGDUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAsstactGDExportUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAsstactGDQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTable;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTableHelper;
import com.kingdee.eas.framework.config.IObjectMultiPKBuilder;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;

public class GLNRptAsstactGDUI
extends AbstractGLNRptAsstactGDUI {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptAsstactGDUI.class);
    public static final Color PERIOD_BEGIN_COLOR = new Color(238, 236, 248);
    public static final Color PERIOD_TOTAL_COLOR = new Color(232, 228, 203);
    public static final Color YEAR_TOTAL_COLOR = new Color(233, 226, 184);
    protected boolean showFor = false;
    protected boolean showLocal = false;
    protected boolean showRpt = false;
    protected boolean showQty = false;
    private boolean onlyAsstact = false;

    public GLNRptAsstactGDUI() throws Exception {
        this.init();
    }

    private void init() {
        this.txtConsole.setContentType("text/html");
        this.txtConsole.setEditable(false);
        StringBuffer htmlText = new StringBuffer();
        htmlText.append("<html>");
        htmlText.append("<body>");
        htmlText.append(this.getResource("detailsUsageInfo"));
        htmlText.append("<br>");
        htmlText.append("<a href=\"https://vip.kingdee.com/article/348056408527098880\">https://vip.kingdee.com/article/348056408527098880</a>");
        htmlText.append("<br>");
        htmlText.append("</body>");
        htmlText.append("</html>");
        this.txtConsole.setText(htmlText.toString());
        this.txtConsole.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(evt.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initPopMenu(GLNRptAsstactGDExportUI.class.getName());
    }

    protected void initListener() {
        super.initListener();
        this.getTable().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                if (GLNRptAsstactGDUI.this.innerSumTable != null) {
                    GLNRptAsstactGDUI.this.innerSumTable.setVisible(false);
                }
                if (GLNRptAsstactGDUI.this.innerSumTable != null && (GLNRptAsstactGDUI.this.getTable().getSelectManager().size() > 1 || e.getSelectBlock().getEndRow() - e.getSelectBlock().getBeginRow() > 0)) {
                    GLNRptAsstactGDUI.this.innerSumTable.selectRowSum(GLNRptAsstactGDUI.this.getTable().getSelectManager().getBlocks(), false);
                } else {
                    int rowIndex = e.getSelectBlock().getTop();
                    GLNRptAsstactGDUI.this.tblMain_doSelectChanged(rowIndex);
                }
            }
        });
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        GLNRptAsstactGDUI.this.tblMain_doDoubleClicked();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    GLNRptAsstactGDUI.this.handleError(ex);
                }
            }
        });
    }

    public void tblMain_doDoubleClicked() {
        if (this.btnVoucher.isEnabled()) {
            try {
                this.setCursorOfWair();
                this.findVoucher();
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handleError(e);
            }
        }
    }

    public void findVoucher() {
        String voucherId;
        int rowIndex = KDTableUtil.getSelectedTop((KDTable)this.getTable());
        IRow row = this.getTable().getRow(rowIndex);
        if (row != null && !StringUtils.isEmpty((String)(voucherId = (String)row.getCell("voucherId").getValue()))) {
            try {
                this.setCursorOfWair();
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)voucherId);
                uiContext.put((Object)"NOTLICHA", (Object)"NOTLICHA");
                uiContext.put((Object)"FINDVIEW", (Object)Boolean.TRUE);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)VoucherEditUI.getEditUIMode((CoreUIObject)this)).create(VoucherInfo.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (UIException e) {
                logger.error((Object)e);
                this.handleError((Exception)((Object)e));
            }
        }
    }

    public void tblMain_doSelectChanged(int rowIndex) {
        this.btnVoucher.setEnabled(false);
        IRow row = this.getTable().getRow(rowIndex);
        if (row != null) {
            String voucherId = (String)row.getCell("voucherId").getValue();
            this.btnVoucher.setEnabled(!StringUtils.isEmpty((String)voucherId));
        }
    }

    @Override
    protected GLNRptBaseQueryUI getCustQueryPanel() throws Exception {
        return new GLNRptAsstactGDQueryUI();
    }

    @Override
    protected void setQueryDialogSize(CommonQueryDialog dialog) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        int width = screen.width - insets.left - insets.right;
        if ((width -= 300) > 1130) {
            width = 1130;
        }
        int height = screen.height - insets.top - insets.bottom;
        if ((height -= 90) > 724) {
            height = 724;
        }
        dialog.setWidth(width);
        dialog.setHeight(height);
    }

    @Override
    public int getColumnWidthByColumnName(String colName) {
        return super.getColumnWidthByColumnName(colName);
    }

    @Override
    public void setRptType(Map<String, Object> queryConfig) {
        Object showCompanyLevel = queryConfig.get("showCompanyLevel");
        Object showAccountLevel = queryConfig.get("showAccountLevel");
        super.setRptType(queryConfig);
        queryConfig.put("rptType", "AsstactGD");
        queryConfig.put("showVoucherId", "true");
        queryConfig.put("showCompanyLevel", showCompanyLevel);
        queryConfig.put("showAccountLevel", showAccountLevel);
    }

    @Override
    public GLNRptTableHeadInfo initTableColumn(List<String> colNames, List<String> colAliass) {
        String colAlias;
        int index;
        String colName;
        int i;
        this.initVariable(this.getTable());
        this.tableHeadInfo = new GLNRptTableHeadInfo();
        this.colIndexes.clear();
        ArrayList<String> commonCols = new ArrayList<String>();
        for (int i2 = 0; i2 < colNames.size(); ++i2) {
            String colName2 = colNames.get(i2);
            this.colIndexes.put(colName2, i2);
            if (colName2.endsWith("For") || colName2.endsWith("Local") || colName2.endsWith("Rpt") || colName2.endsWith("Qty") || colName2.equals("dc") || "accountDc".equals(colName2) && !this.showAccountDc) continue;
            commonCols.add(colName2);
        }
        Object asstObj = this.queryConfig.get("asstActTypes");
        if (asstObj instanceof List) {
            int asstCols = ((List)asstObj).size();
            Object obj = this.queryConfig.get("showAsstActNumber");
            boolean showAsstActNumber = obj != null && Boolean.parseBoolean(obj.toString());
            obj = this.queryConfig.get("showAsstActLongNumber");
            boolean showAsstActLongNumber = obj != null && Boolean.parseBoolean(obj.toString());
            obj = this.queryConfig.get("showAsstActLongName");
            boolean showAsstActLongName = obj != null && Boolean.parseBoolean(obj.toString());
            for (int i3 = asstCols + 1; i3 <= 8; ++i3) {
                if (showAsstActNumber) {
                    commonCols.add("asstActNumber" + i3);
                }
                if (showAsstActLongNumber) {
                    commonCols.add("asstActLongNumber" + i3);
                }
                commonCols.add("asstActName" + i3);
                if (!showAsstActLongName) continue;
                commonCols.add("asstActLongName" + i3);
            }
        }
        this.colIndexes.put("dc", 0);
        ArrayList<String> cols = new ArrayList<String>();
        if (this.colIndexes.containsKey("debitQty")) {
            cols.add("debitQty");
        }
        if (this.colIndexes.containsKey("debitFor")) {
            cols.add("debitFor");
        }
        if (this.colIndexes.containsKey("debitLocal")) {
            cols.add("debitLocal");
        }
        if (this.colIndexes.containsKey("debitRpt")) {
            cols.add("debitRpt");
        }
        if (this.colIndexes.containsKey("creditQty")) {
            cols.add("creditQty");
        }
        if (this.colIndexes.containsKey("creditFor")) {
            cols.add("creditFor");
        }
        if (this.colIndexes.containsKey("creditLocal")) {
            cols.add("creditLocal");
        }
        if (this.colIndexes.containsKey("creditRpt")) {
            cols.add("creditRpt");
        }
        ArrayList<String> endCols = new ArrayList<String>();
        endCols.add("dc");
        if (this.colIndexes.containsKey("endQty")) {
            endCols.add("endQty");
        }
        if (this.colIndexes.containsKey("endBalanceFor")) {
            endCols.add("endBalanceFor");
        }
        if (this.colIndexes.containsKey("endBalanceLocal")) {
            endCols.add("endBalanceLocal");
        }
        if (this.colIndexes.containsKey("endBalanceRpt")) {
            endCols.add("endBalanceRpt");
        }
        ArrayList<String> allCols = new ArrayList<String>();
        allCols.addAll(commonCols);
        allCols.addAll(cols);
        allCols.addAll(endCols);
        this.tableHeadInfo.setColumnNames(allCols);
        ArrayList<List<String>> columnTitles = new ArrayList<List<String>>();
        this.tableHeadInfo.setColumnTitles(columnTitles);
        ArrayList<String> columnTitle1 = new ArrayList<String>();
        ArrayList<String> columnTitle2 = new ArrayList<String>();
        columnTitles.add(columnTitle1);
        columnTitles.add(columnTitle2);
        for (i = 0; i < commonCols.size(); ++i) {
            colName = (String)commonCols.get(i);
            if (!this.colIndexes.containsKey(colName) && colName.startsWith("asstAct")) {
                columnTitle1.add(this.getResource("asstAct"));
                columnTitle2.add(this.getResource("asstAct"));
                continue;
            }
            index = (Integer)this.colIndexes.get(colName);
            colAlias = colAliass.get(index);
            columnTitle1.add(colAlias);
            columnTitle2.add(colAlias);
        }
        for (i = 0; i < cols.size(); ++i) {
            columnTitle1.add(this.getResource("periodHappen"));
            colName = (String)cols.get(i);
            index = (Integer)this.colIndexes.get(colName);
            colAlias = colAliass.get(index);
            if (colName.equals("debitQty")) {
                colAlias = this.getResource("debitQty_exp");
            } else if (colName.equals("debitFor")) {
                colAlias = this.getResource("debitFor_exp");
            } else if (colName.equals("debitLocal")) {
                colAlias = this.getResource("debitLocal_exp");
            } else if (colName.equals("debitRpt")) {
                colAlias = this.getResource("debitRpt_exp");
            } else if (colName.equals("creditQty")) {
                colAlias = this.getResource("creditQty_exp");
            } else if (colName.equals("creditFor")) {
                colAlias = this.getResource("creditFor_exp");
            } else if (colName.equals("creditLocal")) {
                colAlias = this.getResource("creditLocal_exp");
            } else if (colName.equals("creditRpt")) {
                colAlias = this.getResource("creditRpt_exp");
            }
            columnTitle2.add(colAlias);
        }
        for (i = 0; i < endCols.size(); ++i) {
            columnTitle1.add(this.getResource("endBalance_exp"));
            colName = (String)endCols.get(i);
            index = (Integer)this.colIndexes.get(colName);
            String string = colAlias = colAliass.isEmpty() ? null : colAliass.get(index);
            if (colName.equals("dc")) {
                colAlias = this.getResource("dc");
            } else if (colName.equals("endQty")) {
                colAlias = this.getResource("qty_exp");
            } else if (colName.equals("endBalanceFor")) {
                colAlias = this.getResource("for_exp");
            } else if (colName.equals("endBalanceLocal")) {
                colAlias = this.getResource("local_exp");
            } else if (colName.equals("endBalanceRpt")) {
                colAlias = this.getResource("rpt_exp");
            }
            columnTitle2.add(colAlias);
        }
        return this.tableHeadInfo;
    }

    @Override
    protected void setColumnStyle(IColumn column) {
        if (column != null && "voucherId".equals(column.getKey())) {
            column.getStyleAttributes().setHided(true);
        }
    }

    @Override
    protected void initVariable(GLNRptTable glnRptTable) {
        super.initVariable(glnRptTable);
        if (glnRptTable.queryConfig != null) {
            this.showFor = Boolean.parseBoolean((String)glnRptTable.queryConfig.get("showFor"));
            this.showLocal = Boolean.parseBoolean((String)glnRptTable.queryConfig.get("showLocal"));
            this.showRpt = Boolean.parseBoolean((String)glnRptTable.queryConfig.get("showRpt"));
            this.showQty = Boolean.parseBoolean((String)glnRptTable.queryConfig.get("showQty"));
            this.onlyAsstact = Boolean.parseBoolean((String)glnRptTable.queryConfig.get("onlyAsstact"));
        }
    }

    @Override
    public void fillDataToTable(List<List<String>> data, int startRowIndex) {
        if (data == null || data.size() == 0) {
            return;
        }
        int rowIndex = startRowIndex;
        List<String> columnNames = this.tableHeadInfo.getColumnNames();
        int bookedDateIndex = (Integer)this.colIndexes.get("bookedDate");
        String accountDc = "1";
        int forPrecisionIndex = this.colIndexes.containsKey("forPrecision") ? (Integer)this.colIndexes.get("forPrecision") : -1;
        int localPrecisionIndex = this.colIndexes.containsKey("localPrecision") ? (Integer)this.colIndexes.get("localPrecision") : -1;
        int rptPrecisionIndex = this.colIndexes.containsKey("rptPrecision") ? (Integer)this.colIndexes.get("rptPrecision") : -1;
        int qtyPrecisionIndex = this.colIndexes.containsKey("qtyPrecision") ? (Integer)this.colIndexes.get("qtyPrecision") : -1;
        String lastAccountDc = null;
        for (int i = 0; i < data.size(); ++i) {
            IRow row = this.getTable().getRow2(rowIndex);
            if (row == null) {
                String str;
                String bookedDate;
                row = this.getTable().setRow(rowIndex);
                List<String> rowData = data.get(i);
                if (this.showByAccountDc) {
                    accountDc = rowData.get((Integer)this.colIndexes.get("accountDc"));
                    if (this.onlyAsstact) {
                        if (StringUtils.isEmpty((String)accountDc)) {
                            accountDc = lastAccountDc;
                        } else {
                            lastAccountDc = accountDc;
                        }
                    }
                }
                if ("1".equals(bookedDate = rowData.get(bookedDateIndex))) {
                    bookedDate = this.getResource("beginBalance_exp");
                    row.getStyleAttributes().setBackground(PERIOD_BEGIN_COLOR);
                } else if ("3".equals(bookedDate)) {
                    bookedDate = this.getResource("sumPeriod");
                    row.getStyleAttributes().setBackground(PERIOD_TOTAL_COLOR);
                } else if ("4".equals(bookedDate)) {
                    bookedDate = this.getResource("sumYear");
                    row.getStyleAttributes().setBackground(YEAR_TOTAL_COLOR);
                }
                rowData.set(bookedDateIndex, bookedDate);
                BigDecimal endFor = GlUtils.zero;
                if (this.showFor && (str = rowData.get((Integer)this.colIndexes.get("endBalanceFor"))) != null && str.length() > 0) {
                    endFor = new BigDecimal(str);
                }
                BigDecimal endLocal = GlUtils.zero;
                if (this.showLocal && (str = rowData.get((Integer)this.colIndexes.get("endBalanceLocal"))) != null && str.length() > 0) {
                    endLocal = new BigDecimal(str);
                }
                BigDecimal endRpt = GlUtils.zero;
                if (this.showRpt && (str = rowData.get((Integer)this.colIndexes.get("endBalanceRpt"))) != null && str.length() > 0) {
                    endRpt = new BigDecimal(str);
                }
                BigDecimal endQty = GlUtils.zero;
                if (this.showQty && (str = rowData.get((Integer)this.colIndexes.get("endQty"))) != null && str.length() > 0) {
                    endQty = new BigDecimal(str);
                }
                BigDecimal end = GlUtils.zero;
                if (this.showFor) {
                    end = endFor;
                } else if (this.showLocal) {
                    end = endLocal;
                } else if (this.showRpt) {
                    end = endRpt;
                }
                String dc = "";
                if (this.showByAccountDc) {
                    if (end.compareTo(GlUtils.zero) == 0) {
                        dc = this.getResource("ping");
                    } else if ("1".equals(accountDc)) {
                        dc = this.getResource("debit");
                    } else {
                        dc = this.getResource("credit");
                        endFor = GlUtils.zero.subtract(endFor);
                        endLocal = GlUtils.zero.subtract(endLocal);
                        endRpt = GlUtils.zero.subtract(endRpt);
                        endQty = GlUtils.zero.subtract(endQty);
                    }
                } else if (end.compareTo(GlUtils.zero) == 0) {
                    dc = this.getResource("ping");
                } else if (end.compareTo(GlUtils.zero) > 0) {
                    dc = this.getResource("debit");
                } else {
                    dc = this.getResource("credit");
                    endFor = GlUtils.zero.subtract(endFor);
                    endLocal = GlUtils.zero.subtract(endLocal);
                    endRpt = GlUtils.zero.subtract(endRpt);
                    endQty = GlUtils.zero.subtract(endQty);
                }
                int forPrecision = -1;
                int localPrecision = -1;
                int rptPrecision = -1;
                int qtyPrecision = -1;
                try {
                    if (forPrecisionIndex >= 0) {
                        forPrecision = Integer.parseInt(rowData.get(forPrecisionIndex));
                    }
                    if (localPrecisionIndex >= 0) {
                        localPrecision = Integer.parseInt(rowData.get(localPrecisionIndex));
                    }
                    if (rptPrecisionIndex >= 0) {
                        rptPrecision = Integer.parseInt(rowData.get(rptPrecisionIndex));
                    }
                    if (qtyPrecisionIndex >= 0) {
                        qtyPrecision = Integer.parseInt(rowData.get(qtyPrecisionIndex));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                for (int j = 0; j < columnNames.size(); ++j) {
                    String colName = columnNames.get(j);
                    if (!this.colIndexes.containsKey(colName)) continue;
                    int colIndex = (Integer)this.colIndexes.get(colName);
                    String value = rowData.get(colIndex);
                    if (colName.equals("dc")) {
                        value = dc;
                    } else if (colName.equals("endBalanceFor")) {
                        value = String.valueOf(endFor);
                    } else if (colName.equals("endBalanceLocal")) {
                        value = String.valueOf(endLocal);
                    } else if (colName.equals("endBalanceRpt")) {
                        value = String.valueOf(endRpt);
                    } else if (colName.equals("endQty")) {
                        value = String.valueOf(endQty);
                    } else if ((colName.endsWith("For") || colName.endsWith("Local") || colName.endsWith("Rpt") || colName.endsWith("Qty") || colName.endsWith("Level") || colName.equals("isBizUnit") || colName.equals("accountDc")) && (value == null || value.length() == 0)) {
                        value = "0";
                    }
                    if (colName.endsWith("For") || colName.endsWith("Local") || colName.endsWith("Rpt") || colName.endsWith("Qty")) {
                        BigDecimal b = new BigDecimal(value);
                        if (b.compareTo(GlUtils.zero) == 0) {
                            row.getCell(colName).setValue((Object)"");
                            continue;
                        }
                        int scale = colName.endsWith("For") ? forPrecision : (colName.endsWith("Local") ? localPrecision : (colName.endsWith("Rpt") ? rptPrecision : qtyPrecision));
                        if (scale >= 0) {
                            row.getCell(colName).getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(scale));
                        }
                        row.getCell(colName).setValue((Object)b);
                        continue;
                    }
                    row.getCell(colName).setValue((Object)value);
                }
                this.afterFillTableRow(row, rowData);
            }
            ++rowIndex;
        }
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.findVoucher();
    }

    @Override
    protected void setQueryingActionStatus(boolean enable) {
        super.setQueryingActionStatus(enable);
        this.actionVoucher.setEnabled(enable);
    }

    @Override
    protected Map<String, Object> getSearchParams(int type) {
        Map<String, Object> params = super.getSearchParams(type);
        params.put("showRemoteSearch", "true");
        return params;
    }

    @Override
    protected List<Map<String, String>> getSearchTargets(int type) {
        ArrayList<Map<String, String>> targets = new ArrayList<Map<String, String>>();
        GLNRptTable table = this.getTable();
        if (table == null) {
            return targets;
        }
        HashSet<String> names = new HashSet<String>();
        names.add("asstActNumber1");
        names.add("asstActLongNumber1");
        names.add("asstActName1");
        names.add("asstActLongName1");
        names.add("asstActNumber2");
        names.add("asstActLongNumber2");
        names.add("asstActName2");
        names.add("asstActLongName2");
        names.add("asstActNumber3");
        names.add("asstActLongNumber3");
        names.add("asstActName3");
        names.add("asstActLongName3");
        names.add("asstActNumber4");
        names.add("asstActLongNumber4");
        names.add("asstActName4");
        names.add("asstActLongName4");
        names.add("asstActNumber5");
        names.add("asstActLongNumber5");
        names.add("asstActName5");
        names.add("asstActLongName5");
        names.add("asstActNumber6");
        names.add("asstActLongNumber6");
        names.add("asstActName6");
        names.add("asstActLongName6");
        names.add("asstActNumber7");
        names.add("asstActLongNumber7");
        names.add("asstActName7");
        names.add("asstActLongName7");
        names.add("asstActNumber8");
        names.add("asstActLongNumber8");
        names.add("asstActName8");
        names.add("asstActLongName8");
        names.add("accountNumber");
        names.add("accountName");
        names.add("accountLongName");
        names.add("currencyNumber");
        names.add("currencyName");
        names.add("bookedDate");
        names.add("bizDate");
        names.add("companyNumber");
        names.add("companyLongNumber");
        names.add("companyName");
        names.add("voucherType");
        names.add("voucherNumber");
        names.add("description");
        names.add("creatorName");
        names.add("debitFor");
        names.add("creditFor");
        names.add("endBalanceFor");
        names.add("debitLocal");
        names.add("creditLocal");
        names.add("endBalanceLocal");
        names.add("debitRpt");
        names.add("creditRpt");
        names.add("endBalanceRpt");
        HashSet<Integer> selectedIndexs = new HashSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            KDTSelectBlock block = table.getSelectManager().get(i);
            if (block.getMode() != 1 && block.getMode() != 15 && block.getMode() != 4 && block.getMode() != 12) continue;
            for (int j = block.getLeft(); j <= block.getRight(); ++j) {
                selectedIndexs.add(j);
            }
        }
        IRow headRow = null;
        if (table.getHeadRowCount() > 0) {
            headRow = table.getHeadRow(table.getHeadRowCount() - 1);
        }
        for (int columIndex = 0; columIndex < table.getColumnCount(); ++columIndex) {
            Object title;
            ICell cell;
            String key;
            IColumn col = table.getColumn(columIndex);
            if (col == null || col.getStyleAttributes().isHided() || (key = col.getKey()) == null || !names.contains(key)) continue;
            HashMap<String, String> target = new HashMap<String, String>();
            target.put("name", key);
            if (key.startsWith("asstActNumber")) {
                target.put("title", "asstActNumber" + key.substring(13));
                if (headRow != null && (cell = headRow.getCell(columIndex)) != null && (title = cell.getValue()) != null) {
                    target.put("title", title.toString());
                }
            } else if (key.startsWith("asstActLongNumber")) {
                target.put("title", "asstActLongNumber" + key.substring(13));
                if (headRow != null && (cell = headRow.getCell(columIndex)) != null && (title = cell.getValue()) != null) {
                    target.put("title", title.toString());
                }
            } else if (key.startsWith("asstActName")) {
                target.put("title", this.getResource("asstAct") + key.substring(11));
                if (headRow != null && (cell = headRow.getCell(columIndex)) != null && (title = cell.getValue()) != null) {
                    target.put("title", title.toString());
                }
            } else if (key.startsWith("asstActLongName")) {
                target.put("title", this.getResource("asstAct") + key.substring(11));
                if (headRow != null && (cell = headRow.getCell(columIndex)) != null && (title = cell.getValue()) != null) {
                    target.put("title", title.toString());
                }
            } else {
                target.put("title", this.getResource(key));
            }
            if (type == 1) {
                if (selectedIndexs.contains(columIndex)) {
                    target.put("selected", "true");
                } else {
                    target.put("selected", "false");
                }
            } else if (type == 2 && selectedIndexs.contains(columIndex)) {
                target.put("selected", "true");
            }
            targets.add(target);
        }
        return targets;
    }

    @Override
    public Object getTablePreferenceSchemaKey() {
        Object key = super.getTablePreferenceSchemaKey();
        Object showAsstActNumber = this.queryConfig.get("showAsstActNumber");
        Object showAsstActLongNumber = this.queryConfig.get("showAsstActLongNumber");
        Object showAsstActLongName = this.queryConfig.get("showAsstActLongName");
        return key + "||" + showAsstActNumber + "||" + showAsstActLongNumber + "||" + showAsstActLongName;
    }

    protected void initHelper() {
        this.tHelperPrint = this.tHelper = new GLNRptTableHelper(this, new IObjectMultiPKBuilder(){

            public IObjectPK buildPK() {
                return GLNRptAsstactGDUI.this.buildPK();
            }
        });
    }

    @Override
    protected String getExportPermissionItem() {
        return "gln_rptasstact_gd_export";
    }
}

