/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLNRptCashflowTableQueryUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class GLNRptCashflowTableQueryUI
extends AbstractGLNRptCashflowTableQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptCashflowTableQueryUI.class);
    DataChangeListener companyListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                GLNRptCashflowTableQueryUI.this.companyDataChange();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                GLNRptCashflowTableQueryUI.this.handUIException(ex);
            }
            Object object = GLNRptCashflowTableQueryUI.this.promptCompany.getValue();
            if (object != null) {
                GLNRptCashflowTableQueryUI.this.promptOrgTree.setValue(null);
                GLNRptCashflowTableQueryUI.this.promptUnion.setValue(null);
            }
        }
    };
    DataChangeListener periodTypeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            GLNRptCashflowTableQueryUI.this.periodTypeDataChange();
        }
    };
    DataChangeListener tableListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                GLNRptCashflowTableQueryUI.this.tableDataChange();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                GLNRptCashflowTableQueryUI.this.handUIException(ex);
            }
        }
    };
    DataChangeListener orgTreeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                GLNRptCashflowTableQueryUI.this.orgTreeChange();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                GLNRptCashflowTableQueryUI.this.handUIException(ex);
            }
        }
    };
    DataChangeListener unionListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                GLNRptCashflowTableQueryUI.this.unionChange();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                GLNRptCashflowTableQueryUI.this.handUIException(ex);
            }
        }
    };

    public GLNRptCashflowTableQueryUI() throws Exception {
        this.init();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    protected void init() {
        this.kDRadioButtonCompany.setSelected(true);
        this.kDRadioButtonUnion.setSelected(false);
        this.kDRadioButtonCompany.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    boolean selected = GLNRptCashflowTableQueryUI.this.kDRadioButtonCompany.isSelected();
                    GLNRptCashflowTableQueryUI.this.kDPanelByCompany.setVisible(selected);
                    GLNRptCashflowTableQueryUI.this.kDPanelByUnion.setVisible(!selected);
                    GLNRptCashflowTableQueryUI.this.kDRadioButtonUnion.setSelected(!selected);
                }
                catch (Exception exc) {
                    GLNRptCashflowTableQueryUI.this.handUIException(exc);
                }
            }
        });
        this.kDRadioButtonUnion.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    boolean selected = GLNRptCashflowTableQueryUI.this.kDRadioButtonUnion.isSelected();
                    GLNRptCashflowTableQueryUI.this.kDPanelByUnion.setVisible(selected);
                    GLNRptCashflowTableQueryUI.this.kDPanelByCompany.setVisible(!selected);
                    GLNRptCashflowTableQueryUI.this.kDRadioButtonCompany.setSelected(!selected);
                }
                catch (Exception exc) {
                    GLNRptCashflowTableQueryUI.this.handUIException(exc);
                }
            }
        });
        this.promptPeriodType.setEditable(true);
        this.promptPeriodType.setEditFormat("$number$");
        this.promptPeriodType.setCommitFormat("$number$;$name$");
        this.promptPeriodType.setDisplayFormat("$name$");
        this.promptCurrency.setEditable(true);
        this.promptCurrency.setEditFormat("$number$");
        this.promptCurrency.setCommitFormat("$number$;$name$");
        this.promptCurrency.setDisplayFormat("$name$");
        this.promptAccountTable.setEditable(true);
        this.promptAccountTable.setEditFormat("$number$");
        this.promptAccountTable.setCommitFormat("$number$;$name$");
        this.promptAccountTable.setDisplayFormat("$name$");
        this.promptAccountTable.addCommonF7KDTableListener(this.accountTableF7ColumnListener);
        this.promptCompany.setEditFormat("$number$");
        this.promptCompany.setCommitFormat("$name$;$number$");
        this.promptCompany.setDisplayFormat("$name$");
        this.promptCompany.setQueryInfo("com.kingdee.eas.fi.gl.app.F7CompanyOrgUnitQuery");
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.promptCompany.setEntityViewInfo(companyView);
        this.promptCompany.setSelector(this.getCompanySelector());
        this.promptCompany.setEditable(true);
        CompanyDisplayModeEnum[] items = new CompanyDisplayModeEnum[]{CompanyDisplayModeEnum.level, CompanyDisplayModeEnum.details, CompanyDisplayModeEnum.enumerate};
        this.cbCompanyDisplayMode.addItems((Object[])items);
        this.spCompanyLevel.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 15, 1));
        this.promptOrgTree.setEditFormat("$number$");
        this.promptOrgTree.setCommitFormat("$name$;$number$");
        this.promptOrgTree.setDisplayFormat("$name$ $startDate$");
        this.promptOrgTree.setQueryInfo("com.kingdee.eas.basedata.org.app.OrgTreeQuery");
        EntityViewInfo orgTreeView = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)8));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)-1, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("layerType", (Object)1));
        orgTreeView.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo si = new SorterItemInfo("number");
        si.setSortType(SortType.ASCEND);
        sorter.add(si);
        si = new SorterItemInfo("startDate");
        si.setSortType(SortType.DESCEND);
        sorter.add(si);
        orgTreeView.setSorter(sorter);
        this.promptOrgTree.setEntityViewInfo(orgTreeView);
        this.promptOrgTree.setEditable(true);
        this.promptOrgTree.setHasCUDefaultFilter(false);
        this.promptUnion.setEditFormat("$number$");
        this.promptUnion.setCommitFormat("$name$;$number$");
        this.promptUnion.setDisplayFormat("$name$");
        this.promptUnion.setQueryInfo("com.kingdee.eas.fi.gl.app.UnionStructureQuery");
        this.promptUnion.setEnabledMultiSelection(true);
        this.promptUnion.setEditable(true);
        this.promptUnion.setHasCUDefaultFilter(false);
        this.spThreadCount.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 64, 1));
        this.initAdvanceOptions();
        this.promptCompany.addDataChangeListener(this.companyListener);
        this.promptAccountTable.addDataChangeListener(this.tableListener);
        this.promptPeriodType.addDataChangeListener(this.periodTypeListener);
        this.promptOrgTree.addDataChangeListener(this.orgTreeListener);
        this.promptUnion.addDataChangeListener(this.unionListener);
        this.kDLabelContainer11.setVisible(false);
        this.kDLabel4.setVisible(false);
        this.lbExtends.setVisible(false);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected void initDefaultSetting() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.promptCompany.removeDataChangeListener(this.companyListener);
        this.kDRadioButtonCompany.setSelected(true);
        this.kDPanelByCompany.setVisible(true);
        this.kDRadioButtonUnion.setSelected(false);
        this.kDPanelByUnion.setVisible(false);
        this.promptCompany.setValue((Object)new CompanyOrgUnitInfo[]{company});
        this.promptOrgTree.setValue(null);
        this.promptUnion.setValue(null);
        this.cbSumByUnion.setSelected(false);
        this.companyDataChange();
        this.promptCompany.addDataChangeListener(this.companyListener);
        this.initUnion(null);
        this.cbCompanyDisplayMode.setSelectedIndex(0);
        this.spCompanyLevel.setValue((Object)0);
        this.cbBalType.setSelected(false);
        this.rbByPeriod.setSelected(true);
        this.rbShowAsst.setSelected(false);
        this.rbShowExchangeItem.setSelected(false);
        this.rbShowInvisibleItem.setSelected(false);
        this.rbShowCashInitEndBalance.setSelected(true);
        this.rbShowSupplementItem.setSelected(false);
        this.rbShowAsstNumber.setSelected(false);
        this.rbShowAsstLongName.setSelected(false);
        this.spinSumItemLevel.setModel((SpinnerModel)new SpinnerNumberModel(10, 1, 10, 1));
        this.spThreadCount.setValue((Object)1);
        this.txtExtends.setText("");
    }

    @Override
    protected void showAdvanceActionPerformed(ActionEvent e) {
        this.lbExtends.setVisible(!this.lbExtends.isVisible());
    }

    protected void companyDataChange() throws EASBizException, BOSException {
        Object[] cs;
        Object object = this.promptCompany.getValue();
        CompanyOrgUnitInfo company = null;
        CompanyOrgUnitInfo bizCompany = null;
        if (object instanceof CompanyOrgUnitInfo[]) {
            cs = (CompanyOrgUnitInfo[])object;
            company = this.getTopCompany((CompanyOrgUnitInfo[])cs);
            bizCompany = this.getBizCompany((CompanyOrgUnitInfo[])cs);
        } else if (object instanceof Object[]) {
            cs = (Object[])object;
            company = this.getTopCompany(cs);
            bizCompany = this.getBizCompany(cs);
        } else if (object instanceof CompanyOrgUnitInfo) {
            company = (CompanyOrgUnitInfo)object;
        } else if (object instanceof String) {
            cs = this.getCompanys((String)object);
            company = this.getTopCompany((CompanyOrgUnitInfo[])cs);
            bizCompany = this.getBizCompany((CompanyOrgUnitInfo[])cs);
        }
        if (company == null) {
            return;
        }
        if (bizCompany == null) {
            bizCompany = this.getFirstBizCompany(company);
        }
        PeriodTypeInfo periodType = null;
        AccountTableInfo accountTable = null;
        CurrencyInfo currency = null;
        if (company.getAccountPeriodType() != null) {
            periodType = company.getAccountPeriodType().getNumber() != null ? company.getAccountPeriodType() : PeriodTypeFactory.getRemoteInstance().getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(company.getAccountPeriodType().getId()));
        }
        if (company.getBaseCurrency() != null) {
            currency = company.getBaseCurrency().getNumber() != null ? company.getBaseCurrency() : CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
        }
        if (company.getAccountTable() != null) {
            accountTable = company.getAccountTable().getNumber() != null ? company.getAccountTable() : AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(company.getAccountTable().getId()));
        }
        this.promptPeriodType.removeDataChangeListener(this.periodTypeListener);
        this.promptPeriodType.setValue((Object)periodType);
        this.periodTypeDataChange();
        this.promptPeriodType.addDataChangeListener(this.periodTypeListener);
        if (periodType != null && bizCompany != null) {
            PeriodInfo current;
            if (bizCompany.getAccountPeriodType() == null || bizCompany.getAccountPeriodType().getId() == null) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("accountPeriodType.id");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)bizCompany.getId().toString()));
                view.setFilter(filter);
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                if (coll.size() > 0) {
                    bizCompany.setAccountPeriodType(coll.get(0).getAccountPeriodType());
                }
            }
            if (bizCompany.getAccountPeriodType().getId().equals((Object)periodType.getId()) && (current = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(bizCompany.getId().toString()))) != null) {
                this.spnPeriodYearBegin.setValue((Object)current.getPeriodYear());
                this.spnPeriodNumberBegin.setValue((Object)current.getPeriodNumber());
                this.spnPeriodYearEnd.setValue((Object)current.getPeriodYear());
                this.spnPeriodNumberEnd.setValue((Object)current.getPeriodNumber());
            }
        }
        this.promptCurrency.setValue((Object)currency);
        this.promptAccountTable.setValue((Object)accountTable);
        if (accountTable == null) {
            accountTable = company.getAccountTable();
        }
        this.tableDataChange();
    }

    protected void periodTypeDataChange() {
        PeriodTypeInfo periodType = null;
        Object object = this.promptPeriodType.getValue();
        if (object instanceof PeriodTypeInfo) {
            periodType = (PeriodTypeInfo)object;
        }
        if (periodType == null) {
            return;
        }
        try {
            boolean isPeriodEnable;
            Set<String> companyIdSet = this.getPeriodCompanyIds(this.promptCompany.getValue(), (OrgTreeInfo)this.promptOrgTree.getValue(), this.promptUnion.getValue(), periodType);
            boolean bl = isPeriodEnable = !companyIdSet.isEmpty();
            if (isPeriodEnable) {
                PeriodEntity pe;
                Map pdRang = this.getIGLRptBaseFacade().getPeriodRange(companyIdSet, periodType.getId().toString());
                this.pe = pe = new PeriodEntity(pdRang);
                SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)false, (boolean)false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected IGLRptBaseFacade getIGLRptBaseFacade() throws BOSException {
        return GLRptAccountBalanceFacadeFactory.getRemoteInstance();
    }

    protected Set getCompanyIdSet() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        HashSet<String> idSet = new HashSet<String>();
        if (companys == null) {
            return idSet;
        }
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    protected CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.promptCompany.getValue();
        if (company instanceof CompanyOrgUnitInfo) {
            return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
        }
        if (this.promptCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            return (CompanyOrgUnitInfo[])this.promptCompany.getValue();
        }
        if (this.promptCompany.getValue() instanceof Object[]) {
            Object[] companyObjs = (Object[])this.promptCompany.getValue();
            return this.toObjectArray2CompanyArray(companyObjs);
        }
        return null;
    }

    protected void orgTreeChange() throws EASBizException, BOSException {
        OrgTreeInfo tree = null;
        Object object = this.promptOrgTree.getValue();
        if (object instanceof OrgTreeInfo) {
            tree = (OrgTreeInfo)object;
        }
        this.promptUnion.setValue(null);
        this.initUnion(tree);
        if (tree != null) {
            this.promptCompany.removeDataChangeListener(this.companyListener);
            try {
                this.promptCompany.setValue((Object)this.getCompanysByOrgTree(tree.getId().toString()));
                this.companyDataChange();
            }
            finally {
                this.promptCompany.addDataChangeListener(this.companyListener);
            }
        }
    }

    protected void unionChange() throws EASBizException, BOSException {
        this.periodTypeDataChange();
    }

    protected void initUnion(OrgTreeInfo tree) {
        if (tree != null) {
            EntityViewInfo unionView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("ot.id", (Object)tree.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("os.isLeaf", (Object)0));
            unionView.setFilter(filter);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo si = new SorterItemInfo("longNumber");
            si.setSortType(SortType.ASCEND);
            sorter.add(si);
            unionView.setSorter(sorter);
            this.promptUnion.setEntityViewInfo(unionView);
        } else {
            EntityViewInfo unionView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("ot.id", (Object)"no"));
            filter.getFilterItems().add(new FilterItemInfo("os.isLeaf", (Object)0));
            unionView.setFilter(filter);
            this.promptUnion.setEntityViewInfo(unionView);
        }
    }

    protected void tableDataChange() throws EASBizException, BOSException {
        AccountTableInfo accountTable = null;
        Object object = this.promptAccountTable.getValue();
        if (object instanceof AccountTableInfo) {
            accountTable = (AccountTableInfo)object;
        }
        if (accountTable == null) {
            return;
        }
        object = this.promptCompany.getValue();
        CompanyOrgUnitInfo company = null;
        if (object instanceof CompanyOrgUnitInfo[]) {
            CompanyOrgUnitInfo[] cs = (CompanyOrgUnitInfo[])object;
            company = this.getTopCompany(cs);
        } else if (object instanceof Object[]) {
            Object[] cs = (Object[])object;
            company = this.getTopCompany(cs);
        } else if (object instanceof CompanyOrgUnitInfo) {
            company = (CompanyOrgUnitInfo)object;
        } else if (object instanceof String) {
            CompanyOrgUnitInfo[] cs = this.getCompanys((String)object);
            company = this.getTopCompany(cs);
        }
        if (company == null) {
            return;
        }
    }

    @Override
    protected String getPermissionItem() {
        return "gl_cashflow_report";
    }

    @Override
    protected void setParam(Object param) {
        if (param != null) {
            Map params = (Map)param;
            this.setGeneralOptions(params);
            this.setVoucherRange(params);
            this.setShowOptions(params);
            this.setOtherOptions(params);
        }
    }

    protected void setGeneralOptions(Map<String, Object> params) {
        CompanyOrgUnitInfo company;
        boolean byCompanyQuery = "true".equals(params.get("byCompanyQuery"));
        this.kDRadioButtonCompany.setSelected(byCompanyQuery);
        this.kDRadioButtonUnion.setSelected(!byCompanyQuery);
        this.kDPanelByCompany.setVisible(byCompanyQuery);
        this.kDPanelByUnion.setVisible(!byCompanyQuery);
        String companyNumber = (String)params.get("companyNumber");
        CompanyOrgUnitInfo[] cs = this.getCompanys(companyNumber);
        this.promptCompany.setValue((Object)cs);
        String companyDisplayMode = (String)params.get("companyDisplayMode");
        if ("level".equals(companyDisplayMode)) {
            this.cbCompanyDisplayMode.setSelectedIndex(0);
        } else if ("details".equals(companyDisplayMode)) {
            this.cbCompanyDisplayMode.setSelectedIndex(1);
        } else if ("enumerate".equals(companyDisplayMode)) {
            this.cbCompanyDisplayMode.setSelectedIndex(2);
        }
        String companyLevel = (String)params.get("companyLevel");
        if (companyLevel != null) {
            try {
                int i = Integer.parseInt(companyLevel);
                if (i >= 0 && i <= 15) {
                    this.spCompanyLevel.setValue((Object)i);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        String orgTreeId = (String)params.get("orgTreeId");
        OrgTreeInfo orgTree = this.getOrgTree(orgTreeId);
        this.promptOrgTree.setValue((Object)orgTree);
        this.initUnion(orgTree);
        OrgUnitInfo[] unions = null;
        if (orgTree != null) {
            String unionNumber = (String)params.get("unionNumber");
            unions = this.getUnions(orgTree.getId().toString(), unionNumber);
        }
        this.promptUnion.setValue(unions);
        this.cbSumByUnion.setSelected(Boolean.parseBoolean((String)params.get("sumByUnion")));
        AccountTableInfo accountTable = this.getAccountTable((String)params.get("accountTableNumber"));
        this.promptAccountTable.setValue((Object)accountTable);
        this.promptPeriodType.setValue((Object)this.getPeriodType((String)params.get("periodTypeNumber")));
        String fromPeriod = (String)params.get("fromPeriodNumber");
        String toPeriod = (String)params.get("toPeriodNumber");
        if (fromPeriod != null && fromPeriod.trim().length() > 0 && toPeriod != null && toPeriod.trim().length() > 0) {
            this.setPeriod(this.spnPeriodYearBegin, this.spnPeriodNumberBegin, this.spnPeriodYearEnd, this.spnPeriodNumberEnd, new Integer(fromPeriod.trim()), new Integer(toPeriod.trim()));
        }
        if ((company = this.getTopCompany(cs)) == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (accountTable == null) {
            accountTable = company.getAccountTable();
        }
        CurrencyInfo[] cys = null;
        String currencyNumber = (String)params.get("currencyNumber");
        if (currencyNumber != null && currencyNumber.trim().length() > 0) {
            HashSet<String> numbers = new HashSet<String>();
            for (String str : currencyNumber.split(";")) {
                if (str.trim().length() <= 0) continue;
                numbers.add(str.trim());
            }
            if (numbers.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                view.setFilter(filter);
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo item = new SorterItemInfo("number");
                item.setSortType(SortType.ASCEND);
                sorter.add(item);
                view.setSorter(sorter);
                try {
                    CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
                    if (coll.size() > 0) {
                        cys = new CurrencyInfo[coll.size()];
                        for (int i = 0; i < coll.size(); ++i) {
                            cys[i] = coll.get(i);
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        this.promptCurrency.setValue(cys != null ? cys[0] : null);
    }

    protected void setOtherOptions(Map<String, Object> param) {
        String threadCount = (String)param.get("threadCount");
        if (threadCount != null) {
            try {
                int i = Integer.parseInt(threadCount);
                if (i >= 1 && i <= 64) {
                    this.spThreadCount.setValue((Object)i);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.txtExtends.setText(param.get("extends") != null ? (String)param.get("extends") : "");
    }

    protected void setShowOptions(Map<String, Object> param) {
        boolean showAsst = false;
        boolean showExchangeItem = false;
        boolean showInvisibleItem = false;
        boolean showCashInitEndBalance = false;
        boolean showSupplementItem = false;
        boolean showAsstNumber = false;
        boolean showAsstLongName = false;
        Integer sumItemLevel = 10;
        if (param.get("showAsst") != null && Boolean.valueOf((String)param.get("showAsst")).booleanValue()) {
            showAsst = true;
        }
        if (param.get("showExchangeItem") != null && Boolean.valueOf((String)param.get("showExchangeItem")).booleanValue()) {
            showExchangeItem = true;
        }
        if (param.get("showInvisibleItem") != null && Boolean.valueOf((String)param.get("showInvisibleItem")).booleanValue()) {
            showInvisibleItem = true;
        }
        if (param.get("showCashInitEndBalance") != null && Boolean.valueOf((String)param.get("showCashInitEndBalance")).booleanValue()) {
            showCashInitEndBalance = true;
        }
        if (param.get("showSupplementItem") != null && Boolean.valueOf((String)param.get("showSupplementItem")).booleanValue()) {
            showSupplementItem = true;
        }
        if (param.get("showAsstNumber") != null && Boolean.valueOf((String)param.get("showAsstNumber")).booleanValue()) {
            showAsstNumber = true;
        }
        if (param.get("showAsstLongName") != null && Boolean.valueOf((String)param.get("showAsstLongName")).booleanValue()) {
            showAsstLongName = true;
        }
        if (param.get("sumItemLevel") != null) {
            sumItemLevel = (int)((Integer)param.get("sumItemLevel"));
        }
        this.rbShowAsst.setSelected(showAsst);
        this.rbShowExchangeItem.setSelected(showExchangeItem);
        this.rbShowInvisibleItem.setSelected(showInvisibleItem);
        this.rbShowCashInitEndBalance.setSelected(showCashInitEndBalance);
        this.rbShowSupplementItem.setSelected(showSupplementItem);
        this.rbShowAsstNumber.setSelected(showAsstNumber);
        this.rbShowAsstLongName.setSelected(showAsstLongName);
        this.spinSumItemLevel.setValue((Object)sumItemLevel);
    }

    protected void setVoucherRange(Map<String, Object> param) {
        this.cbBalType.setSelected(false);
        if (param.get("balType") != null) {
            String balType = (String)param.get("balType");
            if ("1".equals(balType) || Boolean.valueOf(balType).booleanValue()) {
                this.cbBalType.setSelected(true);
            } else {
                this.cbBalType.setSelected(false);
            }
        }
    }

    @Override
    protected Object getParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.getGeneralOptions(param);
        this.getVoucherRange(param);
        this.getShowOptions(param);
        this.getOtherOptions(param);
        return param;
    }

    protected void getGeneralOptions(Map<String, Object> param) {
        Object[] cs;
        StringBuffer str = new StringBuffer();
        Object object = this.promptCompany.getValue();
        if (object instanceof CompanyOrgUnitInfo[]) {
            for (CompanyOrgUnitInfo c : cs = (CompanyOrgUnitInfo[])object) {
                str.append(c.getNumber()).append(";");
            }
        } else if (object instanceof Object[]) {
            for (CompanyOrgUnitInfo c : cs = (Object[])object) {
                str.append(c.getNumber()).append(";");
            }
        } else if (object instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo c = (CompanyOrgUnitInfo)object;
            str.append(c.getNumber()).append(";");
        } else if (object != null) {
            str.append(object.toString());
        }
        if (this.kDRadioButtonCompany.isSelected()) {
            param.put("byCompanyQuery", String.valueOf(this.kDRadioButtonCompany.isSelected()));
            param.put("companyNumber", str.toString());
            CompanyDisplayModeEnum mode = (CompanyDisplayModeEnum)((Object)this.cbCompanyDisplayMode.getSelectedItem());
            param.put("companyDisplayMode", mode.getName());
            param.put("companyLevel", this.spCompanyLevel.getValue().toString());
        } else {
            OrgTreeInfo orgTree = (OrgTreeInfo)this.promptOrgTree.getValue();
            if (orgTree != null) {
                param.put("orgTreeId", orgTree.getId().toString());
                Object[] os = (Object[])this.promptUnion.getValue();
                if (os != null && os.length > 0) {
                    str.setLength(0);
                    for (Object o : os) {
                        str.append(((OrgUnitInfo)o).getNumber()).append(";");
                    }
                    param.put("unionNumber", str.toString());
                }
            }
            param.put("sumByUnion", String.valueOf(this.cbSumByUnion.isSelected()));
        }
        object = this.promptAccountTable.getValue();
        param.put("accountTableNumber", object instanceof AccountTableInfo ? ((AccountTableInfo)object).getNumber() : "");
        object = this.promptPeriodType.getValue();
        param.put("periodTypeNumber", object instanceof PeriodTypeInfo ? ((PeriodTypeInfo)object).getNumber() : "");
        Integer fromPeriodYear = this.spnPeriodYearBegin.getIntegerVlaue();
        Integer fromPeriodNumber = this.spnPeriodNumberBegin.getIntegerVlaue();
        Integer toPeriodYear = this.spnPeriodYearEnd.getIntegerVlaue();
        Integer toPeriodNumber = this.spnPeriodNumberEnd.getIntegerVlaue();
        param.put("fromPeriodNumber", this.getPeriodStr(fromPeriodYear, fromPeriodNumber, str));
        param.put("toPeriodNumber", this.getPeriodStr(toPeriodYear, toPeriodNumber, str));
        object = this.promptCurrency.getValue();
        param.put("currencyNumber", object instanceof CurrencyInfo ? ((CurrencyInfo)object).getNumber() : "");
    }

    protected void getVoucherRange(Map<String, Object> param) {
        param.put("balType", this.cbBalType.isSelected() ? "1" : "5");
    }

    protected void getShowOptions(Map<String, Object> param) {
        param.put("showAsst", String.valueOf(this.rbShowAsst.isSelected()));
        param.put("showExchangeItem", String.valueOf(this.rbShowExchangeItem.isSelected()));
        param.put("showInvisibleItem", String.valueOf(this.rbShowInvisibleItem.isSelected()));
        param.put("showCashInitEndBalance", String.valueOf(this.rbShowCashInitEndBalance.isSelected()));
        param.put("showSupplementItem", String.valueOf(this.rbShowSupplementItem.isSelected()));
        param.put("showAsstNumber", String.valueOf(this.rbShowAsstNumber.isSelected()));
        param.put("showAsstLongName", String.valueOf(this.rbShowAsstLongName.isSelected()));
        param.put("sumItemLevel", this.spinSumItemLevel.getValue());
    }

    protected void getOtherOptions(Map<String, Object> param) {
        param.put("threadCount", this.spThreadCount.getValue().toString());
        param.put("extends", this.txtExtends.getText());
    }
}

