/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CashFlowFilterPara;
import com.kingdee.eas.fi.gl.CashFlowRecordFacadeFactory;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.client.CashFlowListUI;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLNRptCashflowTableUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAccountBalanceExportUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptCashflowTableQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTableHeadInfo;
import com.kingdee.eas.fm.common.client.AbstractHidedMenuItem;
import com.kingdee.eas.util.ResourceBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;

public class GLNRptCashflowTableUI
extends AbstractGLNRptCashflowTableUI {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptCashflowTableUI.class);
    private static final String CF_RESOURCE = "com.kingdee.eas.fi.gl.GLNRptCFResource";
    private IRow curRow = null;
    private Integer seq = 0;
    private String preItemName = null;

    public GLNRptCashflowTableUI() throws Exception {
        this.init();
        this.btnSearch.setVisible(false);
        InputMap imEntry = this.getInputMap(2);
        KeyStroke key = KeyStroke.getKeyStroke(70, 2);
        imEntry.remove(key);
        key = KeyStroke.getKeyStroke(70, 3);
        imEntry.remove(key);
        key = KeyStroke.getKeyStroke(70, 10);
        imEntry.remove(key);
    }

    private void init() {
        this.txtConsole.setContentType("text/html");
        this.txtConsole.setEditable(false);
        StringBuffer htmlText = new StringBuffer();
        htmlText.append("<html>");
        htmlText.append("<body>");
        htmlText.append(this.getResource("detailsUsageInfo"));
        htmlText.append("<br>");
        htmlText.append("<a href=\"https://vip.kingdee.com/article/348055433821180928\">https://vip.kingdee.com/article/348055433821180928</a>");
        htmlText.append("<br>");
        htmlText.append("</body>");
        htmlText.append("</html>");
        this.txtConsole.setText(htmlText.toString());
        this.txtConsole.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(evt.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    protected void setQueryDialogSize(CommonQueryDialog dialog) {
        dialog.setWidth(530);
        dialog.setHeight(525);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initPopMenu(GLNRptAccountBalanceExportUI.class.getName());
        this.addHidenFunction();
    }

    @Override
    protected GLNRptBaseQueryUI getCustQueryPanel() throws Exception {
        return new GLNRptCashflowTableQueryUI();
    }

    @Override
    protected void initPopMenu(String uiClassName) {
        KDTMenuManager tm = this.getMenuManager(this.getTable());
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        Component[] menus = pop.getComponents();
        for (int i = 0; i < menus.length; ++i) {
            Component comp = menus[i];
            if (comp.getName().indexOf("Copy") <= 0 && comp.getName().indexOf("Paste") <= 0) continue;
            comp.setVisible(false);
        }
    }

    @Override
    public void setRptType(Map<String, Object> queryConfig) {
        super.setRptType(queryConfig);
        queryConfig.put("rptType", "Cashflow");
    }

    @Override
    protected void setColumnStyle(IColumn column) {
        if (column == null) {
            return;
        }
        String key = column.getKey();
        if ("seq".equals(key) || "amount".equals(key) || "yearSum".equals(key)) {
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        } else if ("itemLevel".equals(key) || "companyLevel".equals(key) || "isNetRow".equals(key) || "itemID".equals(key) || "companyID".equals(key) || "isQueryRow".equals(key) || "hgID".equals(key) || "isAsstRow".equals(key)) {
            column.getStyleAttributes().setHided(true);
        }
    }

    @Override
    public void fillDataToTable(List<List<String>> data, int startRowIndex) {
        IRow seqStartRow;
        if (this.getTable().getColumns().size() <= 0) {
            return;
        }
        int rowIndex = startRowIndex;
        if (startRowIndex > 2 && (seqStartRow = this.getTable().getRow2(startRowIndex - 1)) != null) {
            this.preItemName = (String)seqStartRow.getCell("cashFlowItemName").getValue();
        }
        int itemNameColumnIdx = (Integer)this.colIndexes.get("cashFlowItemName");
        int itemLevelColumnIdx = (Integer)this.colIndexes.get("itemLevel");
        int seqIdx = (Integer)this.colIndexes.get("seq");
        for (int i = 0; i < data.size(); ++i) {
            IRow row = this.getTable().getRow2(rowIndex);
            if (row == null) {
                row = this.getTable().setRow(rowIndex);
                List<String> rowData = data.get(i);
                String itemName = rowData.get(itemNameColumnIdx);
                String itemLevel = rowData.get(itemLevelColumnIdx);
                if (itemLevel != null) {
                    if (this.preItemName != null && !this.preItemName.equals(itemName)) {
                        Integer n = this.seq;
                        Integer n2 = this.seq = Integer.valueOf(this.seq + 1);
                    }
                    rowData.set(seqIdx, this.seq.toString());
                }
                this.preItemName = itemName;
                this.fillDataToRow(row, rowData);
                this.afterFillTableRow(row, rowData);
            }
            ++rowIndex;
        }
    }

    @Override
    protected void afterFillTableRow(IRow row, List<String> rowData) {
        int itemNameIdx = this.colIndexes.containsKey("cashFlowItemName") ? (Integer)this.colIndexes.get("cashFlowItemName") : -1;
        int companyNameIdx = this.colIndexes.containsKey("companyName") ? (Integer)this.colIndexes.get("companyName") : -1;
        String itemName = rowData.get(itemNameIdx);
        String companyName = rowData.get(companyNameIdx);
        boolean isNetRow = "1".equals(rowData.get((Integer)this.colIndexes.get("isNetRow")));
        if (isNetRow) {
            rowData.set((Integer)this.colIndexes.get("itemLevel"), "2");
            this.fillItemNameByLevel(row, "cashFlowItemName", itemName, rowData);
            this.fillCompanyNameByLevel(row, "companyName", companyName, rowData);
            row.getStyleAttributes().setBackground(new Color(0xF6F6BF));
        } else {
            this.fillItemNameByLevel(row, "cashFlowItemName", itemName, rowData);
            this.fillCompanyNameByLevel(row, "companyName", companyName, rowData);
        }
    }

    protected void fillItemNameByLevel(IRow row, String colName, String value, List<String> rowData) {
        if ("cashFlowItemName".equals(colName) && this.colIndexes.containsKey("itemLevel")) {
            String level = rowData.get((Integer)this.colIndexes.get("itemLevel"));
            if (level == null) {
                return;
            }
            try {
                int itemLevel = Integer.parseInt(level);
                row.getCell(colName).setValue((Object)(this.getBlankString(1, itemLevel) + value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected void fillCompanyNameByLevel(IRow row, String colName, String value, List<String> rowData) {
        if ("companyName".equals(colName) && this.colIndexes.containsKey("companyLevel")) {
            String level = rowData.get((Integer)this.colIndexes.get("companyLevel"));
            if (level == null) {
                return;
            }
            try {
                int companyLevel = Integer.parseInt(level);
                row.getCell(colName).setValue((Object)(this.getBlankString(this.companyTopLevel, companyLevel) + value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private void fillDataToRow(IRow row, List<String> rowData) {
        List<String> columnNames = this.tableHeadInfo.getColumnNames();
        for (int j = 0; j < columnNames.size(); ++j) {
            String colName = columnNames.get(j);
            if (!this.colIndexes.containsKey(colName)) continue;
            row.getCell(colName).setValue((Object)rowData.get((Integer)this.colIndexes.get(colName)));
        }
    }

    public String getCFResource(String resName) {
        String key = resName + "_" + this.getLocate();
        if (resourceCache.containsKey(key)) {
            return (String)resourceCache.get(key);
        }
        String name = ResourceBase.getString((String)CF_RESOURCE, (String)resName, (Locale)this.getLocate());
        resourceCache.put(key, name);
        return name;
    }

    @Override
    public GLNRptTableHeadInfo initTableColumn(List<String> colNames, List<String> colAliass) {
        this.initVariable(this.getTable());
        this.placeholder = "    ";
        this.seq = 0;
        this.tableHeadInfo = new GLNRptTableHeadInfo();
        this.colIndexes.clear();
        ArrayList<String> commonCols = new ArrayList<String>();
        this.isCompanyLevelMode = true;
        for (int i = 0; i < colNames.size(); ++i) {
            String colName = colNames.get(i);
            this.colIndexes.put(colName, i);
            commonCols.add(colName);
        }
        ArrayList<String> allCols = new ArrayList<String>();
        allCols.addAll(commonCols);
        this.tableHeadInfo.setColumnNames(allCols);
        ArrayList<List<String>> columnTitles = new ArrayList<List<String>>();
        this.tableHeadInfo.setColumnTitles(columnTitles);
        ArrayList<String> columnTitle1 = new ArrayList<String>();
        ArrayList<String> columnTitle2 = new ArrayList<String>();
        columnTitles.add(columnTitle1);
        columnTitles.add(columnTitle2);
        for (int i = 0; i < commonCols.size(); ++i) {
            String colName = (String)commonCols.get(i);
            int index = (Integer)this.colIndexes.get(colName);
            String colAlias = colAliass.get(index);
            columnTitle1.add(colAlias);
            columnTitle2.add(colAlias);
        }
        return this.tableHeadInfo;
    }

    @Override
    public int getColumnWidthByColumnName(String colName) {
        if ("cashFlowItemName".equals(colName) || "hgLongNameGroup".equals(colName)) {
            return 400;
        }
        if ("companyName".equals(colName)) {
            return 200;
        }
        if ("amount".equals(colName) || "yearSum".equals(colName)) {
            return 200;
        }
        return 100;
    }

    protected void initListener() {
        super.initListener();
        this.getTable().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int rowIndex = e.getSelectBlock().getTop();
                GLNRptCashflowTableUI.this.tblMain_doSelectChanged(rowIndex);
            }
        });
    }

    public void tblMain_doSelectChanged(int rowIndex) {
        this.curRow = this.getTable().getRow(rowIndex);
        if (this.curRow != null) {
            String isQueryRow = (String)this.curRow.getCell("isQueryRow").getValue();
            this.actionQueryCashflow.setEnabled(isQueryRow != null && isQueryRow.equals("1"));
        }
    }

    @Override
    public void actionQueryCashflow_actionPerformed(ActionEvent e) throws Exception {
        Map params = this.queryConfig;
        boolean showAsst = false;
        boolean includeUnPost = false;
        String param = (String)params.get("showAsst");
        if ("true".equals(param.trim())) {
            showAsst = true;
        }
        if ("1".equals((param = (String)params.get("balType")).trim())) {
            includeUnPost = true;
        }
        param = (String)params.get("currencyNumber");
        String currencyNumber = param.trim();
        CurrencyInfo currency = this.getCurrency(currencyNumber);
        param = (String)params.get("accountTableNumber");
        String accountTableNumber = param.trim();
        AccountTableInfo accountTable = this.getAccountTable(accountTableNumber);
        String companyID = (String)this.curRow.getCell("companyID").getValue();
        String cashFlowItemID = (String)this.curRow.getCell("itemID").getValue();
        String hgID = null;
        CashflowTypeEnum type = null;
        boolean isAsstRow = false;
        if (showAsst) {
            isAsstRow = "1".equals(this.curRow.getCell("isAsstRow").getValue());
            hgID = (String)this.curRow.getCell("hgID").getValue();
            String typeValue = (String)this.curRow.getCell("type").getValue();
            type = typeValue == null || typeValue.trim().length() == 0 ? CashflowTypeEnum.NONE : (typeValue.equals(CashflowTypeEnum.getEnum((int)3).toString()) ? CashflowTypeEnum.IN : CashflowTypeEnum.OUT);
        }
        UIContext uiContext = new UIContext((Object)this);
        CashFlowFilterPara cashFlowFilterPara = new CashFlowFilterPara();
        String fromPeriodNumberStr = (String)params.get("fromPeriodNumber");
        String toPeriodNumberStr = (String)params.get("toPeriodNumber");
        int fromPeriodNumber = Integer.parseInt(fromPeriodNumberStr);
        int toPeriodNumber = Integer.parseInt(toPeriodNumberStr);
        cashFlowFilterPara.setCurrencyId(currency.getId().toString());
        cashFlowFilterPara.setCompanyIds(companyID);
        cashFlowFilterPara.setSelectedCompanyId(companyID);
        cashFlowFilterPara.setMonthFrom((short)(fromPeriodNumber % 100));
        cashFlowFilterPara.setMonthTo((short)(toPeriodNumber % 100));
        cashFlowFilterPara.setYearFrom((short)(fromPeriodNumber / 100));
        cashFlowFilterPara.setYearTo((short)(toPeriodNumber / 100));
        cashFlowFilterPara.setAllVoucher(includeUnPost);
        CashFlowItemInfo item = CashFlowItemFactory.getRemoteInstance().getCashFlowItemInfo((IObjectPK)new ObjectUuidPK(cashFlowItemID));
        cashFlowFilterPara.setCurrency(currency);
        cashFlowFilterPara.setAccountTabel(accountTable);
        uiContext.put((Object)"cashFlowListConditon", (Object)cashFlowFilterPara);
        uiContext.put((Object)"item", (Object)item);
        uiContext.put((Object)"itemEqual", (Object)item.isIsLeaf());
        uiContext.put((Object)"linkQuery", (Object)true);
        StringBuilder str = new StringBuilder();
        str.append(cashFlowFilterPara.getCurrencyId());
        str.append(cashFlowFilterPara.getDateFrom());
        str.append(cashFlowFilterPara.getDateTo());
        str.append(cashFlowFilterPara.getYearFrom());
        str.append(cashFlowFilterPara.getYearTo());
        str.append(cashFlowFilterPara.getMonthFrom());
        str.append(cashFlowFilterPara.getMonthTo());
        str.append(item.getId().toString());
        uiContext.put((Object)"UIClassParam", (Object)str.toString());
        if (showAsst) {
            uiContext.put((Object)"choosedAssGrpID", (Object)hgID);
            uiContext.put((Object)"type", (Object)type);
            uiContext.put((Object)"needType", (Object)Boolean.TRUE);
        }
        uiContext.put((Object)"isChoosedAssGrpRow", (Object)isAsstRow);
        if (item != null) {
            uiContext.put((Object)item.getId().toString(), (Object)"");
        }
        CashFlowListUI.showCashFlow((Map)uiContext);
    }

    protected AccountTableInfo getAccountTable(String accountTableNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountTableNumber));
        view.setFilter(filter);
        AccountTableCollection ats = AccountTableFactory.getRemoteInstance().getAccountTableCollection(view);
        if (ats != null && ats.size() > 0) {
            return ats.get(0);
        }
        return null;
    }

    protected CurrencyInfo getCurrency(String currencyNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("precision");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber));
        view.setFilter(filter);
        CurrencyCollection currencys = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
        if (currencys != null && currencys.size() > 0) {
            return currencys.get(0);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)currencyNumber));
        view.setFilter(filter);
        currencys = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
        if (currencys != null && currencys.size() > 0) {
            return currencys.get(0);
        }
        return null;
    }

    private void addHidenFunction() {
        this.menuFile.add((JMenuItem)new AbstractHidedMenuItem("alt shift S"){

            public void action_actionPerformed() {
                if (GLNRptCashflowTableUI.this.curRow == null || !GLNRptCashflowTableUI.this.actionQueryCashflow.isEnabled()) {
                    return;
                }
                try {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    Map uic = GLNRptCashflowTableUI.this.getUIContext();
                    uic.put("PARAMS", params);
                    IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.CashflowSearchOptionUI", uic, null, OprtState.EDIT);
                    window.show();
                    if (!Boolean.valueOf(String.valueOf(params.get("IsConfirm"))).booleanValue()) {
                        return;
                    }
                    Boolean isPrimarySelect = Boolean.valueOf(String.valueOf(params.remove("IsPrimarySelect")));
                    Boolean isSupSelect = Boolean.valueOf(String.valueOf(params.remove("IsSupSelect")));
                    params.remove("IsConfirm");
                    CashFlowFilterPara cashFlowFilterPara = new CashFlowFilterPara();
                    String fromPeriodNumberStr = (String)GLNRptCashflowTableUI.this.queryConfig.get("fromPeriodNumber");
                    String toPeriodNumberStr = (String)GLNRptCashflowTableUI.this.queryConfig.get("toPeriodNumber");
                    int fromPeriodNumber = Integer.parseInt(fromPeriodNumberStr);
                    int toPeriodNumber = Integer.parseInt(toPeriodNumberStr);
                    cashFlowFilterPara.setMonthFrom((short)(fromPeriodNumber % 100));
                    cashFlowFilterPara.setMonthTo((short)(toPeriodNumber % 100));
                    cashFlowFilterPara.setYearFrom((short)(fromPeriodNumber / 100));
                    cashFlowFilterPara.setYearTo((short)(toPeriodNumber / 100));
                    params.put("QueryParam", cashFlowFilterPara);
                    String companyId = (String)GLNRptCashflowTableUI.this.curRow.getCell("companyID").getValue();
                    params.put("companyId", companyId);
                    Map retValue = CashFlowRecordFacadeFactory.getRemoteInstance().queryAssignedIncorrectVoucher(isPrimarySelect, isSupSelect, params);
                    List ids = (List)retValue.get("IDS");
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"IDList", (Object)ids);
                    IUIWindow winVoucherList = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.VoucherListUI", (Map)uiContext);
                    winVoucherList.show();
                }
                catch (UIException e) {
                    GLNRptCashflowTableUI.this.handleException((Exception)((Object)e));
                }
                catch (BOSException e) {
                    GLNRptCashflowTableUI.this.handleException((Exception)((Object)e));
                }
                catch (EASBizException e) {
                    GLNRptCashflowTableUI.this.handleException((Exception)((Object)e));
                }
            }
        });
    }
}

