/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLEditor;
import com.kingdee.eas.fi.gl.common.KDSpinnerCellEditor;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLNRptExportBaseUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptGeneralBizPromptBox;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptGroupAsstItemSelectorListener;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class GLNRptExportBaseUI
extends AbstractGLNRptExportBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptExportBaseUI.class);
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLNResource";
    protected Map<String, AsstActTypeInfo> asstActTypes = new HashMap<String, AsstActTypeInfo>();
    protected static final DateFormat DF_IMP = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat DF_LOG = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    protected static final String commonSorterRes = "com.kingdee.eas.base.commonquery.client.CommonSorterPanel";
    protected static final Color WARN_COLOR = new Color(246, 168, 46);
    public static final Color LOCKCOLOR = new Color(228, 228, 228);
    private boolean assistFromOrToChange = false;
    protected boolean isRunning = false;
    protected boolean stop = false;
    protected Locale locate;
    protected String permissionFilter = null;
    private KDTEditAdapter tblAsstListener = null;
    private final Map<Integer, GLNRptGeneralBizPromptBox> isBasicInfo = new HashMap<Integer, GLNRptGeneralBizPromptBox>();
    private final Map<String, Object[]> standardsCache = new HashMap<String, Object[]>();

    public Locale getLocate() {
        if (this.locate == null) {
            this.locate = SysContext.getSysContext().getLocale();
        }
        return this.locate;
    }

    public String getResource(String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)this.getLocate());
    }

    protected KDPromptSelector getCompanySelector() {
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(true);
        companySelector.setIsCUFilter(false);
        companySelector.setContainSealUp(true);
        companySelector.setNeedAddAssistant(true);
        companySelector.setMultiSelect(true);
        companySelector.setOuterFilterInfo(this.getCompanyFilterInfo());
        return companySelector;
    }

    protected FilterInfo getCompanyFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        return filter;
    }

    protected String getCompanyIdFilter() {
        StringBuffer sql = new StringBuffer();
        sql.append("select c.FID from T_ORG_Company c \n");
        sql.append("where ( \n");
        sql.append("    c.FIsBizUnit = 0 \n");
        sql.append("    or c.FIsBizUnit = 1 and exists ( \n");
        sql.append("        select 1 from T_BD_SystemStatusCtrol ssc \n");
        sql.append("        join T_BD_SystemStatus ss on ss.FID = ssc.FSystemStatusID \n");
        sql.append("        where ss.FName = 6 and ssc.FIsStart = 1 \n");
        sql.append("            and ssc.FCompanyID = c.FID \n");
        sql.append("            and ssc.FStartPeriodID is not null \n");
        sql.append("            and ssc.FCurrentPeriodID is not null \n");
        sql.append("    ) \n");
        sql.append(") \n");
        String permissionFilter = this.getPermissionFilter();
        if (permissionFilter != null) {
            sql.append("and c.FID in ( \n");
            sql.append(permissionFilter);
            sql.append(") \n");
        }
        return sql.toString();
    }

    protected String getPermissionFilter() {
        if (this.permissionFilter != null) {
            return this.permissionFilter;
        }
        String permissionItem = this.getPermissionItem();
        if (permissionItem == null) {
            return null;
        }
        String permissionItemId = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)permissionItem));
        view.setFilter(filter);
        try {
            PermItemCollection items = PermItemFactory.getRemoteInstance().getPermItemCollection(view);
            if (items.size() > 0) {
                permissionItemId = items.get(0).getId().toString();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("    SELECT UserOrgPerm.FOrgID FOrgID \n");
        sql.append("    FROM T_PM_UserOrgPerm UserOrgPerm \n");
        sql.append("    WHERE UserOrgPerm.FOwner = '" + userId + "' \n");
        sql.append("        AND UserOrgPerm.FPermItemID = '" + permissionItemId + "' \n");
        sql.append("    union \n");
        sql.append("    SELECT UserRoleOrg.FOrgID AS FOrgID \n");
        sql.append("    FROM T_PM_RolePerm RolePerm \n");
        sql.append("    INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON RolePerm.FRoleID = UserRoleOrg.FRoleID \n");
        sql.append("    WHERE UserRoleOrg.FUserID = '" + userId + "' \n");
        sql.append("        AND RolePerm.FPermItemID = '" + permissionItemId + "' \n");
        sql.append("     \n");
        this.permissionFilter = sql.toString();
        return this.permissionFilter;
    }

    protected String getPermissionItem() {
        return null;
    }

    protected CompanyOrgUnitInfo[] getCompanys(String companyNumber) {
        CompanyOrgUnitInfo[] cs = null;
        if (companyNumber == null || companyNumber.length() == 0) {
            return cs;
        }
        HashSet<String> numbers = new HashSet<String>();
        for (String str : companyNumber.split(";")) {
            if (str.trim().length() <= 0) continue;
            numbers.add(str.trim());
        }
        if (numbers.size() > 0) {
            EntityViewInfo companyView = new EntityViewInfo();
            companyView.setSelector(GlUtils.getCompanySic());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
            companyView.setFilter(filter);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo item = new SorterItemInfo("longNumber");
            item.setSortType(SortType.ASCEND);
            sorter.add(item);
            companyView.setSorter(sorter);
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(companyView);
                if (coll.size() > 0) {
                    cs = new CompanyOrgUnitInfo[coll.size()];
                    for (int i = 0; i < coll.size(); ++i) {
                        cs[i] = coll.get(i);
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return cs;
    }

    protected CompanyOrgUnitInfo getTopCompany(CompanyOrgUnitInfo[] companys) {
        if (companys == null || companys.length == 0) {
            return null;
        }
        if (companys.length == 1) {
            return companys[0];
        }
        CompanyOrgUnitInfo company = null;
        for (int i = 0; i < companys.length; ++i) {
            if (company == null) {
                company = companys[i];
                continue;
            }
            if (companys[i] == null || companys[i].getLevel() >= company.getLevel()) continue;
            company = companys[i];
        }
        return company;
    }

    protected CompanyOrgUnitInfo getTopCompany(Object[] companys) {
        if (companys == null || companys.length == 0) {
            return null;
        }
        if (companys.length == 1) {
            return (CompanyOrgUnitInfo)companys[0];
        }
        CompanyOrgUnitInfo company = null;
        for (int i = 0; i < companys.length; ++i) {
            if (company == null) {
                company = (CompanyOrgUnitInfo)companys[i];
                continue;
            }
            if (companys[i] == null || ((CompanyOrgUnitInfo)companys[i]).getLevel() >= company.getLevel()) continue;
            company = (CompanyOrgUnitInfo)companys[i];
        }
        return company;
    }

    protected CompanyOrgUnitInfo getBizCompany(CompanyOrgUnitInfo[] companys) {
        if (companys == null || companys.length == 0) {
            return null;
        }
        for (int i = 0; i < companys.length; ++i) {
            if (companys[i] == null || !companys[i].isIsBizUnit()) continue;
            return companys[i];
        }
        return null;
    }

    protected CompanyOrgUnitInfo getBizCompany(Object[] companys) {
        if (companys == null || companys.length == 0) {
            return null;
        }
        for (int i = 0; i < companys.length; ++i) {
            if (companys[i] == null || !((CompanyOrgUnitInfo)companys[i]).isIsBizUnit()) continue;
            return (CompanyOrgUnitInfo)companys[i];
        }
        return null;
    }

    protected CompanyOrgUnitInfo getFirstBizCompany(CompanyOrgUnitInfo company) {
        if (company != null) {
            if (company.isIsBizUnit()) {
                return company;
            }
            if (!company.containsKey("longNumber")) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("longNumber");
                try {
                    company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return null;
                }
            }
        }
        String companyId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 c.FID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_BD_SystemStatus s \n");
        sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("where c.FIsBizUnit = 1 \n");
        sql.append("    and sc.FStartPeriodID is not null \n");
        sql.append("    and sc.FCurrentPeriodID is not null \n");
        if (company != null && company.getLongNumber() != null) {
            sql.append("    and c.FLongNumber like '" + company.getLongNumber() + "!%' \n");
        }
        sql.append("order by c.FLongNumber \n");
        try {
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            if (rs.next()) {
                companyId = rs.getString("FID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (companyId != null) {
            try {
                return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected OrgTreeInfo getOrgTree(String orgTreeId) {
        if (orgTreeId == null || orgTreeId.trim().length() == 0) {
            return null;
        }
        orgTreeId = orgTreeId.trim();
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgTreeId));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            selector.add("type");
            selector.add("basic");
            selector.add("startDate");
            selector.add("endDate");
            selector.add("status");
            OrgTreeCollection coll = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(view);
            if (coll != null && coll.size() > 0) {
                return coll.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected OrgUnitInfo[] getUnions(String orgTreeId, String unionNumber) {
        OrgUnitInfo[] unions = null;
        if (unionNumber != null && unionNumber.trim().length() > 0) {
            HashSet<String> numbers = new HashSet<String>();
            for (String str : unionNumber.split(";")) {
                if (str.trim().length() <= 0) continue;
                numbers.add(str.trim());
            }
            if (numbers.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("level");
                selector.add("isLeaf");
                selector.add("unit.id");
                selector.add("unit.number");
                selector.add("unit.name");
                selector.add("unit.longNumber");
                selector.add("unit.displayName");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeId));
                filter.getFilterItems().add(new FilterItemInfo("unit.number", numbers, CompareType.INCLUDE));
                view.setFilter(filter);
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo item = new SorterItemInfo("longNumber");
                item.setSortType(SortType.ASCEND);
                sorter.add(item);
                view.setSorter(sorter);
                try {
                    OrgStructureCollection coll = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(view);
                    if (coll.size() > 0) {
                        unions = new OrgUnitInfo[coll.size()];
                        for (int i = 0; i < coll.size(); ++i) {
                            unions[i] = coll.get(i).getUnit();
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        return unions;
    }

    protected CompanyOrgUnitInfo[] getCompanysByOrgTree(String orgTreeId) {
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("CU.id");
            selector.add("CU.number");
            OrgTreeInfo orgTree = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTreeId), selector);
            if (orgTree.getCU() == null) {
                return null;
            }
            return this.getCompanys(orgTree.getCU().getNumber());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void initAsstAccount(KDBizPromptBox bizPromptBox) {
        bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.auxacct.app.F7AsstAccountForRefQuery");
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        bizPromptBox.setEditable(true);
        bizPromptBox.setFilterInfoProducer(new IFilterInfoProducer(){

            public FilterInfo getFilterInfo() {
                return new FilterInfo();
            }

            public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
            }

            public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
            }
        });
    }

    protected void initAccount(CompanyOrgUnitInfo company, AccountTableInfo table, KDBizPromptBox prmptAccount) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        if (table != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)table.getId().toString()));
        } else {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)"emptyid"));
        }
        filter.setMaskString("#0 and #1");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        prmptAccount.setEntityViewInfo(view);
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, company, table, filter, false, false);
        prmptAccount.setSelector((KDPromptSelector)apb);
    }

    protected Map<String, AccountViewInfo> getAccounts(CompanyOrgUnitInfo company, AccountTableInfo table, Set<String> accountNumbers) {
        HashMap<String, AccountViewInfo> map = new HashMap<String, AccountViewInfo>();
        if (company == null || table == null || accountNumbers == null || accountNumbers.size() == 0) {
            return map;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)table.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", accountNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
            for (AccountViewInfo account : coll) {
                map.put(account.getNumber(), account);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return map;
    }

    protected List<String> split(String str, String regex) {
        ArrayList<String> list = new ArrayList<String>();
        if (str != null) {
            String[] ss;
            for (String s : ss = str.split(regex)) {
                if (s.trim().length() <= 0) continue;
                list.add(s.trim());
            }
        }
        return list;
    }

    public boolean isStop() {
        return this.stop;
    }

    protected String getConfigFile() {
        return null;
    }

    protected Map<String, String> buildConfig() {
        return null;
    }

    protected void saveConfig() {
        File file;
        Map<String, String> params = this.buildConfig();
        String filepath = this.getFilepath();
        if (filepath != null && (filepath = FilenameUtils.normalize((String)filepath)) != null && (file = new File(filepath)).isDirectory()) {
            this.saveConfig(params, filepath + this.getConfigFile());
        }
    }

    public void open(File file) {
        String command = "cmd /c start " + file.getAbsolutePath();
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void explorerFile(File file, boolean select) {
        if (file != null) {
            try {
                String command = "explorer ";
                if (select) {
                    command = command + "/select, ";
                }
                command = command + file.getAbsolutePath();
                Runtime.getRuntime().exec(command);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void info(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, Color.black);
    }

    public void warn(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, WARN_COLOR);
    }

    public void error(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, Color.red);
    }

    public void error(Throwable t) {
        this.error(GlUtils.printStackTrace(t));
    }

    protected synchronized void log(String msg, Color color) {
    }

    protected String getFilepath() {
        String tempPath = System.getProperty("easclient.root");
        if (tempPath == null) {
            return null;
        }
        tempPath = tempPath + "/";
        tempPath = tempPath.replace('/', File.separatorChar);
        tempPath = tempPath.replace('\\', File.separatorChar);
        return tempPath;
    }

    protected void saveConfig(Map<String, String> params, String filename) {
        ArrayList<String> lines = new ArrayList<String>(params.size());
        for (String key : params.keySet()) {
            lines.add(key + "=" + params.get(key));
        }
        this.saveTxt(lines, filename, "UTF-8");
    }

    protected Map<String, String> loadConfig(String filename) {
        List<String> lines = this.loadTxt(filename, "UTF-8");
        HashMap<String, String> params = new HashMap<String, String>();
        for (String line : lines) {
            int index = (line = line.trim()).indexOf("=");
            if (index <= 0) continue;
            params.put(line.substring(0, index), line.substring(index + 1));
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveTxt(List<String> lines, String filename, String coding) {
        try (PrintWriter writer = null;){
            filename = FilenameUtils.normalize((String)filename);
            if (filename == null) {
                throw new IOException();
            }
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), coding));
            for (String line : lines) {
                writer.println(line);
            }
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> loadTxt(String filename, String coding) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            filename = FilenameUtils.normalize((String)filename);
            if (filename == null) {
                throw new IOException();
            }
            File file = new File(filename);
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), coding));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            this.error(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return lines;
    }

    protected PeriodTypeInfo getPeriodType(String periodTypeNumber) {
        if (periodTypeNumber == null || periodTypeNumber.trim().length() == 0) {
            return null;
        }
        periodTypeNumber = periodTypeNumber.trim();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)periodTypeNumber.trim()));
        view.setFilter(filter);
        try {
            PeriodTypeCollection coll = PeriodTypeFactory.getRemoteInstance().getPeriodTypeCollection(view);
            if (coll.size() > 0) {
                return coll.get(0);
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    protected AccountTableInfo getAccountTable(String accountTableNumber) {
        if (accountTableNumber == null || accountTableNumber.trim().length() == 0) {
            return null;
        }
        accountTableNumber = accountTableNumber.trim();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountTableNumber));
        try {
            AccountTableCollection coll = AccountTableFactory.getRemoteInstance().getAccountTableCollection(view);
            if (coll.size() > 0) {
                return coll.get(0);
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    protected AsstActTypeInfo getAsstActType(String asstActTypeNumber) {
        if (asstActTypeNumber == null || asstActTypeNumber.trim().length() == 0) {
            return null;
        }
        if (this.asstActTypes.containsKey(asstActTypeNumber = asstActTypeNumber.trim())) {
            return this.asstActTypes.get(asstActTypeNumber);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)asstActTypeNumber));
        AsstActTypeInfo asstActType = null;
        try {
            AsstActTypeCollection coll = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection(view);
            if (coll.size() > 0) {
                asstActType = coll.get(0);
            }
            this.asstActTypes.put(asstActTypeNumber, asstActType);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return asstActType;
    }

    protected void initAsstTable(final KDTable tblAsst, KDWorkButton kdUp, KDWorkButton kdDown, final CompanyOrgUnitInfo[] companies) {
        IColumn levelCol;
        kdUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        kdUp.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveUp"));
        kdDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        kdDown.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveDown"));
        tblAsst.checkParsed();
        tblAsst.getSelectManager().setSelectMode(1);
        tblAsst.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        tblAsst.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        KDTDefaultCellEditor selectEditor = new KDTDefaultCellEditor((JCheckBox)new KDCheckBox());
        tblAsst.getColumn("selected").setEditor((ICellEditor)selectEditor);
        tblAsst.getColumn("selected").setRenderer((IBasicRender)new CellCheckBoxRenderer());
        BizDataFormat groupFormat = new BizDataFormat("$number$ $name$");
        ObjectValueRender groupRender = new ObjectValueRender();
        groupRender.setFormat((IDataFormat)groupFormat);
        tblAsst.getColumn("group").setRenderer((IBasicRender)groupRender);
        tblAsst.getColumn("group").getStyleAttributes().setLocked(true);
        tblAsst.getColumn("to").getStyleAttributes().setLocked(true);
        tblAsst.getColumn("from").getStyleAttributes().setLocked(true);
        tblAsst.getColumn("dist").getStyleAttributes().setLocked(true);
        if (this.tblAsstListener != null) {
            tblAsst.removeKDTEditListener((KDTEditListener)this.tblAsstListener);
        }
        this.tblAsstListener = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                IRow row = tblAsst.getRow(e.getRowIndex());
                if (e.getColIndex() == 0) {
                    tblAsst.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getValue());
                    if (((Boolean)e.getValue()).booleanValue()) {
                        row.getCell("groupStandard").getStyleAttributes().setLocked(false);
                        GLNRptExportBaseUI.this.loadAsstF7(tblAsst, row, companies);
                        row.getCell("dist").getStyleAttributes().setLocked(false);
                    } else {
                        row.getCell("groupStandard").getStyleAttributes().setLocked(true);
                        row.getCell("to").getStyleAttributes().setLocked(true);
                        row.getCell("from").getStyleAttributes().setLocked(true);
                        row.getCell("dist").getStyleAttributes().setLocked(true);
                    }
                } else if (e.getColIndex() == ((KDTable)e.getSource()).getColumnIndex("groupStandard")) {
                    GLNRptExportBaseUI.this.loadAsstGroupF7(tblAsst, row);
                } else if (e.getColIndex() == ((KDTable)e.getSource()).getColumnIndex("collect")) {
                    AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
                    int level = 1;
                    if (row.getCell("maxLevel").getValue() != null) {
                        level = Integer.parseInt(row.getCell("maxLevel").getValue().toString());
                    }
                    at.setSelectedLevel(level);
                }
            }

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 0 && e.getValue() != null && ((Boolean)e.getValue()).booleanValue()) {
                    GLNRptExportBaseUI.this.afterSelectedAsstActType();
                }
            }
        };
        tblAsst.addKDTEditListener((KDTEditListener)this.tblAsstListener);
        IColumn collectCol = tblAsst.getColumn("collect");
        if (collectCol != null) {
            ArrayList<CollectEnum> asstShowTypes = new ArrayList<CollectEnum>();
            asstShowTypes.add(CollectEnum.LEVEL);
            asstShowTypes.add(CollectEnum.LEAF);
            collectCol.setEditor(GLEditor.getComboBox(asstShowTypes));
        }
        if ((levelCol = tblAsst.getColumn("maxLevel")) != null) {
            SpinnerNumberModel sm = new SpinnerNumberModel(0, 0, 10, 1);
            KDSpinnerCellEditor sce = new KDSpinnerCellEditor(sm);
            levelCol.setEditor((ICellEditor)sce);
        }
    }

    protected void tblAsstMoveRow(KDTable tblAsst, int offset) {
        if (tblAsst.getSelectManager().get() != null) {
            int r = tblAsst.getSelectManager().get().getTop();
            int newr = r + offset;
            if (r < 0 || newr < 0 || newr >= tblAsst.getRowCount()) {
                return;
            }
            IRow row = tblAsst.removeRow(r);
            tblAsst.addRow(newr, row);
            tblAsst.getSelectManager().select(newr, 0, newr, tblAsst.getColumnCount());
            tblAsst.getLayoutManager().scrollToShow(newr, 0);
        }
    }

    protected void loadAsstF7(final KDTable tblAsst, IRow row, CompanyOrgUnitInfo[] companies) {
        row.getCell("to").getStyleAttributes().setLocked(false);
        row.getCell("from").getStyleAttributes().setLocked(false);
        AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
        AsstActTypeInfo atInfo = new AsstActTypeInfo();
        atInfo.setAsstHGAttribute(at.getHgAttribute());
        atInfo.setIsForCompany(at.isForCompany());
        atInfo.setUseLongNumber(at.isUseLongNumber());
        if (at.getGeneralAsstactGroupId() != null && at.getGeneralAsstactGroupId().trim().length() > 0) {
            GeneralAsstActTypeGroupInfo groupInfo = new GeneralAsstActTypeGroupInfo();
            groupInfo.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
            atInfo.setGlAsstActTypeGrp(groupInfo);
        }
        GLF7Parameter f7Param = new GLF7Parameter();
        f7Param.setOnlyLeaf(true);
        f7Param.setUnUse(true);
        KDBizPromptBox toBizPromptBox = new KDBizPromptBox();
        toBizPromptBox.setEditable(true);
        toBizPromptBox.setEditFormat("$number$");
        toBizPromptBox.setCommitFormat("$number$;$name$");
        toBizPromptBox.setDisplayFormat("$number$ - $name$");
        toBizPromptBox.setQueryInfo(at.getQueryName());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isUseLongNumber() || at.isUseLevel()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        toBizPromptBox.setSelectorCollection(sic);
        if (companies != null && companies.length > 1) {
            atInfo.put("isSetMainBizOrg", (Object)false);
        }
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)toBizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo[])companies, (GLF7Parameter)f7Param);
        toBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    Object from;
                    AsstactTypeEntity asst;
                    Object old;
                    int beginRow = tblAsst.getSelectManager().getActiveRowIndex();
                    IRow row = tblAsst.getRow(beginRow);
                    KDBizPromptBox toBox = (KDBizPromptBox)e.getSource();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = toBox.getEntityViewInfo().getFilter();
                    FilterInfo newFilter = new FilterInfo();
                    Object to = e.getNewValue();
                    Object object = old = e.getOldValue() == null ? row.getCell("to").getValue() : e.getOldValue();
                    if (to instanceof IObjectValue && old instanceof IObjectValue) {
                        String id = ((IObjectValue)to).get("id").toString();
                        String oid = ((IObjectValue)old).get("id").toString();
                        if (id != null && id.equals(oid)) {
                            return;
                        }
                    }
                    Object obj = row.getUserObject();
                    String compareExpr = "number";
                    if (obj instanceof AsstactTypeEntity && (asst = (AsstactTypeEntity)obj).isGeneralActType()) {
                        compareExpr = "longnumber";
                    }
                    if (to instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)to).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
                    }
                    if ((from = row.getCell("from").getValue()) instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.GREATER_EQUALS));
                    }
                    newFilter.mergeFilter(filter, "and");
                    view.setFilter(newFilter);
                    GLNRptExportBaseUI.this.assistFromOrToChange = true;
                    GLNRptExportBaseUI.this.loadAsstDistF7(tblAsst, row, toBox, view);
                    Object standard = row.getCell("groupStandard").getValue();
                    Object[] groups = (Object[])row.getCell("group").getValue();
                    GLNRptExportBaseUI.this.checkGroupStandIsBasic(row, standard, groups);
                }
                catch (Exception exc) {
                    GLNRptExportBaseUI.this.handUIException(exc);
                }
            }
        });
        row.getCell("to").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)toBizPromptBox));
        KDBizPromptBox fromBizPromptBox = new KDBizPromptBox();
        fromBizPromptBox.setEditable(true);
        fromBizPromptBox.setEditFormat("$number$");
        if (at.isUseLongNumber() || at.isUseLevel()) {
            fromBizPromptBox.setCommitFormat("$number$;$name$");
        } else {
            fromBizPromptBox.setCommitFormat("$number$;$longnumber$;$name$");
        }
        fromBizPromptBox.setDisplayFormat("$number$ - $name$");
        fromBizPromptBox.setQueryInfo(at.getQueryName());
        fromBizPromptBox.setSelectorCollection(sic);
        if (atInfo.getGlAsstActTypeGrp() != null) {
            try {
                CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("company");
                boolean showLongNumber = Boolean.parseBoolean(GlUtils.getParamByKey(null, currentCompany.getId().toString(), "GL_064").toString());
                if (showLongNumber) {
                    toBizPromptBox.setNeedConvert(true);
                    fromBizPromptBox.setNeedConvert(true);
                }
            }
            catch (Exception e) {
                logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"480_GLRptAssistBalanceQueryUI"));
            }
        }
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)fromBizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo[])companies, (GLF7Parameter)f7Param);
        fromBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    Object to;
                    AsstactTypeEntity asst;
                    Object old;
                    int beginRow = tblAsst.getSelectManager().getActiveRowIndex();
                    IRow row = tblAsst.getRow(beginRow);
                    KDBizPromptBox fromBox = (KDBizPromptBox)e.getSource();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = fromBox.getEntityViewInfo().getFilter();
                    FilterInfo newFilter = new FilterInfo();
                    Object from = e.getNewValue();
                    Object object = old = e.getOldValue() == null ? row.getCell("from").getValue() : e.getOldValue();
                    if (from instanceof IObjectValue && old instanceof IObjectValue) {
                        String id = ((IObjectValue)from).get("id").toString();
                        String oid = ((IObjectValue)old).get("id").toString();
                        if (id != null && id.equals(oid)) {
                            return;
                        }
                    }
                    Object obj = row.getUserObject();
                    String compareExpr = "number";
                    if (obj instanceof AsstactTypeEntity && (asst = (AsstactTypeEntity)obj).isGeneralActType()) {
                        compareExpr = "longnumber";
                    }
                    if (from instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.GREATER_EQUALS));
                    }
                    if ((to = row.getCell("to").getValue()) instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)to).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
                    } else if (from != null) {
                        row.getCell("to").setValue(from);
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
                    }
                    newFilter.mergeFilter(filter, "and");
                    view.setFilter(newFilter);
                    GLNRptExportBaseUI.this.assistFromOrToChange = true;
                    KDBizPromptBox disBox = GLNRptExportBaseUI.this.loadAsstDistF7(tblAsst, row, fromBox, view);
                    Object standard = row.getCell("group").getValue();
                    Object[] groups = (Object[])row.getCell("group").getValue();
                    GLNRptExportBaseUI.this.checkGroupStandIsBasic(row, standard, groups);
                }
                catch (Exception exc) {
                    GLNRptExportBaseUI.this.handUIException(exc);
                }
            }
        });
        row.getCell("from").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)fromBizPromptBox));
        fromBizPromptBox.addSelectorListener((SelectorListener)new GLNRptGroupAsstItemSelectorListener(row.getCell("groupStandard"), row.getCell("group"), at.getHgAttribute()));
        toBizPromptBox.addSelectorListener((SelectorListener)new GLNRptGroupAsstItemSelectorListener(row.getCell("groupStandard"), row.getCell("group"), at.getHgAttribute()));
        this.loadAsstDistF7(tblAsst, row, fromBizPromptBox, null);
    }

    protected void loadAsstGroupStandardF7(final IRow row) {
        AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
        String hgAttribute = at.getHgAttribute();
        CSSPGroupStandardCollection stds = null;
        try {
            ICSSPGroupStandard iSupplierGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
            if (hgAttribute.equalsIgnoreCase("customer")) {
                stds = iSupplierGroupStandard.getCSSPGroupStandard("1", false);
            } else if (hgAttribute.equalsIgnoreCase("provider")) {
                stds = iSupplierGroupStandard.getCSSPGroupStandard("2", false);
            } else {
                IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
                FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), (String)SysContext.getSysContext().getCurrentFIUnit().getLongNumber());
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filterInfoCU);
                stds = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        KDComboBox box = new KDComboBox();
        box.addItem((Object)"");
        if (stds != null) {
            this.standardsCache.put(hgAttribute, stds.toArray());
            box.addItems(stds.toArray());
        }
        box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    row.getCell("group").setValue(null);
                    row.getCell("from").setValue(null);
                    row.getCell("to").setValue(null);
                    row.getCell("dist").setValue(null);
                    row.getCell("dist").setUserObject(null);
                }
            }
        });
        KDTDefaultCellEditor groupEditor = new KDTDefaultCellEditor((JComboBox)box);
        row.getCell("groupStandard").setEditor((ICellEditor)groupEditor);
        row.getCell("groupStandard").getStyleAttributes().setLocked(false);
    }

    protected void loadAsstGroupF7(final KDTable tblAsst, IRow row) {
        AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
        String hgAttribute = at.getHgAttribute();
        if (!("customer".equalsIgnoreCase(at.getHgAttribute()) || "provider".equalsIgnoreCase(at.getHgAttribute()) || "Material".equalsIgnoreCase(at.getHgAttribute()))) {
            return;
        }
        KDBizPromptBox groupPromptBox = new KDBizPromptBox();
        groupPromptBox.setEditable(true);
        groupPromptBox.setEditFormat("$number$");
        groupPromptBox.setDisplayFormat("$number$ - $name$");
        groupPromptBox.setCommitFormat("$number$");
        groupPromptBox.setEnabledMultiSelection(true);
        EntityViewInfo ev = new EntityViewInfo();
        if (hgAttribute.equalsIgnoreCase("customer")) {
            groupPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerGroupQuery");
        } else if (hgAttribute.equalsIgnoreCase("material")) {
            groupPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
        } else {
            groupPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierGroupQuery");
        }
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("name"));
        ev.getSelector().add(new SelectorItemInfo("isLeaf"));
        ev.getSelector().add(new SelectorItemInfo("groupStandard.id"));
        ev.getSelector().add(new SelectorItemInfo("groupStandard.name"));
        if (hgAttribute.equalsIgnoreCase("customer") || hgAttribute.equalsIgnoreCase("provider")) {
            ev.getSelector().add(new SelectorItemInfo("groupStandard.isBasic"));
            ev.getSorter().add(new SorterItemInfo("groupStandard.isBasic"));
            ev.getSelector().add(new SelectorItemInfo("longNumber"));
        } else if (hgAttribute.equalsIgnoreCase("material")) {
            ev.getSelector().add(new SelectorItemInfo("groupStandard.standardType"));
            ev.getSorter().add(new SorterItemInfo("groupStandard.standardType"));
            ev.getSelector().add(new SelectorItemInfo("longNumber"));
        }
        ev.getSelector().add(new SelectorItemInfo("deletedStatus"));
        FilterInfo filter = new FilterInfo();
        Object groupStandard = row.getCell("groupStandard").getValue();
        if (groupStandard != null && !"".equals(groupStandard.toString().trim()) && ((DataBaseInfo)groupStandard).getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)((DataBaseInfo)groupStandard).getId().toString(), CompareType.EQUALS));
        }
        ev.setFilter(filter);
        ev.getSorter().add(new SorterItemInfo("groupStandard.number"));
        ev.getSorter().add(new SorterItemInfo("number"));
        groupPromptBox.setEntityViewInfo(ev);
        groupPromptBox.setSelectorCollection(ev.getSelector());
        groupPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                int beginRow = tblAsst.getSelectManager().getActiveRowIndex();
                IRow row = tblAsst.getRow(beginRow);
                Object[] groups = (Object[])e.getNewValue();
                GLNRptExportBaseUI.this.checkGroupStandIsBasic(row, null, groups);
                HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
                if (groups != null) {
                    StandardTypeEnum lastSdType = null;
                    for (int i = 0; i < groups.length; ++i) {
                        StandardTypeEnum sdType;
                        if (groups[i] instanceof CSSPGroupInfo) {
                            ids.add(((CSSPGroupInfo)groups[i]).getId());
                            sdType = ((CSSPGroupInfo)groups[i]).getGroupStandard().getIsBasic();
                            if (lastSdType == null) {
                                lastSdType = sdType;
                                continue;
                            }
                            if (sdType == lastSdType) continue;
                            MsgBox.showInfo((Component)((Object)GLNRptExportBaseUI.this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"sameGroupType"));
                            ((KDBizPromptBox)e.getSource()).setValue(e.getOldValue());
                            return;
                        }
                        if (!(groups[i] instanceof MaterialGroupInfo)) continue;
                        ids.add(((MaterialGroupInfo)groups[i]).getId());
                        sdType = ((MaterialGroupInfo)groups[i]).getGroupStandard().getStandardType();
                        if (lastSdType == null) {
                            lastSdType = sdType;
                            continue;
                        }
                        if (sdType == lastSdType) continue;
                        MsgBox.showInfo((Component)((Object)GLNRptExportBaseUI.this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"sameGroupType"));
                        ((KDBizPromptBox)e.getSource()).setValue(e.getOldValue());
                        return;
                    }
                    row.getCell("group").setUserObject(ids);
                    Object[] oldGroups = (Object[])e.getOldValue();
                    boolean isClearFromTo = false;
                    if (oldGroups == null) {
                        isClearFromTo = true;
                    } else if (oldGroups.length != groups.length) {
                        isClearFromTo = true;
                    } else {
                        for (int i = 0; i < oldGroups.length; ++i) {
                            if (oldGroups[i].equals(groups[i])) continue;
                            isClearFromTo = true;
                            break;
                        }
                    }
                    if (isClearFromTo) {
                        row.getCell("from").setValue(null);
                        row.getCell("to").setValue(null);
                        row.getCell("dist").setValue(null);
                        row.getCell("dist").setUserObject(null);
                    }
                }
            }
        });
        KDTDefaultCellEditor groupEditor = new KDTDefaultCellEditor((IKDEditor)groupPromptBox);
        row.getCell("group").setEditor((ICellEditor)groupEditor);
        Object obj = row.getCell("groupStandard").getValue();
        if (obj != null && !"".equals(obj.toString().trim())) {
            row.getCell("group").getStyleAttributes().setBackground(Color.WHITE);
            row.getCell("group").getStyleAttributes().setLocked(false);
            this.checkGroupStandIsBasic(row, obj, null);
        } else {
            row.getCell("group").setValue(null);
            row.getCell("group").getStyleAttributes().setBackground(LOCKCOLOR);
            row.getCell("group").getStyleAttributes().setLocked(true);
        }
    }

    private void checkGroupStandIsBasic(IRow row, Object standard, Object[] groups) {
        if (!(standard != null && standard.toString().trim().length() != 0 || null != groups && groups.length != 0)) {
            return;
        }
        if (null != this.isBasicInfo.get(row.getRowIndex())) {
            this.isBasicInfo.get(row.getRowIndex()).setRow(row);
        }
    }

    protected KDBizPromptBox loadAsstDistF7(final KDTable tblAsst, IRow row, KDBizPromptBox bizBox, EntityViewInfo view) {
        KDBizPromptBox disBox = new KDBizPromptBox();
        disBox.setEditFormat("$number$");
        disBox.setDisplayFormat("$name$");
        disBox.setCommitFormat("$number$");
        disBox.setEditable(false);
        disBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = tblAsst.getSelectManager().get().getBeginRow();
                    IRow row = tblAsst.getRow(beginRow);
                    Object dist = e.getNewValue();
                    if (dist == null) {
                        AsstactTypeEntity entry = (AsstactTypeEntity)row.getUserObject();
                        entry.setDist(null);
                        row.getCell("dist").setUserObject(null);
                    }
                }
                catch (Exception exc) {
                    GLNRptExportBaseUI.this.handUIException(exc);
                }
            }
        });
        if (view == null) {
            view = bizBox.getEntityViewInfo();
            if (view != null) {
                view = (EntityViewInfo)view.clone();
            }
            view = this.getDefaultView(row, view);
        }
        disBox.setEntityViewInfo(view);
        GLNRptGeneralBizPromptBox bizPromptBox = new GLNRptGeneralBizPromptBox(view, bizBox.getQueryInfo(), tblAsst, "com.kingdee.eas.fi.gl.rpt.client.FilterForAssistF7UI");
        if (row.getRowIndex() >= 0) {
            this.isBasicInfo.put(row.getRowIndex(), bizPromptBox);
        }
        bizPromptBox.setRow(row);
        disBox.setSelector((KDPromptSelector)bizPromptBox);
        if (this.assistFromOrToChange) {
            row.getCell("dist").setValue(null);
            row.getCell("dist").setUserObject(null);
            this.assistFromOrToChange = false;
        }
        row.getCell("dist").getStyleAttributes().setLocked(false);
        row.getCell("dist").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)disBox));
        return disBox;
    }

    private EntityViewInfo getDefaultView(IRow row, EntityViewInfo view) {
        Object to;
        Object from;
        AsstactTypeEntity at;
        if (view == null || view.getFilter() == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = view.getFilter();
        FilterInfo newFilter = new FilterInfo();
        Object obj = row.getUserObject();
        String compareExpr = "number";
        if (obj instanceof AsstactTypeEntity && (at = (AsstactTypeEntity)obj).isGeneralActType()) {
            compareExpr = "longnumber";
        }
        if ((from = row.getCell("from").getValue()) instanceof IObjectValue) {
            newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.GREATER_EQUALS));
        }
        if ((to = row.getCell("to").getValue()) instanceof IObjectValue) {
            newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)to).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
        }
        try {
            newFilter.mergeFilter(filter, "and");
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        view.setFilter(newFilter);
        return view;
    }

    protected void setAsstactTypeList(KDTable tblAsst, List asstactList, CompanyOrgUnitInfo[] companies) {
        if (asstactList == null) {
            return;
        }
        int index = 0;
        for (int i = 0; i < tblAsst.getRowCount(); ++i) {
            ICell levelCell;
            IRow row = tblAsst.getRow(i);
            AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
            boolean found = false;
            Map asstMap = null;
            for (int j = 0; j < asstactList.size(); ++j) {
                asstMap = (Map)asstactList.get(j);
                if (!asstMap.get("type").equals(at.getNumber())) continue;
                tblAsst.removeRow(i);
                row = tblAsst.addRow(index < j ? index : j, row);
                ++index;
                found = true;
                break;
            }
            if (found) {
                ICell iCell;
                ICell collectCell;
                Object distObj;
                row.getCell("to").getStyleAttributes().setLocked(false);
                row.getCell("from").getStyleAttributes().setLocked(false);
                row.getCell("selected").setValue((Object)Boolean.TRUE);
                this.loadAsstGroupStandardF7(row);
                Object standard = this.getGroupStandardInfo(at.getHgAttribute(), (String)asstMap.get("standard"));
                if (standard != null && this.standardsCache.containsKey(at.getHgAttribute())) {
                    Object[] standardsObj;
                    for (Object object : standardsObj = this.standardsCache.get(at.getHgAttribute())) {
                        if (!object.toString().equals(standard.toString())) continue;
                        row.getCell("groupStandard").setUserObject(object);
                        row.getCell("groupStandard").setValue(object);
                        row.getCell("groupStandard").getEditor().setValue(object);
                    }
                }
                this.loadAsstGroupF7(tblAsst, row);
                Object[] groups = this.getGroupInfo(at.getHgAttribute(), (String)asstMap.get("group"));
                if (groups != null) {
                    row.getCell("group").setValue((Object)groups);
                    StringBuffer groupIds = new StringBuffer();
                    for (int j = 0; j < groups.length; ++j) {
                        groupIds.append(((DataBaseInfo)groups[j]).getId().toString()).append(",");
                    }
                    groupIds.deleteCharAt(groupIds.length() - 1);
                    at.setAsstGroup(groupIds.toString());
                }
                this.loadAsstF7(tblAsst, row, companies);
                HashSet<String> asstIds = new HashSet<String>();
                if (asstMap.get("from") != null && !"".equals(asstMap.get("from").toString().trim())) {
                    asstIds.add(asstMap.get("from").toString().replace("!", "."));
                    Object[] from = this.getAsstInfo(at, companies[0], asstIds);
                    if (from != null) {
                        at.setFrom(from[0]);
                        row.getCell("from").setValue(from[0]);
                        row.getCell("from").setUserObject(from[0]);
                    }
                }
                if (asstMap.get("to") != null && !"".equals(asstMap.get("to").toString().trim())) {
                    asstIds.clear();
                    asstIds.add(asstMap.get("to").toString().replace("!", "."));
                    Object[] to = this.getAsstInfo(at, companies[0], asstIds);
                    if (to != null) {
                        at.setTo(to[0]);
                        row.getCell("to").setValue(to[0]);
                    }
                }
                if ((distObj = asstMap.get("number")) != null && !"".equals(distObj.toString().trim())) {
                    String[] distAsst;
                    asstIds.clear();
                    for (String asst : distAsst = distObj.toString().split(";")) {
                        asstIds.add(asst.toString().replace("!", "."));
                    }
                    Object[] objectArray = this.getAsstInfo(at, companies[0], asstIds);
                    if (objectArray != null) {
                        HashSet<AssistViewFilterInfo> distSet = new HashSet<AssistViewFilterInfo>();
                        StringBuffer name = new StringBuffer();
                        for (int j = 0; j < objectArray.length; ++j) {
                            DataBaseInfo asst = (DataBaseInfo)objectArray[j];
                            HashSet<String> idSet = new HashSet<String>();
                            idSet.add(asst.getId().toString());
                            AssistViewFilterInfo v = new AssistViewFilterInfo(idSet, at.isGeneralActType() ? (String)asst.get("longNumber") : asst.getNumber(), asst.getName());
                            distSet.add(v);
                            name.append(objectArray[j]).append(";");
                        }
                        row.getCell("dist").setUserObject(distSet);
                        row.getCell("dist").setValue((Object)name.toString());
                    }
                }
                if ((collectCell = row.getCell("collect")) != null) {
                    if (CollectEnum.LEVEL.getName().equals(asstMap.get("displayMode")) || CollectEnum.LEVEL.getAlias().equals(asstMap.get("displayMode"))) {
                        row.getCell("collect").setValue((Object)CollectEnum.LEVEL);
                    } else {
                        row.getCell("collect").setValue((Object)CollectEnum.LEAF);
                    }
                }
                if ((iCell = row.getCell("maxLevel")) == null) continue;
                row.getCell("maxLevel").setValue(asstMap.get("level"));
                continue;
            }
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("from").setValue(null);
            row.getCell("from").getStyleAttributes().setLocked(true);
            row.getCell("to").setValue(null);
            row.getCell("to").getStyleAttributes().setLocked(true);
            row.getCell("dist").setValue(null);
            row.getCell("dist").getStyleAttributes().setLocked(true);
            ICell collectCell = row.getCell("collect");
            if (collectCell != null) {
                collectCell.setValue((Object)CollectEnum.LEAF);
            }
            if ((levelCell = row.getCell("maxLevel")) == null) continue;
            levelCell.setValue((Object)0);
        }
    }

    private Object[] getAsstInfo(AsstactTypeEntity at, CompanyOrgUnitInfo company, Set asstIds) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            AsstActTypeInfo atInfo = new AsstActTypeInfo();
            atInfo.setId(BOSUuid.read((String)at.getId()));
            atInfo.put("ignoreFilter", (Object)Boolean.TRUE);
            params.put("asstActType", atInfo);
            params.put("asstActNumbers", asstIds);
            params.put("company", company);
            Map asstActs = GLGeneralFacadeFactory.getRemoteInstance().findAsstActs(params);
            if (asstActs != null) {
                ArrayList result = new ArrayList(asstActs.size());
                for (Object key : asstIds) {
                    Object value = asstActs.get(key);
                    if (value == null || value instanceof String) continue;
                    result.add(value);
                }
                if (result.size() > 0) {
                    return result.toArray();
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Object[] getGroupInfo(String hgAttribute, String groupNumbers) {
        if (groupNumbers == null) {
            return null;
        }
        String[] numArray = groupNumbers.split(";");
        HashSet<String> nums = new HashSet<String>();
        for (int i = 0; i < numArray.length; ++i) {
            nums.add(numArray[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("isLeaf"));
        view.getSelector().add(new SelectorItemInfo("groupStandard.id"));
        view.getSelector().add(new SelectorItemInfo("groupStandard.isBasic"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", nums, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection coll = null;
        try {
            if ("customer".equalsIgnoreCase(hgAttribute) || "provider".equalsIgnoreCase(hgAttribute)) {
                coll = CSSPGroupFactory.getRemoteInstance().getCollection(view);
            } else if ("material".equalsIgnoreCase(hgAttribute)) {
                coll = MaterialGroupFactory.getRemoteInstance().getCollection(view);
            }
            if (coll != null && !coll.isEmpty()) {
                return coll.toArray();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Object getGroupStandardInfo(String hgAttribute, String groupStandardNumber) {
        if (StringUtils.isEmpty((String)groupStandardNumber)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)groupStandardNumber, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            if (hgAttribute.equalsIgnoreCase("customer") || hgAttribute.equalsIgnoreCase("provider")) {
                CSSPGroupStandardCollection ss = CSSPGroupStandardFactory.getRemoteInstance().getCSSPGroupStandardCollection(view);
                if (ss.size() > 0) {
                    return ss.get(0);
                }
            } else {
                FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), (String)SysContext.getSysContext().getCurrentFIUnit().getLongNumber());
                view.getFilter().mergeFilter(filterInfoCU, "AND");
                MaterialGroupStandardCollection ss = MaterialGroupStandardFactory.getRemoteInstance().getMaterialGroupStandardCollection(view);
                if (ss.size() > 0) {
                    return ss.get(0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected AsstAccountInfo getAsstAccount(String number) {
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number.trim()));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        try {
            AsstAccountCollection coll = AsstAccountFactory.getRemoteInstance().getAsstAccountCollection(view);
            if (coll.size() > 0) {
                return coll.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void afterSelectedAsstActType() {
    }
}

