/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.WSVoucherFactory;
import com.kingdee.eas.fi.gl.ZipUtils;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAccountBalanceExporter;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptExportBaseUI;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class GLNRptSubLedgerExporter
extends GLNRptAccountBalanceExporter {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptSubLedgerExporter.class);
    protected boolean showFor = false;
    protected boolean showLocal = false;
    protected boolean showRpt = false;
    protected boolean showQty = false;
    protected List<String> asstActCols = new ArrayList<String>();
    protected List<String> oppAccountCols = new ArrayList<String>();
    protected List<String> oppAsstActCols = new ArrayList<String>();
    protected Map<String, XSSFCellStyle> cellStyles = new HashMap<String, XSSFCellStyle>();
    protected XSSFCellStyle beginStyle = null;
    protected XSSFCellStyle periodSumStyle = null;
    protected XSSFCellStyle yearSumStyle = null;

    public GLNRptSubLedgerExporter(GLNRptExportBaseUI nRptUI, Map<String, String> config) {
        super(nRptUI, config);
    }

    @Override
    protected Map<String, Object> buildParams() {
        Map<String, Object> params = super.buildParams();
        params.put("rptType", "SubLedger");
        List asstActTypes = new ArrayList();
        String strAsstActTypes = (String)this.config.get("asstActTypes");
        if (strAsstActTypes != null) {
            asstActTypes = (List)JSON.parseObject((String)strAsstActTypes, List.class);
        }
        params.put("showAsstDetail", this.config.get("showAsstDetail"));
        params.put("showOppAccount", this.config.get("showOppAccount"));
        params.put("showOppAsstact", this.config.get("showOppAsstact"));
        params.put("showPeriodSum", this.config.get("showPeriodSum"));
        params.put("showYearSum", this.config.get("showYearSum"));
        params.put("asstActTypes", asstActTypes);
        params.put("showAsstActNumber", this.config.get("showAsstActNumber"));
        params.put("showAsstActLongName", this.config.get("showAsstActLongName"));
        params.put("voucherType", this.config.get("voucherType"));
        params.put("voucherNumber", this.config.get("voucherNumber"));
        params.put("fromVoucherNumber", this.config.get("fromVoucherNumber"));
        params.put("toVoucherNumber", this.config.get("toVoucherNumber"));
        params.put("fromBookedDate", this.config.get("fromBookedDate"));
        params.put("toBookedDate", this.config.get("toBookedDate"));
        params.put("fromBizDate", this.config.get("fromBizDate"));
        params.put("toBizDate", this.config.get("toBizDate"));
        params.put("sourceSys", this.config.get("sourceSys"));
        params.put("sourceType", this.config.get("sourceType"));
        params.put("creator", this.config.get("creator"));
        params.put("auditor", this.config.get("auditor"));
        params.put("poster", this.config.get("poster"));
        params.put("cashier", this.config.get("cashier"));
        params.put("description", this.config.get("description"));
        params.put("entryDescription", this.config.get("entryDescription"));
        params.put("entryDC", this.config.get("entryDC"));
        params.put("entryMinAmount", this.config.get("entryMinAmount"));
        params.put("entryMaxAmount", this.config.get("entryMaxAmount"));
        return params;
    }

    @Override
    protected String getSheetName() {
        return this.getResource("subLedger");
    }

    @Override
    protected void init(Map result, List<List<String>> values) {
        Object param = this.config.get("showByAccountDc");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showByAccountDc = true;
        }
        if ((param = this.config.get("showFor")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showFor = true;
        }
        if ((param = this.config.get("showLocal")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showLocal = true;
        }
        if ((param = this.config.get("showRpt")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showRpt = true;
        }
        if ((param = this.config.get("showQty")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showQty = true;
        }
        this.sheetByOrg = (param = this.config.get("sheetByOrg")) != null && param.toString().trim().equals("true");
        param = this.config.get("MAX_SIZE");
        if (param != null && param.toString().trim().length() > 0) {
            this.MAX_SIZE = Integer.parseInt(param.toString().trim());
        }
        this.colNames = values.get(0);
        this.colAliass = values.get(1);
        this.commonCols = new ArrayList();
        this.asstActCols = new ArrayList<String>();
        this.oppAccountCols = new ArrayList<String>();
        this.oppAsstActCols = new ArrayList<String>();
        for (int i = 0; i < this.colNames.size(); ++i) {
            String colName = (String)this.colNames.get(i);
            this.colIndexs.put(colName, i);
            if (colName.endsWith("For") || colName.endsWith("Local") || colName.endsWith("Rpt") || colName.endsWith("Qty") || colName.equals("dc")) continue;
            if (colName.startsWith("asstAct")) {
                this.asstActCols.add(colName);
                continue;
            }
            if (colName.startsWith("oppAccount") || colName.equals("oppDescription")) {
                this.oppAccountCols.add(colName);
                continue;
            }
            if (colName.startsWith("oppAsstAct")) {
                this.oppAsstActCols.add(colName);
                continue;
            }
            if ("accountDc".equals(colName) ? !"true".equals(this.config.get("showAccountDc")) : colName.endsWith("Precision") || colName.equals("assistGrpId")) continue;
            this.commonCols.add(colName);
        }
        this.colIndexs.put("dc", 0);
        this.cols = new ArrayList();
        if (this.colIndexs.containsKey("debitQty")) {
            this.cols.add("debitQty");
        }
        if (this.colIndexs.containsKey("debitFor")) {
            this.cols.add("debitFor");
        }
        if (this.colIndexs.containsKey("debitLocal")) {
            this.cols.add("debitLocal");
        }
        if (this.colIndexs.containsKey("debitRpt")) {
            this.cols.add("debitRpt");
        }
        if (this.colIndexs.containsKey("creditQty")) {
            this.cols.add("creditQty");
        }
        if (this.colIndexs.containsKey("creditFor")) {
            this.cols.add("creditFor");
        }
        if (this.colIndexs.containsKey("creditLocal")) {
            this.cols.add("creditLocal");
        }
        if (this.colIndexs.containsKey("creditRpt")) {
            this.cols.add("creditRpt");
        }
        this.endCols = new ArrayList();
        this.endCols.add("dc");
        if (this.colIndexs.containsKey("endQty")) {
            this.endCols.add("endQty");
        }
        if (this.colIndexs.containsKey("endBalanceFor")) {
            this.endCols.add("endBalanceFor");
        }
        if (this.colIndexs.containsKey("endBalanceLocal")) {
            this.endCols.add("endBalanceLocal");
        }
        if (this.colIndexs.containsKey("endBalanceRpt")) {
            this.endCols.add("endBalanceRpt");
        }
        this.allCols = new ArrayList();
        this.allCols.addAll(this.commonCols);
        this.allCols.addAll(this.asstActCols);
        this.allCols.addAll(this.oppAccountCols);
        this.allCols.addAll(this.oppAsstActCols);
        this.allCols.addAll(this.cols);
        this.allCols.addAll(this.endCols);
    }

    @Override
    public void buildWorkbook(Map result, List<List<String>> values) {
        this.wb = new SXSSFWorkbook();
        this.style = this.getCellStyle(this.wb, new Color(201, 222, 240), null);
        Font font = this.wb.createFont();
        font.setBold(true);
        this.style.setAlignment(HorizontalAlignment.CENTER);
        this.style.setVerticalAlignment(VerticalAlignment.CENTER);
        this.style.setFont(font);
        Color borderColor = new Color(218, 220, 221);
        this.beginStyle = this.getCellStyle(this.wb, new Color(238, 236, 248), borderColor);
        this.periodSumStyle = this.getCellStyle(this.wb, new Color(232, 228, 203), borderColor);
        this.yearSumStyle = this.getCellStyle(this.wb, new Color(233, 226, 184), borderColor);
        this.textStyle = this.getCellStyle(this.wb, Color.WHITE, borderColor);
        DataFormat format = this.wb.createDataFormat();
        short fmt = format.getFormat("@");
        this.textStyle.setDataFormat(fmt);
        this.beginStyle.setDataFormat(fmt);
        this.periodSumStyle.setDataFormat(fmt);
        this.yearSumStyle.setDataFormat(fmt);
        this.lastOrgNumber = null;
        String companyNumber = null;
        if (this.sheetByOrg) {
            List<String> item = values.get(2);
            this.lastOrgNumber = companyNumber = item.get((Integer)this.colIndexs.get("companyNumber"));
        }
        this.sheet = this.wb.createSheet(companyNumber == null ? this.getSheetName() : companyNumber);
        this.buildHead();
        int beginIndex = this.buildBatch(values, true, 2);
        List batchNames = (List)result.get("batchNames");
        if (batchNames != null && batchNames.size() > 0) {
            for (String batchName : batchNames) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("rptType", "getBatch");
                params.put("batchName", batchName);
                params.put("isCompress", "true");
                String jsonParams = JSON.toJSONString(params);
                try {
                    List rows;
                    this.info(this.getResource("batchQuery") + batchName);
                    String jsonResult = WSVoucherFactory.getRemoteInstance().nGetBalance(jsonParams, false);
                    Map r = (Map)JSON.parseObject((String)(jsonResult = ZipUtils.gunzip(jsonResult)), Map.class);
                    if (r == null || (rows = (List)r.get("rows")) == null || rows.size() <= 0) continue;
                    beginIndex = this.buildBatch(rows, false, beginIndex);
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }
    }

    @Override
    protected void buildHead() {
        Integer width;
        Cell cell1;
        Cell cell0;
        String colAlias;
        Integer width2;
        Cell cell12;
        Cell cell02;
        Map<String, Integer> widths = this.getWidths();
        Row row0 = this.sheet.createRow(0);
        Row row1 = this.sheet.createRow(1);
        for (int i = 0; i < this.commonCols.size(); ++i) {
            String colName = (String)this.commonCols.get(i);
            int index = (Integer)this.colIndexs.get(colName);
            String colAlias2 = (String)this.colAliass.get(index);
            cell02 = row0.createCell(i);
            cell02.setCellValue(colAlias2);
            cell02.setCellStyle((CellStyle)this.style);
            cell12 = row1.createCell(i);
            cell12.setCellValue(colAlias2);
            cell12.setCellStyle((CellStyle)this.style);
            width2 = widths.get(colName);
            if (width2 != null) {
                this.sheet.setColumnWidth(i, width2.intValue());
            }
            this.sheet.addMergedRegion(new CellRangeAddress(0, 1, i, i));
        }
        int start = this.commonCols.size();
        if (this.asstActCols.size() > 0) {
            for (int i = 0; i < this.asstActCols.size(); ++i) {
                String colName = this.asstActCols.get(i);
                int index = (Integer)this.colIndexs.get(colName);
                colAlias = (String)this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(this.getResource("asstAct"));
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width == null) continue;
                this.sheet.setColumnWidth(i + start, width.intValue());
            }
            this.sheet.addMergedRegion(new CellRangeAddress(0, 1, start, start + this.asstActCols.size() - 1));
        }
        start += this.asstActCols.size();
        if (this.oppAccountCols.size() > 0) {
            for (int i = 0; i < this.oppAccountCols.size(); ++i) {
                String colName = this.oppAccountCols.get(i);
                int index = (Integer)this.colIndexs.get(colName);
                colAlias = (String)this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(colAlias);
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width != null) {
                    this.sheet.setColumnWidth(i + start, width.intValue());
                }
                this.sheet.addMergedRegion(new CellRangeAddress(0, 1, start + i, start + i));
            }
        }
        start += this.oppAccountCols.size();
        if (this.oppAsstActCols.size() > 0) {
            for (int i = 0; i < this.oppAsstActCols.size(); ++i) {
                String colName = this.oppAsstActCols.get(i);
                int index = (Integer)this.colIndexs.get(colName);
                cell02 = row0.createCell(i + start);
                cell02.setCellValue(this.getResource("oppAsstAct"));
                cell02.setCellStyle((CellStyle)this.style);
                cell12 = row1.createCell(i + start);
                cell12.setCellValue(this.getResource("oppAsstAct"));
                cell12.setCellStyle((CellStyle)this.style);
                width2 = widths.get(colName);
                if (width2 == null) continue;
                this.sheet.setColumnWidth(i + start, width2.intValue());
            }
            this.sheet.addMergedRegion(new CellRangeAddress(0, 1, start, start + this.oppAsstActCols.size() - 1));
        }
        start += this.oppAsstActCols.size();
        if (this.cols.size() > 0) {
            for (int i = 0; i < this.cols.size(); ++i) {
                String colName = (String)this.cols.get(i);
                int index = (Integer)this.colIndexs.get(colName);
                colAlias = (String)this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(this.getResource("periodHappen"));
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                if (colName.equals("debitQty")) {
                    colAlias = this.getResource("debitQty_exp");
                } else if (colName.equals("debitFor")) {
                    colAlias = this.getResource("debitFor_exp");
                } else if (colName.equals("debitLocal")) {
                    colAlias = this.getResource("debitLocal_exp");
                } else if (colName.equals("debitRpt")) {
                    colAlias = this.getResource("debitRpt_exp");
                } else if (colName.equals("creditQty")) {
                    colAlias = this.getResource("creditQty_exp");
                } else if (colName.equals("creditFor")) {
                    colAlias = this.getResource("creditFor_exp");
                } else if (colName.equals("creditLocal")) {
                    colAlias = this.getResource("creditLocal_exp");
                } else if (colName.equals("creditRpt")) {
                    colAlias = this.getResource("creditRpt_exp");
                }
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width == null) continue;
                this.sheet.setColumnWidth(i + start, width.intValue());
            }
            if (this.cols.size() > 1) {
                this.sheet.addMergedRegion(new CellRangeAddress(0, 0, start, start + this.cols.size() - 1));
            }
        }
        start += this.cols.size();
        if (this.endCols.size() > 0) {
            for (int i = 0; i < this.endCols.size(); ++i) {
                String colName = (String)this.endCols.get(i);
                int index = (Integer)this.colIndexs.get(colName);
                colAlias = (String)this.colAliass.get(index);
                cell0 = row0.createCell(i + start);
                cell0.setCellValue(this.getResource("endBalance_exp"));
                cell0.setCellStyle((CellStyle)this.style);
                cell1 = row1.createCell(i + start);
                if (colName.equals("dc")) {
                    colAlias = this.getResource("dc");
                } else if (colName.equals("endQty")) {
                    colAlias = this.getResource("qty_exp");
                } else if (colName.equals("endBalanceFor")) {
                    colAlias = this.getResource("for_exp");
                } else if (colName.equals("endBalanceLocal")) {
                    colAlias = this.getResource("local_exp");
                } else if (colName.equals("endBalanceRpt")) {
                    colAlias = this.getResource("rpt_exp");
                }
                cell1.setCellValue(colAlias);
                cell1.setCellStyle((CellStyle)this.style);
                width = widths.get(colName);
                if (width == null) continue;
                this.sheet.setColumnWidth(i + start, width.intValue());
            }
            if (this.endCols.size() > 1) {
                this.sheet.addMergedRegion(new CellRangeAddress(0, 0, start, start + this.endCols.size() - 1));
            }
        }
    }

    @Override
    protected int buildBatch(List<List<String>> values, boolean firstBatch, int beginIndex) {
        int i;
        int bookedDateIndex = (Integer)this.colIndexs.get("bookedDate");
        String accountDc = "1";
        int forPrecisionIndex = this.colIndexs.containsKey("forPrecision") ? (Integer)this.colIndexs.get("forPrecision") : -1;
        int localPrecisionIndex = this.colIndexs.containsKey("localPrecision") ? (Integer)this.colIndexs.get("localPrecision") : -1;
        int rptPrecisionIndex = this.colIndexs.containsKey("rptPrecision") ? (Integer)this.colIndexs.get("rptPrecision") : -1;
        int qtyPrecisionIndex = this.colIndexs.containsKey("qtyPrecision") ? (Integer)this.colIndexs.get("qtyPrecision") : -1;
        int companyNumberIndex = (Integer)this.colIndexs.get("companyNumber");
        String orgNumber = null;
        int n = i = firstBatch ? 2 : 0;
        while (i < values.size()) {
            String str;
            List<String> items = values.get(i);
            if (this.sheetByOrg) {
                orgNumber = items.get(companyNumberIndex);
            }
            if (this.sheetByOrg && !orgNumber.equals(this.lastOrgNumber)) {
                this.sheet = this.wb.createSheet(orgNumber);
                this.buildHead();
                beginIndex = 2;
                this.sheetIndex = 1;
            } else if (beginIndex >= this.MAX_SIZE) {
                this.sheet = this.wb.createSheet((orgNumber != null ? orgNumber : this.getSheetName()) + "_" + ++this.sheetIndex);
                this.buildHead();
                beginIndex = 2;
            }
            this.lastOrgNumber = orgNumber;
            Row row = this.sheet.createRow(beginIndex++);
            String bookedDate = items.get(bookedDateIndex);
            XSSFCellStyle s = null;
            String type = "2";
            if ("1".equals(bookedDate)) {
                bookedDate = this.getResource("beginBalance_exp");
                s = this.beginStyle;
                if (this.showByAccountDc) {
                    accountDc = items.get((Integer)this.colIndexs.get("accountDc"));
                }
                type = "1";
            } else if ("3".equals(bookedDate)) {
                bookedDate = this.getResource("sumPeriod");
                s = this.periodSumStyle;
                type = "3";
            } else if ("4".equals(bookedDate)) {
                bookedDate = this.getResource("sumYear");
                s = this.yearSumStyle;
                type = "4";
            }
            items.set(bookedDateIndex, bookedDate);
            double endFor = 0.0;
            if (this.showFor && (str = items.get((Integer)this.colIndexs.get("endBalanceFor"))) != null && str.length() > 0) {
                endFor = Double.parseDouble(str);
            }
            double endLocal = 0.0;
            if (this.showLocal && (str = items.get((Integer)this.colIndexs.get("endBalanceLocal"))) != null && str.length() > 0) {
                endLocal = Double.parseDouble(str);
            }
            double endRpt = 0.0;
            if (this.showRpt && (str = items.get((Integer)this.colIndexs.get("endBalanceRpt"))) != null && str.length() > 0) {
                endRpt = Double.parseDouble(str);
            }
            double endQty = 0.0;
            if (this.showQty && (str = items.get((Integer)this.colIndexs.get("endQty"))) != null && str.length() > 0) {
                endQty = Double.parseDouble(str);
            }
            double end = 0.0;
            if (this.showFor) {
                end = endFor;
            } else if (this.showLocal) {
                end = endLocal;
            } else if (this.showRpt) {
                end = endRpt;
            }
            String dc = "";
            if (this.showByAccountDc) {
                if (end == 0.0) {
                    dc = this.getResource("ping");
                } else if ("1".equals(accountDc)) {
                    dc = this.getResource("debit");
                } else {
                    dc = this.getResource("credit");
                    endFor = 0.0 - endFor;
                    endLocal = 0.0 - endLocal;
                    endRpt = 0.0 - endRpt;
                    endQty = 0.0 - endQty;
                }
            } else if (end == 0.0) {
                dc = this.getResource("ping");
            } else if (end > 0.0) {
                dc = this.getResource("debit");
            } else {
                dc = this.getResource("credit");
                endFor = 0.0 - endFor;
                endLocal = 0.0 - endLocal;
                endRpt = 0.0 - endRpt;
                endQty = 0.0 - endQty;
            }
            int forPrecision = -1;
            int localPrecision = -1;
            int rptPrecision = -1;
            int qtyPrecision = -1;
            try {
                if (forPrecisionIndex >= 0) {
                    forPrecision = Integer.parseInt(items.get(forPrecisionIndex));
                }
                if (localPrecisionIndex >= 0) {
                    localPrecision = Integer.parseInt(items.get(localPrecisionIndex));
                }
                if (rptPrecisionIndex >= 0) {
                    rptPrecision = Integer.parseInt(items.get(rptPrecisionIndex));
                }
                if (qtyPrecisionIndex >= 0) {
                    qtyPrecision = Integer.parseInt(items.get(qtyPrecisionIndex));
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            for (int j = 0; j < this.allCols.size(); ++j) {
                String colName = (String)this.allCols.get(j);
                int index = (Integer)this.colIndexs.get(colName);
                String value = items.get(index);
                Cell cell = row.createCell(j);
                cell.setCellStyle((CellStyle)(s == null ? this.textStyle : s));
                if (colName.equals("dc")) {
                    cell.setCellValue(dc);
                    continue;
                }
                if (colName.equals("endBalanceFor")) {
                    if (endFor == 0.0) {
                        cell.setCellValue("");
                        continue;
                    }
                    cell.setCellValue(endFor);
                    cell.setCellStyle((CellStyle)this.getNumberCellStyle(type, forPrecision));
                    continue;
                }
                if (colName.equals("endBalanceLocal")) {
                    if (endLocal == 0.0) {
                        cell.setCellValue("");
                        continue;
                    }
                    cell.setCellValue(endLocal);
                    cell.setCellStyle((CellStyle)this.getNumberCellStyle(type, localPrecision));
                    continue;
                }
                if (colName.equals("endBalanceRpt")) {
                    if (endRpt == 0.0) {
                        cell.setCellValue("");
                        continue;
                    }
                    cell.setCellValue(endRpt);
                    cell.setCellStyle((CellStyle)this.getNumberCellStyle(type, rptPrecision));
                    continue;
                }
                if (colName.equals("endQty")) {
                    if (endQty == 0.0) {
                        cell.setCellValue("");
                        continue;
                    }
                    cell.setCellValue(endQty);
                    cell.setCellStyle((CellStyle)this.getNumberCellStyle(type, qtyPrecision));
                    continue;
                }
                if (colName.endsWith("For") || colName.endsWith("Local") || colName.endsWith("Rpt") || colName.endsWith("Qty")) {
                    Double d;
                    if (value == null || value.length() == 0) {
                        value = "0";
                    }
                    if ((d = Double.valueOf(Double.parseDouble(value))) == 0.0) {
                        cell.setCellValue("");
                        continue;
                    }
                    cell.setCellValue(d.doubleValue());
                    int scale = colName.endsWith("For") ? forPrecision : (colName.endsWith("Local") ? localPrecision : (colName.endsWith("Rpt") ? rptPrecision : qtyPrecision));
                    cell.setCellStyle((CellStyle)this.getNumberCellStyle(type, scale));
                    continue;
                }
                if (colName.endsWith("Level")) {
                    if (StringUtils.isEmpty((String)value)) continue;
                    cell.setCellValue(Double.parseDouble(value));
                    continue;
                }
                if (colName.equals("isBizUnit")) {
                    if ("1".equals(value)) {
                        cell.setCellValue(this.getResource("yes"));
                        continue;
                    }
                    cell.setCellValue(this.getResource("no"));
                    continue;
                }
                if (colName.equals("accountDc")) {
                    if ("1".equals(value)) {
                        cell.setCellValue(this.getResource("debit"));
                        continue;
                    }
                    cell.setCellValue(this.getResource("credit"));
                    continue;
                }
                cell.setCellValue(value);
            }
            ++i;
        }
        return beginIndex;
    }

    protected XSSFCellStyle getNumberCellStyle(String type, int scale) {
        String key = type + "_" + scale;
        XSSFCellStyle style = this.cellStyles.get(key);
        if (style == null) {
            XSSFColor borderColor = new XSSFColor(new Color(218, 220, 221));
            style = (XSSFCellStyle)this.wb.createCellStyle();
            if (type.equals("1")) {
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(new XSSFColor(new Color(238, 236, 248)));
            } else if (type.equals("3")) {
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(new XSSFColor(new Color(232, 228, 203)));
            } else if (type.equals("4")) {
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(new XSSFColor(new Color(233, 226, 184)));
            }
            DataFormat format = this.wb.createDataFormat();
            if (scale >= 0) {
                style.setDataFormat(format.getFormat(GlUtils.getDecimalFormat(scale)));
            }
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderTop(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
            style.setBottomBorderColor(borderColor);
            style.setTopBorderColor(borderColor);
            style.setLeftBorderColor(borderColor);
            style.setRightBorderColor(borderColor);
            this.cellStyles.put(key, style);
        }
        return style;
    }

    @Override
    protected Map<String, Integer> getWidths() {
        Map<String, Integer> widths = super.getWidths();
        for (int i = 1; i <= 8; ++i) {
            widths.put("asstActNumber" + i, 4000);
            widths.put("asstActLongNumber" + i, 5000);
            widths.put("asstActName" + i, 4000);
            widths.put("asstActLevel" + i, 2000);
            widths.put("asstAct" + i, 8000);
            widths.put("oppAsstAct" + i, 6000);
        }
        widths.put("bookedDate", 3000);
        widths.put("bizDate", 3000);
        widths.put("description", 4000);
        widths.put("oppDescription", 4000);
        widths.put("dc", 1500);
        widths.put("oppAccountNumber", 4000);
        widths.put("oppAccountName", 4000);
        widths.put("oppAccountLongName", 4000);
        return widths;
    }
}

