/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLNRptSubLedgerUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAsstactGDUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptSubLedgerExportUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptSubLedgerQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTable;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTableHelper;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.config.IObjectMultiPKBuilder;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;

public class GLNRptSubLedgerUI
extends AbstractGLNRptSubLedgerUI {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptSubLedgerUI.class);
    public static final Color PERIOD_BEGIN_COLOR = new Color(238, 236, 248);
    public static final Color PERIOD_TOTAL_COLOR = new Color(232, 228, 203);
    public static final Color YEAR_TOTAL_COLOR = new Color(233, 226, 184);
    protected boolean showFor = false;
    protected boolean showLocal = false;
    protected boolean showRpt = false;
    protected boolean showQty = false;
    protected Map<String, CompanyOrgUnitInfo> linckCompanys = new HashMap<String, CompanyOrgUnitInfo>();
    protected Map<String, AccountViewInfo> linkAccounts = new HashMap<String, AccountViewInfo>();
    protected Map<String, String> linkCaaIds = new HashMap<String, String>();
    protected String linkCaaId = null;

    public GLNRptSubLedgerUI() throws Exception {
        this.init();
    }

    private void init() {
        this.txtConsole.setContentType("text/html");
        this.txtConsole.setEditable(false);
        StringBuffer htmlText = new StringBuffer();
        htmlText.append("<html>");
        htmlText.append("<body>");
        htmlText.append(this.getResource("detailsUsageInfo"));
        htmlText.append("<br>");
        htmlText.append("<a href=\"https://vip.kingdee.com/article/348056214297014016\">https://vip.kingdee.com/article/348056214297014016</a>");
        htmlText.append("<br>");
        htmlText.append("</body>");
        htmlText.append("</html>");
        this.txtConsole.setText(htmlText.toString());
        this.txtConsole.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(evt.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initPopMenu(GLNRptSubLedgerExportUI.class.getName());
    }

    protected void initListener() {
        super.initListener();
        this.getTable().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                if (GLNRptSubLedgerUI.this.innerSumTable != null) {
                    GLNRptSubLedgerUI.this.innerSumTable.setVisible(false);
                }
                if (GLNRptSubLedgerUI.this.innerSumTable != null && (GLNRptSubLedgerUI.this.getTable().getSelectManager().size() > 1 || e.getSelectBlock().getEndRow() - e.getSelectBlock().getBeginRow() > 0)) {
                    GLNRptSubLedgerUI.this.innerSumTable.selectRowSum(GLNRptSubLedgerUI.this.getTable().getSelectManager().getBlocks(), false);
                } else {
                    int rowIndex = e.getSelectBlock().getTop();
                    GLNRptSubLedgerUI.this.tblMain_doSelectChanged(rowIndex);
                }
            }
        });
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        GLNRptSubLedgerUI.this.tblMain_doDoubleClicked();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    GLNRptSubLedgerUI.this.handleError(ex);
                }
            }
        });
    }

    public void tblMain_doDoubleClicked() {
        this.findVoucher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findVoucher() {
        String voucherId;
        int rowIndex = KDTableUtil.getSelectedTop((KDTable)this.getTable());
        IRow row = this.getTable().getRow(rowIndex);
        if (row != null && !StringUtils.isEmpty((String)(voucherId = (String)row.getCell("voucherId").getValue()))) {
            try {
                this.setCursorOfWair();
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)voucherId);
                uiContext.put((Object)"NOTLICHA", (Object)"NOTLICHA");
                uiContext.put((Object)"FINDVIEW", (Object)Boolean.TRUE);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)VoucherEditUI.getEditUIMode((CoreUIObject)this)).create(VoucherInfo.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (UIException e) {
                logger.error((Object)e);
                this.handleError((Exception)((Object)e));
            }
            finally {
                this.setCursorOfDefault();
            }
        }
    }

    public void tblMain_doSelectChanged(int rowIndex) {
        this.actionVoucher.setEnabled(false);
        this.actionAsstactGD.setEnabled(false);
        this.linkCaaId = null;
        IRow row = this.getTable().getRow(rowIndex);
        if (row != null) {
            String voucherId = (String)row.getCell("voucherId").getValue();
            this.actionVoucher.setEnabled(!StringUtils.isEmpty((String)voucherId));
            ICell cell = row.getCell("asstAct1");
            if (cell != null && !StringUtils.isEmpty((String)((String)cell.getValue()))) {
                this.actionAsstactGD.setEnabled(true);
                return;
            }
            String accountNumber = null;
            cell = row.getCell("accountNumber");
            if (cell != null) {
                accountNumber = (String)cell.getValue();
            }
            if (accountNumber == null || accountNumber.trim().length() == 0) {
                return;
            }
            String companyNumber = null;
            cell = row.getCell("companyNumber");
            if (cell != null) {
                companyNumber = (String)cell.getValue();
            }
            if (companyNumber == null || companyNumber.trim().length() == 0) {
                return;
            }
            this.linkCaaId = this.getLinckCaaId(companyNumber, accountNumber);
            this.actionAsstactGD.setEnabled(this.linkCaaId != null);
        }
    }

    private String getLinckCaaId(String companyNumber, String accountNumber) {
        String caaId = null;
        try {
            CompanyOrgUnitInfo linkCompany = null;
            if (this.linckCompanys.containsKey(companyNumber)) {
                linkCompany = this.linckCompanys.get(companyNumber);
            } else {
                linkCompany = this.getCompany(companyNumber);
                this.linckCompanys.put(companyNumber, linkCompany);
            }
            if (linkCompany == null) {
                return caaId;
            }
            String accountTableNumber = (String)this.queryConfig.get("accountTableNumber");
            String key = linkCompany.getId().toString();
            if (accountTableNumber != null && accountTableNumber.length() > 0) {
                key = key + accountTableNumber;
            } else if (linkCompany.getAccountTable() != null) {
                key = key + linkCompany.getAccountTable().getId().toString();
            }
            key = key + accountNumber;
            AccountViewInfo linkAccount = null;
            if (this.linkAccounts.containsKey(key)) {
                linkAccount = this.linkAccounts.get(key);
            } else {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)linkCompany.getId().toString()));
                if (accountTableNumber != null && accountTableNumber.length() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("accountTableID.number", (Object)accountTableNumber));
                } else if (linkCompany.getAccountTable() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)linkCompany.getAccountTable().getId().toString()));
                }
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("isLeaf");
                selector.add("CAA.id");
                view.setSelector(selector);
                AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
                if (coll.size() > 0) {
                    linkAccount = coll.get(0);
                }
                this.linkAccounts.put(key, linkAccount);
            }
            if (linkAccount == null) {
                return caaId;
            }
            if (linkAccount.getCAA() != null) {
                caaId = linkAccount.getCAA().getId().toString();
            }
            if (linkCompany.isIsBizUnit() && linkAccount.isIsLeaf()) {
                String toPeriodNumber = (String)this.queryConfig.get("toPeriodNumber");
                String fromPeriodNumber = (String)this.queryConfig.get("fromPeriodNumber");
                key = linkAccount.getId().toString() + toPeriodNumber + fromPeriodNumber;
                if (this.linkCaaIds.containsKey(key)) {
                    caaId = this.linkCaaIds.get(key);
                } else {
                    Set caaIds;
                    if (toPeriodNumber != null && toPeriodNumber.trim().length() > 0 && (caaId = AccountFacadeFactory.getRemoteInstance().getCAAIdByPeriod(linkAccount.getId().toString(), Integer.parseInt(toPeriodNumber))) == null && fromPeriodNumber != null && fromPeriodNumber.trim().length() > 0 && (caaIds = AccountFacadeFactory.getRemoteInstance().getCAAIdsByPeriodRange(linkAccount.getId().toString(), Integer.parseInt(fromPeriodNumber), Integer.parseInt(toPeriodNumber))).size() > 0) {
                        caaId = (String)caaIds.iterator().next();
                    }
                    this.linkCaaIds.put(key, caaId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return caaId;
    }

    @Override
    protected GLNRptBaseQueryUI getCustQueryPanel() throws Exception {
        return new GLNRptSubLedgerQueryUI();
    }

    @Override
    protected void setQueryDialogSize(CommonQueryDialog dialog) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        int width = screen.width - insets.left - insets.right;
        if ((width -= 300) > 1130) {
            width = 1130;
        }
        int height = screen.height - insets.top - insets.bottom;
        if ((height -= 90) > 724) {
            height = 724;
        }
        dialog.setWidth(width);
        dialog.setHeight(height);
    }

    @Override
    public int getColumnWidthByColumnName(String colName) {
        return super.getColumnWidthByColumnName(colName);
    }

    @Override
    public void setRptType(Map<String, Object> queryConfig) {
        Object showCompanyLevel = queryConfig.get("showCompanyLevel");
        Object showAccountLevel = queryConfig.get("showAccountLevel");
        super.setRptType(queryConfig);
        queryConfig.put("rptType", "SubLedger");
        queryConfig.put("showVoucherId", "true");
        queryConfig.put("showCompanyLevel", showCompanyLevel);
        queryConfig.put("showAccountLevel", showAccountLevel);
    }

    @Override
    public GLNRptTableHeadInfo initTableColumn(List<String> colNames, List<String> colAliass) {
        String colAlias;
        int index;
        String colName;
        int i;
        int i2;
        this.initVariable(this.getTable());
        this.tableHeadInfo = new GLNRptTableHeadInfo();
        this.colIndexes.clear();
        ArrayList<String> commonCols = new ArrayList<String>();
        ArrayList<String> asstActCols = new ArrayList<String>();
        ArrayList<String> oppAccountCols = new ArrayList<String>();
        ArrayList<String> oppAsstActCols = new ArrayList<String>();
        for (i2 = 0; i2 < colNames.size(); ++i2) {
            String colName2 = colNames.get(i2);
            this.colIndexes.put(colName2, i2);
            if (colName2.endsWith("For") || colName2.endsWith("Local") || colName2.endsWith("Rpt") || colName2.endsWith("Qty") || colName2.equals("dc")) continue;
            if (colName2.startsWith("asstAct")) {
                asstActCols.add(colName2);
                continue;
            }
            if (colName2.startsWith("oppAccount") || colName2.equals("oppDescription")) {
                oppAccountCols.add(colName2);
                continue;
            }
            if (colName2.startsWith("oppAsstAct")) {
                oppAsstActCols.add(colName2);
                continue;
            }
            if ("accountDc".equals(colName2) && !this.showAccountDc) continue;
            commonCols.add(colName2);
        }
        this.realAsstActColCount = asstActCols.size();
        if (this.realAsstActColCount != 0) {
            for (i2 = this.realAsstActColCount + 1; i2 <= 8; ++i2) {
                asstActCols.add("asstAct" + i2);
            }
        }
        this.colIndexes.put("dc", 0);
        ArrayList<String> cols = new ArrayList<String>();
        if (this.colIndexes.containsKey("debitQty")) {
            cols.add("debitQty");
        }
        if (this.colIndexes.containsKey("debitFor")) {
            cols.add("debitFor");
        }
        if (this.colIndexes.containsKey("debitLocal")) {
            cols.add("debitLocal");
        }
        if (this.colIndexes.containsKey("debitRpt")) {
            cols.add("debitRpt");
        }
        if (this.colIndexes.containsKey("creditQty")) {
            cols.add("creditQty");
        }
        if (this.colIndexes.containsKey("creditFor")) {
            cols.add("creditFor");
        }
        if (this.colIndexes.containsKey("creditLocal")) {
            cols.add("creditLocal");
        }
        if (this.colIndexes.containsKey("creditRpt")) {
            cols.add("creditRpt");
        }
        ArrayList<String> endCols = new ArrayList<String>();
        if (colAliass.size() > 0) {
            endCols.add("dc");
        }
        if (this.colIndexes.containsKey("endQty")) {
            endCols.add("endQty");
        }
        if (this.colIndexes.containsKey("endBalanceFor")) {
            endCols.add("endBalanceFor");
        }
        if (this.colIndexes.containsKey("endBalanceLocal")) {
            endCols.add("endBalanceLocal");
        }
        if (this.colIndexes.containsKey("endBalanceRpt")) {
            endCols.add("endBalanceRpt");
        }
        ArrayList<String> allCols = new ArrayList<String>();
        allCols.addAll(commonCols);
        allCols.addAll(asstActCols);
        allCols.addAll(oppAccountCols);
        allCols.addAll(oppAsstActCols);
        allCols.addAll(cols);
        allCols.addAll(endCols);
        this.tableHeadInfo.setColumnNames(allCols);
        ArrayList<List<String>> columnTitles = new ArrayList<List<String>>();
        this.tableHeadInfo.setColumnTitles(columnTitles);
        ArrayList<String> columnTitle1 = new ArrayList<String>();
        ArrayList<String> columnTitle2 = new ArrayList<String>();
        columnTitles.add(columnTitle1);
        columnTitles.add(columnTitle2);
        for (i = 0; i < commonCols.size(); ++i) {
            colName = (String)commonCols.get(i);
            index = (Integer)this.colIndexes.get(colName);
            colAlias = colAliass.get(index);
            columnTitle1.add(colAlias);
            columnTitle2.add(colAlias);
        }
        for (i = 0; i < asstActCols.size(); ++i) {
            columnTitle1.add(this.getResource("asstAct"));
            columnTitle2.add(this.getResource("asstAct"));
        }
        for (i = 0; i < oppAccountCols.size(); ++i) {
            colName = (String)oppAccountCols.get(i);
            index = (Integer)this.colIndexes.get(colName);
            colAlias = colAliass.get(index);
            columnTitle1.add(colAlias);
            columnTitle2.add(colAlias);
        }
        for (i = 0; i < oppAsstActCols.size(); ++i) {
            columnTitle1.add(this.getResource("oppAsstAct"));
            columnTitle2.add(this.getResource("oppAsstAct"));
        }
        for (i = 0; i < cols.size(); ++i) {
            columnTitle1.add(this.getResource("periodHappen"));
            colName = (String)cols.get(i);
            index = (Integer)this.colIndexes.get(colName);
            colAlias = colAliass.get(index);
            if (colName.equals("debitQty")) {
                colAlias = this.getResource("debitQty_exp");
            } else if (colName.equals("debitFor")) {
                colAlias = this.getResource("debitFor_exp");
            } else if (colName.equals("debitLocal")) {
                colAlias = this.getResource("debitLocal_exp");
            } else if (colName.equals("debitRpt")) {
                colAlias = this.getResource("debitRpt_exp");
            } else if (colName.equals("creditQty")) {
                colAlias = this.getResource("creditQty_exp");
            } else if (colName.equals("creditFor")) {
                colAlias = this.getResource("creditFor_exp");
            } else if (colName.equals("creditLocal")) {
                colAlias = this.getResource("creditLocal_exp");
            } else if (colName.equals("creditRpt")) {
                colAlias = this.getResource("creditRpt_exp");
            }
            columnTitle2.add(colAlias);
        }
        for (i = 0; i < endCols.size(); ++i) {
            columnTitle1.add(this.getResource("endBalance_exp"));
            colName = (String)endCols.get(i);
            index = (Integer)this.colIndexes.get(colName);
            colAlias = colAliass.get(index);
            if (colName.equals("dc")) {
                colAlias = this.getResource("dc");
            } else if (colName.equals("endQty")) {
                colAlias = this.getResource("qty_exp");
            } else if (colName.equals("endBalanceFor")) {
                colAlias = this.getResource("for_exp");
            } else if (colName.equals("endBalanceLocal")) {
                colAlias = this.getResource("local_exp");
            } else if (colName.equals("endBalanceRpt")) {
                colAlias = this.getResource("rpt_exp");
            }
            columnTitle2.add(colAlias);
        }
        return this.tableHeadInfo;
    }

    @Override
    protected void setColumnStyle(IColumn column) {
        if (column != null && "voucherId".equals(column.getKey())) {
            column.getStyleAttributes().setHided(true);
        }
    }

    @Override
    protected void initVariable(GLNRptTable glnRptTable) {
        super.initVariable(glnRptTable);
        this.showFor = false;
        this.showLocal = false;
        this.showRpt = false;
        this.showQty = false;
        if (glnRptTable.queryConfig != null) {
            if (glnRptTable.queryConfig.containsKey("showFor") && Boolean.valueOf((String)glnRptTable.queryConfig.get("showFor")).booleanValue()) {
                this.showFor = true;
            }
            if (glnRptTable.queryConfig.containsKey("showLocal") && Boolean.valueOf((String)glnRptTable.queryConfig.get("showLocal")).booleanValue()) {
                this.showLocal = true;
            }
            if (glnRptTable.queryConfig.containsKey("showRpt") && Boolean.valueOf((String)glnRptTable.queryConfig.get("showRpt")).booleanValue()) {
                this.showRpt = true;
            }
            if (glnRptTable.queryConfig.containsKey("showQty") && Boolean.valueOf((String)glnRptTable.queryConfig.get("showQty")).booleanValue()) {
                this.showQty = true;
            }
        }
    }

    @Override
    public void fillDataToTable(List<List<String>> data, int startRowIndex) {
        if (data == null || data.size() == 0) {
            return;
        }
        int rowIndex = startRowIndex;
        List<String> columnNames = this.tableHeadInfo.getColumnNames();
        int bookedDateIndex = (Integer)this.colIndexes.get("bookedDate");
        String accountDc = "1";
        int forPrecisionIndex = this.colIndexes.containsKey("forPrecision") ? (Integer)this.colIndexes.get("forPrecision") : -1;
        int localPrecisionIndex = this.colIndexes.containsKey("localPrecision") ? (Integer)this.colIndexes.get("localPrecision") : -1;
        int rptPrecisionIndex = this.colIndexes.containsKey("rptPrecision") ? (Integer)this.colIndexes.get("rptPrecision") : -1;
        int qtyPrecisionIndex = this.colIndexes.containsKey("qtyPrecision") ? (Integer)this.colIndexes.get("qtyPrecision") : -1;
        for (int i = 0; i < data.size(); ++i) {
            IRow row = this.getTable().getRow2(rowIndex);
            if (row == null) {
                String str;
                String bookedDate;
                row = this.getTable().setRow(rowIndex);
                List<String> rowData = data.get(i);
                if (this.showByAccountDc) {
                    accountDc = rowData.get((Integer)this.colIndexes.get("accountDc"));
                }
                if ("1".equals(bookedDate = rowData.get(bookedDateIndex))) {
                    bookedDate = this.getResource("beginBalance_exp");
                    row.getStyleAttributes().setBackground(PERIOD_BEGIN_COLOR);
                } else if ("3".equals(bookedDate)) {
                    bookedDate = this.getResource("sumPeriod");
                    row.getStyleAttributes().setBackground(PERIOD_TOTAL_COLOR);
                } else if ("4".equals(bookedDate)) {
                    bookedDate = this.getResource("sumYear");
                    row.getStyleAttributes().setBackground(YEAR_TOTAL_COLOR);
                }
                rowData.set(bookedDateIndex, bookedDate);
                BigDecimal endFor = GlUtils.zero;
                if (this.showFor && (str = rowData.get((Integer)this.colIndexes.get("endBalanceFor"))) != null && str.length() > 0) {
                    endFor = new BigDecimal(str);
                }
                BigDecimal endLocal = GlUtils.zero;
                if (this.showLocal && (str = rowData.get((Integer)this.colIndexes.get("endBalanceLocal"))) != null && str.length() > 0) {
                    endLocal = new BigDecimal(str);
                }
                BigDecimal endRpt = GlUtils.zero;
                if (this.showRpt && (str = rowData.get((Integer)this.colIndexes.get("endBalanceRpt"))) != null && str.length() > 0) {
                    endRpt = new BigDecimal(str);
                }
                BigDecimal endQty = GlUtils.zero;
                if (this.showQty && (str = rowData.get((Integer)this.colIndexes.get("endQty"))) != null && str.length() > 0) {
                    endQty = new BigDecimal(str);
                }
                BigDecimal end = GlUtils.zero;
                if (this.showFor) {
                    end = endFor;
                } else if (this.showLocal) {
                    end = endLocal;
                } else if (this.showRpt) {
                    end = endRpt;
                }
                String dc = "";
                if (this.showByAccountDc) {
                    if (end.compareTo(GlUtils.zero) == 0) {
                        dc = this.getResource("ping");
                    } else if ("1".equals(accountDc)) {
                        dc = this.getResource("debit");
                    } else {
                        dc = this.getResource("credit");
                        endFor = GlUtils.zero.subtract(endFor);
                        endLocal = GlUtils.zero.subtract(endLocal);
                        endRpt = GlUtils.zero.subtract(endRpt);
                        endQty = GlUtils.zero.subtract(endQty);
                    }
                } else if (end.compareTo(GlUtils.zero) == 0) {
                    dc = this.getResource("ping");
                } else if (end.compareTo(GlUtils.zero) > 0) {
                    dc = this.getResource("debit");
                } else {
                    dc = this.getResource("credit");
                    endFor = GlUtils.zero.subtract(endFor);
                    endLocal = GlUtils.zero.subtract(endLocal);
                    endRpt = GlUtils.zero.subtract(endRpt);
                    endQty = GlUtils.zero.subtract(endQty);
                }
                int forPrecision = -1;
                int localPrecision = -1;
                int rptPrecision = -1;
                int qtyPrecision = -1;
                try {
                    if (forPrecisionIndex >= 0) {
                        forPrecision = Integer.parseInt(rowData.get(forPrecisionIndex));
                    }
                    if (localPrecisionIndex >= 0) {
                        localPrecision = Integer.parseInt(rowData.get(localPrecisionIndex));
                    }
                    if (rptPrecisionIndex >= 0) {
                        rptPrecision = Integer.parseInt(rowData.get(rptPrecisionIndex));
                    }
                    if (qtyPrecisionIndex >= 0) {
                        qtyPrecision = Integer.parseInt(rowData.get(qtyPrecisionIndex));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                for (int j = 0; j < columnNames.size(); ++j) {
                    String colName = columnNames.get(j);
                    if (!this.colIndexes.containsKey(colName)) continue;
                    int colIndex = (Integer)this.colIndexes.get(colName);
                    String value = rowData.get(colIndex);
                    if (colName.equals("dc")) {
                        value = dc;
                    } else if (colName.equals("endBalanceFor")) {
                        value = String.valueOf(endFor);
                    } else if (colName.equals("endBalanceLocal")) {
                        value = String.valueOf(endLocal);
                    } else if (colName.equals("endBalanceRpt")) {
                        value = String.valueOf(endRpt);
                    } else if (colName.equals("endQty")) {
                        value = String.valueOf(endQty);
                    } else if ((colName.endsWith("For") || colName.endsWith("Local") || colName.endsWith("Rpt") || colName.endsWith("Qty") || colName.endsWith("Level") || colName.equals("isBizUnit") || colName.equals("accountDc")) && (value == null || value.length() == 0)) {
                        value = "0";
                    }
                    if (colName.endsWith("For") || colName.endsWith("Local") || colName.endsWith("Rpt") || colName.endsWith("Qty")) {
                        BigDecimal b = new BigDecimal(value);
                        if (b.compareTo(GlUtils.zero) == 0) {
                            row.getCell(colName).setValue((Object)"");
                            continue;
                        }
                        int scale = colName.endsWith("For") ? forPrecision : (colName.endsWith("Local") ? localPrecision : (colName.endsWith("Rpt") ? rptPrecision : qtyPrecision));
                        if (scale >= 0) {
                            row.getCell(colName).getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(scale));
                        }
                        row.getCell(colName).setValue((Object)b);
                        continue;
                    }
                    row.getCell(colName).setValue((Object)value);
                }
                this.afterFillTableRow(row, rowData);
            }
            ++rowIndex;
        }
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.findVoucher();
    }

    @Override
    protected void setQueryingActionStatus(boolean enable) {
        super.setQueryingActionStatus(enable);
        this.actionVoucher.setEnabled(false);
        this.actionAsstactGD.setEnabled(false);
    }

    @Override
    public void actionAsstactGD_actionPerformed(ActionEvent e) throws Exception {
        Object value;
        ICell cell;
        int rowIndex = KDTableUtil.getSelectedTop((KDTable)this.getTable());
        IRow row = this.getTable().getRow(rowIndex);
        HashMap<String, Object> queryConfig = new HashMap<String, Object>();
        queryConfig.putAll(this.queryConfig);
        String companyNumber = (String)row.getCell("companyNumber").getValue();
        if (!StringUtils.isEmpty((String)companyNumber)) {
            queryConfig.put("companyNumber", this.getLinkedCompanyNumber(companyNumber));
        }
        CurrencyInfo currency = null;
        String currencyNumber = (String)this.getTable().queryConfig.get("currencyNumber");
        if ((currencyNumber == null || currencyNumber.length() == 0) && (cell = row.getCell("currencyNumber")) != null) {
            currencyNumber = (String)cell.getValue();
        }
        if (currencyNumber != null && currencyNumber.length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
            if (coll.size() > 0) {
                currency = coll.get(0);
            }
        }
        if (currency != null) {
            queryConfig.put("currencyNumber", currency.getNumber());
        } else {
            String currencyName;
            cell = row.getCell("currencyName");
            if (cell != null && (currencyName = (String)cell.getValue()) != null && currencyName.length() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)currencyName));
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                view.setSelector(selector);
                CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
                if (coll.size() > 0) {
                    currency = coll.get(0);
                }
            }
            if (currency != null) {
                queryConfig.put("currencyNumber", currency.getNumber());
            }
        }
        String accountNumber = (String)row.getCell("accountNumber").getValue();
        String accountLevel = null;
        ICell cell2 = row.getCell("accountLevel");
        if (cell2 != null && (value = cell2.getValue()) != null && value.toString().trim().length() > 0) {
            try {
                int i = Integer.parseInt(value.toString().trim());
                if (i > 0) {
                    accountLevel = String.valueOf(i);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)accountNumber)) {
            HashMap<String, String> asstActType;
            String str = (String)queryConfig.get("accountNumber");
            if (str != null && str.trim().length() > 0) {
                String[] ss;
                StringBuffer numbers = new StringBuffer();
                for (String s : ss = str.split(";")) {
                    if (!(s = s.trim()).startsWith(accountNumber) || s.length() <= accountNumber.length()) continue;
                    numbers.append(s).append(";");
                }
                if (numbers.length() > 0) {
                    queryConfig.put("accountNumber", numbers.toString());
                } else {
                    queryConfig.put("accountNumber", accountNumber);
                }
            } else {
                queryConfig.put("accountNumber", accountNumber);
            }
            queryConfig.put("showPeriodSum", this.getTable().queryConfig.get("showPeriodSum"));
            queryConfig.put("showYearSum", this.getTable().queryConfig.get("showYearSum"));
            if (accountLevel == null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
                if (!StringUtils.isEmpty((String)companyNumber)) {
                    filter.getFilterItems().add(new FilterItemInfo("companyID.number", (Object)companyNumber));
                }
                if (queryConfig.get("accountTableNumber") != null) {
                    filter.getFilterItems().add(new FilterItemInfo("accountTableID.number", queryConfig.get("accountTableNumber")));
                }
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("level");
                view.setSelector(selector);
                AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
                if (coll.size() > 0) {
                    accountLevel = String.valueOf(coll.get(0).getLevel());
                }
            }
            if (accountLevel == null) {
                accountLevel = "1";
            }
            queryConfig.put("toAccountLevel", accountLevel);
            ArrayList asstActTypes = new ArrayList();
            String assistGrpId = null;
            cell2 = row.getCell("assistGrpId");
            if (cell2 != null) {
                assistGrpId = (String)cell2.getValue();
            }
            if (assistGrpId != null && assistGrpId.trim().length() > 0) {
                List ats = GLRptUtils.getAsstactTypeEntityListWithSelectItem(assistGrpId);
                queryConfig.put("asstActTypes", asstActTypes);
                for (int i = 0; i < ats.size(); ++i) {
                    AsstactTypeEntity at = (AsstactTypeEntity)ats.get(i);
                    asstActType = new HashMap();
                    asstActTypes.add(asstActType);
                    asstActType.put("type", at.getNumber());
                    DataBaseInfo db = (DataBaseInfo)at.getFrom();
                    if (db == null) continue;
                    String number = at.isGeneralActType() ? (String)db.get("longNumber") : db.getNumber();
                    asstActType.put("from", number);
                    asstActType.put("to", number);
                }
            } else {
                if (this.linkCaaId == null) {
                    return;
                }
                AsstActTypeCollection aats = GLAsstAccountUtils.getAsstActTypes(this.getMainOrgContext(), this.linkCaaId);
                queryConfig.put("asstActTypes", asstActTypes);
                for (int i = 0; i < aats.size(); ++i) {
                    asstActType = new HashMap<String, String>();
                    asstActTypes.add(asstActType);
                    asstActType.put("type", aats.get(i).getNumber());
                }
            }
            this.joinQuery(queryConfig, GLNRptAsstactGDUI.class.getName());
        }
    }

    @Override
    protected Map<String, Object> getSearchParams(int type) {
        Map<String, Object> params = super.getSearchParams(type);
        params.put("showRemoteSearch", "true");
        return params;
    }

    @Override
    protected List<Map<String, String>> getSearchTargets(int type) {
        ArrayList<Map<String, String>> targets = new ArrayList<Map<String, String>>();
        GLNRptTable table = this.getTable();
        if (table == null) {
            return targets;
        }
        HashSet<String> names = new HashSet<String>();
        names.add("accountNumber");
        names.add("accountName");
        names.add("accountLongName");
        names.add("currencyNumber");
        names.add("currencyName");
        names.add("bookedDate");
        names.add("bizDate");
        names.add("companyNumber");
        names.add("companyLongNumber");
        names.add("companyName");
        names.add("voucherType");
        names.add("voucherNumber");
        names.add("description");
        names.add("creatorName");
        names.add("asstAct1");
        names.add("asstAct2");
        names.add("asstAct3");
        names.add("asstAct4");
        names.add("asstAct5");
        names.add("asstAct6");
        names.add("asstAct7");
        names.add("asstAct8");
        names.add("oppAccountNumber");
        names.add("oppAccountName");
        names.add("oppAccountLongName");
        names.add("oppDescription");
        names.add("oppAsstAct1");
        names.add("oppAsstAct2");
        names.add("oppAsstAct3");
        names.add("oppAsstAct4");
        names.add("oppAsstAct5");
        names.add("oppAsstAct6");
        names.add("oppAsstAct7");
        names.add("oppAsstAct8");
        names.add("debitFor");
        names.add("creditFor");
        names.add("endBalanceFor");
        names.add("debitLocal");
        names.add("creditLocal");
        names.add("endBalanceLocal");
        names.add("debitRpt");
        names.add("creditRpt");
        names.add("endBalanceRpt");
        HashSet<Integer> selectedIndexs = new HashSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            KDTSelectBlock block = table.getSelectManager().get(i);
            if (block.getMode() != 1 && block.getMode() != 15 && block.getMode() != 4 && block.getMode() != 12) continue;
            for (int j = block.getLeft(); j <= block.getRight(); ++j) {
                selectedIndexs.add(j);
            }
        }
        for (int columIndex = 0; columIndex < table.getColumnCount(); ++columIndex) {
            String key;
            IColumn col = table.getColumn(columIndex);
            if (col == null || col.getStyleAttributes().isHided() || (key = col.getKey()) == null || !names.contains(key)) continue;
            HashMap<String, String> target = new HashMap<String, String>();
            target.put("name", key);
            if (key.startsWith("asstAct")) {
                target.put("title", this.getResource("asstAct") + key.substring(7));
            } else if (key.startsWith("oppAsstAct")) {
                target.put("title", this.getResource("oppAsstAct") + key.substring(7));
            } else {
                target.put("title", this.getResource(key));
            }
            if (type == 1) {
                if (selectedIndexs.contains(columIndex)) {
                    target.put("selected", "true");
                } else {
                    target.put("selected", "false");
                }
            } else if (type == 2 && selectedIndexs.contains(columIndex)) {
                target.put("selected", "true");
            }
            targets.add(target);
        }
        return targets;
    }

    @Override
    public Object getTablePreferenceSchemaKey() {
        Object key = super.getTablePreferenceSchemaKey();
        String showOppAccount = (String)this.queryConfig.get("showOppAccount");
        String showOppAsstact = (String)this.queryConfig.get("showOppAsstact");
        return key + "||" + showOppAccount + "||" + showOppAsstact;
    }

    protected void initHelper() {
        this.tHelperPrint = this.tHelper = new GLNRptTableHelper(this, new IObjectMultiPKBuilder(){

            public IObjectPK buildPK() {
                return GLNRptSubLedgerUI.this.buildPK();
            }
        });
    }

    @Override
    protected String getExportPermissionItem() {
        return "gln_subsidiaryLedger_export";
    }
}

