/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IWSVoucher;
import com.kingdee.eas.fi.gl.ZipUtils;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAccountBalanceUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAsstActBalanceUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptAsstactGDUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptBaseUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptDataComponent;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptSubLedgerUI;
import com.kingdee.eas.fi.gl.rpt.client.GLNRptTableHeadInfo;
import com.kingdee.eas.util.client.EASResource;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GLNRptTable
extends KDTable
implements GLNRptDataComponent,
Serializable {
    private static final Logger logger = CoreUIObject.getLogger(GLNRptTable.class);
    private static final long serialVersionUID = 3326585547270045264L;
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLNResource";
    private GLNRptBaseUI owner;
    private IWSVoucher iWsVoucher;
    private GLNRptBaseUI.QueryAfterHandler handler;
    protected Map<String, Object> queryConfig;
    private boolean firstLoadData = true;
    private boolean isAsynQuery = true;
    private String queryId;
    protected List<String> colNames = new ArrayList<String>();
    protected List<String> colAliass = new ArrayList<String>();
    private int rowCount = -1;
    protected int companyTopLevel = 1;
    private boolean isReParseTable = true;
    public List<Map<String, Object>> companyTree = null;

    @Override
    public void init(GLNRptBaseUI owner, IWSVoucher iWsVoucher, GLNRptBaseUI.QueryAfterHandler handler, boolean isAsynQuery) {
        this.owner = owner;
        this.iWsVoucher = iWsVoucher;
        this.handler = handler;
        this.isAsynQuery = isAsynQuery;
        this.getDataRequestManager().setDataRequestMode(1);
        this.initListener();
        this.setEditable(false);
    }

    public void initListener() {
        this.addKDTDataRequestListener(new KDTDataRequestListener(){

            public void tableDataRequest(KDTDataRequestEvent event) {
                try {
                    GLNRptTable.this.tblMain_doRequestRowSet(event.getFirstRow());
                }
                catch (Exception e) {
                    GLNRptTable.this.setRowCount(0);
                    logger.error((Object)e);
                    GLNRptTable.this.owner.handleError(e);
                }
            }
        });
    }

    protected void tblMain_doRequestRowSet(int start) throws EASBizException, BOSException, IOException {
        if (start == 0 && this.firstLoadData) {
            this.firstLoadData = false;
            this.rowCount = 0;
            this.setRowCount(this.rowCount);
            if (this.queryConfig == null) {
                return;
            }
            AsynQuery query = new AsynQuery(start);
            if (this.isAsynQuery) {
                Executors.newSingleThreadExecutor().execute(query);
            } else {
                query.run();
            }
        } else {
            List<List<String>> data = this.getData(start);
            if (data != null) {
                this.fillDataToTable(data, start);
                this.afterFillDataToTable(start, start + data.size());
            }
        }
    }

    public void fillDataToTable(List<List<String>> data, int startRowIndex) {
        this.owner.fillDataToTable(data, startRowIndex);
    }

    private List<List<String>> getData(int start) throws EASBizException, BOSException, IOException {
        return this.getData(start, this.getDataRequestManager().getPageRowCount());
    }

    private synchronized List<List<String>> getData(int start, int rowCount) throws EASBizException, BOSException, IOException {
        int length = rowCount;
        int toRowCount = start + rowCount;
        for (int i = start; i < toRowCount && i < this.getRowCount() && this.getRow2(i) != null; ++i) {
            --length;
            ++start;
        }
        if (length <= 0) {
            return null;
        }
        String nGetBalance = this.iWsVoucher.nGetBalance(this.buildGetDataConfig(start, length), false);
        List<List<String>> data = this.buildGLRptRowSet(nGetBalance);
        return data;
    }

    protected List<List<String>> buildGLRptRowSet(String nGetBalance) throws IOException {
        if (nGetBalance == null || "".equals(nGetBalance)) {
            return null;
        }
        if (Boolean.valueOf((String)this.queryConfig.get("isCompress")).booleanValue()) {
            nGetBalance = ZipUtils.gunzip(nGetBalance);
        }
        Map results = (Map)JSON.parseObject((String)nGetBalance, Map.class);
        List rows = (List)results.get("rows");
        return rows;
    }

    protected String buildGetDataConfig(int start, int length) {
        HashMap<String, Object> queryConfig = new HashMap<String, Object>();
        queryConfig.put("rptType", "getPage");
        queryConfig.put("pageName", this.queryId);
        queryConfig.put("startIndex", String.valueOf(start + 1));
        queryConfig.put("pageSize", String.valueOf(length));
        queryConfig.put("isCompress", this.queryConfig.get("isCompress"));
        return JSON.toJSONString(queryConfig);
    }

    protected void afterFillDataToTable(int start, int length) {
    }

    @Override
    public void query(Map<String, Object> queryConfig) {
        this.query(queryConfig, true);
    }

    public void query(Map<String, Object> queryConfig, boolean isReParseTable) {
        this.closeQuery();
        this.firstLoadData = true;
        if (isReParseTable) {
            this.checkParsed();
            this.removeColumns();
        }
        this.isReParseTable = isReParseTable;
        this.queryConfig = queryConfig;
        this.removeRows();
    }

    @Override
    public void closeQuery() {
        if (this.queryId != null) {
            try {
                this.iWsVoucher.nGetBalance(this.buildReleaseConfig(), false);
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.owner.handleError(e);
            }
        }
    }

    protected String buildReleaseConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("rptType", "release");
        config.put("pageName", this.queryId);
        return JSON.toJSONString(config);
    }

    @Override
    public String getQueryId() {
        return this.queryId;
    }

    protected List<List<String>> buildGLNRptQueryResult(String nGetBalance) throws Exception {
        List rows;
        List errs;
        Map results;
        List sqls;
        if (nGetBalance == null || "".equals(nGetBalance)) {
            return null;
        }
        if (Boolean.valueOf((String)this.queryConfig.get("isCompress")).booleanValue()) {
            nGetBalance = ZipUtils.gunzip(nGetBalance);
        }
        if ("true".equals(this.queryConfig.get("showRequest"))) {
            this.owner.info("result\uff1a" + (nGetBalance.length() > 100000 ? nGetBalance.substring(0, 100000) : nGetBalance));
        }
        if ((sqls = (List)(results = (Map)JSON.parseObject((String)nGetBalance, Map.class)).get("sqls")) != null) {
            for (Object sql : sqls) {
                this.owner.info(sql.toString());
            }
        }
        if ((errs = (List)results.get("errs")) != null && errs.size() > 0) {
            for (Object msg : errs) {
                this.owner.error(msg.toString());
            }
            this.owner.showConsole();
        }
        if (results.containsKey("pageName")) {
            this.queryId = (String)results.get("pageName");
        }
        if (results.containsKey("rowCount")) {
            this.rowCount = Integer.parseInt((String)results.get("rowCount"));
        }
        if (results.containsKey("companyTopLevel")) {
            this.companyTopLevel = results.get("companyTopLevel") instanceof Integer ? (Integer)results.get("companyTopLevel") : Integer.parseInt((String)results.get("companyTopLevel"));
        }
        if (results.containsKey("companys")) {
            this.companyTree = (List)results.get("companys");
        }
        if ((rows = (List)results.get("rows")).size() > 1) {
            this.colNames = (List)rows.get(0);
            this.colAliass = (List)rows.get(1);
            rows.remove(0);
            rows.remove(0);
            if (!results.containsKey("rowCount")) {
                this.rowCount = rows.size();
            }
        }
        return rows;
    }

    protected String buildQueryConfig() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.queryConfig);
        map.put("dataMode", "byPage");
        map.put("startIndex", "1");
        map.put("pageSize", String.valueOf(this.getDataRequestManager().getPageRowCount()));
        map.put("showCompanyInfo", "true");
        this.owner.setRptType(map);
        return JSON.toJSONString(map);
    }

    private void fillData(List<List<String>> data, int start) {
        try {
            if (this.isReParseTable || this.getColumnCount() == 0) {
                this.initTableColumn();
            }
            this.setRowCount(this.rowCount);
            this.fillDataToTable(data, start);
            this.afterFillDataToTable(start, start + data.size());
            if (this.handler != null) {
                this.handler.handle();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.owner.handleError(e);
        }
    }

    protected void initTableColumn() {
        this.removeColumns();
        GLNRptTableHeadInfo tableHeadInfo = this.owner.initTableColumn(this.colNames, this.colAliass);
        List<String> columnNames = tableHeadInfo.getColumnNames();
        Object asstObj = this.queryConfig.get("asstActTypes");
        int asstCols = 0;
        if (asstObj instanceof List) {
            asstCols = "true".equals(this.queryConfig.get("showBizCode")) ? 1 : ((List)asstObj).size();
        }
        for (String colName : columnNames) {
            IColumn column = this.addColumn();
            column.setKey(colName);
            column.setWidth(this.owner.getColumnWidthByColumnName(colName));
            if (colName.endsWith("For") || colName.endsWith("Local") || colName.endsWith("Rpt") || colName.endsWith("Qty") || colName.endsWith("Level")) {
                column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            } else if (colName.equals("assistGrpId") || colName.endsWith("Precision")) {
                column.getStyleAttributes().setHided(true);
            } else if (colName.startsWith("asstActId")) {
                if (colName.compareTo("asstActId" + asstCols) > 0) {
                    column.setWidth(-1);
                }
                column.getStyleAttributes().setHided(true);
            } else if (this.owner.getClass() == GLNRptAccountBalanceUI.class && colName.startsWith("asstActName") && colName.compareTo("asstActName" + this.owner.realAsstActColCount) > 0 || this.owner.getClass() == GLNRptSubLedgerUI.class && colName.startsWith("asstAct") && colName.compareTo("asstAct" + this.owner.realAsstActColCount) > 0) {
                column.setWidth(-1);
                column.getStyleAttributes().setHided(true);
            } else if ((this.owner.getClass() == GLNRptAsstActBalanceUI.class || this.owner.getClass() == GLNRptAsstactGDUI.class) && (colName.startsWith("asstActName") && colName.compareTo("asstActName" + asstCols) > 0 || colName.startsWith("asstActLongName") && colName.compareTo("asstActLongName" + asstCols) > 0 || colName.startsWith("asstActNumber") && colName.compareTo("asstActNumber" + asstCols) > 0 || colName.startsWith("asstActLongNumber") && colName.compareTo("asstActLongNumber" + asstCols) > 0)) {
                column.setWidth(-1);
                column.getStyleAttributes().setHided(true);
            }
            this.owner.setColumnStyle(column);
        }
        this.getHeadMergeManager().setMergeMode(3);
        List<List<String>> columnTitles = tableHeadInfo.getColumnTitles();
        for (int i = 0; i < columnTitles.size(); ++i) {
            IRow headRow = this.getHeadRow(i);
            if (headRow == null) {
                headRow = this.addHeadRow(i);
            }
            List<String> titles = columnTitles.get(i);
            for (int j = 0; j < titles.size(); ++j) {
                headRow.getCell(columnNames.get(j)).setValue((Object)titles.get(j));
            }
        }
        this.doLayout();
    }

    public String getResource(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }

    private final class AsynQuery
    implements Runnable {
        private int start = 0;

        public AsynQuery(int start) {
            this.start = start;
        }

        @Override
        public void run() {
            String nGetBalance = null;
            List<List<String>> data = null;
            try {
                GLNRptTable.this.owner.info(GLNRptTable.this.getResource("beginQuery"));
                long start = System.currentTimeMillis();
                String jsonParams = GLNRptTable.this.buildQueryConfig();
                if ("true".equals(GLNRptTable.this.queryConfig.get("showRequest"))) {
                    GLNRptTable.this.owner.info("params\uff1a" + jsonParams);
                }
                IObjectPK logPK = LogUtil.beginLog(null, (String)"AsynQuery", (BOSObjectType)BOSObjectType.create((String)"EXPEXCEL"), null, (String)GLNRptTable.this.owner.getUITitle(), (String)"gl_rpt_query");
                nGetBalance = GLNRptTable.this.iWsVoucher.nGetBalance(jsonParams, false);
                LogUtil.afterLog(null, (IObjectPK)logPK);
                data = GLNRptTable.this.buildGLNRptQueryResult(nGetBalance);
                GLNRptTable.this.owner.info(GLNRptTable.this.getResource("endQueryAndCost") + (System.currentTimeMillis() - start) + "ms\n");
            }
            catch (Exception e) {
                logger.error((Object)e);
                GLNRptTable.this.owner.handleError(e);
            }
            if (nGetBalance == null) {
                return;
            }
            if (GLNRptTable.this.isAsynQuery) {
                final List<List<String>> finalData = data;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GLNRptTable.this.fillData(finalData, AsynQuery.this.start);
                    }
                });
            } else {
                GLNRptTable.this.fillData(data, this.start);
            }
        }
    }
}

