/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptPrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptAccountBalancePrintDelegate
extends AbstractGLRptPrintDelegate {
    private static final Logger logger = Logger.getLogger(GLRptAccountBalancePrintDelegate.class);
    public static final String[][] col = new String[][]{{"SysDateTime", ""}, {"CurrentUser", ""}, {"AccountLevel", ""}, {"Company", ""}, {"Currency", ""}, {"Period", ""}, {"FAccountNumber", "accountNumber"}, {"FAccountName", "accountName"}, {"FCurrencyName", "currencyName"}, {"FAsstAccountGroupName", "FAsstAccountGroupName"}, {"FAsstAccountName0", "FAsstAccountName0"}, {"FAsstAccountName1", "FAsstAccountName1"}, {"FAsstAccountName2", "FAsstAccountName2"}, {"FAsstAccountName3", "FAsstAccountName3"}, {"FAsstAccountName4", "FAsstAccountName4"}, {"FAsstAccountName5", "FAsstAccountName5"}, {"FAsstAccountName6", "FAsstAccountName6"}, {"FAsstAccountName7", "FAsstAccountName7"}, {"FYearBeginQty", "FYearBeginQty"}, {"FYearBeginDebitQty", "FYearBeginDebitQty"}, {"FYearBeginDebitFor", "FYearBeginDebitBalanceFor"}, {"FYearBeginDebitLocal", "FYearBeginDebitBalanceLocal"}, {"FYearBeginDebitRpt", "FYearBeginDebitBalanceRpt"}, {"FYearBeginCreditQty", "FYearBeginCreditQty"}, {"FYearBeginCreditFor", "FYearBeginCreditBalanceFor"}, {"FYearBeginCreditLocal", "FYearBeginCreditBalanceLocal"}, {"FYearBeginCreditRpt", "FYearBeginCreditBalanceRpt"}, {"FBeginQty", "FBeginQty"}, {"FBeginDebitQty", "FBeginDebitQty"}, {"FBeginDebitFor", "FBeginDebitBalanceFor"}, {"FBeginDebitLocal", "FBeginDebitBalanceLocal"}, {"FBeginDebitRpt", "FBeginDebitBalanceRpt"}, {"FBeginCreditQty", "FBeginCreditQty"}, {"FBeginCreditFor", "FBeginCreditBalanceFor"}, {"FBeginCreditLocal", "FBeginCreditBalanceLocal"}, {"FBeginCreditRpt", "FBeginCreditBalanceRpt"}, {"FDebitQty", "FDebitQty"}, {"FDebitFor", "FDebitFor"}, {"FDebitLocal", "FDebitLocal"}, {"FDebitRpt", "FDebitRpt"}, {"FCreditQty", "FCreditQty"}, {"FCreditFor", "FCreditFor"}, {"FCreditLocal", "FCreditLocal"}, {"FCreditRpt", "FCreditRpt"}, {"FYearDebitQty", "FYearDebitQty"}, {"FYearDebitFor", "FYearDebitFor"}, {"FYearDebitLocal", "FYearDebitLocal"}, {"FYearDebitRpt", "FYearDebitRpt"}, {"FYearCreditQty", "FYearCreditQty"}, {"FYearCreditFor", "FYearCreditFor"}, {"FYearCreditLocal", "FYearCreditLocal"}, {"FYearCreditRpt", "FYearCreditRpt"}, {"FEndQty", "FEndQty"}, {"FEndDebitQty", "FEndDebitQty"}, {"FEndDebitFor", "FEndDebitBalanceFor"}, {"FEndDebitLocal", "FEndDebitBalanceLocal"}, {"FEndDebitRpt", "FEndDebitBalanceRpt"}, {"FEndCreditQty", "FEndCreditQty"}, {"FEndCreditFor", "FEndCreditBalanceFor"}, {"FEndCreditLocal", "FEndCreditBalanceLocal"}, {"FEndCreditRpt", "FEndCreditBalanceRpt"}};
    protected GLRptRowSet rs;
    protected Map baseInfo;
    private CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
    protected GLRptBasePrintConfig config;

    public GLRptAccountBalancePrintDelegate(GLRptRowSet rs, Map baseInfo, GLRptBasePrintConfig config) {
        this.rs = rs;
        this.baseInfo = baseInfo;
        if (baseInfo.get("mapCompany") != null && baseInfo.get("mapCompany") instanceof CompanyOrgUnitInfo) {
            this.curCompany = (CompanyOrgUnitInfo)baseInfo.get("mapCompany");
        }
        this.config = config;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount) {
        DateFormat format = GlUtils.getDateFormat();
        HashMap hmParamValue = new HashMap();
        try {
            hmParamValue = this.getInitParam(this.curCompany);
        }
        catch (EASBizException e1) {
            logger.error((Object)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        boolean isImp = false;
        isImp = hmParamValue.get("GL_059") == null ? true : Boolean.valueOf(hmParamValue.get("GL_059").toString());
        int qtyScale = 2;
        if (hmParamValue.get("GL_002") != null) {
            qtyScale = Integer.parseInt(hmParamValue.get("GL_002").toString());
        }
        boolean showQty = (Boolean)this.baseInfo.get("showQty");
        DynamicRowSet drs = null;
        try {
            CurrencyInfo baseCurrency = this.curCompany.getBaseCurrency();
            baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            CurrencyInfo rptCurrency = this.curCompany.getReportCurrency();
            if (rptCurrency != null) {
                rptCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(rptCurrency.getId()));
            }
            String currencyId = (String)this.baseInfo.get("currencyId");
            CurrencyInfo currency = null;
            if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                currency = baseCurrency;
            } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                currency = rptCurrency;
            } else if (!currencyId.equalsIgnoreCase("AllCurrency")) {
                currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            }
            boolean isBaseCurrency = currency != null && baseCurrency.getId().equals((Object)currency.getId());
            boolean isGBaseCy = currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC");
            boolean isGRptCy = currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC");
            int colCount = col.length;
            drs = this.createDynamicRowSet(colCount);
            this.rs.beforeFirst();
            while (this.rs.next()) {
                drs.moveToInsertRow();
                GLRptAccountBalancePrintDelegate.clearRow((IRowSet)drs);
                drs.updateString("SysDateTime", GlUtils.formatDate(format, new Date()));
                if (SysContext.getSysContext().getCurrentUserInfo().getName() != null) {
                    drs.updateString("CurrentUser", SysContext.getSysContext().getCurrentUserInfo().getName());
                } else {
                    drs.updateString("CurrentUser", SysContext.getSysContext().getCurrentUserInfo().toString());
                }
                drs.updateString("AccountLevel", this.baseInfo.get("mapAccountLevel").toString());
                drs.updateString("Company", this.curCompany.getName());
                drs.updateString("Currency", this.baseInfo.get("mapCurrency").toString());
                drs.updateString("Period", this.baseInfo.get("mapPeriod").toString());
                int precision = 0;
                if (currency == null) {
                    Object currencyPre = this.rs.getObject("currencyPre");
                    if (currencyPre != null) {
                        precision = Integer.parseInt(currencyPre.toString());
                    }
                } else {
                    precision = currency.getPrecision();
                }
                for (int i = 6; i < col.length; ++i) {
                    if (this.rs.indexOf(col[i][1]) == -1 || "FYearBeginQty".equals(col[i][1]) || "FBeginQty".equals(col[i][1]) || "FEndQty".equals(col[i][1])) continue;
                    Object objValue = this.rs.getObject(col[i][1]);
                    if (objValue != null) {
                        if (objValue.getClass() != BigDecimal.class) {
                            if (col[i][1].startsWith("FAsstAccountName")) {
                                String[] a;
                                if (!isImp && (a = objValue.toString().trim().split("\\:")).length > 1) {
                                    StringBuffer sbE = new StringBuffer();
                                    int r = a.length - 1;
                                    for (int k = 0; k <= r; ++k) {
                                        if (k == 0) continue;
                                        sbE.append(a[k]).append(":");
                                    }
                                    sbE.deleteCharAt(sbE.length() - 1);
                                    objValue = sbE.toString();
                                }
                                drs.updateString(col[i][0], objValue.toString());
                                String names = drs.getString("FAsstAccountGroupName");
                                if (names == null) {
                                    drs.updateString("FAsstAccountGroupName", objValue.toString());
                                    continue;
                                }
                                names = names + "; " + objValue.toString();
                                drs.updateString("FAsstAccountGroupName", names);
                                continue;
                            }
                            drs.updateString(col[i][0], objValue.toString());
                            continue;
                        }
                        if (((BigDecimal)objValue).compareTo(new BigDecimal("0")) == 0) {
                            drs.updateString(col[i][0], "");
                            continue;
                        }
                        BigDecimal value = (BigDecimal)objValue;
                        if (col[i][0].toLowerCase().endsWith("local")) {
                            drs.updateString(col[i][0], GlUtils.withComma(value, baseCurrency.getPrecision()));
                            if (!isGBaseCy) continue;
                            drs.updateString(col[i][0].substring(0, col[i][0].length() - 5) + "for", GlUtils.withComma((BigDecimal)objValue, baseCurrency.getPrecision()));
                            continue;
                        }
                        if (rptCurrency != null && col[i][0].toLowerCase().endsWith("rpt")) {
                            drs.updateString(col[i][0], GlUtils.withComma(value, rptCurrency.getPrecision()));
                            if (!isGRptCy) continue;
                            drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "for", GlUtils.withComma(value, rptCurrency.getPrecision()));
                            continue;
                        }
                        if (col[i][0].toLowerCase().endsWith("for")) {
                            drs.updateString(col[i][0], GlUtils.withComma(value, precision));
                            if (!isBaseCurrency) continue;
                            drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "local", GlUtils.withComma(value, precision));
                            continue;
                        }
                        if (col[i][1].endsWith("Qty")) {
                            drs.updateString(col[i][0], GlUtils.withComma(value, qtyScale));
                            continue;
                        }
                        drs.updateString(col[i][0], value.toString());
                        continue;
                    }
                    drs.updateString(col[i][0], "");
                }
                if (showQty) {
                    BigDecimal yearBeginQty = this.getBigDecimal(this.rs, "FYearBeginDebitQty").subtract(this.getBigDecimal(this.rs, "FYearBeginCreditQty"));
                    drs.updateString("FYearBeginQty", yearBeginQty.doubleValue() == 0.0 ? "" : GlUtils.withComma(yearBeginQty, qtyScale));
                    BigDecimal beginQty = this.getBigDecimal(this.rs, "FBeginDebitQty").subtract(this.getBigDecimal(this.rs, "FBeginCreditQty"));
                    drs.updateString("FBeginQty", beginQty.doubleValue() == 0.0 ? "" : GlUtils.withComma(beginQty, qtyScale));
                    BigDecimal endQty = this.getBigDecimal(this.rs, "FEndDebitQty").subtract(this.getBigDecimal(this.rs, "FEndCreditQty"));
                    drs.updateString("FEndQty", endQty.doubleValue() == 0.0 ? "" : GlUtils.withComma(endQty, qtyScale));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return drs;
    }

    private BigDecimal getBigDecimal(GLRptRowSet rs, String field) throws BOSException {
        BigDecimal amount = rs.getBigDecimal(field);
        if (amount == null) {
            return GlUtils.zero;
        }
        return amount;
    }

    private DynamicRowSet createDynamicRowSet(int colCount) throws SQLException {
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 0; i < colCount; ++i) {
            ColInfo ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = col[i][0];
            ci.nullable = 1;
            drs.setColInfo(i + 1, ci);
        }
        drs.beforeFirst();
        return drs;
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private HashMap getInitParam(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)String.valueOf(company.getId())));
        HashMap<String, ObjectUuidPK> sysParams = new HashMap<String, ObjectUuidPK>();
        sysParams.put("GL_059", comPK);
        sysParams.put("GL_002", comPK);
        return ParamControlFactory.getRemoteInstance().getParamHashMap(sysParams);
    }
}

