/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionBalanceListAssist;
import com.kingdee.eas.fi.gl.client.ReportBalanceListAssistUI;
import com.kingdee.eas.fi.gl.client.VoucherUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.PrintButtonEnum;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptAccountBalanceUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAccountBalancePrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAccountBalancePrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAccountBalanceQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptCommonItemInfo;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptTable;
import com.kingdee.eas.fi.gl.rpt.client.GLRptTableHelper;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.fi.gl.rpt.client.InnerSumTable;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.config.IObjectMultiPKBuilder;
import com.kingdee.eas.framework.report.RptException;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class GLRptAccountBalanceUI
extends AbstractGLRptAccountBalanceUI {
    private static final long serialVersionUID = 4133082108782368996L;
    private static final Logger logger = CoreUIObject.getLogger(GLRptAccountBalanceUI.class);
    private static final String BN_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"BNSum");
    private static final String BW_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"BWSum");
    private static final String ACCOUNT_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"total");
    private static final String CURRENCY_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"subtotal");
    private static final String[] NEED_FILL_COL_NAMES = new String[]{"accountNumber", "accountName", "currencyName", "companyName"};
    private boolean needFillInfo = false;

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubsidiaryLedger.setIcon(EASResource.getIcon((String)"imgTbtn_listaccount"));
        this.btnAssitAct.setIcon(EASResource.getIcon((String)"imgTbtn_assistantgeneralledger"));
        this.menuItemSubsidiaryLedger.setIcon(EASResource.getIcon((String)"imgTbtn_listaccount"));
        this.menuItemAssistAct.setIcon(EASResource.getIcon((String)"imgTbtn_assistantlistaccount"));
        boolean isEnable = this.getCurrCompany().isIsBizUnit();
        this.actionMenuItemPrintParame.setEnabled(isEnable);
        this.actionMenuItemPrintParame.setVisible(isEnable);
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.getTable().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    if (GLRptAccountBalanceUI.this.innerSumTable != null) {
                        GLRptAccountBalanceUI.this.innerSumTable.setVisible(false);
                    }
                    if (e.getSelectBlock() != null) {
                        if (GLRptAccountBalanceUI.this.innerSumTable != null && (GLRptAccountBalanceUI.this.getTable().getSelectManager().size() > 1 || e.getSelectBlock().getEndRow() - e.getSelectBlock().getBeginRow() > 0)) {
                            GLRptAccountBalanceUI.this.innerSumTable.selectRowSum(GLRptAccountBalanceUI.this.getTable().getSelectManager().getBlocks(), GLRptAccountBalanceUI.this.getQueryCond() != null && GLRptAccountBalanceUI.this.getQueryCond().isAllCurrency());
                        } else {
                            int rowIndex = e.getSelectBlock().getTop();
                            GLRptAccountBalanceUI.this.tblMain_SelectChanged(rowIndex);
                        }
                    }
                }
                catch (Exception ex) {
                    GLRptAccountBalanceUI.this.handleException(ex);
                }
            }
        });
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        GLRptAccountBalanceUI.this.doTableDoubleClick(e.getRowIndex());
                    }
                }
                catch (Exception ex) {
                    GLRptAccountBalanceUI.this.handUIException(ex);
                }
            }
        });
    }

    @Override
    protected void setQueryDialogSize(CommonQueryDialog dialog) {
        dialog.setWidth(500);
        dialog.setHeight(510);
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        List<Object[]> needRecoverCells = this.fillCellBeforeExportExcel(this.needFillInfo);
        try {
            IObjectPK pk = this.hasExportExcelPermission();
            if (pk != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(pk, sic);
                PermItemInfo permItemInfo = PermItemFactory.getRemoteInstance().getPermItemInfoByNumber(this.getExportPermissionItem());
                throw new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION_2, new Object[]{SysContext.getSysContext().getCurrentUserInfo().getNumber(), company.getName(), permItemInfo.getAlias()});
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
            return;
        }
        super.actionExport_actionPerformed(e);
        this.recoverTable(needRecoverCells);
    }

    private void recoverTable(List<Object[]> needRecoverCells) {
        if (needRecoverCells.size() == 0) {
            return;
        }
        GLRptTable tblMain = this.getTable();
        for (Object[] needRecoverCell : needRecoverCells) {
            ICell cell = tblMain.getCell((Integer)needRecoverCell[0], NEED_FILL_COL_NAMES[(Integer)needRecoverCell[1]]);
            if (cell == null) continue;
            cell.setValue(needRecoverCell[2]);
        }
    }

    private List<Object[]> fillCellBeforeExportExcel(boolean needFillInfo) {
        GLRptTable tblMain = this.getTable();
        Object[] preValue = new Object[NEED_FILL_COL_NAMES.length];
        LinkedList<Object[]> needRecoverCell = new LinkedList<Object[]>();
        if (!needFillInfo) {
            return needRecoverCell;
        }
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            String accountNameValue;
            IRow row = tblMain.getRow(i);
            if (null == row || null != (accountNameValue = (String)row.getCell("accountName").getValue()) && (accountNameValue.contains(ACCOUNT_TOTAL) || accountNameValue.contains(BN_TOTAL) || accountNameValue.contains(BW_TOTAL) || accountNameValue.contains(CURRENCY_TOTAL))) continue;
            for (int j = 0; j < NEED_FILL_COL_NAMES.length; ++j) {
                String columnName = NEED_FILL_COL_NAMES[j];
                if (row.getCell(columnName) == null) continue;
                preValue[j] = row.getCell(columnName).getValue();
                if (null != preValue[j] && !StringUtils.isEmpty((String)preValue[j].toString())) continue;
                row.getCell(columnName).setValue(tblMain.getRow(i - 1).getCell(columnName).getValue());
                needRecoverCell.add(new Object[]{i, j, preValue[j]});
            }
        }
        return needRecoverCell;
    }

    @Override
    protected GLRptBaseQueryUI getCustQueryPanel() throws Exception {
        return new GLRptAccountBalanceQueryUI();
    }

    @Override
    protected GLRptBaseCondition createQueryCond(Map param) {
        try {
            return new GLRptAccountBalanceCondition(param);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void doGLRowSet(GLRptRowSet rs) throws EASBizException, BOSException {
        rs.beforeFirst();
        GLRptAccountBalanceCondition cond = (GLRptAccountBalanceCondition)this.getQueryCond();
        while (rs.next()) {
            boolean isAccountTotal;
            Object isBWSum;
            boolean isBWAccountSum = false;
            GLRptTreeNode node = null;
            if (CompanyDisplayModeEnum.enumerate != cond.getCompanyDisplayMode()) {
                node = (GLRptTreeNode)rs.getObject("companyName");
            }
            if (cond.getIncludeBWAccount() && (isBWSum = rs.getObject("FIsAccountBWSum")) != null) {
                boolean bl = isBWAccountSum = new BigDecimal(isBWSum.toString()).intValue() == 1;
            }
            if (node != null && CompanyDisplayModeEnum.merger == cond.getCompanyDisplayMode()) {
                SimpleCompanyUserObject obj = (SimpleCompanyUserObject)node.getUserObject();
                if (!node.isLeaf()) {
                    obj.setName(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"367_RptAsstactGGUI"));
                }
            }
            Object isAccTotal = rs.getObject("FIsAccountTotal");
            if (rs.getObject("fpTypeNum") != null && rs.getObject("FIsAccountTypeTotal") != null && rs.getInt("FIsAccountTypeTotal") == 1) {
                rs.updateString("accountName", rs.getString("FpTypeName"));
            }
            boolean bl = isAccTotal == null ? false : (isAccountTotal = new BigDecimal(isAccTotal.toString()).intValue() == 1);
            if (isBWAccountSum) {
                boolean isBWAccount = false;
                Object isBW = rs.getObject("FBWType");
                if (isBW != null) {
                    boolean bl2 = isBWAccount = new BigDecimal(isBW.toString()).intValue() == 1;
                }
                if (CompanyDisplayModeEnum.enumerate == cond.getCompanyDisplayMode()) {
                    rs.updateString("accountName", isBWAccount ? BW_TOTAL : BN_TOTAL);
                } else if (cond.isFillInfo() || node != null && node.getLevel() == 0) {
                    rs.updateString("accountName", isBWAccount ? BW_TOTAL : BN_TOTAL);
                }
            } else if (isAccountTotal) {
                if (CompanyDisplayModeEnum.enumerate == cond.getCompanyDisplayMode()) {
                    rs.updateString("accountName", ACCOUNT_TOTAL);
                } else if (cond.isFillInfo() || node != null && node.getLevel() == 0) {
                    rs.updateString("accountName", ACCOUNT_TOTAL);
                }
            }
            if (cond.isAllCurrency()) {
                boolean isCurrencyTotal;
                boolean bl3 = isCurrencyTotal = rs.getInt("FIsCurrencyTotal") == 1;
                if (isCurrencyTotal && (cond.isFillInfo() || CompanyDisplayModeEnum.enumerate == cond.getCompanyDisplayMode() || node != null && !node.isLeaf() && node.getParentNode() == null)) {
                    rs.updateString("currencyName", CURRENCY_TOTAL);
                }
            }
            if (rs.getObject("FAsstAccountName0") == null) continue;
            rs.updateString("FAsstAccountName0", VoucherUtil.decodeSplitFlag(rs.getObject("FAsstAccountName0").toString()));
        }
    }

    @Override
    protected void afterFillTableRow(IRow row, String[] colNames) {
        Object isAccTotal;
        Object isBWSum;
        GLRptAccountBalanceCondition cond = (GLRptAccountBalanceCondition)this.getQueryCond();
        boolean isBWAccountSum = false;
        if (cond.getIncludeBWAccount() && (isBWSum = row.getCell("FIsAccountBWSum").getValue()) != null) {
            boolean bl = isBWAccountSum = new BigDecimal(row.getCell("FIsAccountBWSum").getValue().toString()).intValue() == 1;
        }
        boolean isAccountTotal = (isAccTotal = row.getCell("FIsAccountTotal").getValue()) == null ? false : new BigDecimal(isAccTotal.toString()).intValue() == 1;
        boolean isAccountTypeTotal = false;
        if (row.getCell("FIsAccountTypeTotal") != null) {
            Object fIsAccountTypeTotal = row.getCell("FIsAccountTypeTotal").getValue();
            boolean bl = fIsAccountTypeTotal == null ? false : (isAccountTypeTotal = new BigDecimal(fIsAccountTypeTotal.toString()).intValue() == 1);
        }
        if (isBWAccountSum || isAccountTypeTotal) {
            row.getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
        } else if (isAccountTotal) {
            row.getStyleAttributes().setBackground(TOTAL_COLOR);
        }
        if (cond.isAllCurrency()) {
            boolean isCurrencyTotal;
            boolean bl = isCurrencyTotal = new BigDecimal(row.getCell("FIsCurrencyTotal").getValue().toString()).intValue() == 1;
            if (isCurrencyTotal) {
                row.getStyleAttributes().setBackground(TOTAL_COLOR);
            } else {
                String key = null;
                int currencyPre = new BigDecimal(row.getCell("currencyPre").getValue().toString()).intValue();
                GLRptTable tblMain = this.getTable();
                for (int i = 0; i < tblMain.getColumnCount(); ++i) {
                    key = tblMain.getColumn(i).getKey();
                    if (key == null || !key.endsWith("For")) continue;
                    row.getCell(key).getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(currencyPre));
                }
            }
        }
    }

    @Override
    protected GLRptBaseCondition buildLinkedQuery(String uiParams) throws EASBizException, BOSException {
        PeriodEntity pe;
        String companys;
        CurrencyCollection currColl;
        FilterInfo filter;
        int level;
        String[] params = uiParams.split(";");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < params.length; ++i) {
            String[] param = params[i].split("=", 2);
            if ((param[0] == null || param[0].trim().length() <= 0) && (param[1] == null || param[1].trim().length() <= 0)) continue;
            paramMap.put(param[0].trim().toUpperCase(), param[1].trim());
        }
        GLRptAccountBalanceCondition condition = new GLRptAccountBalanceCondition();
        Object beginYearObj = paramMap.get("BEGIN_PERIOD_YEAR");
        Object beginMonthObj = paramMap.get("BEGIN_PERIOD_NUMBER");
        Object endYearObj = paramMap.get("END_PERIOD_YEAR");
        Object endMonthObj = paramMap.get("END_PERIOD_NUMBER");
        int startPeriodYear = -1;
        int startPeriodNumber = -1;
        int endPeriodYear = -1;
        int endPeriodNumber = -1;
        if (beginYearObj == null || beginMonthObj == null || endYearObj == null || endMonthObj == null) {
            PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.getCurrCompany());
            startPeriodYear = endPeriodYear = currPeriod.getPeriodYear();
            startPeriodNumber = endPeriodNumber = currPeriod.getPeriodNumber();
        } else {
            startPeriodYear = Integer.parseInt(beginYearObj.toString());
            startPeriodNumber = Integer.parseInt(beginMonthObj.toString());
            endPeriodYear = Integer.parseInt(endYearObj.toString());
            endPeriodNumber = Integer.parseInt(endMonthObj.toString());
        }
        String startAccountNumber = (String)paramMap.get("BEGIN_ACCOUNT_NUMBER");
        String endAccountNumber = (String)paramMap.get("END_ACCOUNT_NUMBER");
        boolean isIncludeNotPosted = false;
        Object isIncludeNotPostedObj = paramMap.get("IS_INCLUDE_UNPOST_VOUCHER");
        if (isIncludeNotPostedObj != null) {
            isIncludeNotPosted = Boolean.valueOf((String)isIncludeNotPostedObj);
        }
        boolean isShowAsstDetail = false;
        Object isShowAsstActObj = paramMap.get("IS_SHOW_ASSTACT");
        if (isShowAsstActObj != null) {
            isShowAsstDetail = Boolean.valueOf((String)isShowAsstActObj);
        }
        boolean isShowQty = false;
        Object isShowQtyObj = paramMap.get("IS_SHOW_QTY");
        if (isShowQtyObj != null) {
            isShowQty = Boolean.valueOf((String)isShowQtyObj);
        }
        boolean isAmountZero = false;
        Object isAmountZeroObj = paramMap.get("IS_SHOW_ZERO_AMOUNT");
        if (isAmountZeroObj != null) {
            isAmountZero = Boolean.valueOf((String)isAmountZeroObj);
        }
        int accountLevel = 1;
        if (startAccountNumber != null) {
            accountLevel = startAccountNumber.split("\\.").length;
        }
        if (endAccountNumber != null && (level = endAccountNumber.split("\\.").length) > accountLevel) {
            accountLevel = level;
        }
        String currencyId = null;
        String currencyNumber = (String)paramMap.get("CURRENCY_NUMBER");
        String currencyName = (String)paramMap.get("CURRENCY_NAME");
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        if (currencyNumber != null) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber));
            evi.setFilter(filter);
            currColl = CurrencyFactory.getRemoteInstance().getCurrencyCollection(evi);
            if (currColl.size() > 0) {
                currencyId = currColl.get(0).getId().toString();
                currencyName = currColl.get(0).getName();
            }
        } else if (currencyName != null) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)currencyName));
            evi.setFilter(filter);
            currColl = CurrencyFactory.getRemoteInstance().getCurrencyCollection(evi);
            if (currColl.size() > 0) {
                currencyId = currColl.get(0).getId().toString();
                currencyNumber = currColl.get(0).getNumber();
            }
        }
        if (currencyId == null) {
            currencyId = this.getCurrCompany().getBaseCurrency().getId().toString();
            currencyNumber = this.getCurrCompany().getBaseCurrency().getNumber();
            currencyName = this.getCurrCompany().getBaseCurrency().getName();
            if (currencyName == null) {
                currencyName = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId)).getName();
            }
        }
        if (!this.getCurrCompany().isIsBizUnit() && (companys = (String)paramMap.get("COMPANYS")) != null) {
            evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("number"));
            evi.getSelector().add(new SelectorItemInfo("name"));
            evi.getSelector().add(new SelectorItemInfo("longNumber"));
            evi.getSelector().add(new SelectorItemInfo("isBizUnit"));
            evi.getSelector().add(new SelectorItemInfo("level"));
            evi.getSorter().add(new SorterItemInfo("longNumber"));
            FilterInfo filter2 = new FilterInfo();
            HashSet<String> companyNumberSet = new HashSet<String>();
            String[] companyNumbers = companys.split("\\|");
            for (int i = 0; i < companyNumbers.length; ++i) {
                if (companyNumbers[i] == null || companyNumbers[i].trim().length() <= 0) continue;
                companyNumberSet.add(companyNumbers[i]);
            }
            if (companyNumberSet.size() == 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"97_ReportBalanceListUI"));
                SysUtil.abort();
            }
            filter2.getFilterItems().add(new FilterItemInfo("number", companyNumberSet, CompareType.INCLUDE));
            evi.setFilter(filter2);
            CompanyOrgUnitCollection orgColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
            StringBuffer companyIds = new StringBuffer();
            for (int i = 0; i < orgColl.size(); ++i) {
                if (i > 0) {
                    companyIds.append(",");
                }
                companyIds.append("'");
                companyIds.append(orgColl.get(i).getId().toString());
                companyIds.append("'");
            }
            this.getCurrCompany().setDescription(companyIds.toString());
        }
        condition.setPeriodYearStart(startPeriodYear);
        condition.setPeriodNumberStart(startPeriodNumber);
        condition.setPeriodYearEnd(endPeriodYear);
        condition.setPeriodNumberEnd(endPeriodNumber);
        condition.setAccountCodeStart(startAccountNumber);
        condition.setAccountCodeEnd(endAccountNumber);
        condition.setAccountLevelStart(1);
        condition.setAccountLevelEnd(accountLevel);
        condition.setCurrencyID(currencyId);
        condition.setCurrencyName(currencyName);
        condition.setDisplayAsstDetail(isShowAsstDetail);
        condition.setOptionPosting(isIncludeNotPosted);
        condition.setShowQty(isShowQty);
        condition.setOptionAmountZero(isAmountZero);
        if (this.getCurrCompany().isIsBizUnit()) {
            pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.getCurrCompany());
            condition.getExpandInfo().put("periodEntity", pe);
            condition.getExpandInfo().put("isAfterPeriodIncluded", endPeriodYear > pe.getCurrentYear() || endPeriodYear == pe.getCurrentYear() && endPeriodNumber > pe.getCurrentPeriod());
        } else {
            pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.getCurrCompany());
            condition.getExpandInfo().put("periodEntity", pe);
        }
        condition.getExpandInfo().put("company", this.getCurrCompany());
        return condition;
    }

    protected void tblMain_SelectChanged(int rowIndex) throws EASBizException, BOSException {
        this.setActionStatus(rowIndex);
    }

    protected void setActionStatus(int rowIndex) throws EASBizException, BOSException {
        IRow row;
        this.actionAssistAccount.setEnabled(false);
        this.actionSubsidiaryLedger.setEnabled(false);
        GLRptAccountBalanceCondition condition = (GLRptAccountBalanceCondition)this.getQueryCond();
        if (condition != null && (row = this.getTable().getRow(rowIndex)) != null) {
            String strAccountId = (String)row.getCell("FAccountID").getValue();
            if (strAccountId == null || strAccountId.trim().length() == 0) {
                return;
            }
            SelectorItemCollection accountSel = new SelectorItemCollection();
            accountSel.add(new SelectorItemInfo("id"));
            accountSel.add(new SelectorItemInfo("isLeaf"));
            accountSel.add(new SelectorItemInfo("CAA.id"));
            AccountViewInfo av = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(strAccountId), accountSel);
            if (CompanyDisplayModeEnum.enumerate == condition.getCompanyDisplayMode()) {
                if (av != null) {
                    if (av.getId() != null) {
                        this.actionSubsidiaryLedger.setEnabled(true);
                    }
                    if (this.canJoinQueryForPeriodLimit()) {
                        int startPeriod = condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart();
                        int endPeriod = condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd();
                        Set caas = AccountFacadeFactory.getRemoteInstance().getCAAIdsByPeriodRange(av.getId().toString(), startPeriod, endPeriod);
                        if (caas.size() > 0) {
                            this.actionAssistAccount.setEnabled(true);
                        }
                    }
                }
            } else {
                GLRptTreeNode treeNode = (GLRptTreeNode)this.getTable().getCell(rowIndex, "companyName").getValue();
                SimpleCompanyUserObject company = null;
                if (treeNode != null) {
                    company = (SimpleCompanyUserObject)treeNode.getUserObject();
                }
                if (company != null) {
                    SelectorItemCollection companySel = new SelectorItemCollection();
                    companySel.add(new SelectorItemInfo("id"));
                    companySel.add(new SelectorItemInfo("isBizUnit"));
                    CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getCompanyId()), companySel);
                    if (companyInfo.isIsBizUnit()) {
                        HashMap<String, String> ctx = new HashMap<String, String>();
                        ctx.put("companyId", company.getCompanyId());
                        ctx.put("accountTableId", condition.getAccountTableId());
                        ctx.put("accountPeriodTypeId", condition.getPeriodTypeId());
                        this.fetchCompany(ctx);
                        if (av != null) {
                            this.actionSubsidiaryLedger.setEnabled(true);
                            if (this.canJoinQueryForPeriodLimit()) {
                                int startPeriod = condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart();
                                int endPeriod = condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd();
                                Set caas = AccountFacadeFactory.getRemoteInstance().getCAAIdsByPeriodRange(av.getId().toString(), startPeriod, endPeriod);
                                if (caas.size() > 0) {
                                    this.actionAssistAccount.setEnabled(true);
                                }
                            }
                        }
                    } else {
                        this.actionSubsidiaryLedger.setEnabled(true);
                    }
                }
            }
        }
    }

    @Override
    protected GLRptBaseCondition getSysDefaultQueryCond() throws EASBizException, BOSException {
        if (!this.getCurrCompany().isIsBizUnit()) {
            return null;
        }
        GLRptBaseCondition cond = this.createQueryCond(new HashMap());
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.getCurrCompany().getId()), GlUtils.getCompanySic());
        cond.setCurrencyID(company.getBaseCurrency().getId().toString());
        cond.setPeriodTypeId(company.getAccountPeriodType().getId().toString());
        cond.switchCompany(company);
        cond.setCompanyId(company.getId().toString());
        cond.setCurrencyName(company.getBaseCurrency().getName());
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (currPeriod == null) {
            throw new RptException(RptException.PERIOD_ERROR);
        }
        cond.setPeriodYearStart(currPeriod.getPeriodYear());
        cond.setPeriodNumberStart(currPeriod.getPeriodNumber());
        cond.setPeriodYearEnd(currPeriod.getPeriodYear());
        cond.setPeriodNumberEnd(currPeriod.getPeriodNumber());
        String accountTableId = GlUtils.getAccountTableInfo(company, currPeriod.getPeriodYear(), currPeriod.getPeriodNumber()).getId().toString();
        cond.setAccountTableId(accountTableId);
        cond.setAccountLevelEnd(1);
        return cond;
    }

    private boolean canJoinQueryForPeriodLimit() {
        GLRptAccountBalanceCondition condition = (GLRptAccountBalanceCondition)this.getQueryCond();
        PeriodEntity pe = (PeriodEntity)condition.getExpandInfo().get("periodEntity");
        if (pe == null) {
            return true;
        }
        return condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd() <= pe.getCurrentYear() * 100 + pe.getCurrentPeriod();
    }

    protected void doTableDoubleClick(int rowIndex) {
        if (this.actionSubsidiaryLedger.isEnabled()) {
            try {
                this.setCursorOfWair();
                this.findSubsidiaryLedger();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        } else {
            return;
        }
    }

    @Override
    public void actionSubsidiaryLedger_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.findSubsidiaryLedger();
    }

    @Override
    public void actionAssistAccount_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.findAssistAccountBalance();
    }

    public void checkSelected() {
        if (this.getTable().getRowCount() == 0 || this.getTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private void findSubsidiaryLedger() throws Exception {
        KDTSelectBlock sb = this.getTable().getSelectManager().get();
        if (sb == null || this.getQueryCond() == null) {
            return;
        }
        GLRptSubLedgerCondition cond = new GLRptSubLedgerCondition(this.getQueryCond());
        cond.setCompanyDisplayMode(CompanyDisplayModeEnum.enumerate);
        this.joinQury(cond, GLRptSubLedgerUI.class.getName());
    }

    private void findAssistAccountBalance() throws Exception {
        KDTSelectBlock sb = this.getTable().getSelectManager().get();
        if (sb != null && this.getQueryCond() != null) {
            CompanyOrgUnitInfo linkCompany;
            String cyId;
            int top = sb.getTop();
            IRow row = this.getTable().getRow(top);
            String strAccountId = (String)row.getCell("FAccountID").getValue();
            if (strAccountId == null || strAccountId.trim().length() == 0) {
                return;
            }
            ICell companyCell = this.getTable().getCell(top, "FOrgUnitID");
            String companyId = companyCell == null ? null : (String)companyCell.getValue();
            AccountViewInfo acc = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(strAccountId));
            String strAssisthgId = null;
            if (row.getCell("FAssistGrpId") != null) {
                strAssisthgId = (String)row.getCell("FAssistGrpId").getValue();
            }
            GLRptAccountBalanceCondition cond = (GLRptAccountBalanceCondition)this.getQueryCond();
            CurrencyInfo currency = null;
            if (cond.isAllCurrency() && (cyId = (String)row.getCell("FCurrencyID").getValue()) != null && cyId.trim().length() > 0) {
                currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(cyId));
            }
            if (cond.isNotIncluePLVoucher() && acc.getPLType() != AccountPLType.NONE && !MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"98_ReportBalanceListUI")))) {
                SysUtil.abort();
            }
            EntityViewInfo evi = new EntityViewInfo();
            ReportConditionBalanceListAssist assistBalanceCondition = new ReportConditionBalanceListAssist(cond);
            assistBalanceCondition.setOptionShowQty(cond.isShowQty());
            if (currency != null) {
                assistBalanceCondition.setCurrencyID(currency.getId().toString());
                assistBalanceCondition.setCurrencyName(currency.getName());
            }
            evi.put("GLFixCondition", (Object)assistBalanceCondition);
            if (strAssisthgId != null && strAssisthgId.trim().length() > 0) {
                evi.put("asstHGId", (Object)strAssisthgId);
                assistBalanceCondition.setAssistItemId(strAssisthgId);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("asstAccount.id");
                AssistantHGInfo hg = AssistantHGFactory.getRemoteInstance().getAssistantHGInfo((IObjectPK)new ObjectUuidPK(strAssisthgId), selector);
                if (hg.getAsstAccount() != null) {
                    assistBalanceCondition.setAsstAccountId(hg.getAsstAccount().getId().toString());
                }
            }
            assistBalanceCondition.setAccountIdSet(null);
            if (!acc.isIsLeaf()) {
                boolean hasDistAccounts;
                boolean bl = hasDistAccounts = !cond.getAccountIdSet().isEmpty();
                if (!StringUtils.isEmpty((String)cond.getAccountCodeStart()) || !StringUtils.isEmpty((String)cond.getAccountCodeEnd()) || hasDistAccounts) {
                    EntityViewInfo view = new EntityViewInfo();
                    SelectorItemCollection sic = view.getSelector();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("level"));
                    FilterInfo filter = new FilterInfo();
                    if (!StringUtils.isEmpty((String)cond.getAccountCodeStart())) {
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)cond.getAccountCodeStart(), CompareType.GREATER_EQUALS));
                    }
                    if (!StringUtils.isEmpty((String)cond.getAccountCodeEnd())) {
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)(cond.getAccountCodeEnd() + "zz"), CompareType.LESS));
                    }
                    filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1));
                    filter.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
                    if (StringUtils.isEmpty((String)companyId)) {
                        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)cond.getCompanyIds(), CompareType.INCLUDE));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
                    }
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)acc.getNumber(), CompareType.GREATER_EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)(acc.getNumber() + "zz"), CompareType.LESS));
                    if (hasDistAccounts) {
                        filter.getFilterItems().add(new FilterItemInfo("id", cond.getAccountIdSet(), CompareType.INCLUDE));
                    }
                    filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)cond.getAccountTableId()));
                    view.setFilter(filter);
                    AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
                    if (!coll.isEmpty()) {
                        HashSet<String> accountIdSet = new HashSet<String>();
                        for (int j = 0; j < coll.size(); ++j) {
                            AccountViewInfo info = coll.get(j);
                            accountIdSet.add(info.getId().toString());
                        }
                        assistBalanceCondition.setAccountIdSet(accountIdSet);
                    }
                }
            }
            if (CompanyDisplayModeEnum.enumerate == cond.getCompanyDisplayMode()) {
                assistBalanceCondition.setAccountId(strAccountId);
                linkCompany = cond.getCompany();
            } else {
                companyId = this.getSelectCompanyId();
                assistBalanceCondition.setCompanyId(companyId);
                HashMap<String, String> ctx = new HashMap<String, String>();
                ctx.put("companyId", companyId);
                ctx.put("accountTableId", cond.getAccountTableId());
                ctx.put("accountPeriodTypeId", cond.getPeriodTypeId());
                ctx.put("asstHGId", strAssisthgId);
                this.fetchCompany(ctx);
                linkCompany = (CompanyOrgUnitInfo)ctx.get("company");
                AccountViewInfo linkAV = this.findAccountViewInfoByNumber(acc.getNumber(), companyId, cond.getAccountTableId());
                if (linkAV != null) {
                    assistBalanceCondition.setAccountId(linkAV.getId().toString());
                }
            }
            ReportBalanceListAssistUI.queryByCondition(evi, (Object)this, linkCompany);
        }
    }

    private AccountViewInfo findAccountViewInfoByNumber(String strNumber, String companyId, String accountTableId) throws BOSException {
        if (StringUtil.isEmptyString((String)strNumber)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("CAA"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strNumber.trim()));
        fic.add(new FilterItemInfo("companyID.id", (Object)companyId));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        filter.setMaskString("#0 and #1 and #2 ");
        AccountViewInfo accountViewInfo = null;
        IAccountView accountView = AccountViewFactory.getRemoteInstance();
        AccountViewCollection accountViewCollection = accountView.getAccountViewCollection(view);
        if (accountViewCollection != null && accountViewCollection.size() != 0) {
            accountViewInfo = accountViewCollection.get(0);
        }
        return accountViewInfo;
    }

    private void fetchCompany(Map uiContext) throws BOSException, EASBizException {
        String companyId = (String)uiContext.get("companyId");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)uiContext.get("company");
        BOSUuid preAccountTableId = null;
        if (company != null && company.getAccountTable() != null) {
            preAccountTableId = company.getAccountTable().getId();
        }
        if (companyId == null) {
            companyId = company == null ? SysContext.getSysContext().getCurrentFIUnit().getId().toString() : company.getId().toString();
        }
        company = this.getCompanyById(companyId);
        if (preAccountTableId != null) {
            company.getAccountTable().setId(preAccountTableId);
        }
        String accountTableId = (String)uiContext.get("accountTableId");
        String accountPeriodTypeId = (String)uiContext.get("accountPeriodTypeId");
        if (accountTableId != null && company.getAccountTable() != null) {
            company.getAccountTable().setId(BOSUuid.read((String)accountTableId));
        }
        if (accountPeriodTypeId != null) {
            company.getAccountPeriodType().setId(BOSUuid.read((String)accountPeriodTypeId));
        }
        uiContext.put("companyId", companyId);
        uiContext.put("company", company);
    }

    private CompanyOrgUnitInfo getCompanyById(String companyId) throws BOSException, EASBizException {
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(companyId);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        return companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
    }

    @Override
    protected String getPrintConfigUIName() {
        return "com.kingdee.eas.fi.gl.rpt.client.GLRptAccountBalancePrintConfigUI";
    }

    @Override
    public Object getTablePreferenceSchemaKey() {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        GLRptAccountBalanceCondition cond = (GLRptAccountBalanceCondition)this.getQueryCond();
        String currencyId = cond.getCurrencyID();
        String showQty = String.valueOf(cond.isShowQty());
        String showAsstact = String.valueOf(cond.getDisplayAsstDetail());
        return userId + "||" + companyId + "||" + currencyId + "||" + showQty + "||" + showAsstact;
    }

    @Override
    protected BOSQueryDelegate getPrintQueryDelegate(GLRptRowSet rs, GLRptBaseCondition cond, GLRptBasePrintConfig config) throws EASBizException, BOSException {
        return new GLRptAccountBalancePrintDelegate(rs, this.getPrintVar(cond), config);
    }

    protected Map getPrintVar(GLRptBaseCondition cond) {
        HashMap<String, Object> printParams = new HashMap<String, Object>();
        printParams.put("mapAccountLevel", Integer.toString(cond.getAccountLevelEnd()));
        printParams.put("mapCompany", cond.getCompany());
        printParams.put("currencyId", cond.getCurrencyID());
        printParams.put("mapCurrency", cond.getCurrencyName());
        printParams.put("mapPeriod", this.lblPeriod.getText());
        printParams.put("showQty", cond.isShowQty());
        return printParams;
    }

    @Override
    protected GLRptBasePrintConfig getPrintConfig() {
        return new GLRptAccountBalancePrintConfig(this);
    }

    @Override
    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.VoucherReportQuery";
    }

    @Override
    protected IGLRptBaseFacade getIGLRptFacade() throws BOSException {
        return GLRptAccountBalanceFacadeFactory.getRemoteInstance();
    }

    @Override
    protected List getCommonPrintButtons() {
        ArrayList<GLRptCommonItemInfo> list = new ArrayList<GLRptCommonItemInfo>();
        list.add(new GLRptCommonItemInfo(PrintButtonEnum.CompanyArea, new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"SelectedCompany"), EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"AllCompany")}));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void joinQury(GLRptSubLedgerCondition cond, String uiClassName) throws Exception {
        if (this.getDataComponent().isEmpty()) {
            return;
        }
        try {
            this.setCursorOfWair();
            this.setLinkedAccount(cond);
            this.setLinkedCompany(cond);
            this.setLinkedCurrency(cond);
            this.setLinkedAsstactList(cond);
            String mode = this.getUIWindow() instanceof UINewFrame ? "com.kingdee.eas.base.uiframe.client.UINewFrameFactory" : "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
            IUIWindow ui = UIFactory.createUIFactory((String)mode).create(uiClassName, (Map)this.getLinkedContext(cond), null);
            ui.show();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    protected UIContext getLinkedContext(GLRptBaseCondition cond) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        if ("FSSC".equalsIgnoreCase(uiParam)) {
            uiContext.put((Object)"UIClassParam", (Object)uiParam);
        } else {
            uiContext.put((Object)"UIClassParam", (Object)cond.toMap().toString());
        }
        uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)cond);
        return uiContext;
    }

    private void setLinkedCompany(GLRptSubLedgerCondition cond) throws EASBizException, BOSException {
        if (cond.getCompany() == null) {
            if (cond.getCompanyId() != null) {
                cond.switchCompany(GlUtils.getCompanyById(cond.getCompanyId()), true);
            } else {
                cond.switchCompany(this.getCurrCompany(), true);
            }
        }
        this.setJoinCompany(cond);
    }

    @Override
    protected void setJoinCompany(GLRptBaseCondition cond) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        if (CompanyDisplayModeEnum.enumerate == this.getQueryCond().getCompanyDisplayMode()) {
            if (this.getQueryCond().getCompany() != null) {
                company = this.getQueryCond().getCompany();
            }
        } else {
            company = this.getSelectCompanyNotEnumerate();
        }
        if (company != null) {
            String uiParam = (String)this.getUIContext().get("UIClassParam");
            if ("FSSC".equalsIgnoreCase(uiParam) || !company.isIsBizUnit()) {
                if (!company.isIsBizUnit()) {
                    CompanyOrgUnitInfo[] companies = cond.getCompanys();
                    HashSet<String> companyIdSet = new HashSet<String>();
                    int len = cond.getCompanys().length;
                    for (int i = 0; i < len; ++i) {
                        if (!companies[i].get("longnumber").toString().contains(company.get("longnumber").toString() + "!")) continue;
                        companyIdSet.add(companies[i].getId().toString());
                    }
                    companies = GLRptUtils.getCompanyArray(companyIdSet, cond.getAccountTableId(), cond.getAccountCodeStart());
                    cond.setCompanys(companies);
                    cond.setSelectedCompanys(companies);
                }
                cond.switchCompany(company, false);
            } else {
                cond.switchCompany(company, true);
            }
        }
    }

    protected void setLinkedAccount(GLRptSubLedgerCondition cond) throws Exception {
        int i;
        if (this.getTable().getSelectManager().get() != null && (i = KDTableUtil.getSelectedTop((KDTable)this.getTable())) != -1) {
            String companyId;
            IRow row = this.getTable().getRow(i);
            String accountId = (String)this.getTable().getCell(i, "FAccountID").getValue();
            ICell companyCell = this.getTable().getCell(i, "FOrgUnitID");
            String string = companyId = companyCell == null ? null : (String)companyCell.getValue();
            if (StringUtils.isEmpty((String)accountId)) {
                return;
            }
            AccountViewInfo account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
            if (!cond.getAccountIdSet().isEmpty() && account.isIsLeaf()) {
                HashSet<String> accountIdSet = new HashSet<String>();
                accountIdSet.add(accountId);
                cond.setAccountIdSet(accountIdSet);
            }
            if (!this.getCurrCompany().isIsBizUnit()) {
                cond.setAccountIdSet((Set)null);
            } else {
                boolean hasDistAccounts;
                boolean bl = hasDistAccounts = !cond.getAccountIdSet().isEmpty();
                if (!(account.isIsLeaf() || StringUtils.isEmpty((String)cond.getAccountCodeStart()) && StringUtils.isEmpty((String)cond.getAccountCodeEnd()) && !hasDistAccounts)) {
                    EntityViewInfo view = new EntityViewInfo();
                    SelectorItemCollection sic = view.getSelector();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("level"));
                    FilterInfo filter = new FilterInfo();
                    if (!StringUtils.isEmpty((String)cond.getAccountCodeStart())) {
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)cond.getAccountCodeStart(), CompareType.GREATER_EQUALS));
                    }
                    if (!StringUtils.isEmpty((String)cond.getAccountCodeEnd())) {
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)(cond.getAccountCodeEnd() + "zz"), CompareType.LESS));
                    }
                    filter.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
                    if (StringUtils.isEmpty((String)companyId)) {
                        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)cond.getCompanyIds(), CompareType.INCLUDE));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
                    }
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)account.getNumber(), CompareType.GREATER_EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)(account.getNumber() + "zz"), CompareType.LESS));
                    if (hasDistAccounts) {
                        filter.getFilterItems().add(new FilterItemInfo("id", cond.getAccountIdSet(), CompareType.INCLUDE));
                    }
                    filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)cond.getAccountTableId()));
                    view.setFilter(filter);
                    AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
                    int maxLevel = 1;
                    if (!coll.isEmpty()) {
                        HashSet<String> accountIdSet = new HashSet<String>();
                        for (int j = 0; j < coll.size(); ++j) {
                            AccountViewInfo info = coll.get(j);
                            maxLevel = Math.max(info.getLevel(), maxLevel);
                            accountIdSet.add(info.getId().toString());
                        }
                        cond.setAccountIdSet(accountIdSet);
                    }
                    cond.setAccountLevelStart(1);
                    cond.setAccountLevelEnd(maxLevel);
                }
            }
            cond.setAccountCodeStart(account.getNumber());
            cond.setAccountCodeEnd(account.getNumber());
            if (cond.isShowLeafAccount()) {
                cond.setAccountLevelStart(account.getLevel());
                cond.setAccountLevelEnd(account.getLevel());
            }
        }
    }

    protected void setLinkedCurrency(GLRptSubLedgerCondition cond) throws Exception {
        int i;
        if (cond.isAllCurrency() && this.getTable().getSelectManager().get() != null && (i = KDTableUtil.getSelectedTop((KDTable)this.getTable())) != -1) {
            IRow row = this.getTable().getRow(i);
            String strCurrencyid = (String)row.getCell("FCurrencyID").getValue();
            if (StringUtils.isEmpty((String)strCurrencyid)) {
                return;
            }
            cond.setCurrencyID(strCurrencyid);
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(strCurrencyid));
            cond.setCurrencyName(currency.getName());
        }
    }

    protected void setLinkedAsstactList(GLRptSubLedgerCondition cond) throws CloneNotSupportedException, BOSException, EASBizException {
        GLRptAccountBalanceCondition oldCond = (GLRptAccountBalanceCondition)this.getQueryCond();
        cond.setShowDisplayAsstDetail(oldCond.getDisplayAsstDetail());
        if (!oldCond.getDisplayAsstDetail()) {
            cond.setAsstActList(new ArrayList());
            return;
        }
        List asstActList = GLRptUtils.getasstActList(this.getTableForPrint(), "FAssistGrpId");
        if (asstActList == null) {
            if (!oldCond.getAsstActList().isEmpty()) {
                cond.setAsstActList(oldCond.getAsstActList());
                return;
            }
            cond.setAsstActList(new ArrayList());
            return;
        }
        cond.setAsstActList(asstActList);
        cond.setSumByAsstact(true);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.getTable().setMergeHeadMoveable(true);
        this.actionAssistAccount.setEnabled(false);
        this.actionSubsidiaryLedger.setEnabled(false);
        this.initPopMenu();
        if (this.MULTI_SELECTION_TOTAL) {
            this.innerSumTable = new InnerSumTable(this.getTable(), 2);
        }
    }

    private void initPopMenu() {
        KDTMenuManager tm = this.getMenuManager(this.getTable());
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        pop.addSeparator();
        KDMenuItem miExport = new KDMenuItem();
        miExport.setText(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"ExportExcel_Include"));
        pop.add((JMenuItem)miExport);
        miExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLRptAccountBalanceUI.this.needFillInfo = true;
                GLRptAccountBalanceUI.this.asynExportExcel(null);
                GLRptAccountBalanceUI.this.needFillInfo = false;
            }
        });
        KDMenuItem expandAllItem = new KDMenuItem();
        expandAllItem.setText(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"ExportExcel"));
        pop.add((JMenuItem)expandAllItem);
        expandAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GLRptAccountBalanceUI.this.needFillInfo = true;
                    GLRptAccountBalanceUI.this.actionExport_actionPerformed(e);
                    GLRptAccountBalanceUI.this.needFillInfo = false;
                }
                catch (Exception ex) {
                    GLRptAccountBalanceUI.this.handUIException(ex);
                }
            }
        });
    }

    @Override
    protected String getPermissionItem() {
        return "gl_balanceList_view";
    }

    @Override
    protected String getExportPermissionItem() {
        return "gl_balanceList_export";
    }

    @Override
    protected void tableUserSetting() {
        super.tableUserSetting();
        this.tHelper.setCanMoveColumn(true);
    }

    @Override
    protected GLRptExcelExporter getExporter(Map<String, Object> params) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("needFillInfo", this.needFillInfo);
        params.put("Period", this.lblPeriod.getText());
        params.put("Currency", this.lblCurrency.getText());
        return new GLRptAccountBalanceExcelExporter(params);
    }

    protected void initHelper() {
        this.tHelperPrint = this.tHelper = new GLRptTableHelper(this, new IObjectMultiPKBuilder(){

            public IObjectPK buildPK() {
                return GLRptAccountBalanceUI.this.buildPK();
            }
        });
    }
}

