/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.MutiOrgPermParam;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.account.client.FilterForAccountF7UI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptAccountQueryUI;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class GLRptAccountQueryUI
extends AbstractGLRptAccountQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(GLRptAccountQueryUI.class);
    protected Set hashAccountIdSet;

    public GLRptAccountQueryUI() throws Exception {
        this.btnAccountDiscrete.setText("...");
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initAccountF7();
    }

    protected void initAccountF7() throws Exception {
        this.prbAccountBegin.setEditable(true);
        this.prbAccountBegin.setEditFormat("$number$");
        this.prbAccountBegin.setCommitFormat("$helpCode$;$name$;$number$");
        this.prbAccountBegin.setDisplayFormat("$number$ - $name$");
        this.prbAccountBegin.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountBegin.setCommitParser((IParser)new AccountViewParser(this.prbAccountBegin));
        this.prbAccountEnd.setEditFormat("$number$");
        this.prbAccountEnd.setCommitFormat("$helpCode$;$name$;$number$");
        this.prbAccountEnd.setDisplayFormat("$number$ - $name$");
        this.prbAccountEnd.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountEnd.setCommitParser((IParser)new AccountViewParser(this.prbAccountEnd));
        this.setAccountF7Filter();
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.prbAccountBegin.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    GLRptAccountQueryUI.this.prbAccountBegin_dataChanged(e);
                }
                catch (Exception exc) {
                    GLRptAccountQueryUI.this.handUIException(exc);
                }
            }
        });
        this.prbAccountEnd.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    GLRptAccountQueryUI.this.prbAccountEnd_dataChanged(e);
                }
                catch (Exception exc) {
                    GLRptAccountQueryUI.this.handUIException(exc);
                }
            }
        });
        this.chkShowLeafAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GLRptAccountQueryUI.this.setAccountLevelEnabled(e);
            }
        });
        this.btnAccountDiscrete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GLRptAccountQueryUI.this.action_showHashAccount();
                }
                catch (Exception ex) {
                    GLRptAccountQueryUI.this.handUIException(ex);
                }
            }
        });
    }

    protected Context getMainOrgContext() {
        CompanyOrgUnitInfo cur_ou = this.company;
        Context mainContext = new Context();
        MutiOrgPermParam mutiOrgParam = new MutiOrgPermParam();
        mutiOrgParam.setOrgType(OrgType.Company);
        ArrayList<String> orgIdList = new ArrayList<String>();
        if (this.isUnionQuery()) {
            orgIdList.add(cur_ou.getId().toString());
        } else {
            CompanyOrgUnitInfo[] companys = this.getCompanys();
            if (companys != null && companys.length > 0) {
                for (int i = 0; i < companys.length; ++i) {
                    orgIdList.add(companys[i].getId().toString());
                }
            }
            if (companys != null && companys.length == 1) {
                cur_ou = companys[0];
            }
        }
        mutiOrgParam.setOrgIdList(orgIdList);
        mainContext.put((Object)"MUTI_ORG_INFO", (Object)mutiOrgParam);
        mainContext.put((Object)"CurCompanyId", (Object)cur_ou.getId());
        mainContext.put((Object)OrgType.Company, (Object)cur_ou);
        mainContext.put((Object)"CompanyInfo", (Object)cur_ou);
        mainContext.put((Object)"CompanyId", (Object)cur_ou);
        mainContext.put((Object)"CurOU", (Object)cur_ou);
        return mainContext;
    }

    private FilterInfo getAccountPermissionFilterInfo() throws EASBizException, BOSException {
        String permissionSql;
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId());
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getRemoteInstance();
        String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, "bd_account_accountView_view");
        FilterInfo permissionFilter = null;
        if (!StringUtils.isEmpty((String)rule) && (permissionSql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_account_accountView_view")) != null) {
            permissionFilter = new FilterInfo();
            permissionFilter.getFilterItems().add(new FilterItemInfo("id", (Object)permissionSql, CompareType.INNER));
            this.filterInfo.mergeFilter(permissionFilter, "and");
        }
        return permissionFilter;
    }

    protected void action_showHashAccount() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)((AccountTableInfo)this.bpAccount.getSelectedItem()).getId().toString()));
        view.setFilter(filter);
        AccountTypeFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getAccountTypeCollection(view);
        FilterInfo filterInfo = this.getHashAccountFilter();
        uiContext.put((Object)"filter", (Object)filterInfo);
        uiContext.put((Object)"selectedAccountIdSet", (Object)this.hashAccountIdSet);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FilterForAccountF7UI.class.getName(), (Map)uiContext);
        if (uiWindow instanceof KDDialog) {
            ((KDDialog)uiWindow).setResizable(true);
        }
        FilterForAccountF7UI filterUI = (FilterForAccountF7UI)uiWindow.getUIObject();
        filterUI.getUIWindow().show();
        if (filterUI.isCancel()) {
            return;
        }
        this.hashAccountIdSet = filterUI.getData();
        if (this.hashAccountIdSet != null && !this.hashAccountIdSet.isEmpty()) {
            int maxLevel = GLGeneralFacadeFactory.getRemoteInstance().getMaxHashAccountLevel(this.hashAccountIdSet);
            this.spnAccountLevelBegin.setValue((Object)1);
            this.spnAccountLevelEnd.setValue((Object)(maxLevel < 1 ? 1 : maxLevel));
        } else {
            this.hashAccountIdSet = null;
        }
    }

    protected FilterInfo getHashAccountFilter() throws BOSException, EASBizException {
        FilterInfo permissionFilterInfo;
        String endAccountNumber;
        String startAccountNumber;
        FilterInfo filter = new FilterInfo();
        if (this.isUnionQuery()) {
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)this.getCurrCompany().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)((AccountTableInfo)this.bpAccount.getSelectedItem()).getId().toString()));
        if (this.prbAccountBegin.getValue() != null && (startAccountNumber = this.getBeginAccountNumber()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)startAccountNumber, CompareType.GREATER_EQUALS));
        }
        if (this.prbAccountEnd.getValue() != null && (endAccountNumber = this.getEndAccountNumber()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(endAccountNumber + 'Z'), CompareType.LESS_EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
        FilterInfo fi = this.getAccountFilter();
        if (fi != null) {
            filter.mergeFilter(fi, "AND");
        }
        if ((permissionFilterInfo = this.getAccountPermissionFilterInfo()) != null) {
            filter.mergeFilter(permissionFilterInfo, "AND");
        }
        return filter;
    }

    private String getEndAccountNumber() {
        String endAccountNumber = null;
        Object endAcc = this.prbAccountEnd.getValue();
        if (endAcc instanceof Object[]) {
            Object[] endAccs = (Object[])endAcc;
            if (endAccs[endAccs.length - 1] instanceof AccountViewInfo) {
                endAccountNumber = ((AccountViewInfo)endAccs[endAccs.length - 1]).getNumber();
            }
        } else {
            endAccountNumber = ((AccountViewInfo)this.prbAccountEnd.getValue()).getNumber();
        }
        return endAccountNumber;
    }

    private String getBeginAccountNumber() {
        String startAccountNumber = null;
        Object startAcc = this.prbAccountBegin.getValue();
        if (startAcc instanceof Object[]) {
            Object[] startAccs = (Object[])startAcc;
            if (startAccs[0] instanceof AccountViewInfo) {
                startAccountNumber = ((AccountViewInfo)startAccs[0]).getNumber();
            }
        } else {
            startAccountNumber = ((AccountViewInfo)this.prbAccountBegin.getValue()).getNumber();
        }
        return startAccountNumber;
    }

    protected boolean isSameOneAccount(Object[] beginAccounts, Object[] endAccounts) {
        if (endAccounts != null && endAccounts.length == 1 && beginAccounts != null && beginAccounts.length == 1 && beginAccounts[0] instanceof AccountViewInfo && endAccounts[0] instanceof AccountViewInfo) {
            return ((AccountViewInfo)endAccounts[0]).getId().equals((Object)((AccountViewInfo)beginAccounts[0]).getId());
        }
        return false;
    }

    protected void setAccountLevelModel() {
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getSelectedItem();
        if (account == null) {
            return;
        }
        HashSet<String> companyIdSet = null;
        if (this.isUnionQuery()) {
            companyIdSet = new HashSet<String>();
            companyIdSet.add(this.getCurrCompany().getId().toString());
        } else {
            companyIdSet = this.getCompanyIdSet();
        }
        if (companyIdSet.isEmpty()) {
            return;
        }
        this.spnAccountLevelBegin.setEnabled(!this.chkShowLeafAccount.isSelected() && !companyIdSet.isEmpty());
        this.spnAccountLevelEnd.setEnabled(!this.chkShowLeafAccount.isSelected() && !companyIdSet.isEmpty());
        if (companyIdSet.isEmpty()) {
            return;
        }
        try {
            int maxLevel = this.getIGLRptBaseFacade().getAccountMaxLevel(companyIdSet, account.getId().toString());
            SpinnerUtil.manageAccountLevelRange((int)1, (int)(maxLevel < 1 ? 1 : maxLevel), (KDSpinner)this.spnAccountLevelBegin, (KDSpinner)this.spnAccountLevelEnd);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void prbAccountBegin_dataChanged(DataChangeEvent e) throws Exception, BOSException {
        Object accountFrom = this.prbAccountBegin.getValue();
        Object accountTo = this.prbAccountEnd.getValue();
        if (accountFrom != null && accountTo == null) {
            if (accountFrom instanceof Object[]) {
                Object[] accounts = (Object[])accountFrom;
                for (int i = 0; i < accounts.length; ++i) {
                    if (accounts[i] != null) continue;
                    return;
                }
            }
            this.prbAccountEnd.setValue(accountFrom);
        }
        int minLevel = this.getMinLevelFromAccount(accountFrom instanceof Object[] ? ((Object[])accountFrom)[0] : accountFrom, accountTo instanceof Object[] ? ((Object[])accountTo)[0] : accountTo);
        int maxLevel = this.getMaxLevelFromAccount(accountFrom instanceof Object[] ? ((Object[])accountFrom)[0] : accountFrom, accountTo instanceof Object[] ? ((Object[])accountTo)[0] : accountTo);
        if (0 != minLevel) {
            this.spnAccountLevelBegin.setValue((Object)minLevel);
        }
        if (0 != maxLevel) {
            this.spnAccountLevelEnd.setValue((Object)maxLevel);
        }
        this.hashAccountIdSet = null;
    }

    protected void prbAccountEnd_dataChanged(DataChangeEvent e) throws Exception, BOSException {
        Object acct = this.prbAccountBegin.getValue();
        Object[] beginAccounts = null;
        Object beginAccount = null;
        Object endAccount = null;
        if (acct instanceof AccountViewInfo) {
            beginAccounts = new Object[]{acct};
        } else if (acct instanceof Object[]) {
            beginAccounts = (Object[])acct;
        }
        acct = e.getNewValue();
        Object[] endAccounts = null;
        if (acct instanceof AccountViewInfo) {
            endAccounts = new Object[]{acct};
        } else if (acct instanceof Object[]) {
            endAccounts = (Object[])acct;
        }
        if (beginAccounts != null) {
            beginAccount = beginAccounts[0];
        }
        if (endAccounts != null) {
            endAccount = endAccounts[0];
        }
        int maxLevel = this.getMaxLevelFromAccount(beginAccount, endAccount);
        int minLevel = this.getMinLevelFromAccount(beginAccount, endAccount);
        if (0 != minLevel) {
            this.spnAccountLevelBegin.setValue((Object)minLevel);
        }
        if (0 != maxLevel) {
            this.spnAccountLevelEnd.setValue((Object)maxLevel);
        }
        this.hashAccountIdSet = null;
    }

    protected int getMinLevelFromAccount(Object beginAccounts, Object endAccounts) {
        int beginLevel;
        if (null == beginAccounts && null == endAccounts) {
            return 1;
        }
        if (null != beginAccounts && null == endAccounts) {
            return ((AccountViewInfo)beginAccounts).getLevel();
        }
        if (null == beginAccounts && null != endAccounts) {
            return ((AccountViewInfo)endAccounts).getLevel();
        }
        int endLevel = ((AccountViewInfo)endAccounts).getLevel();
        if (endLevel < (beginLevel = ((AccountViewInfo)beginAccounts).getLevel())) {
            return endLevel;
        }
        return beginLevel;
    }

    protected int getMaxLevelFromAccount(Object beginAccount, Object endAccount) {
        int beginLevel;
        if (null == beginAccount && null == endAccount) {
            return 1;
        }
        if (null != beginAccount && null == endAccount) {
            return ((AccountViewInfo)beginAccount).getLevel();
        }
        if (null == beginAccount && null != endAccount) {
            return ((AccountViewInfo)endAccount).getLevel();
        }
        int endLevel = ((AccountViewInfo)endAccount).getLevel();
        if (endLevel > (beginLevel = ((AccountViewInfo)beginAccount).getLevel())) {
            return endLevel;
        }
        return beginLevel;
    }

    @Override
    protected void accountTableChanged() throws Exception {
        boolean b;
        super.accountTableChanged();
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getSelectedItem();
        boolean bl = b = account != null;
        if (this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.merger || this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.enumerate) {
            b = b && this.getCompanys() != null;
        }
        this.prbAccountBegin.setEnabled(b);
        this.prbAccountEnd.setEnabled(b);
        this.btnAccountDiscrete.setEnabled(b);
        this.setAccountTemp();
        this.setAccountLevelModel();
        this.setAccountF7Filter();
    }

    @Override
    protected void companyChanged() throws Exception {
        super.companyChanged();
        boolean isEnable = this.bpCompany.getValue() != null;
        this.prbAccountBegin.setEnabled(isEnable);
        this.prbAccountEnd.setEnabled(isEnable);
        this.btnAccountDiscrete.setEnabled(isEnable);
        this.spnAccountLevelBegin.setEnabled(isEnable);
        this.spnAccountLevelEnd.setEnabled(isEnable);
        if (!isEnable) {
            this.setAccountTemp();
            return;
        }
        this.setAccountLevelModel();
        if (this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.merger || this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.enumerate) {
            this.setAccountTemp();
            this.setAccountF7Filter();
        }
    }

    protected void setAccountF7Filter() {
        try {
            AccountTableInfo accountTable = (AccountTableInfo)this.bpAccount.getSelectedItem();
            if (accountTable == null) {
                return;
            }
            FilterInfo filter = this.getAccountFilter();
            CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
            if (this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.merger || this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.enumerate) {
                CompanyOrgUnitInfo[] companys = this.getCompanys();
                if (companys == null) {
                    return;
                }
                for (int i = 0; i < companys.length; ++i) {
                    companyColl.add(companys[i]);
                }
            } else {
                companyColl.add(this.getCurrCompany());
            }
            FilterInfo tf = new FilterInfo();
            if (companyColl != null) {
                if (companyColl.size() == 1) {
                    tf.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyColl.get(0).getId().toString()));
                } else {
                    CompanyOrgUnitInfo company = AccountTools.getCUCompanyOrgUnitInfo(null, (CompanyOrgUnitCollection)companyColl);
                    tf.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
                }
            }
            if (accountTable != null) {
                tf.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
            }
            tf.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
            if (tf.getFilterItems().size() > 0) {
                filter.mergeFilter(tf, "and");
            }
            AccountPromptBox apb = new AccountPromptBox((IUIObject)this, companyColl, accountTable, filter, false, false, false);
            this.prbAccountBegin.setSelector((KDPromptSelector)apb);
            this.prbAccountEnd.setSelector((KDPromptSelector)apb);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            this.prbAccountBegin.setEntityViewInfo(view);
            this.prbAccountEnd.setEntityViewInfo(view);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected FilterInfo getAccountFilter() {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    @Override
    public GLRptBaseCondition getCustomCondition() {
        GLRptBaseCondition cond = super.getCustomCondition();
        this.getAccountStartValue(cond);
        this.getAccountEndValue(cond);
        Integer accountLevelBegin = (Integer)this.spnAccountLevelBegin.getValue();
        Integer accountLevelEnd = (Integer)this.spnAccountLevelEnd.getValue();
        cond.setAccountLevelStart(accountLevelBegin);
        cond.setAccountLevelEnd(accountLevelEnd);
        cond.setShowLeafAccount(this.chkShowLeafAccount.isSelected());
        cond.setAccountIdSet(this.hashAccountIdSet);
        return cond;
    }

    private void getAccountStartValue(GLRptBaseCondition cond) {
        cond.setAccountCodeStart(null);
        Object object = this.prbAccountBegin.getValue();
        if (object != null) {
            Object[] objectArray;
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object;
            }
            Object[] ar = objectArray;
            cond.setAccountCodeStart(this.getAccountNumber(ar));
            cond.setAccountViewStart(ar);
        }
    }

    public String getAccountNumber(Object[] objects) {
        String accountNumber = "";
        for (int i = 0; i < objects.length; ++i) {
            AccountViewInfo account;
            if (objects[i] instanceof String) {
                logger.error((Object)"-----------+++++----------objects[0] is a String ");
                accountNumber = accountNumber + objects[i] + ",";
                continue;
            }
            if (!(objects[i] instanceof AccountViewInfo) || (account = (AccountViewInfo)objects[i]) == null) continue;
            accountNumber = accountNumber + account.getNumber() + ",";
        }
        if (!accountNumber.equals("")) {
            accountNumber = accountNumber.substring(0, accountNumber.length() - 1);
        }
        return accountNumber;
    }

    private void getAccountEndValue(GLRptBaseCondition cond) {
        cond.setAccountCodeEnd(null);
        Object object = this.prbAccountEnd.getValue();
        if (object != null) {
            Object[] objectArray;
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object;
            }
            Object[] ar = objectArray;
            cond.setAccountCodeEnd(this.getAccountNumber(ar));
            cond.setAccountViewEnd(ar);
        }
    }

    @Override
    public void setCustomCondition(GLRptBaseCondition condition) throws EASBizException, BOSException {
        super.setCustomCondition(condition);
        if (condition == null) {
            return;
        }
        this.setAccountCondition(condition);
    }

    protected void setAccountTemp() {
        this.prbAccountBegin.setValue(null);
        this.prbAccountEnd.setValue(null);
        this.hashAccountIdSet = null;
    }

    protected void setAccountCondition(GLRptBaseCondition condition) {
        this.prbAccountBegin.setValue(condition.getAccountViewStart());
        this.prbAccountEnd.setValue(condition.getAccountViewEnd());
        this.chkShowLeafAccount.setSelected(condition.isShowLeafAccount());
        int beginLevel = condition.getAccountLevelStart();
        int endLevel = condition.getAccountLevelEnd();
        beginLevel = beginLevel < 1 ? 1 : beginLevel;
        endLevel = endLevel < 1 ? 1 : endLevel;
        this.spnAccountLevelBegin.setValue((Object)beginLevel);
        this.spnAccountLevelBegin.setEnabled(!condition.isShowLeafAccount());
        this.spnAccountLevelEnd.setValue((Object)endLevel);
        this.spnAccountLevelEnd.setEnabled(!condition.isShowLeafAccount());
        this.hashAccountIdSet = condition.getAccountIdSet();
    }

    @Override
    public void clear() {
        super.clear();
        this.setAccountF7Filter();
        this.setAccountTemp();
        this.hashAccountIdSet = null;
        this.chkShowLeafAccount.setSelected(false);
        this.setAccountLevelModel();
    }

    protected void setAccountF7Filter2() {
        try {
            AccountTableInfo accountTable = (AccountTableInfo)this.bpAccount.getSelectedItem();
            if (accountTable == null) {
                return;
            }
            FilterInfo filter = new FilterInfo();
            CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
            if (this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.merger || this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.enumerate) {
                CompanyOrgUnitInfo[] companys = this.getCompanys();
                if (companys == null) {
                    return;
                }
                for (int i = 0; i < companys.length; ++i) {
                    companyColl.add(companys[i]);
                }
            } else {
                companyColl.add(this.getCurrCompany());
            }
            FilterInfo tf = new FilterInfo();
            if (companyColl != null) {
                if (companyColl.size() == 1) {
                    tf.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyColl.get(0).getId().toString()));
                } else {
                    CompanyOrgUnitInfo company = AccountTools.getCUCompanyOrgUnitInfo(null, (CompanyOrgUnitCollection)companyColl);
                    tf.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
                }
            }
            if (accountTable != null) {
                tf.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
            }
            tf.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
            if (tf.getFilterItems().size() > 0) {
                filter.mergeFilter(tf, "and");
            }
            AccountPromptBox apb = new AccountPromptBox((IUIObject)this, companyColl, accountTable, filter, false, false, false);
            this.prbAccountBegin.setSelector((KDPromptSelector)apb);
            this.prbAccountEnd.setSelector((KDPromptSelector)apb);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            this.prbAccountBegin.setEntityViewInfo(view);
            this.prbAccountEnd.setEntityViewInfo(view);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void setAccountLevelEnabled(ItemEvent e) {
        this.spnAccountLevelBegin.setEnabled(e.getStateChange() != 1);
        this.spnAccountLevelEnd.setEnabled(e.getStateChange() != 1);
    }
}

