/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptPrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAssistBalancePrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;

public class GLRptAssistBalancePrintDelegate
extends AbstractGLRptPrintDelegate {
    public static final String[][] col = new String[][]{{"sysDateNow", ""}, {"yeCode", ""}, {"qiJian", ""}, {"biBie", ""}, {"heShuanName", ""}, {"companyName", ""}, {"userName", ""}, {"fAccountLongName", ""}, {"fPeriod", ""}, {"fnumber", "itemNumber"}, {"fname", "itemName"}, {"facttypename", "actTypeName"}, {"faccountnumber", "accountNumber"}, {"faccountname", "accountName"}, {"fcurrencyname", "currencyName"}, {"tpFPeriodYear", "FPeriodYear"}, {"tpFperiodnumber", "FPeriodNumber"}, {"fyearbeginbalancefor", "FYearBeginBalanceFor"}, {"fyearbeginbalancelocal", "FYearBeginBalanceLocal"}, {"fyearbeginbalancerpt", "FYearBeginBalanceRpt"}, {"fbeginbalancefor", "FBeginBalanceFor"}, {"fbeginbalancelocal", "FBeginBalanceLocal"}, {"fbeginbalancerpt", "FBeginBalanceRpt"}, {"fdebitfor", "FDebitFor"}, {"fdebitlocal", "FDebitLocal"}, {"fdebitrpt", "FDebitRpt"}, {"fcreditfor", "FCreditFor"}, {"fcreditlocal", "FCreditLocal"}, {"fcreditrpt", "FCreditRpt"}, {"fyeardebitfor", "FYearDebitFor"}, {"fyeardebitlocal", "FYearDebitLocal"}, {"fyeardebitrpt", "FYearDebitRpt"}, {"fyearcreditfor", "FYearCreditFor"}, {"fyearcreditlocal", "FYearCreditLocal"}, {"fyearcreditrpt", "FYearCreditRpt"}, {"fDC", "endBalanceDC"}, {"fyearBeginBalanceDC", "yearBeginBalanceDC"}, {"fbeginBalanceDC", "beginBalanceDC"}, {"fendBalanceDC", "endBalanceDC"}, {"fendbalancefor", "FEndBalanceFor"}, {"fendbalancelocal", "FEndBalanceLocal"}, {"fendbalancerpt", "FEndBalanceRpt"}, {"fprecision", "currencyPre"}};
    protected Map mapParame = null;
    protected GLRptRowSet rs = null;
    protected boolean bBF = false;
    protected CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();

    public GLRptAssistBalancePrintDelegate(GLRptRowSet rs, Map mapParame, GLRptBasePrintConfig config) {
        this.mapParame = mapParame;
        this.rs = rs;
        this.bBF = ((GLRptAssistBalancePrintConfig)config).isBF();
        if (mapParame.get("company") != null && mapParame.get("company") instanceof CompanyOrgUnitInfo) {
            this.curCompany = (CompanyOrgUnitInfo)mapParame.get("company");
        }
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount) {
        DateFormat format = GlUtils.getDateFormat();
        boolean bearForwardPage = false;
        boolean overHypoPage = false;
        int icycleDegree = rowLineCount;
        int entryNumber = 0;
        int noteNumber = 0;
        int ir = 1;
        int colCount = col.length;
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = col[i][0];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int it = this.rs.size();
            int iCount = 0;
            iCount = it % rowLineCount == 0 ? it / rowLineCount : it / rowLineCount + 1;
            int entryCount = 1;
            CurrencyInfo baseCurrency = this.curCompany.getBaseCurrency();
            baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            CurrencyInfo rptCurrency = this.curCompany.getReportCurrency();
            if (rptCurrency != null) {
                rptCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(rptCurrency.getId()));
            }
            String currencyId = (String)this.mapParame.get("currencyId");
            CurrencyInfo currency = null;
            if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                currency = baseCurrency;
            } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                currency = rptCurrency;
            } else if (!currencyId.equalsIgnoreCase("AllCurrency")) {
                currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            }
            boolean isBaseCurrency = currency != null && baseCurrency.getId().equals((Object)currency.getId());
            boolean isGBaseCy = currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC");
            boolean isGRptCy = currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC");
            this.rs.beforeFirst();
            while (this.rs.next()) {
                String resFullName;
                Object periodYear;
                drs.moveToInsertRow();
                GLRptAssistBalancePrintDelegate.clearRow((IRowSet)drs);
                int page = 0;
                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                drs.updateString("yeCode", page + "/" + iCount);
                drs.updateString("sysDateNow", GlUtils.formatDate(format, new Date()));
                drs.updateString("qiJian", this.mapParame.get("mapPeriod").toString());
                drs.updateString("biBie", this.mapParame.get("CurrencyName").toString());
                drs.updateString("heShuanName", this.mapParame.get("asstActParame").toString());
                if (SysContext.getSysContext().getCurrentUserInfo().getName() != null) {
                    drs.updateString("userName", SysContext.getSysContext().getCurrentUserInfo().getName());
                } else {
                    drs.updateString("userName", SysContext.getSysContext().getCurrentUserInfo().toString());
                }
                drs.updateString("companyName", this.curCompany.getName().toString());
                int precision = 0;
                if (currency == null) {
                    Object currencyPre = this.rs.getObject("currencyPre");
                    if (currencyPre != null) {
                        precision = Integer.parseInt(currencyPre.toString());
                    }
                } else {
                    precision = currency.getPrecision();
                }
                drs.updateInt("fprecision", precision);
                int colNum = col.length - 1;
                for (int i = 9; i < colNum; ++i) {
                    Object value;
                    if (this.rs.indexOf(col[i][1]) == -1 || (value = this.rs.getObject(col[i][1])) == null) continue;
                    if (value instanceof BigDecimal) {
                        if (((BigDecimal)value).compareTo(new BigDecimal("0")) == 0) {
                            drs.updateString(col[i][0], "");
                            continue;
                        }
                        if (col[i][0].toLowerCase().endsWith("local")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)value, baseCurrency.getPrecision()));
                            if (!isGBaseCy) continue;
                            drs.updateString(col[i][0].substring(0, col[i][0].length() - 5) + "for", GlUtils.withComma((BigDecimal)value, baseCurrency.getPrecision()));
                            continue;
                        }
                        if (rptCurrency != null && col[i][0].toLowerCase().endsWith("rpt")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)value, rptCurrency.getPrecision()));
                            if (!isGRptCy) continue;
                            drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "for", GlUtils.withComma((BigDecimal)value, rptCurrency.getPrecision()));
                            continue;
                        }
                        drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)value, precision));
                        if (!isBaseCurrency) continue;
                        drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "local", GlUtils.withComma((BigDecimal)value, precision));
                        continue;
                    }
                    drs.updateString(col[i][0], value.toString());
                }
                Object account = this.rs.getObject("accountNumber");
                if (account != null) {
                    if (this.rs.getObject("accountName") == null) {
                        drs.updateString("fAccountLongName", account.toString());
                    } else {
                        drs.updateString("fAccountLongName", account.toString() + " - " + this.rs.getString("accountName"));
                    }
                }
                if ((periodYear = this.rs.getObject("FPeriodYear")) != null) {
                    drs.updateString("fPeriod", periodYear.toString() + " - " + this.rs.getObject("FPeriodNumber").toString());
                }
                drs.insertRow();
                if (!this.bBF) continue;
                if (it - noteNumber > icycleDegree) {
                    bearForwardPage = true;
                    overHypoPage = true;
                }
                if (++entryNumber != icycleDegree - ir) continue;
                if (overHypoPage) {
                    drs.moveToInsertRow();
                    resFullName = "com.kingdee.eas.fi.gl.client.TaoDaResource.overHypoPage";
                    String strOverHypoPage = EASResource.getString((String)resFullName);
                    drs.updateString("fnumber", strOverHypoPage);
                    drs.insertRow();
                }
                if (bearForwardPage) {
                    drs.moveToInsertRow();
                    resFullName = "com.kingdee.eas.fi.gl.client.TaoDaResource.bearForwardPage";
                    String strBearForwardPage = EASResource.getString((String)resFullName);
                    drs.updateString("fnumber", strBearForwardPage);
                    drs.insertRow();
                }
                noteNumber += entryNumber;
                entryNumber = 0;
                if (it - noteNumber <= icycleDegree) continue;
                ir = 2;
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        catch (Exception e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        return drs;
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }
}

