/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAssistBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAssistBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.IGLRptAsstactBaseFacade;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptAssistBalanceQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GeneralBizPromptBox;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

public class GLRptAssistBalanceQueryUI
extends AbstractGLRptAssistBalanceQueryUI {
    private static final long serialVersionUID = 8643728776787026689L;
    private static final Logger logger = CoreUIObject.getLogger(GLRptAssistBalanceQueryUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initAcctTable();
    }

    @Override
    protected boolean canMergeDisplay() {
        return false;
    }

    protected void initAcctTable() {
        this.tblAct.checkParsed();
        this.tblAct.getSelectManager().setSelectMode(1);
        this.tblAct.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tblAct.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.tblAct.getColumn("selected").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.tblAct.getColumn("selected").setRenderer((IBasicRender)new CellCheckBoxRenderer());
        this.tblAct.getColumn("to").getStyleAttributes().setLocked(true);
        this.tblAct.getColumn("from").getStyleAttributes().setLocked(true);
        this.fillTableAcctType();
        this.tblAct.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == 0) {
                    GLRptAssistBalanceQueryUI.this.tblAct.getCell(e.getRowIndex(), 0).setValue(e.getValue());
                    boolean isSelect = (Boolean)e.getValue();
                    if (isSelect) {
                        GLRptAssistBalanceQueryUI.this.setAsstF7(GLRptAssistBalanceQueryUI.this.tblAct.getRow(e.getRowIndex()));
                    } else {
                        GLRptAssistBalanceQueryUI.this.tblAct.getRow(e.getRowIndex()).getCell("to").getStyleAttributes().setLocked(true);
                        GLRptAssistBalanceQueryUI.this.tblAct.getRow(e.getRowIndex()).getCell("from").getStyleAttributes().setLocked(true);
                    }
                }
                GLRptAssistBalanceQueryUI.this.storeAsstactTypeEntityFields(e);
            }

            public void editValueChanged(KDTEditEvent e) {
                GLRptAssistBalanceQueryUI.this.storeAsstactTypeEntityFields(e);
                GLRptAssistBalanceQueryUI.this.setAccountF7Filter();
            }
        });
        this.setTableKeyBoardManager(this.tblAct);
    }

    @Override
    protected FilterInfo getAccountFilter() {
        FilterInfo filter = super.getAccountFilter();
        FilterInfo asstactTypeFilter = new FilterInfo();
        int maskIndex = 0;
        for (int i = 0; i < this.tblAct.getRowCount(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)this.tblAct.getRow(i).getUserObject();
            if (!at.isSelected()) continue;
            HashSet<String> asstAccIdSet = new HashSet<String>();
            for (int j = 0; j < at.getAsstAccountCount(); ++j) {
                String asstAccountId = at.getAsstAccountId(j);
                asstAccIdSet.add(asstAccountId);
            }
            if (asstAccIdSet.isEmpty()) continue;
            if (asstactTypeFilter.getFilterItems().isEmpty()) {
                asstactTypeFilter.setMaskString("#" + maskIndex++);
            } else {
                asstactTypeFilter.setMaskString(asstactTypeFilter.getMaskString() + " OR #" + maskIndex++);
            }
            asstactTypeFilter.getFilterItems().add(new FilterItemInfo("CAA.id", asstAccIdSet, CompareType.INCLUDE));
        }
        if (!asstactTypeFilter.getFilterItems().isEmpty()) {
            try {
                filter.mergeFilter(asstactTypeFilter, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)"mergeFilter error,", (Throwable)e);
            }
        }
        return filter;
    }

    private void storeAsstactTypeEntityFields(KDTEditEvent e) {
        if (e.getColIndex() == this.tblAct.getColumn("selected").getColumnIndex()) {
            IRow row = this.tblAct.getRow(e.getRowIndex());
            AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
            if (at == null) {
                return;
            }
            at.setSelected((Boolean)e.getValue());
        }
    }

    @Override
    protected void companyChanged() throws Exception {
        super.companyChanged();
        this.fillTableAcctType();
    }

    protected void fillTableAcctType() {
        List actList = null;
        try {
            actList = ((IGLRptAsstactBaseFacade)this.getIGLRptBaseFacade()).queryAsstAct(this.getCompanyIdSet());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.tblAct.removeRows();
        if (actList == null || actList.isEmpty()) {
            return;
        }
        Iterator it = actList.iterator();
        while (it.hasNext()) {
            IRow row = this.tblAct.addRow();
            if (row.getCell("selected") == null) {
                this.tblAct.removeRows();
                return;
            }
            AsstactTypeEntity at = (AsstactTypeEntity)it.next();
            LabelValueBean lvb = new LabelValueBean(at.getId(), at.getName());
            lvb.setProperty("attrs", (Object)at);
            row.setUserObject((Object)at);
            row.getCell("asstact").setValue((Object)lvb);
            row.getCell("selected").setValue((Object)Boolean.FALSE);
        }
    }

    protected void setAsstF7(IRow row) {
        CompanyOrgUnitInfo[] filterCompany;
        CompanyOrgUnitInfo[] companyOrgUnitInfoArray;
        row.getCell("to").getStyleAttributes().setLocked(false);
        row.getCell("from").getStyleAttributes().setLocked(false);
        row.getCell("dist").getStyleAttributes().setLocked(false);
        AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
        AsstActTypeInfo atInfo = new AsstActTypeInfo();
        atInfo.setAsstHGAttribute(at.getHgAttribute());
        atInfo.setIsForCompany(at.isForCompany());
        atInfo.setUseLongNumber(at.isUseLongNumber());
        if (at.getGeneralAsstactGroupId() != null && at.getGeneralAsstactGroupId().trim().length() > 0) {
            GeneralAsstActTypeGroupInfo groupInfo = new GeneralAsstActTypeGroupInfo();
            groupInfo.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
            atInfo.setGlAsstActTypeGrp(groupInfo);
        }
        GLF7Parameter f7Param = new GLF7Parameter();
        f7Param.setOnlyLeaf(true);
        f7Param.setUnUse(true);
        KDBizPromptBox toBizPromptBox = new KDBizPromptBox();
        toBizPromptBox.setEditable(true);
        toBizPromptBox.setEditFormat("$number$");
        toBizPromptBox.setCommitFormat("$number$;$name$");
        toBizPromptBox.setDisplayFormat("$number$ - $name$");
        toBizPromptBox.setQueryInfo(at.getQueryName());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isUseLongNumber() || at.isUseLevel()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        toBizPromptBox.setSelectorCollection(sic);
        if (at.isGeneralActType() && !this.isMultiCompanyF7()) {
            CompanyOrgUnitInfo[] companyOrgUnitInfoArray2 = new CompanyOrgUnitInfo[1];
            companyOrgUnitInfoArray = companyOrgUnitInfoArray2;
            companyOrgUnitInfoArray2[0] = this.getCurrCompany();
        } else {
            companyOrgUnitInfoArray = filterCompany = this.getCompanys();
        }
        if (!at.isGeneralActType() && !this.getCurrCompany().isIsBizUnit()) {
            atInfo.put("isSetMainBizOrg", (Object)false);
        }
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)toBizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo[])filterCompany, (GLF7Parameter)f7Param);
        toBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    Object from;
                    AsstactTypeEntity asst;
                    Object old;
                    int beginRow = GLRptAssistBalanceQueryUI.this.tblAct.getSelectManager().get().getBeginRow();
                    IRow row = GLRptAssistBalanceQueryUI.this.tblAct.getRow(beginRow);
                    KDBizPromptBox toBox = (KDBizPromptBox)e.getSource();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = toBox.getEntityViewInfo().getFilter();
                    FilterInfo newFilter = new FilterInfo();
                    Object to = e.getNewValue();
                    Object object = old = e.getOldValue() == null ? row.getCell("to").getValue() : e.getOldValue();
                    if (to instanceof IObjectValue && old instanceof IObjectValue) {
                        String id = ((IObjectValue)to).get("id").toString();
                        String oid = ((IObjectValue)old).get("id").toString();
                        if (id != null && id.equals(oid)) {
                            return;
                        }
                    }
                    Object obj = row.getUserObject();
                    String compareExpr = "number";
                    if (obj instanceof AsstactTypeEntity && (asst = (AsstactTypeEntity)obj).isGeneralActType()) {
                        compareExpr = "longnumber";
                    }
                    if (to instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)to).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
                    }
                    if ((from = row.getCell("from").getValue()) instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.GREATER_EQUALS));
                    }
                    newFilter.mergeFilter(filter, "and");
                    view.setFilter(newFilter);
                    GLRptAssistBalanceQueryUI.this.loadDistBox(row, toBox, view);
                }
                catch (Exception exc) {
                    GLRptAssistBalanceQueryUI.this.handUIException(exc);
                }
            }
        });
        row.getCell("to").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)toBizPromptBox));
        KDBizPromptBox fromBizPromptBox = new KDBizPromptBox();
        fromBizPromptBox.setEditable(true);
        fromBizPromptBox.setEditFormat("$number$");
        if (at.isUseLongNumber() || at.isUseLevel()) {
            fromBizPromptBox.setCommitFormat("$number$;$name$");
        } else {
            fromBizPromptBox.setCommitFormat("$number$;$longnumber$;$name$");
        }
        fromBizPromptBox.setDisplayFormat("$number$ - $name$");
        fromBizPromptBox.setQueryInfo(at.getQueryName());
        fromBizPromptBox.setSelectorCollection(sic);
        if (atInfo.getGlAsstActTypeGrp() != null) {
            try {
                CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("company");
                boolean showLongNumber = Boolean.parseBoolean(GlUtils.getParamByKey(null, currentCompany.getId().toString(), "GL_064").toString());
                if (showLongNumber) {
                    toBizPromptBox.setNeedConvert(true);
                    fromBizPromptBox.setNeedConvert(true);
                }
            }
            catch (Exception e) {
                logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"480_GLRptAssistBalanceQueryUI"));
            }
        }
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)fromBizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo[])filterCompany, (GLF7Parameter)f7Param);
        fromBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    Object to;
                    AsstactTypeEntity asst;
                    Object old;
                    int beginRow = GLRptAssistBalanceQueryUI.this.tblAct.getSelectManager().get().getBeginRow();
                    IRow row = GLRptAssistBalanceQueryUI.this.tblAct.getRow(beginRow);
                    KDBizPromptBox fromBox = (KDBizPromptBox)e.getSource();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = fromBox.getEntityViewInfo().getFilter();
                    FilterInfo newFilter = new FilterInfo();
                    Object from = e.getNewValue();
                    Object object = old = e.getOldValue() == null ? row.getCell("from").getValue() : e.getOldValue();
                    if (from instanceof IObjectValue && old instanceof IObjectValue) {
                        String id = ((IObjectValue)from).get("id").toString();
                        String oid = ((IObjectValue)old).get("id").toString();
                        if (id != null && id.equals(oid)) {
                            return;
                        }
                    }
                    Object obj = row.getUserObject();
                    String compareExpr = "number";
                    if (obj instanceof AsstactTypeEntity && (asst = (AsstactTypeEntity)obj).isGeneralActType()) {
                        compareExpr = "longnumber";
                    }
                    if (from instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.GREATER_EQUALS));
                    }
                    if ((to = row.getCell("to").getValue()) instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)to).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
                    } else if (from != null) {
                        row.getCell("to").setValue(from);
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
                    }
                    newFilter.mergeFilter(filter, "and");
                    view.setFilter(newFilter);
                    GLRptAssistBalanceQueryUI.this.loadDistBox(row, fromBox, view);
                }
                catch (Exception exc) {
                    GLRptAssistBalanceQueryUI.this.handUIException(exc);
                }
            }
        });
        row.getCell("from").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)fromBizPromptBox));
        this.loadDistBox(row, fromBizPromptBox, null);
    }

    private KDBizPromptBox loadDistBox(IRow row, KDBizPromptBox bizBox, EntityViewInfo view) {
        KDBizPromptBox disBox = new KDBizPromptBox();
        disBox.setEditFormat("$number$");
        disBox.setDisplayFormat("$name$");
        disBox.setCommitFormat("$number$");
        disBox.setEditable(false);
        disBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = GLRptAssistBalanceQueryUI.this.tblAct.getSelectManager().get().getBeginRow();
                    IRow row = GLRptAssistBalanceQueryUI.this.tblAct.getRow(beginRow);
                    Object dist = e.getNewValue();
                    if (dist == null) {
                        AsstactTypeEntity entry = (AsstactTypeEntity)row.getUserObject();
                        entry.setDist(null);
                        row.getCell("dist").setUserObject(null);
                    }
                }
                catch (Exception exc) {
                    GLRptAssistBalanceQueryUI.this.handUIException(exc);
                }
            }
        });
        if (view == null) {
            view = bizBox.getEntityViewInfo();
            if (view != null) {
                view = (EntityViewInfo)view.clone();
            }
            view = this.getDefaultView(row, view);
        }
        disBox.setEntityViewInfo(view);
        disBox.setSelector((KDPromptSelector)new GeneralBizPromptBox(view, bizBox.getQueryInfo(), this.tblAct, "com.kingdee.eas.fi.gl.rpt.client.FilterForAssistF7UI"));
        row.getCell("dist").setValue(null);
        row.getCell("dist").setUserObject(null);
        row.getCell("dist").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)disBox));
        return disBox;
    }

    private EntityViewInfo getDefaultView(IRow row, EntityViewInfo view) {
        Object to;
        Object from;
        AsstactTypeEntity at;
        if (view == null || view.getFilter() == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = view.getFilter();
        FilterInfo newFilter = new FilterInfo();
        Object obj = row.getUserObject();
        String compareExpr = "number";
        if (obj instanceof AsstactTypeEntity && (at = (AsstactTypeEntity)obj).isGeneralActType()) {
            compareExpr = "longnumber";
        }
        if ((from = row.getCell("from").getValue()) instanceof IObjectValue) {
            newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.GREATER_EQUALS));
        }
        if ((to = row.getCell("to").getValue()) instanceof IObjectValue) {
            newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)to).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
        }
        try {
            newFilter.mergeFilter(filter, "and");
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        view.setFilter(newFilter);
        return view;
    }

    @Override
    public void setCustomCondition(GLRptBaseCondition condition) throws EASBizException, BOSException {
        super.setCustomCondition(condition);
        GLRptAssistBalanceCondition cond = (GLRptAssistBalanceCondition)condition;
        if (cond == null) {
            return;
        }
        this.chkOpDisplaySumByAsst.setSelected(cond.isShowAsstItemTotal());
        if (cond.getAsstActList() != null) {
            for (int i = 0; i < this.tblAct.getRowCount(); ++i) {
                IRow row = this.tblAct.getRow(i);
                AsstactTypeEntity ate = (AsstactTypeEntity)row.getUserObject();
                AsstactTypeEntity at = null;
                for (int j = 0; j < cond.getAsstActList().size(); ++j) {
                    AsstactTypeEntity actEntity = (AsstactTypeEntity)cond.getAsstActList().get(j);
                    if (!actEntity.getId().equals(ate.getId()) || !actEntity.isSelected()) continue;
                    at = actEntity;
                    break;
                }
                if (at != null) {
                    row.getCell("selected").setValue((Object)Boolean.TRUE);
                    row.getCell("from").setValue(at.getFrom());
                    row.getCell("to").setValue(at.getTo());
                    this.setAsstF7(row);
                    this.loadDist(row, at);
                    row.setUserObject((Object)at);
                    continue;
                }
                row.getCell("selected").setValue((Object)Boolean.FALSE);
                row.getCell("from").setValue(null);
                row.getCell("from").getStyleAttributes().setLocked(true);
                row.getCell("to").setValue(null);
                row.getCell("to").getStyleAttributes().setLocked(true);
                row.getCell("dist").setValue(null);
                row.getCell("dist").getStyleAttributes().setLocked(true);
            }
        }
    }

    private void loadDist(IRow row, AsstactTypeEntity actEntity) {
        Object temp = actEntity.getDist();
        if (temp instanceof Set) {
            String asstName = "";
            AssistViewFilterInfo avf2 = null;
            for (AssistViewFilterInfo avf2 : (Set)temp) {
                asstName = asstName + avf2.getName() + ";";
            }
            if (!"".equals(asstName)) {
                row.getCell("dist").setValue((Object)asstName);
                row.getCell("dist").setUserObject(actEntity.getDist());
            }
        }
    }

    @Override
    public GLRptBaseCondition getCustomCondition() {
        GLRptAssistBalanceCondition customCondition = (GLRptAssistBalanceCondition)super.getCustomCondition();
        customCondition.setShowAsstActSingle(true);
        customCondition.setShowAsstItemTotal(this.chkOpDisplaySumByAsst.isSelected());
        ArrayList<AsstactTypeEntity> actList = new ArrayList<AsstactTypeEntity>();
        for (int i = 0; i < this.tblAct.getRowCount(); ++i) {
            IRow row = this.tblAct.getRow(i);
            Boolean selected = (Boolean)row.getCell("selected").getValue();
            if (selected == null || !selected.booleanValue()) continue;
            AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
            at.setSelected(true);
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            at.setDist(row.getCell("dist").getUserObject());
            actList.add(at);
        }
        customCondition.setAsstActList(actList);
        return customCondition;
    }

    @Override
    public boolean verify() {
        if (!super.verify()) {
            return false;
        }
        boolean selected = false;
        int n = this.tblAct.getRowCount();
        for (int i = 0; i < n; ++i) {
            selected = selected || (Boolean)this.tblAct.getRow(i).getCell(0).getValue() != false;
        }
        if (!selected) {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_act_item_please"));
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.chkOpDisplaySumByAsst.setSelected(false);
        this.clearAsst();
    }

    private void clearAsst() {
        for (int i = 0; i < this.tblAct.getRowCount(); ++i) {
            IRow row = this.tblAct.getRow(i);
            Boolean selected = (Boolean)row.getCell("selected").getValue();
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("from").setValue(null);
            row.getCell("to").setValue(null);
            row.getCell("dist").setValue(null);
            row.getCell("dist").setUserObject(null);
            AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
            at.setFrom(null);
            at.setTo(null);
            at.setDist(null);
            this.lockAsstCell(row);
        }
    }

    private void lockAsstCell(IRow row) {
        row.getCell("from").getStyleAttributes().setLocked(true);
        row.getCell("from").setEditor(null);
        row.getCell("to").getStyleAttributes().setLocked(true);
        row.getCell("to").setEditor(null);
        row.getCell("dist").getStyleAttributes().setLocked(true);
        row.getCell("dist").setEditor(null);
    }

    @Override
    protected GLRptBaseCondition createReportCondition() {
        return new GLRptAssistBalanceCondition();
    }

    @Override
    protected GLRptBaseCondition createReportCondition(Map param) throws CloneNotSupportedException {
        return new GLRptAssistBalanceCondition(param);
    }

    @Override
    protected IGLRptBaseFacade getIGLRptBaseFacade() throws BOSException {
        return GLRptAssistBalanceFacadeFactory.getRemoteInstance();
    }

    private boolean isMultiCompanyF7() {
        return this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.enumerate || this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.merger;
    }

    @Override
    public void actionEditExtendParams_actionPerformed(ActionEvent e) throws Exception {
        this.showParamExUI();
    }

    @Override
    protected void showAdvanceActionPerformed(ActionEvent e) {
        this.lbExtendParams.setVisible(!this.lbExtendParams.isVisible());
        this.btnEditExtendParams.setVisible(!this.btnEditExtendParams.isVisible());
        this.btnEditExtendParams.setEnabled(true);
    }
}

