/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.GLRptAssistBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAssistBalanceExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptAssistBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.PrintButtonEnum;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptAssistBalanceUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAssistBalancePrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAssistBalancePrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAssistBalanceQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptCommonItemInfo;
import com.kingdee.eas.fi.gl.rpt.client.GLRptTable;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class GLRptAssistBalanceUI
extends AbstractGLRptAssistBalanceUI {
    private static final long serialVersionUID = -4305097872892112473L;
    private static final Logger logger = CoreUIObject.getLogger(GLRptAssistBalanceUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initPopMenu();
    }

    private void initPopMenu() {
        KDTMenuManager tm = this.getMenuManager(this.getTable());
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        pop.addSeparator();
        KDMenuItem miExport = new KDMenuItem();
        miExport.setText(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"ExportExcel_Include"));
        pop.add((JMenuItem)miExport);
        miExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLRptAssistBalanceUI.this.asynExportExcel(null);
            }
        });
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnJoinAsstactGD.setIcon(EASResource.getIcon((String)"imgTbtn_assistantaccountdetail"));
        this.menuItemJoinAsstactGD.setIcon(EASResource.getIcon((String)"imgTbtn_assistantaccountdetail"));
    }

    @Override
    protected boolean isSupportUnion() {
        return false;
    }

    @Override
    protected void tableUserSetting() {
        super.tableUserSetting();
        this.tHelper.setCanMoveColumn(true);
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.getTable().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int rowIndex = e.getSelectBlock().getTop();
                try {
                    GLRptAssistBalanceUI.this.tblMain_SelectChanged(rowIndex);
                }
                catch (Exception ex) {
                    GLRptAssistBalanceUI.this.handleException(ex);
                }
            }
        });
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        GLRptAssistBalanceUI.this.doTableDoubleClick(e.getRowIndex());
                    }
                }
                catch (Exception ex) {
                    GLRptAssistBalanceUI.this.handUIException(ex);
                }
            }
        });
    }

    protected void doTableDoubleClick(int rowIndex) {
        if (this.actionJoinAsstactGD.isEnabled()) {
            try {
                this.setCursorOfWair();
                this.joinAsstactGD();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        } else {
            return;
        }
    }

    @Override
    protected void setQueryDialogSize(CommonQueryDialog dialog) {
        dialog.setWidth(470);
        dialog.setHeight(430);
    }

    @Override
    protected void setReportExtraTitle(GLRptBaseCondition condition) {
        super.setReportExtraTitle(condition);
        String asstAct = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"Item_Label");
        String str = asstAct + this.getAsstactName();
        this.lblAsstActItem.setText(str);
        this.lblAsstActItem.setToolTipText(str);
    }

    @Override
    protected void setQueryingActionStatus(boolean enable) {
        super.setQueryingActionStatus(enable);
        this.actionJoinAsstactGD.setEnabled(enable);
    }

    @Override
    protected void afterFillTableRow(IRow row, String[] colNames) {
        this.setCellNumberFormat(row, colNames);
        this.setTotalColoer(row);
    }

    private void setCellNumberFormat(IRow row, String[] colNames) {
        if (row.getCell("currencyPre") != null && row.getCell("currencyPre").getValue() != null) {
            int currencyPre = Integer.parseInt(row.getCell("currencyPre").getValue().toString());
            String key = null;
            for (int i = 0; i < colNames.length; ++i) {
                key = colNames[i];
                if (key == null || !key.endsWith("For")) continue;
                row.getCell(key).getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(currencyPre));
            }
        }
    }

    private void setTotalColoer(IRow row) {
        GLRptAssistBalanceCondition cond = (GLRptAssistBalanceCondition)this.getQueryCond();
        boolean isTotal = false;
        Object total = row.getCell("isTotal").getValue();
        Object currencyIsTotal = cond.isAllCurrency() ? row.getCell("currencyIsTotal").getValue() : null;
        Object actTypeIsTotal = cond.isShowAsstItemTotal() ? row.getCell("actTypeIsTotal").getValue() : null;
        Object actItemIsTotal = cond.isShowAsstItemTotal() ? row.getCell("actItemIsTotal").getValue() : null;
        String ONE = "1";
        if (total != null && total.toString().equals(ONE) || currencyIsTotal != null && ONE.equals(currencyIsTotal.toString()) || actTypeIsTotal != null && ONE.equals(actTypeIsTotal.toString()) || actItemIsTotal != null && ONE.equals(actItemIsTotal.toString())) {
            isTotal = true;
        }
        if (isTotal) {
            row.getStyleAttributes().setBackground(TOTAL_COLOR);
        }
    }

    @Override
    protected GLRptBaseCondition createQueryCond(Map param) {
        try {
            return new GLRptAssistBalanceCondition(param);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
            return null;
        }
    }

    @Override
    protected GLRptBaseQueryUI getCustQueryPanel() throws Exception {
        return new GLRptAssistBalanceQueryUI();
    }

    protected void tblMain_SelectChanged(int rowIndex) throws EASBizException, BOSException {
        if (rowIndex >= 0) {
            IRow row = this.getTable().getRow(rowIndex);
            if (row == null) {
                return;
            }
            Object actTypeId = row.getCell("FActTypefId").getValue();
            if (actTypeId != null) {
                this.actionJoinAsstactGD.setEnabled(true);
            } else {
                this.actionJoinAsstactGD.setEnabled(false);
            }
        } else {
            this.actionJoinAsstactGD.setEnabled(false);
        }
    }

    @Override
    public void actionJoinAsstactGD_actionPerformed(ActionEvent e) throws Exception {
        this.joinAsstactGD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinAsstactGD() throws EASBizException, BOSException {
        GLRptTable tblMain = this.getTable();
        if (tblMain.getRowCount() == 0 || tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        IRow row = tblMain.getRow(tblMain.getSelectManager().getActiveRowIndex());
        GLRptAssistBalanceCondition oldCond = (GLRptAssistBalanceCondition)this.getQueryCond();
        GLRptAsstactGDCondition cond = new GLRptAsstactGDCondition(oldCond);
        this.setJoinCompany(cond);
        this.setCursorOfWair();
        try {
            this.setLinkedAccount(row, cond);
            this.setLinkedCurrency(row, cond);
            cond.setShowAsstItemTotal(oldCond.isShowAsstItemTotal());
            List actList = this.getAsstactTypes(row, oldCond);
            if (actList == null || actList.isEmpty()) {
                return;
            }
            cond.setAsstActList(actList);
            UIContext ctx = this.getLinkedContext(cond);
            IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(GLRptAsstactGDUI.class.getName(), (Map)ctx, this.dataObjects);
            ui.show();
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    protected UIContext getLinkedContext(GLRptBaseCondition cond) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
        uiContext.put((Object)"UIClassParam", (Object)cond.toMap().toString());
        uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)cond);
        return uiContext;
    }

    private AsstactTypeEntity getSelectedAsstactType(IRow row, GLRptAssistBalanceCondition oldCond) {
        AsstactTypeEntity at;
        block1: {
            at = null;
            if (row.getCell("FActTypefId").getValue() == null) break block1;
            String asstTypeId = (String)row.getCell("FActTypefId").getValue();
            Iterator it = oldCond.getAsstActList().iterator();
            while (it.hasNext() && !(at = (AsstactTypeEntity)it.next()).getId().equals(asstTypeId)) {
            }
        }
        return at;
    }

    private void setLinkedCurrency(IRow row, GLRptAsstactGDCondition cond) {
        RptConditionManager.ComponentStatus jbxCurrency = new RptConditionManager.ComponentStatus();
        jbxCurrency.setName("jbxCurrency");
        jbxCurrency.setEnabled(true);
        if (row.getCell("FCurrencyID") != null && row.getCell("FCurrencyID").getValue() != null) {
            cond.setCurrencyID((String)row.getCell("FCurrencyID").getValue());
            cond.setCurrencyName((String)row.getCell("currencyName").getValue());
        }
    }

    private void setLinkedAccount(IRow row, GLRptAsstactGDCondition cond) {
        AccountViewInfo av = null;
        String accountId = (String)row.getCell("FAccountID").getValue();
        if (accountId != null) {
            av = new AccountViewInfo();
            av.setId(BOSUuid.read((String)accountId));
            av.setNumber((String)row.getCell("accountNumber").getValue());
            av.setName((String)row.getCell("accountName").getValue());
            cond.setAccountId(accountId);
            cond.setAccountCodeStart((String)row.getCell("accountNumber").getValue());
            cond.setAccountCodeEnd((String)row.getCell("accountNumber").getValue());
            cond.setAccountViewStart(av);
            cond.setAccountViewEnd(av);
        }
    }

    private List getAsstactTypes(IRow row, GLRptAssistBalanceCondition oldCond) {
        AsstactTypeEntity at = this.getSelectedAsstactType(row, oldCond);
        if (at == null) {
            return null;
        }
        AsstactTypeEntity joinAt = this.getJoinAsstactType(row, at);
        ArrayList<AsstactTypeEntity> actList = new ArrayList<AsstactTypeEntity>();
        actList.add(joinAt);
        return actList;
    }

    private AsstactTypeEntity getJoinAsstactType(IRow row, AsstactTypeEntity at) {
        AsstactTypeEntity joinAt = new AsstactTypeEntity();
        joinAt.setId(at.getId());
        joinAt.setName(at.getName());
        joinAt.setNumber(at.getNumber());
        joinAt.setEnabledPermissionLimit(at.isEnabledPermissionLimit());
        joinAt.setForCompany(at.isForCompany());
        joinAt.setFrom(at.getFrom());
        joinAt.setTo(at.getTo());
        joinAt.setGeneralAsstactGroupId(at.getGeneralAsstactGroupId());
        joinAt.setGroupField(at.getGroupField());
        joinAt.setGroupTable(at.getGroupTable());
        joinAt.setHgAttribute(at.getHgAttribute());
        joinAt.setHgField(at.getHgField());
        joinAt.setPermissionItem(at.getPermissionItem());
        joinAt.setQueryName(at.getQueryName());
        joinAt.setSelected(true);
        joinAt.setTableName(at.getTableName());
        joinAt.setUseLongNumber(at.isUseLongNumber());
        joinAt.setCollect(at.getCollect());
        joinAt.setQtyAsst(at.isQtyAsst());
        if (row.getCell("FAsstItemId").getValue() != null) {
            String itemID = (String)row.getCell("FAsstItemId").getValue();
            DataBaseDInfo asstItem = new DataBaseDInfo();
            asstItem.setString("number", (String)row.getCell("itemNumber").getValue());
            asstItem.setString("id", itemID);
            asstItem.setString("name", (String)row.getCell("itemName").getValue());
            joinAt.setFrom(asstItem);
            joinAt.setTo(asstItem);
        }
        return joinAt;
    }

    @Override
    protected IGLRptBaseFacade getIGLRptFacade() throws BOSException {
        return GLRptAssistBalanceFacadeFactory.getRemoteInstance();
    }

    @Override
    protected String getPrintConfigUIName() {
        return "com.kingdee.eas.fi.gl.rpt.client.GLRptAssistBalancePrintConfigUI";
    }

    @Override
    protected GLRptBasePrintConfig getPrintConfig() {
        return new GLRptAssistBalancePrintConfig(this);
    }

    @Override
    protected BOSQueryDelegate getPrintQueryDelegate(GLRptRowSet rs, GLRptBaseCondition cond, GLRptBasePrintConfig config) throws EASBizException, BOSException {
        return new GLRptAssistBalancePrintDelegate(rs, this.getPrintVar(cond), config);
    }

    protected Map getPrintVar(GLRptBaseCondition cond) {
        HashMap<String, Object> printParams = new HashMap<String, Object>();
        printParams.put("company", cond.getCompany());
        printParams.put("asstActParame", this.getAsstactName().toString());
        printParams.put("currencyId", cond.getCurrencyID());
        printParams.put("CurrencyName", cond.getCurrencyName());
        printParams.put("mapPeriod", this.lblPeriod.getText());
        return printParams;
    }

    private String getAsstactName() {
        GLRptAssistBalanceCondition cond = (GLRptAssistBalanceCondition)this.getQueryCond();
        Iterator actIt = cond.getAsstActList().iterator();
        StringBuffer actTypeNames = new StringBuffer();
        actTypeNames.append(((AsstactTypeEntity)actIt.next()).getName());
        while (actIt.hasNext()) {
            actTypeNames.append(",").append(((AsstactTypeEntity)actIt.next()).getName());
        }
        return actTypeNames.toString();
    }

    @Override
    protected Map preparePrintVariantMap() {
        Map var = super.preparePrintVariantMap();
        var.put("Asstact", this.getAsstactName());
        return var;
    }

    @Override
    protected void preparePrintPageHeader(HeadFootModel header) {
        super.preparePrintPageHeader(header);
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"Item_Label"));
        sb.append("&[Asstact]");
        header.addRow(sb.append("&|").toString(), sa);
    }

    @Override
    protected List getCommonPrintButtons() {
        ArrayList<GLRptCommonItemInfo> list = new ArrayList<GLRptCommonItemInfo>();
        list.add(new GLRptCommonItemInfo(PrintButtonEnum.CompanyArea, new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"SelectedCompany"), EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"AllCompany")}));
        return list;
    }

    @Override
    protected String getPermissionItem() {
        return "gl_rptAsstactBalanceUI_view";
    }

    @Override
    protected String getExportPermissionItem() {
        return "gl_rptAsstactBalanceUI_export";
    }

    @Override
    protected GLRptExcelExporter getExporter(Map<String, Object> params) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("Period", this.lblPeriod.getText());
        params.put("Currency", this.lblCurrency.getText());
        return new GLRptAssistBalanceExcelExporter(params);
    }
}

