/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptPrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptAsstActTypeBalancePrintDelegate
extends AbstractGLRptPrintDelegate {
    private static final Logger logger = Logger.getLogger(GLRptAsstActTypeBalancePrintDelegate.class);
    public static final String[][] col = new String[][]{{"SysDateTime", ""}, {"CurrentUser", ""}, {"AccountLevel", ""}, {"Company", ""}, {"Currency", ""}, {"Period", ""}, {"accountNumber", "accountNumber"}, {"accountName", "accountName"}, {"asstName1", "FName1"}, {"asstName2", "FName2"}, {"asstName3", "FName3"}, {"asstName4", "FName4"}, {"asstName5", "FName5"}, {"asstName6", "FName6"}, {"asstName7", "FName7"}, {"asstName8", "FName8"}, {"asstNumber1", "FNumber1"}, {"asstNumber2", "FNumber2"}, {"asstNumber3", "FNumber3"}, {"asstNumber4", "FNumber4"}, {"asstNumber5", "FNumber5"}, {"asstNumber6", "FNumber6"}, {"asstNumber7", "FNumber7"}, {"asstNumber8", "FNumber8"}, {"asstactTypes", "asstactTypes"}, {"asstactType1", "asstactType1"}, {"asstactType2", "asstactType2"}, {"asstactType3", "asstactType3"}, {"asstactType4", "asstactType4"}, {"asstactType5", "asstactType5"}, {"asstactType6", "asstactType6"}, {"asstactType7", "asstactType7"}, {"asstactType8", "asstactType8"}, {"beginQty", "FBeginQty"}, {"beginDebitQty", "FBeginDebitQty"}, {"beginBalanceDebitFor", "FBeginDebitBalanceFor"}, {"beginBalanceDebitLocal", "FBeginDebitBalanceLocal"}, {"beginBalanceDebitRpt", "FBeginDebitBalanceRpt"}, {"beginCreditQty", "FBeginCreditQty"}, {"beginBalanceCreditFor", "FBeginCreditBalanceFor"}, {"beginBalanceCreditLocal", "FBeginCreditBalanceLocal"}, {"beginBalanceCreditRpt", "FBeginCreditBalanceRpt"}, {"debitQty", "FDebitQty"}, {"debitFor", "FDebitFor"}, {"debitLocal", "FDebitLocal"}, {"debitRpt", "FDebitRpt"}, {"creditQty", "FCreditQty"}, {"creditFor", "FCreditFor"}, {"creditLocal", "FCreditLocal"}, {"creditRpt", "FCreditRpt"}, {"yearDebitQty", "FYearDebitQty"}, {"yearDebitFor", "FYearDebitFor"}, {"yearDebitLocal", "FYearDebitLocal"}, {"yearDebitRpt", "FYearDebitRpt"}, {"yearCreditQty", "FYearCreditQty"}, {"yearCreditFor", "FYearCreditFor"}, {"yearCreditLocal", "FYearCreditLocal"}, {"yearCreditRpt", "FYearCreditRpt"}, {"endQty", "FEndQty"}, {"endDebitQty", "FEndDebitQty"}, {"endBalanceDebitFor", "FEndDebitBalanceFor"}, {"endBalanceDebitLocal", "FEndDebitBalanceLocal"}, {"endBalanceDebitRpt", "FEndDebitBalanceRpt"}, {"endCreditQty", "FEndCreditQty"}, {"endBalanceCreditFor", "FEndCreditBalanceFor"}, {"endBalanceCreditLocal", "FEndCreditBalanceLocal"}, {"endBalanceCreditRpt", "FEndCreditBalanceRpt"}};
    protected GLRptRowSet rs;
    private CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
    protected GLRptBasePrintConfig config;
    Map<String, Object> vars;

    public GLRptAsstActTypeBalancePrintDelegate(GLRptRowSet rs, Map<String, Object> vars, GLRptBasePrintConfig config) {
        this.rs = rs;
        this.vars = vars;
        if (vars.get("company") != null && vars.get("company") instanceof CompanyOrgUnitInfo) {
            this.curCompany = (CompanyOrgUnitInfo)vars.get("company");
        }
        this.config = config;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        return this.getRowSet();
    }

    public IRowSet getRowSet() {
        DateFormat format = GlUtils.getDateFormat();
        HashMap hmParamValue = new HashMap();
        try {
            hmParamValue = this.getInitParam(this.curCompany);
        }
        catch (EASBizException e1) {
            logger.error((Object)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        boolean isImp = hmParamValue.get("GL_059") == null || Boolean.valueOf(hmParamValue.get("GL_059").toString()) != false;
        int qtyScale = 2;
        if (hmParamValue.get("GL_002") != null) {
            qtyScale = Integer.parseInt(hmParamValue.get("GL_002").toString());
        }
        boolean showQty = this.vars.get("showQty") != null && (Boolean)this.vars.get("showQty") != false;
        DynamicRowSet drs = null;
        try {
            CurrencyInfo baseCurrency = this.curCompany.getBaseCurrency();
            baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            CurrencyInfo rptCurrency = this.curCompany.getReportCurrency();
            if (rptCurrency != null) {
                rptCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(rptCurrency.getId()));
            }
            String currencyId = (String)this.vars.get("currencyId");
            CurrencyInfo currency = null;
            if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                currency = baseCurrency;
            } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                currency = rptCurrency;
            } else if (!currencyId.equalsIgnoreCase("AllCurrency")) {
                currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            }
            boolean isBaseCurrency = currency != null && baseCurrency.getId().equals((Object)currency.getId());
            boolean isGBaseCy = currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC");
            boolean isGRptCy = currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC");
            int colCount = col.length;
            drs = this.createDynamicRowSet(colCount);
            this.rs.beforeFirst();
            while (this.rs.next()) {
                drs.moveToInsertRow();
                GLRptAsstActTypeBalancePrintDelegate.clearRow((IRowSet)drs);
                drs.updateString("SysDateTime", GlUtils.formatDate(format, new Date()));
                UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
                if (user.getName() != null) {
                    drs.updateString("CurrentUser", user.getName());
                } else {
                    drs.updateString("CurrentUser", user.toString());
                }
                drs.updateString("AccountLevel", this.vars.get("mapAccountLevel").toString());
                drs.updateString("Company", this.curCompany.getName());
                drs.updateString("Currency", this.vars.get("mapCurrency").toString());
                drs.updateString("Period", this.vars.get("mapPeriod").toString());
                List asstTypeNumAndNameMaps = (List)this.vars.get("asstTypeList");
                if (asstTypeNumAndNameMaps != null && !asstTypeNumAndNameMaps.isEmpty()) {
                    int index = 1;
                    StringBuilder namesStr = new StringBuilder();
                    for (AsstactTypeEntity asstTypeNumAndNameMap : asstTypeNumAndNameMaps) {
                        drs.updateString("asstactType" + index, asstTypeNumAndNameMap.getName());
                        namesStr.append('-');
                        namesStr.append(asstTypeNumAndNameMap.getName());
                        String hgFileName = asstTypeNumAndNameMap.getHgAttribute();
                        String hgFullName = hgFileName + "Name";
                        String hgFullNumber = hgFileName + "Number";
                        if (this.rs.getObject(hgFullName) != null) {
                            drs.updateString("asstName" + index, this.rs.getObject(hgFullName).toString());
                        }
                        if (this.rs.getObject(hgFullNumber) != null) {
                            drs.updateString("asstNumber" + index, this.rs.getString(hgFullNumber));
                        }
                        ++index;
                    }
                    if (namesStr.length() > 0) {
                        namesStr.deleteCharAt(0);
                    }
                    drs.updateString("asstactTypes", namesStr.toString());
                } else {
                    logger.error((Object)"print param 'asstTypeList' is null", (Throwable)new Exception(""));
                }
                int precision = 0;
                if (currency == null) {
                    Object currencyPre = this.rs.getObject("currencyPre");
                    if (currencyPre != null) {
                        precision = Integer.parseInt(currencyPre.toString());
                    }
                } else {
                    precision = currency.getPrecision();
                }
                for (int i = 6; i < col.length; ++i) {
                    if (this.rs.indexOf(col[i][1]) == -1 || "FYearBeginQty".equals(col[i][1]) || "FBeginQty".equals(col[i][1]) || "FEndQty".equals(col[i][1])) continue;
                    Object objValue = this.rs.getObject(col[i][1]);
                    if (objValue != null) {
                        if (objValue.getClass() != BigDecimal.class) {
                            String[] a;
                            if (col[i][1].startsWith("FName") && !isImp && (a = objValue.toString().trim().split(":")).length > 1) {
                                StringBuilder sbE = new StringBuilder();
                                int r = a.length - 1;
                                for (int k = 0; k <= r; ++k) {
                                    if (k == 0) continue;
                                    sbE.append(a[k]).append(":");
                                }
                                sbE.deleteCharAt(sbE.length() - 1);
                                objValue = sbE.toString();
                            }
                            drs.updateString(col[i][0], objValue.toString());
                            continue;
                        }
                        if (((BigDecimal)objValue).compareTo(new BigDecimal("0")) == 0) {
                            drs.updateString(col[i][0], "");
                            continue;
                        }
                        BigDecimal value = (BigDecimal)objValue;
                        if (col[i][0].toLowerCase().endsWith("local")) {
                            drs.updateString(col[i][0], GlUtils.withComma(value, baseCurrency.getPrecision()));
                            if (!isGBaseCy) continue;
                            drs.updateString(col[i][0].substring(0, col[i][0].length() - 5) + "for", GlUtils.withComma((BigDecimal)objValue, baseCurrency.getPrecision()));
                            continue;
                        }
                        if (rptCurrency != null && col[i][0].toLowerCase().endsWith("rpt")) {
                            drs.updateString(col[i][0], GlUtils.withComma(value, rptCurrency.getPrecision()));
                            if (!isGRptCy) continue;
                            drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "for", GlUtils.withComma(value, rptCurrency.getPrecision()));
                            continue;
                        }
                        if (col[i][0].toLowerCase().endsWith("for")) {
                            drs.updateString(col[i][0], GlUtils.withComma(value, precision));
                            if (!isBaseCurrency) continue;
                            drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "local", GlUtils.withComma(value, precision));
                            continue;
                        }
                        if (col[i][1].endsWith("Qty")) {
                            drs.updateString(col[i][0], GlUtils.withComma(value, qtyScale));
                            continue;
                        }
                        drs.updateString(col[i][0], value.toString());
                        continue;
                    }
                    drs.updateString(col[i][0], "");
                }
                if (showQty) {
                    BigDecimal beginQty = this.getBigDecimal(this.rs, "FBeginDebitQty").subtract(this.getBigDecimal(this.rs, "FBeginCreditQty"));
                    drs.updateString("beginQty", beginQty.doubleValue() == 0.0 ? "" : GlUtils.withComma(beginQty, qtyScale));
                    BigDecimal endQty = this.getBigDecimal(this.rs, "FEndDebitQty").subtract(this.getBigDecimal(this.rs, "FEndCreditQty"));
                    drs.updateString("endQty", endQty.doubleValue() == 0.0 ? "" : GlUtils.withComma(endQty, qtyScale));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return drs;
    }

    private BigDecimal getBigDecimal(GLRptRowSet rs, String field) throws BOSException {
        BigDecimal amount = rs.getBigDecimal(field);
        if (amount == null) {
            return GlUtils.zero;
        }
        return amount;
    }

    private DynamicRowSet createDynamicRowSet(int colCount) throws SQLException {
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 0; i < colCount; ++i) {
            ColInfo ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = col[i][0];
            ci.nullable = 1;
            drs.setColInfo(i + 1, ci);
        }
        return drs;
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private HashMap getInitParam(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)String.valueOf(company.getId())));
        HashMap<String, ObjectUuidPK> sysParams = new HashMap<String, ObjectUuidPK>();
        sysParams.put("GL_059", comPK);
        sysParams.put("GL_002", comPK);
        return ParamControlFactory.getRemoteInstance().getParamHashMap(sysParams);
    }
}

