/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.client.AuxAccountF7Filter;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ParamEx;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLEditor;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.KDSpinnerCellEditor;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.IGLRptAsstactBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptAsstactBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.fi.gl.rpt.client.GeneralBizPromptBox;
import com.kingdee.eas.fi.gl.rpt.client.GroupAsstItemSelectorListener;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.IntEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JScrollBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public abstract class GLRptAsstactBaseQueryUI
extends AbstractGLRptAsstactBaseQueryUI {
    private static final long serialVersionUID = -4490798998712040380L;
    private static final String commonSorterRes = "com.kingdee.eas.base.commonquery.client.CommonSorterPanel";
    public static final Color LOCKCOLOR = new Color(228, 228, 228);
    private static final int asstTypeMaxLevel = 100;
    private static final Logger logger = CoreUIObject.getLogger(GLRptAsstactBaseQueryUI.class);
    private Map<Integer, GeneralBizPromptBox> isBasicInfos = new HashMap<Integer, GeneralBizPromptBox>();

    public GLRptAsstactBaseQueryUI() throws Exception {
        this.tbl.checkParsed();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        AuxAccountF7Filter.setFilter((KDBizPromptBox)this.jebAcct);
        this.initAcctTable();
        this.kDPanel1.setVisible(false);
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.chkFilterByCat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GLRptAsstactBaseQueryUI.this.showGroup(e.getStateChange() == 1);
            }
        });
        this.tbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                IRow row = GLRptAsstactBaseQueryUI.this.tbl.getRow(e.getRowIndex());
                if ("collect".equals(GLRptAsstactBaseQueryUI.this.tbl.getColumnKey(e.getColIndex()))) {
                    CollectEnum collect = (CollectEnum)((Object)e.getValue());
                    if (collect == CollectEnum.UP) {
                        GLRptAsstactBaseQueryUI.this.unLockMaxLevel(row, 1);
                    } else {
                        GLRptAsstactBaseQueryUI.this.lockMaxLevel(row);
                    }
                }
            }

            public void editValueChanged(KDTEditEvent e) {
                try {
                    IRow row = GLRptAsstactBaseQueryUI.this.tbl.getRow(e.getRowIndex());
                    if ("selected".equals(GLRptAsstactBaseQueryUI.this.tbl.getColumnKey(e.getColIndex()))) {
                        boolean selected = (Boolean)e.getValue();
                        GLRptAsstactBaseQueryUI.this.setAsstF7(row);
                        AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
                        at.setSelected(selected);
                        row.getCell("selected").setValue((Object)selected);
                        GLRptAsstactBaseQueryUI.this.setAccountF7Filter(row, selected);
                        if (!selected) {
                            row.getCell("to").getStyleAttributes().setLocked(true);
                            row.getCell("from").getStyleAttributes().setLocked(true);
                            row.getCell("dist").getStyleAttributes().setLocked(true);
                        }
                    }
                }
                catch (Exception ex) {
                    GLRptAsstactBaseQueryUI.this.handUIException(ex);
                }
            }
        });
    }

    protected void setAccountF7Filter(IRow row, boolean selected) {
        if (selected) {
            this.setAccountTemp();
        }
        this.setAccountF7Filter();
    }

    protected void showGroup(boolean visible) {
        this.tbl.getColumn("group").getStyleAttributes().setHided(!visible);
    }

    protected void initAcctTable() throws EASBizException, BOSException {
        this.kdUp.setText(null);
        this.kdUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.kdUp.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveUp"));
        this.kdDown.setText(null);
        this.kdDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.kdDown.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveDown"));
        this.showGroup(false);
        this.tbl.getSelectManager().setSelectMode(1);
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.tbl.getColumn("selected").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.tbl.getColumn("selected").setRenderer((IBasicRender)new CellCheckBoxRenderer());
        this.tbl.getColumn("group").getStyleAttributes().setLocked(true);
        this.tbl.getColumn("group").getStyleAttributes().setBackground(LOCKCOLOR);
        BizDataFormat groupFormat = new BizDataFormat("$number$ $name$");
        ObjectValueRender groupRender = new ObjectValueRender();
        groupRender.setFormat((IDataFormat)groupFormat);
        this.tbl.getColumn("group").setRenderer((IBasicRender)groupRender);
        this.tbl.getColumn("collect").setEditor(GLEditor.getComboBox(CollectEnum.getEnumList()));
        if (!this.getCurrCompany().isIsBizUnit() && this.isSupportUnion()) {
            this.fillTableAcctType(null, false);
        }
        this.setTableKeyBoardManager(this.tbl);
    }

    protected void setAsstF7(IRow row) {
        CompanyOrgUnitInfo[] filterCompany;
        CompanyOrgUnitInfo[] companyOrgUnitInfoArray;
        row.getCell("to").getStyleAttributes().setLocked(false);
        row.getCell("from").getStyleAttributes().setLocked(false);
        row.getCell("dist").getStyleAttributes().setLocked(false);
        AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
        AsstActTypeInfo atInfo = new AsstActTypeInfo();
        atInfo.setAsstHGAttribute(at.getHgAttribute());
        atInfo.setIsForCompany(at.isForCompany());
        atInfo.setUseLongNumber(at.isUseLongNumber());
        if (at.getGeneralAsstactGroupId() != null && at.getGeneralAsstactGroupId().trim().length() > 0) {
            GeneralAsstActTypeGroupInfo groupInfo = new GeneralAsstActTypeGroupInfo();
            groupInfo.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
            atInfo.setGlAsstActTypeGrp(groupInfo);
        }
        GLF7Parameter f7Param = new GLF7Parameter();
        try {
            boolean chooseAsstByCompany = Boolean.parseBoolean(GlUtils.getParamByKey(null, this.getCurrCompany().getId().toString(), "GL_069").toString());
            f7Param.setAttribute((Object)"chooseAsstByCompany", (Object)chooseAsstByCompany);
            boolean GL043 = Boolean.parseBoolean(GlUtils.getParamByKey(null, this.getCurrCompany().getId().toString(), "GL_043").toString());
            f7Param.setAttribute((Object)"GL043", (Object)GL043);
        }
        catch (Exception chooseAsstByCompany) {
            // empty catch block
        }
        f7Param.setOnlyLeaf(false);
        KDBizPromptBox toBizPromptBox = new KDBizPromptBox();
        toBizPromptBox.setEditable(true);
        toBizPromptBox.setEditFormat("$number$");
        toBizPromptBox.setCommitFormat("$number$;$name$");
        toBizPromptBox.setDisplayFormat("$number$ - $name$");
        toBizPromptBox.setQueryInfo(at.getQueryName());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isUseLongNumber() || at.isUseLevel()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        toBizPromptBox.setSelectorCollection(sic);
        f7Param.setUnUse(true);
        if (at.isGeneralActType() && !this.isMultiCompanyF7()) {
            CompanyOrgUnitInfo[] companyOrgUnitInfoArray2 = new CompanyOrgUnitInfo[1];
            companyOrgUnitInfoArray = companyOrgUnitInfoArray2;
            companyOrgUnitInfoArray2[0] = this.getCurrCompany();
        } else {
            companyOrgUnitInfoArray = filterCompany = this.getCompanys();
        }
        if (!at.isGeneralActType() && !this.getCurrCompany().isIsBizUnit()) {
            atInfo.put("isSetMainBizOrg", (Object)false);
        }
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)toBizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo[])filterCompany, (GLF7Parameter)f7Param);
        toBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = GLRptAsstactBaseQueryUI.this.tbl.getSelectManager().get().getBeginRow();
                    IRow row = GLRptAsstactBaseQueryUI.this.tbl.getRow(beginRow);
                    GLRptAsstactBaseQueryUI.this.fireDataChange(e, row, "to", "from");
                }
                catch (Exception exc) {
                    GLRptAsstactBaseQueryUI.this.handUIException(exc);
                }
            }
        });
        row.getCell("to").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)toBizPromptBox));
        KDBizPromptBox fromBizPromptBox = new KDBizPromptBox();
        fromBizPromptBox.setEditable(true);
        fromBizPromptBox.setEditFormat("$number$");
        fromBizPromptBox.setCommitFormat("$number$;$name$");
        fromBizPromptBox.setDisplayFormat("$number$ - $name$");
        fromBizPromptBox.setQueryInfo(at.getQueryName());
        fromBizPromptBox.setSelectorCollection(sic);
        if (atInfo.getGlAsstActTypeGrp() != null) {
            try {
                CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("company");
                boolean showLongNumber = Boolean.parseBoolean(GlUtils.getParamByKey(null, currentCompany.getId().toString(), "GL_064").toString());
                if (showLongNumber) {
                    toBizPromptBox.setNeedConvert(true);
                    fromBizPromptBox.setNeedConvert(true);
                }
            }
            catch (Exception currentCompany) {
                // empty catch block
            }
        }
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)fromBizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo[])filterCompany, (GLF7Parameter)f7Param);
        fromBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = GLRptAsstactBaseQueryUI.this.tbl.getSelectManager().get().getBeginRow();
                    IRow row = GLRptAsstactBaseQueryUI.this.tbl.getRow(beginRow);
                    GLRptAsstactBaseQueryUI.this.fireDataChange(e, row, "from", "to");
                }
                catch (Exception exc) {
                    GLRptAsstactBaseQueryUI.this.handUIException(exc);
                }
            }
        });
        row.getCell("from").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)fromBizPromptBox));
        fromBizPromptBox.addSelectorListener((SelectorListener)new GroupAsstItemSelectorListener(this.chkFilterByCat, row.getCell("group"), at.getHgAttribute()));
        toBizPromptBox.addSelectorListener((SelectorListener)new GroupAsstItemSelectorListener(this.chkFilterByCat, row.getCell("group"), at.getHgAttribute()));
        KDBizPromptBox disBox = this.loadDistBox(row, fromBizPromptBox, null);
        disBox.addSelectorListener((SelectorListener)new GroupAsstItemSelectorListener(this.chkFilterByCat, row.getCell("group"), at.getHgAttribute()));
    }

    public void fireDataChange(DataChangeEvent e, IRow row, String curCol, String oppCol) throws BOSException {
        Object opp;
        AsstactTypeEntity asst;
        Object old;
        KDBizPromptBox fromBox = (KDBizPromptBox)e.getSource();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo newFilter = new FilterInfo();
        Object cur = e.getNewValue();
        Object object = old = e.getOldValue() == null ? row.getCell(curCol).getValue() : e.getOldValue();
        if (cur instanceof IObjectValue && old instanceof IObjectValue) {
            String id = ((IObjectValue)cur).get("id").toString();
            String oid = ((IObjectValue)old).get("id").toString();
            if (id != null && id.equals(oid)) {
                return;
            }
        }
        Object obj = row.getUserObject();
        String compareExpr = "number";
        if (obj instanceof AsstactTypeEntity && (asst = (AsstactTypeEntity)obj).isGeneralActType()) {
            compareExpr = "longnumber";
        }
        CompareType fromCompare = CompareType.GREATER_EQUALS;
        CompareType toCompare = CompareType.LESS_EQUALS;
        if ("to".equals(curCol)) {
            fromCompare = CompareType.LESS_EQUALS;
            toCompare = CompareType.GREATER_EQUALS;
        }
        if (cur instanceof IObjectValue) {
            newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)cur).get(compareExpr).toString().replace("!", "."), fromCompare));
        }
        if ((opp = row.getCell(oppCol).getValue()) instanceof IObjectValue) {
            newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)opp).get(compareExpr).toString().replace("!", "."), toCompare));
        } else if (cur != null) {
            row.getCell(oppCol).setValue(cur);
            newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)cur).get(compareExpr).toString().replace("!", "."), toCompare));
        }
        if (fromBox.getEntityViewInfo() != null) {
            newFilter.mergeFilter(fromBox.getEntityViewInfo().getFilter(), "and");
        }
        view.setFilter(newFilter);
        if (obj instanceof AsstactTypeEntity) {
            AsstactTypeEntity asst2 = (AsstactTypeEntity)obj;
            if ("from".equals(curCol)) {
                asst2.setFrom(cur);
            }
            if ("to".equals(curCol)) {
                asst2.setTo(cur);
            }
        }
        this.loadDistBox(row, fromBox, view);
        if (null != this.tbl.getRow(0).getCell("group") && null != this.tbl.getRow(0).getCell("group").getValue()) {
            Object[] groups = (Object[])this.tbl.getRow(0).getCell("group").getValue();
            this.checkGroupStandIsBasic(groups);
        }
    }

    private int getTblCurIndex() {
        int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tbl);
        return rowIndexs[0];
    }

    public KDBizPromptBox loadDistBox(IRow row, KDBizPromptBox bizBox, EntityViewInfo view) {
        KDBizPromptBox disBox = new KDBizPromptBox();
        disBox.setEditFormat("$number$");
        disBox.setDisplayFormat("$name$");
        disBox.setCommitFormat("$number$");
        disBox.setEditable(false);
        disBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = GLRptAsstactBaseQueryUI.this.tbl.getSelectManager().get().getBeginRow();
                    IRow row = GLRptAsstactBaseQueryUI.this.tbl.getRow(beginRow);
                    Object dist = e.getNewValue();
                    if (dist == null) {
                        AsstactTypeEntity entry = (AsstactTypeEntity)row.getUserObject();
                        entry.setDist(null);
                        row.getCell("dist").setUserObject(null);
                    }
                }
                catch (Exception exc) {
                    GLRptAsstactBaseQueryUI.this.handUIException(exc);
                }
            }
        });
        if (view == null) {
            view = bizBox.getEntityViewInfo();
            if (view != null) {
                view = (EntityViewInfo)view.clone();
            }
            view = this.getDefaultView(row, view);
        }
        disBox.setEntityViewInfo(view);
        int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tbl);
        GeneralBizPromptBox generalBizPromptBox = new GeneralBizPromptBox(view, bizBox.getQueryInfo(), this.tbl, "com.kingdee.eas.fi.gl.rpt.client.FilterForAssistF7UI");
        if (rowIndexs.length > 0) {
            this.isBasicInfos.put(rowIndexs[0], generalBizPromptBox);
        }
        generalBizPromptBox.setRow(row);
        disBox.setSelector((KDPromptSelector)generalBizPromptBox);
        row.getCell("dist").setValue(null);
        row.getCell("dist").setUserObject(null);
        row.getCell("dist").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)disBox));
        return disBox;
    }

    private EntityViewInfo getDefaultView(IRow row, EntityViewInfo view) {
        Object to;
        Object from;
        AsstactTypeEntity at;
        if (view == null || view.getFilter() == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = view.getFilter();
        FilterInfo newFilter = new FilterInfo();
        Object obj = row.getUserObject();
        String compareExpr = "number";
        if (obj instanceof AsstactTypeEntity && (at = (AsstactTypeEntity)obj).isGeneralActType()) {
            compareExpr = "longnumber";
        }
        if ((from = row.getCell("from").getValue()) instanceof IObjectValue && ((IObjectValue)from).get(compareExpr) != null) {
            newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.GREATER_EQUALS));
        }
        if ((to = row.getCell("to").getValue()) instanceof IObjectValue && ((IObjectValue)to).get(compareExpr) != null) {
            newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)to).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
        }
        try {
            newFilter.mergeFilter(filter, "and");
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        view.setFilter(newFilter);
        return view;
    }

    @Override
    public void setCustomCondition(GLRptBaseCondition condition) throws EASBizException, BOSException {
        super.setCustomCondition(condition);
        GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)condition;
        if (cond == null) {
            return;
        }
        this.chkFilterByCat.setSelected(cond.isFilterByCat());
        try {
            AsstAccountInfo asstAccount = null;
            if (cond.getAsstAccountId() != null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("name"));
                selector.add(new SelectorItemInfo("number"));
                asstAccount = AsstAccountFactory.getRemoteInstance().getAsstAccountInfo((IObjectPK)new ObjectUuidPK(cond.getAsstAccountId()), selector);
            }
            this.jebAcct.setValue(asstAccount);
            this.showGroup(cond.isFilterByCat());
            this.setAsstactTypeList(cond.getAsstActList());
            this.setAccountF7Filter();
            this.setAccountCondition(cond);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected FilterInfo getAccountFilter() {
        FilterInfo filter = super.getAccountFilter();
        AsstAccountInfo acct = (AsstAccountInfo)this.jebAcct.getValue();
        FilterInfo caaFilter = new FilterInfo();
        if (acct != null) {
            caaFilter.getFilterItems().add(new FilterItemInfo("CAA.id", (Object)acct.getId().toString()));
            StringBuffer sql = new StringBuffer();
            sql.append("select FAccountID ");
            sql.append("From T_BD_AsstAccountChange aac ");
            sql.append("where aac.FBeforeID = '" + acct.getId().toString() + "' ");
            caaFilter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            caaFilter.setMaskString("#0 or #1");
            try {
                filter.mergeFilter(caaFilter, "and");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            HashMap<String, Integer> counter = new HashMap<String, Integer>();
            int count = 0;
            for (int i = 0; i < this.tbl.getRowCount(); ++i) {
                IRow row = this.tbl.getRow(i);
                Boolean selected = (Boolean)row.getCell("selected").getValue();
                AsstactTypeEntity at = (AsstactTypeEntity)this.tbl.getRow(i).getUserObject();
                if (selected == null || !selected.booleanValue()) continue;
                ++count;
                for (int j = 0; j < at.getAsstAccountCount(); ++j) {
                    String caaId = at.getAsstAccountId(j);
                    if (counter.containsKey(caaId)) {
                        counter.put(caaId, (Integer)counter.get(caaId) + 1);
                        continue;
                    }
                    counter.put(caaId, 1);
                }
            }
            HashSet<String> asstAccIdSet = new HashSet<String>();
            for (String caaId : counter.keySet()) {
                if ((Integer)counter.get(caaId) != count) continue;
                asstAccIdSet.add(caaId);
            }
            if (!asstAccIdSet.isEmpty()) {
                caaFilter.getFilterItems().add(new FilterItemInfo("CAA.id", asstAccIdSet, CompareType.INCLUDE));
                StringBuffer sql = new StringBuffer();
                sql.append("select FAccountID ");
                sql.append("From T_BD_AsstAccountChange aac ");
                sql.append("where aac.FBeforeID in " + SQLUtil.collection2InList(asstAccIdSet) + " ");
                caaFilter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
                caaFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(caaFilter, "and");
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        return filter;
    }

    @Override
    public GLRptBaseCondition getCustomCondition() {
        GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)super.getCustomCondition();
        cond.setShowAsstActSingle(this.singleAsstact.isSelected());
        AsstAccountInfo asstAccount = (AsstAccountInfo)this.jebAcct.getValue();
        cond.setAsstAccountId(asstAccount == null ? null : asstAccount.getId().toString());
        cond.setFilterByCat(this.chkFilterByCat.isSelected());
        ArrayList<AsstactTypeEntity> actList = new ArrayList<AsstactTypeEntity>();
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            Boolean selected = (Boolean)row.getCell("selected").getValue();
            if (selected == null || !selected.booleanValue()) continue;
            AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
            at.setSelected(true);
            Object[] groups = (Object[])row.getCell("group").getValue();
            if (groups != null) {
                at.setAsstGroup(this.getGroupIdsStr(groups));
                if (groups.length > 0) {
                    if ("customer".equalsIgnoreCase(at.getHgAttribute()) || "provider".equalsIgnoreCase(at.getHgAttribute())) {
                        at.setCat((IntEnum)((CSSPGroupInfo)groups[0]).getGroupStandard().getIsBasic());
                    } else if ("material".equalsIgnoreCase(at.getHgAttribute())) {
                        at.setCat((IntEnum)((MaterialGroupInfo)groups[0]).getGroupStandard().getStandardType());
                    }
                }
            } else {
                at.setAsstGroup(null);
                at.setCat(null);
            }
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            at.setDist(row.getCell("dist").getUserObject());
            at.setCollect((CollectEnum)((Object)row.getCell("collect").getValue()));
            if (at.getCollect() == CollectEnum.UP) {
                Integer maxLevel = (Integer)row.getCell("maxLevel").getValue();
                at.setSelectedLevel(maxLevel);
            }
            actList.add(at);
        }
        cond.setAsstActList(actList);
        return cond;
    }

    private String getGroupIdsStr(Object[] groups) {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < groups.length; ++i) {
            if (i > 0) {
                ids.append(",");
            }
            ids.append(((DataBaseInfo)groups[i]).getId().toString());
        }
        return ids.toString();
    }

    @Override
    protected void companyChanged() throws Exception {
        super.companyChanged();
        Object value = this.bpCompany.getValue();
        if (null != value && value.getClass().isArray() && ((Object[])value).length > 1) {
            this.getCustomCondition().setCompanysSelect(true);
        }
        boolean isEnable = value != null;
        this.jebAcct.setEnabled(isEnable);
        if (!isEnable) {
            this.jebAcct.setValue(null);
        }
        if (this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.merger || this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.enumerate) {
            if (this.getCompanys() == null) {
                AuxAccountF7Filter.setFilter((KDBizPromptBox)this.jebAcct);
            } else {
                AuxAccountF7Filter.setFilter((KDBizPromptBox)this.jebAcct, (CompanyOrgUnitInfo[])this.getCompanys());
            }
            if (this.jebAcct.getValue() != null) {
                this.jebAcct.setValue(null);
            } else {
                this.fillTableAcctType(null, false);
            }
        }
        this.fillTableAcctType(null, false);
    }

    protected void setAsstactTypeList(List asstactList) throws BOSException {
        if (asstactList == null) {
            return;
        }
        int index = 0;
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
            boolean found = false;
            AsstactTypeEntity actEntity = null;
            for (int j = 0; j < asstactList.size(); ++j) {
                actEntity = (AsstactTypeEntity)asstactList.get(j);
                if (!actEntity.getId().equals(at.getId()) || !actEntity.isSelected()) continue;
                this.tbl.removeRow(i);
                row = this.tbl.addRow(index < j ? index : j, row);
                ++index;
                found = true;
                break;
            }
            if (found) {
                row.getCell("to").getStyleAttributes().setLocked(false);
                row.getCell("from").getStyleAttributes().setLocked(false);
                row.getCell("dist").getStyleAttributes().setLocked(false);
                row.setUserObject((Object)actEntity);
                row.getCell("selected").setValue((Object)Boolean.TRUE);
                row.getCell("group").setValue((Object)this.getGroupInfo(actEntity.getHgAttribute(), actEntity.getAsstGroup()));
                row.getCell("from").setValue(actEntity.getFrom());
                row.getCell("to").setValue(actEntity.getTo());
                this.setAsstF7(row);
                this.loadDist(row, actEntity);
                row.getCell("collect").setValue((Object)actEntity.getCollect());
                if (actEntity.getCollect() == CollectEnum.UP) {
                    this.unLockMaxLevel(row, actEntity.getSelectedLevel());
                    continue;
                }
                this.lockMaxLevel(row);
                continue;
            }
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("from").setValue(null);
            row.getCell("from").getStyleAttributes().setLocked(true);
            row.getCell("to").setValue(null);
            row.getCell("to").getStyleAttributes().setLocked(true);
            row.getCell("dist").setValue(null);
            row.getCell("dist").getStyleAttributes().setLocked(true);
            row.getCell("collect").setValue((Object)CollectEnum.LEAF);
            this.lockMaxLevel(row);
        }
    }

    private void loadDist(IRow row, AsstactTypeEntity actEntity) {
        Object temp = actEntity.getDist();
        if (temp instanceof Set) {
            String asstName = "";
            AssistViewFilterInfo avf2 = null;
            for (AssistViewFilterInfo avf2 : (Set)temp) {
                asstName = asstName + avf2.getName() + ";";
            }
            if (!"".equals(asstName)) {
                ICell cell = row.getCell("dist");
                cell.setValue((Object)asstName);
                cell.setUserObject(temp);
            }
        }
    }

    private Object[] getGroupInfo(String hgAttribute, String groupIds) throws BOSException {
        if (groupIds == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("isLeaf"));
        view.getSelector().add(new SelectorItemInfo("groupStandard.id"));
        view.getSelector().add(new SelectorItemInfo("groupStandard.isBasic"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)groupIds, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection coll = null;
        if ("customer".equalsIgnoreCase(hgAttribute) || "provider".equalsIgnoreCase(hgAttribute)) {
            coll = CSSPGroupFactory.getRemoteInstance().getCollection(view);
        } else if ("material".equalsIgnoreCase(hgAttribute)) {
            coll = MaterialGroupFactory.getRemoteInstance().getCollection(view);
        }
        if (coll != null && !coll.isEmpty()) {
            return coll.toArray();
        }
        return null;
    }

    @Override
    protected void kdUp_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(-1);
    }

    @Override
    protected void kdDown_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(1);
    }

    private void moveRow(int offset) {
        if (this.tbl.getSelectManager().get() != null) {
            int r = this.tbl.getSelectManager().get().getTop();
            int newr = r + offset;
            if (r < 0 || newr < 0 || newr >= this.tbl.getRowCount()) {
                return;
            }
            IRow row = this.tbl.removeRow(r);
            this.tbl.addRow(newr, row);
            this.tbl.getSelectManager().select(newr, 0, newr, this.tbl.getColumnCount());
            this.tbl.getLayoutManager().scrollToShow(newr, 0);
        }
    }

    @Override
    protected void jebAcct_dataChanged(DataChangeEvent e) throws Exception {
        AsstAccountInfo asstAccount = (AsstAccountInfo)this.jebAcct.getValue();
        String asstAccountId = null;
        if (asstAccount != null) {
            asstAccountId = asstAccount.getId().toString();
        }
        this.fillTableAcctType(asstAccountId, asstAccountId != null);
        this.setAccountF7Filter();
        this.setAccountTemp();
    }

    private void fillTableAcctType(String asstAccountId, boolean selected) {
        List list = null;
        try {
            list = this.getAsstactTypeList(asstAccountId);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.tbl.removeRows();
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tbl.addRow();
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            row.getCell("selected").setValue((Object)(selected ? Boolean.TRUE : Boolean.FALSE));
            if ("customer".equalsIgnoreCase(at.getHgAttribute()) || "provider".equalsIgnoreCase(at.getHgAttribute()) || "Material".equalsIgnoreCase(at.getHgAttribute())) {
                this.unLockGroup(row, at.getHgAttribute());
            } else {
                this.lockGroup(row);
            }
            row.setUserObject((Object)at);
            if (selected) {
                this.setAsstF7(row);
            } else {
                row.getCell("to").getStyleAttributes().setLocked(true);
                row.getCell("from").getStyleAttributes().setLocked(true);
                row.getCell("dist").getStyleAttributes().setLocked(true);
            }
            row.getCell("asstact").setValue((Object)at.getName());
            row.getCell("collect").setValue((Object)CollectEnum.LEAF);
            if (at.isMultilevel() || at.isUseGroup()) {
                row.getCell("collect").getStyleAttributes().setLocked(false);
            } else {
                row.getCell("collect").getStyleAttributes().setLocked(true);
            }
            row.getCell("maxLevel").getStyleAttributes().setLocked(true);
            row.getCell("maxLevel").getStyleAttributes().setBackground(LOCKCOLOR);
        }
    }

    private void lockAsstCell(IRow row) {
        row.getCell("from").getStyleAttributes().setLocked(true);
        row.getCell("from").setEditor(null);
        row.getCell("to").getStyleAttributes().setLocked(true);
        row.getCell("to").setEditor(null);
        row.getCell("dist").getStyleAttributes().setLocked(true);
        row.getCell("dist").setEditor(null);
    }

    private void lockMaxLevel(IRow row) {
        row.getCell("maxLevel").getStyleAttributes().setLocked(true);
        row.getCell("maxLevel").getStyleAttributes().setBackground(LOCKCOLOR);
        row.getCell("maxLevel").setEditor(null);
        row.getCell("maxLevel").setValue(null);
    }

    private void unLockMaxLevel(IRow row, int level) {
        final ICell maxLevelCell = row.getCell("maxLevel");
        maxLevelCell.getStyleAttributes().setLocked(false);
        maxLevelCell.getStyleAttributes().setBackground(Color.WHITE);
        AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
        int maxLevel = this.getMaxLevel(at);
        SpinnerNumberModel sm = new SpinnerNumberModel(1, 1, maxLevel, 1);
        final KDSpinnerCellEditor sce = new KDSpinnerCellEditor(sm);
        sce.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                maxLevelCell.setValue(sce.getValue());
            }
        });
        maxLevelCell.setEditor((ICellEditor)sce);
        sm.setValue(new Integer(level));
        maxLevelCell.setValue((Object)new Integer(level));
        sce.setEditable(true);
        sce.setEnabled(true);
    }

    private int getMaxLevel(AsstactTypeEntity at) {
        int maxLevel = 100;
        try {
            SQLExecutor sqlExecutor = new SQLExecutor("select max(flevel) maxLevel from " + (at.isUseGroup() ? at.getGroupTable() : at.getTableName()));
            IRowSet rs = sqlExecutor.executeSQL();
            if (rs.next()) {
                maxLevel = rs.getInt("maxLevel");
                if (at.isUseGroup()) {
                    ++maxLevel;
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return maxLevel;
    }

    private void lockGroup(IRow row) {
        StyleAttributes sa = row.getCell("group").getStyleAttributes();
        sa.setLocked(true);
        sa.setBackground(LOCKCOLOR);
        sa.setPattern(Pattern.Solid);
    }

    private void unLockGroup(IRow row, String hgAttribute) {
        StyleAttributes sa = row.getCell("group").getStyleAttributes();
        sa.setLocked(false);
        sa.setBackground(Color.WHITE);
        sa.setPattern(Pattern.Solid);
        KDBizPromptBox groupPromptBox = new KDBizPromptBox();
        groupPromptBox.setEditable(true);
        groupPromptBox.setEditFormat("$number$");
        groupPromptBox.setDisplayFormat("$number$ - $name$");
        groupPromptBox.setCommitFormat("$number$");
        groupPromptBox.setEnabledMultiSelection(true);
        EntityViewInfo ev = new EntityViewInfo();
        if (hgAttribute.equalsIgnoreCase("customer")) {
            groupPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerGroupQuery");
        } else if (hgAttribute.equalsIgnoreCase("material")) {
            groupPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
        } else {
            groupPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierGroupQuery");
        }
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("name"));
        ev.getSelector().add(new SelectorItemInfo("isLeaf"));
        ev.getSelector().add(new SelectorItemInfo("groupStandard.id"));
        ev.getSelector().add(new SelectorItemInfo("groupStandard.name"));
        if (hgAttribute.equalsIgnoreCase("customer") || hgAttribute.equalsIgnoreCase("provider")) {
            ev.getSelector().add(new SelectorItemInfo("groupStandard.isBasic"));
            ev.getSorter().add(new SorterItemInfo("groupStandard.isBasic"));
            ev.getSelector().add(new SelectorItemInfo("longNumber"));
        } else if (hgAttribute.equalsIgnoreCase("material")) {
            ev.getSelector().add(new SelectorItemInfo("groupStandard.standardType"));
            ev.getSorter().add(new SorterItemInfo("groupStandard.standardType"));
            ev.getSelector().add(new SelectorItemInfo("longNumber"));
        }
        ev.getSelector().add(new SelectorItemInfo("deletedStatus"));
        ev.getSorter().add(new SorterItemInfo("groupStandard.number"));
        ev.getSorter().add(new SorterItemInfo("number"));
        groupPromptBox.setEntityViewInfo(ev);
        groupPromptBox.setSelectorCollection(ev.getSelector());
        groupPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object[] groups = (Object[])e.getNewValue();
                GLRptAsstactBaseQueryUI.this.checkGroupStandIsBasic(groups);
                if (groups != null) {
                    StandardTypeEnum lastSdType = null;
                    for (int i = 0; i < groups.length; ++i) {
                        StandardTypeEnum sdType;
                        if (groups[i] instanceof CSSPGroupInfo) {
                            sdType = ((CSSPGroupInfo)groups[i]).getGroupStandard().getIsBasic();
                            if (lastSdType == null) {
                                lastSdType = sdType;
                                continue;
                            }
                            if (sdType == lastSdType) continue;
                            MsgBox.showInfo((Component)((Object)GLRptAsstactBaseQueryUI.this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"sameGroupType"));
                            ((KDBizPromptBox)e.getSource()).setValue(e.getOldValue());
                            return;
                        }
                        if (!(groups[i] instanceof MaterialGroupInfo)) continue;
                        sdType = ((MaterialGroupInfo)groups[i]).getGroupStandard().getStandardType();
                        if (lastSdType == null) {
                            lastSdType = sdType;
                            continue;
                        }
                        if (sdType == lastSdType) continue;
                        MsgBox.showInfo((Component)((Object)GLRptAsstactBaseQueryUI.this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"sameGroupType"));
                        ((KDBizPromptBox)e.getSource()).setValue(e.getOldValue());
                        return;
                    }
                }
            }
        });
        KDTDefaultCellEditor groupEditor = new KDTDefaultCellEditor((IKDEditor)groupPromptBox);
        row.getCell("group").setEditor((ICellEditor)groupEditor);
    }

    private void checkGroupStandIsBasic(Object[] groups) {
        if (null == groups || groups.length == 0) {
            return;
        }
        if (null != this.isBasicInfos.get(this.getTblCurIndex())) {
            this.isBasicInfos.get(this.getTblCurIndex()).setRow(this.tbl.getRow(this.getTblCurIndex()));
            return;
        }
    }

    private String getGroupFilterSQL(Object[] groups, String hgAttribute) {
        String tableName = "material".equalsIgnoreCase(hgAttribute) ? "T_BD_MaterialGroup" : "T_BD_CSSPGroup";
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT gp.fid FROM ").append(tableName).append(" gp ");
        StringBuffer groupIdStr = new StringBuffer();
        for (int i = 0; i < groups.length; ++i) {
            TreeBaseInfo group = (TreeBaseInfo)groups[i];
            if (groupIdStr.length() > 0) {
                groupIdStr.append(",");
            }
            groupIdStr.append("'").append(group.getId().toString()).append("'");
        }
        if (groupIdStr.length() > 0) {
            sql.append(" INNER JOIN ").append(tableName).append(" pgp ON (CHARINDEX(pgp.flongnumber||'!', gp.flongnumber) = 1 ");
            sql.append(" or pgp.fid = gp.fid) ");
            sql.append(" where pgp.fid IN (").append(groupIdStr).append(")");
        }
        return sql.toString();
    }

    protected List getAsstactTypeList(String asstAccountId) throws EASBizException, BOSException {
        if (asstAccountId == null) {
            HashSet<String> companyIdSet = null;
            if (this.getCurrCompany().isIsBizUnit() || !this.isSupportUnion()) {
                companyIdSet = this.getCompanyIdSet();
            } else {
                companyIdSet = new HashSet<String>();
                companyIdSet.add(this.getCurrCompany().getId().toString());
            }
            return ((IGLRptAsstactBaseFacade)this.getIGLRptBaseFacade()).queryAsstAct(companyIdSet);
        }
        return GLRptUtils.getAsstactTypeEntityList(asstAccountId);
    }

    @Override
    public boolean verify() {
        if (!super.verify()) {
            return false;
        }
        if (this.isVerifyAsstSelected()) {
            boolean selected = false;
            int sumCount = 0;
            int n = this.tbl.getRowCount();
            for (int i = 0; i < n; ++i) {
                Object coll;
                boolean sel = (Boolean)this.tbl.getRow(i).getCell("selected").getValue();
                boolean bl = selected = selected || sel;
                if (!sel || CollectEnum.LEVEL != (coll = this.tbl.getRow(i).getCell("collect").getValue()) && CollectEnum.UP != coll) continue;
                ++sumCount;
            }
            if (!selected) {
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_act_item_please"));
                return false;
            }
            if (sumCount > 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"30_RptAsstactGGConditionUI"));
                return false;
            }
        }
        return true;
    }

    protected boolean isVerifyAsstSelected() {
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.jebAcct.setValue(null);
        this.chkFilterByCat.setSelected(false);
        this.clearAsst();
        this.setAccountF7Filter();
    }

    private void clearAsst() {
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("group").setValue(null);
            row.getCell("from").setValue(null);
            row.getCell("to").setValue(null);
            row.getCell("dist").setValue(null);
            row.getCell("dist").setUserObject(null);
            row.getCell("collect").setValue((Object)CollectEnum.LEAF);
            AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
            at.setFrom(null);
            at.setTo(null);
            at.setDist(null);
            this.lockAsstCell(row);
            this.lockMaxLevel(row);
        }
    }

    private boolean isMultiCompanyF7() {
        return this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.enumerate || this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.merger;
    }

    @Override
    protected List<ParamEx> getDefaultParamExs() {
        List<ParamEx> paramExs = super.getDefaultParamExs();
        if (!GLRptSubLedgerQueryUI.class.getName().equals(((Object)((Object)this)).getClass().getName())) {
            ParamEx paramEx = new ParamEx("Export_BatchSize", "0", "0", EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Rpt_tips1"));
            paramExs.add(paramEx);
        }
        return paramExs;
    }
}

