/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.UserSettingUtil;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.print.IRequestTableData;
import com.kingdee.eas.fi.gl.common.print.MultiPrint;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.PrintButtonEnum;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptAsstactBaseUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptCommonItemInfo;
import com.kingdee.eas.fi.gl.rpt.client.GLRptDataComponent;
import com.kingdee.eas.fi.gl.rpt.client.GLRptIRowDataFilledListener;
import com.kingdee.eas.fi.gl.rpt.client.GLRptTable;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.fi.gl.rpt.client.PrintButtonValues;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.framework.config.AbstractTablePreferencesHelper;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;

public abstract class GLRptAsstactBaseUI
extends AbstractGLRptAsstactBaseUI
implements IRequestTableData {
    private static final long serialVersionUID = 6970244314689017531L;
    private static final int ONE = 1;
    private JMenuItem exportExcelItem = new JMenuItem();
    private JMenuItem exportExcelSelectItem = new JMenuItem();
    private boolean isNewQuery = true;
    private int lastSelectIndex = 0;
    private boolean requesting = false;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.exportExcelItem.setText(this.getJoinExportAllLabel() + "EXCEL");
        this.exportExcelSelectItem.setText(this.getJoinExportSelectedLabel() + "EXCEL");
        this.initDataTable();
        GLRptTable tblMain = (GLRptTable)this.getDataComponent();
        KDTMenuManager tm = this.getMenuManager(tblMain);
        if (tm == null) {
            return;
        }
        tm.getMenu().addSeparator();
        tm.getMenu().add(this.exportExcelItem);
        tm.getMenu().add(this.exportExcelSelectItem);
    }

    public void addCommonMenusToTable(KDTable table) {
        super.addCommonMenusToTable(table);
        if (table == this.getDataComponent()) {
            PopupMenuManager mgr = this.getPopupMenuManager((JComponent)table);
            mgr.removeMenuSection("export");
        }
    }

    @Override
    protected GLRptDataComponent createDataComponent() {
        GLRptTable tblMain = new GLRptTable();
        tblMain.setName("tblMain");
        tblMain.setDataTable(false);
        return tblMain;
    }

    protected abstract String getJoinExportAllLabel();

    protected abstract String getJoinExportSelectedLabel();

    protected void initDataTable() throws Exception {
        this.dataTable.init(this, this.getIGLRptDataFacade(), new GLRptBaseUI.QueryAfterHandler(){

            @Override
            public void handle() {
                GLRptAsstactBaseUI.this.setDataTableConfig();
            }
        }, false, true);
        this.enableExportExcel(this.dataTable);
        this.checkTableCommonMenu(this.dataTable);
        this.addCommonMenusToTable(this.dataTable);
    }

    @Override
    protected void initListener() {
        super.initListener();
        GLRptTable tblMain = (GLRptTable)this.getDataComponent();
        tblMain.addGLRptIRowDataFilledListener(new GLRptIRowDataFilledListener(){

            @Override
            public void afterFilledTableRow(IRow row, String[] colNames) {
                GLRptAsstactBaseUI.this.afterFillTableRow(row, colNames);
            }
        });
        tblMain.addKDTSelectListener(new KDTSelectListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableSelectChanged(KDTSelectEvent e) {
                if (e.getSelectBlock() == null) {
                    return;
                }
                int rowIndex = e.getSelectBlock().getTop();
                GLRptAsstactBaseUI.this.lastSelectIndex = rowIndex;
                try {
                    GLRptAsstactBaseUI.this.setCursorOfWair();
                    GLRptAsstactBaseUI.this.tblMain_SelectChanged((KDTable)e.getSource(), rowIndex);
                }
                catch (Exception ex) {
                    GLRptAsstactBaseUI.this.handleException(ex);
                }
                finally {
                    GLRptAsstactBaseUI.this.setCursorOfDefault();
                }
            }
        });
        this.dataTable.addGLRptIRowDataFilledListener(new GLRptIRowDataFilledListener(){

            @Override
            public void afterFilledTableRow(IRow row, String[] colKeys) {
                GLRptAsstactBaseUI.this.afterFillDataTableRow(row, colKeys);
            }
        });
        this.exportExcelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GLRptAsstactBaseUI.this.actionExportToExcel_actionPerformed(e);
                }
                catch (Exception ex) {
                    GLRptAsstactBaseUI.this.handUIException(ex);
                }
            }
        });
        this.exportExcelSelectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GLRptAsstactBaseUI.this.actionExportPartToExcel_actionPerformed(e);
                }
                catch (Exception ex) {
                    GLRptAsstactBaseUI.this.handUIException(ex);
                }
            }
        });
    }

    @Override
    protected abstract GLRptBaseCondition createQueryCond(Map var1);

    @Override
    protected abstract GLRptBaseQueryUI getCustQueryPanel() throws Exception;

    @Override
    protected abstract IGLRptBaseFacade getIGLRptFacade() throws BOSException;

    protected void actionExportToExcel_actionPerformed(ActionEvent e) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        GLRptAsstactBaseCondition cond = this.getQueryCond();
        cond.setSelectedItem(null);
        view.put("GLFixCondition", (Object)cond);
        view.put("isExportAll", (Object)Boolean.TRUE);
        this.exportExcel(view);
    }

    protected void actionExportPartToExcel_actionPerformed(ActionEvent e) throws Exception {
        GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)this.getQueryCond().clone();
        GLRptRowSet itemData = this.getSelectedItems();
        if (itemData == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        cond.setSelectedItem(itemData);
        view.put("GLFixCondition", (Object)cond);
        this.exportExcel(view);
    }

    protected Object getSelectedValue(String colName) {
        KDTable tblMain = (KDTable)this.getDataComponent();
        int rowIndex = tblMain.getSelectManager().getActiveRowIndex();
        Object value = tblMain.getCell(rowIndex, colName).getValue();
        return value;
    }

    protected GLRptRowSet getSelectedItem(boolean isIgnoreTotal) throws BOSException {
        KDTable tblMain = (KDTable)this.getDataComponent();
        int selectedRow = tblMain.getSelectManager().getActiveRowIndex();
        GLRptRowSet itemData = this.getSelectedItems(tblMain, new int[]{selectedRow}, isIgnoreTotal);
        return itemData;
    }

    protected GLRptRowSet getSelectedItems() throws BOSException {
        KDTable tblMain = (KDTable)this.getDataComponent();
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)tblMain);
        GLRptRowSet itemData = this.getSelectedItems(tblMain, selectedRows, true);
        return itemData;
    }

    @Override
    protected GLRptTable getPrintTable() {
        return this.dataTable;
    }

    @Override
    protected GLRptAsstactBaseCondition getQueryCond() {
        return (GLRptAsstactBaseCondition)super.getQueryCond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcel(EntityViewInfo view) throws BOSException, EASBizException {
        if (this.isExportAsyn()) {
            this.asynExportExcel(view);
        } else {
            try {
                IObjectPK pk = this.hasExportExcelPermission();
                if (pk != null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("name"));
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(pk, sic);
                    PermItemInfo permItemInfo = PermItemFactory.getRemoteInstance().getPermItemInfoByNumber(this.getExportPermissionItem());
                    throw new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION_2, new Object[]{SysContext.getSysContext().getCurrentUserInfo().getNumber(), company.getName(), permItemInfo.getAlias()});
                }
                this.setCursorOfWair();
                GLRptQueryResult qrs = this.queryRight(this.getDataComponent().getQueryId(), view);
                if (qrs == null) {
                    return;
                }
                Map<String, Object> params = this.getExportConfig();
                params.put("view", view);
                Map<String, Object> tParams = this.getExportParams(view);
                if (tParams != null) {
                    params.putAll(tParams);
                }
                this.getExporter(params).export(qrs.getTableHeadInfo(), qrs.getData());
            }
            finally {
                this.setCursorOfDefault();
            }
        }
    }

    @Override
    protected Map<String, Object> getExportConfig() {
        Map<String, Object> config = super.getExportConfig();
        config.put("exportBatchSize", this.getExportBatchSize());
        return config;
    }

    protected void afterFillDataTableRow(IRow row, String[] colKeys) {
    }

    @Override
    protected Map<String, Object> getExportParams(EntityViewInfo view) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryId", this.getDataComponent().getQueryId());
        return params;
    }

    @Override
    protected void setReportExtraTitle(GLRptBaseCondition condition) {
        super.setReportExtraTitle(condition);
        GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)condition;
        AsstAccountInfo asstAccInfo = null;
        if (cond.getAsstAccountId() != null && cond.getAsstAccountId().trim().length() > 0) {
            asstAccInfo = this.getAsstAccountInfo(cond.getAsstAccountId());
        }
        String asstStr = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"AsstAccount_Label");
        if (asstAccInfo != null) {
            asstStr = asstStr + asstAccInfo.getName();
        }
        this.jtAsst.setText(asstStr);
        this.jtAsst.setToolTipText(asstStr);
        String asstAct = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"Item_Label");
        String str = asstAct + this.getAsstactName();
        this.jtAsstact.setText(str);
        this.jtAsstact.setToolTipText(str);
    }

    private AsstAccountInfo getAsstAccountInfo(String asstAccountId) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        try {
            return AsstAccountFactory.getRemoteInstance().getAsstAccountInfo((IObjectPK)new ObjectUuidPK(asstAccountId), selector);
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected void afterFillTableRow(IRow row, String[] colNames) {
        GLRptAsstactBaseCondition cond = this.getQueryCond();
        if (!cond.isShowAsstItemTotal()) {
            return;
        }
        boolean isTotal = false;
        if (1 == Integer.parseInt(row.getCell("isTotal").getValue().toString())) {
            isTotal = true;
        } else {
            List actList = cond.getAsstActList();
            for (int i = actList.size() - 1; i >= 0; --i) {
                AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
                ICell totalCell = row.getCell(this.getCellName(at, "IsTotal"));
                if (totalCell == null || 1 != Integer.parseInt(totalCell.getValue().toString())) continue;
                isTotal = true;
                break;
            }
        }
        if (isTotal) {
            row.getStyleAttributes().setBackground(TOTAL_COLOR);
        }
    }

    protected void tblMain_SelectChanged(KDTable tblMain, int rowIndex) throws Exception {
        IRow row = tblMain.getRow(rowIndex);
        if (row == null) {
            return;
        }
        this.setActionStatus(row);
        this.joinQueryData(this.getSelectedItem(false));
    }

    private void joinQueryData(GLRptRowSet itemData) throws BOSException {
        if (itemData == null) {
            return;
        }
        this.requesting = true;
        GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)this.getQueryCond().clone();
        EntityViewInfo view = new EntityViewInfo();
        cond.setSelectedItem(itemData);
        cond.setDataSourceTable(this.getDataComponent().getQueryId());
        if (this.getQueryCond().isShowAsstActSingle()) {
            AsstactTypeEntity at = (AsstactTypeEntity)itemData.getObject(0, "AsstactType");
            ArrayList<AsstactTypeEntity> asstActList = new ArrayList<AsstactTypeEntity>();
            asstActList.add(at);
            cond.setAsstActList(asstActList);
        }
        view.put("GLFixCondition", (Object)cond);
        this.dataTable.query(view, false);
        this.requesting = false;
    }

    protected void setActionStatus(IRow row) {
        boolean isTotalRow;
        block3: {
            block2: {
                isTotalRow = false;
                if (!this.getQueryCond().isShowAsstActSingle()) break block2;
                String id = (String)row.getCell(GLRptField.asstItemIDSingle.getName()).getValue();
                if (id != null) break block3;
                isTotalRow = true;
                break block3;
            }
            for (AsstactTypeEntity at : this.getQueryCond().getAsstActList()) {
                String id = (String)row.getCell(this.getCellName(at, "ID")).getValue();
                String groupId = null;
                if (at.isShowAsstGroup()) {
                    groupId = (String)row.getCell(this.getCellName(at, "GroupID")).getValue();
                }
                if (id != null || groupId != null) continue;
                isTotalRow = true;
                break;
            }
        }
        this.exportExcelSelectItem.setEnabled(!isTotalRow);
        this.actionExportSelected.setEnabled(!isTotalRow);
    }

    protected String getCellName(AsstactTypeEntity at, String asstIDType) {
        if ("ID".equals(asstIDType)) {
            return at.getHgField();
        }
        if ("GroupID".equals(asstIDType)) {
            return at.getHgAttribute() + "GroupID";
        }
        if ("Name".equals(asstIDType)) {
            return at.getHgAttribute() + "Name";
        }
        if ("Number".equals(asstIDType)) {
            return at.getHgAttribute() + "Number";
        }
        if ("IsTotal".equals(asstIDType)) {
            return at.getHgField() + "IsTotal";
        }
        return at.getHgField();
    }

    protected void setDataTableConfig() {
        if (!this.isNewQuery) {
            return;
        }
        UserPreferenceData userDBData = this.tHelper.getUserDataFromDB();
        GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)this.getEv().get("GLFixCondition");
        String tableNameData = this.getClass().getName() + "." + this.dataTable.getName();
        UserPreferenceData userData = new UserPreferenceData();
        UserCustomConfigItemData itemData = null;
        itemData = ((AbstractTablePreferencesHelper)this.tHelper).getColumnDataFromTable((KDTable)this.dataTable, itemData);
        itemData = ((AbstractTablePreferencesHelper)this.tHelper).getGenricDataFromTable((KDTable)this.dataTable, itemData);
        userData.getTables().put(tableNameData, itemData);
        KDTable tblMain = (KDTable)this.getDataComponent();
        String tableNameMain = this.getClass().getName() + "." + tblMain.getName();
        userData.getTables().put(tableNameMain, this.tHelper.getDefaultUserData(tblMain));
        this.tHelper.setDefaultUserData(userData);
        if (userDBData != null && userDBData.getTableCurrentSetting(tableNameData) != null) {
            this.tHelper.applyConfigFromData((KDTable)this.dataTable, userDBData.getTableCurrentSetting(tableNameData));
        }
        this.isNewQuery = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void joinQury(GLRptAsstactBaseCondition cond, String uiClassName) throws Exception {
        if (this.getDataComponent().isEmpty()) {
            return;
        }
        try {
            this.setCursorOfWair();
            this.setLinkedCompany(cond);
            this.setLinkedAccount(cond);
            this.setLinkedAsstactList(cond);
            String mode = this.getUIWindow() instanceof UINewFrame ? "com.kingdee.eas.base.uiframe.client.UINewFrameFactory" : "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
            IUIWindow ui = UIFactory.createUIFactory((String)mode).create(uiClassName, (Map)this.getLinkedContext(cond), null);
            ui.show();
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    protected UIContext getLinkedContext(GLRptBaseCondition cond) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
        uiContext.put((Object)"UIClassParam", (Object)cond.toMap().toString());
        uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)cond);
        return uiContext;
    }

    private void setLinkedCompany(GLRptBaseCondition cond) throws EASBizException, BOSException {
        if (cond.getCompany() == null) {
            if (cond.getCompanyId() != null) {
                cond.switchCompany(GlUtils.getCompanyById(cond.getCompanyId()));
            } else {
                cond.switchCompany(this.getCurrCompany());
            }
        }
        this.setJoinCompany(cond);
    }

    protected void setLinkedAccount(GLRptBaseCondition cond) {
        int i;
        if (this.dataTable.getSelectManager().get() != null && (i = com.kingdee.eas.framework.report.util.KDTableUtil.getSelectedTop((KDTable)this.dataTable)) != -1) {
            String accountId = (String)this.dataTable.getCell(i, "FAccountID").getValue();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            try {
                if (accountId != null && accountId.trim().length() > 0) {
                    AccountViewInfo account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId), selector);
                    cond.setAccountCodeStart(account.getNumber());
                    cond.setAccountCodeEnd(account.getNumber());
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    protected void setLinkedAsstactList(GLRptAsstactBaseCondition cond) throws CloneNotSupportedException, BOSException {
        Iterator it = cond.getAsstActList().iterator();
        ArrayList<AsstactTypeEntity> asstActList = new ArrayList<AsstactTypeEntity>();
        while (it.hasNext()) {
            AsstactTypeEntity at = (AsstactTypeEntity)((AsstactTypeEntity)it.next()).clone();
            String id = (String)this.getSelectedValue(this.getCellName(at, "ID"));
            if (id != null) {
                Object obj = this.getSelectedValue(this.getCellName(at, "Name"));
                Object number = this.getSelectedValue(this.getCellName(at, "Number"));
                DataBaseDInfo db = new DataBaseDInfo();
                db.setId(BOSUuid.read((String)id));
                if (obj instanceof GLRptTreeNode) {
                    db.setName(((GLRptTreeNode)obj).getUserObject().toString());
                } else {
                    db.setName((String)obj);
                }
                db.put("longnumber", number);
                db.put("number", number);
                at.setFrom(db);
                at.setTo(db);
                at.setDist(null);
            }
            asstActList.add(at);
        }
        cond.setAsstActList(asstActList);
        GLRptRowSet itemData = this.getSelectedItem(false);
        cond.setSelectedItem(itemData);
        cond.setDataSourceTable(this.getDataComponent().getQueryId());
    }

    @Override
    protected void tableUserSetting() {
        super.tableUserSetting();
        this.tHelper.setCanMoveColumn(true);
    }

    @Override
    protected void afterQuery() throws EASBizException, BOSException {
        super.afterQuery();
        this.isNewQuery = true;
        if (!this.getDataComponent().isEmpty()) {
            this.dataTable.checkParsed();
            this.dataTable.removeColumns();
            this.getDataComponent().selectFirst();
        } else {
            this.dataTable.query(null);
        }
    }

    @Override
    protected void showDataUILayout() throws EASBizException, BOSException {
        this.kDSplitPane1 = this.initSplitPane();
        this.kDSplitPane1.setName("kDSplitPane1");
        String kdSplitPaneDividerLocationSettingFunction = this.getKDSplitPaneDividerLocationSettingFunction();
        if (kdSplitPaneDividerLocationSettingFunction == null) {
            this.kDSplitPane1.setDividerLocation(400);
        } else {
            Map data = UserSettingUtil.getUserSetting(kdSplitPaneDividerLocationSettingFunction, null);
            if (data.size() != 0 && data.get("dividerLocation") != null) {
                String dividerLocation = (String)data.get("dividerLocation");
                this.kDSplitPane1.setDividerLocation(Integer.parseInt(dividerLocation));
            } else {
                this.kDSplitPane1.setDividerLocation(400);
            }
        }
        super.showDataUILayout();
    }

    protected String getKDSplitPaneDividerLocationSettingFunction() {
        return null;
    }

    protected KDSplitPane initSplitPane() {
        KDSplitPane newSplitPane = new KDSplitPane();
        newSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (GLRptAsstactBaseUI.this.getKDSplitPaneDividerLocationSettingFunction() != null && evt.getPropertyName().equals("dividerLocation")) {
                    JSplitPane tsplitPane = (JSplitPane)evt.getSource();
                    int dividerLocation = tsplitPane.getDividerLocation();
                    Properties props = new Properties();
                    props.setProperty("dividerLocation", String.valueOf(dividerLocation));
                    try {
                        UserSettingUtil.saveUserSetting(GLRptAsstactBaseUI.this.getKDSplitPaneDividerLocationSettingFunction(), props);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return newSplitPane;
    }

    protected String getAsstactName() {
        List asstTypeList = this.getQueryCond().getAsstActList();
        StringBuffer actTypeNames = new StringBuffer();
        GLRptTable tblMain = (GLRptTable)this.getDataComponent();
        IRow row = tblMain.getRow(this.lastSelectIndex);
        for (int i = 0; i < asstTypeList.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)asstTypeList.get(i);
            if (i > 0) {
                actTypeNames.append(";");
            }
            if (null == at || null == at.getName() || null == row) continue;
            actTypeNames.append(at.getName());
        }
        return actTypeNames.toString();
    }

    protected KDTable getTableForPrintSetting() {
        return this.dataTable;
    }

    @Override
    protected KDTable getTableForOA() {
        return this.dataTable;
    }

    @Override
    protected Map preparePrintVariantMap() {
        Map var = super.preparePrintVariantMap();
        var.put("Asstact", this.getAsstActPrintTitle(com.kingdee.eas.framework.report.util.KDTableUtil.getSelectedRow((KDTable)((GLRptTable)this.getDataComponent()))));
        return var;
    }

    protected String getAsstActPrintTitle(int selectedRowIndex) {
        String s;
        GLRptTable tblLeft = (GLRptTable)this.getDataComponent();
        StringBuffer sb = new StringBuffer();
        sb.append('[').append(this.jtAsstact.getText().substring(this.jtAsstact.getText().indexOf(":") + 1)).append("] ");
        if (selectedRowIndex != -1) {
            int n = tblLeft.getColumnCount();
            for (int j = 0; j < n; ++j) {
                Object cv;
                IColumn col = tblLeft.getColumn(j);
                if (col.getWidth() <= 0 || (cv = tblLeft.getValueAt(selectedRowIndex, j)) == null) continue;
                sb.append(cv);
                if (j >= n - 1) continue;
                sb.append(", ");
            }
        }
        if ((s = sb.toString()).endsWith(", ")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    @Override
    protected void preparePrintPageHeader(HeadFootModel header) {
        super.preparePrintPageHeader(header);
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"Item_Label"));
        sb.append("&[Asstact]");
        header.addRow(sb.append("&|").toString(), sa);
    }

    private GLRptRowSet getSelectedItems(KDTable tblMain, int[] selectedRows, boolean isIgnoreTotal) throws BOSException {
        if (selectedRows[0] < 0) {
            return null;
        }
        ArrayList dataList = new ArrayList();
        List asstactList = this.getQueryCond().getAsstActList();
        for (int i = 0; i < selectedRows.length; ++i) {
            Object group;
            AsstactTypeEntity at;
            int j;
            IRow row = tblMain.getRow(selectedRows[i]);
            boolean isTotal = false;
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            if (this.getQueryCond().isShowAsstActSingle()) {
                for (j = 0; j < asstactList.size(); ++j) {
                    at = (AsstactTypeEntity)asstactList.get(j);
                    Object object = row.getCell(GLRptField.actTypeIDSingle.getName()).getValue();
                    String actTypeId = "";
                    if (object != null && object instanceof String) {
                        actTypeId = (String)object;
                    }
                    if (actTypeId.compareToIgnoreCase(at.getId().toString()) != 0) continue;
                    object = row.getCell(GLRptField.asstItemIDSingle.getName()).getValue();
                    if (object != null && object instanceof String) {
                        rowData.put(at.getHgField(), (String)object);
                    } else {
                        rowData.put(at.getHgField(), null);
                    }
                    rowData.put("AsstactType", at);
                    group = null;
                    if (!isIgnoreTotal || object != null || group != null) continue;
                    isTotal = true;
                    break;
                }
            } else {
                for (j = 0; j < asstactList.size(); ++j) {
                    at = (AsstactTypeEntity)asstactList.get(j);
                    String cellName = this.getCellName(at, "ID");
                    Object object = row.getCell(cellName).getValue();
                    rowData.put(at.getHgField(), object);
                    group = null;
                    if (at.isShowAsstGroup()) {
                        cellName = this.getCellName(at, "GroupID");
                        group = row.getCell(cellName).getValue();
                        rowData.put(at.getHgAttribute() + "GroupID", group);
                    }
                    if (!isIgnoreTotal || object != null || group != null) continue;
                    isTotal = true;
                    break;
                }
            }
            if (isTotal) continue;
            dataList.add(rowData);
        }
        if (dataList.size() == 0) {
            return null;
        }
        return this.itemToGLRowSet(dataList);
    }

    private GLRptRowSet itemToGLRowSet(List dataList) throws BOSException {
        String[] items = null;
        if (this.getQueryCond().isShowAsstActSingle()) {
            if (dataList.size() > 0) {
                Map rowData = (Map)dataList.get(0);
                items = new String[rowData.keySet().size()];
                Iterator it = rowData.keySet().iterator();
                int i = 0;
                while (it.hasNext()) {
                    String key = it.next().toString();
                    items[i++] = key;
                }
            }
        } else {
            items = this.getAsstIDColNames(this.getQueryCond());
        }
        GLRptRowSet itemData = new GLRptRowSet(items, dataList.size());
        if (items != null) {
            for (int i = 0; i < itemData.size(); ++i) {
                Map rowData = (Map)dataList.get(i);
                itemData.insertRow();
                for (int j = 0; j < items.length; ++j) {
                    Object object = rowData.get(items[j]);
                    itemData.updateObject(items[j], object);
                }
            }
        }
        return itemData;
    }

    private String[] getAsstIDColNames(GLRptAsstactBaseCondition cond) {
        List actTypeList = cond.getAsstActList();
        ArrayList<String> items = new ArrayList<String>();
        for (int k = 0; k < actTypeList.size(); ++k) {
            AsstactTypeEntity at = (AsstactTypeEntity)actTypeList.get(k);
            if (at.isShowAsstGroup()) {
                items.add(at.getHgAttribute() + "GroupID");
            }
            items.add(at.getHgField());
        }
        return items.toArray(new String[items.size()]);
    }

    @Override
    protected void releaseDataSource() {
        super.releaseDataSource();
        this.dataTable.closeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected GLRptRowSet getPrintData(EntityViewInfo view, PrintButtonValues values) throws EASBizException, BOSException {
        cond = (GLRptAsstactBaseCondition)view.get("GLFixCondition");
        rs = null;
        if (cond.getCompany().getId().equals((Object)this.getQueryCond().getCompany().getId())) {
            this.setSelectedItems(view, values);
            rs = this.queryRight(this.getDataComponent().getQueryId(), view);
        } else {
            block7: {
                block8: {
                    queryId = null;
                    try {
                        cond.setSelectedItem(null);
                        cond.setDataSourceTable(null);
                        queryId = cond.getCompany().getId().equals((Object)this.getQueryCond().getCompany().getId()) != false ? this.getDataComponent().getQueryId() : this.queryLeft(view);
                        if (queryId != null) break block7;
                        var6_6 = null;
                        if (queryId == null) break block8;
                    }
                    catch (Throwable var7_7) {
                        if (queryId != null) {
                            this.getIGLRptFacade().releaseDataSource(queryId);
                        }
                        throw var7_7;
                    }
                    this.getIGLRptFacade().releaseDataSource(queryId);
                }
                return var6_6;
            }
            this.setSelectedItems(view, values);
            rs = this.queryRight(queryId, view);
            ** if (queryId == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                this.getIGLRptFacade().releaseDataSource(queryId);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        return rs == null ? null : rs.getData();
    }

    private String queryLeft(EntityViewInfo view) throws EASBizException, BOSException {
        GLRptQueryResult rs = this.getIGLRptFacade().query(view);
        if (rs == null) {
            return null;
        }
        return rs.getQueryId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GLRptQueryResult queryRight(String queryId, EntityViewInfo view) throws BOSException, EASBizException {
        IGLRptBaseFacade facade = this.getIGLRptDataFacade();
        GLRptQueryResult rs = null;
        GLRptQueryResult totalRs = null;
        try {
            GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)view.get("GLFixCondition");
            view.put("isShowAsstItem", (Object)Boolean.TRUE);
            view.put("PAGE_ROW_COUNT", (Object)new Integer(this.getExportPageSize()));
            cond.setDataSourceTable(queryId);
            rs = facade.query(view);
            if (rs == null) {
                GLRptQueryResult gLRptQueryResult = null;
                return gLRptQueryResult;
            }
            this.doPrintData(rs, facade);
            if (view.get("isExportAll") != null && cond.isShowAsstItemTotal()) {
                view.put("isPrintTotal", (Object)Boolean.TRUE);
                totalRs = facade.query(view);
                this.doPrintData(totalRs, facade);
                this.doMergeDate(rs, totalRs);
            }
        }
        finally {
            if (rs != null && rs.getQueryId() != null) {
                facade.releaseDataSource(rs.getQueryId());
            }
            if (totalRs != null && totalRs.getQueryId() != null) {
                facade.releaseDataSource(totalRs.getQueryId());
            }
        }
        return rs;
    }

    protected void doMergeDate(GLRptQueryResult queryResult, GLRptQueryResult totalResult) throws BOSException {
        if (queryResult != null && queryResult.getData() != null && totalResult != null && totalResult.getData() != null) {
            GLRptRowSet queryResultData = queryResult.getData();
            GLRptRowSet totalResultData = totalResult.getData();
            GLRptTableHeadInfo totalHead = totalResult.getTableHeadInfo();
            GLRptTableHeadInfo queryHead = queryResult.getTableHeadInfo();
            GLRptRowSet newTotalSet = new GLRptRowSet(queryResultData.getColumKeys(), totalResultData.size());
            totalResultData.beforeFirst();
            queryResultData.last();
            block0: while (totalResultData.next()) {
                String colName;
                GLRptTableHeadInfo.GLRptTableColumnInfo col;
                int i;
                newTotalSet.next();
                int colSize = totalHead.getColumnSize();
                for (i = 0; i < colSize; ++i) {
                    col = totalHead.getTableColumnInfo(i);
                    colName = col.getColName();
                    if (colName.equals("SQL_BATCH")) continue;
                    newTotalSet.updateObject(colName, totalResultData.getObject(colName));
                }
                colSize = queryHead.getColumnSize();
                for (i = 0; i < colSize; ++i) {
                    Object value;
                    col = queryHead.getTableColumnInfo(i);
                    if (col.isHide() || (value = newTotalSet.getObject(colName = col.getColName())) != null) continue;
                    newTotalSet.updateObject(colName, EASResource.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"total"));
                    continue block0;
                }
            }
            queryResultData.addRowSets(newTotalSet);
        }
    }

    protected void setSelectedItems(EntityViewInfo view, PrintButtonValues values) {
        GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)view.get("GLFixCondition");
        if (values != null && values.getBoolean(PrintButtonEnum.AssistArea)) {
            cond.setSelectedItem(null);
        } else {
            GLRptRowSet itemData = null;
            try {
                itemData = this.getSelectedItems();
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            if (itemData == null) {
                return;
            }
            cond.setSelectedItem(itemData);
        }
    }

    protected abstract IGLRptBaseFacade getIGLRptDataFacade() throws BOSException;

    @Override
    public Object getTablePreferenceSchemaKey() {
        String schemaKey = (String)super.getTablePreferenceSchemaKey();
        String getAsstActListStr = "";
        if (this.getQueryCond() != null) {
            GLRptAsstactBaseCondition cond = this.getQueryCond();
            getAsstActListStr = this.getAsstActListStr(cond.getAsstActList());
        }
        schemaKey = schemaKey + "||" + getAsstActListStr;
        return schemaKey;
    }

    private String getAsstActListStr(List asstActList) {
        String asstActListStr = "";
        for (AsstactTypeEntity at : asstActList) {
            asstActListStr = asstActListStr + at.getNumber() + "||";
        }
        if (!StringUtils.isEmpty((String)asstActListStr)) {
            asstActListStr = asstActListStr.substring(0, asstActListStr.length() - 2);
        }
        return asstActListStr;
    }

    protected GLRptRowSet itemToGLRowSet(List dataList, List actTypeList) throws BOSException {
        String[] items = this.getAsstIDColNames(actTypeList);
        GLRptRowSet itemData = new GLRptRowSet(items, dataList.size());
        for (int i = 0; i < itemData.size(); ++i) {
            Map rowData = (Map)dataList.get(i);
            itemData.insertRow();
            for (int j = 0; j < items.length; ++j) {
                Object object = rowData.get(items[j]);
                itemData.updateObject(items[j], object);
            }
        }
        return itemData;
    }

    private String[] getAsstIDColNames(List actTypeList) {
        ArrayList<String> items = new ArrayList<String>();
        for (int k = 0; k < actTypeList.size(); ++k) {
            AsstactTypeEntity at = (AsstactTypeEntity)actTypeList.get(k);
            if (at.isShowAsstGroup()) {
                items.add(at.getHgAttribute() + "GroupID");
            }
            items.add(at.getHgField());
        }
        return items.toArray(new String[items.size()]);
    }

    @Override
    protected String getSelectCompanyId() {
        String selectCompanyId = null;
        GLRptAsstactBaseCondition cond = this.getQueryCond();
        CompanyOrgUnitInfo company = cond.getCompany();
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            selectCompanyId = company.getId().toString();
        } else {
            Object obj;
            int rowIndex = this.dataTable.getSelectManager().getActiveRowIndex();
            if (rowIndex == -1) {
                return selectCompanyId;
            }
            if (!company.isIsBizUnit()) {
                Object obj2;
                if (rowIndex != -1 && (obj2 = this.dataTable.getRow(rowIndex).getCell("companyName").getValue()) instanceof GLRptTreeNode) {
                    Object comObj = ((GLRptTreeNode)obj2).getUserObject();
                    company = (CompanyOrgUnitInfo)comObj;
                    selectCompanyId = company.getId().toString();
                }
            } else if (rowIndex != -1 && (obj = this.dataTable.getRow(rowIndex).getCell("FOrgUnitID").getValue()) != null) {
                selectCompanyId = obj.toString();
            }
        }
        return selectCompanyId;
    }

    @Override
    protected CompanyOrgUnitInfo getSelectCompany() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        String selectCompanyId = this.getSelectCompanyId();
        if (!StringUtils.isEmpty((String)selectCompanyId)) {
            company = GlUtils.getCompanyById(selectCompanyId);
        }
        return company;
    }

    @Override
    protected List getCommonPrintButtons() {
        ArrayList<GLRptCommonItemInfo> list = new ArrayList<GLRptCommonItemInfo>();
        list.add(new GLRptCommonItemInfo(PrintButtonEnum.CompanyArea, new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"SelectedCompany"), EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"AllCompany")}));
        list.add(new GLRptCommonItemInfo(PrintButtonEnum.AssistArea, new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"SelectedAssist"), EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"AllAssist")}));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void print(boolean preview) throws Exception {
        this.dataTable.setAsynSumData(false);
        try {
            this.setCursorOfWair();
            MultiPrint mp = new MultiPrint((Component)((Object)this));
            boolean isShowNumber = this.isAssitemShowNumber();
            if (!mp.showPrintOption()) {
                return;
            }
            this.preparePrintPage(this.getTableForPrint());
            GLRptRowSet tps = this.getAsstactTreePath(mp.isPrintAll());
            if (tps == null || tps.size() == 0) {
                return;
            }
            int begin = 0;
            mp.getMultiPrintModel().setTable(this.getTableForPrint());
            mp.getMultiPrintModel().setRequestData(this);
            String asst = null;
            List asstactList = this.getQueryCond().getAsstActList();
            GLRptTable tblMain = (GLRptTable)this.getDataComponent();
            int count = tblMain.getRowCount();
            int[] selectedRows = new int[count];
            if (mp.isPrintAll()) {
                for (int i = 0; i < tblMain.getRowCount(); ++i) {
                    selectedRows[i] = i;
                }
            } else {
                selectedRows = KDTableUtil.getSelectedRows((KDTable)tblMain);
            }
            String account = null;
            String companyName = null;
            companyName = this.getQueryCond().getCompany() != null ? this.getQueryCond().getCompany().getName() : this.getCurrCompany().getName();
            int n = tps.size();
            for (int i = begin; i < n; ++i) {
                HashMap<String, String> var = new HashMap<String, String>();
                GLRptRowSet item = tps.getRow(i);
                asst = this.getNameAndNumber(tblMain.getRow(selectedRows[i]), isShowNumber);
                var.put("Company", companyName);
                var.put("User", SysContext.getSysContext().getUserName());
                var.put("Period", this.lblPeriod.getText().substring(3));
                var.put("Currency", this.lblCurrency.getText().substring(3));
                var.put("Asstact", asst);
                account = this.getAccountNumberAndName(item, tblMain.getRow(selectedRows[i]));
                var.put("Account", account);
                mp.getMultiPrintModel().addVarParser("PrintJob_" + i, var);
                mp.getMultiPrintModel().addTreePath("PrintJob_" + i, item);
            }
            if (preview) {
                mp.preview();
            } else {
                mp.print();
            }
        }
        finally {
            this.dataTable.setAsynSumData(false);
            this.setCursorOfDefault();
        }
    }

    private String getAccountNumberAndName(GLRptRowSet rowSet, IRow row) {
        String accountNumberAndName = "";
        try {
            if (rowSet == null) {
                return "";
            }
            this.setActionStatus(row);
            this.joinQueryData(rowSet);
            IRow dataRow = this.dataTable.getRow(0);
            Object accountNumber = dataRow.getCell("accountNumber").getValue();
            Object accountName = dataRow.getCell("accountName").getValue();
            if (accountNumber != null && !"".equals(accountNumber.toString().trim())) {
                accountNumberAndName = accountNumberAndName + accountNumber;
            }
            if (accountName != null && !"".equals(accountName.toString().trim())) {
                accountNumberAndName = accountNumberAndName + " " + accountName;
            }
        }
        catch (Exception e) {
            accountNumberAndName = "";
        }
        return accountNumberAndName;
    }

    private String getNameAndNumber(IRow row, boolean isShowNumber) throws BOSException {
        StringBuffer str = new StringBuffer();
        str.append("[ ").append(this.jtAsstact.getText().substring(5)).append(" ] ");
        StringBuffer asstactDetail = new StringBuffer();
        for (AsstactTypeEntity at : this.getQueryCond().getAsstActList()) {
            asstactDetail.append(" [").append(at.getName()).append("]");
            if (row.getCell(this.getCellName(at, "Name")).getValue() instanceof GLRptTreeNode) {
                if (isShowNumber) {
                    asstactDetail.append(((GLRptTreeNode)row.getCell(this.getCellName(at, "Number")).getValue()).getUserObject().toString()).append(" ");
                }
                asstactDetail.append(((GLRptTreeNode)row.getCell(this.getCellName(at, "Name")).getValue()).getUserObject().toString());
                continue;
            }
            if (row.getCell(this.getCellName(at, "Name")).getValue() instanceof String) {
                if (isShowNumber) {
                    asstactDetail.append((String)row.getCell(this.getCellName(at, "Number")).getValue()).append(" ");
                }
                asstactDetail.append((String)row.getCell(this.getCellName(at, "Name")).getValue());
                continue;
            }
            if (!(row.getCell(this.getCellName(at, "Name")).getValue() instanceof Object)) continue;
            if (isShowNumber) {
                asstactDetail.append(row.getCell(this.getCellName(at, "Number")).getValue().toString()).append(" ");
            }
            asstactDetail.append(row.getCell(this.getCellName(at, "Name")).getValue().toString());
        }
        return asstactDetail.toString();
    }

    private GLRptRowSet getAsstactTreePath(boolean all) throws BOSException {
        GLRptRowSet itemData = null;
        GLRptTable tblMain = (GLRptTable)this.getDataComponent();
        if (all) {
            int count = tblMain.getRowCount();
            int[] selectedRows = new int[count];
            for (int i = 0; i < tblMain.getRowCount(); ++i) {
                selectedRows[i] = i;
            }
            itemData = this.getSelectedItems(tblMain, selectedRows, false);
        } else {
            int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)tblMain);
            itemData = this.getSelectedItems(tblMain, selectedRows, false);
        }
        return itemData;
    }

    @Override
    public void requestTableData(Object thepath) throws Exception {
        GLRptRowSet itemData = null;
        if (!(thepath instanceof GLRptRowSet)) {
            return;
        }
        itemData = (GLRptRowSet)thepath;
        this.joinQueryData(itemData);
    }

    @Override
    public void confirmEnd() {
        try {
            while (this.requesting) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean isAssitemShowNumber() throws BOSException, EASBizException {
        HashMap<String, BOSUuid> paramKeyMap = new HashMap<String, BOSUuid>();
        boolean isShowNumber = false;
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        paramKeyMap.put("GL_004", this.getCurrCompany().getId());
        String strShowNumber = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_012");
        if (strShowNumber != null && strShowNumber.trim().length() > 0) {
            isShowNumber = Boolean.parseBoolean(strShowNumber.trim());
        }
        return isShowNumber;
    }

    public int getExportBatchSize() {
        return GLRptUtils.getInt(this.getQueryCond().getExtendParam("Export_BatchSize"), 0, 50, 0);
    }
}

