/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDPrintConfig;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class GLRptAsstactGDPrintAccountContents
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger(GLRptAsstactGDPrintAccountContents.class);
    public static final String[] col = new String[]{"sysDateNow", "user", "company", "asstAct", "account", "pageCode"};
    private GLRptRowSet rs;
    boolean bBF = false;
    private GLRptAsstactGDCondition cond;
    public static int page = 0;

    public GLRptAsstactGDPrintAccountContents(GLRptAsstactGDCondition cond, GLRptRowSet rs, GLRptAsstactGDPrintConfig config) {
        this.rs = rs;
        this.bBF = config.isBF();
        this.cond = cond;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i, ds);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount, BOSQueryDataSource ds) {
        DateFormat format = GlUtils.getDateFormat();
        ArrayList alDs = ds.getParams();
        Object[] objDs = alDs.toArray();
        int iobjDs = objDs.length;
        String[] strCyc = new String[iobjDs];
        for (int i = 0; i < iobjDs; ++i) {
            strCyc[i] = ((DSParam)objDs[i]).getAssociateField();
        }
        if (iobjDs > 0) {
            rowLineCount = Integer.parseInt(strCyc[strCyc.length - 1]);
        }
        int colCount = col.length;
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int iHuan = 0;
            int iPage = 1;
            int ie = 0;
            int iStep = 0;
            int nn = 0;
            this.rs.beforeFirst();
            ArrayList<AsstItemInfo> data = new ArrayList<AsstItemInfo>();
            AsstItemInfo asstItem = null;
            AccountItemInfo account = null;
            while (this.rs.next()) {
                String accountName;
                String asstItemName = this.getAsstItem(this.rs);
                if (asstItem == null || !asstItemName.equals(asstItem.getItemName())) {
                    asstItem = new AsstItemInfo();
                    asstItem.setItemName(asstItemName);
                    data.add(asstItem);
                    account = null;
                }
                asstItem.addNum();
                String string = accountName = this.cond.isGroupByAsst() ? "" : this.getAccount(this.rs);
                if (!this.cond.isGroupByAsst() && accountName == null && account != null) {
                    int isTotal = this.rs.getInt("isTotal");
                    int isCurrencyIsTotal = this.rs.getInt("currencyIsTotal");
                    if (isTotal == 1 || isCurrencyIsTotal == 1) {
                        account.addNum();
                    }
                }
                if (accountName == null) continue;
                if (account == null || !accountName.equals(account.getAccountName())) {
                    account = new AccountItemInfo();
                    account.setAccountName(accountName);
                    asstItem.addAccountItemInfo(account);
                }
                account.addNum();
            }
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1086_pageCode");
            String itemName = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"100_RptAsstactGDTaodaAccount");
            String accountName = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"101_RptAsstactGDTaodaAccount");
            String msgInfo = null;
            for (int k = 0; k < data.size(); ++k) {
                AsstItemInfo asstItemInfo = (AsstItemInfo)data.get(k);
                int irsCurr = asstItemInfo.getNum();
                List accounts = asstItemInfo.getAccountItemInfos();
                for (int i = 0; i < accounts.size(); ++i) {
                    AccountItemInfo accountInfo = (AccountItemInfo)accounts.get(i);
                    drs.moveToInsertRow();
                    GLRptAsstactGDPrintAccountContents.clearRow((IRowSet)drs);
                    drs.updateString("sysDateNow", GlUtils.formatDate(format, new Date()));
                    if (SysContext.getSysContext().getCurrentUserInfo() != null) {
                        drs.updateString("user", SysContext.getSysContext().getCurrentUserInfo().getName());
                    } else {
                        drs.updateString("user", SysContext.getSysContext().getCurrentUserInfo().toString());
                    }
                    drs.updateString("company", this.cond.getCompany().getName());
                    drs.updateString("asstAct", itemName + asstItemInfo.getItemName());
                    if (!this.cond.isGroupByAsst()) {
                        drs.updateString("account", accountName + accountInfo.getAccountName());
                    }
                    int iNote = accountInfo.getNum();
                    if (this.bBF) {
                        int aaa;
                        iHuan += iNote;
                        ie = iPage;
                        if (irsCurr > rowLineCount) {
                            if (iHuan - (rowLineCount * iPage - 1) > 0) {
                                aaa = rowLineCount * iPage - (iHuan - iNote);
                                int rows = iNote - aaa + 1;
                                if (i == accounts.size() - 1) {
                                    iStep = rows / (rowLineCount - 2);
                                    int lastPage = rows % (rowLineCount - 2);
                                    if (lastPage > 1) {
                                        ++iStep;
                                    }
                                } else {
                                    iStep = rows % (rowLineCount - 2) == 0 ? rows / (rowLineCount - 2) : rows / (rowLineCount - 2) + 1;
                                }
                                nn = iStep * 2;
                                iPage = (iHuan += nn) % rowLineCount == 0 ? iHuan / rowLineCount : iHuan / rowLineCount + 1;
                                msgInfo = ie == iPage ? MessageFormat.format(msg, iPage) : MessageFormat.format(msg, ie + " - " + iPage);
                                drs.updateString("pageCode", msgInfo);
                                if (iHuan - (rowLineCount * iPage - 1) == 0 && i != accounts.size() - 1) {
                                    ++iPage;
                                    iHuan += 2;
                                }
                            } else {
                                msgInfo = MessageFormat.format(msg, iPage);
                                drs.updateString("pageCode", msgInfo);
                                if (iHuan - (rowLineCount * iPage - 1) == 0 && i != accounts.size() - 1) {
                                    ++iPage;
                                    iHuan += 2;
                                }
                            }
                        } else if (iHuan - rowLineCount * iPage > 0) {
                            iPage = (iHuan += (nn = (iStep = (iNote - ((aaa = rowLineCount * iPage - (iHuan - iNote)) - 1)) / (rowLineCount - 2) + 1) * 2)) % rowLineCount == 0 ? iHuan / rowLineCount : iHuan / rowLineCount + 1;
                            msgInfo = MessageFormat.format(msg, ie + " - " + iPage);
                            drs.updateString("pageCode", msgInfo);
                        } else {
                            msgInfo = MessageFormat.format(msg, iPage);
                            drs.updateString("pageCode", msgInfo);
                        }
                    } else {
                        ie = iPage;
                        iPage = (iHuan += iNote) % rowLineCount == 0 ? iHuan / rowLineCount : iHuan / rowLineCount + 1;
                        if (iHuan - rowLineCount * ie == iNote) {
                            if (iPage - ie > 1) {
                                if (ie != 1) {
                                    ++ie;
                                }
                                msgInfo = MessageFormat.format(msg, ie + " - " + iPage);
                                drs.updateString("pageCode", msgInfo);
                            } else if (iPage - ie == 1) {
                                ie = iPage;
                                msgInfo = MessageFormat.format(msg, ie);
                                drs.updateString("pageCode", msgInfo);
                            }
                        } else if (ie == iPage) {
                            msgInfo = MessageFormat.format(msg, iPage);
                            drs.updateString("pageCode", msgInfo);
                        } else {
                            msgInfo = MessageFormat.format(msg, ie + " - " + iPage);
                            drs.updateString("pageCode", msgInfo);
                        }
                    }
                    drs.insertRow();
                }
                if (this.bBF) {
                    iHuan = rowLineCount * iPage;
                    ++iPage;
                } else {
                    iHuan = rowLineCount * iPage;
                }
                if (k != data.size() - 1) continue;
                page = iPage;
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return drs;
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private String getAsstItem(GLRptRowSet rs) throws BOSException, SQLException {
        StringBuffer asstItemName = new StringBuffer();
        List asstTypeList = this.cond.getAsstActList();
        for (int i = 0; i < asstTypeList.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)asstTypeList.get(i);
            if (i > 0) {
                asstItemName.append(";");
            }
            asstItemName.append(at.getName()).append(":").append(rs.getString(at.getHgAttribute() + "Name"));
        }
        return asstItemName.toString();
    }

    private String getAccount(GLRptRowSet rs) throws BOSException, SQLException {
        String accNumber = rs.getString("accountNumber");
        String accName = rs.getString("accountName");
        return accNumber == null ? null : accNumber + " " + accName;
    }

    class AccountItemInfo {
        String accountName;
        int num = 0;

        AccountItemInfo() {
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public int getNum() {
            return this.num;
        }

        public void addNum() {
            ++this.num;
        }
    }

    class AsstItemInfo {
        String itemName;
        int num = 0;
        List accountItemInfos = new ArrayList();

        AsstItemInfo() {
        }

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public int getNum() {
            return this.num;
        }

        public void addNum() {
            ++this.num;
        }

        public List getAccountItemInfos() {
            return this.accountItemInfos;
        }

        public void addAccountItemInfo(AccountItemInfo accountItemInfo) {
            this.accountItemInfos.add(accountItemInfo);
        }

        public boolean equals(Object item) {
            if (item instanceof AsstItemInfo && item != null && ((AsstItemInfo)item).getItemName() != null) {
                return ((AsstItemInfo)item).getItemName().equals(this.getItemName());
            }
            return false;
        }
    }
}

