/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptPrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDPrintAccountContents;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDPrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GLRptAsstactGDPrintDelegate
extends AbstractGLRptPrintDelegate {
    private String strOverHypoPage = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.overHypoPage");
    private String strBearForwardPage = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.bearForwardPage");
    private String periodStartBalance = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.cell_periodInitAmount");
    private String periodEndBalance = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.cell_periodAmount");
    private String yearBalance = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.cell_yearAmount");
    private String allCurrency = GLResUtil.getRes("all_currency");
    private static final String[][] col = new String[][]{{"sysDateNow", ""}, {"s_CurrentUser", ""}, {"creator", ""}, {"s_Company", ""}, {"yeCode", ""}, {"h_Asst", ""}, {"h_Asstact", ""}, {"h_Period", ""}, {"h_Currency", ""}, {"faccountNumName", ""}, {"faccountLong", ""}, {"faccountnum", ""}, {"faccountnm", ""}, {"fbdYear", ""}, {"fbookeddateYear", ""}, {"fbookeddateMonth", ""}, {"fbookeddateDay", ""}, {"fperiodyear", ""}, {"fperiodnumber", ""}, {"fperiodyearnumber", "FPeriod"}, {"faccountnumber", "accountNumber"}, {"faccountname", "accountName"}, {"fdc", "accountDC"}, {"fbookeddateRedundancy", "FBookedDate"}, {"fvouchertype", "voucherTypeName"}, {"fvoucherno", "voucherNumber"}, {"fbizdate", "FBizdate"}, {"fdescription", "FDescription"}, {"flocalexchangerate", "FLocalExchangeRate"}, {"freportingexchangerate", "FReportingExchangeRate"}, {"fdebit_for", "FSubDebitFor"}, {"fdebit_local", "FSubDebitLocal"}, {"fdebit_rpt", "FSubDebitRpt"}, {"fcredit_for", "FSubCreditFor"}, {"fcredit_local", "FSubCreditLocal"}, {"fcredit_rpt", "FSubCreditRpt"}, {"fbalance_for", "FEndBalanceFor"}, {"fbalance_local", "FEndBalanceLocal"}, {"fbalance_rpt", "FEndBalanceRpt"}, {"FDEBITQTY", "FSubDebitQty"}, {"FDEBITPRICE", "FDebitPrice"}, {"FCREDITQTY", "FSubCreditQty"}, {"FCREDITPRICE", "FCreditPrice"}, {"FENDQTY", "FEndQty"}, {"FBALANCEPRICE", "FEndPrice"}, {"FMEASUREUNITNUMBER", "measureUnitNumber"}, {"FMEASUREUNITNAME", "measureUnitName"}, {"fcurrencyname", "currencyName"}, {"fcurrencynumber", "currencyNumber"}, {"fcurrencyid", "FCurrencyID"}, {"fprecision", "currencyPre"}, {"fcoefficient", ""}, {"fbiznumber", "FBizNumber"}, {"finvoicenumber", "FInvoiceNumber"}, {"fsettlementcode", "FSettlementCode"}, {"settlename", "settleTypeName"}, {"fticketnumber", "FTicketNumber"}};
    private Map mapParame = null;
    private GLRptRowSet rs = null;
    private boolean bBF = false;
    private List asstTypeList;
    private boolean isSumPeriod = false;
    private CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
    private int rowCount = 0;
    private String lastAsstitem = null;
    private StringBuffer sbYear = null;

    public GLRptAsstactGDPrintDelegate(GLRptRowSet rs, Map mapParame, GLRptBasePrintConfig config) {
        this.rs = rs;
        this.mapParame = mapParame;
        if (mapParame.get("company") != null && mapParame.get("company") instanceof CompanyOrgUnitInfo) {
            this.curCompany = (CompanyOrgUnitInfo)mapParame.get("company");
        }
        this.asstTypeList = (List)mapParame.get("asstTypeList");
        this.bBF = ((GLRptAsstactGDPrintConfig)config).isBF();
        this.isSumPeriod = ((GLRptAsstactGDPrintConfig)config).isSumPeriod();
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount) {
        int colCount = col.length;
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = col[i][0];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int size = this.rs.size();
            this.rs.beforeFirst();
            int iCountNew = 0;
            iCountNew = GLRptAsstactGDUI.isPrintAccountContentsStatic && GLRptAsstactGDPrintAccountContents.page != 0 ? GLRptAsstactGDPrintAccountContents.page : this.getTotalByAssts(rowLineCount);
            CurrencyInfo baseCurrency = this.curCompany.getBaseCurrency();
            baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            CurrencyInfo rptCurrency = this.curCompany.getReportCurrency();
            if (rptCurrency != null) {
                rptCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(rptCurrency.getId()));
            }
            String currencyId = (String)this.mapParame.get("currencyId");
            CurrencyInfo currency = this.getCurrency(baseCurrency, rptCurrency, currencyId);
            this.rowCount = 0;
            this.lastAsstitem = null;
            this.sbYear = null;
            this.rs.beforeFirst();
            while (this.rs.next()) {
                this.setRowData(drs, currency, baseCurrency, rptCurrency, rowLineCount, iCountNew);
            }
            drs.beforeFirst();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            e.printStackTrace();
            SysUtil.abort();
        }
        return drs;
    }

    private int getTotalByAssts(int rowLineCount) throws BOSException, SQLException {
        int iCount = 1;
        int size = this.rs.size();
        HashMap<String, Integer> asstMap = new HashMap<String, Integer>();
        String lastAsstItem = null;
        while (this.rs.next()) {
            String asstItem = this.getAsstitemID(this.rs);
            if (lastAsstItem != null && asstItem.equals(lastAsstItem)) {
                ++iCount;
            } else if (lastAsstItem != null && !asstItem.equals(lastAsstItem)) {
                iCount = 1;
            }
            lastAsstItem = asstItem;
            asstMap.put(asstItem, iCount);
        }
        iCount = 0;
        for (String key : asstMap.keySet()) {
            int value = (Integer)asstMap.get(key);
            iCount += value % rowLineCount == 0 ? value / rowLineCount : value / rowLineCount + 1;
        }
        return iCount;
    }

    private void setRowData(DynamicRowSet drs, CurrencyInfo currency, CurrencyInfo baseCurrency, CurrencyInfo rptCurrency, int rowLineCount, int iCount) throws Exception {
        String asstItem = this.getAsstitemID(this.rs);
        if (this.lastAsstitem != null && !asstItem.equals(this.lastAsstitem)) {
            if (this.rowCount % rowLineCount != 0) {
                this.rowCount += rowLineCount - this.rowCount % rowLineCount;
            }
            this.lastAsstitem = asstItem;
        } else {
            this.lastAsstitem = asstItem;
        }
        drs.moveToInsertRow();
        this.clearRow((IRowSet)drs);
        ++this.rowCount;
        int page = this.rowCount % rowLineCount == 0 ? this.rowCount / rowLineCount : this.rowCount / rowLineCount + 1;
        drs.updateString("yeCode", page + "/" + iCount);
        StringBuffer sbAccountLongName = new StringBuffer();
        drs.updateString("sysDateNow", GlUtils.formatDate(GlUtils.getDateFormat(), new Date()));
        if (SysContext.getSysContext().getCurrentUserInfo().getName() != null) {
            drs.updateString("s_CurrentUser", SysContext.getSysContext().getCurrentUserInfo().getName());
        } else {
            drs.updateString("s_CurrentUser", SysContext.getSysContext().getCurrentUserInfo().toString());
        }
        drs.updateString("s_Company", this.curCompany.toString());
        drs.updateString("creator", this.rs.getString("FCreatorName"));
        drs.updateObject("h_Asst", this.mapParame.get("AsstAct"));
        drs.updateObject("h_Period", this.mapParame.get("Period"));
        drs.updateObject("h_Currency", (Object)(currency == null ? this.allCurrency : currency.getName()));
        this.updateAsstitem(drs, this.rs);
        drs.updateInt("fprecision", this.getPrecision(currency));
        int colNum = col.length - 1;
        for (int i = 18; i < colNum; ++i) {
            this.setCellData(drs, sbAccountLongName, baseCurrency, rptCurrency, currency, i);
        }
        this.sbYear = this.updateYear(this.rs, drs, this.sbYear, rowLineCount, this.rowCount);
        drs.updateString("faccountNumName", sbAccountLongName.toString());
        drs.updateString("faccountLong", sbAccountLongName.toString());
        drs.insertRow();
        if (this.bBF) {
            this.setBFRowData(drs, currency, baseCurrency, rptCurrency, rowLineCount);
        }
    }

    private void setBFRowData(DynamicRowSet drs, CurrencyInfo currency, CurrencyInfo baseCurrency, CurrencyInfo rptCurrency, int rowLineCount) throws BOSException, SQLException, Exception {
        String it;
        int currIndex = this.rs.getCurrRowIndex();
        if ((this.rowCount + 1) % rowLineCount == 0 && this.rs.next() && this.rs.next() && (it = this.getAsstitemID(this.rs)).equals(this.lastAsstitem)) {
            drs.moveToInsertRow();
            this.setEmptyStr(drs);
            drs.updateString("fdescription", this.strOverHypoPage);
            this.setBFAmount(drs, currency, baseCurrency, rptCurrency, currIndex);
            drs.insertRow();
            ++this.rowCount;
            drs.moveToInsertRow();
            this.setEmptyStr(drs);
            drs.updateString("fdescription", this.strBearForwardPage);
            ++this.rowCount;
            this.sbYear = this.updateYear(this.rs, drs, this.sbYear, rowLineCount, this.rowCount);
            drs.insertRow();
        }
        this.rs.absolute(currIndex);
    }

    private void setCellData(DynamicRowSet drs, StringBuffer sbAccountLongName, CurrencyInfo baseCurrency, CurrencyInfo rptCurrency, CurrencyInfo currency, int i) throws BOSException, SQLException {
        String period;
        if (this.rs.indexOf(col[i][1]) == -1) {
            return;
        }
        Object value = this.rs.getObject(col[i][1]);
        if (value == null) {
            return;
        }
        if (value instanceof BigDecimal) {
            BigDecimal val = (BigDecimal)value;
            if (val.doubleValue() == 0.0) {
                drs.updateString(col[i][0], "");
            } else {
                this.setBigDecimalValue(drs, baseCurrency, rptCurrency, currency, i, val);
            }
        } else {
            drs.updateString(col[i][0], value.toString());
        }
        if (col[i][1].equalsIgnoreCase("FBookedDate")) {
            String[] sDate = value.toString().split("\\-");
            drs.updateString("fbookeddateYear", sDate[0]);
            drs.updateString("fbookeddateMonth", sDate[1]);
            drs.updateString("fbookeddateDay", sDate[2]);
        }
        if (col[i][1].equalsIgnoreCase("accountNumber")) {
            drs.updateString("faccountnum", value.toString());
        }
        if (col[i][1].equalsIgnoreCase("accountName")) {
            drs.updateString("faccountnm", value.toString());
        }
        if ((col[i][1].equalsIgnoreCase("accountNumber") || col[i][1].equalsIgnoreCase("accountName")) && value.toString() != null && !value.toString().trim().equals("")) {
            if (sbAccountLongName.length() > 0) {
                sbAccountLongName.append(" - ");
            }
            sbAccountLongName.append(value.toString());
        }
        if (col[i][1].equalsIgnoreCase("FPeriod") && (period = this.rs.getString("FPeriod")) != null) {
            String[] p = period.split("\\.");
            drs.updateString("fperiodyear", p[0]);
            drs.updateString("fperiodnumber", p[1]);
        }
    }

    private void setBigDecimalValue(DynamicRowSet drs, CurrencyInfo baseCurrency, CurrencyInfo rptCurrency, CurrencyInfo currency, int i, BigDecimal val) throws SQLException, BOSException {
        boolean isGRptCy;
        boolean isGBaseCy = currency != null && currency.getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC");
        boolean bl = isGRptCy = currency != null && currency.getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC");
        if (col[i][1].endsWith("Local")) {
            drs.updateString(col[i][0], GlUtils.withComma(val, baseCurrency.getPrecision()));
            if (isGBaseCy) {
                drs.updateString(col[i][0].substring(0, col[i][0].length() - 5) + "for", GlUtils.withComma(val, baseCurrency.getPrecision()));
            }
        } else if (col[i][1].endsWith("Rpt")) {
            drs.updateString(col[i][0], GlUtils.withComma(val, rptCurrency.getPrecision()));
            if (isGRptCy) {
                drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "for", GlUtils.withComma(val, rptCurrency.getPrecision()));
            }
        } else if (col[i][1].endsWith("For")) {
            drs.updateString(col[i][0], GlUtils.withComma(val, drs.getInt("fprecision")));
            if (this.isBaseCurrency(currency, baseCurrency)) {
                drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "local", GlUtils.withComma(val, drs.getInt("fprecision")));
            }
        } else if (col[i][1].equals("FLocalExchangeRate")) {
            drs.updateString(col[i][0], GlUtils.withComma(val, this.rs.getInt("FLocalExRatePre")));
        } else if (col[i][1].equals("FReportingExchangeRate")) {
            drs.updateString(col[i][0], GlUtils.withComma(val, this.rs.getInt("FRptExRatePre")));
        } else if (col[i][1].endsWith("Qty")) {
            drs.updateString(col[i][0], GlUtils.withComma(val, (Integer)this.mapParame.get("qtyScale")));
        } else {
            drs.updateString(col[i][0], val.toString());
        }
    }

    private int getPrecision(CurrencyInfo currency) throws BOSException {
        int precision = 0;
        if (currency == null) {
            Object currencyPre = this.rs.getObject("currencyPre");
            if (currencyPre != null) {
                precision = Integer.parseInt(currencyPre.toString());
            }
        } else {
            precision = currency.getPrecision();
        }
        return precision;
    }

    private void setBFAmount(DynamicRowSet drs, CurrencyInfo currency, CurrencyInfo baseCurrency, CurrencyInfo rptCurrency, int currIndex) throws BOSException, SQLException {
        String desc = this.rs.getString(currIndex, "FDescription");
        if (this.yearBalance.equals(desc)) {
            drs.updateString("fdebit_for", null);
            drs.updateString("fdebit_local", null);
            drs.updateString("fdebit_rpt", null);
            drs.updateString("fcredit_for", null);
            drs.updateString("fcredit_local", null);
            drs.updateString("fcredit_rpt", null);
        } else if (!this.periodEndBalance.equals(desc) && !this.periodStartBalance.equals(desc)) {
            String creditRpt;
            String debitFor = this.isSumPeriod ? "FDebitFor" : "FYearDebitFor";
            String debitLocal = this.isSumPeriod ? "FDebitLocal" : "FYearDebitLocal";
            String debitRpt = this.isSumPeriod ? "FDebitRpt" : "FYearDebitRpt";
            String creditFor = this.isSumPeriod ? "FCreditFor" : "FYearCreditFor";
            String creditLocal = this.isSumPeriod ? "FCreditLocal" : "FYearCreditLocal";
            String string = creditRpt = this.isSumPeriod ? "FCreditRpt" : "FYearCreditRpt";
            if (this.rs.indexOf(debitFor) != -1) {
                drs.updateString("fdebit_for", GlUtils.withComma(this.rs.getBigDecimal(currIndex, debitFor), this.getPrecision(currency)));
                if (this.isBaseCurrency(currency, baseCurrency)) {
                    drs.updateString("fdebit_local", GlUtils.withComma(this.rs.getBigDecimal(currIndex, debitFor), baseCurrency.getPrecision()));
                }
            }
            if (this.rs.indexOf(debitLocal) != -1) {
                drs.updateString("fdebit_local", GlUtils.withComma(this.rs.getBigDecimal(currIndex, debitLocal), baseCurrency.getPrecision()));
            }
            if (this.rs.indexOf(debitRpt) != -1) {
                drs.updateString("fdebit_rpt", GlUtils.withComma(this.rs.getBigDecimal(currIndex, debitRpt), rptCurrency.getPrecision()));
            }
            if (this.rs.indexOf(creditFor) != -1) {
                drs.updateString("fcredit_for", GlUtils.withComma(this.rs.getBigDecimal(currIndex, creditFor), this.getPrecision(currency)));
                if (this.isBaseCurrency(currency, baseCurrency)) {
                    drs.updateString("fcredit_local", GlUtils.withComma(this.rs.getBigDecimal(currIndex, creditFor), baseCurrency.getPrecision()));
                }
            }
            if (this.rs.indexOf(creditLocal) != -1) {
                drs.updateString("fcredit_local", GlUtils.withComma(this.rs.getBigDecimal(currIndex, creditLocal), baseCurrency.getPrecision()));
            }
            if (this.rs.indexOf(creditRpt) != -1) {
                drs.updateString("fcredit_rpt", GlUtils.withComma(this.rs.getBigDecimal(currIndex, creditRpt), rptCurrency.getPrecision()));
            }
        }
    }

    private boolean isBaseCurrency(CurrencyInfo currency, CurrencyInfo baseCurrency) {
        return currency != null && baseCurrency.getId().equals((Object)currency.getId());
    }

    private void setEmptyStr(DynamicRowSet drs) throws SQLException {
        drs.updateString("faccountNumName", "");
        drs.updateString("fbookeddateYear", "");
        drs.updateString("fbookeddateMonth", "");
        drs.updateString("fbookeddateDay", "");
        drs.updateString("faccountnumber", "");
        drs.updateString("faccountname", "");
        drs.updateString("fperiodyear", "");
        drs.updateString("fperiodnumber", "");
        drs.updateString("fbookeddateRedundancy", "");
        drs.updateString("fvouchertype", "");
        drs.updateString("fvoucherno", "");
        drs.updateString("fcurrencyname", "");
        drs.updateString("fcurrencynumber", "");
        drs.updateString("fprecision", "");
        drs.updateString("flocalexchangerate", "");
        drs.updateString("freportingexchangerate", "");
        drs.updateString("FMEASUREUNITNUMBER", "");
        drs.updateString("FMEASUREUNITNAME", "");
        drs.updateString("fcoefficient", "");
        drs.updateString("fbiznumber", "");
        drs.updateString("finvoicenumber", "");
        drs.updateString("fsettlementcode", "");
        drs.updateString("settlename", "");
        drs.updateString("fticketnumber", "");
    }

    private StringBuffer updateYear(GLRptRowSet rs, DynamicRowSet drs, StringBuffer sbYear, int rowLineCount, int rowCount) throws Exception, SQLException {
        if (rowCount % rowLineCount == 1) {
            sbYear = new StringBuffer();
            String[] albookeddateYear = this.getMoreYear(rs, rowCount, rowLineCount);
            int n = albookeddateYear.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sbYear.append(" - ");
                }
                sbYear.append(albookeddateYear[i]);
            }
            if (sbYear.length() == 0) {
                sbYear = this.sbYear;
            }
        }
        if (sbYear != null) {
            drs.updateString("fbdYear", sbYear.toString());
        }
        return sbYear;
    }

    private String getAsstitemID(GLRptRowSet rs) throws BOSException, SQLException {
        StringBuffer asstItemId = new StringBuffer();
        for (int i = 0; i < this.asstTypeList.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)this.asstTypeList.get(i);
            if (i > 0) {
                asstItemId.append(";");
            }
            asstItemId.append(rs.getString(at.getHgField()));
        }
        return asstItemId.toString();
    }

    private void updateAsstitem(DynamicRowSet drs, GLRptRowSet rs) throws BOSException, SQLException {
        StringBuffer asstItemName = new StringBuffer();
        StringBuffer asstItemId = new StringBuffer();
        for (int i = 0; i < this.asstTypeList.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)this.asstTypeList.get(i);
            if (i > 0) {
                asstItemName.append(";");
                asstItemId.append(";");
            }
            asstItemName.append("[").append(at.getName()).append("]").append(rs.getObject(at.getHgAttribute() + "Name").toString());
            asstItemId.append(rs.getString(at.getHgField()));
        }
        drs.updateObject("h_Asstact", (Object)asstItemName.toString());
    }

    private CurrencyInfo getCurrency(CurrencyInfo baseCurrency, CurrencyInfo rptCurrency, String currencyId) throws BOSException, EASBizException {
        CurrencyInfo currency = null;
        if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            currency = baseCurrency;
        } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            currency = rptCurrency;
        } else if (!currencyId.equalsIgnoreCase("AllCurrency")) {
            currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        }
        return currency;
    }

    private String[] getMoreYear(GLRptRowSet rs, int rowCount, int rowLineCount) throws Exception {
        HashSet<String> albookeddateYear = new HashSet<String>();
        int currIndex = rs.getCurrRowIndex();
        String lastAsstitem = null;
        do {
            String it = this.getAsstitemID(rs);
            if (lastAsstitem != null && !it.equals(lastAsstitem)) break;
            lastAsstitem = it;
            String strDate = rs.getString("fbookeddate");
            if (strDate != null) {
                String[] sDate = strDate.split("\\-");
                albookeddateYear.add(sDate[0]);
            } else if (rs.getObject("FPeriod") != null) {
                String[] p = rs.getString("FPeriod").split("\\.");
                albookeddateYear.add(p[0]);
            }
            int curr = rs.getCurrRowIndex();
            if (this.bBF && (rowCount + 1) % rowLineCount == 0 && rs.next() && rs.next() && (it = this.getAsstitemID(rs)).equals(lastAsstitem)) break;
            rs.absolute(curr);
            if (rowCount % rowLineCount == 0) break;
            ++rowCount;
        } while (rs.next());
        rs.absolute(currIndex);
        Object[] years = new String[albookeddateYear.size()];
        years = albookeddateYear.toArray(years);
        Arrays.sort(years);
        return years;
    }

    private void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }
}

