/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ParamEx;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactItemFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptAsstactGDQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptAsstactGDQueryUI
extends AbstractGLRptAsstactGDQueryUI {
    private static final long serialVersionUID = -2297816402878360261L;
    private static final Logger logger = CoreUIObject.getLogger(GLRptAsstactGDQueryUI.class);
    private boolean isQtyAsst = false;
    boolean bool = false;
    public static final String RES = "com.kingdee.eas.fi.gl.GLAutoGenerateResource";

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.isQtyAsst = this.getCustomCondition().getRptParams().isQtyAsst();
        this.prbMeasureUnit.setEditable(this.isQtyAsst);
        this.prbMeasureUnit.setEditFormat("$number$");
        this.prbMeasureUnit.setDisplayFormat("$number$ - $name$");
        this.prbMeasureUnit.setCommitFormat("$number$;$name$");
        this.prbMeasureUnit.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherMeasureUnitQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("coefficient"));
        sic.add(new SelectorItemInfo("isDisabled"));
        sic.add(new SelectorItemInfo("measureUnitGroup.id"));
        this.prbMeasureUnit.setSelectorCollection(sic);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)0));
        this.prbMeasureUnit.setEntityViewInfo(view);
        this.jcbSumByMeasureUnit.setEnabled(false);
        this.setCustomCondition();
    }

    protected void setCustomCondition() throws Exception {
        GLRptAsstactGDUI parentUI = (GLRptAsstactGDUI)this.getUIContext().get("Owner");
        Map parentUICtx = parentUI.getUIContext();
        if (parentUICtx.get("JoinQuery") != null) {
            AccountViewCollection acColl;
            this.bool = true;
            this.getUIContext().put("JoinQuery", parentUICtx.get("JoinQuery"));
            GLRptBaseCondition condition = (GLRptBaseCondition)parentUICtx.get("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS");
            String accountAtr = condition.getAccountCodeStart();
            String accountTableId = condition.getAccountTableId();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountAtr));
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)this.getCurrCompany().getId().toString()));
            if (accountTableId != null) {
                filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableId));
            }
            if ((acColl = AccountViewFactory.getRemoteInstance().getAccountViewCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null))) != null && acColl.size() > 0) {
                condition.setAccountViewStart(acColl.get(0));
                condition.setAccountViewEnd(acColl.get(0));
            }
            this.setCustomCondition(condition);
        }
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.chkShowQty.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                GLRptAsstactGDQueryUI.this.prbMeasureUnit.setEnabled(selected && GLRptAsstactGDQueryUI.this.isQtyAsst);
                GLRptAsstactGDQueryUI.this.jcbSumByMeasureUnit.setEnabled(selected && GLRptAsstactGDQueryUI.this.isQtyAsst);
                if (!selected) {
                    GLRptAsstactGDQueryUI.this.prbMeasureUnit.setValue(null);
                    GLRptAsstactGDQueryUI.this.jcbSumByMeasureUnit.setSelected(false);
                }
            }
        });
        this.prbMeasureUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() != null) {
                    GLRptAsstactGDQueryUI.this.jcbSumByMeasureUnit.setSelected(true);
                }
                GLRptAsstactGDQueryUI.this.jcbSumByMeasureUnit.setEnabled(GLRptAsstactGDQueryUI.this.chkShowQty.isSelected() && e.getNewValue() == null);
            }
        });
    }

    @Override
    public GLRptBaseCondition getCustomCondition() {
        GLRptAsstactGDCondition cond = (GLRptAsstactGDCondition)super.getCustomCondition();
        MeasureUnitInfo measureUnit = (MeasureUnitInfo)this.prbMeasureUnit.getValue();
        cond.setMeasureUnitId(measureUnit == null ? null : measureUnit.getId().toString());
        cond.setDisplayAttribute(this.jcbDisplayAttribute.isSelected());
        cond.setGroupByAsst(this.onlyAsstact.isSelected());
        cond.setGroupByMU(this.jcbSumByMeasureUnit.isSelected());
        cond.setSumPeriod(this.jcbSumPeriod.isSelected());
        cond.setNoDisplayZeroTotal(this.jcbNoDisplayZeroTotal.isSelected());
        cond.setShowAsstItemTotal(this.jcbShowSum.isSelected());
        cond.setOptionAmountAndBalZero(this.chkAmountAndBalZero.isSelected());
        cond.setShowDailyTotal(this.chkOpDailyTotal.isSelected());
        return cond;
    }

    @Override
    public void setCustomCondition(GLRptBaseCondition condition) throws EASBizException, BOSException {
        super.setCustomCondition(condition);
        GLRptAsstactGDCondition cond = (GLRptAsstactGDCondition)condition;
        if (cond.getMeasureUnitId() == null) {
            this.prbMeasureUnit.setValue(null);
        } else {
            try {
                MeasureUnitInfo measureUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(cond.getMeasureUnitId()));
                this.prbMeasureUnit.setValue((Object)measureUnit);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.prbMeasureUnit.setEnabled(this.chkShowQty.isSelected());
        if (cond.isGroupByAsst()) {
            this.onlyAsstact.setSelected(true);
        } else {
            this.asstactAndAccount.setSelected(true);
        }
        this.jcbDisplayAttribute.setSelected(cond.isDisplayAttribute());
        this.jcbSumByMeasureUnit.setSelected(cond.isGroupByMU());
        this.jcbSumPeriod.setSelected(cond.isSumPeriod());
        this.jcbNoDisplayZeroTotal.setSelected(cond.isNoDisplayZeroTotal());
        this.jcbShowSum.setSelected(cond.isShowAsstItemTotal());
        this.chkOpDailyTotal.setSelected(cond.isShowDailyTotal());
    }

    @Override
    protected GLRptBaseCondition createReportCondition() {
        return new GLRptAsstactGDCondition();
    }

    @Override
    protected boolean canMergeDisplay() {
        return false;
    }

    @Override
    protected GLRptBaseCondition createReportCondition(Map param) throws CloneNotSupportedException {
        return new GLRptAsstactGDCondition(param);
    }

    @Override
    protected IGLRptBaseFacade getIGLRptBaseFacade() throws BOSException {
        return GLRptAsstactItemFacadeFactory.getRemoteInstance();
    }

    @Override
    public void clear() {
        GLRptAsstactGDUI parentUI = (GLRptAsstactGDUI)this.getUIContext().get("Owner");
        Map parentUICtx = parentUI.getUIContext();
        if (parentUICtx.get("JoinQuery") != null && this.bool) {
            this.bool = false;
            return;
        }
        super.clear();
        this.chkShowLeafAccount.setSelected(true);
        this.prbMeasureUnit.setValue(null);
        this.prbMeasureUnit.setEnabled(false);
        this.asstactAndAccount.setSelected(true);
        this.jcbSumByMeasureUnit.setSelected(false);
        this.jcbSumPeriod.setSelected(false);
        this.jcbNoDisplayZeroTotal.setSelected(false);
        this.jcbShowSum.setSelected(false);
        this.chkOpDailyTotal.setSelected(false);
    }

    @Override
    protected String getNRptUI() {
        return "com.kingdee.eas.fi.gl.rpt.client.GLNRptAsstactGDExportUI";
    }

    @Override
    protected String getNRptSimpleUI() {
        return "com.kingdee.eas.fi.gl.rpt.client.GLNRptAsstactGDUI";
    }

    public String getResourceFromAuto(String resName) {
        return EASResource.getString((String)RES, (String)resName);
    }

    @Override
    protected List<ParamEx> getDefaultParamExs() {
        List<ParamEx> paramExs = super.getDefaultParamExs();
        ParamEx paramEx = new ParamEx("voucher_query_hint", "", "", this.getResourceFromAuto("GLRptAsstactGDUI1"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("VoucherQuery_EntryJoinOn_CompanyAndPeriod", "false", "false", this.getResourceFromAuto("GLRptAsstactGDUI2"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("VoucherQuery_AssistJoinOn_CompanyAndPeriod", "false", "false", this.getResourceFromAuto("GLRptAsstactGDUI3"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("VoucherQuery_AssistJoinOn_Account", "false", "false", this.getResourceFromAuto("GLRptAsstactGDUI4"));
        paramExs.add(paramEx);
        return paramExs;
    }

    @Override
    public void actionEditExtendParams_actionPerformed(ActionEvent e) throws Exception {
        this.showParamExUI();
    }

    @Override
    protected void showAdvanceActionPerformed(ActionEvent e) {
        this.lbExtendParams.setVisible(!this.lbExtendParams.isVisible());
        this.btnEditExtendParams.setVisible(!this.btnEditExtendParams.isVisible());
        this.btnEditExtendParams.setEnabled(true);
    }
}

