/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.client.GLRptExcelExporter;
import com.kingdee.eas.util.client.EASResource;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;

public class GLRptAsstactGGExcelExporter
extends GLRptExcelExporter {
    public GLRptAsstactGGExcelExporter(GLRptAsstactBaseCondition cond, Map<String, Object> params) {
        super(cond, params);
    }

    @Override
    protected int createRptHead(HSSFWorkbook wb, HSSFSheet sheet) {
        int rowIndex = 0;
        HSSFRow row = sheet.createRow(rowIndex++);
        GLRptAsstactBaseCondition cond = this.getCond();
        HSSFCell cell = row.createCell(0);
        cell.setCellValue((RichTextString)new HSSFRichTextString((String)this.params.get("AsstAct")));
        CellRangeAddress rang = new CellRangeAddress(0, 0, 0, 1);
        sheet.addMergedRegion(rang);
        cell = row.createCell(2);
        cell.setCellValue((RichTextString)new HSSFRichTextString((String)this.params.get("AsstActItem")));
        rang = new CellRangeAddress(0, 0, 2, 3);
        sheet.addMergedRegion(rang);
        cell = row.createCell(4);
        cell.setCellValue((RichTextString)new HSSFRichTextString((String)this.params.get("Period")));
        rang = new CellRangeAddress(0, 0, 4, 5);
        sheet.addMergedRegion(rang);
        cell = row.createCell(6);
        cell.setCellValue((RichTextString)new HSSFRichTextString((String)this.params.get("Currency")));
        rang = new CellRangeAddress(0, 0, 6, 7);
        sheet.addMergedRegion(rang);
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            cell = row.createCell(8);
            cell.setCellValue((RichTextString)new HSSFRichTextString(cond.getCompany().getName()));
            rang = new CellRangeAddress(0, 0, 8, 9);
            sheet.addMergedRegion(rang);
        }
        String optionPosting = cond.getOptionPosting() ? EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"include_unpostvoucher") : EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"posted_voucher");
        cell = row.createCell(10);
        cell.setCellValue((RichTextString)new HSSFRichTextString(optionPosting));
        rang = new CellRangeAddress(0, 0, 10, 11);
        sheet.addMergedRegion(rang);
        return rowIndex;
    }

    @Override
    protected boolean isTotal(GLRptRowSet data) throws BOSException {
        boolean isTotal = false;
        Object accountID = data.getObject("FAccountID");
        if (accountID == null || accountID.toString().trim().length() == 0) {
            isTotal = true;
        }
        return isTotal;
    }

    @Override
    protected GLRptAsstactBaseCondition getCond() {
        return (GLRptAsstactBaseCondition)super.getCond();
    }

    @Override
    protected String getFileName() {
        return "asstActGGTmp.xls";
    }
}

