/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptPrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGGPrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class GLRptAsstactGGPrintDelegate
extends AbstractGLRptPrintDelegate {
    private String strOverHypoPage = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.overHypoPage");
    private String strBearForwardPage = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.bearForwardPage");
    private String allCurrency = GLResUtil.getRes("all_currency");
    public static final String[][] col = new String[][]{{"sysDateNow", ""}, {"s_CurrentUser", ""}, {"s_Company", ""}, {"yeCode", ""}, {"h_Asst", ""}, {"h_Asstact", ""}, {"h_Period", ""}, {"h_Currency", ""}, {"faccountNumName", ""}, {"fperiodyear", ""}, {"fperiodnumber", ""}, {"fperiod", "FPeriod"}, {"faccountnumber", "accountNumber"}, {"faccountname", "accountName"}, {"fcurrencyname", "currencyName"}, {"fcompanyname", "companyName"}, {"fDCbeginbalance", "beginAccountDC"}, {"fDCendbalance", "endAccountDC"}, {"fbeginbalance", "FBeginBalance"}, {"fdebit", "FDebit"}, {"fcredit", "FCredit"}, {"fyeardebit", "FYearDebit"}, {"fyearcredit", "FYearCredit"}, {"fendbalance", "FEndBalance"}};
    protected Map mapParame = null;
    protected GLRptRowSet rs = null;
    protected boolean bBF = false;
    private List asstTypeList;
    private CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();

    public GLRptAsstactGGPrintDelegate(GLRptRowSet rs, Map mapParame, GLRptBasePrintConfig config) {
        this.mapParame = mapParame;
        if (mapParame.get("company") != null && mapParame.get("company") instanceof CompanyOrgUnitInfo) {
            this.curCompany = (CompanyOrgUnitInfo)mapParame.get("company");
        }
        this.rs = rs;
        this.bBF = ((GLRptAsstactGGPrintConfig)config).isBF();
        this.asstTypeList = (List)mapParame.get("asstTypeList");
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount) {
        DateFormat format = GlUtils.getDateFormat();
        int colCount = col.length;
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = col[i][0];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int size = this.rs.size();
            int iCount = size % rowLineCount == 0 ? size / rowLineCount : size / rowLineCount + 1;
            CurrencyInfo baseCurrency = this.curCompany.getBaseCurrency();
            baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            CurrencyInfo rptCurrency = this.curCompany.getReportCurrency();
            if (rptCurrency != null) {
                rptCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(rptCurrency.getId()));
            }
            String currencyId = (String)this.mapParame.get("currencyId");
            CurrencyInfo currency = null;
            String suff = null;
            if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                currency = baseCurrency;
                suff = "Local";
            } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                currency = rptCurrency;
                suff = "Rpt";
            } else {
                suff = "For";
                if (!currencyId.equalsIgnoreCase("AllCurrency")) {
                    currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                }
            }
            int rowCount = 0;
            this.rs.beforeFirst();
            String lastAsstitem = null;
            while (this.rs.next()) {
                String it;
                String asstItem = this.getAsstitemID(this.rs);
                if (lastAsstitem != null && !asstItem.equals(lastAsstitem)) {
                    if (rowCount % rowLineCount != 0) {
                        rowCount += rowLineCount - rowCount % rowLineCount;
                    }
                    lastAsstitem = asstItem;
                } else {
                    lastAsstitem = asstItem;
                }
                drs.moveToInsertRow();
                this.clearRow((IRowSet)drs);
                int page = ++rowCount % rowLineCount == 0 ? rowCount / rowLineCount : rowCount / rowLineCount + 1;
                drs.updateString("yeCode", page + "/" + iCount);
                StringBuffer sbAccountLongName = new StringBuffer();
                drs.updateString("sysDateNow", GlUtils.formatDate(format, new Date()));
                if (SysContext.getSysContext().getCurrentUserInfo().getName() != null) {
                    drs.updateString("s_CurrentUser", SysContext.getSysContext().getCurrentUserInfo().getName());
                } else {
                    drs.updateString("s_CurrentUser", SysContext.getSysContext().getCurrentUserInfo().toString());
                }
                drs.updateString("s_Company", this.curCompany.toString());
                drs.updateObject("h_Asst", this.mapParame.get("AsstAct"));
                drs.updateObject("h_Period", this.mapParame.get("Period"));
                drs.updateObject("h_Currency", (Object)(currency == null ? this.allCurrency : currency.getName()));
                this.updateAsstitem(drs, this.rs);
                int precision = 0;
                if (currency == null) {
                    Object currencyPre = this.rs.getObject("currencyPre");
                    if (currencyPre != null) {
                        precision = Integer.parseInt(currencyPre.toString());
                    }
                } else {
                    precision = currency.getPrecision();
                }
                int colNum = col.length;
                for (int i = 11; i < colNum; ++i) {
                    String period;
                    Object value;
                    String field = col[i][1];
                    if (i >= 18) {
                        field = field + suff;
                    }
                    if (this.rs.indexOf(field) == -1 || (value = this.rs.getObject(field)) == null) continue;
                    if (value instanceof BigDecimal) {
                        BigDecimal val = (BigDecimal)value;
                        if (val.doubleValue() == 0.0) {
                            drs.updateString(col[i][0], "");
                        } else if (field.endsWith("Local")) {
                            drs.updateString(col[i][0], GlUtils.withComma(val, baseCurrency.getPrecision()));
                        } else if (field.endsWith("Rpt")) {
                            drs.updateString(col[i][0], GlUtils.withComma(val, rptCurrency.getPrecision()));
                        } else if (field.endsWith("For")) {
                            drs.updateString(col[i][0], GlUtils.withComma(val, precision));
                        } else if (field.endsWith("Qty")) {
                            drs.updateString(col[i][0], GlUtils.withComma(val, (Integer)this.mapParame.get("qtyScale")));
                        } else {
                            drs.updateString(col[i][0], val.toString());
                        }
                    } else {
                        drs.updateString(col[i][0], value.toString());
                    }
                    if ((field.equalsIgnoreCase("accountNumber") || field.equalsIgnoreCase("accountName")) && value.toString() != null && !value.toString().trim().equals("")) {
                        if (sbAccountLongName.length() > 0) {
                            sbAccountLongName.append(" - ");
                        }
                        sbAccountLongName.append(value.toString());
                    }
                    if (!field.equalsIgnoreCase("FPeriod") || (period = this.rs.getString("FPeriod")) == null) continue;
                    String[] p = period.split("\\.");
                    drs.updateString("fperiodyear", p[0]);
                    drs.updateString("fperiodnumber", p[1]);
                    drs.updateString("fperiod", period);
                }
                drs.updateString("faccountNumName", sbAccountLongName.toString());
                drs.insertRow();
                if (!this.bBF) continue;
                int currIndex = this.rs.getCurrRowIndex();
                if ((rowCount + 1) % rowLineCount == 0 && this.rs.next() && this.rs.next() && (it = this.getAsstitemID(this.rs)).equals(lastAsstitem)) {
                    drs.moveToInsertRow();
                    drs.updateString("faccountNumName", "");
                    drs.updateString("faccountnumber", this.strOverHypoPage);
                    drs.updateString("faccountname", "");
                    drs.updateString("fperiodyear", "");
                    drs.updateString("fperiodnumber", "");
                    drs.updateString("fperiod", "");
                    drs.updateString("fcurrencyname", "");
                    drs.updateString("fcompanyname", "");
                    String debit = "FDebit" + suff;
                    String credit = "FCredit" + suff;
                    if (this.rs.indexOf(debit) != -1) {
                        drs.updateString("fdebit", GlUtils.withComma(this.rs.getBigDecimal(currIndex, debit), precision));
                    }
                    if (this.rs.indexOf(credit) != -1) {
                        drs.updateString("fcredit", GlUtils.withComma(this.rs.getBigDecimal(currIndex, credit), precision));
                    }
                    drs.insertRow();
                    ++rowCount;
                    drs.moveToInsertRow();
                    drs.updateString("faccountNumName", "");
                    drs.updateString("faccountnumber", this.strBearForwardPage);
                    drs.updateString("faccountname", "");
                    drs.updateString("fperiodyear", "");
                    drs.updateString("fperiodnumber", "");
                    drs.updateString("fperiod", "");
                    drs.updateString("fcurrencyname", "");
                    drs.updateString("fcompanyname", "");
                    ++rowCount;
                    drs.insertRow();
                }
                this.rs.absolute(currIndex);
            }
            drs.beforeFirst();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            e.printStackTrace();
            SysUtil.abort();
        }
        return drs;
    }

    private String getAsstitemID(GLRptRowSet rs) throws BOSException, SQLException {
        StringBuffer asstItemId = new StringBuffer();
        for (int i = 0; i < this.asstTypeList.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)this.asstTypeList.get(i);
            if (i > 0) {
                asstItemId.append(";");
            }
            asstItemId.append(rs.getString(at.getHgField()));
        }
        return asstItemId.toString();
    }

    private void updateAsstitem(DynamicRowSet drs, GLRptRowSet rs) throws BOSException, SQLException {
        StringBuffer asstItemName = new StringBuffer();
        StringBuffer asstItemId = new StringBuffer();
        for (int i = 0; i < this.asstTypeList.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)this.asstTypeList.get(i);
            if (i > 0) {
                asstItemName.append(";");
                asstItemId.append(";");
            }
            asstItemName.append(at.getName()).append(":").append(rs.getString(at.getHgAttribute() + "Name"));
            asstItemId.append(rs.getString(at.getHgField()));
        }
        drs.updateObject("h_Asstact", (Object)asstItemName.toString());
    }

    private void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }
}

