/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGGCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGGExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGGFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactItemFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptAsstactGGUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGGPrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGGPrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGGQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseQueryUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLRptAsstactGGUI
extends AbstractGLRptAsstactGGUI {
    private static final long serialVersionUID = 6179092550173250746L;
    private static final Logger logger = CoreUIObject.getLogger(GLRptAsstactGGUI.class);

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnLinkAsstactGD.setIcon(EASResource.getIcon((String)"imgTbtn_assistantaccountdetail"));
        this.menuItemLinkAsstactGD.setIcon(EASResource.getIcon((String)"imgTbtn_assistantaccountdetail"));
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.dataTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                GLRptAsstactGGUI.this.tblData_SelectChanged(e);
            }
        });
        this.dataTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    GLRptAsstactGGUI.this.joinRptGD();
                }
            }
        });
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    GLRptAsstactGGUI.this.joinRptGD();
                }
            }
        });
    }

    @Override
    protected void setQueryDialogSize(CommonQueryDialog dialog) {
        dialog.setWidth(560);
        dialog.setHeight(540);
    }

    @Override
    protected void tblMain_SelectChanged(KDTable tblMain, int rowIndex) throws Exception {
        super.tblMain_SelectChanged(tblMain, rowIndex);
        if (this.getQueryCond().getCompanyDisplayMode() != CompanyDisplayModeEnum.enumerate) {
            this.actionLinkAsstactGD.setEnabled(false);
        } else {
            this.actionLinkAsstactGD.setEnabled(true);
        }
    }

    @Override
    protected void afterFillDataTableRow(IRow row, String[] colKeys) {
        ICell currencyPreCell;
        if (row.getCell("FAccountID").getValue() == null || row.getCell("FAccountID").getValue().toString().trim().length() == 0) {
            row.getStyleAttributes().setBackground(TOTAL_COLOR);
        }
        if ((currencyPreCell = row.getCell("currencyPre")) != null && currencyPreCell.getValue() != null) {
            int currencyPre = Integer.parseInt(currencyPreCell.getValue().toString());
            String key = null;
            for (int i = 0; i < colKeys.length; ++i) {
                key = colKeys[i];
                if (key == null || !key.endsWith("For")) continue;
                row.getCell(key).getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(currencyPre));
            }
        }
    }

    @Override
    protected void setQueryingActionStatus(boolean enable) {
        super.setQueryingActionStatus(enable);
        this.actionLinkAsstactGD.setEnabled(false);
    }

    @Override
    public void actionLinkAsstactGD_actionPerformed(ActionEvent e) throws Exception {
        this.joinRptGD();
    }

    private void joinRptGD() {
        if (!this.verifyJoinRptGD()) {
            return;
        }
        GLRptAsstactGDCondition cond = new GLRptAsstactGDCondition(this.getQueryCond());
        cond.setCompanyDisplayMode(CompanyDisplayModeEnum.enumerate);
        if (cond.getCompany() == null || !cond.getCompany().isIsBizUnit()) {
            cond.setAccountIdSet((Set)null);
        }
        try {
            this.joinQury(cond, GLRptAsstactGDUI.class.getName());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private boolean verifyJoinRptGD() {
        Object obj;
        if (this.getQueryCond().getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            return true;
        }
        int rowIndex = this.dataTable.getSelectManager().getActiveRowIndex();
        return rowIndex != -1 && (this.getQueryCond().getCompanyDisplayMode() == CompanyDisplayModeEnum.level ? (obj = this.dataTable.getRow(rowIndex).getCell("companyName").getValue()) instanceof GLRptTreeNode && ((GLRptTreeNode)obj).isLeaf() : this.getQueryCond().getCompanyDisplayMode() == CompanyDisplayModeEnum.merger && this.dataTable.getRow(rowIndex).getCell("FOrgUnitID").getValue() != null);
    }

    @Override
    protected GLRptExcelExporter getExporter(Map<String, Object> params) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("AsstAct", this.jtAsst.getText());
        params.put("AsstActItem", this.jtAsstact.getText());
        params.put("Period", this.lblPeriod.getText());
        params.put("Currency", this.lblCurrency.getText());
        return new GLRptAsstactGGExcelExporter(params);
    }

    @Override
    public boolean isExportSupportXls() {
        return false;
    }

    @Override
    public boolean isExportSupportXlsx() {
        return true;
    }

    @Override
    protected String getJoinExportAllLabel() {
        return GLResUtil.getRes("export_asstact_gg");
    }

    @Override
    protected String getJoinExportSelectedLabel() {
        return GLResUtil.getRes("export_part_asstact_gg_account");
    }

    @Override
    protected GLRptBaseCondition createQueryCond(Map param) {
        try {
            return new GLRptAsstactGGCondition(param);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
            return null;
        }
    }

    @Override
    protected GLRptBaseQueryUI getCustQueryPanel() throws Exception {
        return new GLRptAsstactGGQueryUI();
    }

    @Override
    protected String getPrintConfigUIName() {
        return "com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGGPrintConfigUI";
    }

    @Override
    protected GLRptBasePrintConfig getPrintConfig() {
        return new GLRptAsstactGGPrintConfig(this);
    }

    @Override
    protected BOSQueryDelegate getPrintQueryDelegate(GLRptRowSet rs, GLRptBaseCondition cond, GLRptBasePrintConfig config) throws EASBizException, BOSException {
        return new GLRptAsstactGGPrintDelegate(rs, this.getPrintVar(cond), config);
    }

    protected Map getPrintVar(GLRptBaseCondition condition) throws EASBizException, BOSException {
        HashMap<String, Object> printParams = new HashMap<String, Object>();
        GLRptAsstactGGCondition cond = (GLRptAsstactGGCondition)condition;
        printParams.put("qtyScale", new Integer(cond.getQtyScale()));
        printParams.put("AsstAct", this.getAsstactName4New());
        printParams.put("currencyId", cond.getCurrencyID());
        printParams.put("CurrencyName", cond.getCurrencyName());
        printParams.put("asstTypeList", cond.getAsstActList());
        printParams.put("Period", this.lblPeriod.getText());
        printParams.put("company", cond.getCompany());
        return printParams;
    }

    private String getAsstactName4New() {
        GLRptAsstactGGCondition cond = (GLRptAsstactGGCondition)this.getQueryCond();
        Iterator actIt = cond.getAsstActList().iterator();
        StringBuffer actTypeNames = new StringBuffer();
        actTypeNames.append(((AsstactTypeEntity)actIt.next()).getName());
        while (actIt.hasNext()) {
            actTypeNames.append(",").append(((AsstactTypeEntity)actIt.next()).getName());
        }
        return actTypeNames.toString();
    }

    @Override
    protected IGLRptBaseFacade getIGLRptFacade() throws BOSException {
        return GLRptAsstactItemFacadeFactory.getRemoteInstance();
    }

    @Override
    protected IGLRptBaseFacade getIGLRptDataFacade() throws BOSException {
        return GLRptAsstactGGFacadeFactory.getRemoteInstance();
    }

    protected void tblData_SelectChanged(KDTSelectEvent e) {
        CompanyOrgUnitInfo company = this.getQueryCond().getCompany();
        if (!company.isIsBizUnit()) {
            Object obj;
            int rowIndex = this.dataTable.getSelectManager().getActiveRowIndex();
            if (rowIndex != -1 && (obj = this.dataTable.getRow(rowIndex).getCell("companyName").getValue()) instanceof GLRptTreeNode) {
                this.actionLinkAsstactGD.setEnabled(((GLRptTreeNode)obj).isLeaf());
            }
        } else {
            boolean isEnableJoinGD = true;
            if (CompanyDisplayModeEnum.merger == this.getQueryCond().getCompanyDisplayMode()) {
                Object obj;
                isEnableJoinGD = false;
                int rowIndex = this.dataTable.getSelectManager().getActiveRowIndex();
                if (rowIndex != -1 && (obj = this.dataTable.getRow(rowIndex).getCell("FOrgUnitID").getValue()) != null) {
                    isEnableJoinGD = true;
                }
            }
            this.actionLinkAsstactGD.setEnabled(isEnableJoinGD);
        }
    }

    @Override
    protected String getPermissionItem() {
        return "gl_rptasstact_gg_view";
    }

    @Override
    protected String getExportPermissionItem() {
        return "gl_rptasstact_gg_export";
    }

    @Override
    protected GLRptBaseCondition getDefaultQueryCondtion() throws BOSException, EASBizException, Exception {
        AsstAccountInfo caa;
        GLRptAsstactGGCondition cond = (GLRptAsstactGGCondition)super.getDefaultQueryCondtion();
        Map condition = (Map)this.getUIContext().get("JoinQuery_Outer_Params_condition");
        if (condition == null) {
            return cond;
        }
        if (cond == null) {
            cond = new GLRptAsstactGGCondition();
        }
        this.getUIContext().put("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", cond);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)condition.get("company");
        cond.setCompany(company);
        AccountViewInfo accountViewInfoFrom = (AccountViewInfo)condition.get("jebAccountFrom");
        cond.setAccountViewStart(accountViewInfoFrom);
        if (accountViewInfoFrom != null) {
            cond.setAccountCodeStart(accountViewInfoFrom.getNumber());
        }
        AccountViewInfo accountViewInfoTo = (AccountViewInfo)condition.get("jebAccountTo");
        cond.setAccountViewEnd(accountViewInfoTo);
        if (accountViewInfoTo != null) {
            cond.setAccountCodeEnd(accountViewInfoTo.getNumber());
        }
        if ((caa = (AsstAccountInfo)condition.get("jebAcct")) != null) {
            cond.setAsstAccountId(caa.getId().toString());
        }
        Integer accountViewInfoLevelFrom = (Integer)condition.get("jspLevelFrom");
        cond.setAccountLevelStart(accountViewInfoLevelFrom);
        Integer accountViewInfoLevelTo = (Integer)condition.get("jspLevelTo");
        cond.setAccountLevelEnd(accountViewInfoLevelTo);
        cond.setAsstActList((List)condition.get("tableData"));
        Integer yearFrom = (Integer)condition.get("jspYearFrom");
        cond.setPeriodYearStart(yearFrom);
        Integer yearTo = (Integer)condition.get("jspYearTo");
        cond.setPeriodYearEnd(yearTo);
        Integer periodFrom = (Integer)condition.get("jspPeriodFrom");
        cond.setPeriodNumberStart(periodFrom);
        Integer periodTo = (Integer)condition.get("jspPeriodTo");
        cond.setPeriodNumberEnd(periodTo);
        CurrencyInfo currency = (CurrencyInfo)condition.get("jbxCurrency");
        cond.setCurrencyID(currency.getId().toString());
        cond.setCurrencyName(currency.getName());
        Boolean IncludeUnPost = (Boolean)condition.get("jcbIncludeUnPost");
        cond.setOptionPosting(IncludeUnPost);
        Boolean displayAmount = (Boolean)condition.get("jcbDisplayAmount");
        if (displayAmount == null) {
            displayAmount = new Boolean(false);
        }
        cond.setShowQty(displayAmount);
        return cond;
    }

    @Override
    protected String getKDSplitPaneDividerLocationSettingFunction() {
        return "fi.gl.rpt.AsstactGGKDSplitPaneDividerLocationSetting";
    }
}

