/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptRowData;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptPrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactMultiColumnPrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptAsstactMultiColumnPrintDelegate
extends AbstractGLRptPrintDelegate {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactMultiColumnPrintDelegate");
    public static final String RES_AUTO_GEN_RES = "com.kingdee.eas.fi.gl.GLAutoGenerateResource";
    protected String[] colVal = new String[]{"sysDateNow", "yeCode", "periodParame", "schemaParame", "keMuParame", "TopAccountViewName", "AccountLongName", "unitParame", "createPerpor", "accountDC", "strAssttype", "accountAndAsst", "FDateYear", "FDateMonth", "FDateDay"};
    protected String[] col = null;
    protected String[][] mulTitles = null;
    protected GLRptRowSet rs;
    protected GLRptRowSet pSumRs;
    protected GLRptTableHeadInfo tableHeadInfo;
    protected Map baseInfo;
    boolean bBF = false;

    public GLRptAsstactMultiColumnPrintDelegate(GLRptRowSet rs, GLRptTableHeadInfo tableHeadInfo, Map baseInfo, GLRptBasePrintConfig config) {
        this.rs = rs;
        this.pSumRs = new GLRptRowSet(tableHeadInfo.getColNames(), 1);
        try {
            this.pSumRs.insertRow();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.tableHeadInfo = tableHeadInfo;
        this.baseInfo = baseInfo;
        this.bBF = ((GLRptAsstactMultiColumnPrintConfig)config).isChkBf();
        this.setMulTitles();
        this.setCol(rs.getColumKeys());
    }

    private void setCol(String[] strColName) {
        int i;
        int iCol = this.colVal.length;
        int iColumnCount = 0;
        for (int j = 0; j < this.tableHeadInfo.getColumnSize(); ++j) {
            GLRptTableHeadInfo.GLRptTableColumnInfo columnInfo = this.tableHeadInfo.getTableColumnInfo(j);
            if (columnInfo.isHide()) continue;
            ++iColumnCount;
        }
        int iMulTitles = 0;
        for (int i2 = 0; i2 < this.mulTitles.length; ++i2) {
            iMulTitles += this.mulTitles[i2].length;
        }
        this.col = new String[iMulTitles + iColumnCount + iCol];
        int index = 0;
        for (i = 0; i < this.mulTitles.length; ++i) {
            for (int j = 0; j < this.mulTitles[i].length; ++j) {
                this.col[index++] = i == this.mulTitles.length - 1 ? "AuxActType" + j : "head" + i + "AuxActType" + j;
            }
        }
        for (i = 0; i < iColumnCount; ++i) {
            this.col[index++] = i + 1 + "";
        }
        for (int j = 0; j < iCol; ++j) {
            this.col[index++] = this.colVal[j];
        }
    }

    private void setMulTitles() {
        String[][] titles = this.tableHeadInfo.getHeadTitle();
        this.mulTitles = new String[titles.length][];
        int lines = 0;
        for (int j = 0; j < titles[0].length; ++j) {
            GLRptTableHeadInfo.GLRptTableColumnInfo columnInfo = this.tableHeadInfo.getTableColumnInfo(j);
            if (columnInfo.isHide() || columnInfo.getColName().indexOf("_") == columnInfo.getColName().lastIndexOf("_")) continue;
            ++lines;
        }
        for (int i = 0; i < titles.length; ++i) {
            LinkedHashSet<String> mulTitleSet = new LinkedHashSet<String>();
            if (i == titles.length - 1) {
                this.mulTitles[i] = new String[lines];
            }
            int index = 0;
            for (int j = 0; j < titles[i].length; ++j) {
                GLRptTableHeadInfo.GLRptTableColumnInfo columnInfo = this.tableHeadInfo.getTableColumnInfo(j);
                if (columnInfo.isHide() || columnInfo.getColName().indexOf("_") == columnInfo.getColName().lastIndexOf("_")) continue;
                String res = EASResource.getString((String)this.getResourceName(), (String)titles[i][j]);
                if (res == null || res.equals("Missing Resource")) {
                    res = titles[i][j];
                }
                if (i == titles.length - 1) {
                    this.mulTitles[i][index] = res;
                    ++index;
                    continue;
                }
                mulTitleSet.add(res);
            }
            if (i == titles.length - 1) continue;
            this.mulTitles[i] = new String[mulTitleSet.size()];
            Iterator it = mulTitleSet.iterator();
            int colIndex = 0;
            while (it.hasNext()) {
                this.mulTitles[i][colIndex++] = (String)it.next();
            }
        }
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount) {
        int colCount = this.col.length;
        DynamicRowSet drs = null;
        try {
            drs = this.createDynamicRowSet(colCount);
            int it = this.rs.size() + 1;
            int iCount = 0;
            iCount = this.bBF ? (it <= rowLineCount - 1 ? 1 : (it <= 2 * (rowLineCount - 1) ? 2 : ((it - 2 * (rowLineCount - 1)) % (rowLineCount - 2) == 0 ? (it - 2 * (rowLineCount - 1)) / (rowLineCount - 2) + 2 : (it - 2 * (rowLineCount - 1)) / (rowLineCount - 2) + 3))) : (it % rowLineCount == 0 ? it / rowLineCount : it / rowLineCount + 1);
            int entryCount = 0;
            String perLineNo = null;
            while (this.rs.next()) {
                ++entryCount;
                int page = 0;
                boolean needBF = false;
                if (this.bBF) {
                    page = entryCount <= rowLineCount - 1 ? 1 : (iCount == 2 ? 2 : (entryCount > (iCount - 1) * (rowLineCount - 2) + 1 ? iCount : ((entryCount - 1) % (rowLineCount - 2) == 0 ? (entryCount - 1) / (rowLineCount - 2) : (entryCount - 1) / (rowLineCount - 2) + 1)));
                    if (entryCount == rowLineCount - 1) {
                        needBF = true;
                    } else if (entryCount == rowLineCount - 1 + (page - 1) * (rowLineCount - 2) && page != iCount) {
                        needBF = true;
                    }
                } else {
                    page = entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                }
                this.insertRow(this.rs, drs, page, iCount, perLineNo, true);
                String strDate = this.rs.getDate("bizDate").toString();
                int iQ = strDate.indexOf("-");
                int iH = strDate.lastIndexOf("-");
                perLineNo = strDate.substring(0, iQ) + strDate.substring(iQ + 1, iH);
                if (!needBF) continue;
                String GUO_CHI_YE = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.overHypoPage");
                String CHENG_QIAN_YE = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.bearForwardPage");
                this.pSumRs.updateString(0, "description", GUO_CHI_YE);
                this.pSumRs.updateString(0, "voucherTypeName", null);
                this.insertRow(this.pSumRs, drs, page, iCount, perLineNo, false);
                this.pSumRs.updateString(0, "description", CHENG_QIAN_YE);
                this.pSumRs.updateString(0, "voucherTypeName", null);
                this.insertRow(this.pSumRs, drs, page + 1, iCount, perLineNo, false);
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return drs;
    }

    private void insertRow(GLRptRowSet glrs, DynamicRowSet drs, int page, int iCount, String perLineNo, boolean needSum) throws Exception {
        DateFormat format = GlUtils.getDateFormat();
        drs.moveToInsertRow();
        GLRptAsstactMultiColumnPrintDelegate.clearRow((IRowSet)drs);
        drs.updateString("periodParame", this.baseInfo.get("kdlPeriod").toString());
        drs.updateString("schemaParame", this.baseInfo.get("kdlSchema").toString());
        drs.updateString("keMuParame", this.baseInfo.get("keMuParame").toString());
        drs.updateString("TopAccountViewName", this.baseInfo.get("TopAccountViewName").toString());
        drs.updateString("AccountLongName", this.baseInfo.get("AccountLongName").toString());
        drs.updateString("accountDC", this.baseInfo.get("accountDC").toString());
        drs.updateString("unitParame", this.baseInfo.get("CompanyName").toString());
        drs.updateString("strAssttype", this.baseInfo.get("strAssttype").toString());
        drs.updateString("accountAndAsst", this.baseInfo.get("accountAndAsst").toString());
        drs.updateString("sysDateNow", GlUtils.formatDate(format, new java.util.Date()));
        drs.updateString("createPerpor", SysContext.getSysContext().getCurrentUserInfo().getName());
        drs.updateString("yeCode", page + "/" + iCount);
        for (int i = 0; i < this.mulTitles.length; ++i) {
            for (int j = 0; j < this.mulTitles[i].length; ++j) {
                if (i == this.mulTitles.length - 1) {
                    drs.updateString("AuxActType" + j, this.mulTitles[i][j]);
                    continue;
                }
                drs.updateString("head" + i + "AuxActType" + j, this.mulTitles[i][j]);
            }
        }
        int index = 1;
        String no = glrs.getString("no");
        for (int i = 0; i < this.tableHeadInfo.getColumnSize(); ++i) {
            GLRptTableHeadInfo.GLRptTableColumnInfo columnInfo = this.tableHeadInfo.getTableColumnInfo(i);
            String colName = columnInfo.getColName();
            Object objValue = glrs.getObject(colName);
            if (this.bBF && needSum) {
                if ("0".equals(no)) {
                    String strDate = glrs.getDate("bizDate").toString();
                    int iQ = strDate.indexOf("-");
                    int iH = strDate.lastIndexOf("-");
                    String lineNo = strDate.substring(0, iQ) + strDate.substring(iQ + 1, iH);
                    if (!lineNo.equals(perLineNo)) {
                        this.pSumRs.updateObject(colName, null);
                    }
                    if (colName.indexOf("_") != -1 && colName.indexOf("_") == colName.lastIndexOf("_") && colName.indexOf("Sum") == -1 && !colName.equals("Orginal_DC") && colName.indexOf("Balance") == -1) {
                        this.pSumRs.updateObject(colName, null);
                    } else if (objValue != null) {
                        if (objValue instanceof BigDecimal) {
                            if (colName.indexOf("Balance") != -1) {
                                this.pSumRs.updateObject(colName, objValue);
                            } else {
                                this.updateRowAmount(this.pSumRs, colName, (BigDecimal)objValue);
                            }
                        } else {
                            this.pSumRs.updateObject(colName, objValue);
                        }
                    }
                } else if ("1".equals(no) || "2".equals(no)) {
                    this.pSumRs.updateObject(colName, objValue);
                }
            }
            if (columnInfo.isHide()) continue;
            String strIndex = "" + index++;
            if (objValue != null) {
                if (objValue instanceof BigDecimal) {
                    if (((BigDecimal)objValue).compareTo(GlUtils.zero) == 0) {
                        drs.updateString(strIndex, "");
                        continue;
                    }
                    int scale = this.tableHeadInfo.getTableColumnInfo(colName).getScale();
                    drs.updateString(strIndex, GlUtils.withComma((BigDecimal)objValue, scale));
                    continue;
                }
                if (objValue instanceof Date) {
                    if (!needSum) continue;
                    drs.updateDate(strIndex, (Date)objValue);
                    String strDate = objValue.toString();
                    int iQ = strDate.indexOf("-");
                    int iH = strDate.lastIndexOf("-");
                    drs.updateString("FDateYear", strDate.substring(0, iQ));
                    drs.updateString("FDateMonth", strDate.substring(iQ + 1, iH));
                    drs.updateString("FDateDay", strDate.substring(iH + 1, strDate.length()));
                    continue;
                }
                drs.updateString(strIndex, objValue.toString());
                continue;
            }
            drs.updateString(strIndex, "");
        }
        drs.insertRow();
    }

    private DynamicRowSet createDynamicRowSet(int colCount) throws SQLException {
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 0; i < colCount; ++i) {
            ColInfo ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = this.col[i];
            ci.nullable = 1;
            drs.setColInfo(i + 1, ci);
        }
        drs.beforeFirst();
        return drs;
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    protected void updateRowAmount(IGLRptRowData rowData, String colName, BigDecimal amount) throws BOSException {
        BigDecimal oldV = rowData.getBigDecimal(colName);
        if (oldV == null) {
            rowData.updateBigDecimal(colName, amount);
        } else {
            BigDecimal dNewV = oldV.add(amount);
            rowData.updateBigDecimal(colName, dNewV);
        }
    }

    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.GLXResource";
    }
}

