/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CommonSchemaInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionAsstactMultiColumn;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.RptCommonSchemaFactory;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.CommonSchema;
import com.kingdee.eas.fi.gl.common.RptConstant;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactMultiColumnFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptAsstactMultiColumnUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactMultiColumnPrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactMultiColumnPrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactMultiColumnQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptTable;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class GLRptAsstactMultiColumnUI
extends AbstractGLRptAsstactMultiColumnUI {
    private static final long serialVersionUID = -3291735817012323272L;
    protected static final String TITLE_RES = "com.kingdee.eas.fi.gl.ReportPeriodExtraRes";
    private AccountViewInfo accountView = null;
    private CommonSchema cs = null;
    private CommonSchemaInfo csi = null;
    private Object[] actAttributes = null;
    private String asstactTypeItemId = null;
    private boolean isAccountShowLongName = false;
    private boolean isGelShowLnum = false;
    private boolean isGelShowLname = false;
    private boolean isShowNum = false;

    @Override
    public boolean isSupportUnion() {
        return false;
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.getTable().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    GLRptAsstactMultiColumnUI.this.tblMain_SelectChanged(e);
                }
                catch (Exception ex) {
                    GLRptAsstactMultiColumnUI.this.handUIException(ex);
                }
            }
        });
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    GLRptUtils.queryVoucher(GLRptAsstactMultiColumnUI.this, GLRptAsstactMultiColumnUI.this.getTable(), "voucherId");
                }
            }
        });
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemQueryVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.actionQueryVoucher.setEnabled(false);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
    }

    @Override
    protected void setReportExtraTitle(GLRptBaseCondition condition) {
        super.setReportExtraTitle(condition);
        String strAccount = EASResource.getString((String)TITLE_RES, (String)"ACCOUNT");
        String strSchema = EASResource.getString((String)TITLE_RES, (String)"Schema");
        ReportConditionAsstactMultiColumn con = (ReportConditionAsstactMultiColumn)condition;
        this.csi = con.getSchema();
        this.kdlSchema.setText(strSchema + this.csi.getNumber() + "-" + this.csi.getName());
        try {
            this.getGLSysParams();
            this.cs = RptCommonSchemaFactory.getRemoteInstance().getSchema(this.csi.getId().toString());
            String accViewId = this.cs.getParams().getString("accountViewID");
            this.accountView = this.getAccountById(accViewId);
            boolean isAccountColumnType = this.cs.getParams().getBoolean("isAccountColumnType");
            String accountName = null;
            accountName = this.isAccountShowLongName ? this.accountView.getLongName(this.getLocale()) : this.accountView.getName(this.getLocale());
            StringBuffer txt = new StringBuffer(this.accountView.getNumber());
            txt.append(" - ");
            txt.append(accountName);
            txt.append("    ");
            List tblData = con.getTableData();
            int size = tblData.size();
            for (int i = 0; i < size; ++i) {
                int last;
                String lnumber;
                AsstactTypeEntity at = (AsstactTypeEntity)tblData.get(i);
                if (!at.isSelected()) continue;
                txt.append(at.getName());
                Object from = at.getFrom();
                Object to = at.getTo();
                txt.append(":");
                if (from != null) {
                    if (this.isShowNum) {
                        if (at.isGeneralActType() && this.isGelShowLnum) {
                            txt.append(((DataBaseInfo)from).get("LongNumber").toString().replaceAll("!", "."));
                        } else if (at.isGeneralActType() && ((DataBaseInfo)from).get("LongNumber") != null) {
                            lnumber = ((DataBaseInfo)from).get("LongNumber").toString();
                            last = lnumber.lastIndexOf("!");
                            if (last != -1) {
                                txt.append(lnumber.substring(last + 1));
                            } else {
                                txt.append(((DataBaseInfo)from).get("Number").toString());
                            }
                        } else {
                            txt.append(((DataBaseInfo)from).get("Number").toString());
                        }
                        txt.append(" ");
                    }
                    if (at.isGeneralActType() && this.isGelShowLname) {
                        txt.append(((DataBaseInfo)from).get("displayName").toString());
                    } else {
                        txt.append(((DataBaseInfo)from).get("Name").toString());
                    }
                }
                if (!(to == null || from != null && ((DataBaseInfo)to).getId().equals((Object)((DataBaseInfo)from).getId()))) {
                    txt.append(" ~ ");
                    if (this.isShowNum) {
                        if (at.isGeneralActType() && this.isGelShowLnum) {
                            txt.append(((DataBaseInfo)to).get("LongNumber").toString().replaceAll("!", "."));
                        } else if (at.isGeneralActType() && ((DataBaseInfo)to).get("LongNumber") != null) {
                            lnumber = ((DataBaseInfo)to).get("LongNumber").toString();
                            last = lnumber.lastIndexOf("!");
                            if (last != -1) {
                                txt.append(lnumber.substring(last + 1));
                            } else {
                                txt.append(((DataBaseInfo)to).get("Number").toString());
                            }
                        } else {
                            txt.append(((DataBaseInfo)to).get("Number").toString());
                        }
                        txt.append(" ");
                    }
                    if (at.isGeneralActType() && this.isGelShowLname) {
                        txt.append(((DataBaseInfo)to).get("displayName").toString());
                    } else {
                        txt.append(((DataBaseInfo)to).get("Name").toString());
                    }
                }
                if (from != null && to == null) {
                    txt.append(" ~ ");
                }
                txt.append(";");
            }
            this.delLastChar(txt);
            this.kDLaccount.setText(strAccount + txt.toString());
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (BOSException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    private void getGLSysParams() throws BOSException, EASBizException {
        String[] paramList = new String[]{"GL_012", "GL_004", "GL_064", "GL_066"};
        String companyId = this.getCompany().getId().toString();
        GlParam glParam = GlParam.getGlParams(null, (String[])paramList, (String)companyId);
        this.isAccountShowLongName = glParam.getBoolean("GL_012");
        this.isGelShowLnum = glParam.getBoolean("GL_064");
        this.isGelShowLname = glParam.getBoolean("GL_066");
        this.isShowNum = glParam.getBoolean("GL_004");
    }

    private AccountViewInfo getAccountById(String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("AC"));
        return AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    @Override
    protected GLRptBaseCondition getQueryCond() {
        ReportConditionAsstactMultiColumn condition = (ReportConditionAsstactMultiColumn)super.getQueryCond();
        if (condition != null) {
            condition.setAsstactTypeItemId(this.asstactTypeItemId);
            condition.setActAttributes(this.actAttributes);
        }
        return condition;
    }

    @Override
    protected void afterFillTableRow(IRow row, String[] colNames) {
        if (row.getCell("no") != null) {
            String no = (String)row.getCell("no").getValue();
            if ("1".equals(no) || "2".equals(no)) {
                row.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_PERIOD_TOTAL);
            } else if ("3".equals(no) || "4".equals(no)) {
                row.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_YEAR_TOTAL);
            } else if ("5".equals(no)) {
                row.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_TOTAL);
            }
        }
    }

    protected void tblMain_SelectChanged(KDTSelectEvent e) throws EASBizException, BOSException {
        GLRptTable tblMain = this.getTable();
        if (tblMain.getSelectManager().get() == null) {
            return;
        }
        int row = tblMain.getSelectManager().get().getTop();
        String voucherId = (String)tblMain.getCell(row, "voucherId").getValue();
        this.actionQueryVoucher.setEnabled(voucherId != null && !"".equals(voucherId));
    }

    @Override
    public void actionQueryVoucher_actionPerformed(ActionEvent e) throws Exception {
        GLRptUtils.queryVoucher(this, this.getTable(), "voucherId");
    }

    @Override
    protected String getPrintConfigUIName() {
        return "com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactMultiColumnPrintConfigUI";
    }

    @Override
    protected GLRptBasePrintConfig getPrintConfig() {
        return new GLRptAsstactMultiColumnPrintConfig(this);
    }

    @Override
    protected GLRptBaseCondition createQueryCond(Map param) {
        try {
            return new ReportConditionAsstactMultiColumn(param);
        }
        catch (CloneNotSupportedException e) {
            this.handUIExceptionAndAbort(e);
            return null;
        }
    }

    @Override
    protected GLRptBaseQueryUI getCustQueryPanel() throws Exception {
        return new GLRptAsstactMultiColumnQueryUI();
    }

    @Override
    protected IGLRptBaseFacade getIGLRptFacade() throws BOSException {
        return GLRptAsstactMultiColumnFacadeFactory.getRemoteInstance();
    }

    @Override
    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.GLReportBalanceListQuery";
    }

    @Override
    protected void invokePrintFunc(boolean noPreview, GLRptBasePrintConfig config) throws Exception {
        KDNoteHelper appHlp = new KDNoteHelper();
        String dir = "/FI/GL/Account/RptAsstactMultiColumnMain";
        GLRptRowSet rs = this.getTable().getData();
        if (!noPreview) {
            appHlp.print(dir, (Object)this.getPrintQueryDelegate(rs, null, config), (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(dir, (Object)this.getPrintQueryDelegate(rs, null, config), (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    protected BOSQueryDelegate getPrintQueryDelegate(GLRptRowSet rs, GLRptBaseCondition cond, GLRptBasePrintConfig config) throws EASBizException, BOSException {
        GLRptTable tblMain = this.getTable();
        return new GLRptAsstactMultiColumnPrintDelegate(rs, tblMain.getTableHeadInfo(), this.getPrintVar(), config);
    }

    protected String getResourceNameForPrint() {
        return "com.kingdee.eas.fi.gl.ReportPrintTitle";
    }

    @Override
    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        String strAccount = EASResource.getString((String)TITLE_RES, (String)"ACCOUNT");
        String strSchema = EASResource.getString((String)TITLE_RES, (String)"Schema");
        String strPrePeriod = EASResource.getString((String)TITLE_RES, (String)"PREPERIOD");
        String strAsstact = EASResource.getString((String)TITLE_RES, (String)"ASSTACT");
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Company_Label"));
        sb.append("&[CompanyName]");
        sb.append("&|");
        sb.append(strPrePeriod).append("&[kdlPeriod]");
        sb.append("&|");
        header.addRow(sb.append("&|").toString(), sa);
        sb.setLength(0);
        sb.append(strSchema).append("&[kdlSchema]");
        sb.append("&|");
        sb.append(strAccount);
        sb.append("&[keMuParame]");
        sb.append("&|");
        header.addRow(sb.append("&|").toString(), sa);
        sb.setLength(0);
        sb.append(strAsstact).append("&[strAssttype]&|&[null]&|");
        header.addRow(sb.toString(), sa);
    }

    @Override
    protected Map preparePrintVariantMap() {
        String[] actAndAsst;
        HashMap<String, String> map = new HashMap<String, String>();
        GLRptBaseCondition condition = this.getQueryCond();
        map.put("CompanyName", this.getCompany().getName());
        map.put("kdlPeriod", this.getPeriodTitle(condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd()));
        map.put("kdlSchema", this.csi.getNumber() + "-" + this.csi.getName());
        String accountName = null;
        accountName = this.isAccountShowLongName ? this.accountView.getLongName(this.getLocale()) : this.accountView.getName(this.getLocale());
        map.put("keMuParame", this.accountView.getNumber() + " - " + accountName);
        String strAssttype = "";
        String strKDLaccount = this.kDLaccount.getText();
        if (strKDLaccount != null && (actAndAsst = strKDLaccount.split("    ")).length > 1) {
            strAssttype = actAndAsst[1];
        }
        map.put("strAssttype", strAssttype);
        return map;
    }

    protected Map getPrintVar() {
        String[] actAndAsst;
        HashMap<String, String> printParams = new HashMap<String, String>();
        GLRptBaseCondition cond = this.getQueryCond();
        printParams.put("User", SysContext.getSysContext().getUserName());
        printParams.put("CompanyName", this.getCompany().getName());
        printParams.put("kdlPeriod", this.getPeroidStr(cond));
        printParams.put("kdlSchema", this.csi.getNumber() + "-" + this.csi.getName());
        String accountName = null;
        accountName = this.isAccountShowLongName ? this.accountView.getLongName(this.getLocale()) : this.accountView.getName(this.getLocale());
        printParams.put("keMuParame", this.accountView.getNumber() + " - " + accountName);
        printParams.put("TopAccountViewName", this.accountView.getLongName().split("_")[0]);
        printParams.put("AccountLongName", this.accountView.getLongName());
        printParams.put("accountDC", this.accountView.getDC() != null ? this.accountView.getDC().toString() : "");
        String strAssttype = "";
        String strKDLaccount = this.kDLaccount.getText();
        if (strKDLaccount != null && (actAndAsst = strKDLaccount.split("    ")).length > 1) {
            strAssttype = actAndAsst[1];
        }
        printParams.put("strAssttype", strAssttype);
        printParams.put("accountAndAsst", strKDLaccount);
        return printParams;
    }

    private String getPeroidStr(ReportConditionBase condition) {
        int yearBegin = condition.getPeriodYearStart();
        int numberBegin = condition.getPeriodNumberStart();
        int yearEnd = condition.getPeriodYearEnd();
        int numberEnd = condition.getPeriodNumberEnd();
        String txtPeriod = this.getPeriodTitle(yearBegin, numberBegin, yearEnd, numberEnd);
        return txtPeriod;
    }

    @Override
    public Object getTablePreferenceSchemaKey() {
        StringBuffer key = new StringBuffer("");
        String companyId = this.getCompany().getId().toString();
        key.append(companyId);
        ReportConditionAsstactMultiColumn con = (ReportConditionAsstactMultiColumn)this.getQueryCond();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (con != null && con.getSchema() != null && con.getSchema().getId() != null) {
            key.append(con.getSchema().getId().toString());
        }
        key.append("||").append(userId);
        return key.toString();
    }

    protected void delLastChar(StringBuffer sb) {
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    @Override
    public boolean isPrepareActionQuery() {
        return true;
    }

    @Override
    public RequestContext prepareActionQuery(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionQuery(itemAction);
        if (request == null) {
            request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
        }
        request.put("CSIID", (Object)this.csi.getId().toString());
        return request;
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        GLRptTable tblMain = this.getTable();
        if (tblMain != null && tblMain.getColumn("bizDate") != null) {
            tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(GlUtils.getDateFormatString());
        }
    }

    @Override
    protected IObjectPK getOrgPK(ItemAction action) {
        CompanyOrgUnitInfo company = this.getCompany();
        if (company != null) {
            return new ObjectUuidPK(BOSUuid.read((String)company.getId().toString()));
        }
        return super.getOrgPK(action);
    }

    @Override
    protected String getPermissionItem() {
        return "gl_columnarLedger_view";
    }

    @Override
    protected void setEnumDisplayStatus() {
        super.setEnumDisplayStatus();
        this.companyName.setVisible(false);
    }

    @Override
    protected boolean checkCondition(GLRptBaseCondition cond) {
        if (!super.checkCondition(cond)) {
            return false;
        }
        ReportConditionAsstactMultiColumn rc = (ReportConditionAsstactMultiColumn)cond;
        CommonSchemaInfo csi = rc.getSchema();
        try {
            this.cs = RptCommonSchemaFactory.getRemoteInstance().getSchema(csi.getId().toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
        if (this.cs == null) {
            return false;
        }
        return this.cs.isMatchVersion();
    }

    @Override
    protected void tableUserSetting() {
        super.tableUserSetting();
        this.tHelper.setCanMoveColumn(true);
    }
}

