/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ParamEx;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.client.CompanyTreePromptBox;
import com.kingdee.eas.fi.gl.client.ParamExUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryInitData;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.RptException;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public abstract class GLRptBaseQueryUI
extends AbstractGLRptBaseQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(GLRptBaseQueryUI.class);
    protected CompanyOrgUnitInfo company = null;
    protected GLRptQueryInitData queryInitData;
    protected PeriodEntity pe;
    protected boolean show = false;
    protected CompanyOrgUnitInfo[] companys;
    protected List<ParamEx> paramExs;
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.ReportBase";

    public String getResource(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }

    public GLRptBaseQueryUI() throws Exception {
        InputMap imEntry = this.getInputMap(2);
        KeyStroke key = KeyStroke.getKeyStroke(69, 3);
        imEntry.put(key, "showExportUI");
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put("showExportUI", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLRptBaseQueryUI.this.showExportUI(e);
            }
        });
        KeyStroke simpleKey = KeyStroke.getKeyStroke(83, 3);
        imEntry.put(simpleKey, "showSimpleUI");
        ActionMap simpleEntryActionMap = this.getActionMap();
        simpleEntryActionMap.put("showSimpleUI", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLRptBaseQueryUI.this.showSimpleUI(e);
            }
        });
    }

    public void onLoad() throws Exception {
        this.initData();
        this.bpCompany.setEnabledMultiSelection(this.isMultiSelectCompany());
        super.onLoad();
        this.initCompanyF7();
        this.initPeriodComboBox();
        this.initAccountTableComboBox();
        this.initCurrencyComboBox();
        this.companyChanged();
        this.accountTableChanged();
        this.initAdvanceOptions();
    }

    public void initData() throws Exception {
        this.queryInitData = this.getIGLRptBaseFacade().getQueryInitData(this.isSupportUnion());
    }

    private void initCompanyF7() {
        this.bpCompany.setEditable(true);
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.bpCompany.setEntityViewInfo(companyView);
        this.bpCompany.setSelector(this.getCompanySelector());
        this.setCompanyDisplayMode();
    }

    private String getCompanyIdFilter() {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer companyIdStr = new StringBuffer();
        CompanyOrgUnitInfo root = null;
        boolean isPerm = true;
        if (this.isUnionQuery()) {
            root = SysContext.getSysContext().getCurrentFIUnit();
            isPerm = this.queryInitData.isCompanyByUser();
        }
        try {
            return GLGeneralFacadeFactory.getRemoteInstance().getCompanyIDSQL(isPerm ? this.getPermissionItem() : null, root, false);
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected boolean canMultiSelectCompany() {
        GLRptBaseUI baseUI = (GLRptBaseUI)((Object)this.getUIContext().get("Owner"));
        String uiParam = (String)baseUI.getUIContext().get("UIClassParam");
        return !GlUtils.isEmpty(uiParam) && "FSSC".equalsIgnoreCase(uiParam);
    }

    private boolean isMultiSelectCompany() {
        return !SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit() && this.isSupportUnion() || this.canMultiSelectCompany();
    }

    protected void setCompanyDisplayMode() {
        if (this.isUnionQuery()) {
            this.cbDisplayMode.addItem((Object)CompanyDisplayModeEnum.level);
            if (this.canDetailDisplay()) {
                this.cbDisplayMode.addItem((Object)CompanyDisplayModeEnum.details);
            } else {
                this.cbDisplayMode.setEnabled(false);
            }
        } else {
            if (this.canMultiSelectCompany()) {
                this.lblDisplayMode.setVisible(true);
            } else {
                this.lblDisplayMode.setVisible(false);
            }
            this.lblDisplayMode.setEnabled(this.canMergeDisplay());
            this.cbDisplayMode.addItem((Object)CompanyDisplayModeEnum.enumerate);
            if (this.canMergeDisplay()) {
                this.cbDisplayMode.addItem((Object)CompanyDisplayModeEnum.merger);
            } else {
                this.cbDisplayMode.setEnabled(false);
            }
        }
    }

    protected KDPromptSelector getCompanySelector() {
        if (this.isMultiSelectCompany()) {
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            CompanyOrgUnitInfo root = this.isUnionQuery() ? company : null;
            return new CompanyTreePromptBox((CoreUIObject)this, root, this.bpCompany, this.getPermissionItem(), false);
        }
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(false);
        companySelector.setIsCUFilter(false);
        companySelector.setShowVirtual(false);
        companySelector.setContainSealUp(false);
        companySelector.setNeedAddAssistant(true);
        companySelector.setOuterFilterInfo(this.getCompanyFilterInfo());
        companySelector.setContainSealUp(true);
        return companySelector;
    }

    private FilterInfo getCompanyFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        return filter;
    }

    protected boolean canMergeDisplay() {
        return false;
    }

    protected boolean canDetailDisplay() {
        return false;
    }

    protected void initListener() {
        super.initListener();
        this.bpCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                try {
                    if (GLRptBaseQueryUI.this.isCompanyChanged(event)) {
                        GLRptBaseQueryUI.this.companyChanged();
                    }
                }
                catch (Exception e) {
                    GLRptBaseQueryUI.this.handUIException(e);
                }
            }
        });
        this.bpCompany.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                GLRptBaseQueryUI.this.verifySelecteCompany(e);
            }
        });
        this.cbDisplayMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    GLRptBaseQueryUI.this.displayModeChanged();
                }
            }
        });
        this.bpAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    if (event.getStateChange() == 1) {
                        GLRptBaseQueryUI.this.accountTableChanged();
                    }
                }
                catch (Exception e) {
                    GLRptBaseQueryUI.this.handUIException(e);
                }
            }
        });
        this.bpPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    if (event.getStateChange() == 1) {
                        GLRptBaseQueryUI.this.periodTypeChanged();
                    }
                }
                catch (Exception e) {
                    GLRptBaseQueryUI.this.handUIException(e);
                }
            }
        });
        this.spnPeriodYearEnd.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    GLRptBaseQueryUI.this.spnPeriodYearEnd_stateChanged(e);
                }
                catch (Exception exc) {
                    GLRptBaseQueryUI.this.handUIException(exc);
                }
            }
        });
        this.spnPeriodNumberEnd.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    GLRptBaseQueryUI.this.spnPeriodNumberEnd_stateChanged(e);
                }
                catch (Exception exc) {
                    GLRptBaseQueryUI.this.handUIException(exc);
                }
            }
        });
        this.chkOpAmountZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected;
                boolean bl = selected = e.getStateChange() == 1;
                if (selected) {
                    GLRptBaseQueryUI.this.chkAmountAndBalZero.setSelected(false);
                    GLRptBaseQueryUI.this.chkOpBalanceZero.setSelected(false);
                }
            }
        });
        this.chkOpBalanceZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected;
                boolean bl = selected = e.getStateChange() == 1;
                if (selected) {
                    GLRptBaseQueryUI.this.chkOpAmountZero.setSelected(false);
                    GLRptBaseQueryUI.this.chkAmountAndBalZero.setSelected(false);
                }
            }
        });
        this.chkAmountAndBalZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected;
                boolean bl = selected = e.getStateChange() == 1;
                if (selected) {
                    GLRptBaseQueryUI.this.chkOpAmountZero.setSelected(false);
                    GLRptBaseQueryUI.this.chkOpBalanceZero.setSelected(false);
                }
            }
        });
    }

    protected void accountTableChanged() throws Exception {
    }

    protected void spnPeriodYearEnd_stateChanged(ChangeEvent e) throws Exception {
    }

    protected void spnPeriodNumberEnd_stateChanged(ChangeEvent e) throws Exception {
    }

    protected void initAccountTableComboBox() throws Exception {
        AccountTableCollection accountTables = this.queryInitData.getAccountTables();
        this.bpAccount.setModel(new DefaultComboBoxModel(this.toVector((AbstractObjectCollection)accountTables)));
    }

    protected void initPeriodComboBox() throws Exception {
        PeriodTypeCollection periodTyes = this.queryInitData.getPeriodTypes();
        this.bpPeriod.setModel(new DefaultComboBoxModel(this.toVector((AbstractObjectCollection)periodTyes)));
        if (!this.isMultiSelectCompany()) {
            this.bpPeriod.setEnabled(false);
        }
    }

    private Vector toVector(AbstractObjectCollection coll) {
        if (coll == null) {
            return null;
        }
        Vector v = new Vector();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        return v;
    }

    protected void initCurrencyComboBox() throws Exception {
        Vector currencys = this.queryInitData.getCurrencys();
        this.cmbCurrency.setModel(new DefaultComboBoxModel(currencys));
    }

    protected void periodTypeChanged() throws Exception {
        this.setPeriodRange();
    }

    protected boolean isSameBaseCurrency(CompanyOrgUnitCollection companys) {
        if (companys == null || companys.isEmpty()) {
            return true;
        }
        boolean same = true;
        BOSUuid lastId = null;
        for (int i = 0; i < companys.size(); ++i) {
            CurrencyInfo currency = companys.get(i).getBaseCurrency();
            if (currency == null) continue;
            if (lastId == null) {
                lastId = currency.getId();
                continue;
            }
            if (lastId.equals((Object)currency.getId())) continue;
            same = false;
            break;
        }
        return same;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)param));
            } else {
                this.setParam(param);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public void setParam(Object param) throws EASBizException, BOSException {
        if (param != null) {
            try {
                if (param instanceof RptParams) {
                    param = ((RptParams)param).toMap();
                }
                this.setCustomCondition(this.createReportCondition((Map)param));
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)e);
                throw new RptException(RptException.IOSERIALIZABLE_ERROR, (Throwable)e);
            }
        }
    }

    public Object getParam() {
        return this.getCustomCondition().toMap();
    }

    public void setCustomCondition(GLRptBaseCondition condition) throws EASBizException, BOSException {
        if (condition == null) {
            return;
        }
        this.bpPeriod.setSelectedItem(null);
        this.bpAccount.setSelectedItem(null);
        this.setCompanys(condition.getSelectedCompanys());
        this.cbDisplayMode.setSelectedItem((Object)condition.getCompanyDisplayMode());
        int expandLevel = condition.getExpandCompanyLevel();
        if (expandLevel <= 0) {
            expandLevel = 1;
        }
        this.spnCompanyLevel.setValue((Object)expandLevel);
        PeriodTypeInfo period = null;
        CompanyOrgUnitInfo currCompany = this.getCurrCompany();
        period = condition.getPeriodTypeId() != null ? this.getPeriodType(condition.getPeriodTypeId()) : currCompany.getAccountPeriodType();
        this.setSelectedItem(this.bpPeriod, (DataBaseInfo)period);
        AccountTableInfo accountTable = null;
        if (condition.getAccountTableId() != null) {
            accountTable = this.getAccountTable(condition.getAccountTableId());
        } else if (currCompany.getAccountTable() != null) {
            accountTable = this.getAccountTable(currCompany.getAccountTable().getId().toString());
        }
        this.setSelectedItem(this.bpAccount, (DataBaseInfo)accountTable);
        String currencyId = condition.getCurrencyID();
        if (currencyId != null && currencyId.trim().length() != 0) {
            for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
                Object object = this.cmbCurrency.getItemAt(i);
                if (object instanceof CurrencyInfo) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)object;
                    if (!currencyId.equals(currencyInfo.getId().toString()) && !currencyId.equals(currencyInfo.getNumber())) continue;
                    this.cmbCurrency.setSelectedIndex(i);
                    break;
                }
                if (!currencyId.equals("AllCurrency")) continue;
                this.cmbCurrency.setSelectedIndex(i);
            }
        } else {
            this.cmbCurrency.setSelectedIndex(this.cmbCurrency.getItemCount() - 1);
        }
        if (this.pe != null) {
            this.spnPeriodYearBegin.setValue((Object)this.pe.getMinYear());
            this.spnPeriodNumberBegin.setValue((Object)this.pe.getMinPeriod(this.pe.getMinYear()));
            this.spnPeriodYearEnd.setValue((Object)this.pe.getMaxYear());
            this.spnPeriodNumberEnd.setValue((Object)this.pe.getMaxPeriod(this.pe.getMaxYear()));
        }
        this.spnPeriodYearBegin.setValue((Object)condition.getPeriodYearStart());
        this.spnPeriodNumberBegin.setValue((Object)condition.getPeriodNumberStart());
        this.spnPeriodYearEnd.setValue((Object)condition.getPeriodYearEnd());
        this.spnPeriodNumberEnd.setValue((Object)condition.getPeriodNumberEnd());
        this.chkOpIncludeNotPosting.setSelected(condition.getOptionPosting());
        this.chkAmountAndBalZero.setSelected(condition.isOptionAmountAndBalZero());
        this.chkOpAmountZero.setSelected(condition.isOptionAmountZero());
        this.chkOpBalanceZero.setSelected(condition.isOptionBalanceZero());
        this.chkShowQty.setSelected(condition.isShowQty());
        this.chkNotIncluePLVoucher.setSelected(condition.isNotIncluePLVoucher());
        this.show = true;
        String extendParams = condition.getExtendParams();
        this.paramExs = new ArrayList<ParamEx>();
        if (extendParams != null && extendParams.startsWith("[{") && extendParams.endsWith("}]")) {
            List paramExList = (List)JSON.parseObject((String)extendParams, List.class);
            for (Object obj : paramExList) {
                this.paramExs.add((ParamEx)JSON.parseObject((String)obj.toString(), ParamEx.class));
            }
        }
    }

    protected void setSelectedItem(KDComboBox comboBox, DataBaseInfo dbInfo) {
        if (dbInfo == null) {
            comboBox.setSelectedItem(null);
            return;
        }
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            DataBaseInfo info;
            Object object = comboBox.getItemAt(i);
            if (!(object instanceof DataBaseInfo) || (info = (DataBaseInfo)object) == null || !dbInfo.getId().equals((Object)info.getId())) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    private PeriodTypeInfo getPeriodType(String periodTypeId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        try {
            return PeriodTypeFactory.getRemoteInstance().getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(periodTypeId), sic);
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private AccountTableInfo getAccountTable(String accTableId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        try {
            return AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(accTableId), sic);
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    public GLRptBaseCondition getCustomCondition() {
        GLRptBaseCondition customCondition = this.createReportCondition();
        customCondition.setCompanys(this.companys);
        customCondition.setSelectedCompanys(this.getCompanys());
        customCondition.setCompanyDisplayMode((CompanyDisplayModeEnum)((Object)this.cbDisplayMode.getSelectedItem()));
        Integer companyLevel = (Integer)this.spnCompanyLevel.getValue();
        if (companyLevel == null || companyLevel <= 0) {
            companyLevel = 1;
        }
        customCondition.setExpandCompanyLevel(companyLevel);
        if (this.bpAccount.getSelectedItem() != null) {
            customCondition.setAccountTableId(((AccountTableInfo)this.bpAccount.getSelectedItem()).getId().toString());
        }
        if (this.bpPeriod.getSelectedItem() != null) {
            customCondition.setPeriodTypeId(((PeriodTypeInfo)this.bpPeriod.getSelectedItem()).getId().toString());
        }
        int yearBegin = (Integer)this.spnPeriodYearBegin.getValue();
        customCondition.setPeriodYearStart(yearBegin);
        int yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
        customCondition.setPeriodYearEnd(yearEnd);
        Integer periodBegin = (Integer)this.spnPeriodNumberBegin.getValue();
        customCondition.setPeriodNumberStart(periodBegin);
        Integer periodEND = (Integer)this.spnPeriodNumberEnd.getValue();
        customCondition.setPeriodNumberEnd(periodEND);
        Object objectCurrency = this.cmbCurrency.getSelectedItem();
        if (objectCurrency instanceof CurrencyInfo) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
            customCondition.setCurrencyID(currencyInfo.getId().toString());
            customCondition.setCurrencyName(currencyInfo.getName());
        } else if (GLResUtil.getRes("all_currency").equals((String)objectCurrency)) {
            customCondition.setCurrencyID("AllCurrency");
            customCondition.setCurrencyName((String)objectCurrency);
        }
        customCondition.setOptionPosting(this.chkOpIncludeNotPosting.isSelected());
        customCondition.setOptionAmountZero(this.chkOpAmountZero.isSelected());
        customCondition.setOptionBalanceZero(this.chkOpBalanceZero.isSelected());
        customCondition.setOptionAmountAndBalZero(this.chkAmountAndBalZero.isSelected());
        customCondition.setShowQty(this.chkShowQty.isSelected());
        customCondition.setNotIncluePLVoucher(this.chkNotIncluePLVoucher.isSelected());
        customCondition.setExtendParams(JSON.toJSONString(this.paramExs));
        return customCondition;
    }

    protected void companyChanged() throws Exception {
        CompanyOrgUnitInfo currentFIUnit;
        boolean isEnable = this.getCompanys() != null;
        this.spnPeriodYearBegin.setEnabled(isEnable);
        this.spnPeriodNumberBegin.setEnabled(isEnable);
        this.spnPeriodYearEnd.setEnabled(isEnable);
        this.spnPeriodNumberEnd.setEnabled(isEnable);
        if (!this.isUnionQuery()) {
            this.bpPeriod.setSelectedItem(null);
            this.setSelectedItem(this.bpAccount, (DataBaseInfo)this.getSameAccountTableInfo());
            CurrencyInfo currencyInfo = this.getSameBaseCurrencyInfo();
            if (currencyInfo == null) {
                this.cmbCurrency.setSelectedIndex(0);
            } else {
                this.setSelectedItem(this.cmbCurrency, (DataBaseInfo)currencyInfo);
            }
        }
        if (isEnable) {
            this.setPeriodRange();
            this.setCompanyMaxLevel();
        }
        if (!this.isUnionQuery()) {
            this.setSelectedItem(this.bpPeriod, (DataBaseInfo)this.getSamePeriodTypeInfo());
        }
        if ((currentFIUnit = SysContext.getSysContext().getCurrentFIUnit()).isIsBizUnit() && this.getCompanys() != null) {
            AccountTableCollection accountTableCollection = this.getAccountTableCollection(null, this.getCompanys()[0]);
            this.bpAccount.setModel(new DefaultComboBoxModel(this.toVector((AbstractObjectCollection)accountTableCollection)));
            if (this.getCompanys()[0].getAccountTable() != null) {
                this.setSelectedItem(this.bpAccount, (DataBaseInfo)this.getCompanys()[0].getAccountTable());
            }
        }
    }

    private AccountTableCollection getAccountTableCollection(Context ctx, CompanyOrgUnitInfo company) throws ReportBizException, BOSException {
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        return AccountTools.getAllAccountTableByCompany((Context)ctx, (CompanyOrgUnitInfo)company);
    }

    private AccountTableInfo getSameAccountTableInfo() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys == null) {
            return null;
        }
        AccountTableInfo accountTable = companys[0].getAccountTable();
        if (accountTable == null) {
            return null;
        }
        for (int i = 1; i < companys.length; ++i) {
            if (companys[i].getAccountTable() == null) {
                return null;
            }
            if (companys[i].getAccountTable().getId().equals((Object)accountTable.getId())) continue;
            return null;
        }
        return accountTable;
    }

    private PeriodTypeInfo getSamePeriodTypeInfo() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys == null) {
            return null;
        }
        PeriodTypeInfo periodTypeInfo = companys[0].getAccountPeriodType();
        if (periodTypeInfo == null) {
            return null;
        }
        for (int i = 1; i < companys.length; ++i) {
            if (companys[i].getAccountPeriodType() == null) {
                return null;
            }
            if (companys[i].getAccountPeriodType().getId().equals((Object)periodTypeInfo.getId())) continue;
            return null;
        }
        return periodTypeInfo;
    }

    private CurrencyInfo getSameBaseCurrencyInfo() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys == null) {
            return null;
        }
        CurrencyInfo currencyInfo = companys[0].getBaseCurrency();
        if (currencyInfo == null) {
            return null;
        }
        for (int i = 1; i < companys.length; ++i) {
            if (companys[i].getAccountPeriodType() == null) {
                return null;
            }
            if (companys[i].getBaseCurrency().getId().equals((Object)currencyInfo.getId())) continue;
            return null;
        }
        return currencyInfo;
    }

    private void setPeriodRange() {
        PeriodTypeInfo peridType = (PeriodTypeInfo)this.bpPeriod.getSelectedItem();
        Set companyIdSet = this.getCompanyIdSet();
        boolean isPeriodEnable = peridType != null && !companyIdSet.isEmpty();
        this.spnPeriodYearBegin.setEnabled(isPeriodEnable);
        this.spnPeriodYearEnd.setEnabled(isPeriodEnable);
        this.spnPeriodNumberBegin.setEnabled(isPeriodEnable);
        this.spnPeriodNumberEnd.setEnabled(isPeriodEnable);
        if (isPeriodEnable) {
            try {
                PeriodEntity pe;
                Map pdRang = this.getIGLRptBaseFacade().getPeriodRange(companyIdSet, peridType.getId().toString());
                this.pe = pe = new PeriodEntity(pdRang);
                SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)false, (boolean)false);
            }
            catch (Exception e) {
                this.spnPeriodYearBegin.setEnabled(false);
                this.spnPeriodYearEnd.setEnabled(false);
                this.spnPeriodNumberBegin.setEnabled(false);
                this.spnPeriodNumberEnd.setEnabled(false);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            }
        }
    }

    protected Set getCompanyIdSet() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        HashSet<String> idSet = new HashSet<String>();
        if (companys == null) {
            return idSet;
        }
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    public CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.bpCompany.getValue();
        if (company instanceof CompanyOrgUnitInfo) {
            return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
        }
        if (this.bpCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            return (CompanyOrgUnitInfo[])this.bpCompany.getValue();
        }
        if (this.bpCompany.getValue() instanceof Object[]) {
            Object[] companyObjs = (Object[])this.bpCompany.getValue();
            return this.toObjectArray2CompanyArray(companyObjs);
        }
        return null;
    }

    private CompanyOrgUnitInfo[] toObjectArray2CompanyArray(Object[] companyObjs) {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < companyObjs.length; ++i) {
            if (!(companyObjs[i] instanceof CompanyOrgUnitInfo)) continue;
            companyList.add(companyObjs[i]);
        }
        if (companyList.isEmpty()) {
            return null;
        }
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companyList.size()];
        return companyList.toArray(companys);
    }

    protected void setCompanys(CompanyOrgUnitInfo[] companys) {
        this.bpCompany.setValue((Object)companys);
    }

    protected void displayModeChanged() {
        this.setCompanyMaxLevel();
    }

    private void setCompanyMaxLevel() {
        boolean isLevel = this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.level;
        this.lblCompanyLevel.setVisible(isLevel);
        if (isLevel) {
            int maxLevel = 1;
            CompanyOrgUnitInfo[] companys = this.getCompanys();
            if (companys != null) {
                for (int i = 0; i < companys.length; ++i) {
                    int level = companys[i].getLevel();
                    if (maxLevel >= level) continue;
                    maxLevel = level;
                }
                ++maxLevel;
            }
            SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, maxLevel, 1);
            this.spnCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
        }
    }

    protected CompanyOrgUnitCollection getCompanyCollection(Set companyIdSet) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("baseCurrency.id"));
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        evi.setFilter(f);
        CompanyOrgUnitCollection comCol = null;
        try {
            comCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return comCol;
    }

    public void setCurrCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public boolean isShow() {
        return this.show;
    }

    public boolean verify() {
        Object objectCurrency;
        if (!super.verify()) {
            return false;
        }
        if (this.getCompanys() == null) {
            this.bpCompany.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_company_range"));
            return false;
        }
        if (this.accountTableIsMustInput() && this.bpAccount.getSelectedItem() == null) {
            this.bpAccount.requestFocus();
            MsgBox.showInfo((Component)this.bpAccount, (String)GLResUtil.getRes("select_accountView_table_please"));
            return false;
        }
        if (this.periodTypeIsMustInput() && this.bpPeriod.getSelectedItem() == null) {
            this.bpPeriod.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_periodType_table_please"));
            return false;
        }
        if (this.currencyIsMustInput() && (objectCurrency = this.cmbCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            CurrencyInfo currencyInfo = (CurrencyInfo)objectCurrency;
            Set companyIdSet = this.getCompanyIdSet();
            if (!companyIdSet.isEmpty() && currencyInfo.getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !this.isSameBaseCurrency(this.getCompanyCollection(companyIdSet))) {
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("localCyIncons"));
                return false;
            }
        }
        this.companys = GLRptUtils.getCompanyArray(this.getCompanys(), this.accountTableIsMustInput() ? ((AccountTableInfo)this.bpAccount.getSelectedItem()).getId().toString() : null, this.periodTypeIsMustInput() ? ((PeriodTypeInfo)this.bpPeriod.getSelectedItem()).getId().toString() : null, (Integer)this.spnPeriodYearEnd.getValue(), (Integer)this.spnPeriodNumberEnd.getValue());
        if (this.companys == null || this.companys.length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("selectCompanyNoData"));
            return false;
        }
        return true;
    }

    protected boolean accountTableIsMustInput() {
        return true;
    }

    protected boolean periodTypeIsMustInput() {
        return true;
    }

    protected boolean currencyIsMustInput() {
        return true;
    }

    protected CompanyOrgUnitInfo getCurrCompany() {
        return this.company;
    }

    protected boolean isSupportUnion() {
        GLRptBaseUI baseUI = (GLRptBaseUI)((Object)this.getUIContext().get("Owner"));
        return baseUI.isSupportUnion();
    }

    protected boolean isUnionQuery() {
        return !this.getCurrCompany().isIsBizUnit() && this.isSupportUnion();
    }

    public void clear() {
        super.clear();
        if (this.isUnionQuery()) {
            this.setCompanys(null);
            this.setSelectedItem(this.bpAccount, (DataBaseInfo)this.getCurrCompany().getAccountTable());
            this.setSelectedItem(this.bpPeriod, (DataBaseInfo)this.getCurrCompany().getAccountPeriodType());
            this.setSelectedItem(this.cmbCurrency, (DataBaseInfo)this.getCurrCompany().getBaseCurrency());
            this.cbDisplayMode.setSelectedItem((Object)this.getDefaultUnionCompanyShowMode());
        } else {
            CompanyOrgUnitInfo firstCompany = this.getFirstCompany();
            if (firstCompany != null) {
                this.setCompanys(new CompanyOrgUnitInfo[]{firstCompany});
                this.setSelectedItem(this.bpAccount, (DataBaseInfo)firstCompany.getAccountTable());
                this.setSelectedItem(this.bpPeriod, (DataBaseInfo)firstCompany.getAccountPeriodType());
                this.setSelectedItem(this.cmbCurrency, (DataBaseInfo)firstCompany.getBaseCurrency());
            }
            this.setPeriodRange();
            this.cbDisplayMode.setSelectedItem((Object)CompanyDisplayModeEnum.enumerate);
        }
        this.chkOpIncludeNotPosting.setSelected(false);
        this.chkOpAmountZero.setSelected(false);
        this.chkOpBalanceZero.setSelected(false);
        this.chkAmountAndBalZero.setSelected(false);
        this.chkShowQty.setSelected(false);
        this.chkNotIncluePLVoucher.setSelected(false);
        this.show = true;
        this.paramExs = null;
    }

    protected CompanyDisplayModeEnum getDefaultUnionCompanyShowMode() {
        return CompanyDisplayModeEnum.level;
    }

    private CompanyOrgUnitInfo getFirstCompany() {
        Object company = this.getCurrCompany();
        try {
            company = company.isIsBizUnit() || !this.isSupportUnion() ? GLGeneralFacadeFactory.getRemoteInstance().getFirstCompany(this.getPermissionItem()) : null;
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return company;
    }

    protected boolean isCompanyChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            return e.getOldValue() != null;
        }
        if (e.getOldValue() == null) {
            return true;
        }
        return !this.isCompanyEquals(e.getNewValue(), e.getOldValue());
    }

    protected boolean isCompanyEquals(Object newObject, Object oldObject) {
        if (newObject instanceof Object[] && oldObject instanceof Object[] && Arrays.toString((Object[])newObject).equalsIgnoreCase(Arrays.toString((Object[])oldObject))) {
            return true;
        }
        if (newObject instanceof CompanyOrgUnitInfo && oldObject instanceof CompanyOrgUnitInfo) {
            return ((CompanyOrgUnitInfo)newObject).getId().equals((Object)((CompanyOrgUnitInfo)oldObject).getId());
        }
        return false;
    }

    protected void verifySelecteCompany(PreChangeEvent e) {
    }

    protected abstract IGLRptBaseFacade getIGLRptBaseFacade() throws BOSException;

    protected abstract GLRptBaseCondition createReportCondition();

    protected abstract GLRptBaseCondition createReportCondition(Map var1) throws CloneNotSupportedException;

    protected String getPermissionItem() {
        GLRptBaseUI rptUI = (GLRptBaseUI)((Object)this.getUIContext().get("Owner"));
        return rptUI.getPermissionItem();
    }

    public String getUiParam() {
        GLRptBaseUI baseUI = (GLRptBaseUI)((Object)this.getUIContext().get("Owner"));
        return (String)baseUI.getUIContext().get("UIClassParam");
    }

    protected String getNRptUI() {
        return null;
    }

    protected void showExportUI(ActionEvent e) {
        IUIWindow uiWindow = null;
        try {
            String nRptUI = this.getNRptUI();
            if (nRptUI == null) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(nRptUI, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            Util.getWindow((Component)((Object)this)).dispose();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    protected String getNRptSimpleUI() {
        return null;
    }

    protected void showSimpleUI(ActionEvent e) {
        IUIWindow uiWindow = null;
        try {
            String nRptUI = this.getNRptSimpleUI();
            if (nRptUI == null) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(nRptUI, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            Util.getWindow((Component)((Object)this)).dispose();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    protected void setTableKeyBoardManager(KDTable table) {
        KDTFocusChangeAction action = new KDTFocusChangeAction(table, 0, false);
        ActionMap actionMap = table.getActionMap();
        actionMap.put("FocusChangeRow", (Action)action);
        actionMap.put("FocusChangeCol", (Action)action);
        actionMap.put("FocusChangeColReverse", (Action)action);
        actionMap.put("FocusChangeRowReverse", (Action)action);
        actionMap.put("Delete", null);
        actionMap.put("Copy", null);
        actionMap.put("Paste", null);
        actionMap.put("Cut", null);
    }

    protected void initAdvanceOptions() {
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_f5 = KeyStroke.getKeyStroke(116, 3);
        imEntry.put(ctrl_shift_f5, "showAdvance");
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put("showAdvance", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLRptBaseQueryUI.this.showAdvanceActionPerformed(e);
            }
        });
    }

    protected void showAdvanceActionPerformed(ActionEvent e) {
    }

    protected void showParamExUI() {
        List<ParamEx> result;
        if (this.paramExs == null || this.paramExs.size() == 0) {
            this.paramExs = this.getDefaultParamExs();
        }
        if ((result = ParamExUI.showMe((Object)this, this.paramExs, this.getDefaultParamExs())) != null) {
            this.paramExs = result;
        }
    }

    protected List<ParamEx> getDefaultParamExs() {
        ArrayList<ParamEx> paramExs = new ArrayList<ParamEx>();
        ParamEx paramEx = new ParamEx("Debug", "false", "false", this.getResource("Rpt_tips3"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("Query_Required", "", "", this.getResource("Rpt_tips4"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("Update_Balance", "true", "true", this.getResource("Rpt_tips5"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("Query_Asyn", "true", "true", this.getResource("Rpt_tips6"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("Export_Asyn", "true", "true", this.getResource("Rpt_tips7"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("Export_PageSize", "500", "500", this.getResource("Rpt_tips8"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("Export_AutoClose", "true", "true", this.getResource("Rpt_tips9"));
        paramExs.add(paramEx);
        return paramExs;
    }
}

