/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.UserSettingUtil;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptBaseTreeUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptDataComponent;
import com.kingdee.eas.fi.gl.rpt.client.GLRptTable;
import com.kingdee.eas.fi.gl.rpt.client.GLRptTree;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Properties;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class GLRptBaseTreeUI
extends AbstractGLRptBaseTreeUI {
    private static final long serialVersionUID = 7604533013036990491L;
    private static final Logger logger = CoreUIObject.getLogger(GLRptBaseTreeUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initDataTable();
    }

    protected void actionExportToExcel_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void initListener() {
        super.initListener();
        final GLRptTree tree = this.getTree();
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (tree.getSelectionPaths() != null && tree.getSelectionPaths().length == 1) {
                    GLRptBaseTreeUI.this.treeSelectionChanged(e);
                }
            }
        });
    }

    protected void treeSelectionChanged(TreeSelectionEvent e) {
        TreePath path = e.getNewLeadSelectionPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node != null) {
            try {
                this.joinQueryData(node.getUserObject());
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    protected void initDataTable() throws Exception {
        this.tblMain.init(this, this.getIGLRptDataFacade(), null, false, true);
    }

    @Override
    protected void afterQuery() throws EASBizException, BOSException {
        super.afterQuery();
        if (!this.getDataComponent().isEmpty()) {
            this.getDataComponent().selectFirst();
        } else {
            this.getDataComponent().query(null);
        }
    }

    protected abstract String getJoinExportLabel();

    @Override
    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    @Override
    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    @Override
    protected GLRptDataComponent createDataComponent() {
        GLRptTree tree = new GLRptTree();
        tree.addPopupMenu(this.getJoinExportLabel(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GLRptBaseTreeUI.this.setCursorOfWair();
                    GLRptBaseTreeUI.this.actionExportToExcel_actionPerformed(e);
                }
                catch (Exception ex) {
                    GLRptBaseTreeUI.this.handleException(ex);
                }
                finally {
                    GLRptBaseTreeUI.this.setCursorOfDefault();
                }
            }
        });
        return tree;
    }

    protected GLRptTree getTree() {
        return (GLRptTree)this.getDataComponent();
    }

    @Override
    protected GLRptTable getPrintTable() {
        return this.tblMain;
    }

    @Override
    protected void releaseDataSource() {
        super.releaseDataSource();
        this.tblMain.closeQuery();
    }

    @Override
    protected void showDataUILayout() throws EASBizException, BOSException {
        this.splitPane = this.initSplitPane();
        this.splitPane.setName("splitPane");
        String kdSplitPaneDividerLocationSettingFunction = this.getKDSplitPaneDividerLocationSettingFunction();
        if (kdSplitPaneDividerLocationSettingFunction == null) {
            this.splitPane.setDividerLocation(400);
        } else {
            Map data = UserSettingUtil.getUserSetting(kdSplitPaneDividerLocationSettingFunction, null);
            if (data.size() != 0 && data.get("dividerLocation") != null) {
                String dividerLocation = (String)data.get("dividerLocation");
                this.splitPane.setDividerLocation(Integer.parseInt(dividerLocation));
            } else {
                this.splitPane.setDividerLocation(400);
            }
        }
        super.showDataUILayout();
    }

    protected String getKDSplitPaneDividerLocationSettingFunction() {
        return null;
    }

    protected KDSplitPane initSplitPane() {
        KDSplitPane newSplitPane = new KDSplitPane();
        newSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (GLRptBaseTreeUI.this.getKDSplitPaneDividerLocationSettingFunction() != null && evt.getPropertyName().equals("dividerLocation")) {
                    JSplitPane tsplitPane = (JSplitPane)evt.getSource();
                    int dividerLocation = tsplitPane.getDividerLocation();
                    Properties props = new Properties();
                    props.setProperty("dividerLocation", String.valueOf(dividerLocation));
                    try {
                        UserSettingUtil.saveUserSetting(GLRptBaseTreeUI.this.getKDSplitPaneDividerLocationSettingFunction(), props);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return newSplitPane;
    }

    protected abstract IGLRptBaseFacade getIGLRptDataFacade() throws BOSException;

    protected abstract void joinQueryData(Object var1) throws Exception;
}

