/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Hashtable;
import java.util.Map;

public class GLRptCellTreeRenderer
implements IBasicRender {
    protected SimpleTextRender simpleRender = new SimpleTextRender();
    protected Icon cbIcon;
    protected boolean isExpandNode = true;
    private Map mapOfTreeNodeLocation = new Hashtable();

    protected GLRptCellTreeRenderer() {
        this.cbIcon = new TreeIcon();
    }

    protected GLRptCellTreeRenderer(boolean isExpandNode) {
        this.cbIcon = new TreeIcon();
        this.isExpandNode = isExpandNode;
    }

    protected boolean inRect(GLRptTreeNode node, int x, int y) {
        if (node.getUserObject() == null) {
            return false;
        }
        Rectangle rec = (Rectangle)this.mapOfTreeNodeLocation.get(node.hashCode());
        if (rec != null) {
            return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
        }
        return false;
    }

    public void draw(Graphics g, Shape clip, Object value, Style style) {
        if (value == null) {
            return;
        }
        if (!(value instanceof GLRptTreeNode)) {
            this.simpleRender.draw(g, clip, value.toString(), style);
            return;
        }
        GLRptTreeNode node = (GLRptTreeNode)value;
        if (node.toString() == null) {
            return;
        }
        int ident = node.getLevel() * 8;
        Rectangle rect = clip.getBounds();
        int x = rect.x + ident;
        int y = rect.y + (rect.height - this.cbIcon.getHeight()) / 2;
        int v = node.isLeaf() ? 0 : (node.isExpend() ? 2 : 1);
        Color color = style.getFontColor();
        g.setColor(color);
        Rectangle locRec = new Rectangle(x, y, this.cbIcon.getWidth(), this.cbIcon.getWidth());
        this.mapOfTreeNodeLocation.put(node.hashCode(), locRec);
        int xx = x + this.cbIcon.getWidth() + 8;
        Rectangle newRec = new Rectangle(xx, rect.y, clip.getBounds().width - this.cbIcon.getWidth() - 8, (int)clip.getBounds().getHeight());
        this.simpleRender.draw(g, (Shape)newRec, node.toString(), style);
        this.cbIcon.paint((Object)new Integer(v), g, x, y);
    }

    private static class TreeIcon
    implements Icon {
        private int iconSize;
        private int margin;

        public TreeIcon() {
            this(9);
        }

        public TreeIcon(int iconSize) {
            this.iconSize = iconSize;
            this.margin = 2;
        }

        public int getWidth() {
            return this.iconSize;
        }

        public int getHeight() {
            return this.iconSize;
        }

        public void paint(Object value, Graphics g, int x, int y) {
            if (value instanceof Integer) {
                int type = (Integer)value;
                if (type == 0) {
                    this.drawLeaf(g, x, y);
                } else if (type == 1) {
                    this.drawCollapsed(g, x, y);
                } else {
                    this.drawExpanded(g, x, y);
                }
            }
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
            g.drawLine(x + 1 + this.iconSize / 2, y + this.margin, x + 1 + this.iconSize / 2, y + this.margin + lineSize);
        }
    }
}

