/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.DiffItemCollection;
import com.kingdee.eas.fi.gl.DiffItemFactory;
import com.kingdee.eas.fi.gl.DiffItemInfo;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.client.DiffItemF7Selector;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptDiffItemDetQueryUI;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class GLRptDiffItemDetQueryUI
extends AbstractGLRptDiffItemDetQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(GLRptDiffItemDetQueryUI.class);
    private CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
    private PeriodInfo curPeriod;
    private PeriodEntity pe = null;

    public GLRptDiffItemDetQueryUI() throws Exception {
        this.initFilterData();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAccountTableComboBox();
        this.initBtnState();
        if (this.curPeriod != null) {
            this.spnYearFrom.setValue((Object)new Integer(this.curPeriod.getPeriodYear()));
            this.spnYearTo.setValue((Object)new Integer(this.curPeriod.getPeriodYear()));
            this.spnPeriodFrom.setValue((Object)new Integer(this.curPeriod.getPeriodNumber()));
            this.spnPeriodTo.setValue((Object)new Integer(this.curPeriod.getPeriodNumber()));
        }
        this.initDiffItemF7();
    }

    private void initBtnState() {
        this.bpCompany.setEnabled(false);
        this.bpAccount.setEnabled(false);
        this.radByVoucher.setEnabled(false);
        this.radByEntry.setEnabled(false);
    }

    private void initFilterData() throws Exception {
        String curComId = this.getCurCompany().getId().toString();
        Object[] initData = VoucherFacadeFactory.getRemoteInstance().fetchInitFilterData(curComId);
        this.curCompany = (CompanyOrgUnitInfo)initData[0];
        GlUtils.AccountPeriodInfo pi = (GlUtils.AccountPeriodInfo)initData[1];
        this.curPeriod = pi.curPeriod;
        this.pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.curCompany);
        this.initAccountF7();
    }

    private void initAccountF7() throws Exception {
        this.pbxAccountFrom.setEditable(true);
        this.pbxAccountFrom.setEditFormat("$number$");
        this.pbxAccountFrom.setDisplayFormat("$number$ - $name$");
        this.pbxAccountFrom.setCommitFormat("$helpCode$;$number$;$name$");
        this.pbxAccountFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbxAccountFrom.setCommitParser((IParser)new AccountViewParser(this.pbxAccountFrom));
        this.pbxAccountTo.setEditable(true);
        this.pbxAccountTo.setEditFormat("$number$");
        this.pbxAccountTo.setDisplayFormat("$number$ - $name$");
        this.pbxAccountTo.setCommitFormat("$helpCode$;$number$;$name$");
        this.pbxAccountTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbxAccountTo.setCommitParser((IParser)new AccountViewParser(this.pbxAccountTo));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        this.pbxAccountFrom.setSelectorCollection(sic);
        this.pbxAccountTo.setSelectorCollection(sic);
        this.setAccountF7Filter();
    }

    protected void setAccountF7Filter() throws Exception {
        AccountTableInfo accountTable = this.curCompany.getAccountTable();
        try {
            AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(this.curCompany.getId().toString(), accountTable.getId().toString(), this.spnYearTo.getIntegerVlaue().intValue(), this.spnPeriodTo.getIntegerVlaue().intValue());
            if (ar != null) {
                accountTable = ar.getEnabledAcctTable();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.curCompany.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        fic.add(new FilterItemInfo("isProfitCenter", (Object)new Integer(1), CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, accountTable, filter, false);
        this.pbxAccountFrom.setSelector((KDPromptSelector)apb);
        this.pbxAccountTo.setSelector((KDPromptSelector)apb);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        this.pbxAccountFrom.setEntityViewInfo(ev);
        this.pbxAccountTo.setEntityViewInfo(ev);
    }

    private void initDiffItemF7() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1));
        view.setFilter(filter);
        SelectorItemCollection sic = this.getDiSelector();
        DiffItemF7Selector selector = new DiffItemF7Selector((IUIObject)this, filter);
        this.pbxDiffItemFrom.setEditable(true);
        this.pbxDiffItemFrom.setDisplayFormat("$number$;$name$");
        this.pbxDiffItemFrom.setEditFormat("$number$;$name$");
        this.pbxDiffItemFrom.setCommitFormat("$number$;$name$");
        this.pbxDiffItemFrom.setQueryInfo("com.kingdee.eas.fi.gl.app.F7DiffItemQuery");
        this.pbxDiffItemFrom.setSelectorCollection(sic);
        this.pbxDiffItemFrom.setEntityViewInfo(view);
        this.pbxDiffItemFrom.setSelector((KDPromptSelector)selector);
        this.pbxDiffItemTo.setEditable(true);
        this.pbxDiffItemTo.setDisplayFormat("$number$;$name$");
        this.pbxDiffItemTo.setEditFormat("$number$;$name$");
        this.pbxDiffItemTo.setCommitFormat("$number$;$name$");
        this.pbxDiffItemTo.setQueryInfo("com.kingdee.eas.fi.gl.app.F7DiffItemQuery");
        this.pbxDiffItemTo.setSelectorCollection(sic);
        this.pbxDiffItemTo.setEntityViewInfo(view);
        this.pbxDiffItemTo.setSelector((KDPromptSelector)selector);
    }

    private SelectorItemCollection getDiSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("dc"));
        return sic;
    }

    public void loadData(EntityViewInfo view) {
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setPeriodRange() {
        if (this.getUIContext().get("isClearing") != null) {
            return;
        }
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys == null) {
            return;
        }
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        for (int i = 0; i < companys.length; ++i) {
            companyColl.add(companys[i]);
        }
        boolean isPeriodEnable = !companyColl.isEmpty();
        this.spnYearFrom.setEnabled(isPeriodEnable);
        this.spnPeriodFrom.setEnabled(isPeriodEnable);
        this.spnYearTo.setEnabled(isPeriodEnable);
        this.spnPeriodTo.setEnabled(isPeriodEnable);
        if (isPeriodEnable) {
            try {
                SpinnerUtil.managePeriodRange((PeriodEntity)this.pe, (KDSpinner)this.spnYearFrom, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodTo, (boolean)false, (boolean)false);
            }
            catch (Exception e) {
                this.spnYearFrom.setEnabled(false);
                this.spnYearTo.setEnabled(false);
                this.spnPeriodFrom.setEnabled(false);
                this.spnPeriodTo.setEnabled(false);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            }
        }
    }

    protected CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.bpCompany.getValue();
        if (company instanceof CompanyOrgUnitInfo) {
            return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
        }
        if (this.bpCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            return (CompanyOrgUnitInfo[])this.bpCompany.getValue();
        }
        if (this.bpCompany.getValue() instanceof Object[]) {
            Object[] companyObjs = (Object[])this.bpCompany.getValue();
            return this.toObjectArray2CompanyArray(companyObjs);
        }
        return null;
    }

    private CompanyOrgUnitInfo[] toObjectArray2CompanyArray(Object[] companyObjs) {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < companyObjs.length; ++i) {
            if (!(companyObjs[i] instanceof CompanyOrgUnitInfo)) continue;
            companyList.add(companyObjs[i]);
        }
        if (companyList.isEmpty()) {
            return null;
        }
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companyList.size()];
        return companyList.toArray(companys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        super.clear();
        Map uictx = this.getUIContext();
        try {
            uictx.put("isClearing", Boolean.TRUE);
            this.pbxAccountFrom.setData(null);
            this.pbxAccountTo.setData(null);
            this.pbxDiffItemFrom.setData(null);
            this.pbxDiffItemTo.setData(null);
            this.cbxAllVoucher.setSelected(false);
            this.radByEntry.setSelected(true);
            CompanyOrgUnitInfo firstCompany = this.getFirstCompany();
            if (firstCompany != null) {
                this.bpCompany.setValue((Object)new CompanyOrgUnitInfo[]{firstCompany});
                AccountTableInfo accountTableInfo = firstCompany.getAccountTable();
            } else {
                this.bpCompany.setValue(null);
            }
        }
        finally {
            uictx.remove("isClearing");
        }
        this.setPeriodRange();
    }

    private CompanyOrgUnitInfo getFirstCompany() {
        try {
            return GLGeneralFacadeFactory.getRemoteInstance().getFirstCompany(this.getPermissionItem());
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private String getPermissionItem() {
        return "gl_voucher01_view";
    }

    protected void initAccountTableComboBox() throws Exception {
        AccountTableCollection accountTables = this.getAllAccountTableCollection();
        Vector accountTableList = this.toVector((AbstractObjectCollection)accountTables);
        AccountTableInfo accountTable = this.curCompany.getAccountTable();
        accountTableList.add(0, accountTable);
        this.bpAccount.setModel(new DefaultComboBoxModel(accountTableList));
    }

    private Vector toVector(AbstractObjectCollection coll) {
        if (coll == null) {
            return null;
        }
        Vector v = new Vector();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        return v;
    }

    private AccountTableCollection getAllAccountTableCollection() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return AccountTableFactory.getRemoteInstance().getAccountTableCollection(view);
    }

    protected void pbxAccountFrom_dataChanged1(DataChangeEvent e) throws Exception {
        super.pbxAccountFrom_dataChanged(e);
    }

    protected void spnPeriodFrom_stateChanged(ChangeEvent e) throws Exception {
    }

    protected void spnPeriodTo_stateChanged(ChangeEvent e) throws Exception {
    }

    protected void spnYearFrom_stateChanged(ChangeEvent e) throws Exception {
    }

    protected void spnYearTo_stateChanged(ChangeEvent e) throws Exception {
        if (this.curCompany.isIsBizUnit()) {
            int yearEnd = (Integer)this.spnYearTo.getValue();
            int numberEnd = (Integer)this.spnPeriodTo.getValue();
            RptClientUtil.periodChanged((IUIObject)this, this.curCompany, yearEnd, numberEnd, this.pbxAccountFrom, this.pbxAccountTo);
        }
    }

    @Override
    protected void pbxAccountFrom_dataChanged(DataChangeEvent e) throws Exception {
        super.pbxAccountFrom_dataChanged(e);
    }

    public CompanyOrgUnitInfo getCurCompany() {
        return this.curCompany;
    }

    public void setCurCompany(CompanyOrgUnitInfo curCompany) {
        this.curCompany = curCompany;
    }

    public void setCustomerParams(CustomerParams cp) {
        String diffItemToId;
        String accountToId;
        super.setCustomerParams(cp);
        if (cp == null) {
            return;
        }
        String startYear = cp.getCustomerParam("startYear");
        String startPeriod = cp.getCustomerParam("startPeriod");
        String endYear = cp.getCustomerParam("endYear");
        String endPeriod = cp.getCustomerParam("endPeriod");
        if (startYear != null && startPeriod != null && endYear != null && endPeriod != null) {
            this.spnYearFrom.setValue((Object)this.pe.getMinYear());
            this.spnPeriodFrom.setValue((Object)this.pe.getMinPeriod(this.pe.getMinYear()));
            this.spnYearTo.setValue((Object)this.pe.getMaxYear());
            this.spnPeriodTo.setValue((Object)this.pe.getMaxPeriod(this.pe.getMaxYear()));
            this.spnYearFrom.setValue((Object)new Integer(startYear));
            this.spnPeriodFrom.setValue((Object)new Integer(startPeriod));
            this.spnYearTo.setValue((Object)new Integer(endYear));
            this.spnPeriodTo.setValue((Object)new Integer(endPeriod));
        }
        HashSet<String> accountIds = new HashSet<String>();
        String accountFromId = cp.getCustomerParam("accountFrom");
        if (accountFromId != null) {
            accountIds.add(accountFromId);
        }
        if ((accountToId = cp.getCustomerParam("accountTo")) != null) {
            accountIds.add(accountToId);
        }
        AccountViewInfo accountFrom = null;
        AccountViewInfo accountTo = null;
        if (accountIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", accountIds, CompareType.INCLUDE));
            view.setFilter(filter);
            try {
                AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
                for (AccountViewInfo account : coll) {
                    if (account.getId().toString().equals(accountFromId)) {
                        accountFrom = account;
                    }
                    if (!account.getId().toString().equals(accountToId)) continue;
                    accountTo = account;
                }
            }
            catch (BOSException coll) {
                // empty catch block
            }
        }
        this.pbxAccountFrom.setValue(accountFrom);
        this.pbxAccountTo.setValue(accountTo);
        HashSet<String> diffItemIds = new HashSet<String>();
        String diffItemFromId = cp.getCustomerParam("diffItemFrom");
        if (diffItemFromId != null) {
            diffItemIds.add(diffItemFromId);
        }
        if ((diffItemToId = cp.getCustomerParam("diffItemTo")) != null) {
            diffItemIds.add(diffItemToId);
        }
        DiffItemInfo diffItemFrom = null;
        DiffItemInfo diffItemTo = null;
        if (diffItemIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", diffItemIds, CompareType.INCLUDE));
            view.setFilter(filter);
            try {
                DiffItemCollection coll = DiffItemFactory.getRemoteInstance().getDiffItemCollection(view);
                Iterator it = coll.iterator();
                while (it.hasNext()) {
                    DiffItemInfo diffItem = (DiffItemInfo)it.next();
                    if (diffItem.getId().toString().equals(diffItemFromId)) {
                        diffItemFrom = diffItem;
                    }
                    if (!diffItem.getId().toString().equals(diffItemToId)) continue;
                    diffItemTo = diffItem;
                }
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        this.pbxDiffItemFrom.setValue(diffItemFrom);
        this.pbxDiffItemTo.setValue(diffItemTo);
        String includeUnPosted = cp.getCustomerParam("includeUnPosted");
        this.cbxAllVoucher.setSelected("1".equals(includeUnPosted));
        String queryBy = cp.getCustomerParam("queryBy");
        if ("voucher".equals(queryBy)) {
            this.radByVoucher.setSelected(true);
        } else {
            this.radByEntry.setSelected(true);
        }
    }

    public CustomerParams getCustomerParams() {
        Object toObject;
        CustomerParams cp = super.getCustomerParams();
        if (cp == null) {
            cp = new CustomerParams();
        }
        cp.addCustomerParam("startYear", ((Integer)this.spnYearFrom.getValue()).toString());
        cp.addCustomerParam("startPeriod", ((Integer)this.spnPeriodFrom.getValue()).toString());
        cp.addCustomerParam("endYear", ((Integer)this.spnYearTo.getValue()).toString());
        cp.addCustomerParam("endPeriod", ((Integer)this.spnPeriodTo.getValue()).toString());
        Object fromObject = this.pbxAccountFrom.getValue();
        if (fromObject instanceof AccountViewInfo) {
            cp.addCustomerParam("accountFrom", ((AccountViewInfo)fromObject).getId().toString());
        }
        if ((toObject = this.pbxAccountTo.getValue()) instanceof AccountViewInfo) {
            cp.addCustomerParam("accountTo", ((AccountViewInfo)toObject).getId().toString());
        }
        if ((fromObject = this.pbxDiffItemFrom.getValue()) instanceof DiffItemInfo) {
            cp.addCustomerParam("diffItemFrom", ((DiffItemInfo)fromObject).getId().toString());
        }
        if ((toObject = this.pbxDiffItemTo.getValue()) instanceof DiffItemInfo) {
            cp.addCustomerParam("diffItemTo", ((DiffItemInfo)toObject).getId().toString());
        }
        cp.addCustomerParam("includeUnPosted", this.cbxAllVoucher.isSelected() ? "1" : "5");
        cp.addCustomerParam("queryBy", this.radByVoucher.isSelected() ? "voucher" : "entry");
        return cp;
    }

    public FilterInfo getFilterInfo() {
        Object toObject;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.curCompany.getId().toString()));
        Integer startYear = (Integer)this.spnYearFrom.getValue();
        Integer startPeriod = (Integer)this.spnPeriodFrom.getValue();
        Integer endYear = (Integer)this.spnYearTo.getValue();
        Integer endPeriod = (Integer)this.spnPeriodTo.getValue();
        filterInfo.getFilterItems().add(new FilterItemInfo("period.number", (Object)(startYear * 100 + startPeriod), CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("period.number", (Object)(endYear * 100 + endPeriod), CompareType.LESS_EQUALS));
        Object fromObject = this.pbxAccountFrom.getValue();
        if (fromObject instanceof AccountViewInfo) {
            filterInfo.getFilterItems().add(new FilterItemInfo("account.number", (Object)((AccountViewInfo)fromObject).getNumber(), CompareType.GREATER_EQUALS));
        }
        if ((toObject = this.pbxAccountTo.getValue()) instanceof AccountViewInfo) {
            filterInfo.getFilterItems().add(new FilterItemInfo("account.number", (Object)((AccountViewInfo)toObject).getNumber(), CompareType.LESS_EQUALS));
        }
        if ((fromObject = this.pbxDiffItemFrom.getValue()) instanceof DiffItemInfo) {
            filterInfo.getFilterItems().add(new FilterItemInfo("diffItem.number", (Object)((DiffItemInfo)fromObject).getNumber(), CompareType.GREATER_EQUALS));
        }
        if ((toObject = this.pbxDiffItemTo.getValue()) instanceof DiffItemInfo) {
            filterInfo.getFilterItems().add(new FilterItemInfo("diffItem.number", (Object)((DiffItemInfo)toObject).getNumber(), CompareType.LESS_EQUALS));
        }
        if (this.cbxAllVoucher.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5)));
        }
        return filterInfo;
    }
}

