/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.render.RenderObject;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.master.account.AccountCategoryEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.client.DiffItemRecordAutoUI;
import com.kingdee.eas.fi.gl.client.DiffItemRecordEditUI;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptDiffItemDetUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptDiffItemDetQueryUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GLRptDiffItemDetUI
extends AbstractGLRptDiffItemDetUI {
    private static final Logger logger = CoreUIObject.getLogger(GLRptDiffItemDetUI.class);
    protected static Image imgBudget = null;
    private Map<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
    protected CommonQueryDialog queryDlg;
    protected GLRptDiffItemDetQueryUI myPanel;
    private boolean isFirstDefaultQuery = true;
    private boolean showQueryDlg = true;
    protected EntityViewInfo view;
    private CompanyOrgUnitInfo curCompany = null;

    public void onLoad() throws Exception {
        this.curCompany = this.getCurrentCompany();
        this.setMergeColumn();
        super.onLoad();
        this.actionAddNew.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionView.setVisible(false);
        this.actionView.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionCheckDiffItem.setVisible(false);
        this.actionCheckDiffItem.setEnabled(false);
        this.myPanel = new GLRptDiffItemDetQueryUI();
        this.queryDlg = new CommonQueryDialog();
        this.initCommonQuery();
        Map param = (Map)this.getUIContext().get("param");
        if (param != null) {
            this.showQueryDlg = false;
            this.actionQuery.setEnabled(false);
            this.actionQuery.setVisible(false);
            this.setUITitle(this.getUITitle() + this.getUIContext().get("uiname"));
        }
        this.initTableStyle();
        if (!this.showQueryDlg(null)) {
            SysUtil.abort();
        }
    }

    private void initCommonQuery() throws Exception {
        this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.queryDlg.setWidth(350);
        this.queryDlg.setHeight(330);
        this.queryDlg.setQueryObjectPK(this.mainQueryPK);
        this.queryDlg.setShowFilter(true);
        this.queryDlg.setShowSorter(true);
        this.queryDlg.setShowToolbar(true);
        this.queryDlg.setUiObject((IUIObject)this);
        this.queryDlg.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"diffItem_query"));
        this.queryDlg.addUserPanel((KDPanel)this.myPanel);
        this.queryDlg.setProcessor((IProcessor)new CommonQueryProcessor(){

            public void process() throws Exception {
                String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
                if ("bizStatus".equalsIgnoreCase(fieldProperty)) {
                    Object editor = this.get("CURRENT_EDITOR");
                    KDComboBox cmb = (KDComboBox)editor;
                    int size = cmb.getItemCount();
                    for (int i = 0; i < size; ++i) {
                        Object item = cmb.getItemAt(i);
                        if (VoucherStatusEnum.CANCELLED != item && VoucherStatusEnum.TEMP != item) continue;
                        cmb.removeItemAt(i);
                    }
                }
            }
        });
    }

    public boolean showQueryDlg(ActionEvent evt) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = "";
        queryName = this.mainQueryPK == null ? "com.kingdee.eas.fi.gl.app.GLRptDiffItemDetQuery" : (GLRptDiffItemDetUI.getQueryInfo((IMetaDataPK)this.mainQueryPK) == null ? "com.kingdee.eas.fi.gl.app.GLRptDiffItemDetQuery" : GLRptDiffItemDetUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName());
        String curUserID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String curCompanyId = this.curCompany.getId().toString();
        if (!this.showQueryDlg) {
            this.isFirstDefaultQuery = false;
            this.view = new EntityViewInfo();
            Map param = (Map)this.getUIContext().get("param");
            FilterInfo filter = new FilterInfo();
            Object companyId = param.get("companyId");
            if (companyId instanceof String) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", companyId));
            } else if (companyId instanceof Set) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", companyId, CompareType.INCLUDE));
            }
            Integer startYear = (Integer)param.get("startYear");
            Integer startPeriod = (Integer)param.get("startPeriod");
            Integer endYear = (Integer)param.get("endYear");
            Integer endPeriod = (Integer)param.get("endPeriod");
            filter.getFilterItems().add(new FilterItemInfo("period.number", (Object)(startYear * 100 + startPeriod), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period.number", (Object)(endYear * 100 + endPeriod), CompareType.LESS_EQUALS));
            Object accountId = param.get("accountId");
            if (accountId instanceof String) {
                filter.getFilterItems().add(new FilterItemInfo("account.id", accountId));
            } else if (accountId instanceof Set) {
                filter.getFilterItems().add(new FilterItemInfo("account.id", accountId, CompareType.INCLUDE));
            }
            Object accountNumber = param.get("accountNumber");
            if (accountNumber instanceof String) {
                filter.getFilterItems().add(new FilterItemInfo("account.number", accountNumber));
            } else if (accountNumber instanceof Set) {
                filter.getFilterItems().add(new FilterItemInfo("account.number", accountNumber, CompareType.INCLUDE));
            }
            Object diffItemId = param.get("diffItemId");
            if (diffItemId instanceof String) {
                filter.getFilterItems().add(new FilterItemInfo("diffItem.id", diffItemId));
            } else if (diffItemId instanceof Set) {
                filter.getFilterItems().add(new FilterItemInfo("diffItem.id", diffItemId, CompareType.INCLUDE));
            }
            Object diffItemNumber = param.get("diffItemNumber");
            if (diffItemNumber instanceof String) {
                filter.getFilterItems().add(new FilterItemInfo("diffItem.number", diffItemNumber));
            } else if (diffItemNumber instanceof Set) {
                filter.getFilterItems().add(new FilterItemInfo("diffItem.number", diffItemNumber, CompareType.INCLUDE));
            }
            if ("1".equals((String)param.get("includeUnPosted"))) {
                filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5)));
            }
            this.view.setFilter(filter);
            this.mainQuery = this.view;
        } else if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName, curCompanyId, curUserID)) {
            this.isFirstDefaultQuery = false;
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName, curCompanyId, curUserID);
            if (SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)solution.getSolutionType())) {
                this.view = new EntityViewInfo();
                FilterInfo filter = this.myPanel.getFilterInfo();
                this.view.setFilter(filter);
                this.mainQuery = this.view;
            } else {
                QueryPanelCollection panels = solution.getQueryPanelInfo();
                QueryPanelInfo panel = null;
                int size = panels.size();
                for (int i = 0; i < size; ++i) {
                    panel = panels.get(i);
                    if (panel == null || panel.getCustomerParams() == null || !panel.getPanelClassName().equals(this.myPanel.getMetaDataPK().getFullName())) continue;
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)panel.getCustomerParams());
                    this.myPanel.setCustomerParams(cp);
                }
                this.view = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                this.mainQuery = (EntityViewInfo)this.view.clone();
            }
            this.doDefaultSolution(iQuery, queryName);
            this.applyPreference();
        } else {
            this.isFirstDefaultQuery = false;
            if (this.queryDlg.show()) {
                this.tHelper.setDialog(this.queryDlg);
                this.view = (EntityViewInfo)this.queryDlg.getEntityViewInfoResult().clone();
                this.mainQuery = (EntityViewInfo)this.view.clone();
                this.doQuery(this.queryDlg);
            } else {
                this.tHelper.setDialog(this.queryDlg);
                return false;
            }
        }
        this.refresh(evt);
        this.showQueryDlg = true;
        return true;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.isFirstDefaultQuery) {
            return;
        }
        this.queryDlg.setUiObject((IUIObject)this);
        this.tHelper.init();
        this.showQueryDlg(e);
        this.tHelper.setDialog(this.queryDlg);
        this.doQuery(this.queryDlg);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.queryVoucher(this.tblMain, "id");
            return;
        }
        super.tblMain_tableClicked(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.queryVoucher(this.tblMain, "id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryVoucher(KDTable table, String voucherIdColumnKey) {
        String voucherId;
        int rowIndex = table.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return;
        }
        IRow row = table.getRow(rowIndex);
        if (row != null && (voucherId = (String)row.getCell(voucherIdColumnKey).getValue()) != null) {
            try {
                this.setCursorOfWair();
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)voucherId);
                uiContext.put((Object)"NOTLICHA", (Object)"NOTLICHA");
                uiContext.put((Object)"FINDVIEW", (Object)Boolean.TRUE);
                if (row.getCell("entries.seq") != null) {
                    uiContext.put((Object)"ENTRYSEQ", row.getCell("entries.seq").getValue());
                }
                if (row.getCell("recordSeq") != null) {
                    uiContext.put((Object)"ASSISTSEQ", row.getCell("recordSeq").getValue());
                }
                IIDList voucherIdList = GLRptDiffItemDetUI.getVoucherIDList(table, voucherIdColumnKey);
                voucherIdList.setCurrentID(voucherId);
                uiContext.put((Object)"IDList", (Object)voucherIdList);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)VoucherEditUI.getEditUIMode((CoreUIObject)this)).create(VoucherInfo.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            finally {
                this.setCursorOfDefault();
            }
        }
    }

    private static IIDList getVoucherIDList(KDTable tblMain, String voucherColKey) {
        RealModeIDList idList = new RealModeIDList(){

            public void setCurrentID(String id) {
                if (this.newIdList.contains(id)) {
                    this.setCurrentIndex(this.newIdList.indexOf(id));
                }
            }
        };
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            String voucherId = (String)tblMain.getRow(i).getCell(voucherColKey).getValue();
            if (voucherId == null || idList.contains(voucherId)) continue;
            idList.add(voucherId);
        }
        return idList;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"company.name", "entries.seq"};
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    protected void initTableStyle() throws Exception {
        if (imgBudget == null) {
            imgBudget = Toolkit.getDefaultToolkit().getImage(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/fi/gl/client/images/category_budget_12.png"));
        }
        this.tblMain.getColumn("account.number").setRenderer((IBasicRender)new ObjectValueRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle, Object extObject) {
                AccountCategoryEnum category = null;
                Object categoryObject = GLRptDiffItemDetUI.this.tblMain.getRow(((RenderObject)extObject).getRowIndex()).getCell("account.category").getValue();
                if (categoryObject instanceof BizEnumValueDTO) {
                    category = AccountCategoryEnum.getEnum((int)((BizEnumValueDTO)categoryObject).getInt());
                }
                Rectangle rInner = new Rectangle();
                this.getCellInnerBounds(rInner, clip.getBounds());
                super.draw(graphics, (Shape)rInner, object, cellStyle, null);
                if (category != null) {
                    Rectangle bounds = clip.getBounds();
                    if (AccountCategoryEnum.BUDGET.equals((Object)category) && imgBudget != null) {
                        graphics.drawImage(imgBudget, bounds.x - 3, bounds.y, null);
                    }
                }
            }

            protected void getCellInnerBounds(Rectangle inner, Rectangle origin) {
                inner.x = origin.x + 3 + 4;
                inner.y = origin.y + 0;
                inner.width = origin.width - 6 - 4;
                inner.height = origin.height - 0;
            }
        });
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    GLRptDiffItemDetUI.this.setDecimalFormat(e.getFirstRow(), e.getLastRow() - e.getFirstRow() + 1);
                }
                catch (Exception ex) {
                    GLRptDiffItemDetUI.this.handleException(ex);
                }
            }
        });
    }

    private void setDecimalFormat(int beginRowIndex, int length) throws Exception {
        IRow row = null;
        for (int i = beginRowIndex; i < beginRowIndex + length; ++i) {
            row = this.tblMain.getRow2(i);
            if (row == null) continue;
            int localPrecision = 2;
            String companyId = (String)row.getCell("company.id").getValue();
            CompanyOrgUnitInfo company = this.getCompany(companyId);
            if (company != null) {
                localPrecision = company.getBaseCurrency().getPrecision();
            }
            int precision = localPrecision;
            Object o = row.getCell("currency.precision").getValue();
            if (o instanceof Integer) {
                precision = (Integer)o;
            }
            row.getCell("entries.originalAmount").getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(precision));
            row.getCell("localAmountDebit").getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(localPrecision));
            row.getCell("localAmountCredit").getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(localPrecision));
            row.getCell("assignedLocalAmount").getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(localPrecision));
        }
    }

    private CompanyOrgUnitInfo getCompany(String companyId) {
        if (this.companyMap.containsKey(companyId)) {
            return this.companyMap.get(companyId);
        }
        CompanyOrgUnitInfo company = null;
        try {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), GlUtils.getCompanySic());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.companyMap.put(companyId, company);
        return company;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        SorterItemCollection sorter = viewInfo.getSorter();
        if (sorter == null) {
            sorter = new SorterItemCollection();
        }
        if (sorter.size() == 0) {
            SorterItemInfo sbd = new SorterItemInfo("bookedDate");
            sbd.setSortType(SortType.DESCEND);
            sorter.add(sbd);
            SorterItemInfo snumber = new SorterItemInfo("number");
            snumber.setSortType(SortType.DESCEND);
            sorter.add(snumber);
            sorter.add(new SorterItemInfo("id"));
            sorter.add(new SorterItemInfo("entries.seq"));
            sorter.add(new SorterItemInfo("record.checkSeq"));
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    private CompanyOrgUnitInfo getCurrentCompany() {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (this.getUIContext().get("company") != null && this.getUIContext().get("company") instanceof CompanyOrgUnitInfo) {
            company = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        }
        return company;
    }

    @Override
    public void actionDiffItem_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectRows[0]);
        if (row == null) {
            return;
        }
        Object id = row.getCell(this.getKeyFieldName()).getValue();
        if (id == null) {
            return;
        }
        DiffItemRecordEditUI.showMe((Object)this, id.toString());
    }

    @Override
    public void actionAutoDiffItem_actionPerformed(final ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> numbers = new ArrayList<String>();
        for (int rowIndex : selectRows) {
            String id;
            Object value;
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null || (value = row.getCell("id").getValue()) == null || set.contains(id = value.toString())) continue;
            set.add(id);
            ids.add(id);
            String number = null;
            value = row.getCell("number").getValue();
            if (value != null) {
                number = value.toString();
            }
            numbers.add(number);
        }
        if (ids.size() > 0) {
            DiffItemRecordAutoUI.showMe((Object)this, ids, numbers);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        GLRptDiffItemDetUI.this.actionRefresh_actionPerformed(e);
                    }
                    catch (Exception ex) {
                        GLRptDiffItemDetUI.this.handleException(ex);
                    }
                }
            });
        }
    }

    @Override
    public void actionCheckDiffItem_actionPerformed(ActionEvent e) throws Exception {
    }
}

