/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.DiffItemUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptDiffItemSumCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptDiffItemSumFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptDiffItemSumUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptDiffItemDetUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptDiffItemSumQueryUI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptDiffItemSumUI
extends AbstractGLRptDiffItemSumUI {
    private static final Logger logger = CoreUIObject.getLogger(GLRptDiffItemSumUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.actionPrint.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionMenuItemPrintParame.setVisible(false);
        this.actionMenuItemPrintParame.setEnabled(false);
        this.getTable().getActionMap().put("Paste", null);
    }

    @Override
    protected GLRptBaseCondition createQueryCond(Map param) {
        try {
            return new GLRptDiffItemSumCondition(param);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
            return null;
        }
    }

    @Override
    protected BOSQueryDelegate getPrintQueryDelegate(GLRptRowSet rs, GLRptBaseCondition cond, GLRptBasePrintConfig config) throws EASBizException, BOSException {
        return null;
    }

    @Override
    protected GLRptBaseQueryUI getCustQueryPanel() throws Exception {
        return new GLRptDiffItemSumQueryUI();
    }

    @Override
    protected IGLRptBaseFacade getIGLRptFacade() throws BOSException {
        return GLRptDiffItemSumFacadeFactory.getRemoteInstance();
    }

    @Override
    protected String getPermissionItem() {
        return "gl_diffItemSum_view";
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        GLRptDiffItemSumUI.this.doTableDoubleClick(e.getRowIndex());
                    }
                }
                catch (Exception ex) {
                    GLRptDiffItemSumUI.this.handUIException(ex);
                }
            }
        });
    }

    protected void doTableDoubleClick(int rowIndex) throws Exception {
        if (rowIndex < 0 || rowIndex >= this.getTable().getRowCount()) {
            return;
        }
        this.showDetUI(rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDetUI(int rowIndex) throws Exception {
        CompanyOrgUnitInfo company;
        GLRptBaseCondition condition = this.getQueryCond();
        if (condition == null) {
            return;
        }
        IRow row = this.getTable().getRow(rowIndex);
        if (row == null) {
            return;
        }
        String diffItemId = (String)row.getCell("FDiffItemID").getValue();
        if (diffItemId == null || diffItemId.startsWith("virtual")) {
            return;
        }
        String companyId = (String)row.getCell("FOrgUnitID").getValue();
        if (companyId == null) {
            return;
        }
        HashMap<String, CompanyOrgUnitInfo> companys = new HashMap<String, CompanyOrgUnitInfo>();
        if (condition.getCompany() != null) {
            companys.put(condition.getCompany().getId().toString(), condition.getCompany());
        }
        if (condition.getSelectedCompanys() != null) {
            for (CompanyOrgUnitInfo company2 : condition.getSelectedCompanys()) {
                if (company2 == null) continue;
                companys.put(company2.getId().toString(), company2);
            }
        }
        if ((company = (CompanyOrgUnitInfo)companys.get(companyId)) == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            selector.add("longNumber");
            selector.add("isBizUnit");
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        }
        String diffItemNumber = (String)row.getCell("FDiffItemNumber").getValue();
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
            uiContext.put((Object)"ID", (Object)(companyId + "_" + diffItemId));
            uiContext.put((Object)"uiname", (Object)("(" + company.getName() + ":" + diffItemNumber + ")"));
            HashMap<String, Object> param = new HashMap<String, Object>();
            if (company.isIsBizUnit()) {
                param.put("companyId", companyId);
            } else {
                HashSet<String> companyIds = new HashSet<String>();
                for (CompanyOrgUnitInfo info : companys.values()) {
                    if (!info.isIsBizUnit() || !info.getLongNumber().startsWith(company.getLongNumber())) continue;
                    companyIds.add(info.getId().toString());
                }
            }
            param.put("startYear", condition.getPeriodYearStart());
            param.put("startPeriod", condition.getPeriodNumberStart());
            param.put("endYear", condition.getPeriodYearEnd());
            param.put("endPeriod", condition.getPeriodNumberEnd());
            HashSet<String> diffItemIds = new HashSet<String>();
            if ("1".equals(diffItemNumber)) {
                diffItemIds.add(DiffItemUtils.DiffItems.get("10101"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10102"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10201"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10202"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10203"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10204"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10301"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10302"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10401"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10402"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10403"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10404"));
                param.put("diffItemId", diffItemIds);
            } else if ("101".equals(diffItemNumber)) {
                diffItemIds.add(DiffItemUtils.DiffItems.get("10101"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10102"));
                param.put("diffItemId", diffItemIds);
            } else if ("102".equals(diffItemNumber)) {
                diffItemIds.add(DiffItemUtils.DiffItems.get("10201"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10202"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10203"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10204"));
                param.put("diffItemId", diffItemIds);
            } else if ("103".equals(diffItemNumber)) {
                diffItemIds.add(DiffItemUtils.DiffItems.get("10301"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10302"));
                param.put("diffItemId", diffItemIds);
            } else if ("104".equals(diffItemNumber)) {
                diffItemIds.add(DiffItemUtils.DiffItems.get("10401"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10402"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10403"));
                diffItemIds.add(DiffItemUtils.DiffItems.get("10404"));
                param.put("diffItemId", diffItemIds);
            } else {
                param.put("diffItemId", diffItemId);
            }
            param.put("includeUnPosted", condition.getOptionPosting() ? "1" : "5");
            uiContext.put((Object)"param", param);
            this.setCursorOfWair();
            IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(GLRptDiffItemDetUI.class.getName(), (Map)uiContext, null);
            ui.show();
        }
        finally {
            this.setCursorOfDefault();
        }
    }
}

