/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.utils.ExcelUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class GLRptExcelExporter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.client.GLRptExporter");
    private GLRptBaseCondition cond;
    private HSSFCellStyle headColumnStyle = null;
    private HSSFCellStyle commTotalStyle;
    private HSSFCellStyle commStyle;
    private Map numeralTotalForamts = new HashMap();
    private Map numeralForamts = new HashMap();
    private GLRptTableHeadInfo head;
    private HSSFWorkbook wb;
    protected Map<String, Object> params;
    public DataFormat dataFormat;

    public GLRptExcelExporter(GLRptBaseCondition cond, Map<String, Object> params) {
        this.cond = cond;
        this.params = params;
    }

    public void export(GLRptTableHeadInfo head, GLRptRowSet data) throws BOSException {
        if (data == null || data.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"62_RptAsstactGGExportHelper"));
            SysUtil.abort();
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        wb.setSheetName(0, "sheet1");
        int rptHeadRowCount = this.createRptHead(wb, sheet);
        int rowIndex = this.createHeadColumn(head, wb, sheet, rptHeadRowCount);
        rowIndex = this.createBodyColumn(head, data, wb, sheet, rowIndex);
        this.adjustColumnWidth(head, wb, sheet);
        this.mergeTableHead(head, wb, sheet, rptHeadRowCount);
        this.writeFile(wb);
    }

    protected abstract String getFileName();

    protected int createRptHead(HSSFWorkbook wb, HSSFSheet sheet) {
        return 0;
    }

    protected int createBodyColumn(GLRptTableHeadInfo head, GLRptRowSet data, HSSFWorkbook wb, HSSFSheet sheet, int rowIndex) throws BOSException {
        HSSFRow row = null;
        this.head = head;
        this.wb = wb;
        this.dataFormat = wb.createDataFormat();
        this.commTotalStyle = this.getCellStyle(wb, HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
        this.commStyle = this.getCellStyle(wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        this.commTotalStyle.setAlignment(HorizontalAlignment.LEFT);
        this.commStyle.setAlignment(HorizontalAlignment.LEFT);
        data.beforeFirst();
        while (data.next() && rowIndex < Short.MAX_VALUE) {
            row = sheet.createRow(rowIndex++);
            this.setRowData(row, data);
        }
        return rowIndex;
    }

    protected void setRowData(HSSFRow row, GLRptRowSet data) throws BOSException {
        boolean isTotal = this.isTotal(data);
        GLRptTableHeadInfo.GLRptTableColumnInfo col = null;
        HSSFCell cell = null;
        int colSize = this.head.getColumnSize();
        int cellIndex = 0;
        for (int j = 0; j < colSize; ++j) {
            col = this.head.getTableColumnInfo(j);
            if (col.isHide()) continue;
            cell = row.createCell(cellIndex);
            this.setCellValueAndStyle(col, cell, data, isTotal);
            ++cellIndex;
        }
    }

    protected void setCellValueAndStyle(GLRptTableHeadInfo.GLRptTableColumnInfo col, HSSFCell cell, GLRptRowSet data, boolean isTotal) throws BOSException {
        HSSFCellStyle style = null;
        String colName = col.getColName();
        Object value = data.getObject(colName);
        if (col.isNumeral()) {
            cell.setCellType(CellType.NUMERIC);
            this.setCellDoubleValue(cell, value);
            int precision = col.getScale();
            if (this.cond.isAllCurrency() && colName.endsWith("For")) {
                precision = data.getInt("currencyPre");
            }
            style = this.getNumericStyle(isTotal, precision);
        } else {
            if (value != null) {
                cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
            } else {
                cell.setCellValue((RichTextString)new HSSFRichTextString(""));
            }
            style = this.getCommStyle(isTotal);
        }
        cell.setCellStyle(style);
    }

    protected void setCellDoubleValue(HSSFCell cell, Object value) {
        if (value != null) {
            double val = 0.0;
            try {
                val = Double.parseDouble(value.toString());
            }
            catch (Exception ex) {
                logger.error((Object)"trans to double error!", (Throwable)ex);
            }
            if (val != 0.0) {
                cell.setCellValue(val);
            } else {
                cell.setCellValue((RichTextString)new HSSFRichTextString(""));
            }
        } else {
            cell.setCellValue((RichTextString)new HSSFRichTextString(""));
        }
    }

    protected boolean isTotal(GLRptRowSet data) throws BOSException {
        return false;
    }

    private int createHeadColumn(GLRptTableHeadInfo head, HSSFWorkbook wb, HSSFSheet sheet, int rowIndex) {
        String resFile = "com.kingdee.eas.fi.gl.GLXResource";
        for (int i = 0; i < head.getHeadRowSize(); ++i) {
            HSSFRow row = sheet.createRow(rowIndex++);
            int cellIndex = 0;
            for (int j = 0; j < head.getColumnSize(); ++j) {
                GLRptTableHeadInfo.GLRptTableColumnInfo col = head.getTableColumnInfo(j);
                if (col.isHide()) continue;
                HSSFCell cell = row.createCell(cellIndex);
                String res = EASResource.getString((String)resFile, (String)head.getHeadTitle()[i][j]);
                if ("Missing Resource".equals(res)) {
                    res = head.getHeadTitle()[i][j];
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(res));
                cell.setCellType(CellType.STRING);
                cell.setCellStyle(this.getHeadColumnStyle(wb));
                ++cellIndex;
            }
        }
        return rowIndex;
    }

    private HSSFCellStyle getHeadColumnStyle(HSSFWorkbook wb) {
        if (this.headColumnStyle == null) {
            this.headColumnStyle = wb.createCellStyle();
            this.headColumnStyle.setBorderBottom(BorderStyle.THIN);
            this.headColumnStyle.setBorderTop(BorderStyle.THIN);
            this.headColumnStyle.setBorderLeft(BorderStyle.THIN);
            this.headColumnStyle.setBorderRight(BorderStyle.THIN);
            this.headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
            this.headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
            this.headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            this.headColumnStyle.setHidden(false);
        }
        return this.headColumnStyle;
    }

    private void adjustColumnWidth(GLRptTableHeadInfo head, HSSFWorkbook wb, HSSFSheet sheet) {
        int index = 0;
        for (int i = 0; i < head.getColumnSize(); ++i) {
            if (head.getTableColumnInfo(i).isHide()) continue;
            sheet.setColumnWidth((int)((short)index), head.getTableColumnInfo(i).getWidth() * 40);
            ++index;
        }
    }

    private void mergeTableHead(GLRptTableHeadInfo head, HSSFWorkbook wb, HSSFSheet sheet, int rptHeadRowCount) {
        MergeCell[][] cells = this.getTableHeadCells(head);
        int rowCount = cells.length;
        int colCount = cells[0].length;
        int beginRow = 0;
        int beginCol = 0;
        int endRow = 0;
        int endCol = 0;
        while (endRow != rowCount - 1 || endCol != colCount - 1) {
            int[] beginRowCol;
            for (int i = beginRow; i < rowCount; ++i) {
                for (int j = beginCol; j < colCount && !cells[i][j].isMerged && cells[i][j].getValue().equals(cells[beginRow][beginCol].getValue()); ++j) {
                    endRow = i;
                    endCol = j;
                    cells[i][j].setMerged(true);
                }
            }
            int firstRow = beginRow + rptHeadRowCount;
            int lastRow = endRow + rptHeadRowCount;
            if (firstRow != lastRow || beginCol != endCol) {
                CellRangeAddress rang = new CellRangeAddress(firstRow, lastRow, beginCol, endCol);
                sheet.addMergedRegion(rang);
            }
            if ((beginRowCol = this.getBeginRowCol(cells)) == null) break;
            beginRow = beginRowCol[0];
            beginCol = beginRowCol[1];
        }
    }

    private int[] getBeginRowCol(MergeCell[][] titles) {
        int rowCount = titles.length;
        int colCount = titles[0].length;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                if (titles[i][j].isMerged) continue;
                int[] rowCol = new int[]{i, j};
                return rowCol;
            }
        }
        return null;
    }

    protected HSSFCellStyle getNumericStyle(boolean isTotal, int precision) {
        HSSFCellStyle style = null;
        Integer key = new Integer(precision);
        if (isTotal) {
            style = (HSSFCellStyle)this.numeralTotalForamts.get(key);
            if (style == null) {
                style = this.getCellStyle(this.wb, HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
                HSSFDataFormat format = this.wb.createDataFormat();
                style.setAlignment(HorizontalAlignment.RIGHT);
                style.setDataFormat(format.getFormat(this.getFormatterByPrecision(precision)));
                this.numeralTotalForamts.put(key, style);
            }
        } else {
            style = (HSSFCellStyle)this.numeralForamts.get(key);
            if (style == null) {
                style = this.getCellStyle(this.wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex());
                HSSFDataFormat format = this.wb.createDataFormat();
                style.setAlignment(HorizontalAlignment.RIGHT);
                style.setDataFormat(format.getFormat(this.getFormatterByPrecision(precision)));
                this.numeralForamts.put(key, style);
            }
        }
        return style;
    }

    protected HSSFCellStyle getCommStyle(boolean isTotal) {
        return isTotal ? this.commTotalStyle : this.commStyle;
    }

    protected String getFormatterByPrecision(int precision) {
        String retValue = "#,##0.";
        for (int i = 0; i < precision; ++i) {
            retValue = retValue + "0";
        }
        return retValue;
    }

    private HSSFCellStyle getCellStyle(HSSFWorkbook wb, short bgcolor) {
        HSSFCellStyle numberStyle = wb.createCellStyle();
        numberStyle.setBorderLeft(BorderStyle.THIN);
        numberStyle.setBorderTop(BorderStyle.THIN);
        numberStyle.setBorderRight(BorderStyle.THIN);
        numberStyle.setBorderBottom(BorderStyle.THIN);
        numberStyle.setFillForegroundColor(bgcolor);
        numberStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        numberStyle.setHidden(false);
        numberStyle.setDataFormat(this.dataFormat.getFormat("@"));
        return numberStyle;
    }

    private MergeCell[][] getTableHeadCells(GLRptTableHeadInfo head) {
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        GLRptTableHeadInfo newHead = new GLRptTableHeadInfo();
        for (int i = 0; i < head.getColumnSize(); ++i) {
            GLRptTableHeadInfo.GLRptTableColumnInfo col = head.getTableColumnInfo(i);
            if (col.isHide()) continue;
            indexs.add(new Integer(i));
        }
        String[][] ts = head.getHeadTitle();
        MergeCell[][] cells = new MergeCell[head.getHeadRowSize()][indexs.size()];
        for (int i = 0; i < cells.length; ++i) {
            for (int j = 0; j < indexs.size(); ++j) {
                cells[i][j] = new MergeCell(ts[i][(Integer)indexs.get(j)]);
            }
        }
        return cells;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(HSSFWorkbook wb) {
        OutputStream fOut = null;
        try {
            String fileName = this.getTempFilename("GL");
            fOut = new FileOutputStream(new File(fileName));
            wb.write(fOut);
            this.showFile(fileName);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            try {
                if (fOut != null) {
                    fOut.flush();
                    ((FileOutputStream)fOut).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getTempFilename(String prefix) {
        String filename;
        File excelFile = (File)this.params.get("excelFile");
        if (excelFile != null) {
            return excelFile.getAbsolutePath();
        }
        String path = System.getProperty("user.dir") + File.separator + this.getFileName();
        File uploadFilePath = new File(path);
        if (!uploadFilePath.exists()) {
            uploadFilePath.mkdirs();
        }
        String pp = path + File.separator + prefix;
        long timestamp = System.currentTimeMillis();
        File f = null;
        do {
            filename = pp + timestamp + ".xls";
            f = new File(filename);
            ++timestamp;
        } while (f.exists());
        return filename;
    }

    protected void showFile(String fileName) throws IOException {
        ExcelUtils.showFile(fileName);
    }

    protected GLRptBaseCondition getCond() {
        return this.cond;
    }

    protected class MergeCell {
        String value;
        boolean isMerged = false;

        protected MergeCell(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isMerged() {
            return this.isMerged;
        }

        public void setMerged(boolean isMerged) {
            this.isMerged = isMerged;
        }
    }
}

