/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ExtensionFileFilter;
import com.kingdee.eas.fi.gl.rpt.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptExportUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseUI;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigManager;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigParam;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class GLRptExportUI
extends AbstractGLRptExportUI
implements Runnable,
GLRptExcelExporter.ExportLogger {
    private static final Logger logger = CoreUIObject.getLogger(GLRptExportUI.class);
    private static final DateFormat df = new SimpleDateFormat("yyyyMMdd-HH:mm:ss SSS");
    public static Map<String, String> map = new HashMap<String, String>();
    private GLRptExcelExporter exporter = null;
    private Thread worker = null;
    private boolean finished = true;
    private boolean cancel = false;
    protected ExportExcelConfigParam configParam = null;
    private int excelVersion = 1;
    private CoreUI parentUI = null;
    private File excelFile = null;
    private ExtensionFileFilter xlsxFilter = new ExtensionFileFilter("xlsx", "xlsx(*.xlsx)");
    private ExtensionFileFilter xlsFilter = new ExtensionFileFilter("xls", "xls(*.xls)");
    private boolean isSupportXlsx = false;
    private boolean isSupportXls = false;
    private boolean isExportAutoClose = false;

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        Object parent = uiContext.get("Owner");
        if (parent instanceof CoreUI) {
            this.parentUI = (CoreUI)parent;
        }
        Map params = (Map)uiContext.get("params");
        this.exporter = (GLRptExcelExporter)uiContext.get("exporter");
        if (this.exporter == null) {
            SysUtil.abort();
        }
        if (params.containsKey("isSupportXlsx")) {
            this.isSupportXlsx = (Boolean)params.get("isSupportXlsx");
        }
        if (params.containsKey("isSupportXls")) {
            this.isSupportXls = (Boolean)params.get("isSupportXls");
        }
        if (params.containsKey("isExportAutoClose")) {
            this.isExportAutoClose = (Boolean)params.get("isExportAutoClose");
        }
        ExportExcelConfigParam param = ExportExcelConfigManager.loadExportExcelConfig();
        this.initConfigParam(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isSuccess = false;
        try {
            this.txStartTime.setText(df.format(new Date()));
            Map uiContext = this.getUIContext();
            Map params = (Map)uiContext.get("params");
            params.put("exportLogger", this);
            params.put("excelFile", this.excelFile);
            String alias = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"export_excel") + "\nexport fileName:" + this.excelFile + "\nexport UI:" + this.parentUI.getClass().getName();
            BOSObjectType bosObjectType = BOSObjectType.create((String)"EXPEXCEL");
            if (this.parentUI instanceof GLRptBaseUI) {
                bosObjectType = ((GLRptBaseUI)this.parentUI).getIGLRptFacade().getType();
            }
            IObjectPK logPK = LogUtil.beginLog(null, (String)"export", (BOSObjectType)bosObjectType, null, (String)alias);
            this.exporter.export();
            LogUtil.afterLog(null, (IObjectPK)logPK);
            this.txEndTime.setText(df.format(new Date()));
            isSuccess = true;
        }
        catch (Throwable t) {
            if (t instanceof AbortException) {
                this.showProgress("task cancel");
            } else if (t instanceof EASBizException) {
                this.showProgress(t.getMessage());
                logger.error((Object)"", t);
            } else {
                this.showProgress("task error: " + t.getMessage());
                logger.error((Object)"", t);
            }
        }
        finally {
            this.finished = true;
            this.btnCancel.setText(this.btnClose.getText());
            this.btnCancel.setEnabled(true);
        }
        if (isSuccess && this.isExportAutoClose) {
            this.destroyWindow();
        }
    }

    protected boolean checkBeforeWindowClosing() {
        return this.finished;
    }

    @Override
    public void actionChoose_actionPerformed(ActionEvent e) throws Exception {
        super.actionChoose_actionPerformed(e);
        this.initSaveDialog();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        this.saveConfigParam();
        this.actionChoose.setEnabled(false);
        this.actionExport.setEnabled(false);
        this.finished = false;
        this.worker = new Thread(this);
        this.worker.start();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        if (this.finished || this.actionExport.isEnabled()) {
            this.destroyWindow();
        } else if (!this.cancel) {
            this.cancel = true;
            this.btnCancel.setEnabled(false);
        }
    }

    @Override
    public void info(String msg) {
        this.showProgress(msg);
    }

    @Override
    public void error(String msg) {
        this.showProgress(msg);
    }

    public void showProgress(final String progress) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GLRptExportUI.this.txCurrentProcess.setText(progress);
            }
        });
        if (this.cancel) {
            SysUtil.abort();
        }
    }

    protected void initConfigParam(ExportExcelConfigParam configParam) {
        this.configParam = configParam;
        this.excelVersion = configParam.getExcelVersion();
        if (!this.isSupportXlsx || !this.isSupportXls) {
            this.excelVersion = this.isSupportXlsx ? 0 : 1;
        }
        this.excelFile = new File(configParam.getSavePath(), this.buildFileName(true));
        this.textPath.setText(this.excelFile.getAbsolutePath());
    }

    private void saveConfigParam() {
        if (this.excelFile != null) {
            this.excelVersion = this.excelFile.getName().toLowerCase().endsWith(".xlsx") ? 0 : 1;
        }
        if (this.excelVersion != this.configParam.getExcelVersion() || this.excelFile != null && !this.excelFile.getParent().equals(this.configParam.getSavePath())) {
            this.configParam.setExcelVersion(this.excelVersion);
            if (this.excelFile != null) {
                this.configParam.setSavePath(this.excelFile.getParent());
            }
            ExportExcelConfigManager.saveExportExcelConfig((ExportExcelConfigParam)this.configParam);
        }
    }

    private void initSaveDialog() throws Exception {
        KDFileChooser fileChooser = this.initKDFileChooser();
        File tFile = this.initFile(fileChooser);
        if (tFile != null) {
            this.excelFile = tFile;
        }
    }

    private KDFileChooser initKDFileChooser() throws Exception {
        String fileName = this.excelFile != null ? this.excelFile.getName() : this.buildFileName(true);
        KDFileChooser fileChooser = this.getKDFileChooser(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"export_to_excel"), this.configParam.getSavePath(), fileName);
        return fileChooser;
    }

    private File initFile(KDFileChooser fileChooser) throws Exception {
        if (fileChooser != null) {
            int result = fileChooser.showSaveDialog(null);
            File file = fileChooser.getSelectedFile();
            if (result != 0) {
                return null;
            }
            ExtensionFileFilter filter = (ExtensionFileFilter)fileChooser.getFileFilter();
            String suffix = "." + filter.getExtension();
            if (!file.getAbsolutePath().endsWith(suffix)) {
                file = new File(file.getAbsolutePath() + suffix);
            }
            if (file.exists()) {
                int select = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"56_ExportExcelConfigUI"));
                if (select == 2) {
                    return null;
                }
                if (select == 0 && !file.renameTo(file)) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"57_ExportExcelConfigUI"));
                    return null;
                }
            }
            this.textPath.setText(file.getAbsolutePath());
            return file;
        }
        return null;
    }

    private KDFileChooser getKDFileChooser(String title, String path, String fileName) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setSelectedFile(new File(path, fileName));
        if (this.isSupportXlsx) {
            fileChooser.addChoosableFileFilter((FileFilter)this.xlsxFilter);
        }
        if (this.isSupportXls) {
            fileChooser.addChoosableFileFilter((FileFilter)this.xlsFilter);
        }
        ExtensionFileFilter filter = null;
        if (fileName.toLowerCase().endsWith(".xlsx")) {
            filter = this.xlsxFilter;
        } else if (fileName.toLowerCase().endsWith(".xls")) {
            filter = this.xlsFilter;
        } else if (this.isSupportXlsx) {
            filter = this.xlsxFilter;
        } else if (this.isSupportXls) {
            filter = this.xlsFilter;
        }
        if (filter != null) {
            fileChooser.setFileFilter((FileFilter)filter);
        }
        return fileChooser;
    }

    private String buildFileName(boolean isShowTime) {
        String dateTime = "";
        if (isShowTime) {
            SimpleDateFormat tempDate = new SimpleDateFormat("yyyyMMddHHmmss");
            dateTime = tempDate.format(new Date());
        }
        StringBuffer name = new StringBuffer();
        if (this.parentUI != null) {
            String fileName = FrameWorkUtils.getTrimFileName((String)this.parentUI.getUITitle());
            name.append(fileName).append(dateTime);
        } else {
            name.append(dateTime);
        }
        if (this.excelVersion == 0) {
            name.append(".xlsx");
        } else {
            name.append(".xls");
        }
        return name.toString();
    }

    public static interface Processor {
        public Object process(Map<String, Object> var1) throws Exception;

        public void after(Object var1);

        public boolean autoClose();
    }
}

