/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.client.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerExcelExporter_2007;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;

public class GLRptSubLedgerExcelExporter
extends GLRptExcelExporter {
    public GLRptSubLedgerExcelExporter(GLRptSubLedgerCondition cond, Map<String, Object> params) {
        super(cond, params);
    }

    @Override
    public void export(GLRptTableHeadInfo head, GLRptRowSet data) throws BOSException {
        File excelFile = (File)this.params.get("excelFile");
        if (excelFile != null && excelFile.getName().toLowerCase().endsWith(".xlsx")) {
            GLRptSubLedgerExcelExporter_2007 export = new GLRptSubLedgerExcelExporter_2007(this.getCond(), (Map<String, Object>)this.params);
            ((GLRptExcelExporter)export).export(head, data);
        } else {
            super.export(head, data);
        }
    }

    @Override
    protected int createRptHead(HSSFWorkbook wb, HSSFSheet sheet) {
        int rowIndex = 0;
        HSSFRow row = sheet.createRow(rowIndex++);
        GLRptSubLedgerCondition cond = this.getCond();
        HSSFCell cell = row.createCell(0);
        cell.setCellValue((RichTextString)new HSSFRichTextString((String)this.params.get("Period")));
        CellRangeAddress rang = new CellRangeAddress(0, 0, 0, 3);
        sheet.addMergedRegion(rang);
        cell = row.createCell(4);
        cell.setCellValue((RichTextString)new HSSFRichTextString((String)this.params.get("Currency")));
        rang = new CellRangeAddress(0, 0, 4, 5);
        sheet.addMergedRegion(rang);
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            cell = row.createCell(6);
            cell.setCellValue((RichTextString)new HSSFRichTextString(cond.getCompany().getName()));
            rang = new CellRangeAddress(0, 0, 6, 7);
            sheet.addMergedRegion(rang);
        }
        String optionPosting = cond.getOptionPosting() ? EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"include_unpostvoucher") : EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"posted_voucher");
        cell = row.createCell(8);
        cell.setCellValue((RichTextString)new HSSFRichTextString(optionPosting));
        rang = new CellRangeAddress(0, 0, 8, 9);
        sheet.addMergedRegion(rang);
        return rowIndex;
    }

    @Override
    protected boolean isTotal(GLRptRowSet data) throws BOSException {
        boolean isTotal = false;
        Object balSeq = data.getObject("FBalSeq");
        if (balSeq == null || balSeq.toString().equals("3") || balSeq.toString().equals("4") || balSeq.toString().equals("5") || balSeq.toString().equals("2") && data.getString("voucherNumber") == null) {
            isTotal = true;
        }
        return isTotal;
    }

    @Override
    protected void setCellValueAndStyle(GLRptTableHeadInfo.GLRptTableColumnInfo col, HSSFCell cell, GLRptRowSet data, boolean isTotal) throws BOSException {
        String colName = col.getColName();
        Object value = data.getObject(colName);
        HSSFCellStyle style = null;
        GLRptSubLedgerCondition cond = this.getCond();
        if (colName.equals("FLocalExchangeRate")) {
            int localExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                localExRatePre = data.getInt("FLocalExRatePre");
            }
            style = this.getNumericStyle(isTotal, localExRatePre);
            this.setCellDoubleValue(cell, value);
        } else if (colName.equals("FReportingExchangeRate")) {
            int rptExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                rptExRatePre = data.getInt("FRptExRatePre");
            }
            style = this.getNumericStyle(isTotal, rptExRatePre);
            this.setCellDoubleValue(cell, value);
        } else if (col.isNumeral()) {
            cell.setCellType(CellType.NUMERIC);
            int precision = col.getScale();
            if (cond.isAllCurrency() && colName.endsWith("For")) {
                precision = data.getInt("currencyPre");
            }
            style = this.getNumericStyle(isTotal, precision);
            this.setCellDoubleValue(cell, value);
        } else {
            style = this.getCommStyle(isTotal);
            if (value != null) {
                cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
            } else {
                cell.setCellValue((RichTextString)new HSSFRichTextString(""));
            }
        }
        cell.setCellStyle(style);
    }

    @Override
    protected GLRptSubLedgerCondition getCond() {
        return (GLRptSubLedgerCondition)super.getCond();
    }

    @Override
    protected String getFileName() {
        return "subledgerTmp.xls";
    }
}

