/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.util.XMLEncoder;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.client.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.client.GLRptExportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class GLRptSubLedgerExcelExporter_2007
extends GLRptExcelExporter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerExcelExporter_2007");
    private static final String XML_ENCODING = "UTF-8";
    private int mergeCount = 0;
    private StringBuffer mergeCells = new StringBuffer();
    private CellStyle headColumnStyle = null;
    private CellStyle commTotalStyle = null;
    private CellStyle commStyle = null;
    private Workbook wb = null;
    private Map numeralTotalForamts = new HashMap();
    private Map numeralForamts = new HashMap();

    public GLRptSubLedgerExcelExporter_2007(GLRptSubLedgerCondition cond, Map<String, Object> params) {
        super(cond, params);
    }

    @Override
    public void export(GLRptTableHeadInfo head, GLRptRowSet data) throws BOSException {
        if (data == null || data.size() == 0) {
            MsgBox.showWarning((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"62_RptAsstactGGExportHelper"));
            SysUtil.abort();
        }
        this.wb = new XSSFWorkbook();
        XSSFSheet sheet = (XSSFSheet)this.wb.createSheet();
        this.wb.setSheetName(0, "sheet1");
        if (data == null || data.size() == 0) {
            MsgBox.showWarning((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"62_RptAsstactGGExportHelper"));
            SysUtil.abort();
        }
        String sheetRef = sheet.getPackagePart().getPartName().getName();
        BufferedWriter fw = null;
        OutputStreamWriter osw = null;
        FileOutputStream fos = null;
        FileOutputStream os = null;
        FileOutputStream out = null;
        try {
            String fileName;
            File tmp = File.createTempFile("sheet", ".xml");
            fos = new FileOutputStream(tmp);
            osw = new OutputStreamWriter((OutputStream)fos, XML_ENCODING);
            fw = new BufferedWriter(osw, 20480);
            this.generate(fw, this.wb, head, data);
            String path = System.getProperty("user.dir") + File.separator + "temporary";
            File uploadFilePath = new File(path);
            if (!uploadFilePath.exists()) {
                uploadFilePath.mkdirs();
            }
            os = new FileOutputStream(path + File.separator + "template.xlsx");
            this.wb.write((OutputStream)os);
            File excelFile = (File)this.params.get("excelFile");
            if (excelFile != null) {
                fileName = excelFile.getAbsolutePath();
                out = new FileOutputStream(excelFile);
            } else {
                fileName = this.getTempFilename("GL");
                out = new FileOutputStream(fileName);
            }
            GLRptSubLedgerExcelExporter_2007.substitute(new File(path + File.separator + "template.xlsx"), tmp, sheetRef.substring(1), out);
            this.showFile(fileName);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected int createRptHead(Workbook wb, SpreadsheetWriter sw) throws IOException {
        int rowIndex = 0;
        sw.insertRow(rowIndex++, 21.75);
        GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)this.getCond();
        sw.createCell(0, this.getRichTextString((String)this.params.get("Period")).toString());
        this.mergeCells.append(sw.createMergeCell(0, 0, 0, 3));
        ++this.mergeCount;
        sw.createCell(4, this.getRichTextString((String)this.params.get("Currency")).toString());
        this.mergeCells.append(sw.createMergeCell(0, 0, 4, 5));
        ++this.mergeCount;
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            sw.createCell(6, this.getRichTextString(cond.getCompany().getName()).toString());
            this.mergeCells.append(sw.createMergeCell(0, 0, 6, 7));
            ++this.mergeCount;
        }
        String optionPosting = cond.getOptionPosting() ? EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"include_unpostvoucher") : EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"posted_voucher");
        sw.createCell(8, optionPosting);
        this.mergeCells.append(sw.createMergeCell(0, 0, 8, 9));
        ++this.mergeCount;
        sw.endRow();
        return rowIndex;
    }

    private int createHeadColumn(GLRptTableHeadInfo head, Workbook wb, SpreadsheetWriter sw, int rowIndex) throws IOException {
        String resFile = "com.kingdee.eas.fi.gl.GLXResource";
        for (int i = 0; i < head.getHeadRowSize(); ++i) {
            sw.insertRow(rowIndex++);
            int cellIndex = 0;
            for (int j = 0; j < head.getColumnSize(); ++j) {
                GLRptTableHeadInfo.GLRptTableColumnInfo col = head.getTableColumnInfo(j);
                if (col.isHide()) continue;
                String res = com.kingdee.eas.util.client.EASResource.getString((String)resFile, (String)head.getHeadTitle()[i][j]);
                if ("Missing Resource".equals(res)) {
                    res = head.getHeadTitle()[i][j];
                }
                sw.createCell(cellIndex++, this.getRichTextString(res).toString(), (int)this.getHeadColumnStyle(wb).getIndex());
            }
            sw.endRow();
        }
        return rowIndex;
    }

    protected int createBodyColumn(GLRptTableHeadInfo head, GLRptRowSet data, Workbook wb, SpreadsheetWriter sw, int rowIndex) throws BOSException, IOException {
        Object row = null;
        this.commTotalStyle = this.getCellStyle(wb, HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
        this.commStyle = this.getCellStyle(wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        this.commTotalStyle.setAlignment(HorizontalAlignment.LEFT);
        this.commStyle.setAlignment(HorizontalAlignment.LEFT);
        data.beforeFirst();
        GLRptExportUI exportUI = (GLRptExportUI)this.params.get("exportUI");
        while (data.next()) {
            if (exportUI != null && data.getCurrRowIndex() % 100 == 0) {
                exportUI.showProgress("Build excel " + data.getCurrRowIndex() + "/" + data.size() + " ...");
            }
            sw.insertRow(rowIndex++);
            this.setRowData(head, sw, data);
            sw.endRow();
            sw.flush();
        }
        return rowIndex;
    }

    private void mergeTableHead(GLRptTableHeadInfo head, Workbook wb, SpreadsheetWriter sw, int rptHeadRowCount) {
        if (head.getHeadRowSize() < 2) {
            return;
        }
        String[][] ts = head.getHeadTitle();
        int index = 0;
        int col_index = 0;
        int st_end = 0;
        int st_begin = 0;
        while (index < head.getColumnSize()) {
            if (head.getTableColumnInfo(index).isHide()) {
                ++index;
                continue;
            }
            col_index = index;
            while (ts[0].length > col_index + 1 && ts[0][col_index] != null && ts[0][col_index].equals(ts[0][col_index + 1])) {
                ++col_index;
                ++st_end;
            }
            if (index != col_index && ts[1][index] != null && ts[1][index].equals(ts[0][index])) {
                this.mergeCells.append(sw.createMergeCell(rptHeadRowCount, rptHeadRowCount + 1, st_begin, st_end - 1));
                ++this.mergeCount;
                st_begin = st_end;
                index = col_index + 1;
                continue;
            }
            if (index != col_index) {
                this.mergeCells.append(sw.createMergeCell(rptHeadRowCount, rptHeadRowCount, st_begin, st_end - 1));
                ++this.mergeCount;
                st_begin = st_end;
                index = col_index + 1;
                continue;
            }
            if (ts[1][index] != null && ts[1][index].equals(ts[0][index])) {
                this.mergeCells.append(sw.createMergeCell(rptHeadRowCount, rptHeadRowCount + 1, st_begin, st_begin));
                ++this.mergeCount;
                ++st_begin;
                ++st_end;
                ++index;
                continue;
            }
            ++st_begin;
            ++st_end;
            ++index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void substitute(File zipfile, File tmpfile, String entry, OutputStream out) throws IOException {
        InputStream is = null;
        ZipOutputStream zos = null;
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipfile);
            zos = new ZipOutputStream(out);
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                ZipEntry ze = en.nextElement();
                if (ze.getName().equals(entry)) continue;
                zos.putNextEntry(new ZipEntry(ze.getName()));
                is = zip.getInputStream(ze);
                GLRptSubLedgerExcelExporter_2007.copyStream(is, zos);
                is.close();
            }
            zos.putNextEntry(new ZipEntry(entry));
            is = new FileInputStream(tmpfile);
            GLRptSubLedgerExcelExporter_2007.copyStream(is, zos);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (zos != null) {
                zos.close();
            }
            if (zip != null) {
                zip.close();
            }
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] chunk = new byte[1024];
        while ((count = in.read(chunk)) >= 0) {
            out.write(chunk, 0, count);
        }
    }

    private CellStyle getCellStyle(Workbook wb, short bgcolor) {
        CellStyle numberStyle = wb.createCellStyle();
        numberStyle.setBorderLeft(BorderStyle.THIN);
        numberStyle.setBorderTop(BorderStyle.THIN);
        numberStyle.setBorderRight(BorderStyle.THIN);
        numberStyle.setBorderBottom(BorderStyle.THIN);
        numberStyle.setFillForegroundColor(bgcolor);
        numberStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        numberStyle.setHidden(false);
        return numberStyle;
    }

    protected CellStyle getNumericStylefor2007(boolean isTotal, int precision) {
        CellStyle style = null;
        Integer key = new Integer(precision);
        if (isTotal) {
            style = (CellStyle)this.numeralTotalForamts.get(key);
            if (style == null) {
                style = this.getCellStyle(this.wb, HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
                DataFormat format = this.wb.createDataFormat();
                style.setAlignment(HorizontalAlignment.RIGHT);
                style.setDataFormat(format.getFormat(this.getFormatterByPrecision(precision)));
                this.numeralTotalForamts.put(key, style);
            }
        } else {
            style = (CellStyle)this.numeralForamts.get(key);
            if (style == null) {
                style = this.getCellStyle(this.wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex());
                DataFormat format = this.wb.createDataFormat();
                style.setAlignment(HorizontalAlignment.RIGHT);
                style.setDataFormat(format.getFormat(this.getFormatterByPrecision(precision)));
                this.numeralForamts.put(key, style);
            }
        }
        return style;
    }

    protected void setRowData(GLRptTableHeadInfo head, SpreadsheetWriter sw, GLRptRowSet data) throws BOSException, IOException {
        boolean isTotal = this.isTotal(data);
        GLRptTableHeadInfo.GLRptTableColumnInfo col = null;
        int colSize = head.getColumnSize();
        int cellIndex = 0;
        for (int j = 0; j < colSize; ++j) {
            col = head.getTableColumnInfo(j);
            if (col.isHide()) continue;
            this.setCellValueAndStyle(col, sw, data, isTotal, cellIndex);
            ++cellIndex;
        }
    }

    private CellStyle getHeadColumnStyle(Workbook wb) {
        if (this.headColumnStyle == null) {
            this.headColumnStyle = wb.createCellStyle();
            this.headColumnStyle.setBorderBottom(BorderStyle.THIN);
            this.headColumnStyle.setBorderTop(BorderStyle.THIN);
            this.headColumnStyle.setBorderLeft(BorderStyle.THIN);
            this.headColumnStyle.setBorderRight(BorderStyle.THIN);
            this.headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
            this.headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
            this.headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            this.headColumnStyle.setHidden(false);
        }
        return this.headColumnStyle;
    }

    @Override
    protected boolean isTotal(GLRptRowSet data) throws BOSException {
        boolean isTotal = false;
        Object balSeq = data.getObject("FBalSeq");
        if (balSeq == null || balSeq.toString().equals("3") || balSeq.toString().equals("4") || balSeq.toString().equals("5") || balSeq.toString().equals("2") && data.getString("voucherNumber") == null) {
            isTotal = true;
        }
        return isTotal;
    }

    protected void setCellValueAndStyle(GLRptTableHeadInfo.GLRptTableColumnInfo col, SpreadsheetWriter sw, GLRptRowSet data, boolean isTotal, int cellIndex) throws BOSException, IOException {
        String colName = col.getColName();
        Object value = data.getObject(colName);
        CellStyle style = null;
        GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)this.getCond();
        if (colName.equals("FLocalExchangeRate")) {
            int localExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                localExRatePre = data.getInt("FLocalExRatePre");
            }
            style = this.getNumericStylefor2007(isTotal, localExRatePre);
            this.setCellDoubleValue(sw, style, cellIndex, value);
        } else if (colName.equals("FReportingExchangeRate")) {
            int rptExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                rptExRatePre = data.getInt("FRptExRatePre");
            }
            style = this.getNumericStylefor2007(isTotal, rptExRatePre);
            this.setCellDoubleValue(sw, style, cellIndex, value);
        } else if (col.isNumeral()) {
            int precision = col.getScale();
            if (cond.isAllCurrency() && colName.endsWith("For")) {
                precision = data.getInt("currencyPre");
            }
            style = this.getNumericStylefor2007(isTotal, precision);
            this.setCellDoubleValue(sw, style, cellIndex, value);
        } else {
            style = this.getCommStylefor2007(isTotal);
            if (value != null) {
                sw.createCell(cellIndex, this.getRichTextString(value.toString()).toString(), (int)style.getIndex());
            } else {
                sw.createCell(cellIndex, "", (int)style.getIndex());
            }
        }
    }

    protected CellStyle getCommStylefor2007(boolean isTotal) {
        return isTotal ? this.commTotalStyle : this.commStyle;
    }

    protected void setCellDoubleValue(SpreadsheetWriter sw, CellStyle style, int cellIndex, Object value) throws IOException {
        if (value != null) {
            double val = 0.0;
            if (value instanceof BigDecimal) {
                val = ((BigDecimal)value).doubleValue();
            } else {
                try {
                    val = Double.parseDouble(value.toString());
                }
                catch (Exception ex) {
                    logger.error((Object)"trans to double error!", (Throwable)ex);
                }
            }
            if (val != 0.0) {
                sw.createCell(cellIndex, val, (int)style.getIndex());
            } else {
                sw.createCell(cellIndex, this.getRichTextString(null).toString(), (int)style.getIndex());
            }
        } else {
            sw.createCell(cellIndex, this.getRichTextString("").toString(), (int)style.getIndex());
        }
    }

    private void generate(BufferedWriter out, Workbook wb, GLRptTableHeadInfo head, GLRptRowSet data) throws Exception {
        SpreadsheetWriter sw = new SpreadsheetWriter(out);
        sw.beginWorkSheet();
        sw.beginCols();
        this.adjustColumnWidth(head, wb, sw);
        sw.endCols();
        sw.beginSheetData();
        int rptHeadRowCount = this.createRptHead(wb, sw);
        int index = this.createHeadColumn(head, wb, sw, rptHeadRowCount);
        this.createBodyColumn(head, data, wb, sw, index);
        sw.endSheetData();
        this.mergeTableHead(head, wb, sw, rptHeadRowCount);
        sw.beginMergeCells(this.mergeCount);
        out.write(this.mergeCells.toString());
        sw.endMergeCells();
        sw.endWorkSheet();
        sw.flush();
    }

    @Override
    protected GLRptBaseCondition getCond() {
        return (GLRptSubLedgerCondition)super.getCond();
    }

    @Override
    protected String getFileName() {
        return "subledgerTmp.xlsx";
    }

    protected String getExtString() {
        return "xlsx";
    }

    private String getTempFilename(String prefix) {
        String filename;
        String path = System.getProperty("user.dir") + File.separator + "asstActGDTmp." + this.getExtString();
        File uploadFilePath = new File(path);
        if (!uploadFilePath.exists()) {
            uploadFilePath.mkdirs();
        }
        String pp = path + File.separator + prefix;
        long timestamp = System.currentTimeMillis();
        File f = null;
        do {
            filename = pp + timestamp + "." + this.getExtString();
            f = new File(filename);
            ++timestamp;
        } while (f.exists());
        return filename;
    }

    private void adjustColumnWidth(GLRptTableHeadInfo head, Workbook wb, SpreadsheetWriter sw) throws IOException {
        int index = 0;
        for (int i = 0; i < head.getColumnSize(); ++i) {
            if (head.getTableColumnInfo(i).isHide()) continue;
            sw.defineCol((short)index, head.getTableColumnInfo(i).getWidth() / 6 + head.getTableColumnInfo(i).getWidth() % 6);
            ++index;
        }
    }

    protected RichTextString getRichTextString(String str) {
        return new XSSFRichTextString(str);
    }

    public class SpreadsheetWriter {
        private final Writer _out;
        private int _rownum;

        public SpreadsheetWriter(Writer out) {
            this._out = out;
        }

        public void beginWorkSheet() throws IOException {
            this._out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">\n");
        }

        public void beginCols() throws IOException {
            this._out.write("<cols>\n");
        }

        public void defineCol(int colnum, double width) throws IOException {
            this._out.write("<col min=\"" + (colnum + 1) + "\" max=\"" + (colnum + 1) + "\" width=\"" + width + "\"/>\n");
        }

        public void endCols() throws IOException {
            this._out.write("</cols>");
        }

        public void beginSheetData() throws IOException {
            this._out.write("<sheetData>\n");
        }

        public void endSheetData() throws IOException {
            this._out.write("</sheetData>");
        }

        public void beginMergeCells(int mergeCount) throws IOException {
            this._out.write("<mergeCells count=\"" + mergeCount + "\">\n");
        }

        public void endMergeCells() throws IOException {
            this._out.write("</mergeCells>");
        }

        public void endWorkSheet() throws IOException {
            this._out.write("</worksheet>");
        }

        public void insertRow(int rownum) throws IOException {
            this._out.write("<row r=\"" + (rownum + 1) + "\">\n");
            this._rownum = rownum;
        }

        public void insertRow(int rownum, double height) throws IOException {
            this._out.write("<row r=\"" + (rownum + 1) + "\" ht=\"" + height + "\" customHeight=\"true\">\n");
            this._rownum = rownum;
        }

        public void endRow() throws IOException {
            this._out.write("</row>\n");
        }

        public void flush() throws IOException {
            this._out.flush();
        }

        public void createCell(int columnIndex, String value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"inlineStr\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            if (value == null) {
                this._out.write("<v>" + null + "</v>");
            } else {
                this._out.write("<is><t>" + XMLEncoder.encode((String)value) + "</t></is>");
            }
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, String value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, double value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<v>" + value + "</v>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, double value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, Calendar value, int styleIndex) throws IOException {
            this.createCell(columnIndex, DateUtil.getExcelDate((Calendar)value, (boolean)false), styleIndex);
        }

        public String createMergeCell(int beginrownum, int endrownum, int beginColumn, int endColumn) {
            String refbegin = new CellReference(beginrownum, beginColumn).formatAsString();
            String refend = new CellReference(endrownum, endColumn).formatAsString();
            String mergeCell = "<mergeCell ref=\"" + refbegin + ":" + refend + "\"/>";
            return mergeCell;
        }
    }
}

