/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptPrintUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerPrintConfig;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class GLRptSubLedgerPrintAccountContents
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger(GLRptSubLedgerPrintAccountContents.class);
    private static final String ACCOUNT_TXT = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"101_RptAsstactGDTaodaAccount");
    private static final String ASST_TXT = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"100_RptAsstactGDTaodaAccount");
    private static final String MSG = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1086_pageCode");
    private static final String YEAR = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Year");
    private static final String PERIOD_COMMA = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"period_comma");
    private static final String INDEX = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"voucher_index");
    private static final String TO = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"to");
    private static final String PERIOD = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Period");
    private static final String[] col = new String[]{"sysDateNow", "company", "user", "FPeriodYear", "account", "pageCode", "period"};
    private GLRptRowSet rs;
    private boolean bBF = false;
    private boolean isPageByAsst = false;
    private CompanyOrgUnitInfo company;
    private String yearBegin = null;
    private String yearEnd = null;
    private String periodYearStart = null;
    private String periodYearEnd = null;
    private String periodNumberStart = null;
    private String periodNumberEnd = null;
    private boolean isShowAsst = false;
    private boolean acctAndasst = false;
    private boolean showDetailAsst = false;
    private boolean sumByAsst = false;

    public GLRptSubLedgerPrintAccountContents(GLRptSubLedgerCondition cond, GLRptRowSet rs, GLRptSubLedgerPrintConfig config) {
        this.rs = rs;
        this.bBF = config.isBF();
        this.company = cond.getCompany();
        this.isShowAsst = cond.isShowDisplayAsstDetail();
        this.isPageByAsst = config.isPageByAsst();
        this.acctAndasst = config.isChkAcctAndAsst();
        this.showDetailAsst = cond.isShowDisplayAsstDetail();
        this.sumByAsst = cond.isSumByAsstact();
        this.yearBegin = String.valueOf(cond.getPeriodYearStart());
        this.yearEnd = String.valueOf(cond.getPeriodYearEnd());
        this.periodYearStart = String.valueOf(cond.getPeriodYearStart());
        this.periodYearEnd = String.valueOf(cond.getPeriodYearEnd());
        this.periodNumberStart = String.valueOf(cond.getPeriodNumberStart());
        this.periodNumberEnd = String.valueOf(cond.getPeriodNumberEnd());
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        int rowLineCount = GLRptPrintUtil.substrToRowLineCount(ds);
        if (-1 != rowLineCount && (rs = this.getRowSet(rowLineCount, ds)) != null) {
            return rs;
        }
        for (int i = 4; i <= 50; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i, ds);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount, BOSQueryDataSource ds) {
        Object[] objDs = ds.getParams().toArray();
        String[] strCyc = new String[objDs.length];
        for (int i = 0; i < objDs.length; ++i) {
            strCyc[i] = ((DSParam)objDs[i]).getAssociateField();
        }
        if (objDs.length > 0) {
            rowLineCount = Integer.parseInt(strCyc[strCyc.length - 1]);
        }
        int colCount = col.length;
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            this.rs.beforeFirst();
            ArrayList<AccountItemInfo> data = new ArrayList<AccountItemInfo>();
            AsstItemInfo asstItem = null;
            AccountItemInfo account = null;
            boolean isFirst = true;
            boolean index = false;
            while (this.rs.next()) {
                String accountName = this.getAccount(this.rs);
                if (!this.acctAndasst && this.isPageByAsst && this.rs.getInt("FIsPeriodTotal") == 1) continue;
                if (account == null || !accountName.equals(account.getAccountName())) {
                    account = new AccountItemInfo();
                    account.setAccountName(accountName);
                    data.add(account);
                    if (asstItem != null) {
                        asstItem.setEndNum(account.getNum());
                    }
                    asstItem = null;
                    isFirst = true;
                }
                account.addNum();
                String asstItemName = this.getAsstItem(this.rs);
                if (asstItemName == null) continue;
                String asstItemId = this.rs.getString("FAssGrpId");
                if (asstItem == null || !asstItemId.equals(asstItem.getItemId())) {
                    if (asstItem != null) {
                        asstItem.setEndNum(account.getNum() - 1);
                    }
                    asstItem = new AsstItemInfo();
                    asstItem.setItemId(asstItemId);
                    asstItem.setItemName(asstItemName);
                    asstItem.setStartNum(account.getNum());
                    account.addAsstItemInfo(asstItem);
                }
                if (isFirst && this.acctAndasst) {
                    account.setTotalAccount(account.getNum() - 1);
                    isFirst = false;
                }
                asstItem.addNum();
            }
            int pages = 0;
            boolean accountNum = false;
            for (int k = 0; k < data.size(); ++k) {
                AsstItemInfo asstItemInfo;
                int i;
                List assts;
                String msgInfo;
                AccountItemInfo accountInfo = (AccountItemInfo)data.get(k);
                String acctMsg = ACCOUNT_TXT + accountInfo.getAccountName();
                int page = 0;
                if (this.acctAndasst && !accountInfo.getAsstItemInfos().isEmpty()) {
                    page = this.getPages(rowLineCount, accountInfo.getTotalAccount() != 0 ? accountInfo.getTotalAccount() : accountInfo.getNum());
                    msgInfo = MessageFormat.format(MSG, page == 1 ? " " + Integer.toString(pages + 1) : Integer.toString(pages + 1) + " - " + Integer.toString(pages + page));
                    this.setValue(drs, rowLineCount, acctMsg, msgInfo);
                    pages += page;
                } else {
                    if (this.isPageByAsst && !accountInfo.getAsstItemInfos().isEmpty()) {
                        assts = accountInfo.getAsstItemInfos();
                        for (i = 0; i < assts.size(); ++i) {
                            asstItemInfo = (AsstItemInfo)assts.get(i);
                            page += this.getPages(rowLineCount, asstItemInfo.getNum());
                        }
                    } else {
                        page = this.getPages(rowLineCount, accountInfo.getNum());
                    }
                    msgInfo = MessageFormat.format(MSG, page == 1 ? " " + Integer.toString(pages + 1) : Integer.toString(pages + 1) + " - " + Integer.toString(pages + page));
                    this.setValue(drs, rowLineCount, acctMsg, msgInfo);
                }
                if (this.isPageByAsst && !accountInfo.getAsstItemInfos().isEmpty()) {
                    assts = accountInfo.getAsstItemInfos();
                    for (i = 0; i < assts.size(); ++i) {
                        asstItemInfo = (AsstItemInfo)assts.get(i);
                        String msg = ASST_TXT + asstItemInfo.getItemName();
                        page = this.getPages(rowLineCount, asstItemInfo.getNum());
                        String msgInfo2 = MessageFormat.format(MSG, page == 1 ? " " + Integer.toString(pages + 1) : Integer.toString(pages + 1) + " - " + Integer.toString(pages + page));
                        this.setValue(drs, rowLineCount, msg, msgInfo2);
                        pages += page;
                    }
                    continue;
                }
                if (!(!this.acctAndasst && this.showDetailAsst || accountInfo.getAsstItemInfos().isEmpty())) {
                    assts = accountInfo.getAsstItemInfos();
                    int page1 = 0;
                    int page2 = 0;
                    int acctNum = 0;
                    if (this.acctAndasst) {
                        acctNum = accountInfo.getTotalAccount();
                    }
                    for (int i2 = 0; i2 < assts.size(); ++i2) {
                        AsstItemInfo asstItemInfo2 = (AsstItemInfo)assts.get(i2);
                        String msg = ASST_TXT + asstItemInfo2.getItemName();
                        page1 = this.getPages(rowLineCount, asstItemInfo2.getStartNum() - acctNum);
                        page2 = i2 == assts.size() - 1 ? this.getPages(rowLineCount, accountInfo.getNum() - acctNum) : this.getPages(rowLineCount, asstItemInfo2.getEndNum() - acctNum);
                        String msgInfo3 = MessageFormat.format(MSG, page1 == page2 ? " " + Integer.toString(pages + page1) : Integer.toString(pages + page1) + " - " + Integer.toString(pages + page2));
                        this.setValue(drs, rowLineCount, msg, msgInfo3);
                    }
                    pages += page2;
                    continue;
                }
                pages += page;
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return drs;
    }

    private void setValue(DynamicRowSet drs, int rowLineCount, String msg, String msgInfo) throws SQLException {
        drs.moveToInsertRow();
        String yearStr = "";
        if (this.yearBegin != null && this.yearEnd != null) {
            yearStr = this.yearBegin.equals(this.yearEnd) ? this.yearBegin : this.yearBegin + " - " + this.yearEnd;
        }
        String periodStr = "";
        if (this.periodYearStart != null && this.periodYearEnd != null && this.periodNumberStart != null && this.periodNumberEnd != null) {
            periodStr = this.periodYearStart.equals(this.periodYearEnd) && this.periodNumberStart.equals(this.periodNumberEnd) ? PERIOD_COMMA + this.periodYearStart + YEAR + INDEX + this.periodNumberStart + PERIOD : (this.periodYearStart.equals(this.periodYearEnd) ? PERIOD_COMMA + this.periodYearStart + YEAR + INDEX + this.periodNumberStart + PERIOD + TO + INDEX + this.periodNumberEnd + PERIOD : PERIOD_COMMA + this.periodYearStart + YEAR + INDEX + this.periodNumberStart + PERIOD + TO + this.periodYearEnd + YEAR + INDEX + this.periodNumberEnd + PERIOD);
        }
        drs.updateString("FPeriodYear", yearStr);
        drs.updateString("period", periodStr);
        drs.updateString("sysDateNow", GlUtils.formatDate(GlUtils.getDateFormat(), new Date()));
        drs.updateString("user", SysContext.getSysContext().getCurrentUserInfo().getName());
        drs.updateString("company", this.company.getName());
        drs.updateString("account", msg);
        drs.updateString("pageCode", msgInfo);
        drs.insertRow();
    }

    private int getPages(int rowLineCount, int num) {
        int pageBal;
        int page = this.bBF ? (num - 2) / (rowLineCount - 2) : num / rowLineCount;
        int n = pageBal = this.bBF ? (num - 2) % (rowLineCount - 2) : num % rowLineCount;
        if (pageBal != 0) {
            ++page;
        } else if (this.bBF && num - 2 == 0) {
            ++page;
        }
        return page;
    }

    private String getAsstItem(GLRptRowSet rs) throws BOSException, SQLException {
        if (!this.acctAndasst && !this.isPageByAsst || rs.getString("FAssGrpId") == null || StringUtils.isEmpty((String)rs.getString("FAssGrpId"))) {
            return null;
        }
        StringBuffer asstItemName = new StringBuffer();
        String[] keys = rs.getColumKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].startsWith("FAsstAccountName") || rs.getString(keys[i]) == null) continue;
            if (asstItemName.length() > 0) {
                asstItemName.append(";");
            }
            asstItemName.append(rs.getString(keys[i]));
        }
        return asstItemName.length() == 0 ? null : asstItemName.toString();
    }

    private String getAccount(GLRptRowSet rs) throws BOSException, SQLException {
        String accNumber = rs.getString("accountNumber");
        String accName = rs.getString("accountName");
        return (accNumber == null ? "" : accNumber) + " " + (accName == null ? "" : accName);
    }

    class AccountItemInfo {
        String accountName;
        int num = 0;
        int totalAccount = 0;
        List asstItemInfos = new ArrayList();

        AccountItemInfo() {
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public int getNum() {
            return this.num;
        }

        public void addNum() {
            ++this.num;
        }

        public void setTotalAccount(int totalAccount) {
            this.totalAccount = totalAccount;
        }

        public int getTotalAccount() {
            return this.totalAccount;
        }

        public List getAsstItemInfos() {
            return this.asstItemInfos;
        }

        public void addAsstItemInfo(AsstItemInfo asstItemInfo) {
            this.asstItemInfos.add(asstItemInfo);
        }

        public boolean equals(Object item) {
            if (item instanceof AccountItemInfo && item != null && ((AccountItemInfo)item).getAccountName() != null) {
                return ((AccountItemInfo)item).getAccountName().equals(this.getAccountName());
            }
            return false;
        }
    }

    class AsstItemInfo {
        String itemName;
        String itemId;
        int num = 0;
        int startNum = 0;
        int endNum = 0;

        AsstItemInfo() {
        }

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getItemId() {
            return this.itemId;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public int getNum() {
            return this.num;
        }

        public void addNum() {
            ++this.num;
        }

        public int getStartNum() {
            return this.startNum;
        }

        public void setStartNum(int startNum) {
            this.startNum = startNum;
        }

        public int getEndNum() {
            return this.endNum;
        }

        public void setEndNum(int endNum) {
            this.endNum = endNum;
        }
    }
}

