/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptPrintUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptPrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerPrintConfig;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class GLRptSubLedgerPrintDelegate
extends AbstractGLRptPrintDelegate {
    private String strOverHypoPage = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.overHypoPage");
    private String strBearForwardPage = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.bearForwardPage");
    private String allCurrency = GLResUtil.getRes("all_currency");
    private static final String[][] col = new String[][]{{"sysDateNow", ""}, {"userName", ""}, {"creator", ""}, {"companyName", ""}, {"period", ""}, {"currency", ""}, {"FDateYear", ""}, {"FDateMonth", ""}, {"FDateDay", ""}, {"FAsstAccountNameGroup", ""}, {"topKeMu", ""}, {"FAsstAccountName0Title", ""}, {"FAsstAccountName1Title", ""}, {"FAsstAccountName2Title", ""}, {"FAsstAccountName3Title", ""}, {"FAsstAccountName4Title", ""}, {"FAsstAccountName5Title", ""}, {"FAsstAccountName6Title", ""}, {"FAsstAccountName7Title", ""}, {"FAsstAccountNameGroupTitle", ""}, {"FPeriodYear", ""}, {"FPeriodNumber", ""}, {"FaccountName", "accountName"}, {"FAsstAccountName0", "FAsstAccountName0"}, {"FAsstAccountName1", "FAsstAccountName1"}, {"FAsstAccountName2", "FAsstAccountName2"}, {"FAsstAccountName3", "FAsstAccountName3"}, {"FAsstAccountName4", "FAsstAccountName4"}, {"FAsstAccountName5", "FAsstAccountName5"}, {"FAsstAccountName6", "FAsstAccountName6"}, {"FAsstAccountName7", "FAsstAccountName7"}, {"FDC", "accountDC"}, {"FDate", "FBookedDate"}, {"FVoucherNumber", "voucherNumber"}, {"FBizDate", "FBizdate"}, {"FPeriodYearNumber", "FPeriod"}, {"accountName", "oppAccountName"}, {"FDescription", "FDescription"}, {"FBaseRate", "FLocalExchangeRate"}, {"FRptRate", "FReportingExchangeRate"}, {"FDebitUnit", "debitMeasureUnitName"}, {"FDebitQuantity", "FSubDebitQty"}, {"FDebitPrice", "FDebitPrice"}, {"FDebitFor", "FSubDebitFor"}, {"FDebitLocal", "FSubDebitLocal"}, {"FDebitRpt", "FSubDebitRpt"}, {"FCreditUnit", "creditMeasureUnitName"}, {"FCreditQuantity", "FSubCreditQty"}, {"FCreditPrice", "FCreditPrice"}, {"FCreditFor", "FSubCreditFor"}, {"FCreditLocal", "FSubCreditLocal"}, {"FCreditRpt", "FSubCreditRpt"}, {"FBalanceUnit", "endMeasureUnitName"}, {"FBalanceQuantity", "FEndQty"}, {"FBalancePrice", "FEndPrice"}, {"FBalanceFor", "FEndBalanceFor"}, {"FBalanceLocal", "FEndBalanceLocal"}, {"FBalanceRpt", "FEndBalanceRpt"}, {"FCurrencyName", "currencyName"}, {"FBizNumber", "FBizNumber"}, {"FInvoiceNumber", "FInvoiceNumber"}, {"FSettlementCode", "FSettlementCode"}, {"FSettlementType", "settleTypeName"}, {"FTicketNumber", "FTicketNumber"}, {"FFeeType", ""}, {"FHandler", ""}};
    protected Map mapParame = null;
    protected GLRptRowSet rs = null;
    private GLRptSubLedgerPrintConfig config;
    private boolean isShowDisplayAsstDetail = false;
    private CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();

    public GLRptSubLedgerPrintDelegate(GLRptRowSet rs, Map mapParame, GLRptBasePrintConfig config, boolean isShowDisplayAsstDetail) {
        this.rs = rs;
        this.mapParame = mapParame;
        if (mapParame.get("company") != null && mapParame.get("company") instanceof CompanyOrgUnitInfo) {
            this.curCompany = (CompanyOrgUnitInfo)mapParame.get("company");
        }
        this.config = (GLRptSubLedgerPrintConfig)config;
        this.isShowDisplayAsstDetail = isShowDisplayAsstDetail;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        int rowLineCount = GLRptPrintUtil.substrToRowLineCount(ds);
        if (-1 != rowLineCount && (rs = this.getRowSet(rowLineCount)) != null) {
            return rs;
        }
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount) {
        DateFormat format = GlUtils.getDateFormat();
        int colCount = col.length;
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = col[i][0];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            CurrencyInfo baseCurrency = this.curCompany.getBaseCurrency();
            baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            CurrencyInfo rptCurrency = this.curCompany.getReportCurrency();
            if (rptCurrency != null) {
                rptCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(rptCurrency.getId()));
            }
            String currencyId = (String)this.mapParame.get("currencyId");
            CurrencyInfo currency = null;
            String currencyName = null;
            String accountTableId = (String)this.mapParame.get("accountTableId");
            CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)this.mapParame.get("company");
            AccountViewCollection accounts = (AccountViewCollection)this.mapParame.get("account");
            Map topKeMuMap = (Map)this.mapParame.get("topKeMuMap");
            if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                currency = baseCurrency;
                currencyName = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"GENERALLOCAL");
            } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                currency = rptCurrency;
                currencyName = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"GENERALREPORT");
            } else if (!currencyId.equalsIgnoreCase("AllCurrency")) {
                currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                currencyName = currency.getName();
            }
            boolean isBaseCurrency = currency != null && baseCurrency.getId().equals((Object)currency.getId());
            boolean isGBaseCy = currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC");
            boolean isGRptCy = currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC");
            int rowCount = 0;
            this.rs.beforeFirst();
            String lastItemID = null;
            String lastAssGrpID = null;
            while (this.rs.next()) {
                int baseq;
                String itemID = this.rs.getString("FAccountID");
                String assGrpID = null;
                if (!this.config.isChkAcctAndAsst() && this.config.isPageByAsst() && this.rs.getInt("FIsPeriodTotal") == 1) continue;
                if (this.config.isPageByAsst()) {
                    itemID = itemID + this.getAsstItem(this.rs);
                }
                if (this.config.isChkAcctAndAsst()) {
                    assGrpID = this.rs.getString("FAssGrpId");
                    if (lastAssGrpID == null && assGrpID != null) {
                        while (rowCount % rowLineCount != 0) {
                            drs.moveToInsertRow();
                            this.clearRowNew((IRowSet)drs);
                            drs.insertRow();
                            ++rowCount;
                        }
                        lastAssGrpID = assGrpID;
                    } else {
                        lastAssGrpID = assGrpID;
                    }
                }
                if (lastItemID != null && !itemID.equals(lastItemID)) {
                    while (rowCount % rowLineCount != 0) {
                        drs.moveToInsertRow();
                        this.clearRowNew((IRowSet)drs);
                        drs.insertRow();
                        ++rowCount;
                    }
                    lastItemID = itemID;
                } else {
                    lastItemID = itemID;
                }
                drs.moveToInsertRow();
                this.clearRow((IRowSet)drs);
                ++rowCount;
                drs.updateString("sysDateNow", GlUtils.formatDate(format, new Date()));
                drs.updateString("userName", SysContext.getSysContext().getCurrentUserInfo().getName());
                drs.updateString("companyName", curCompany.toString());
                drs.updateString("creator", this.rs.getString("FCreatorName"));
                drs.updateObject("period", this.mapParame.get("Period"));
                drs.updateObject("currency", (Object)(currency == null ? this.allCurrency : currencyName));
                drs.updateObject("topKeMu", topKeMuMap.get(this.rs.getString("FAccountID")));
                int precision = 0;
                if (currency == null) {
                    Object currencyPre = this.rs.getObject("currencyPre");
                    if (currencyPre != null) {
                        precision = Integer.parseInt(currencyPre.toString());
                    }
                } else {
                    precision = currency.getPrecision();
                }
                int colNum = col.length - 1;
                boolean fDateYear = false;
                for (int i = 22; i < colNum; ++i) {
                    String period;
                    Object value;
                    if (this.rs.indexOf(col[i][1]) == -1 || (value = this.rs.getObject(col[i][1])) == null) continue;
                    if (value instanceof BigDecimal) {
                        BigDecimal val = (BigDecimal)value;
                        if (val.doubleValue() == 0.0) {
                            drs.updateString(col[i][0], "");
                        } else if (col[i][1].endsWith("Local")) {
                            drs.updateString(col[i][0], GlUtils.withComma(val, baseCurrency.getPrecision()));
                            if (isGBaseCy) {
                                drs.updateString(col[i][0].substring(0, col[i][0].length() - 5) + "For", GlUtils.withComma(val, baseCurrency.getPrecision()));
                            }
                        } else if (col[i][1].endsWith("Rpt")) {
                            drs.updateString(col[i][0], GlUtils.withComma(val, rptCurrency.getPrecision()));
                            if (isGRptCy) {
                                drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "For", GlUtils.withComma(val, rptCurrency.getPrecision()));
                            }
                        } else if (col[i][1].endsWith("For")) {
                            drs.updateString(col[i][0], GlUtils.withComma(val, precision));
                            if (isBaseCurrency) {
                                drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "Local", GlUtils.withComma(val, precision));
                            }
                        } else if (col[i][1].equals("FLocalExchangeRate")) {
                            drs.updateString(col[i][0], GlUtils.withComma(val, this.rs.getInt("FLocalExRatePre")));
                        } else if (col[i][1].equals("FReportingExchangeRate")) {
                            drs.updateString(col[i][0], GlUtils.withComma(val, this.rs.getInt("FRptExRatePre")));
                        } else if (col[i][1].endsWith("Qty")) {
                            drs.updateString(col[i][0], GlUtils.withComma(val, (Integer)this.mapParame.get("qtyScale")));
                        } else if (col[i][1].endsWith("Price")) {
                            drs.updateString(col[i][0], GlUtils.withComma(val, (Integer)this.mapParame.get("priceScale")));
                        } else {
                            drs.updateString(col[i][0], val.toString());
                        }
                    } else if ("accountName".equals(col[i][1])) {
                        String accountNumber = (String)this.rs.getObject("accountNumber");
                        if (accountNumber != null && accountNumber.trim().length() > 0) {
                            drs.updateString(col[i][0], accountNumber + " " + value.toString());
                        } else {
                            drs.updateString(col[i][0], value.toString());
                        }
                    } else {
                        drs.updateString(col[i][0], value.toString());
                    }
                    if (col[i][1].equalsIgnoreCase("FBookedDate")) {
                        String[] sDate = value.toString().split("\\-");
                        drs.updateString("FDateYear", sDate[0]);
                        drs.updateString("FDateMonth", sDate[1]);
                        drs.updateString("FDateDay", sDate[2]);
                        fDateYear = true;
                    }
                    if (!col[i][1].equalsIgnoreCase("FPeriod") || (period = this.rs.getString("FPeriod")) == null) continue;
                    String[] p = period.split("\\.");
                    drs.updateString("FPeriodYear", p[0]);
                    drs.updateString("FPeriodNumber", p[1]);
                }
                if (!fDateYear) {
                    String period = (String)this.mapParame.get("Period");
                    int start = period.indexOf(":");
                    drs.updateString("FDateYear", period.substring(period.indexOf(":") + 1, start + 5));
                    try {
                        Integer.parseInt(period.substring(period.indexOf(":") + 7, start + 9));
                        drs.updateString("FDateMonth", period.substring(period.indexOf(":") + 7, start + 9));
                    }
                    catch (Exception e) {
                        drs.updateString("FDateMonth", "0" + period.substring(period.indexOf(":") + 7, start + 8));
                    }
                }
                if ((baseq = this.rs.getInt("FBalSeq")) == 1) {
                    drs.updateString("FDateDay", "");
                }
                drs.updateString("FAsstAccountNameGroup", this.getAsstGroupName(this.rs));
                if ((this.config.isPageByAsst() || this.config.isChkAcctAndAsst()) && this.rs.getString("FAssGrpId") != null) {
                    this.updateAssTitle(drs);
                }
                drs.insertRow();
                if (!this.config.isBF()) continue;
                int currIndex = this.rs.getCurrRowIndex();
                if ((rowCount + 1) % rowLineCount == 0 && this.rs.next() && this.rs.next()) {
                    String itID = this.rs.getString("FAccountID");
                    if (this.config.isPageByAsst()) {
                        itID = itID + this.getAsstItem(this.rs);
                    }
                    if ((!this.config.isChkAcctAndAsst() || StringUtils.equals((String)lastAssGrpID, (String)this.rs.getString("FAssGrpId"))) && StringUtils.equals((String)itID, (String)lastItemID)) {
                        drs.moveToInsertRow();
                        this.clearValue(drs);
                        drs.updateString("FDescription", this.strOverHypoPage);
                        String debitFor = this.config.isSumPeriod() ? "FDebitFor" : "FYearDebitFor";
                        String debitLocal = this.config.isSumPeriod() ? "FDebitLocal" : "FYearDebitLocal";
                        String debitRpt = this.config.isSumPeriod() ? "FDebitRpt" : "FYearDebitRpt";
                        String creditFor = this.config.isSumPeriod() ? "FCreditFor" : "FYearCreditFor";
                        String creditLocal = this.config.isSumPeriod() ? "FCreditLocal" : "FYearCreditLocal";
                        String creditRpt = this.config.isSumPeriod() ? "FCreditRpt" : "FYearCreditRpt";
                        String debitQty = this.config.isSumPeriod() ? "FDebitQty" : "FYearDebitQty";
                        String creditQty = this.config.isSumPeriod() ? "FCreditQty" : "FYearCreditQty";
                        String endMeasureUnitName = "endMeasureUnitName";
                        if (this.rs.indexOf(debitFor) != -1) {
                            drs.updateString("FDebitFor", this.getFormatedValue(this.rs.getBigDecimal(currIndex, debitFor), precision));
                            if (isBaseCurrency) {
                                drs.updateString("FDebitLocal", this.getFormatedValue(this.rs.getBigDecimal(currIndex, debitFor), baseCurrency.getPrecision()));
                            }
                        }
                        if (this.rs.indexOf(debitLocal) != -1) {
                            drs.updateString("FDebitLocal", this.getFormatedValue(this.rs.getBigDecimal(currIndex, debitLocal), baseCurrency.getPrecision()));
                        }
                        if (this.rs.indexOf(debitRpt) != -1) {
                            drs.updateString("FDebitRpt", this.getFormatedValue(this.rs.getBigDecimal(currIndex, debitRpt), rptCurrency.getPrecision()));
                        }
                        if (this.rs.indexOf(creditFor) != -1) {
                            drs.updateString("FCreditFor", this.getFormatedValue(this.rs.getBigDecimal(currIndex, creditFor), precision));
                            if (isBaseCurrency) {
                                drs.updateString("FCreditLocal", this.getFormatedValue(this.rs.getBigDecimal(currIndex, creditFor), baseCurrency.getPrecision()));
                            }
                        }
                        if (this.rs.indexOf(creditLocal) != -1) {
                            drs.updateString("FCreditLocal", this.getFormatedValue(this.rs.getBigDecimal(currIndex, creditLocal), baseCurrency.getPrecision()));
                        }
                        if (this.rs.indexOf(creditRpt) != -1) {
                            drs.updateString("FCreditRpt", this.getFormatedValue(this.rs.getBigDecimal(currIndex, creditRpt), rptCurrency.getPrecision()));
                        }
                        if (this.rs.indexOf(debitQty) != -1) {
                            drs.updateString("FDebitQuantity", this.getFormatedValue(this.rs.getBigDecimal(currIndex, debitQty), (Integer)this.mapParame.get("qtyScale")));
                        }
                        if (this.rs.indexOf(creditQty) != -1) {
                            drs.updateString("FCreditQuantity", this.getFormatedValue(this.rs.getBigDecimal(currIndex, creditQty), (Integer)this.mapParame.get("qtyScale")));
                        }
                        if (this.rs.indexOf(endMeasureUnitName) != -1) {
                            drs.updateString("FBalanceUnit", this.rs.getString(currIndex, endMeasureUnitName));
                            drs.updateString("FDebitUnit", this.rs.getString(currIndex, endMeasureUnitName));
                            drs.updateString("FCreditUnit", this.rs.getString(currIndex, endMeasureUnitName));
                        }
                        drs.updateString("accountName", "");
                        drs.insertRow();
                        ++rowCount;
                        drs.moveToInsertRow();
                        this.clearValue(drs);
                        drs.updateString("FDescription", this.strBearForwardPage);
                        ++rowCount;
                        drs.insertRow();
                    }
                }
                this.rs.absolute(currIndex);
            }
            drs.beforeFirst();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            e.printStackTrace();
            SysUtil.abort();
        }
        return drs;
    }

    private String getFormatedValue(BigDecimal value, int scale) {
        if (value == null) {
            value = GlUtils.zero;
        }
        return GlUtils.withComma(value, scale);
    }

    private String getAsstGroupName(GLRptRowSet rs) throws BOSException, SQLException {
        StringBuffer asstGroupName = new StringBuffer();
        try {
            for (int i = 0; i < 8; ++i) {
                if (rs.indexOf("FAsstAccountName" + i) == -1) continue;
                String asstName = rs.getString("FAsstAccountName" + i);
                if (i > 0 && asstName != null) {
                    asstGroupName.append(";");
                }
                if (asstName == null) continue;
                asstGroupName.append(asstName);
            }
        }
        catch (Exception e) {
            asstGroupName = new StringBuffer();
        }
        return asstGroupName.toString();
    }

    private void updateAssTitle(DynamicRowSet drs) throws BOSException, SQLException {
        String assGroupName = drs.getString("FAsstAccountNameGroup");
        for (int i = 0; i < 8; ++i) {
            drs.updateString("FAsstAccountName" + i + "Title", drs.getString("FAsstAccountName" + i));
        }
        drs.updateString("FAsstAccountNameGroupTitle", assGroupName);
    }

    private void clearValue(DynamicRowSet drs) throws SQLException {
        drs.updateString("FDateDay", "");
        drs.updateString("FDate", "");
        drs.updateString("FVoucherNumber", "");
        drs.updateString("FCurrencyName", "");
        drs.updateString("FBaseRate", "");
        drs.updateString("FRptRate", "");
        drs.updateString("FDebitUnit", "");
        drs.updateString("FCreditUnit", "");
        drs.updateString("FBalanceUnit", "");
        drs.updateString("FBizNumber", "");
        drs.updateString("FInvoiceNumber", "");
        drs.updateString("FSettlementCode", "");
        drs.updateString("FSettlementType", "");
        drs.updateString("FTicketNumber", "");
        drs.updateString("FDebitPrice", "");
        drs.updateString("FCreditPrice", "");
    }

    private String getAsstItem(GLRptRowSet rs) throws BOSException, SQLException {
        return this.config.isChkAcctAndAsst() || this.config.isPageByAsst() ? rs.getString("FAssGrpId") : null;
    }

    private void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private void clearRowNew(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        String colName = "";
        for (int i = 1; i <= colCount; ++i) {
            colName = rs.getRowSetMetaData().getColumnName(i);
            if ("userName".equals(colName) || "companyName".equals(colName) || "sysDateNow".equals(colName)) continue;
            rs.updateString(i, null);
        }
    }

    private Map getTopKeMu(AccountViewCollection accountColl, String accountTableId, String companyId) throws BOSException {
        HashMap<String, String> topKeMuMap = new HashMap<String, String>();
        HashMap<String, String> cacheMap = new HashMap<String, String>();
        int size = accountColl.size();
        for (int i = 0; i < size; ++i) {
            AccountViewInfo account = accountColl.get(i);
            String longNumStr = account.getLongNumber().split("!")[0];
            if (!cacheMap.containsKey(longNumStr)) {
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("id"));
                view.getSelector().add(new SelectorItemInfo("name"));
                view.getSelector().add(new SelectorItemInfo("number"));
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId, CompareType.EQUALS));
                fi.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId, CompareType.EQUALS));
                fi.getFilterItems().add(new FilterItemInfo("level", (Object)1, CompareType.EQUALS));
                fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)account.getLongNumber().split("!")[0], CompareType.EQUALS));
                view.setFilter(fi);
                AccountViewCollection accollect = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
                if (accollect == null || accollect.size() <= 0) continue;
                topKeMuMap.put(account.getId().toString(), accollect.get(0).getNumber() + " " + accollect.get(0).getName());
                cacheMap.put(longNumStr, accollect.get(0).getNumber() + " " + accollect.get(0).getName());
                continue;
            }
            topKeMuMap.put(account.getId().toString(), (String)cacheMap.get(longNumStr));
        }
        return topKeMuMap;
    }
}

