/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ParamEx;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptSubLedgerQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptSubLedgerQueryUI
extends AbstractGLRptSubLedgerQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(GLRptSubLedgerQueryUI.class);
    private boolean isQtyAsst = false;
    private int asstCount;
    public static final String RES = "com.kingdee.eas.fi.gl.GLAutoGenerateResource";

    @Override
    public void onLoad() throws Exception {
        GLRptSubLedgerUI parentUI;
        Map parentUICtx;
        super.onLoad();
        this.isQtyAsst = this.getCustomCondition().getRptParams().isQtyAsst();
        this.asstCount = 0;
        this.prbMeasureUnit.setEditFormat("$number$");
        this.prbMeasureUnit.setDisplayFormat("$number$ - $name$");
        this.prbMeasureUnit.setCommitFormat("$number$;$name$");
        this.prbMeasureUnit.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherMeasureUnitQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("coefficient"));
        sic.add(new SelectorItemInfo("isDisabled"));
        sic.add(new SelectorItemInfo("measureUnitGroup.id"));
        this.prbMeasureUnit.setSelectorCollection(sic);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterMU = new FilterInfo();
        view.setFilter(filterMU);
        filterMU.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)0));
        this.prbMeasureUnit.setEntityViewInfo(view);
        if (!SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit()) {
            this.lblDisplayMode.setEnabled(false);
        }
        if ((parentUICtx = (parentUI = (GLRptSubLedgerUI)this.getUIContext().get("Owner")).getUIContext()).get("JoinQuery") != null) {
            AccountViewCollection acColl;
            this.getUIContext().put("JoinQuery", parentUICtx.get("JoinQuery"));
            GLRptBaseCondition condition = (GLRptBaseCondition)parentUICtx.get("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS");
            String accountAtr = condition.getAccountCodeStart();
            String accountTableId = condition.getAccountTableId();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountAtr));
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)this.getCurrCompany().getId().toString()));
            if (accountTableId != null) {
                filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableId));
            }
            if ((acColl = AccountViewFactory.getRemoteInstance().getAccountViewCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null))) != null && acColl.size() > 0) {
                condition.setAccountViewStart(acColl.get(0));
                condition.setAccountViewEnd(acColl.get(0));
            }
            this.setCustomCondition(condition);
        }
    }

    @Override
    protected CompanyDisplayModeEnum getDefaultUnionCompanyShowMode() {
        return CompanyDisplayModeEnum.details;
    }

    @Override
    protected boolean canDetailDisplay() {
        return true;
    }

    @Override
    protected void initAcctTable() throws EASBizException, BOSException {
        super.initAcctTable();
        this.tbl.getColumn("maxLevel").getStyleAttributes().setHided(true);
        this.tbl.getColumn("collect").getStyleAttributes().setHided(true);
        this.tbl.getColumn("from").setWidth(110);
        this.tbl.getColumn("to").setWidth(110);
        this.setAsstEnable(false);
    }

    @Override
    protected boolean canMergeDisplay() {
        return false;
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.chkDisplayAsstDetail.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.getStateChange() == 1;
                GLRptSubLedgerQueryUI.this.setAsstEnable(isSelected);
                if (!isSelected) {
                    GLRptSubLedgerQueryUI.this.asstCount = 0;
                    GLRptSubLedgerQueryUI.this.setMeasureUnitEable();
                }
            }
        });
        this.chkOpOtherAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    GLRptSubLedgerQueryUI.this.chkOpOtherAsstact.setSelected(false);
                }
            }
        });
        this.chkOpOtherAsstact.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GLRptSubLedgerQueryUI.this.chkOpOtherAccount.setSelected(true);
                }
            }
        });
        this.tbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 0 && GLRptSubLedgerQueryUI.this.isQtyAsst) {
                    if (((Boolean)e.getValue()).booleanValue()) {
                        GLRptSubLedgerQueryUI.this.asstCount++;
                        GLRptSubLedgerQueryUI.this.prbMeasureUnit.setEnabled(true);
                        GLRptSubLedgerQueryUI.this.jcbSumByMeasureUnit.setEnabled(GLRptSubLedgerQueryUI.this.prbMeasureUnit.getValue() == null);
                    } else {
                        GLRptSubLedgerQueryUI.this.asstCount--;
                        GLRptSubLedgerQueryUI.this.setMeasureUnitEable();
                    }
                }
            }
        });
        this.prbMeasureUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() != null) {
                    GLRptSubLedgerQueryUI.this.jcbSumByMeasureUnit.setSelected(true);
                }
                if (GLRptSubLedgerQueryUI.this.chkDisplayAsstDetail.isSelected()) {
                    GLRptSubLedgerQueryUI.this.jcbSumByMeasureUnit.setEnabled(e.getNewValue() == null && GLRptSubLedgerQueryUI.this.asstCount > 0);
                }
            }
        });
        this.chkOpAmountZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GLRptSubLedgerQueryUI.this.chkAmountAndBalZero.setSelected(false);
                    GLRptSubLedgerQueryUI.this.chkNoAmountShow.setSelected(false);
                }
            }
        });
        this.chkAmountAndBalZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GLRptSubLedgerQueryUI.this.chkOpAmountZero.setSelected(false);
                    GLRptSubLedgerQueryUI.this.chkNoAmountShow.setSelected(false);
                }
            }
        });
        this.chkNoAmountShow.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GLRptSubLedgerQueryUI.this.chkOpAmountZero.setSelected(false);
                    GLRptSubLedgerQueryUI.this.chkAmountAndBalZero.setSelected(false);
                }
            }
        });
        this.cmbCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (GLResUtil.getRes("all_currency").equals(e.getItem())) {
                        GLRptSubLedgerQueryUI.this.chkNoAmountShow.setEnabled(false);
                        GLRptSubLedgerQueryUI.this.chkNoAmountShow.setSelected(false);
                    } else {
                        GLRptSubLedgerQueryUI.this.chkNoAmountShow.setEnabled(true);
                    }
                }
            }
        });
    }

    private void setMeasureUnitEable() {
        if (!this.isQtyAsst) {
            return;
        }
        boolean hasAsstact = this.asstCount > 0;
        this.prbMeasureUnit.setEnabled(hasAsstact);
        this.jcbSumByMeasureUnit.setEnabled(hasAsstact && this.prbMeasureUnit.getValue() == null);
        if (!hasAsstact) {
            this.prbMeasureUnit.setValue(null);
            this.jcbSumByMeasureUnit.setSelected(false);
        }
    }

    private void setAsstEnable(boolean enabled) {
        this.chkFilterByCat.setEnabled(enabled);
        this.chkSumbyAsstact.setEnabled(enabled);
        if (!enabled) {
            this.chkFilterByCat.setSelected(false);
            this.chkSumbyAsstact.setSelected(false);
            for (int i = 0; i < this.tbl.getRowCount(); ++i) {
                this.tbl.getRow(i).getCell("selected").setValue((Object)Boolean.FALSE);
                this.tbl.getRow(i).getCell("from").getStyleAttributes().setLocked(true);
                this.tbl.getRow(i).getCell("to").getStyleAttributes().setLocked(true);
                this.tbl.getRow(i).getCell("dist").getStyleAttributes().setLocked(true);
            }
        }
        this.tbl.getColumn("selected").getStyleAttributes().setLocked(!enabled);
        this.tbl.getColumn("asstact").getStyleAttributes().setLocked(!enabled);
        this.tbl.getColumn("selected").getStyleAttributes().setBackground(enabled ? Color.WHITE : LOCKCOLOR);
        this.tbl.getColumn("asstact").getStyleAttributes().setBackground(enabled ? Color.WHITE : LOCKCOLOR);
        this.tbl.getColumn("from").getStyleAttributes().setBackground(enabled ? Color.WHITE : LOCKCOLOR);
        this.tbl.getColumn("to").getStyleAttributes().setBackground(enabled ? Color.WHITE : LOCKCOLOR);
        this.tbl.getColumn("dist").getStyleAttributes().setBackground(enabled ? Color.WHITE : LOCKCOLOR);
    }

    @Override
    protected void setAccountF7Filter(IRow row, boolean selected) {
    }

    @Override
    protected FilterInfo getAccountFilter() {
        return new FilterInfo();
    }

    @Override
    public GLRptBaseCondition getCustomCondition() {
        GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)super.getCustomCondition();
        MeasureUnitInfo measureUnit = (MeasureUnitInfo)this.prbMeasureUnit.getValue();
        cond.setMeasureUnitId(measureUnit == null ? null : measureUnit.getId().toString());
        cond.setShowOppAccount(this.chkOpOtherAccount.isSelected());
        cond.setShowOppAsstact(this.chkOpOtherAsstact.isSelected());
        cond.setShowDailyTotal(this.chkOpDailyTotal.isSelected());
        cond.setShowAccountAttribute(this.chkOpAccountCusAttribute.isSelected());
        cond.setShowDisplayAsstDetail(this.chkDisplayAsstDetail.isSelected());
        cond.setNoDisplayZeroTotal(this.jcbNoDisplayZeroTotal.isSelected());
        cond.setSumByAsstact(this.chkSumbyAsstact.isSelected());
        cond.setGroupByMU(this.jcbSumByMeasureUnit.isSelected());
        cond.setNoAmountShow(this.chkNoAmountShow.isSelected());
        return cond;
    }

    @Override
    public void setCustomCondition(GLRptBaseCondition condition) throws EASBizException, BOSException {
        boolean hasAsstAct;
        super.setCustomCondition(condition);
        GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)condition;
        this.chkOpOtherAccount.setSelected(cond.isShowOppAccount());
        this.chkOpOtherAsstact.setSelected(cond.isShowOppAsstact());
        this.chkOpDailyTotal.setSelected(cond.isShowDailyTotal());
        this.chkOpAccountCusAttribute.setSelected(cond.isShowAccountAttribute());
        this.chkDisplayAsstDetail.setSelected(cond.isShowDisplayAsstDetail());
        this.jcbNoDisplayZeroTotal.setSelected(cond.isNoDisplayZeroTotal());
        this.chkSumbyAsstact.setSelected(cond.isSumByAsstact());
        boolean bl = hasAsstAct = cond.getAsstActList().size() > 0;
        if (!hasAsstAct || cond.getMeasureUnitId() == null) {
            this.prbMeasureUnit.setValue(null);
            this.prbMeasureUnit.setEnabled(this.isQtyAsst && hasAsstAct);
        } else {
            try {
                MeasureUnitInfo measureUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(cond.getMeasureUnitId()));
                this.prbMeasureUnit.setValue((Object)measureUnit);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.jcbSumByMeasureUnit.setEnabled(this.isQtyAsst && hasAsstAct && this.prbMeasureUnit.getValue() == null);
        this.jcbSumByMeasureUnit.setSelected(cond.isGroupByMU());
        this.chkNoAmountShow.setSelected(cond.isNoAmountShow());
        this.asstCount = cond.getAsstActList().size();
        this.setMeasureUnitEable();
    }

    @Override
    protected boolean isVerifyAsstSelected() {
        return false;
    }

    @Override
    public void clear() {
        if (this.getUIContext().get("JoinQuery") != null) {
            this.getUIContext().remove("JoinQuery");
            return;
        }
        super.clear();
        this.asstCount = 0;
        this.chkOpOtherAccount.setSelected(false);
        this.chkOpOtherAsstact.setSelected(false);
        this.chkOpDailyTotal.setSelected(false);
        this.chkOpAccountCusAttribute.setSelected(false);
        this.chkDisplayAsstDetail.setSelected(false);
        this.chkSumbyAsstact.setSelected(false);
        this.jcbNoDisplayZeroTotal.setSelected(false);
        this.prbMeasureUnit.setValue(null);
        this.prbMeasureUnit.setEnabled(false);
        this.jcbSumByMeasureUnit.setSelected(false);
        this.jcbSumByMeasureUnit.setEnabled(false);
        this.chkNoAmountShow.setSelected(false);
    }

    @Override
    protected GLRptBaseCondition createReportCondition() {
        return new GLRptSubLedgerCondition();
    }

    @Override
    protected GLRptBaseCondition createReportCondition(Map param) throws CloneNotSupportedException {
        return new GLRptSubLedgerCondition(param);
    }

    @Override
    protected IGLRptBaseFacade getIGLRptBaseFacade() throws BOSException {
        return GLRptSubLedgerFacadeFactory.getRemoteInstance();
    }

    @Override
    protected String getNRptUI() {
        return "com.kingdee.eas.fi.gl.rpt.client.GLNRptSubLedgerExportUI";
    }

    @Override
    protected String getNRptSimpleUI() {
        return "com.kingdee.eas.fi.gl.rpt.client.GLNRptSubLedgerUI";
    }

    @Override
    public void actionEditExtendParams_actionPerformed(ActionEvent e) throws Exception {
        this.showParamExUI();
    }

    public String getResourceFromAuto(String resName) {
        return EASResource.getString((String)RES, (String)resName);
    }

    @Override
    protected List<ParamEx> getDefaultParamExs() {
        List<ParamEx> paramExs = super.getDefaultParamExs();
        ParamEx paramEx = new ParamEx("voucher_query_hint", "", "", this.getResourceFromAuto("GLRptAsstactGDUI1"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("VoucherQuery_EntryJoinOn_CompanyAndPeriod", "false", "false", this.getResourceFromAuto("GLRptAsstactGDUI2"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("VoucherQuery_AssistJoinOn_CompanyAndPeriod", "false", "false", this.getResourceFromAuto("GLRptAsstactGDUI3"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("VoucherQuery_AssistJoinOn_Account", "false", "false", this.getResourceFromAuto("GLRptAsstactGDUI4"));
        paramExs.add(paramEx);
        paramEx = new ParamEx("Tree_AssBal_Filter", "true", "true", this.getResourceFromAuto("Tree_AssBal_Filter"));
        paramExs.add(paramEx);
        return paramExs;
    }

    @Override
    protected void showAdvanceActionPerformed(ActionEvent e) {
        this.lbExtendParams.setVisible(!this.lbExtendParams.isVisible());
        this.btnEditExtendParams.setVisible(!this.btnEditExtendParams.isVisible());
        this.btnEditExtendParams.setEnabled(true);
    }
}

