/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionGeneralLedger;
import com.kingdee.eas.fi.gl.client.ReportGeneralLedgerUI;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.print.IRequestTableData;
import com.kingdee.eas.fi.gl.common.print.MultiPrint;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountTreeFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.PrintButtonEnum;
import com.kingdee.eas.fi.gl.rpt.client.AbstractGLRptSubLedgerUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBasePrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptCommonItemInfo;
import com.kingdee.eas.fi.gl.rpt.client.GLRptIRowDataFilledListener;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerPrintAccountContents;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerPrintConfig;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerPrintDelegate;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptTable;
import com.kingdee.eas.fi.gl.rpt.client.GLRptTableHelper;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.fi.gl.rpt.client.InnerSumTable;
import com.kingdee.eas.fi.gl.rpt.client.PrintButtonValues;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.config.IObjectMultiPKBuilder;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GLRptSubLedgerUI
extends AbstractGLRptSubLedgerUI
implements IRequestTableData {
    private static final long serialVersionUID = 4969217360508831456L;
    private AccountViewInfo currAccount;
    private String periodStartBalance = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.cell_periodInitAmount");
    private String periodEndBalance = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.cell_periodAmount");
    private String yearBalance = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.cell_yearAmount");
    private String dailyTotal = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource.dailyTotal");
    private boolean requesting = false;
    private AccountViewInfo printAccount;
    private boolean printFlag = false;
    private Map<String, Boolean> printFirstRequestFlagMap;
    private boolean isAccountCAA;

    public GLRptSubLedgerUI() throws Exception {
        this.actionVoucher.setEnabled(false);
        this.actionGeneralLedger.setEnabled(false);
        this.setPreferredSize(new Dimension(800, 600));
    }

    @Override
    public void onLoad() throws Exception {
        this.checkOrgsFuncPerm(SysContext.getSysContext().getCurrentFIUnit());
        super.onLoad();
        this.tblMain.setMergeHeadMoveable(true);
        if (this.MULTI_SELECTION_TOTAL) {
            this.innerSumTable = new InnerSumTable(this.getTable(), 1);
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemAssist.setIcon(EASResource.getIcon((String)"imgTbtn_assistantlistaccount"));
        this.menuItemVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.menuItemGeneralLedger.setIcon(EASResource.getIcon((String)"imgTbtn_overallsortaccount"));
        this.btnAssist.setIcon(EASResource.getIcon((String)"imgTbtn_assistantlistaccount"));
        this.btnVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.btnGeneralLedger.setIcon(EASResource.getIcon((String)"imgTbtn_overallsortaccount"));
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.tblMain.addGLRptIRowDataFilledListener(new GLRptIRowDataFilledListener(){

            @Override
            public void afterFilledTableRow(IRow row, String[] colKeys) {
                GLRptSubLedgerUI.this.afterFillDataTableRow(row, colKeys);
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                if (GLRptSubLedgerUI.this.innerSumTable != null) {
                    GLRptSubLedgerUI.this.innerSumTable.setVisible(false);
                }
                if (GLRptSubLedgerUI.this.innerSumTable != null && (GLRptSubLedgerUI.this.getTable().getSelectManager().size() > 1 || e.getSelectBlock().getEndRow() - e.getSelectBlock().getBeginRow() > 0)) {
                    GLRptSubLedgerUI.this.innerSumTable.selectRowSum(GLRptSubLedgerUI.this.getTable().getSelectManager().getBlocks(), GLRptSubLedgerUI.this.getQueryCond() != null && GLRptSubLedgerUI.this.getQueryCond().isAllCurrency());
                } else {
                    IRow row = GLRptSubLedgerUI.this.getSelectedTableRow();
                    GLRptSubLedgerUI.this.actionVoucher.setEnabled(row != null && row.getCell("voucherId").getValue() != null);
                    GLRptSubLedgerUI.this.setActionAssistState();
                }
            }
        });
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    GLRptUtils.queryVoucher(GLRptSubLedgerUI.this, GLRptSubLedgerUI.this.tblMain, "voucherId");
                }
            }
        });
    }

    private void setActionAssistState() {
        this.actionAssist.setEnabled(this.isAccountCAA);
    }

    private boolean isBeforeCurrPeriod() {
        GLRptSubLedgerCondition cond = this.getQueryCond();
        try {
            return cond.getPeriodYearStart() * 100 + cond.getPeriodNumberStart() <= cond.getCurrPeriod().getNumber();
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    protected void treeSelectionChanged(TreeSelectionEvent e) {
        boolean isEnable;
        TreePath path;
        DefaultMutableTreeNode node;
        if (this.innerSumTable != null) {
            this.innerSumTable.setVisible(false);
        }
        this.currAccount = (node = (DefaultMutableTreeNode)(path = e.getNewLeadSelectionPath()).getLastPathComponent()) != null && node.getUserObject() instanceof AccountViewInfo ? (AccountViewInfo)node.getUserObject() : null;
        super.treeSelectionChanged(e);
        this.isAccountCAA = false;
        if (node != null && node.getUserObject() instanceof AccountViewInfo) {
            AccountViewInfo account = (AccountViewInfo)node.getUserObject();
            if (account.getCAA() != null) {
                this.isAccountCAA = true;
            } else {
                GLRptSubLedgerCondition cond = this.getQueryCond();
                int startPeriod = cond.getPeriodYearStart() * 100 + cond.getPeriodNumberStart();
                int endPeriod = cond.getPeriodYearEnd() * 100 + cond.getPeriodNumberEnd();
                try {
                    Set caaIds = AccountFacadeFactory.getRemoteInstance().getCAAIdsByPeriodRange(account.getId().toString(), startPeriod, endPeriod);
                    if (caaIds.size() > 0) {
                        this.isAccountCAA = true;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.setActionAssistState();
        boolean bl = isEnable = node != null && node.getUserObject() instanceof AccountViewInfo;
        if (this.isBizUnitQuery()) {
            isEnable = isEnable && this.isBeforeCurrPeriod();
        }
        this.actionGeneralLedger.setEnabled(isEnable);
        if (node == null || !(node.getUserObject() instanceof AccountViewInfo)) {
            this.actionVoucher.setEnabled(false);
        }
    }

    private boolean isBizUnitQuery() {
        return this.getQueryCond().getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate;
    }

    @Override
    protected GLRptBaseQueryUI getCustQueryPanel() throws Exception {
        GLRptSubLedgerQueryUI queryUI = new GLRptSubLedgerQueryUI();
        return queryUI;
    }

    @Override
    protected boolean isShowFilter() {
        return true;
    }

    @Override
    protected boolean isShowSorter() {
        return true;
    }

    @Override
    protected void setQueryDialogSize(CommonQueryDialog dialog) {
        dialog.setWidth(480);
        dialog.setHeight(510);
    }

    @Override
    protected String getJoinExportLabel() {
        return GLResUtil.getRes("export_d_account") + "EXCEL";
    }

    @Override
    protected void actionExportToExcel_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.setCursorOfWair();
        }
        catch (Exception e1) {
            this.handleException(e1);
            return;
        }
        finally {
            this.setCursorOfDefault();
        }
        TreePath[] tps = this.getTree().getSelectionPaths();
        if (tps == null) {
            return;
        }
        GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)this.getQueryCond().clone();
        AccountViewCollection accountColl = this.getAccountColl(tps);
        if (accountColl.isEmpty()) {
            return;
        }
        Set accountIdSet = this.getAccountIDSet(accountColl);
        cond.setAccountIdSet(accountIdSet);
        cond.setAccounts(accountColl);
        EntityViewInfo view = new EntityViewInfo();
        view.put("isShowAccount", (Object)Boolean.TRUE);
        view.put("PAGE_ROW_COUNT", (Object)this.getExportPageSize());
        view.put("GLFixCondition", (Object)cond);
        this.exportExcel(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcel(EntityViewInfo view) throws BOSException, EASBizException {
        if (this.isExportAsyn()) {
            this.asynExportExcel(view);
        } else {
            try {
                IObjectPK pk = this.hasExportExcelPermission();
                if (pk != null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("name"));
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(pk, sic);
                    PermItemInfo permItemInfo = PermItemFactory.getRemoteInstance().getPermItemInfoByNumber(this.getExportPermissionItem());
                    throw new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION_2, new Object[]{SysContext.getSysContext().getCurrentUserInfo().getNumber(), company.getName(), permItemInfo.getAlias()});
                }
                this.setCursorOfWair();
                IGLRptBaseFacade facade = this.getIGLRptDataFacade();
                GLRptQueryResult rs = facade.query(view);
                this.doPrintData(rs, facade);
                Map<String, Object> params = this.getExportConfig();
                params.put("view", view);
                Map<String, Object> tParams = this.getExportParams(view);
                if (tParams != null) {
                    params.putAll(tParams);
                }
                this.getExporter(params).export(rs.getTableHeadInfo(), rs.getData());
            }
            finally {
                this.setCursorOfDefault();
            }
        }
    }

    @Override
    protected Map<String, Object> getExportParams(EntityViewInfo view) {
        return null;
    }

    @Override
    protected GLRptExcelExporter getExporter(Map<String, Object> params) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("Period", this.lblPeriod.getText());
        params.put("Currency", this.lblCurrency.getText());
        return new GLRptSubLedgerExcelExporter(params);
    }

    @Override
    public boolean isExportSupportXls() {
        return false;
    }

    @Override
    public boolean isExportSupportXlsx() {
        return true;
    }

    private AccountViewCollection getSelectedAccountColl(TreePath[] tps, GLRptSubLedgerCondition cond) throws BOSException {
        if (cond.getCompany().getId().equals((Object)this.getQueryCond().getCompany().getId())) {
            return this.getAccountColl(tps);
        }
        return this.getAccountCollByNumber(tps, cond);
    }

    private AccountViewCollection getAccountCollByNumber(TreePath[] tps, GLRptSubLedgerCondition cond) throws BOSException {
        HashSet<String> numberSet = new HashSet<String>();
        int n = tps.length;
        for (int i = 0; i < n; ++i) {
            Object nodeInfo;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tps[i].getLastPathComponent();
            if (node == null || (nodeInfo = node.getUserObject()) == null || !AccountViewInfo.class.isInstance(nodeInfo)) continue;
            numberSet.add(((AccountViewInfo)nodeInfo).getNumber());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("CAA.id"));
        view.getSelector().add(new SelectorItemInfo("companyID.id"));
        view.getSelector().add(new SelectorItemInfo("hasUserProperty"));
        view.getSelector().add(new SelectorItemInfo("isLeaf"));
        view.getSelector().add(new SelectorItemInfo("level"));
        view.getSelector().add(new SelectorItemInfo("isQty"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)cond.getAccountTableId()));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)cond.getCompany().getId()));
        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
    }

    private Set getAccountIDSet(AccountViewCollection accountColl) {
        if (accountColl == null || accountColl.isEmpty()) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < accountColl.size(); ++i) {
            idSet.add(accountColl.get(i).getId().toString());
        }
        return idSet;
    }

    private AccountViewCollection getAccountColl(TreePath[] tps) {
        AccountViewCollection accounts = new AccountViewCollection();
        int n = tps.length;
        for (int i = 0; i < n; ++i) {
            Object nodeInfo;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tps[i].getLastPathComponent();
            if (node == null || !AccountViewInfo.class.isInstance(nodeInfo = node.getUserObject())) continue;
            accounts.add((AccountViewInfo)nodeInfo);
        }
        return accounts;
    }

    @Override
    protected void joinQueryData(Object selectedObj) throws Exception {
        AccountViewInfo account;
        if (!(selectedObj instanceof AccountViewInfo)) {
            this.tblMain.removeColumns();
            return;
        }
        this.requesting = true;
        this.printAccount = account = (AccountViewInfo)selectedObj;
        GLRptSubLedgerCondition cond = new GLRptSubLedgerCondition(this.getQueryCond());
        HashSet<String> accountIdSet = new HashSet<String>();
        accountIdSet.add(account.getId().toString());
        cond.setAccountIdSet(accountIdSet);
        if (cond.getCompany() != null && cond.getCompany().isIsBizUnit()) {
            cond.setLeafAccount(account.isIsLeaf());
        }
        EntityViewInfo view = new EntityViewInfo();
        AccountViewCollection accounts = new AccountViewCollection();
        accounts.add(account);
        cond.setAccounts(accounts);
        view.put("GLFixCondition", (Object)cond);
        boolean tableInitFlag = !this.printFlag || this.printFirstRequestFlagMap != null && this.printFirstRequestFlagMap.get(account.getLongNumber()) == false;
        this.tblMain.query(view, tableInitFlag);
        if (tableInitFlag) {
            this.tHelper.setDefaultUserData(null);
            this.tHelper.init();
            if (this.printFlag) {
                this.printFirstRequestFlagMap.put(account.getLongNumber(), true);
            }
        }
        this.tblMain.selectFirst();
        this.requesting = false;
    }

    protected void afterFillDataTableRow(IRow row, String[] colKeys) {
        int localExRatepre;
        ICell currencyPreCell;
        Object balSeq = row.getCell("FBalSeq").getValue();
        if (balSeq.toString().equals("3")) {
            row.getStyleAttributes().setBackground(GLRptUtils.DAY_TOTAL_COLOR);
        }
        if (balSeq.toString().equals("4")) {
            row.getStyleAttributes().setBackground(GLRptUtils.PERIOD_TOTAL_COLOR);
        }
        if (balSeq.toString().equals("5")) {
            row.getStyleAttributes().setBackground(GLRptUtils.YEAR_TOTAL_COLOR);
        }
        if (balSeq.toString().equals("6")) {
            row.getStyleAttributes().setBackground(GLRptUtils.PERIOD_SUM_COLOR);
        }
        if ((currencyPreCell = row.getCell("currencyPre")) != null && currencyPreCell.getValue() != null) {
            int currencyPre = Integer.parseInt(currencyPreCell.getValue().toString());
            String key = null;
            for (int i = 0; i < colKeys.length; ++i) {
                key = colKeys[i];
                if (key == null || !key.endsWith("For")) continue;
                row.getCell(key).getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(currencyPre));
            }
        }
        ICell localExRateCell = row.getCell("FLocalExchangeRate");
        ICell localExRatePreCell = row.getCell("FLocalExRatePre");
        if (localExRateCell != null && localExRatePreCell != null && localExRatePreCell.getValue() != null) {
            localExRatepre = Integer.parseInt(localExRatePreCell.getValue().toString());
            localExRateCell.getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(localExRatepre));
        } else if (localExRateCell != null && localExRateCell.getValue() != null && localExRatePreCell == null) {
            localExRatepre = ((BigDecimal)localExRateCell.getValue()).scale();
            localExRateCell.getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(localExRatepre));
        }
        ICell rptExRateCell = row.getCell("FReportingExchangeRate");
        ICell rptExRatePreCell = row.getCell("FRptExRatePre");
        if (rptExRateCell != null && rptExRatePreCell != null && rptExRatePreCell.getValue() != null) {
            int rptExRatepre = Integer.parseInt(rptExRatePreCell.getValue().toString());
            rptExRateCell.getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(rptExRatepre));
        } else if (rptExRateCell != null && rptExRateCell.getValue() != null && rptExRatePreCell == null) {
            int rptExRatepre = ((BigDecimal)rptExRateCell.getValue()).scale();
            rptExRateCell.getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(rptExRatepre));
        }
    }

    @Override
    protected GLRptBaseCondition createQueryCond(Map param) {
        try {
            return new GLRptSubLedgerCondition(param);
        }
        catch (CloneNotSupportedException ex) {
            this.handUIExceptionAndAbort(ex);
            return null;
        }
    }

    @Override
    protected IProcessor getQueryFilterProcessor(GLRptBaseQueryUI queryUI) {
        return GLRptUtils.getUserQueryFilter(queryUI);
    }

    @Override
    protected GLRptSubLedgerCondition getQueryCond() {
        GLRptSubLedgerCondition subLedgerCondition = (GLRptSubLedgerCondition)super.getQueryCond();
        return subLedgerCondition;
    }

    @Override
    protected IGLRptBaseFacade getIGLRptFacade() throws BOSException {
        return GLRptAccountTreeFacadeFactory.getRemoteInstance();
    }

    @Override
    protected IGLRptBaseFacade getIGLRptDataFacade() throws BOSException {
        return GLRptSubLedgerFacadeFactory.getRemoteInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GLRptRowSet getPrintData(EntityViewInfo view, PrintButtonValues values) throws EASBizException, BOSException {
        GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)view.get("GLFixCondition");
        GLRptQueryResult rs = null;
        Map topKeMuMap = null;
        view.setInt("PAGE_ROW_COUNT", this.getExportPageSize());
        if (values != null && values.getBoolean(PrintButtonEnum.AccountArea)) {
            String queryId = null;
            try {
                cond.setSelectedItem(null);
                cond.setDataSourceTable(null);
                AccountViewCollection accountColl = this.getPrintAccountCollection(view);
                if (accountColl.isEmpty()) {
                    GLRptRowSet gLRptRowSet = null;
                    return gLRptRowSet;
                }
                cond.setAccounts(accountColl);
                this.setSelectedAccounts(view, this.getAccountIDSet(accountColl));
                topKeMuMap = this.getTopKeMu(accountColl, cond);
                rs = this.queryRight(view);
            }
            finally {
                if (queryId != null) {
                    this.getIGLRptFacade().releaseDataSource(queryId);
                }
            }
        } else {
            TreePath[] tps = this.getTree().getSelectionPaths();
            if (tps == null) {
                return null;
            }
            AccountViewCollection accountColl = this.getSelectedAccountColl(tps, cond);
            if (accountColl == null || accountColl.isEmpty()) {
                return null;
            }
            cond.setAccounts(accountColl);
            this.setSelectedAccounts(view, this.getAccountIDSet(accountColl));
            topKeMuMap = this.getTopKeMu(accountColl, cond);
            rs = this.queryRight(view);
        }
        cond.getExpandInfo().put("topKeMuMap", topKeMuMap);
        return rs == null ? null : rs.getData();
    }

    private Map getTopKeMu(AccountViewCollection accountColl, GLRptSubLedgerCondition cond) throws BOSException {
        HashMap<String, String> topKeMuMap = new HashMap<String, String>();
        HashMap<String, String> cacheMap = new HashMap<String, String>();
        int size = accountColl.size();
        for (int i = 0; i < size; ++i) {
            AccountViewInfo account = accountColl.get(i);
            String longNumStr = account.getLongNumber().split("!")[0];
            if (!cacheMap.containsKey(longNumStr)) {
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("id"));
                view.getSelector().add(new SelectorItemInfo("name"));
                view.getSelector().add(new SelectorItemInfo("number"));
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)cond.getAccountTableId(), CompareType.EQUALS));
                fi.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)cond.getCompany().getId().toString(), CompareType.EQUALS));
                fi.getFilterItems().add(new FilterItemInfo("level", (Object)1, CompareType.EQUALS));
                fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)account.getLongNumber().split("!")[0], CompareType.EQUALS));
                view.setFilter(fi);
                AccountViewCollection accollect = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
                if (accollect == null || accollect.size() <= 0) continue;
                topKeMuMap.put(account.getId().toString(), accollect.get(0).getNumber() + " " + accollect.get(0).getName());
                cacheMap.put(longNumStr, accollect.get(0).getNumber() + " " + accollect.get(0).getName());
                continue;
            }
            topKeMuMap.put(account.getId().toString(), (String)cacheMap.get(longNumStr));
        }
        return topKeMuMap;
    }

    private void setSelectedAccounts(EntityViewInfo view, Set accountIdSet) {
        GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)view.get("GLFixCondition");
        cond.setAccountIdSet(accountIdSet);
        view.put("isShowAccount", (Object)Boolean.TRUE);
    }

    private AccountViewCollection getPrintAccountCollection(EntityViewInfo view) throws EASBizException, BOSException {
        GLRptQueryResult rs = this.getIGLRptFacade().query(view);
        GLRptRowSet data = rs.getData();
        AccountViewCollection accountColl = new AccountViewCollection();
        if (data.next()) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)data.getObject("accountTree");
            Enumeration<TreeNode> e = root.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                Object nodeInfo;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                if (node == null || (nodeInfo = node.getUserObject()) == null || !(nodeInfo instanceof AccountViewInfo)) continue;
                accountColl.add((AccountViewInfo)nodeInfo);
            }
        }
        return accountColl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GLRptQueryResult queryRight(EntityViewInfo view) throws BOSException, EASBizException {
        IGLRptBaseFacade facade = this.getIGLRptDataFacade();
        GLRptQueryResult rs = null;
        try {
            rs = facade.query(view);
            if (rs == null) {
                GLRptQueryResult gLRptQueryResult = null;
                return gLRptQueryResult;
            }
            this.doPrintData(rs, facade);
        }
        finally {
            if (rs != null && rs.getQueryId() != null) {
                facade.releaseDataSource(rs.getQueryId());
            }
        }
        return rs;
    }

    @Override
    protected void print(boolean noPreview, String templatepathPath, GLRptBasePrintConfig config, CompanyOrgUnitInfo company, PrintButtonValues values) throws EASBizException, BOSException {
        GLRptRowSet rs;
        KDNoteHelper appHelp = new KDNoteHelper();
        EntityViewInfo view = this.getPrintEntityView(company);
        GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)view.get("GLFixCondition");
        GLRptSubLedgerPrintConfig conf = (GLRptSubLedgerPrintConfig)config;
        if (!cond.isSumByAsstact() && !conf.isChkAcctAndAsst()) {
            conf.setPageByAsst(false);
        }
        cond.setAcctAndAsst(conf.isChkAcctAndAsst());
        if (cond.isAcctAndAsst()) {
            cond.setShowDisplayAsstDetail(true);
            cond.setSumByAsstact(false);
        }
        cond.setGroupVoucher(conf.isGroup());
        if (conf.isGroup()) {
            cond.setGroupVoucherByAccount(conf.isGroupByAccount());
            cond.setGroupVoucherAccLevel(conf.getAccountLevel());
            cond.setGroupVoucherZeroNotShow(conf.isZeroNoDisplay());
        }
        if ((rs = this.getPrintData(view, values)) != null && rs.size() > 0 && this.printAccountContents(noPreview, rs, cond, config)) {
            BOSQueryDelegate delegate = this.getPrintQueryDelegate(rs, cond, config);
            appHelp.directPrint(templatepathPath, (Object)delegate, noPreview, (Component)((Object)this));
        }
    }

    private boolean printAccountContents(boolean noPreview, GLRptRowSet rs, GLRptSubLedgerCondition cond, GLRptBasePrintConfig config) {
        GLRptSubLedgerPrintConfig conf = (GLRptSubLedgerPrintConfig)config;
        boolean isPrintAccountContents = conf.isPrintAccountContents();
        if (isPrintAccountContents) {
            GLRptSubLedgerPrintAccountContents rsprv;
            KDNoteHelper appHlp;
            int result;
            String printAccountContents = conf.getPrintAccountContents();
            if (printAccountContents == null || com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)printAccountContents) || "null".equalsIgnoreCase(printAccountContents.trim())) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource", (String)"notTemplet");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if ((result = (appHlp = new KDNoteHelper()).directPrint(printAccountContents, (Object)(rsprv = new GLRptSubLedgerPrintAccountContents(cond, rs, conf)), noPreview, (Component)((Object)this))) == 2) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.rpt.app.GLRptSubledgerQuery";
    }

    @Override
    protected String getPrintConfigUIName() {
        return "com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerPrintConfigUI";
    }

    @Override
    protected void setPrintConfigUIParam(UIContext uiContext) {
        GLRptSubLedgerCondition cond = this.getQueryCond();
        try {
            int maxAccountLevel = this.getIGLRptFacade().getAccountMaxLevel(cond.getAllCompanyIds(), cond.getAccountTableId());
            uiContext.put((Object)"accountMaxLevel", (Object)maxAccountLevel);
            uiContext.put((Object)"chkPageByAsst", (Object)cond.isSumByAsstact());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    protected GLRptBasePrintConfig getPrintConfig() {
        return new GLRptSubLedgerPrintConfig(this);
    }

    @Override
    protected BOSQueryDelegate getPrintQueryDelegate(GLRptRowSet rs, GLRptBaseCondition cond, GLRptBasePrintConfig config) throws EASBizException, BOSException {
        return new GLRptSubLedgerPrintDelegate(rs, this.getPrintVar(cond), config, ((GLRptSubLedgerCondition)cond).isShowDisplayAsstDetail());
    }

    protected Map getPrintVar(GLRptBaseCondition condition) throws EASBizException, BOSException {
        HashMap<String, Object> printParams = new HashMap<String, Object>();
        GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)condition;
        printParams.put("qtyScale", cond.getQtyScale());
        printParams.put("priceScale", cond.getRptParams().getPriceScale());
        printParams.put("currencyId", cond.getCurrencyID());
        printParams.put("Period", this.lblPeriod.getText());
        printParams.put("company", cond.getCompany());
        printParams.put("account", cond.getAccounts());
        printParams.put("accountTableId", cond.getAccountTableId());
        printParams.put("topKeMuMap", cond.getExpandInfo().get("topKeMuMap"));
        return printParams;
    }

    @Override
    protected List getCommonPrintButtons() {
        ArrayList<GLRptCommonItemInfo> list = new ArrayList<GLRptCommonItemInfo>();
        list.add(new GLRptCommonItemInfo(PrintButtonEnum.CompanyArea, new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"SelectedCompany"), EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"AllCompany")}));
        list.add(new GLRptCommonItemInfo(PrintButtonEnum.AccountArea, new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"SelectedAccount"), EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"AllAccount")}));
        return list;
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        GLRptUtils.queryVoucher(this, this.tblMain, "voucherId");
    }

    @Override
    public Object getTablePreferenceSchemaKey() {
        GLRptSubLedgerCondition cond = this.getQueryCond();
        boolean isQty = false;
        boolean isAsstAct = false;
        boolean isAccountAttribute = false;
        boolean isOppAccount = cond.isShowOppAccount();
        boolean isOppAsstAct = false;
        String allAccountAttributes = "FBizNumber|customer|feeType|receiverName|FInvoiceNumber|material|FSettlementCode|settleTypeName|supplier|FTicketNumber";
        KDTColumns columns = this.getTable().getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            KDTColumn column = columns.getColumn(i);
            if (column == null) continue;
            if (cond.isShowDisplayAsstDetail() && !isAsstAct && column.getKey().contains("FAsstAccountName")) {
                isAsstAct = true;
            }
            if (cond.isShowOppAsstact() && !isOppAsstAct && column.getKey().contains("FOppAsstAccountName")) {
                isOppAsstAct = true;
            }
            if (!isQty && column.getKey().contains("Qty")) {
                isQty = true;
            }
            if (cond.isShowAccountAttribute() && !isAccountAttribute && allAccountAttributes.contains(column.getKey())) {
                isAccountAttribute = true;
            }
            if (isAsstAct && isOppAsstAct && isQty && isAccountAttribute) break;
        }
        String key = (String)super.getTablePreferenceSchemaKey();
        return key + "||" + isQty + "||" + isAsstAct + "||" + isAccountAttribute + "||" + isOppAccount + "||" + isOppAsstAct;
    }

    @Override
    public void actionAssist_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isAccountCAA) {
            return;
        }
        GLRptSubLedgerCondition subCon = this.getQueryCond();
        GLRptAsstactGDCondition cond = new GLRptAsstactGDCondition(subCon);
        cond.setCompanyDisplayMode(CompanyDisplayModeEnum.enumerate);
        this.setJoinCompany(cond);
        cond.setNoDisplayZeroTotal(subCon.isNoDisplayZeroTotal());
        cond.setDisplayAttribute(subCon.isShowAccountAttribute());
        cond.setShowQty(this.currAccount.isIsQty());
        cond.setAccountId(this.currAccount.getId().toString());
        if (cond.getCompanys() != null && cond.getCompanys().length > 1) {
            CompanyOrgUnitInfo[] companys = cond.getCompanys();
            IRow row = this.getSelectedTableRow();
            if (row != null) {
                String companyId = (String)row.getCell("FCompanyID").getValue();
                for (int i = 0; i < companys.length; ++i) {
                    if (companys[i].getId() == null || !companys[i].getId().toString().equals(companyId)) continue;
                    cond.setCompanys(new CompanyOrgUnitInfo[]{companys[i]});
                    cond.setSelectedCompanys(new CompanyOrgUnitInfo[]{companys[i]});
                    break;
                }
            }
        }
        cond.setShowDailyTotal(subCon.isShowDailyTotal());
        cond.setAccountIdSet((Set)null);
        this.joinQury(cond, GLRptAsstactGDUI.class.getName());
    }

    @Override
    protected void tableUserSetting() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionGeneralLedger_actionPerformed(ActionEvent e) throws Exception {
        GLRptSubLedgerCondition condition = this.getQueryCond();
        AccountViewInfo acc = null;
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("PLType");
        selectors.add("accountTableID");
        CompanyOrgUnitInfo company = condition.getCompany();
        String accountTableId = condition.getAccountTableId();
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)accountTableId)) {
            acc = acc == null ? AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(this.currAccount.getId()), selectors) : acc;
            accountTableId = acc.getAccountTableID().getId().toString();
        }
        AccountTableInfo acctTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(condition.getAccountTableId()));
        company.setAccountTable(acctTable);
        ReportConditionGeneralLedger newCondition = new ReportConditionGeneralLedger(condition);
        newCondition.setCompanyId(company.getId().toString());
        if (condition.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            Set companyIds = condition.getCompanyIds();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)6));
            filter.getFilterItems().add(new FilterItemInfo("currentPeriod.number", (Object)(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()), CompareType.LESS));
            if (SystemStatusCtrolFactory.getRemoteInstance().exists(filter)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportGeneralLedgerUI", (String)"virtualQueryIncAfterCurPeriod"));
                SysUtil.abort();
            }
            newCondition.getExpandInfo().put("companyIds", companyIds);
        }
        newCondition.getExpandInfo().put("accountTableId", accountTableId);
        newCondition.setOptionNoDisplayZeroTotal(condition.isNoDisplayZeroTotal());
        newCondition.setOptionNOTDisplayIfNoAmount(condition.isOptionAmountZero());
        newCondition.setAccountId(this.currAccount.getId().toString());
        newCondition.setAccountLevelStart(this.currAccount.getLevel());
        newCondition.setAccountLevelEnd(this.currAccount.getLevel());
        newCondition.setNotIncludePLVoucher(condition.isNotIncluePLVoucher());
        EntityViewInfo view = new EntityViewInfo();
        view.put("GLFixCondition", (Object)newCondition);
        if (condition.isAllCurrency()) {
            IRow row = this.getSelectedTableRow();
            if (row != null) {
                String currencyId = (String)row.getCell("FCurrencyID").getValue();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("name"));
                newCondition.setCurrencyID(currencyId);
                newCondition.setCurrencyName(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId), selector).getName());
            } else {
                newCondition.setCurrencyID(null);
            }
        }
        try {
            this.setCursorOfWair();
            ReportGeneralLedgerUI.queryByCondition(view, (CoreUIObject)this, condition.getCompany(), !condition.getCompany().isIsBizUnit());
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void joinQury(GLRptAsstactGDCondition cond, String uiClassName) throws Exception {
        if (this.getDataComponent().isEmpty()) {
            return;
        }
        try {
            this.setCursorOfWair();
            this.setLinkedAccount(cond);
            this.setLinkedAsstactList(cond);
            this.setJoinQueryGDShowQty(cond);
            this.setLinkedCurrency(cond);
            String mode = this.getUIWindow() instanceof UINewFrame ? "com.kingdee.eas.base.uiframe.client.UINewFrameFactory" : "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
            IUIWindow ui = UIFactory.createUIFactory((String)mode).create(uiClassName, (Map)GLRptUtils.getLinkedContext(cond, this), null);
            ui.show();
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    private void setJoinQueryGDShowQty(GLRptAsstactGDCondition cond) throws EASBizException, BOSException, GLException {
        GlParam params = GlParam.getGlParams(null, (String)"G010", (String)cond.getCompany().getId().toString());
        boolean isQtyAsst = params.getBoolean("G010");
        if (!isQtyAsst && this.currAccount.isIsQty()) {
            cond.setShowQty(true);
        } else if (isQtyAsst && this.currAccount.isIsQty()) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("isQty"));
            String caaId = this.getCAAIdByRow(cond);
            if (!StringUtils.isEmpty((String)caaId)) {
                ObjectUuidPK asstAccId = new ObjectUuidPK(caaId);
                AsstAccountInfo asstAccInfo = AsstAccountFactory.getRemoteInstance().getAsstAccountInfo((IObjectPK)asstAccId, selector);
                if (asstAccInfo.isIsQty()) {
                    cond.setShowQty(true);
                }
            }
        }
        if (!cond.isShowQty()) {
            cond.setGroupByMU(false);
        }
    }

    protected void setLinkedAccount(GLRptAsstactGDCondition cond) throws EASBizException, BOSException {
        cond.setAccountId(this.currAccount.getId().toString());
        cond.setAccountCodeStart(this.currAccount.getNumber());
        cond.setAccountCodeEnd(this.currAccount.getNumber());
    }

    protected void setLinkedAsstactList(GLRptAsstactGDCondition cond) throws CloneNotSupportedException, BOSException, EASBizException {
        List asstActList;
        if (this.getQueryCond().isShowDisplayAsstDetail() && (asstActList = GLRptUtils.getasstActList(this.getTableForPrint(), "FAssGrpId")) != null && asstActList.size() > 0) {
            cond.setAsstActList(asstActList);
            return;
        }
        GLRptSubLedgerCondition subCon = this.getQueryCond();
        String caaId = this.getCAAIdByRow(cond);
        if (caaId != null) {
            List atList = GLRptUtils.getAsstactTypeEntityList(caaId);
            List selectedAsstList = subCon.getAsstActList();
            Iterator it = atList.iterator();
            ArrayList<AsstactTypeEntity> newAtList = new ArrayList<AsstactTypeEntity>();
            while (it.hasNext()) {
                AsstactTypeEntity at = (AsstactTypeEntity)it.next();
                boolean selected = false;
                for (int i = 0; i < selectedAsstList.size(); ++i) {
                    AsstactTypeEntity sat = (AsstactTypeEntity)selectedAsstList.get(i);
                    if (!at.getId().equals(sat.getId())) continue;
                    newAtList.add(sat);
                    selected = true;
                }
                if (selected) continue;
                newAtList.add(at);
            }
            cond.setAsstActList(newAtList);
        }
    }

    private String getCAAIdByRow(GLRptAsstactGDCondition cond) throws BOSException, EASBizException {
        String caaId;
        String str;
        IRow row = this.getSelectedTableRow();
        int period = cond.getPeriodYearStart() * 100 + cond.getPeriodNumberStart();
        if (row != null && (str = (String)row.getCell("FPeriod").getValue()) != null && str.length() >= 5) {
            String month = (str = str.replaceAll("\\.", "")).substring(4);
            if (month.length() == 1) {
                month = "0" + month;
                str = str.substring(0, 4) + month;
            }
            period = Integer.parseInt(str);
        }
        if ((caaId = AccountFacadeFactory.getRemoteInstance().getCAAIdByPeriod(this.currAccount.getId().toString(), period)) == null && this.currAccount.getCAA() != null) {
            caaId = this.currAccount.getCAA().getId().toString();
        }
        if (caaId == null) {
            int endPeriod = cond.getPeriodYearEnd() * 100 + cond.getPeriodNumberEnd();
            Set caaIds = AccountFacadeFactory.getRemoteInstance().getCAAIdsByPeriodRange(this.currAccount.getId().toString(), period, endPeriod);
            if (caaIds.size() > 0) {
                caaId = (String)caaIds.iterator().next();
            }
        }
        return caaId;
    }

    private void setLinkedCurrency(GLRptAsstactGDCondition cond) throws EASBizException, BOSException {
        if (cond.isAllCurrency()) {
            IRow row = this.getSelectedTableRow();
            if (row == null) {
                return;
            }
            String currencyId = (String)row.getCell("FCurrencyID").getValue();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            cond.setCurrencyID(currencyId);
            cond.setCurrencyName(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId), selector).getName());
        }
    }

    private IRow getSelectedTableRow() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return null;
        }
        return this.tblMain.getRow(rowIndex);
    }

    @Override
    protected String getPermissionItem() {
        return "gl_subsidiaryLedger_view";
    }

    @Override
    protected String getExportPermissionItem() {
        return "gl_subsidiaryLedger_export";
    }

    @Override
    protected Map preparePrintVariantMap() {
        Map map = super.preparePrintVariantMap();
        StringBuffer accountName = new StringBuffer();
        TreePath[] tps = this.getTree().getSelectionPaths();
        if (tps == null) {
            return null;
        }
        AccountViewCollection accountColl = null;
        AccountViewInfo accountViewInfo = null;
        try {
            accountColl = this.getSelectedAccountColl(tps, this.getQueryCond());
            if (accountColl != null && accountColl.size() > 0) {
                for (int i = 0; i < accountColl.size(); ++i) {
                    accountViewInfo = accountColl.get(i);
                    accountName.append(accountViewInfo.getName(this.getLocale()));
                }
            }
            map.put("Account", accountName.toString());
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return map;
    }

    @Override
    protected void preparePrintPageHeader(HeadFootModel header) {
        super.preparePrintPageHeader(header);
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPrintTitle", (String)"AccountName_Label"));
        sb.append("&[Account]");
        header.addRow(sb.append("&|").toString(), sa);
    }

    @Override
    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    @Override
    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void print(boolean preview) throws Exception {
        boolean hasRequestOtherAccount = false;
        try {
            this.setCursorOfWair();
            MultiPrint mp = new MultiPrint((Component)((Object)this));
            if (!mp.showPrintOption()) {
                return;
            }
            this.preparePrintPage(this.getPrintTable());
            TreePath[] tps = this.getAsstactTreePath(mp.isPrintAll());
            AccountViewCollection avCol = this.getAccountColl(tps);
            this.printFirstRequestFlagMap = new HashMap<String, Boolean>(avCol.size());
            int begin = 0;
            mp.getMultiPrintModel().setTable(this.getPrintTable());
            mp.getMultiPrintModel().setRequestData(this);
            String companyName = null;
            companyName = this.getQueryCond().getCompany() != null ? this.getQueryCond().getCompany().getName() : this.getCurrCompany().getName();
            int n = avCol.size();
            for (int i = begin; i < n; ++i) {
                HashMap<String, String> var = new HashMap<String, String>();
                var.put("Company", companyName);
                var.put("User", SysContext.getSysContext().getUserName());
                var.put("Period", this.lblPeriod.getText().substring(3));
                var.put("Currency", this.lblCurrency.getText().substring(3));
                var.put("Account", avCol.get(i).getNumber() + " " + avCol.get(i).getName());
                this.printFirstRequestFlagMap.put(avCol.get(i).getLongNumber(), false);
                mp.getMultiPrintModel().addVarParser("PrintJob_" + i, var);
                mp.getMultiPrintModel().addTreePath("PrintJob_" + i, avCol.get(i));
            }
            boolean bl = hasRequestOtherAccount = avCol.size() > 1;
            if (preview) {
                mp.preview();
            } else {
                mp.print();
            }
        }
        finally {
            if (hasRequestOtherAccount) {
                this.requestTableData(this.currAccount);
            }
            this.setCursorOfDefault();
        }
    }

    private TreePath[] getAsstactTreePath(boolean all) {
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        TreePath[] tps = null;
        if (all) {
            Enumeration em = ((DefaultKingdeeTreeNode)this.getTree().getTree().getModel().getRoot()).preorderEnumeration();
            while (em.hasMoreElements()) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)em.nextElement();
                list.add(new TreePath(node.getPath()));
            }
        } else {
            tps = this.getTree().getSelectionPaths();
            if (tps != null) {
                int n = tps.length;
                for (int i = 0; i < n; ++i) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tps[i].getLastPathComponent();
                    list.add(tps[i]);
                }
            }
        }
        tps = new TreePath[list.size()];
        list.toArray(tps);
        return tps;
    }

    @Override
    public void requestTableData(Object thepath) throws Exception {
        AccountViewInfo itemData = null;
        if (!(thepath instanceof AccountViewInfo)) {
            return;
        }
        itemData = (AccountViewInfo)thepath;
        this.joinQueryData(itemData);
    }

    @Override
    public void confirmEnd() {
        try {
            while (this.requesting) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected GLRptBaseCondition getDefaultQueryCondtion() throws BOSException, EASBizException, Exception {
        GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)super.getDefaultQueryCondtion();
        String acctAsstItems = (String)this.getUIContext().get("JoinQuery_Outer_Params_asstActList");
        if (acctAsstItems != null && acctAsstItems.length() > 0) {
            List asstActList = GLRptSubLedgerUI.acctAsstItemsToList(acctAsstItems, cond.getCompany());
            if (asstActList == null || asstActList.size() == 0) {
                cond.setShowDisplayAsstDetail(false);
                cond.setAsstActList(new ArrayList());
            } else {
                cond.setAsstActList(asstActList);
                cond.setShowDisplayAsstDetail(true);
                cond.setSumByAsstact(true);
            }
        }
        return cond;
    }

    protected static List acctAsstItemsToList(String acctAsstItems, CompanyOrgUnitInfo curCompany) {
        AcctountAsstItemParser.AsstItem[] asstItems = null;
        try {
            AcctountAsstItemParser.AccountAsstItem accountAsstItem = AcctountAsstItemParser.parse((String)acctAsstItems);
            asstItems = accountAsstItem.asstItems;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList<AsstactTypeEntity> asstActList = new ArrayList<AsstactTypeEntity>();
        List list = null;
        try {
            list = RptClientUtil.queryAsstAct(null, curCompany.getCU().getId().toString());
            for (int j = 0; j < list.size(); ++j) {
                AsstactTypeEntity at = (AsstactTypeEntity)list.get(j);
                at.setSelected(false);
            }
            if (asstItems != null) {
                block6: for (int i = 0; i < asstItems.length; ++i) {
                    AcctountAsstItemParser.AsstItem asstItem = asstItems[i];
                    for (int j = 0; j < list.size(); ++j) {
                        DataBaseInfo asstActInfo;
                        AsstactTypeEntity at = (AsstactTypeEntity)list.get(j);
                        if (!at.getNumber().equals(asstItem.asstTypeNumber)) continue;
                        at.setSelected(true);
                        if (asstItem.group != null) {
                            String asstGroup = "";
                            for (int l = 0; l < asstItem.group.length; ++l) {
                                AcctountAsstItemParser.Group group = asstItem.group[l];
                                if (asstGroup != "") {
                                    asstGroup = asstGroup + "&";
                                }
                                asstGroup = asstGroup + group.standardNumber;
                                if (group.startNumber != null && group.startNumber.length() > 0) {
                                    asstGroup = asstGroup + '#' + group.startNumber;
                                }
                                if (group.endNumber == null || group.endNumber.length() <= 0) continue;
                                asstGroup = asstGroup + ':' + group.endNumber;
                            }
                            at.setAsstGroup(asstGroup);
                        }
                        if (asstItem.startNumber != null && asstItem.startNumber.length() > 0) {
                            asstActInfo = GlUtils.findAsstActObject(at.getHgAttribute(), asstItem.startNumber, SysContext.getSysContext().getCurrentFIUnit().getCU().getId().toString());
                            at.setFrom(asstActInfo);
                        }
                        if (asstItem.endNumber != null && asstItem.endNumber.length() > 0) {
                            asstActInfo = GlUtils.findAsstActObject(at.getHgAttribute(), asstItem.endNumber, SysContext.getSysContext().getCurrentFIUnit().getCU().getId().toString());
                            at.setTo(asstActInfo);
                        }
                        if (at.isUseGroup()) {
                            at.setMultilevel(false);
                        }
                        if (at.isUseLevel() && !at.isUseLongNumber()) {
                            at.setMultilevel(false);
                        }
                        asstActList.add(at);
                        continue block6;
                    }
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return asstActList;
    }

    public void setPrintFlag(boolean printFlag) {
        this.printFlag = printFlag;
    }

    @Override
    protected String getKDSplitPaneDividerLocationSettingFunction() {
        return "fi.gl.rpt.SubLedgerKDSplitPaneDividerLocationSetting";
    }

    @Override
    protected GLRptTable getTable() {
        return this.tblMain;
    }

    protected void initHelper() {
        this.tHelperPrint = this.tHelper = new GLRptTableHelper(this, new IObjectMultiPKBuilder(){

            public IObjectPK buildPK() {
                return GLRptSubLedgerUI.this.buildPK();
            }
        });
    }
}

