/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.rpc.recordSlowReq.RecordMonitor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.FilterZeroParser;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstActTypeBalanceUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptCellTreeRenderer;
import com.kingdee.eas.fi.gl.rpt.client.GLRptDataComponent;
import com.kingdee.eas.fi.gl.rpt.client.GLRptIRowDataFilledListener;
import com.kingdee.eas.fi.gl.rpt.client.GLRptRowSetListener;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GLRptTable
extends KDTable
implements GLRptDataComponent {
    private static final long serialVersionUID = 5512211451658321873L;
    private static final Logger logger = CoreUIObject.getLogger(GLRptTable.class);
    private boolean isPageContinue = false;
    private GLRptBaseUI owner;
    private IGLRptBaseFacade iFacade;
    private GLRptBaseUI.QueryAfterHandler handler;
    private boolean isAsynQuery = true;
    private EntityViewInfo mainQuery;
    private String treeColName;
    private boolean firstLoadData = true;
    private String queryId;
    private JMenuItem expandAllItem;
    private GLRptTableHeadInfo tableHeadInfo;
    private int rowCount = -1;
    private int currRowIndex = -1;
    private List rowSetListeners = new ArrayList();
    private List rowFilledListeners = new ArrayList();
    private boolean isF8Enable = true;
    private boolean isAsynSumData = true;
    private boolean isReParseTable = true;
    private boolean isDataTable = true;

    public GLRptTable() {
        this.getStyleAttributes().setLocked(true);
    }

    @Override
    public void init(GLRptBaseUI owner, IGLRptBaseFacade iFacade, GLRptBaseUI.QueryAfterHandler handler, boolean isAsynQuery, boolean isF8Enable) {
        this.owner = owner;
        this.iFacade = iFacade;
        this.handler = handler;
        this.isAsynQuery = isAsynQuery;
        this.isF8Enable = isF8Enable;
        this.checkParsed();
        int selectMode = 15;
        try {
            Object GL_125 = GlUtils.getParamByKey(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), "GL_125");
            if ("1".equals(GL_125)) {
                selectMode = 10;
            }
        }
        catch (Exception e) {
            owner.handUIException(e);
        }
        this.getSelectManager().setSelectMode(selectMode);
        this.setUserCellDisplayParser(new FilterZeroParser());
        this.getDataRequestManager().setDataRequestMode(1);
        this.initListener();
    }

    public void setAsynSumData(boolean isAsynSumData) {
        this.isAsynSumData = isAsynSumData;
    }

    public void initListener() {
        this.addKDTDataRequestListener(new KDTDataRequestListener(){

            public void tableDataRequest(KDTDataRequestEvent e) {
                try {
                    GLRptTable.this.tblMain_doRequestRowSet(e.getFirstRow());
                }
                catch (Exception ex) {
                    GLRptTable.this.setRowCount(0);
                    GLRptTable.this.owner.handUIException(ex);
                }
            }
        });
        this.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    GLRptTable.this.tblMain_SelectChanged(e.getSelectBlock().getBeginRow());
                }
                catch (Exception ex) {
                    GLRptTable.this.owner.handUIException(ex);
                }
            }
        });
        this.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    GLRptTable.this.doTableClick(e);
                }
                catch (Exception ex) {
                    GLRptTable.this.owner.handUIException(ex);
                }
            }
        });
        if (this.isF8Enable) {
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int rowIndex = GLRptTable.this.getSelectManager().getActiveRowIndex();
                    if (rowIndex != -1 && e.getKeyCode() == 119 && GLRptTable.this.treeColName != null && GLRptTable.this.getCell(rowIndex, GLRptTable.this.treeColName).getValue() != null && GLRptTable.this.expandAllItem.isEnabled()) {
                        try {
                            GLRptTable.this.expandRow(rowIndex, true);
                        }
                        catch (Exception ex) {
                            GLRptTable.this.owner.handUIException(ex);
                        }
                    }
                }
            });
        }
    }

    public void addGLRptRowSetListener(GLRptRowSetListener listener) {
        this.rowSetListeners.add(listener);
    }

    public void addGLRptIRowDataFilledListener(GLRptIRowDataFilledListener listener) {
        this.rowFilledListeners.add(listener);
    }

    protected void tblMain_SelectChanged(int beginRow) throws Exception {
        this.enableExpandAllItem(beginRow);
    }

    public void setPageContinue(boolean isPageContinue) {
        this.isPageContinue = isPageContinue;
    }

    protected void enableExpandAllItem(int rowIndex) {
        if (this.treeColName == null) {
            if (this.expandAllItem != null) {
                this.expandAllItem.setEnabled(false);
            }
            return;
        }
        if (this.expandAllItem == null) {
            return;
        }
        if (rowIndex < 0) {
            this.expandAllItem.setEnabled(false);
        } else if (this.getCell(rowIndex, this.treeColName).getValue() != null) {
            Object value = this.getCell(rowIndex, this.treeColName).getValue();
            if (value instanceof GLRptTreeNode) {
                GLRptTreeNode node = (GLRptTreeNode)value;
                this.expandAllItem.setEnabled(!node.isExpend() && !node.isLeaf());
            } else {
                this.expandAllItem.setEnabled(false);
            }
        } else {
            this.expandAllItem.setEnabled(false);
        }
    }

    @Override
    public void query(EntityViewInfo mainQuery) {
        this.query(mainQuery, true);
    }

    public void query(EntityViewInfo mainQuery, boolean isReParseTable) {
        this.closeQuery();
        this.firstLoadData = true;
        if (isReParseTable) {
            this.checkParsed();
            this.removeColumns();
        }
        this.isReParseTable = isReParseTable;
        if (mainQuery != null) {
            mainQuery.put("isAsynSumData", (Object)this.isAsynSumData);
        }
        this.mainQuery = mainQuery;
        this.removeRows();
    }

    protected void tblMain_doRequestRowSet(int start) throws EASBizException, BOSException {
        if (start == 0 && this.firstLoadData) {
            this.firstLoadData = false;
            this.rowCount = 0;
            this.setRowCount(this.rowCount);
            if (this.mainQuery == null) {
                return;
            }
            AsynQuery query = new AsynQuery(start);
            if (this.isAsynQuery) {
                new Thread(query).start();
            } else {
                query.run();
            }
        } else {
            GLRptRowSet data = null;
            if (this.isPageContinue && start > this.currRowIndex + 1) {
                int pageRowCount = this.getDataRequestManager().getPageRowCount();
                data = this.getData(this.currRowIndex + 1, start + pageRowCount - (this.currRowIndex + 1));
            } else {
                data = this.getData(start);
            }
            if (data != null) {
                if (this.isPageContinue && data.last()) {
                    this.currRowIndex = data.getRowIndex();
                }
                data.beforeFirst();
                this.afterFillDataToTable(start, start + data.size());
            }
        }
    }

    private void fillTable(GLRptRowSet data, int start) {
        try {
            if (this.isReParseTable || this.getColumnCount() == 0) {
                this.initTableColumn(this.tableHeadInfo);
            }
            this.doGLRowSet(data);
            data.beforeFirst();
            this.setRowCount(this.rowCount);
            this.fillDataToTable(data, start);
            if (this.isAsynSumData) {
                this.fillDataToSumRow();
            }
            if (data != null) {
                if (this.isPageContinue && data.last()) {
                    this.currRowIndex = data.getRowIndex();
                }
                data.beforeFirst();
                this.afterFillDataToTable(start, start + data.size());
            }
            if (this.handler != null) {
                this.handler.handle();
            }
        }
        catch (Exception ex) {
            this.owner.handUIException(ex);
        }
    }

    private GLRptRowSet getData(int start) throws EASBizException, BOSException {
        return this.getData(start, this.getDataRequestManager().getPageRowCount());
    }

    private synchronized GLRptRowSet getData(int start, int rowCount) throws EASBizException, BOSException {
        int length = rowCount;
        int toRowCount = start + rowCount;
        for (int i = start; i < toRowCount && i < this.getRowCount() && this.getRow2(i) != null; ++i) {
            --length;
            ++start;
        }
        if (length <= 0) {
            return null;
        }
        GLRptRowSet data = this.iFacade.getData(this.queryId, start, length);
        this.doGLRowSet(data);
        data.beforeFirst();
        this.fillDataToTable(data, start);
        return data;
    }

    public void fillDataToTable(GLRptRowSet data, int startRowIndex) throws BOSException {
        if (data == null || data.size() == 0) {
            return;
        }
        KDTColumns cols = this.getColumns();
        int rowIndex = startRowIndex;
        DateFormat dateFormat = GlUtils.getDateFormat();
        while (data.next()) {
            IRow row = this.getRow2(rowIndex);
            if (row == null) {
                row = this.setRow(rowIndex);
                int n = cols.size();
                for (int i = 0; i < n; ++i) {
                    String key = cols.getColumnKey(i);
                    if (key.equals("bizDate")) {
                        row.getCell(key).setValue((Object)dateFormat.format(data.getObject(key)));
                        continue;
                    }
                    row.getCell(key).setValue(data.getObject(key));
                }
                this.afterFillTableRow(row, data.getColumKeys());
            }
            ++rowIndex;
        }
    }

    protected void initTableColumn(GLRptTableHeadInfo headInfo) throws EASBizException, BOSException {
        this.removeColumns();
        this.treeColName = null;
        for (int i = 0; i < headInfo.getColumnSize(); ++i) {
            GLRptTableHeadInfo.GLRptTableColumnInfo columnInfo = headInfo.getTableColumnInfo(i);
            IColumn column = this.addColumn();
            column.setKey(columnInfo.getColName());
            column.setWidth(columnInfo.getWidth());
            column.getStyleAttributes().setHided(columnInfo.isHide());
            if (columnInfo.isNumeral()) {
                column.getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(columnInfo.getScale()));
                column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            if (columnInfo.isFreeze()) {
                this.getViewManager().setFreezeView(0, i + 1);
            }
            if (columnInfo.isTreeNode()) {
                if (columnInfo.isExpandNode()) {
                    column.setRenderer((IBasicRender)new GLRptCellTreeRenderer());
                } else {
                    column.setRenderer((IBasicRender)new GLRptCellTreeRenderer(false));
                }
                this.treeColName = columnInfo.getColName();
            }
            column.setMergeable(false);
        }
        this.getHeadMergeManager().setMergeMode(3);
        String[][] titles = headInfo.getHeadTitle();
        for (int i = 0; i < titles.length; ++i) {
            IRow headRow = this.getHeadRow(i);
            if (headRow == null) {
                headRow = this.addHeadRow(i);
            }
            for (int j = 0; j < titles[i].length; ++j) {
                String headName = "";
                if (titles[i][j] == null) continue;
                headName = EASResource.getString((String)this.getResourceName(), (String)titles[i][j]).equals("Missing Resource") ? titles[i][j] : EASResource.getString((String)this.getResourceName(), (String)titles[i][j]);
                headRow.getCell(j).setValue((Object)headName);
            }
        }
        this.initPopMenu();
        this.doLayout();
    }

    private void initPopMenu() {
        if (this.treeColName == null || this.expandAllItem != null) {
            return;
        }
        KDTMenuManager tm = this.owner.getMenuManager(this);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        this.expandAllItem = new JMenuItem();
        String text = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.InitResource", (String)"allExpand");
        this.expandAllItem.setText(this.isF8Enable ? text + "    F8" : text);
        pop.addSeparator();
        pop.add(this.expandAllItem);
        this.expandAllItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                int rowIndex = GLRptTable.this.getSelectManager().getActiveRowIndex();
                if (arg0.getButton() == 1 && rowIndex != -1 && GLRptTable.this.expandAllItem.isEnabled()) {
                    try {
                        GLRptTable.this.expandRow(rowIndex, true);
                    }
                    catch (Exception e1) {
                        GLRptTable.this.owner.handUIException(e1);
                    }
                }
            }
        });
    }

    private void doTableClick(KDTMouseEvent e) throws EASBizException, BOSException {
        IBasicRender renderer;
        if (e.isMetaDown()) {
            return;
        }
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IColumn col = this.getColumn(colIndex);
        ICell cell = this.getCell(rowIndex, colIndex);
        if (col != null && cell != null && (renderer = col.getRenderer()) instanceof GLRptCellTreeRenderer && cell.getValue() instanceof GLRptTreeNode) {
            GLRptTreeNode node = (GLRptTreeNode)cell.getValue();
            if (((GLRptCellTreeRenderer)renderer).isExpandNode && ((GLRptCellTreeRenderer)renderer).inRect(node, e.getX(), e.getY())) {
                this.expandRow(rowIndex, false);
            }
        }
    }

    protected void fillDataToSumRow() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    final GLRptRowSet sumRowSet = GLRptTable.this.iFacade.getSumData(GLRptTable.this.queryId);
                    if (sumRowSet == null) {
                        return;
                    }
                    GLRptTable.this.doGLRowSet(sumRowSet);
                    sumRowSet.beforeFirst();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                GLRptTable.this.fillAsynSumRow(sumRowSet);
                            }
                            catch (Exception e) {
                                GLRptTable.this.owner.handUIException(e);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    logger.error((Object)"getSumData error!", (Throwable)ex);
                }
            }
        };
        new Thread(r).start();
    }

    protected void fillAsynSumRow(GLRptRowSet sumRow) throws BOSException, EASBizException {
        if (sumRow == null || sumRow.size() == 0) {
            return;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Thread sleep error!", (Throwable)e);
        }
        KDTColumns cols = this.getColumns();
        while (sumRow.next()) {
            IRow row;
            int rowIndex = sumRow.getRowIndex();
            if (rowIndex == -1) {
                rowIndex = this.getRowCount() - 1;
            }
            if ((row = this.getRow2(rowIndex)) == null) {
                row = this.setRow(rowIndex);
            }
            int n = cols.size();
            for (int i = 0; i < n; ++i) {
                String key = cols.getColumnKey(i);
                Object value = sumRow.getObject(key);
                if (value == null) continue;
                row.getCell(key).setValue(value);
            }
            this.afterFillTableRow(row, sumRow.getColumKeys());
        }
    }

    protected void expandRow(int rowIndex, boolean isExpandAll) throws BOSException, EASBizException {
        GLRptTreeNode node = (GLRptTreeNode)this.getCell(rowIndex, this.treeColName).getValue();
        int newRowCount = 0;
        if (!node.isLeaf()) {
            newRowCount = node.isExpend() ? this.iFacade.shrinkRow(this.queryId, rowIndex) : (isExpandAll ? this.iFacade.expandAllRow(this.queryId, rowIndex) : this.iFacade.expandRow(this.queryId, rowIndex));
            node.setExpend(!node.isExpend());
            if (this.expandAllItem != null) {
                this.expandAllItem.setEnabled(!node.isExpend());
            }
            this.getDataRequestManager().setDataRequestMode(0);
            for (int i = this.rowCount - 1; i > rowIndex; --i) {
                if (this.getRow2(i) == null) continue;
                this.removeRow(i);
            }
            this.getDataRequestManager().setDataRequestMode(1);
            this.rowCount = newRowCount;
            this.setRowCount(newRowCount);
            this.getDataRequestManager().doDataRequest(rowIndex);
            this.reLayoutAndPaint();
        }
    }

    @Override
    public String getQueryId() {
        return this.queryId;
    }

    public GLRptRowSet getData() throws EASBizException, BOSException {
        int count = 0;
        GLRptRowSet rs = null;
        while (true) {
            GLRptRowSet rowSet = this.iFacade.getData(this.queryId, count, 100);
            if (rs == null) {
                rs = rowSet;
            } else {
                rs.addRowSets(rowSet);
            }
            if (rowSet.size() < 100) break;
            count += 100;
        }
        GLRptRowSet sumRow = this.iFacade.getSumData(this.queryId);
        if (sumRow != null) {
            while (sumRow.next()) {
                int rowIndex = sumRow.getRowIndex();
                String[] colKey = sumRow.getColumKeys();
                for (int i = 0; i < colKey.length; ++i) {
                    rs.updateObject(rowIndex, colKey[i], sumRow.getObject(colKey[i]));
                }
            }
        }
        this.doGLRowSet(rs);
        return rs;
    }

    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.GLXResource";
    }

    protected void afterFillDataToTable(int start, int end) {
        if (this.owner instanceof GLRptAsstActTypeBalanceUI) {
            GLRptTreeNode glRptTreeNode;
            ICell nameCell;
            int treeAsstActNameIndex = 0;
            boolean needMerge = false;
            boolean treeAsstActNumberIsTree = false;
            int rowCount = this.getRowCount();
            IRow firstRow = this.getRow(0);
            if (rowCount != 0 && firstRow != null && (nameCell = firstRow.getCell(this.treeColName)) != null && nameCell.getValue() instanceof GLRptTreeNode && (glRptTreeNode = (GLRptTreeNode)nameCell.getValue()).isMerge()) {
                treeAsstActNameIndex = nameCell.getColumnIndex();
                needMerge = true;
            }
            if (needMerge) {
                Object treeCloumNumberValue;
                List mergeList = null;
                String treeCloumNumber = StringUtils.replace((String)this.treeColName, (String)"Name", (String)"Number");
                ICell numberCell = firstRow.getCell(treeCloumNumber);
                if (numberCell != null && (treeCloumNumberValue = firstRow.getCell(treeCloumNumber).getValue()) != null) {
                    if (treeCloumNumberValue instanceof GLRptTreeNode) {
                        treeAsstActNumberIsTree = true;
                    }
                    mergeList = this.mergeBlock(numberCell.getColumnIndex(), treeAsstActNumberIsTree, null);
                }
                this.mergeBlock(treeAsstActNameIndex, true, mergeList);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    @Override
    public void selectFirst() {
        if (!(this.owner instanceof GLRptSubLedgerUI) && !this.getBody().getRows().isEmpty()) {
            this.getSelectManager().select(0, 0);
        }
    }

    @Override
    public void closeQuery() {
        if (this.queryId != null) {
            try {
                this.iFacade.releaseDataSource(this.queryId);
            }
            catch (BOSException ex) {
                this.owner.handUIException(ex);
            }
        }
    }

    protected void doGLRowSet(GLRptRowSet rs) throws EASBizException, BOSException {
        Iterator it = this.rowSetListeners.iterator();
        while (it.hasNext()) {
            ((GLRptRowSetListener)it.next()).onGetGLRowSet(rs);
        }
    }

    protected void afterFillTableRow(IRow row, String[] colKeys) {
        Iterator it = this.rowFilledListeners.iterator();
        while (it.hasNext()) {
            ((GLRptIRowDataFilledListener)it.next()).afterFilledTableRow(row, colKeys);
        }
    }

    private List mergeBlock(int COL, boolean isTreeNode, List mergeList) {
        GLRptTreeNode treeNode;
        int n = this.getRowCount();
        if (n == 0) {
            return null;
        }
        if (isTreeNode && !(treeNode = (GLRptTreeNode)this.getCell(0, COL).getValue()).isMerge()) {
            return null;
        }
        if (mergeList == null) {
            mergeList = new ArrayList<int[]>();
            int span = 0;
            String lastValue = null;
            String lastCurrencyId = null;
            for (int i = 0; i < n; ++i) {
                String currentValue = null;
                String currentCurrencyId = null;
                if (this.getCell(i, "FCurrencyID") != null) {
                    currentCurrencyId = (String)this.getCell(i, "FCurrencyID").getValue();
                }
                String nextValue = null;
                Object nextValueObj = this.getCell(i, COL + 1).getValue();
                nextValue = nextValueObj instanceof GLRptTreeNode ? ((GLRptTreeNode)nextValueObj).getUserObject().toString() : nextValueObj.toString();
                if (isTreeNode) {
                    GLRptTreeNode treeNode2 = (GLRptTreeNode)this.getCell(i, COL).getValue();
                    currentValue = treeNode2.getUserObject().toString() + nextValue;
                } else {
                    currentValue = (String)this.getCell(i, COL).getValue() + nextValue;
                }
                if (!this.checkRowIsTotal(i).booleanValue() && (StringUtils.isEmpty((String)currentValue) || lastValue != null && lastValue.equals(currentValue)) && StringUtils.equals((String)currentCurrencyId, lastCurrencyId)) {
                    if (++span > 0 && i == n - 1) {
                        mergeList.add(new int[]{i - span, i});
                    }
                } else {
                    if (span > 0) {
                        mergeList.add(new int[]{i - span - 1, i - 1});
                    }
                    span = 0;
                }
                if (!StringUtils.isEmpty((String)currentValue)) {
                    lastValue = currentValue;
                }
                lastCurrencyId = currentCurrencyId;
            }
        }
        if (mergeList.size() > 0) {
            KDTMergeManager mm = this.getMergeManager();
            for (int i = 0; i < mergeList.size(); ++i) {
                int[] region = (int[])mergeList.get(i);
                mm.mergeBlock(region[0], COL, region[1], COL);
            }
        }
        return mergeList;
    }

    private Boolean checkRowIsTotal(int rowIndex) {
        Boolean isTotal = false;
        Object isTotalValue = this.getCell(rowIndex, "isTotal").getValue();
        if (isTotalValue instanceof Integer) {
            if ((Integer)isTotalValue == 1) {
                isTotal = true;
            }
        } else if (isTotalValue instanceof BigDecimal && ((BigDecimal)isTotalValue).compareTo(GlUtils.one) == 0) {
            isTotal = true;
        }
        return isTotal;
    }

    public GLRptTableHeadInfo getTableHeadInfo() {
        return this.tableHeadInfo;
    }

    public boolean isAsynQuery() {
        return this.isAsynQuery;
    }

    public void setAsynQuery(boolean isAsynQuery) {
        this.isAsynQuery = isAsynQuery;
    }

    public boolean isDataTable() {
        return this.isDataTable;
    }

    public void setDataTable(boolean isDataTable) {
        this.isDataTable = isDataTable;
    }

    private final class AsynQuery
    implements Runnable {
        private int start = 0;

        private AsynQuery(int start) {
            this.start = start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GLRptQueryResult rs = null;
            long startTime = System.currentTimeMillis();
            String actionName = GLRptTable.this.owner.getCurrentActionName() + (GLRptTable.this.isDataTable() ? "Data" : "Tree");
            try {
                if (actionName != null) {
                    RecordMonitor.startLog((String)GLRptTable.this.owner.getMetaDataPK().getFullName(), (String)actionName);
                }
                GLRptTable.this.mainQuery.put("PAGE_ROW_COUNT", (Object)new Integer(GLRptTable.this.getDataRequestManager().getPageRowCount()));
                rs = GLRptTable.this.iFacade.query(GLRptTable.this.mainQuery);
            }
            catch (Exception ex) {
                GLRptTable.this.owner.handUIException(ex);
            }
            finally {
                if (actionName != null) {
                    RecordMonitor.endLog((String)GLRptTable.this.owner.getMetaDataPK().getFullName(), (String)actionName, (long)startTime, (long)0L);
                }
            }
            if (rs == null) {
                return;
            }
            final GLRptRowSet data = rs.getData();
            GLRptTable.this.queryId = rs.getQueryId();
            GLRptTable.this.tableHeadInfo = rs.getTableHeadInfo();
            GLRptTable.this.rowCount = rs.getViewRowCount();
            if (GLRptTable.this.isAsynQuery) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GLRptTable.this.fillTable(data, AsynQuery.this.start);
                    }
                });
            } else {
                GLRptTable.this.fillTable(data, this.start);
            }
        }
    }
}

