/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.rpc.recordSlowReq.RecordMonitor;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptDataComponent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GLRptTree
extends KDTreeView
implements GLRptDataComponent {
    private static final long serialVersionUID = 6127228456586633532L;
    private GLRptBaseUI owner;
    private IGLRptBaseFacade iFacade;
    private KDTree tree = new KDTree();
    private KDPopupMenu popMenu;
    private GLRptBaseUI.QueryAfterHandler handler;
    private boolean isAsynQuery;

    public GLRptTree() {
        this.tree.setName("tree");
        this.setName("treeView");
        this.setTree(this.tree);
    }

    @Override
    public void init(GLRptBaseUI owner, IGLRptBaseFacade iFacade, GLRptBaseUI.QueryAfterHandler handler, boolean isAsynQuery, boolean isF8Enable) {
        this.owner = owner;
        this.iFacade = iFacade;
        this.handler = handler;
        this.isAsynQuery = isAsynQuery;
        this.initListener();
    }

    protected void initListener() {
        if (this.popMenu != null) {
            this.tree.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3 && GLRptTree.this.getAccountTreePath().length > 0) {
                        GLRptTree.this.popMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
    }

    private TreePath[] getAccountTreePath() {
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        TreePath[] tps = this.tree.getSelectionPaths();
        if (tps != null) {
            int n = tps.length;
            for (int i = 0; i < n; ++i) {
                Object nodeInfo;
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tps[i].getLastPathComponent();
                if (node == null || (nodeInfo = node.getUserObject()) == null || !(nodeInfo instanceof AccountViewInfo)) continue;
                list.add(tps[i]);
            }
        }
        tps = new TreePath[list.size()];
        list.toArray(tps);
        return tps;
    }

    public void addPopupMenu(String title, ActionListener listener) {
        if (this.popMenu == null) {
            this.popMenu = new KDPopupMenu();
        }
        JMenuItem menuItem = new JMenuItem();
        menuItem.setText(title);
        menuItem.addActionListener(listener);
        this.popMenu.add(menuItem);
    }

    @Override
    public void query(final EntityViewInfo mainQuery) {
        if (mainQuery == null) {
            this.tree.setModel(null);
            return;
        }
        if (this.isAsynQuery) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    GLRptTree.this.runQuery(mainQuery);
                }
            });
            t.start();
        } else {
            this.runQuery(mainQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuery(EntityViewInfo mainQuery) {
        DefaultMutableTreeNode root = null;
        long startTime = System.currentTimeMillis();
        String actionName = this.owner.getCurrentActionName() + "Tree";
        try {
            GLRptQueryResult rs;
            GLRptRowSet data;
            if (actionName != null) {
                RecordMonitor.startLog((String)this.owner.getMetaDataPK().getFullName(), (String)actionName);
            }
            if ((data = (rs = this.iFacade.query(mainQuery)).getData()).next()) {
                root = (DefaultMutableTreeNode)data.getObject("accountTree");
            }
        }
        catch (Exception ex) {
            this.owner.handUIExceptionAndAbort(ex);
        }
        finally {
            if (actionName != null) {
                RecordMonitor.endLog((String)this.owner.getMetaDataPK().getFullName(), (String)actionName, (long)startTime, (long)0L);
            }
        }
        final DefaultMutableTreeNode r = root;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GLRptTree.this.setModel(new DefaultTreeModel(r));
                if (GLRptTree.this.handler != null) {
                    try {
                        GLRptTree.this.handler.handle();
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void closeQuery() {
    }

    @Override
    public String getQueryId() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.tree.getRowCount() == 0;
    }

    @Override
    public void selectFirst() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode firstLeafNode = this.getFirstLeafNode(root);
        this.tree.setSelectionPath(new TreePath(firstLeafNode.getPath()));
    }

    protected DefaultMutableTreeNode getFirstLeafNode(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.isLeaf()) continue;
            return node;
        }
        return null;
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.tree.addTreeSelectionListener(tsl);
    }

    public TreePath[] getSelectionPaths() {
        return this.tree.getSelectionPaths();
    }

    public void setModel(TreeModel model) {
        this.tree.setModel(model);
    }

    public void setSelectionPath(TreePath path) {
        this.tree.setSelectionPath(path);
    }

    public boolean isAsynQuery() {
        return this.isAsynQuery;
    }

    public void setAsynQuery(boolean isAsynQuery) {
        this.isAsynQuery = isAsynQuery;
    }
}

