/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.UserQueryFilter;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseQueryUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptBaseUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLRptUtils {
    private static final Logger logger = Logger.getLogger(GLRptUtils.class);
    public static final Color DAY_TOTAL_COLOR = new Color(15789529);
    public static final Color PERIOD_TOTAL_COLOR = new Color(15262923);
    public static final Color YEAR_TOTAL_COLOR = new Color(15327928);
    public static final Color PERIOD_SUM_COLOR = new Color(15392936);

    public static List getAsstactTypeEntityList(String asstAccountId) throws BOSException, EASBizException {
        ArrayList<AsstactTypeEntity> list = new ArrayList<AsstactTypeEntity>();
        if (StringUtils.isEmpty((String)asstAccountId)) {
            return list;
        }
        Iterator it = GLRptUtils.getAsstActGroupDetailCollection(asstAccountId).iterator();
        while (it.hasNext()) {
            AsstActTypeInfo info = ((AsstActGroupDetailInfo)it.next()).getAsstActType();
            list.add(GLRptUtils.createAsstactTypeEntity(info));
        }
        return list;
    }

    public static List getAsstactTypeEntityListWithSelectItem(String strAssisthgId) throws BOSException, EASBizException {
        AssistantHGInfo hgInfo = GLRptUtils.getHGInfoSimple(strAssisthgId);
        AsstAccountInfo asstactInfo = hgInfo.getAsstAccount();
        List list = GLRptUtils.getAsstactTypeEntityList(asstactInfo.getId().toString());
        hgInfo = GLRptUtils.getHGInfoByID(strAssisthgId);
        if (hgInfo == null) {
            return list;
        }
        for (AsstactTypeEntity at : list) {
            at.setFrom(hgInfo.get(at.getHgAttribute()));
            at.setTo(hgInfo.get(at.getHgAttribute()));
        }
        return list;
    }

    public static AsstactTypeEntity createAsstactTypeEntity(AsstActTypeInfo info) {
        AsstactTypeEntity at = new AsstactTypeEntity();
        at.setId(info.getId().toString());
        at.setNumber(info.getNumber());
        at.setQueryName(info.getDefaultQueryName());
        at.setTableName(info.getRealtionDataObject());
        at.setName(info.getName());
        at.setForCompany(info.isIsForCompany());
        if (info.getGlAsstActTypeGrp() != null) {
            at.setGeneralAsstactGroupId(info.getGlAsstActTypeGrp().getId().toString());
        }
        if (info.getMeasureUnitGroup() != null && info.getMeasureUnitGroup().getId() != null) {
            at.setAsstMeasureUnitGroupId(info.getMeasureUnitGroup().getId().toString());
            if (info.getMeasureUnitGroup().getDefaultUnit() != null && info.getMeasureUnitGroup().getDefaultUnit().getId() != null) {
                at.setAsstMeasureUnitGroupDefaultUnitId(info.getMeasureUnitGroup().getDefaultUnit().getId().toString());
            }
        }
        at.setHgField(info.getMappingFieldName());
        at.setHgAttribute(info.getAsstHGAttribute());
        at.setGroupTable(info.getGroupTableName());
        at.setGroupField(info.getGroupMappingFieldName());
        at.setCollect(CollectEnum.LEAF);
        at.setMultilevel(info.isIsMultilevel());
        at.setEnabledPermissionLimit(true);
        at.setPermissionItem(info.getPermissionItem());
        at.setUseLongNumber(info.isUseLongNumber());
        at.setSelected(true);
        at.setQtyAsst(info.isIsQty());
        if (info.getMeasureUnit() != null) {
            at.setAsstMeasureUnitId(info.getMeasureUnit().getId().toString());
        }
        return at;
    }

    public static CompanyOrgUnitInfo[] getCompanyArray(CompanyOrgUnitInfo[] companys, String accountTableId, String periodTypeId, int periodYear, int periodNumber) {
        if (companys == null || companys.length == 0) {
            return null;
        }
        StringBuffer filterSql = new StringBuffer();
        filterSql.append(" select com.fid from t_org_company com ");
        filterSql.append(" inner join t_bd_acct_contorl ac on ac.fdestcompanyid = com.fid ");
        filterSql.append(" inner join t_bd_accounttable ab on ab.fid = ac.faccounttableid ");
        filterSql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fcompanyid = com.fid");
        filterSql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        filterSql.append(" inner join t_bd_period pe on pe.fid = ssc.fstartperiodid ");
        filterSql.append(" where ac.FIsDefaultForRefer = 0 ");
        if (accountTableId != null) {
            filterSql.append(" and ab.fid = '").append(accountTableId).append("'");
        }
        filterSql.append(" and com.fid in ").append(GLRptUtils.getIdStr(GLRptUtils.getCompanyIdSet(companys)));
        filterSql.append(" and pe.fnumber <= ").append(periodYear * 100 + periodNumber);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (periodTypeId != null) {
            fic.add(new FilterItemInfo("accountPeriodType.id", (Object)periodTypeId));
        }
        fic.add(new FilterItemInfo("id", (Object)filterSql.toString(), CompareType.INNER));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        view.setSelector(sic);
        view.setSorter(sorter);
        CompanyOrgUnitCollection companyCollection = null;
        try {
            companyCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (companyCollection == null) {
            return null;
        }
        CompanyOrgUnitInfo[] checkedCompanys = new CompanyOrgUnitInfo[companyCollection.size()];
        for (int i = 0; i < companyCollection.size(); ++i) {
            checkedCompanys[i] = companyCollection.get(i);
        }
        return checkedCompanys;
    }

    public static CompanyOrgUnitInfo[] getCompanyArray(Set<String> companyIdSet, String accountTableId, String accountNumber) {
        if (companyIdSet.isEmpty() || StringUtils.isEmpty((String)accountNumber)) {
            return null;
        }
        StringBuffer filterSql = new StringBuffer();
        filterSql.append(" select fcompanyid from t_bd_accountview ");
        filterSql.append(" where fnumber = '").append(accountNumber).append("'");
        if (accountTableId != null) {
            filterSql.append(" and faccounttableid = '").append(accountTableId).append("'");
        }
        filterSql.append(" and fcompanyid in ").append(GLRptUtils.getIdStr(companyIdSet));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)filterSql.toString(), CompareType.INNER));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        view.setSelector(sic);
        view.setSorter(sorter);
        CompanyOrgUnitCollection companyCollection = null;
        try {
            companyCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (companyCollection == null) {
            return null;
        }
        CompanyOrgUnitInfo[] checkedCompanys = new CompanyOrgUnitInfo[companyCollection.size()];
        for (int i = 0; i < companyCollection.size(); ++i) {
            checkedCompanys[i] = companyCollection.get(i);
        }
        return checkedCompanys;
    }

    public static String getIdStr(Set idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer ids = new StringBuffer();
        Iterator it = idSet.iterator();
        ids.append("('").append(it.next()).append("'");
        while (it.hasNext()) {
            ids.append(",'").append(it.next()).append("'");
        }
        ids.append(")");
        return ids.toString();
    }

    public static Set getCompanyIdSet(CompanyOrgUnitInfo[] companys) {
        if (companys == null || companys.length == 0) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    public static AsstActGroupDetailCollection getAsstActGroupDetailCollection(String asstAccountId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("asstActType.id"));
        view.getSelector().add(new SelectorItemInfo("asstActType.number"));
        view.getSelector().add(new SelectorItemInfo("asstActType.name"));
        view.getSelector().add(new SelectorItemInfo("asstActType.defaultQueryName"));
        view.getSelector().add(new SelectorItemInfo("asstActType.realtionDataObject"));
        view.getSelector().add(new SelectorItemInfo("asstActType.isForCompany"));
        view.getSelector().add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        view.getSelector().add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.getSelector().add(new SelectorItemInfo("asstActType.mappingFieldName"));
        view.getSelector().add(new SelectorItemInfo("asstActType.groupTableName"));
        view.getSelector().add(new SelectorItemInfo("asstActType.groupMappingFieldName"));
        view.getSelector().add(new SelectorItemInfo("asstActType.isMultilevel"));
        view.getSelector().add(new SelectorItemInfo("asstActType.permissionItem"));
        view.getSelector().add(new SelectorItemInfo("asstActType.useLongNumber"));
        view.getSelector().add(new SelectorItemInfo("asstActType.isMultilevel"));
        view.getSelector().add(new SelectorItemInfo("asstActType.isQty"));
        view.getSelector().add(new SelectorItemInfo("asstActType.measureUnit.id"));
        view.getSelector().add(new SelectorItemInfo("asstActType.measureUnitGroup.id"));
        view.getSelector().add(new SelectorItemInfo("asstActType.measureUnitGroup.defaultUnit.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("seq"));
        AsstActGroupDetailCollection coll = AsstActGroupDetailFactory.getRemoteInstance().getAsstActGroupDetailCollection(view);
        return coll;
    }

    public static AssistantHGInfo getHGInfoSimple(String strAssisthgId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)strAssisthgId)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstAccount.id"));
        IAssistantHG iHg = AssistantHGFactory.getRemoteInstance();
        AssistantHGInfo hgInfo = iHg.getAssistantHGInfo((IObjectPK)new ObjectUuidPK(strAssisthgId), sic);
        return hgInfo;
    }

    public static AssistantHGInfo getHGInfoByID(String strAssisthgId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)strAssisthgId)) {
            return null;
        }
        AssistantHGInfo hgInfo = GLRptUtils.getHGInfoSimple(strAssisthgId);
        AsstAccountInfo asstactInfo = hgInfo.getAsstAccount();
        AsstActGroupDetailCollection asstactGDColl = GLRptUtils.getAsstActGroupDetailCollection(asstactInfo.getId().toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstAccount.id"));
        IAssistantHG iHg = AssistantHGFactory.getRemoteInstance();
        Iterator it = asstactGDColl.iterator();
        while (it.hasNext()) {
            AsstActTypeInfo info = ((AsstActGroupDetailInfo)it.next()).getAsstActType();
            sic.add(new SelectorItemInfo(info.getAsstHGAttribute() + ".id"));
            sic.add(new SelectorItemInfo(info.getAsstHGAttribute() + ".number"));
            sic.add(new SelectorItemInfo(info.getAsstHGAttribute() + ".name"));
            if (!info.isUseLongNumber()) continue;
            sic.add(new SelectorItemInfo(info.getAsstHGAttribute() + ".longNumber"));
        }
        hgInfo = iHg.getAssistantHGInfo((IObjectPK)new ObjectUuidPK(strAssisthgId), sic);
        return hgInfo;
    }

    public static AccountViewInfo getOldAcctTable(CompanyOrgUnitInfo company, int periodYearEnd, int periodNumberEnd, String strAccountId) throws EASBizException, BOSException {
        AccountViewInfo oldAcct = null;
        AccountTableInfo table = company.getAccountTable();
        AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(company.getCU().getId().toString(), table.getId().toString());
        if (ar != null && ar.getEnabledAcctTable() != null && ar.getEnabledPeriod() != null && (ar.getEnabledPeriod().getPeriodYear() > periodYearEnd || ar.getEnabledPeriod().getPeriodYear() == periodYearEnd && ar.getEnabledPeriod().getPeriodNumber() >= periodNumberEnd)) {
            table = ar.getDisabledAcctTable();
            company.setAccountTable(table);
            AccountRefContrastEntryCollection arEntrrColl = AccountRefContrastEntryFactory.getRemoteInstance().getAccountRefContrastEntryCollection("select oldAcct where newAcct.id='" + strAccountId + "'");
            if (arEntrrColl != null && arEntrrColl.size() > 0) {
                AccountRefContrastEntryInfo arEntrr = arEntrrColl.get(0);
                oldAcct = arEntrr.getOldAcct();
            }
        }
        return oldAcct;
    }

    public static void transOldGlConditionToNewCondition(GLRptBaseCondition newCondition, ReportConditionBase glCondition) {
        newCondition.setCompanyDisplayMode(CompanyDisplayModeEnum.enumerate);
        newCondition.setAccountLevelStart(glCondition.getAccountLevelStart());
        newCondition.setAccountLevelEnd(glCondition.getAccountLevelEnd());
        newCondition.setExpandCompanyLevel(glCondition.getExpandCompanyLevel());
        newCondition.setExplandAllChildCom(false);
        newCondition.setCurrencyID(glCondition.getCurrencyID() == null ? "AllCurrency" : glCondition.getCurrencyID());
        newCondition.setCurrencyName(glCondition.getCurrencyName());
        newCondition.setOptionPosting(glCondition.getOptionPosting());
        newCondition.setPeriodYearStart(glCondition.getPeriodYearStart());
        newCondition.setPeriodYearEnd(glCondition.getPeriodYearEnd());
        newCondition.setPeriodNumberStart(glCondition.getPeriodNumberStart());
        newCondition.setPeriodNumberEnd(glCondition.getPeriodNumberEnd());
    }

    public static void transOldConditionToNewCondition(GLRptBaseCondition newCondition, RptParams params) throws EASBizException, BOSException {
        newCondition.setCompanyDisplayMode(CompanyDisplayModeEnum.enumerate);
        newCondition.setExplandAllChildCom(false);
        String currencyID = String.valueOf(params.getObjectElement("jbxCurrency.value.id"));
        SelectorItemCollection selectorCy = new SelectorItemCollection();
        selectorCy.add(new SelectorItemInfo("id"));
        selectorCy.add(new SelectorItemInfo("name"));
        newCondition.setCurrencyID(currencyID);
        newCondition.setCurrencyName(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID), selectorCy).getName());
        boolean isIncludeUnPost = false;
        if (params.getObjectElement("jcbIncludeUnPost.value") != null) {
            isIncludeUnPost = (Boolean)params.getObjectElement("jcbIncludeUnPost.value");
        }
        boolean isNoDisplayZero = false;
        if (params.getObjectElement("jcbNoDisplayZero.value") != null) {
            isNoDisplayZero = (Boolean)params.getObjectElement("jcbNoDisplayZero.value");
        }
        boolean isNoPlayBalanceZero = false;
        if (params.getObjectElement("jcbNoPlayBalanceZero.value") != null) {
            isNoPlayBalanceZero = (Boolean)params.getObjectElement("jcbNoPlayBalanceZero.value");
        }
        newCondition.setOptionAmountZero(isNoDisplayZero);
        newCondition.setOptionAmountAndBalZero(false);
        newCondition.setOptionBalanceZero(isNoPlayBalanceZero);
        newCondition.setOptionPosting(isIncludeUnPost);
        newCondition.setPeriodYearStart((Integer)params.getObjectElement("jspYearFrom.value"));
        newCondition.setPeriodYearEnd((Integer)params.getObjectElement("jspYearTo.value"));
        newCondition.setPeriodNumberStart((Integer)params.getObjectElement("jspPeriodFrom.value"));
        newCondition.setPeriodNumberEnd((Integer)params.getObjectElement("jspPeriodTo.value"));
    }

    public static UIContext getLinkedContext(GLRptBaseCondition cond, Object owner) {
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
        uiContext.put((Object)"UIClassParam", (Object)cond.toMap().toString());
        uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)cond);
        return uiContext;
    }

    public static Set getCUIdSet(Set companyIdSet) {
        if (companyIdSet == null || companyIdSet.size() == 0) {
            return null;
        }
        HashSet<String> cUIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("CU.id"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection companyCollection = null;
        try {
            companyCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        for (int i = 0; i < companyCollection.size(); ++i) {
            cUIdSet.add(companyCollection.get(i).getCU().getId().toString());
        }
        return cUIdSet;
    }

    public static CtrlUnitInfo[] getCUS(CompanyOrgUnitInfo[] companys) {
        if (companys == null || companys.length == 0) {
            return null;
        }
        CtrlUnitInfo[] cus = new CtrlUnitInfo[companys.length];
        for (int i = 0; i < companys.length; ++i) {
            cus[i] = companys[i].getCU();
        }
        return cus;
    }

    private static IIDList getVoucherIDList(KDTable tblMain, String voucherColKey) {
        RealModeIDList idList = new RealModeIDList(){

            public void setCurrentID(String id) {
                if (this.newIdList.contains(id)) {
                    this.setCurrentIndex(this.newIdList.indexOf(id));
                }
            }
        };
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            String voucherId = (String)tblMain.getRow(i).getCell(voucherColKey).getValue();
            if (voucherId == null || idList.contains(voucherId)) continue;
            idList.add(voucherId);
        }
        return idList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryVoucher(GLRptBaseUI ui, KDTable table, String voucherIdColumnKey) {
        String voucherId;
        int rowIndex = table.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return;
        }
        IRow row = table.getRow(rowIndex);
        if (row != null && (voucherId = (String)row.getCell(voucherIdColumnKey).getValue()) != null) {
            try {
                ui.setCursorOfWair();
                UIContext uiContext = new UIContext((Object)ui);
                uiContext.put((Object)"ID", (Object)voucherId);
                uiContext.put((Object)"NOTLICHA", (Object)"NOTLICHA");
                uiContext.put((Object)"FINDVIEW", (Object)Boolean.TRUE);
                if (row.getCell("entrySeq") != null) {
                    uiContext.put((Object)"ENTRYSEQ", row.getCell("entrySeq").getValue());
                }
                if (row.getCell("recordSeq") != null) {
                    uiContext.put((Object)"ASSISTSEQ", row.getCell("recordSeq").getValue());
                }
                IIDList voucherIdList = GLRptUtils.getVoucherIDList(table, voucherIdColumnKey);
                voucherIdList.setCurrentID(voucherId);
                uiContext.put((Object)"IDList", (Object)voucherIdList);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)VoucherEditUI.getEditUIMode((CoreUIObject)ui)).create(VoucherInfo.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (Exception ex) {
                ui.handUIException(ex);
            }
            finally {
                ui.setCursorOfDefault();
            }
        }
    }

    public static List getasstActList(KDTable table, String filedAssGrpId) throws BOSException, EASBizException {
        List asstActList = new ArrayList();
        int selectedRow = table.getSelectManager().getActiveRowIndex();
        if (selectedRow < 0) {
            return null;
        }
        IRow row = table.getRow(selectedRow);
        if (row.getCell(filedAssGrpId) == null) {
            return null;
        }
        String strAssisthgId = (String)row.getCell(filedAssGrpId).getValue();
        if (StringUtils.isEmpty((String)strAssisthgId)) {
            return null;
        }
        asstActList = GLRptUtils.getAsstactTypeEntityListWithSelectItem(strAssisthgId);
        return asstActList;
    }

    public static IProcessor getUserQueryFilter(GLRptBaseQueryUI queryUI) {
        UserQueryFilter userFilter = new UserQueryFilter();
        ArrayList<String> paramList = new ArrayList<String>();
        Map hmParams = new HashMap<String, String>();
        paramList.add("G013");
        try {
            hmParams = GlUtils.getParamsByKeys(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), paramList);
        }
        catch (Exception e) {
            hmParams.put("G013", "false");
        }
        boolean userByCU = Boolean.parseBoolean(hmParams.get("G013").toString());
        userFilter.setUserByCU(userByCU);
        userFilter.setOwner((IUIObject)queryUI);
        return userFilter;
    }

    public static boolean getBoolean(String value) {
        return GLRptUtils.getBoolean(value, true);
    }

    public static boolean getBoolean(String value, boolean def) {
        if (value == null || value.trim().length() == 0) {
            return def;
        }
        value = value.trim();
        return "true".equalsIgnoreCase(value);
    }

    public static int getInt(String value, int min, int max, int def) {
        if (value == null || value.trim().length() == 0) {
            return def;
        }
        int i = Integer.parseInt(value = value.trim());
        if (i >= min && i <= max) {
            return i;
        }
        return def;
    }
}

