/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.framework.TreeBaseInfo;

public class GroupAsstItemSelectorListener
implements SelectorListener {
    private KDCheckBox chkFilterByCat;
    private ICell groupCell;
    private String hgAttribute;
    private EntityViewInfo initEntityView;

    public GroupAsstItemSelectorListener(KDCheckBox chkFilterByCat, ICell groupCell, String hgAttribute) {
        this.chkFilterByCat = chkFilterByCat;
        this.groupCell = groupCell;
        this.hgAttribute = hgAttribute;
    }

    public void willShow(SelectorEvent e) {
        KDBizPromptBox pb = (KDBizPromptBox)e.getSource();
        if (this.initEntityView == null) {
            this.initEntityView = pb.getEntityViewInfo();
        }
        if (this.initEntityView == null) {
            this.initEntityView = new EntityViewInfo();
        }
        if (this.groupCell.getValue() == null || !this.chkFilterByCat.isSelected()) {
            pb.setEntityViewInfo(this.initEntityView);
            pb.getQueryAgent().resetRuntimeEntityView();
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = this.getGroupFilterInfo();
        try {
            filter.mergeFilter(this.initEntityView.getFilter(), "AND");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        view.setFilter(filter);
        pb.setEntityViewInfo(view);
        pb.getQueryAgent().resetRuntimeEntityView();
    }

    private FilterInfo getGroupFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        Object[] groups = (Object[])this.groupCell.getValue();
        if (groups != null) {
            String sql = this.getGroupFilterSQL(groups);
            if ("customer".equalsIgnoreCase(this.hgAttribute)) {
                fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.id", (Object)sql, CompareType.INNER));
            } else if ("provider".equalsIgnoreCase(this.hgAttribute)) {
                fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.id", (Object)sql, CompareType.INNER));
            } else if ("material".equalsIgnoreCase(this.hgAttribute)) {
                fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.id", (Object)sql, CompareType.INNER));
            }
        }
        return filter;
    }

    private String getGroupFilterSQL(Object[] groups) {
        String tableName = "material".equalsIgnoreCase(this.hgAttribute) ? "T_BD_MaterialGroup" : "T_BD_CSSPGroup";
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT gp.fid FROM ").append(tableName).append(" gp ");
        StringBuffer groupIdStr = new StringBuffer();
        for (int i = 0; i < groups.length; ++i) {
            TreeBaseInfo group = (TreeBaseInfo)groups[i];
            if (groupIdStr.length() > 0) {
                groupIdStr.append(",");
            }
            groupIdStr.append("'").append(group.getId().toString()).append("'");
        }
        if (groupIdStr.length() > 0) {
            sql.append(" INNER JOIN ").append(tableName).append(" pgp ON (CHARINDEX(pgp.flongnumber||'!', gp.flongnumber) = 1 ");
            sql.append(" or pgp.fid = gp.fid) ");
            sql.append(" where pgp.fid IN (").append(groupIdStr).append(")");
        }
        return sql.toString();
    }
}

